# xargs

> 다른 명령, 파일 등으로부터 전달된 인수를 사용하여 명령을 실행.
> 입력은 하나의 텍스트 블록으로 처리되며 공백, 탭, 개행 및 파일 끝에서 별개의 조각으로 분리됩니다.
> 같이 보기: `parallel`.
> 더 많은 정보: <https://www.gnu.org/software/findutils/manual/html_mono/find.html#Invoking-xargs>.

- 입력 데이터를 인수로 사용하여 명령 실행:

`{{인수들_소스}} | xargs {{명령어}}`

- 입력 데이터에 대해 여러 연결된 명령 실행:

`{{인수들_소스}} | xargs sh -c "{{명령어1}} && {{명령어2}} | {{명령어3}}"`

- 여러 스레드를 활용하여 `.log` 확장자를 가진 모든 파일을 gzip으로 압축 (`-print0`는 파일 이름을 null 문자로 분리하고, `-0`은 이를 구분자로 사용):

`find . -name '*.log' -print0 | xargs {{[-0|--null]}} {{[-P|--max-procs]}} {{4}} {{[-n|--max-args]}} 1 gzip`

- 각 인수에 대해 한 번씩 명령 실행:

`{{인수들_소스}} | xargs {{[-n|--max-args]}} 1 {{명령어}}`

- 각 입력 줄에 대해 한 번씩 명령 실행, 입력 줄로 플레이스홀더(여기서는 `_`로 표시)를 대체:

`{{인수들_소스}} | xargs -I _ {{명령어}} _ {{선택적_추가_인수들}}`

- 한 번에 `최대-프로세스` 프로세스까지 병렬 실행; 기본값은 1입니다. `최대-프로세스`가 0인 경우, xargs는 가능한 많은 프로세스를 동시에 실행:

`{{인수들_소스}} | xargs {{[-P|--max-procs]}} {{최대-프로세스}} {{명령어}}`
