# 2to3

> Automated Python 2 to 3 code conversion.
> This module has been deprecated since 3.11 and has been removed since 3.13.
> For reference, see: <https://github.com/python/cpython/blob/8d42e2d915c3096e7eac1c649751d1da567bb7c3/Doc/whatsnew/3.13.rst?plain=1#L188>.
> More information: <https://manned.org/2to3>.

- Display the changes that would be performed without performing them (dry-run):

`2to3 {{path/to/file.py}}`

- Convert a Python 2 file to Python 3:

`2to3 {{[-w|--write]}} {{path/to/file.py}}`

- Convert specific Python 2 language features to Python 3:

`2to3 {{[-w|--write]}} {{path/to/file.py}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{print}}`

- Convert all Python 2 language features except the specified ones to Python 3:

`2to3 {{[-w|--write]}} {{path/to/file.py}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- List all available language features that can be converted from Python 2 to Python 3:

`2to3 {{[-l|--list-fixes]}}`

- Convert all Python 2 files in a directory to Python 3:

`2to3 {{[-o|--output-dir]}} {{path/to/python3_directory}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{path/to/python2_directory}}`

- Run 2to3 with multiple threads:

`2to3 {{[-j|--processes]}} {{4}} {{[-o|--output-dir]}} {{path/to/python3_directory}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{path/to/python2_directory}}`
