# truss

> 시스템 콜을 추적하는 문제 해결 도구.
> strace와 동일한 기능을 하는 SunOS 대체품.
> 더 많은 정보: <https://www.unix.com/man-page/linux/1/truss>.

- 프로그램을 실행하여 모든 자식 프로세스를 따라가며 추적 시작:

`truss -f {{프로그램}}`

- PID에 따라 특정 프로세스 추적 시작:

`truss -p {{pid}}`

- 인수 및 환경 변수를 표시하며 프로그램을 실행하여 추적 시작:

`truss -a -e {{프로그램}}`

- 각 시스템 콜마다 시간, 호출 및 오류 수를 계산하고 프로그램 종료 시 요약 보고:

`truss -c -p {{pid}}`

- 시스템 콜 이름으로 출력을 필터링하여 프로세스 추적:

`truss -p {{pid}} -t {{시스템_콜_이름}}`
