# 2to3

> Conversión automatizada de código Python 2 a 3.
> Este módulo ha sido depreciado desde la versión 3.11 y ha sido eliminado desde la 3.13.
> Como referencia, vea: <https://github.com/python/cpython/blob/8d42e2d915c3096e7eac1c649751d1da567bb7c3/Doc/whatsnew/3.13.rst?plain=1#L188>.
> Más información: <https://manned.org/2to3>.

- Muestra los cambios que se realizarían sin realizarlos (dry-run):

`2to3 {{ruta/al/archivo.py.py}}`

- Convierte un archivo Python 2 a Python 3:

`2to3 {{[-w|--write]}} {{ruta/a/archivo.py}}`

- Convierte funciones específicas del lenguaje Python 2 a Python 3:

`2to3 {{[-w|--write]}} {{ruta/a/archivo.py}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{print}}`

- Convierte todas las funciones del lenguaje Python 2 excepto las especificadas a Python 3:

`2to3 {{[-w|--write]}} {{ruta/a/archivo.py}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- Muestra una lista de todas las características disponibles del lenguaje que se pueden convertir de Python 2 a Python 3:

`2to3 {{[-l|--list-fixes]}}`

- Convierte todos los archivos Python 2 en un directorio a Python 3:

`2to3 {{[-o|--output-dir]}} {{ruta/a/directorio_python3}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{ruta/a/directorio_python2}}`

- Ejecuta 2to3 con varios hilos (threads):

`2to3 {{[-j|--processes]}} {{1..infinity}} {{[-o|--output-dir]}} {{ruta/a/directorio_python3}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{ruta/a/directorio_python2}}`
