
# Contributing

Thank you for your interest in contributing to tinymist! There are many ways to contribute and we appreciate all of them.

Before contributing, you can read the [Development Guide](./docs/dev-guide.md) to learn more about the project structure and how to build and run the project.

## Fixing a bug or improving a feature

Generally it's fine to just work on these kinds of things and put a pull-request out for it. If there is an issue accompanying it make sure to link it in the pull request description so it can be closed afterwards or linked for context.

If you want to find something to fix or work on keep a look out for the [`bug`](https://github.com/Myriad-Dreamin/tinymist/issues?q=is%3Aissue+is%3Aopen+label%3Abug) and [`enhancement`](https://github.com/Myriad-Dreamin/tinymist/issues?q=is%3Aissue+is%3Aopen+label%3Aenhancement)
labels. Among issues, the [`good first issue`](https://github.com/Myriad-Dreamin/tinymist/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) label is a good place to start.

## Localization

Tinymist is localized in multiple languages. You can contribute to the localization of Tinymist by translating or correcting the locale files in the [locales](./locales) folder. This is also a good start of contributing to the project.

## Implementing a new feature

It's advised to first open an issue for any kind of new feature so the team can tell upfront whether the feature is desirable or not before any implementation work happens. We want to minimize the possibility of someone putting a lot of work into a feature that is then going to waste as we deem it out of scope (be it due to generally not fitting in with tinymist, or just not having the maintenance capacity). If there already is a feature issue open but it is not clear whether it is considered accepted feel free to just drop a comment and ask!

