---
title: Release notes of the 3.4.1 version of `TFEL`, `MFront` and `MTest`
author: Thomas Helfer
date: 2020
lang: en-EN
numbersections: true
documentclass: article
from: markdown+tex_math_single_backslash
geometry:
  - margin=2cm
papersize: a4
link-citations: true
colorlinks: true
figPrefixTemplate: "$$i$$"
tblPrefixTemplate: "$$i$$"
secPrefixTemplate: "$$i$$"
eqnPrefixTemplate: "($$i$$)"
---

The page describes the new functionalities of Version 3.4.1 of the
`TFEL` project.

# Overview

This version notably adds:

- Initial support for the computation of the speed of sound in `MFront`
  behaviours and support of this feature in the `generic` interface.
  This version breaks the `API` (Application Programming Interface) and
  `ABI` (Application Binary Interface) of the `generic` interface. See
  Section @sec:tfel:3.4.1:generic_interface.
- Support for `Cast3M 21`. See Section @sec:mfront:castem21.
- An interface dedicated to the [`AMITEX_FFTP`
  solver](http://www.maisondelasimulation.fr/projects/amitex/general/_build/html/map-site.html).

# Known incompatibilities

## New reserved names

The following names are now reserved:

- `rho_m0` and `ρₘ₀`
- `v_sound` and  `vₛ`

Those names can no longer be used to define `MFront` variables.

See Section @sec:tfel:3.4.1:speed_sound for details.

## Change in the data structures used by the `generic` interface` {#sec:tfel:3.4.1:generic_interface}

The data structures used by the `generic` interface, namely
`mfront_gb_State`, `mfront_gb_InitialState` and
`mfront_gb_BehaviourData`, has been changed to be able to compute the
speed of sound. This change breaks the `API` and `ABI` of the behaviour
generated by this interface. See also Section
@sec:tfel:3.4.1:api_versioning.

# New features of the `TFEL/Glossary` library

Two new entries have been added in the glossary:

- `StrainMeasure`: glossary name associated with the strain measure.
- `DualStress`: glossary name associated with the dual stress of the
  strain measure.

# New features of `MFront`

## Support for `Cast3M 21` {#sec:mfront:castem21}

While the so-called `umat` interface of this solver is unchanged, two
additional material properties are now required to solve mechanical
problem where thermal exansion are taken into account:

- `TREF`: the reference temperature for the computation of the thermal
  expansion.
- `TALP`: the reference temperature for the thermal expansion
  coefficient.

Those material properties are automatically added by the `castem21`
interface in the list of the material properties required by the
behaviour.

The `castem` interface, and its alias called `umat` for historical
reasons, are left unchanged and shall be used for versions prior to
Version `21`.

## The `amitex` interface

The `amitex` interface is mostly an alias for the `castem` interface,
i.e. the interface for the `Cast3M` interface prior to Version `21` and
also generates an input file template which is meant to be copy-pasted
into the `material.xml` file of the user.

Here is an example of such a template:

~~~~{.xml}
<!--
    Simple template for use in AMITEX_FFTP.
    
    You may copy-paste those lines in your material.xml file
    and adjust:

- the material number I,
- the path to the library (currently UmatBehaviour),
- the coefficients and initial internal variables values
which are currently replaced by three dots.
-->

<Material numM="I" Lib="UmatBehaviour" Law="umatplasticity">
  <!-- material property YoungModulus -->
  <Coeff Index = "1" Type = "Constant" Value = "..." />
  <!-- material property PoissonRatio -->
  <Coeff Index = "2" Type = "Constant" Value = "..." />
  <!-- material property MassDensity -->
  <Coeff Index = "3" Type = "Constant" Value = "..." />
  <!-- material property ThermalExpansion -->
  <Coeff Index = "4" Type = "Constant" Value = "..." />
  <!-- material property H -->
  <Coeff Index = "5" Type = "Constant" Value = "..." />
  <!-- material property s0 -->
  <Coeff Index = "6" Type = "Constant" Value = "..." />
  <!-- internal state variable ElasticStrain -->
  <IntVar Index = "1" Type = "Constant" Value = "..." />
  <IntVar Index = "2" Type = "Constant" Value = "..." />
  <IntVar Index = "3" Type = "Constant" Value = "..." />
  <IntVar Index = "4" Type = "Constant" Value = "..." />
  <IntVar Index = "5" Type = "Constant" Value = "..." />
  <IntVar Index = "6" Type = "Constant" Value = "..." />
  <!-- internal state variable EquivalentPlasticStrain -->
  <IntVar Index = "7" Type = "Constant" Value = "..." />
</Material>
~~~~

## Save the strain measure and the dual stress

The strain measure and the dual stress can now be saved in auxiliary
state variables using the following syntax:

~~~~{.cxx}
@StrainMeasure{
  save_strain: true,
  save_stress: true
};
~~~~

If requested, the strain measure will be saved in an auxiliary state
variable internally called `saved_strain_measure` and whose glossary
name is `StrainMeasure`.

If requested, the dual stress will be saved in an auxiliary state
variable internally called `saved_dual_stress` and whose glossary name
is `DualStress`.

## Computation of the speed of sound {#sec:tfel:3.4.1:speed_sound}

Explicit solvers often require the behaviour to compute an upper bound
of the speed of sound in the material to compute a critical time step.

The new code `@SpeedOfSound` to perform this computation.

Inside this code block, the mass density in the initial configuration is
available in a variable called `rho_m0` (one may use the `ρₘ₀` alias if
`UTF-8` encoding is used).

The code block must set the variable `v_sound` (one may use the `vₛ`
alias if `UTF-8` encoding is used)

### API versioning of the generic interface {#sec:tfel:3.4.1:api_versioning}

To avoid any conflict between versions of `TFEL` and client projects
(mostly the [`MGIS`
project](https://github.com/thelfer/MFrontGenericInterfaceSupport), we
have introduce the notion of `API` versioning.

By conventions, previous versions are said to use Version 0 of the API
of the `generic interface. This new version thus introduces Version 1 of
the API. The `API` version is now exported as a new symbol which can be
retrieved by client projects. Those projects thus can check at runtime
which `API` is used by the behaviours they may use.

In practice, users of the [`MGIS`
project](https://github.com/thelfer/MFrontGenericInterfaceSupport) shall
upgrade their `MGIS`' versions.

# Issues fixed

## Ticket #263: `GenericBehaviourInterface`: `rotateArrayOfTangentOperatorBlocks` is not correctly implemented

For more details, see: <https://sourceforge.net/p/tfel/tickets/263/>

## Ticket #262: Missing headers in packages generated by `automake`

For more details, see: <https://sourceforge.net/p/tfel/tickets/262/>

## Ticket #258: Missing `ndarray.cxx` source

For more details, see: <https://sourceforge.net/p/tfel/tickets/258/>

## Ticket #240: Ability to export the thermal expansion coefficients as material properties with the ‘cyrano’ interface

When the thermal expansion is handled by a behaviour, the thermal
expansion coefficients are now automatically exported as material
properties when compiling the behaviour behaviour with the `Cast3M` and
`Cyrano` interfaces.

The names of the functions associated with those thermal expansion
coefficients can be retrieved by:

- the `getUMATLinearThermalExpansionCoefficientsEntryPoints` method of
  the `ExternalLibraryManager` class.
- the `linear_thermal_expansion_coefficients_epts` data member of the
  `ExternalBehaviourData` class.

For more details, see: <https://sourceforge.net/p/tfel/tickets/240/>

## Tickets #236: Save stress and/or strain measures as state variables

For more details, see: <https://sourceforge.net/p/tfel/tickets/236/>
