% Copyright (c) Jupyter Development Team.

% Distributed under the terms of the Modified BSD License.

(code-console)=

# Code Consoles

Code consoles enable you to run code interactively in a kernel. The cells
of a code console show the order in which code was executed in the
kernel, as opposed to the explicit ordering of cells in a notebook
document. Code consoles also display rich output, just like notebook
cells.

(create-console)=

Create a new code console by clicking the `+` button in the {ref}`file
browser <left-sidebar>` and selecting the kernel:

```{raw} html
<div class="jp-youtube-video">
   <iframe src="https://www.youtube-nocookie.com/embed/7Sb_a6veU1s?rel=0&amp;showinfo=0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</div>
```

(run-code)=

Run code using `Shift Enter`. Use the up and down arrows to browse the
history of previously-run code:

```{raw} html
<div class="jp-youtube-video">
   <iframe src="https://www.youtube-nocookie.com/embed/L52yh9FPAtY?rel=0&amp;showinfo=0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</div>
```

(tab-completion)=

Tab completion (`Tab`) and tooltips (`Shift Tab`) work as in the
notebook:

```{raw} html
<div class="jp-youtube-video">
   <iframe src="https://www.youtube-nocookie.com/embed/WoqFgmSuigE?rel=0&amp;showinfo=0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</div>
```

(clear-cell)=

Clear the cells of the code console without restarting the kernel by
right-clicking on the code console and selecting “Clear Console Cells”:

```{raw} html
<div class="jp-youtube-video">
   <iframe src="https://www.youtube-nocookie.com/embed/Aj7sQgP39z8?rel=0&amp;showinfo=0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</div>
```

(log-inspect)=

Creating a code console from the {ref}`file menu <menu-bar>` lets you select an existing
kernel for the code console. The code console then acts as a log of
computations in that kernel, and a place you can interactively inspect
and run code in the kernel:

```{raw} html
<div class="jp-youtube-video">
   <iframe src="https://www.youtube-nocookie.com/embed/QyRuPrLrIOs?rel=0&amp;showinfo=0" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</div>
```
