import os
from pathlib import Path

from fastapi.testclient import TestClient

from docs_src.background_tasks.tutorial001_py310 import app
from tests.utils import workdir_lock

client = TestClient(app)


@workdir_lock
def test():
    log = Path("log.txt")
    if log.is_file():
        os.remove(log)  # pragma: no cover
    response = client.post("/send-notification/foo@example.com")
    assert response.status_code == 200, response.text
    assert response.json() == {"message": "Notification sent in the background"}
    with open("./log.txt") as f:
        assert "notification for foo@example.com: some notification" in f.read()
