# Моделі параметрів запиту { #query-parameter-models }

Якщо у Вас є група **параметрів запиту**, які пов’язані між собою, Ви можете створити **Pydantic-модель** для їх оголошення.

Це дозволить Вам **повторно використовувати модель** у **різних місцях**, а також оголошувати перевірки та метадані для всіх параметрів одночасно. 😎

/// note | Примітка

Ця можливість підтримується, починаючи з версії FastAPI `0.115.0`. 🤓

///

## Параметри запиту з Pydantic-моделлю { #query-parameters-with-a-pydantic-model }

Оголосіть **параметри запиту**, які Вам потрібні, у **Pydantic-моделі**, а потім оголосіть цей параметр як `Query`:

{* ../../docs_src/query_param_models/tutorial001_an_py310.py hl[9:13,17] *}

**FastAPI**  буде **витягувати** дані для **кожного поля** з **параметрів запиту** у запиті та передавати їх у визначену вами Pydantic-модель.

## Перевірте документацію { #check-the-docs }

Ви можете побачити параметри запиту в UI документації за `/docs`:

<div class="screenshot">
<img src="/img/tutorial/query-param-models/image01.png">
</div>

## Заборона зайвих параметрів запиту { #forbid-extra-query-parameters }

У деяких особливих випадках (ймовірно, не дуже поширених) Ви можете захотіти **обмежити** параметри запиту, які дозволено отримувати.

Ви можете використати конфігурацію моделі Pydantic, щоб заборонити (`forbid`) будь-які зайві (`extra`) поля:

{* ../../docs_src/query_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати **зайві** дані у **параметрах запиту**, він отримає **відповідь з помилкою**.

Наприклад, якщо клієнт спробує надіслати параметр запиту `tool` зі значенням `plumbus`, як у цьому запиті:

```http
https://example.com/items/?limit=10&tool=plumbus
```

Він отримає відповідь з **помилкою**, яка повідомить, що параметр запиту `tool` не дозволено:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["query", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus"
        }
    ]
}
```

## Підсумок { #summary }

Ви можете використовувати **Pydantic-моделі** для оголошення **параметрів запиту** у **FastAPI**. 😎

/// tip | Порада

Спойлер: Ви також можете використовувати Pydantic-моделі для оголошення кукі та заголовків, але про це Ви дізнаєтеся пізніше в цьому посібнику. 🤫

///
