# Безпека

Існує багато способів реалізувати безпеку, автентифікацію та авторизацію.

Це зазвичай складна і "непроста" тема.

У багатьох фреймворках і системах забезпечення безпеки та автентифікації займає величезну частину зусиль і коду (іноді — понад 50% всього написаного коду).

**FastAPI** надає кілька інструментів, які допоможуть Вам впоратися з **безпекою** легко, швидко, стандартним способом, без необхідності вивчати всі специфікації безпеки.

Але спочатку — кілька коротких понять.

## Поспішаєте?

Якщо Вам не цікаві всі ці терміни й просто потрібно *швидко* додати автентифікацію за логіном і паролем — переходьте до наступних розділів.

## OAuth2

OAuth2 — це специфікація, що описує кілька способів обробки автентифікації та авторизації.

Це досить об'ємна специфікація, яка охоплює складні випадки використання.

Вона включає способи автентифікації через "третю сторону".

Саме це лежить в основі "входу через Google, Facebook, X (Twitter), GitHub" тощо.

### OAuth 1

Раніше існував OAuth 1, який значно відрізняється від OAuth2 і є складнішим, оскільки містив специфікації для шифрування комунікацій.

Зараз майже не використовується.

OAuth2 не вказує, як саме шифрувати з'єднання — воно очікує, що ваш застосунок працює через HTTPS.

/// tip | Порада

У розділі про **деплой** Ви побачите, як налаштувати HTTPS безкоштовно з Traefik та Let's Encrypt.

///

## OpenID Connect

OpenID Connect — ще одна специфікація, побудована на основі **OAuth2**.

Вона розширює OAuth2, уточнюючи деякі неоднозначності для досягнення кращої сумісності.

Наприклад, вхід через Google використовує OpenID Connect (який базується на OAuth2).

Але вхід через Facebook — ні. Він має власну реалізацію на базі OAuth2.

### OpenID (не "OpenID Connect")

Існувала також специфікація "OpenID", яка намагалася розвʼязати ті самі задачі, що й **OpenID Connect**, але не базувалась на OAuth2.

Це була зовсім інша система, і сьогодні вона майже не використовується.

## OpenAPI

OpenAPI (раніше Swagger) — це специфікація для побудови API (тепер під егідою Linux Foundation).

**FastAPI** базується на **OpenAPI**.

Завдяки цьому Ви отримуєте автоматичну інтерактивну документацію, генерацію коду та багато іншого.

OpenAPI дозволяє описувати різні "схеми" безпеки.

Використовуючи їх, Ви можете скористатися всіма цими інструментами, що базуються на стандартах, зокрема інтерактивними системами документації.

OpenAPI визначає такі схеми безпеки:

* `apiKey`: специфічний для застосунку ключ, який може передаватися через:
    * Параметр запиту.
    * Заголовок.
    * Cookie.
* `http`: стандартні методи HTTP-автентифікації, включаючи:
    * `bearer`: заголовок `Authorization` зі значенням `Bearer` та токеном. Це успадковано з OAuth2.
    * HTTP Basic автентифікація
    * HTTP Digest, тощо.
* `oauth2`: усі способи обробки безпеки за допомогою OAuth2 (так звані «потоки»).
    * Деякі з цих потоків підходять для створення власного провайдера автентифікації OAuth 2.0 (наприклад, Google, Facebook, X (Twitter), GitHub тощо):
        * `implicit`— неявний
        * `clientCredentials`— облікові дані клієнта
        * `authorizationCode` — код авторизації
    * Але є один окремий «потік», який ідеально підходить для реалізації автентифікації всередині одного додатку:
        * `password`: у наступних розділах буде приклад використання цього потоку.
* `openIdConnect`: дозволяє автоматично виявляти параметри автентифікації OAuth2.
    * Це автоматичне виявлення визначається у специфікації OpenID Connect.


/// tip | Порада

Інтеграція інших провайдерів автентифікації/авторизації, таких як Google, Facebook, X (Twitter), GitHub тощо — також можлива і відносно проста.

Найскладніше — це створити власного провайдера автентифікації/авторизації, як Google чи Facebook. Але **FastAPI** надає Вам інструменти, щоб зробити це легко, беручи на себе важку частину роботи.

///

## Інструменти **FastAPI**

FastAPI надає кілька інструментів для кожної з описаних схем безпеки в модулі `fastapi.security`, які спрощують використання цих механізмів захисту.

У наступних розділах Ви побачите, як додати безпеку до свого API за допомогою цих інструментів **FastAPI**.

А також побачите, як вона автоматично інтегрується в інтерактивну документацію вашого API.
