; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -mcpu=kaveri -mtriple=amdgcn--amdhsa < %s | FileCheck -enable-var-scope -check-prefixes=CIVI,CI %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mcpu=tonga -mtriple=amdgcn--amdhsa  < %s | FileCheck -enable-var-scope -check-prefixes=CIVI,GFX8 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mcpu=gfx900 -mtriple=amdgcn--amdhsa < %s | FileCheck -enable-var-scope -check-prefixes=GFX9 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mcpu=gfx1100 -mattr=+real-true16 -mtriple=amdgcn--amdhsa < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mcpu=gfx1100 -mattr=-real-true16 -mtriple=amdgcn--amdhsa < %s | FileCheck -enable-var-scope -check-prefixes=GFX11,GFX11-FAKE16 %s

define amdgpu_kernel void @s_fneg_bf16(ptr addrspace(1) %out, bfloat %in) #0 {
; CI-LABEL: s_fneg_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_mul_f32_e64 v0, -1.0, s2
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fneg_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fneg_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: s_fneg_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, s2
; GFX11-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: s_fneg_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %fneg = fsub bfloat -0.0, %in
  store bfloat %fneg, ptr addrspace(1) %out
  ret void
}

; FIXME: Should be able to use bit operations when illegal type as
; well.
define amdgpu_kernel void @v_fneg_bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fneg_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_ushort v2, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e32 v2, -1.0, v2
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_fneg_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ushort v2, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fneg_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: v_fneg_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    global_load_d16_b16 v0, v1, s[0:1]
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v0.l
; GFX11-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: v_fneg_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    global_load_u16 v1, v0, s[0:1]
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds bfloat, ptr addrspace(1) %in, i32 %tid
  %gep.out = getelementptr inbounds bfloat, ptr addrspace(1) %in, i32 %tid
  %val = load bfloat, ptr addrspace(1) %gep.in, align 2
  %fneg = fsub bfloat -0.0, %val
  store bfloat %fneg, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @s_fneg_free_bf16(ptr addrspace(1) %out, i16 %in) #0 {
; CI-LABEL: s_fneg_free_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_mul_f32_e64 v0, -1.0, s2
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fneg_free_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fneg_free_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_short v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: s_fneg_free_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-TRUE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v1, 0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, s2
; GFX11-TRUE16-NEXT:    global_store_b16 v1, v0, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: s_fneg_free_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-FAKE16-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_xor_b32 s2, s2, 0x8000
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-FAKE16-NEXT:    global_store_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %bc = bitcast i16 %in to bfloat
  %fsub = fsub bfloat -0.0, %bc
  store bfloat %fsub, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fneg_fold_bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fneg_fold_bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    flat_load_ushort v2, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e32 v3, -1.0, v2
; CI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; CI-NEXT:    v_mul_f32_e32 v2, v3, v2
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; CI-NEXT:    flat_store_short v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_fneg_fold_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x8000
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_ushort v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_xor_b32_sdwa v3, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_mul_f32_e32 v2, v3, v2
; GFX8-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; GFX8-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    flat_store_short v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fneg_fold_bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_ushort v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0x8000
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_xor_b32_sdwa v2, v1, s2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_mul_f32_e32 v1, v2, v1
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    global_store_short_d16_hi v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-TRUE16-LABEL: v_fneg_fold_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-TRUE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-TRUE16-NEXT:    global_load_d16_b16 v1, v0, s[2:3]
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_mul_f32_e32 v1, v2, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, v2, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc_lo
; GFX11-TRUE16-NEXT:    global_store_d16_hi_b16 v0, v1, s[0:1]
; GFX11-TRUE16-NEXT:    s_endpgm
;
; GFX11-FAKE16-LABEL: v_fneg_fold_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-FAKE16-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-FAKE16-NEXT:    global_load_u16 v1, v0, s[2:3]
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x8000, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-FAKE16-NEXT:    v_mul_f32_e32 v1, v2, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, v2, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc_lo
; GFX11-FAKE16-NEXT:    global_store_d16_hi_b16 v0, v1, s[0:1]
; GFX11-FAKE16-NEXT:    s_endpgm
  %val = load bfloat, ptr addrspace(1) %in
  %fsub = fsub bfloat -0.0, %val
  %fmul = fmul bfloat %fsub, %val
  store bfloat %fmul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fneg_v2bf16(ptr addrspace(1) %out, <2 x bfloat> %in) #0 {
; CI-LABEL: s_fneg_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s3, s2, 0xffff0000
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_mul_f32_e64 v0, -1.0, s3
; CI-NEXT:    v_mul_f32_e64 v1, -1.0, s2
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    v_alignbit_b32 v2, v0, v1, 16
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fneg_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fneg_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fneg_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %fneg = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %in
  store <2 x bfloat> %fneg, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_fneg_v2bf16_nonload(ptr addrspace(1) %out) #0 {
; CI-LABEL: s_fneg_v2bf16_nonload:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; def s2
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_and_b32 s3, s2, 0xffff0000
; CI-NEXT:    v_mul_f32_e64 v0, -1.0, s3
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    v_mul_f32_e64 v1, -1.0, s2
; CI-NEXT:    v_alignbit_b32 v2, v0, v1, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: s_fneg_v2bf16_nonload:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    ;;#ASMSTART
; GFX8-NEXT:    ; def s2
; GFX8-NEXT:    ;;#ASMEND
; GFX8-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: s_fneg_v2bf16_nonload:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s2
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: s_fneg_v2bf16_nonload:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; def s2
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %in = call i32 asm sideeffect "; def $0", "=s"()
  %in.bc = bitcast i32 %in to <2 x bfloat>
  %fneg = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %in.bc
  store <2 x bfloat> %fneg, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fneg_v2bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fneg_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v2, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e32 v3, -1.0, v3
; CI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_mul_f32_e32 v2, -1.0, v2
; CI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_fneg_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fneg_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x8
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_fneg_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %gep.out = getelementptr inbounds <2 x bfloat>, ptr addrspace(1) %in, i32 %tid
  %val = load <2 x bfloat>, ptr addrspace(1) %gep.in, align 2
  %fneg = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %val
  store <2 x bfloat> %fneg, ptr addrspace(1) %gep.out
  ret void
}

define amdgpu_kernel void @fneg_free_v2bf16(ptr addrspace(1) %out, i32 %in) #0 {
; CI-LABEL: fneg_free_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[8:9], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s3, s2, 0xffff0000
; CI-NEXT:    s_lshl_b32 s2, s2, 16
; CI-NEXT:    v_mul_f32_e64 v0, -1.0, s3
; CI-NEXT:    v_mul_f32_e64 v1, -1.0, s2
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    v_alignbit_b32 v2, v0, v1, 16
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: fneg_free_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: fneg_free_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: fneg_free_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_xor_b32 s2, s2, 0x80008000
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %bc = bitcast i32 %in to <2 x bfloat>
  %fsub = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %bc
  store <2 x bfloat> %fsub, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_fneg_fold_v2bf16(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; CI-LABEL: v_fneg_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    flat_load_dword v2, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    v_mul_f32_e32 v4, -1.0, v3
; CI-NEXT:    v_mul_f32_e32 v5, -1.0, v2
; CI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; CI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; CI-NEXT:    v_mul_f32_e32 v3, v4, v3
; CI-NEXT:    v_mul_f32_e32 v2, v5, v2
; CI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; CI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_fneg_fold_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x8000
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    flat_load_dword v2, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_xor_b32_sdwa v5, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX8-NEXT:    v_xor_b32_sdwa v2, v2, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_mul_f32_e32 v3, v5, v4
; GFX8-NEXT:    v_mul_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX8-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v3
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_alignbit_b32 v2, v2, v3, 16
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_fneg_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0x8000
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX9-NEXT:    v_xor_b32_sdwa v4, v1, s2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX9-NEXT:    v_xor_b32_sdwa v1, v1, s2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_mul_f32_e32 v3, v4, v3
; GFX9-NEXT:    v_mul_f32_e32 v1, v1, v5
; GFX9-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX9-NEXT:    v_bfe_u32 v6, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v3
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX9-NEXT:    v_add_u32_e32 v6, v6, v1
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_or_b32_e32 v7, 0x400000, v1
; GFX9-NEXT:    v_add_u32_e32 v6, 0x7fff, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v4, v5, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v6, v7, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_fneg_fold_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x8000, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mul_f32 v3, v3, v4 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-NEXT:    v_mul_f32_e32 v1, v2, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v2, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v5, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v4, v6, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshl_or_b32 v1, v1, 16, v2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
  %val = load <2 x bfloat>, ptr addrspace(1) %in
  %fsub = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %val
  %fmul = fmul <2 x bfloat> %fsub, %val
  store <2 x bfloat> %fmul, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_extract_fneg_fold_v2bf16(ptr addrspace(1) %in) #0 {
; CI-LABEL: v_extract_fneg_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; CI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; CI-NEXT:    v_mul_f32_e32 v1, -4.0, v1
; CI-NEXT:    v_sub_f32_e32 v0, 2.0, v0
; CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    flat_store_short v[0:1], v1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_short v[0:1], v0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_extract_fneg_fold_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX8-NEXT:    v_mul_f32_e32 v1, -4.0, v1
; GFX8-NEXT:    v_sub_f32_e32 v0, 2.0, v0
; GFX8-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX8-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v0
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fff, v4
; GFX8-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX8-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    flat_store_short v[0:1], v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_short v[0:1], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_extract_fneg_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_mul_f32_e32 v1, -4.0, v1
; GFX9-NEXT:    v_sub_f32_e32 v0, 2.0, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_bfe_u32 v4, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_add_u32_e32 v4, v4, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX9-NEXT:    v_add_u32_e32 v4, 0x7fff, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extract_fneg_fold_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 16, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_dual_mul_f32 v1, -4.0, v1 :: v_dual_and_b32 v0, 0xffff0000, v0
; GFX11-NEXT:    v_sub_f32_e32 v0, 2.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX11-NEXT:    v_bfe_u32 v3, v0, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_or_b32_e32 v5, 0x400000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v5, vcc_lo
; GFX11-NEXT:    global_store_d16_hi_b16 v[0:1], v1, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_d16_hi_b16 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
  %val = load <2 x bfloat>, ptr addrspace(1) %in
  %fneg = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %val
  %elt0 = extractelement <2 x bfloat> %fneg, i32 0
  %elt1 = extractelement <2 x bfloat> %fneg, i32 1

  %fmul0 = fmul bfloat %elt0, 4.0
  %fadd1 = fadd bfloat %elt1, 2.0
  store volatile bfloat %fmul0, ptr addrspace(1) poison
  store volatile bfloat %fadd1, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @v_extract_fneg_no_fold_v2bf16(ptr addrspace(1) %in) #0 {
; CI-LABEL: v_extract_fneg_no_fold_v2bf16:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; CI-NEXT:    s_add_i32 s12, s12, s17
; CI-NEXT:    s_mov_b32 flat_scratch_lo, s13
; CI-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    flat_load_dword v0, v[0:1]
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; CI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; CI-NEXT:    v_mul_f32_e32 v1, -1.0, v1
; CI-NEXT:    v_mul_f32_e32 v0, -1.0, v0
; CI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; CI-NEXT:    flat_store_short v[0:1], v0
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_short v[0:1], v1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    s_endpgm
;
; GFX8-LABEL: v_extract_fneg_no_fold_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    s_add_i32 s12, s12, s17
; GFX8-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX8-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    flat_store_short v[0:1], v0
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    flat_store_short v[0:1], v1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX9-LABEL: v_extract_fneg_no_fold_v2bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v0, v0, s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX9-NEXT:    global_store_short v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_short_d16_hi v[0:1], v0, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: v_extract_fneg_no_fold_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v0, v0, s[0:1]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_store_d16_hi_b16 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
  %val = load <2 x bfloat>, ptr addrspace(1) %in
  %fneg = fsub <2 x bfloat> <bfloat -0.0, bfloat -0.0>, %val
  %elt0 = extractelement <2 x bfloat> %fneg, i32 0
  %elt1 = extractelement <2 x bfloat> %fneg, i32 1
  store volatile bfloat %elt0, ptr addrspace(1) poison
  store volatile bfloat %elt1, ptr addrspace(1) poison
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CIVI: {{.*}}
