; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-linux -mattr=+neon,+fp8fma < %s | FileCheck %s

define <8 x half> @test_fmlalb(<8 x half> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlalb:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalb v0.8h, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <8 x half> @llvm.aarch64.neon.fp8.fmlalb.v8f16(<8 x half> %d, <16 x i8> %a, <16 x i8> %b)
  ret <8 x half> %r
}

define <8 x half> @test_fmlalt(<8 x half> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlalt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalt v0.8h, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <8 x half> @llvm.aarch64.neon.fp8.fmlalt.v8f16(<8 x half> %d, <16 x i8> %a, <16 x i8> %b)
  ret <8 x half> %r
}

define <4 x float> @test_fmlallbb(<4 x float> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlallbb:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlallbb v0.4s, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <4 x float> @llvm.aarch64.neon.fp8.fmlallbb.v4f32(<4 x float> %d, <16 x i8> %a, <16 x i8> %b)
  ret <4 x float> %r
}

define <4 x float> @test_fmlallbt(<4 x float> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlallbt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlallbt v0.4s, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <4 x float> @llvm.aarch64.neon.fp8.fmlallbt.v4f32(<4 x float> %d, <16 x i8> %a, <16 x i8> %b)
  ret <4 x float> %r
}

define <4 x float> @test_fmlalltb(<4 x float> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlalltb:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalltb v0.4s, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <4 x float> @llvm.aarch64.neon.fp8.fmlalltb.v4f32(<4 x float> %d, <16 x i8> %a, <16 x i8> %b)
  ret <4 x float> %r
}

define <4 x float> @test_fmlalltt(<4 x float> %d, <16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_fmlalltt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalltt v0.4s, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %r = call <4 x float> @llvm.aarch64.neon.fp8.fmlalltt.v4f32(<4 x float> %d, <16 x i8> %a, <16 x i8> %b)
  ret <4 x float> %r
}

define <8 x half> @test_fmlalb_lane(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlalb_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalb v0.8h, v1.16b, v2.b[0]
; CHECK-NEXT:    ret
  %res = tail call <8 x half> @llvm.aarch64.neon.fp8.fmlalb.lane(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 0)
  ret <8 x half> %res
}

define <8 x half> @test_fmlalt_lane(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlalt_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalt v0.8h, v1.16b, v2.b[4]
; CHECK-NEXT:    ret
  %res = tail call <8 x half> @llvm.aarch64.neon.fp8.fmlalt.lane(<8 x half> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 4)
  ret <8 x half> %res
}

define <4 x float> @test_fmlallbb_lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlallbb_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlallbb v0.4s, v1.16b, v2.b[7]
; CHECK-NEXT:    ret
  %res = tail call <4 x float> @llvm.aarch64.neon.fp8.fmlallbb.lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 7)
  ret <4 x float> %res
}

define <4 x float> @test_fmlallbt_lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlallbt_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlallbt v0.4s, v1.16b, v2.b[10]
; CHECK-NEXT:    ret
  %res = tail call <4 x float> @llvm.aarch64.neon.fp8.fmlallbt.lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 10)
  ret <4 x float> %res
}

define <4 x float> @test_fmlalltb_lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlalltb_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalltb v0.4s, v1.16b, v2.b[13]
; CHECK-NEXT:    ret
  %res = tail call <4 x float> @llvm.aarch64.neon.fp8.fmlalltb.lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 13)
  ret <4 x float> %res
}

define <4 x float> @test_fmlalltt_lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm) {
; CHECK-LABEL: test_fmlalltt_lane:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmlalltt v0.4s, v1.16b, v2.b[15]
; CHECK-NEXT:    ret
  %res = tail call <4 x float> @llvm.aarch64.neon.fp8.fmlalltt.lane(<4 x float> %vd, <16 x i8> %vn, <16 x i8> %vm, i32 15)
  ret <4 x float> %res
}
