; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -mattr=+fp -disable-block-placement -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

define float @brcc_oeq(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    oeq.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI0_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI0_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp oeq float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ogt(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ule.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI1_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI1_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ogt float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_oge(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_oge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ult.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI2_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB2_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI2_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp oge float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_olt(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    olt.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI3_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB3_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI3_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp olt float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ole(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ole:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ole.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB4_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI4_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI4_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ole float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_one(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ueq.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI5_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB5_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI5_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp one float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ord(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    un.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB6_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI6_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB6_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI6_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ord float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ueq(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ueq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ueq.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB7_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI7_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB7_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI7_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ueq float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ugt(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ole.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB8_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI8_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB8_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI8_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ugt float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_uge(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    olt.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB9_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI9_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB9_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI9_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp uge float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ult(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ult.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB10_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI10_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB10_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI10_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ult float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_ule(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    ule.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB11_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI11_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB11_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI11_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp ule float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_une(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    oeq.s b0, f9, f8
; CHECK-NEXT:    bt b0, .LBB12_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI12_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB12_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI12_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp une float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @brcc_uno(float %a, float %b) nounwind {
; CHECK-LABEL: brcc_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    wfr f8, a3
; CHECK-NEXT:    wfr f9, a2
; CHECK-NEXT:    un.s b0, f9, f8
; CHECK-NEXT:    bf b0, .LBB13_2
; CHECK-NEXT:  # %bb.1: # %t1
; CHECK-NEXT:    l32r a8, .LCPI13_1
; CHECK-NEXT:    wfr f8, a8
; CHECK-NEXT:    add.s f8, f9, f8
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB13_2: # %t2
; CHECK-NEXT:    l32r a8, .LCPI13_0
; CHECK-NEXT:    wfr f9, a8
; CHECK-NEXT:    add.s f8, f8, f9
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
  %wb = fcmp uno float %a, %b
  br i1 %wb, label %t1, label %t2
t1:
  %t1v = fadd float %a, 4.0
  br label %exit
t2:
  %t2v = fadd float %b, 8.0
  br label %exit
exit:
  %v = phi float [ %t1v, %t1 ], [ %t2v, %t2 ]
  ret float %v
}

define float @copysign_f32(float %a, float %b) {
; CHECK-LABEL: copysign_f32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  # %bb.0: # %entry
; CHECK-NEXT:    l32r a8, .LCPI14_0
; CHECK-NEXT:    and a8, a3, a8
; CHECK-NEXT:    l32r a9, .LCPI14_1
; CHECK-NEXT:    and a9, a2, a9
; CHECK-NEXT:    wfr f8, a9
; CHECK-NEXT:    movi a9, 0
; CHECK-NEXT:    beq a8, a9, .LBB14_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    neg.s f8, f8
; CHECK-NEXT:  .LBB14_2: # %entry
; CHECK-NEXT:    rfr a2, f8
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.copysign.f32(float %a, float %b)
  ret float %c
}
