; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64-unknown | FileCheck %s
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64-unknown -mattr=slow-misaligned-128store | FileCheck %s --check-prefix=SLOW_MISALIGNED_128_STORE

target datalayout = "e-p:32:32:32-i1:8:32-i8:8:32-i16:16:32-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:32:64-v128:32:128-v256:32:256-a0:0:32-n32-S32"

; If FeatureSlowMisaligned128Store is set, we penalize 128-bit stores.
; The unlegalized 256-bit stores are further penalized when legalized down
; to 128-bit stores.

define void @getMemoryOpCost() {
; CHECK-LABEL: 'getMemoryOpCost'
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <4 x i64> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <8 x i32> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <16 x i16> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <32 x i8> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <4 x double> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <8 x float> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:1 SizeLat:2 for: store <16 x half> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <2 x i64> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <4 x i32> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <8 x i16> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <16 x i8> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <2 x double> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <4 x float> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of 1 for: store <8 x half> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: store <2 x i8> undef, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: store <4 x i8> undef, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:1 for: %1 = load <2 x i8>, ptr undef, align 2
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %2 = load <4 x i8>, ptr undef, align 4
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; SLOW_MISALIGNED_128_STORE-LABEL: 'getMemoryOpCost'
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <4 x i64> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <8 x i32> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <16 x i16> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <32 x i8> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <4 x double> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <8 x float> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:2 Lat:1 SizeLat:2 for: store <16 x half> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <2 x i64> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <4 x i32> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <8 x i16> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <16 x i8> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <2 x double> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <4 x float> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: store <8 x half> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: store <2 x i8> undef, ptr undef, align 2
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: store <4 x i8> undef, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:4 SizeLat:1 for: %1 = load <2 x i8>, ptr undef, align 2
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:4 SizeLat:1 for: %2 = load <4 x i8>, ptr undef, align 4
; SLOW_MISALIGNED_128_STORE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  store <4 x i64> undef, ptr undef
  store <8 x i32> undef, ptr undef
  store <16 x i16> undef, ptr undef
  store <32 x i8> undef, ptr undef

  store <4 x double> undef, ptr undef
  store <8 x float> undef, ptr undef
  store <16 x half> undef, ptr undef

  store <2 x i64> undef, ptr undef
  store <4 x i32> undef, ptr undef
  store <8 x i16> undef, ptr undef
  store <16 x i8> undef, ptr undef

  store <2 x double> undef, ptr undef
  store <4 x float> undef, ptr undef
  store <8 x half> undef, ptr undef

  ; We scalarize the loads/stores because there is no vector register name for
  ; these types (they get extended to v.4h/v.2s).
  store <2 x i8> undef, ptr undef
  store <4 x i8> undef, ptr undef
  load <2 x i8> , ptr undef
  load <4 x i8> , ptr undef

  ret void
}
