# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x390 -instruction-tables=full -iterations=1 < %s | FileCheck %s

# The legal (SEW, LMUL) pairs are:
# (e8, mf8) (e8, mf4) (e8, mf2) (e8, m1) (e8, m2) (e8, m4) (e8, m8)
# (e16, mf4) (e16, mf2) (e16, m1) (e16, m2) (e16, m4) (e16, m8)
# (e32, mf2) (e32, m1) (e32, m2) (e32, m4) (e32, m8)
# (e64, m1) (e64, m2) (e64, m4) (e64, m8)
# Widening instructions do not have e64
# Narrowing instructions do not have e8

# Vector Single-Width Integer Add and Subtract
vsetvli zero, zero, e8, mf8, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e16, mf4, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e16, mf2, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e16, m1, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e16, m2, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e32, mf2, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e32, m1, tu, mu
vadd.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vadd.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vadd.vi v4, v8, 0
vsetvli zero, zero, e32, m8, tu, mu
vsub.vv v4, v8, v12
vsetvli zero, zero, e64, m1, tu, mu
vsub.vx v4, v8, x10
vsetvli zero, zero, e64, m2, tu, mu
vrsub.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vrsub.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vadd.vv v4, v8, v12

# Vector Widening Integer Add/Subtract
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwaddu.vv  v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vwaddu.vx  v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vwsubu.vv  v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vwsubu.vx  v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vwadd.vv  v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vwadd.vx  v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vwsub.vv  v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vwsub.vx  v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vwaddu.wv  v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vwaddu.wx  v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vwsubu.wv  v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vwsubu.wx  v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vwadd.wv  v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vwadd.wx  v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vwsub.wv  v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vwsub.wx  v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vwaddu.vv  v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vwaddu.vx  v4, v8, x10

# Vector Integer Extension
# no e8
vsetvli zero, zero, e16, mf4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, mf2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e16, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vsetvli zero, zero, e32, mf2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e32, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vsetvli zero, zero, e64, m1, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m2, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m4, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8
vsetvli zero, zero, e64, m8, tu, mu
vzext.vf2 v4, v8
vsext.vf2 v4, v8
vzext.vf4 v4, v8
vsext.vf4 v4, v8
vzext.vf8 v4, v8
vsext.vf8 v4, v8

# Vector Integer Add-with-Carry / Subtract-with-Borrow Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e8, mf4, tu, mu
vadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e8, mf2, tu, mu
vadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e8, m1, tu, mu
vmadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e8, m2, tu, mu
vmadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e8, m4, tu, mu
vmadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e8, m8, tu, mu
vmadc.vv    v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmadc.vx    v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmadc.vi    v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vsbc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e16, m2, tu, mu
vsbc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e16, m4, tu, mu
vmsbc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e16, m8, tu, mu
vmsbc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e32, mf2, tu, mu
vmsbc.vv    v4, v8, v12
vsetvli zero, zero, e32, m1, tu, mu
vmsbc.vx    v4, v8, x10
vsetvli zero, zero, e32, m2, tu, mu
vadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e32, m4, tu, mu
vadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e32, m8, tu, mu
vadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e64, m1, tu, mu
vmadc.vvm   v4, v8, v12, v0
vsetvli zero, zero, e64, m2, tu, mu
vmadc.vxm   v4, v8, x10, v0
vsetvli zero, zero, e64, m4, tu, mu
vmadc.vim   v4, v8, 0, v0
vsetvli zero, zero, e64, m8, tu, mu
vmadc.vv    v4, v8, v12

# Vector Bitwise Logical Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vor.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vor.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vor.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vxor.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vxor.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vxor.vi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vor.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vor.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vor.vi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vxor.vv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vxor.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vxor.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vand.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vand.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vand.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vor.vv v4, v8, v12

# Vector Single-Width Shift Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vsrl.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vsrl.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vsrl.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vsra.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vsra.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vsra.vi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vsrl.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vsrl.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vsrl.vi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vsra.vv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vsra.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vsra.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vsll.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vsll.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vsll.vi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vsrl.vv v4, v8, v12

# Vector Narrowing Integer Right Shift Instructions
# no e8
vsetvli zero, zero, e8, mf8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e16, m1, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e16, m2, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e16, m4, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e16, m8, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e32, m2, tu, mu
vnsra.wv v4, v8, v12
vsetvli zero, zero, e32, m4, tu, mu
vnsra.wx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vnsra.wi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vnsrl.wv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vnsrl.wx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vnsrl.wi v4, v8, 0
vsetvli zero, zero, e64, m8, tu, mu
vnsra.wv v4, v8, v12

# Vector Integer Compare Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmseq.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmseq.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmseq.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vmsne.vv v4, v8, v12
vsetvli zero, zero, e8, m2, tu, mu
vmsne.vx v4, v8, x10
vsetvli zero, zero, e8, m4, tu, mu
vmsne.vi v4, v8, 0
vsetvli zero, zero, e8, m8, tu, mu
vmsltu.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmsltu.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmslt.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vmslt.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmsleu.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmsleu.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmsleu.vi v4, v8, 0
vsetvli zero, zero, e32, mf2, tu, mu
vmsle.vv v4, v8, v12
vsetvli zero, zero, e32, m1, tu, mu
vmsle.vx v4, v8, x10
vsetvli zero, zero, e32, m2, tu, mu
vmsle.vi v4, v8, 0
vsetvli zero, zero, e32, m4, tu, mu
vmsgtu.vx v4, v8, x10
vsetvli zero, zero, e32, m8, tu, mu
vmsgtu.vi v4, v8, 0
vsetvli zero, zero, e64, m1, tu, mu
vmsgt.vx v4, v8, x10
vsetvli zero, zero, e64, m2, tu, mu
vmsgt.vi v4, v8, 0
vsetvli zero, zero, e64, m4, tu, mu
vmseq.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmseq.vx v4, v8, x10

# Pseudo instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmslt.vi v4, v8, 1
vsetvli zero, zero, e8, mf4, tu, mu
vmsltu.vi v4, v8, 1
vsetvli zero, zero, e8, mf2, tu, mu
vmsltu.vi v4, v8, 0
vsetvli zero, zero, e8, m1, tu, mu
vmsgeu.vi v4, v8, 1
vsetvli zero, zero, e8, m2, tu, mu
vmsge.vi v4, v8, 1
vsetvli zero, zero, e8, m4, tu, mu
vmsgeu.vi v4, v8, 0
vsetvli zero, zero, e16, mf4, tu, mu
vmsge.vi v4, v8, 0
vsetvli zero, zero, e16, mf2, tu, mu
vmsge.vx v4, v8, x10
vsetvli zero, zero, e16, m1, tu, mu
vmsgeu.vx v4, v8, x11

# Vector Integer Min/Max Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vmaxu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vmax.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmax.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmaxu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vmax.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vmax.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vminu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vminu.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vmin.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vmin.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vmaxu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmaxu.vx v4, v8, x10

# Vector Single-Width Integer Multiply Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vmulhu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vmulhsu.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmulhsu.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmulhu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vmulhsu.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vmulhsu.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vmul.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vmul.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vmulh.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vmulh.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vmulhu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vmulhu.vx v4, v8, x10

# Vector Integer Divide Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vremu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vrem.vv v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vrem.vx v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vremu.vx v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vrem.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vrem.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vdivu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vdivu.vx v4, v8, x10
vsetvli zero, zero, e64, m1, tu, mu
vdiv.vv v4, v8, v12
vsetvli zero, zero, e64, m2, tu, mu
vdiv.vx v4, v8, x10
vsetvli zero, zero, e64, m4, tu, mu
vremu.vv v4, v8, v12
vsetvli zero, zero, e64, m8, tu, mu
vremu.vx v4, v8, x10

# Vector Widening Integer Multiply Instructions
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e8, mf4, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e8, mf2, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e8, m1, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e8, m2, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e8, m4, tu, mu
vwmulsu.vx v4, v8, x10
vsetvli zero, zero, e8, m8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e16, mf4, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e16, mf2, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e16, m1, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e16, m2, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e16, m4, tu, mu
vwmulsu.vx v4, v8, x10
vsetvli zero, zero, e16, m8, tu, mu
vwmul.vv  v4, v8, v12
vsetvli zero, zero, e32, mf2, tu, mu
vwmul.vx  v4, v8, x10
vsetvli zero, zero, e32, m1, tu, mu
vwmulu.vv v4, v8, v12
vsetvli zero, zero, e32, m2, tu, mu
vwmulu.vx v4, v8, x10
vsetvli zero, zero, e32, m4, tu, mu
vwmulsu.vv v4, v8, v12
vsetvli zero, zero, e32, m8, tu, mu
vwmulsu.vx v4, v8, x10

# Vector Single-Width Integer Multiply-Add Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e8, mf4, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e8, mf2, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e8, m1, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e8, m2, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e8, m4, tu, mu
vmadd.vx v4, x10, v8
vsetvli zero, zero, e8, m8, tu, mu
vnmsub.vv v4, v12, v8
vsetvli zero, zero, e16, mf4, tu, mu
vnmsub.vx v4, x10, v8
vsetvli zero, zero, e16, mf2, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e16, m1, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e16, m2, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e16, m4, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e16, m8, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e32, mf2, tu, mu
vmadd.vx v4, x10, v8
vsetvli zero, zero, e32, m1, tu, mu
vnmsub.vv v4, v12, v8
vsetvli zero, zero, e32, m2, tu, mu
vnmsub.vx v4, x10, v8
vsetvli zero, zero, e32, m4, tu, mu
vmacc.vv v4, v12, v8
vsetvli zero, zero, e32, m8, tu, mu
vmacc.vx v4, x10, v8
vsetvli zero, zero, e64, m1, tu, mu
vnmsac.vv v4, v12, v8
vsetvli zero, zero, e64, m2, tu, mu
vnmsac.vx v4, x10, v8
vsetvli zero, zero, e64, m4, tu, mu
vmadd.vv v4, v12, v8
vsetvli zero, zero, e64, m8, tu, mu
vmadd.vx v4, x10, v8

# Vector Widening Integer Multiply-Add Instructions
# no e64
vsetvli zero, zero, e8, mf8, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e8, mf4, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e8, mf2, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e8, m1, tu, mu
vwmacc.vx v4, x10, v8
vsetvli zero, zero, e8, m2, tu, mu
vwmaccsu.vv v4, v12, v8
vsetvli zero, zero, e8, m4, tu, mu
vwmaccsu.vx v4, x10, v8
vsetvli zero, zero, e8, m8, tu, mu
vwmaccus.vx v4, x10, v8
vsetvli zero, zero, e16, mf4, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e16, mf2, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e16, m1, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e16, m2, tu, mu
vwmacc.vx v4, x10, v8
vsetvli zero, zero, e16, m4, tu, mu
vwmaccsu.vv v4, v12, v8
vsetvli zero, zero, e16, m8, tu, mu
vwmaccsu.vx v4, x10, v8
vsetvli zero, zero, e32, mf2, tu, mu
vwmaccus.vx v4, x10, v8
vsetvli zero, zero, e32, m1, tu, mu
vwmaccu.vv v4, v12, v8
vsetvli zero, zero, e32, m2, tu, mu
vwmaccu.vx v4, x10, v8
vsetvli zero, zero, e32, m4, tu, mu
vwmacc.vv v4, v12, v8
vsetvli zero, zero, e32, m8, tu, mu
vwmacc.vx v4, x10, v8

# Vector Integer Merge Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e8, mf4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e8, mf2, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e8, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e8, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e8, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e8, m8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e16, mf4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e16, mf2, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e16, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e16, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e16, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e16, m8, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e32, mf2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e32, m1, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e32, m2, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e32, m4, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e32, m8, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e64, m1, tu, mu
vmerge.vvm v4, v8, v12, v0
vsetvli zero, zero, e64, m2, tu, mu
vmerge.vxm v4, v8, x10, v0
vsetvli zero, zero, e64, m4, tu, mu
vmerge.vim v4, v8, 0, v0
vsetvli zero, zero, e64, m8, tu, mu
vmerge.vvm v4, v8, v12, v0

# Vector Integer Move Instructions
vsetvli zero, zero, e8, mf8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e8, mf4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e8, mf2, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e8, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e8, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e8, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e8, m8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e16, mf4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e16, mf2, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e16, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e16, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e16, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e16, m8, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e32, mf2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e32, m1, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e32, m2, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e32, m4, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e32, m8, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e64, m1, tu, mu
vmv.v.v v4, v12
vsetvli zero, zero, e64, m2, tu, mu
vmv.v.x v4, x10
vsetvli zero, zero, e64, m4, tu, mu
vmv.v.i v4, 0
vsetvli zero, zero, e64, m8, tu, mu
vmv.v.v v4, v12

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv:1
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv:1
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA:1
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeAB:2 VLEN1024X300SiFive7PipeA, VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7PipeB:1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA1:1
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VA1OrVA2:2 VLEN1024X300SiFive7VA1, VLEN1024X300SiFive7VA2
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VA2:1
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VCQ:1
# CHECK-NEXT: [9]   - VLEN1024X300SiFive7VL:1
# CHECK-NEXT: [10]  - VLEN1024X300SiFive7VS:1

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADD_VV       vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADD_VX       vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADD_VI       vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSUB_VV       vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSUB_VX       vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VRSUB_VX      vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VRSUB_VI     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADD_VV       vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADD_VX       vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VADD_VI       vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSUB_VV       vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSUB_VX       vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VRSUB_VX     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VRSUB_VI      vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VADD_VV       vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VADD_VX       vadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VADD_VI       vadd.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSUB_VV      vsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSUB_VX       vsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VRSUB_VX      vrsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VRSUB_VI      vrsub.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VADD_VV      vadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWADDU_VV     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWADDU_VX     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWSUBU_VV     vwsubu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWSUBU_VX     vwsubu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWADD_VV      vwadd.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWADD_VX      vwadd.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWSUB_VV      vwsub.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWSUB_VX      vwsub.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWADDU_WV     vwaddu.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWADDU_WX     vwaddu.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWSUBU_WV     vwsubu.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWSUBU_WX     vwsubu.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWADD_WV      vwadd.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWADD_WX      vwadd.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWSUB_WV      vwsub.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWSUB_WX      vwsub.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWADDU_VV     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWADDU_VX     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VZEXT_VF8 vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSEXT_VF8 vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VZEXT_VF8 vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSEXT_VF8 vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VZEXT_VF8 vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSEXT_VF8 vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF2 vzext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF2 vsext.vf2	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF4 vzext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF4 vsext.vf4	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VZEXT_VF8 vzext.vf8	v4, v8
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSEXT_VF8 vsext.vf8	v4, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADC_VVM vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADC_VXM vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VADC_VIM vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMADC_VVM vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMADC_VXM vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMADC_VIM vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMADC_VV vmadc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMADC_VX vmadc.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMADC_VI vmadc.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSBC_VVM vsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSBC_VXM vsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSBC_VVM vmsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMSBC_VXM vmsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSBC_VV vmsbc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSBC_VX vmsbc.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VADC_VVM vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VADC_VXM vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VADC_VIM vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMADC_VVM vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMADC_VXM vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMADC_VIM vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMADC_VV vmadc.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VAND_VV       vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VAND_VX       vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VAND_VI       vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VOR_VV        vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VOR_VX        vor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VOR_VI        vor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VXOR_VV      vxor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VXOR_VX       vxor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VXOR_VI       vxor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VAND_VV       vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VAND_VX       vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VAND_VI       vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VOR_VV       vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VOR_VX        vor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VOR_VI        vor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VXOR_VV       vxor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VXOR_VX       vxor.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VXOR_VI      vxor.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VAND_VV       vand.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VAND_VX       vand.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VAND_VI       vand.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VOR_VV       vor.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSLL_VV       vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSLL_VX       vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSLL_VI       vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSRL_VV       vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSRL_VX       vsrl.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSRL_VI       vsrl.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSRA_VV      vsra.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSRA_VX       vsra.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSRA_VI       vsra.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSLL_VV       vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSLL_VX       vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSLL_VI       vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSRL_VV      vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VSRL_VX       vsrl.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSRL_VI       vsrl.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSRA_VV       vsra.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSRA_VX       vsra.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSRA_VI      vsra.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VSLL_VV       vsll.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VSLL_VX       vsll.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VSLL_VI       vsll.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VSRL_VV      vsrl.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VNSRL_WV      vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VNSRL_WX      vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNSRL_WI      vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNSRA_WV      vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VNSRA_WX      vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRA_WI     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRL_WV     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VNSRL_WX      vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNSRL_WI      vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNSRA_WV      vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VNSRA_WX      vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRA_WI     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRL_WV     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNSRL_WX      vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNSRL_WI      vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VNSRA_WV      vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRA_WX     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRA_WI     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNSRL_WV      vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VNSRL_WX      vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRL_WI     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNSRA_WV     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSEQ_VV vmseq.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSEQ_VX vmseq.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSEQ_VI vmseq.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSNE_VV vmsne.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                         7     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMSNE_VX vmsne.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                         11    VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSNE_VI vmsne.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                        19    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMSLTU_VV vmsltu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLTU_VX vmsltu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLT_VV vmslt.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSLT_VX vmslt.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                         7     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMSLEU_VV vmsleu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                         11    VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSLEU_VX vmsleu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                        19    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMSLEU_VI vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLE_VV vmsle.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSLE_VX vmsle.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                         7     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMSLE_VI vmsle.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                         11    VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSGTU_VX vmsgtu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                        19    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMSGTU_VI vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSGT_VX vmsgt.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                         7     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMSGT_VI vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                         11    VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSEQ_VV vmseq.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      19    16.00                        19    VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMSEQ_VX vmseq.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLE_VI vmsle.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLEU_VI vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSNE_VV vmsne.vv	v4, v8, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSGTU_VI vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      7     4.00                         7     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMSGT_VI vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      11    8.00                         11    VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMSEQ_VV vmseq.vv	v4, v8, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSGT_VI vmsgt.vi	v4, v8, -1
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMSLT_VX vmslt.vx	v4, v8, a0
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMNAND_MM vmnot.m	v4, v4
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      5     2.00                         5     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMSLTU_VX vmsltu.vx	v4, v8, a1
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMNAND_MM vmnot.m	v4, v4
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMINU_VV vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMINU_VX vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMIN_VV vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMIN_VX vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMAXU_VV vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMAXU_VX vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMAX_VV vmax.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMAX_VX vmax.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMINU_VV vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMINU_VX vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMIN_VV vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMIN_VX vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMAXU_VV vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMAXU_VX vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMAX_VV vmax.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMAX_VX vmax.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMINU_VV vminu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMINU_VX vminu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMIN_VV vmin.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMIN_VX vmin.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMAXU_VV vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMAXU_VX vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMUL_VV       vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMUL_VX       vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMULH_VV      vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMULH_VX      vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMULHU_VV     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMULHU_VX     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMULHSU_VV   vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMULHSU_VX    vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMUL_VV       vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMUL_VX       vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMULH_VV      vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMULH_VX      vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMULHU_VV    vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMULHU_VX     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMULHSU_VV    vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMULHSU_VX    vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMUL_VV       vmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMUL_VX      vmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMULH_VV      vmulh.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMULH_VX      vmulh.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMULHU_VV     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMULHU_VX    vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VDIVU_VV vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VDIVU_VX vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VDIV_VV vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VDIV_VX vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VREMU_VV vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VREMU_VX vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      3840  3840.00                      3840  VLEN1024X300SiFive7VA1[1,3841],VLEN1024X300SiFive7VA1OrVA2[1,3841],VLEN1024X300SiFive7VCQ VREM_VV vrem.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      60    60.00                        60    VLEN1024X300SiFive7VA1[1,61],VLEN1024X300SiFive7VA1OrVA2[1,61],VLEN1024X300SiFive7VCQ VREM_VX vrem.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      120   120.00                       120   VLEN1024X300SiFive7VA1[1,121],VLEN1024X300SiFive7VA1OrVA2[1,121],VLEN1024X300SiFive7VCQ VDIVU_VV vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      240   240.00                       240   VLEN1024X300SiFive7VA1[1,241],VLEN1024X300SiFive7VA1OrVA2[1,241],VLEN1024X300SiFive7VCQ VDIVU_VX vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      480   480.00                       480   VLEN1024X300SiFive7VA1[1,481],VLEN1024X300SiFive7VA1OrVA2[1,481],VLEN1024X300SiFive7VCQ VDIV_VV vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      960   960.00                       960   VLEN1024X300SiFive7VA1[1,961],VLEN1024X300SiFive7VA1OrVA2[1,961],VLEN1024X300SiFive7VCQ VDIV_VX vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      1920  1920.00                      1920  VLEN1024X300SiFive7VA1[1,1921],VLEN1024X300SiFive7VA1OrVA2[1,1921],VLEN1024X300SiFive7VCQ VREMU_VV vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      112   112.00                       112   VLEN1024X300SiFive7VA1[1,113],VLEN1024X300SiFive7VA1OrVA2[1,113],VLEN1024X300SiFive7VCQ VREMU_VX vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      224   224.00                       224   VLEN1024X300SiFive7VA1[1,225],VLEN1024X300SiFive7VA1OrVA2[1,225],VLEN1024X300SiFive7VCQ VREM_VV vrem.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      448   448.00                       448   VLEN1024X300SiFive7VA1[1,449],VLEN1024X300SiFive7VA1OrVA2[1,449],VLEN1024X300SiFive7VCQ VREM_VX vrem.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      896   896.00                       896   VLEN1024X300SiFive7VA1[1,897],VLEN1024X300SiFive7VA1OrVA2[1,897],VLEN1024X300SiFive7VCQ VDIVU_VV vdivu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      1792  1792.00                      1792  VLEN1024X300SiFive7VA1[1,1793],VLEN1024X300SiFive7VA1OrVA2[1,1793],VLEN1024X300SiFive7VCQ VDIVU_VX vdivu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      228   228.00                       228   VLEN1024X300SiFive7VA1[1,229],VLEN1024X300SiFive7VA1OrVA2[1,229],VLEN1024X300SiFive7VCQ VDIV_VV vdiv.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      456   456.00                       456   VLEN1024X300SiFive7VA1[1,457],VLEN1024X300SiFive7VA1OrVA2[1,457],VLEN1024X300SiFive7VCQ VDIV_VX vdiv.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      912   912.00                       912   VLEN1024X300SiFive7VA1[1,913],VLEN1024X300SiFive7VA1OrVA2[1,913],VLEN1024X300SiFive7VCQ VREMU_VV vremu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      1824  1824.00                      1824  VLEN1024X300SiFive7VA1[1,1825],VLEN1024X300SiFive7VA1OrVA2[1,1825],VLEN1024X300SiFive7VCQ VREMU_VX vremu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMUL_VV      vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMUL_VX      vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMULU_VV     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMULU_VX     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMULSU_VV    vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMULSU_VX    vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMUL_VV      vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMUL_VX      vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMULU_VV     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMULU_VX     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMULSU_VV    vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMULSU_VX    vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMUL_VV      vwmul.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMUL_VX      vwmul.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMULU_VV     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMULU_VX     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMULSU_VV    vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMULSU_VX    vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMACC_VV      vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMACC_VX      vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VNMSAC_VV     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNMSAC_VX     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMADD_VV      vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMADD_VX      vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VNMSUB_VV    vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VNMSUB_VX     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMACC_VV      vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMACC_VX      vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNMSAC_VV     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VNMSAC_VX     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMADD_VV     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMADD_VX      vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNMSUB_VV     vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNMSUB_VX     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMACC_VV      vmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMACC_VX     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VNMSAC_VV     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VNMSAC_VX     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMADD_VV      vmadd.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      8     8.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMADD_VX     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACCU_VV    vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACCU_VX    vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACC_VV     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMACC_VX     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMACCSU_VV   vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACCSU_VX   vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACCUS_VX   vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACCU_VV    vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACCU_VX    vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMACC_VV     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMACC_VX     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACCSU_VV   vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACCSU_VX   vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VWMACCUS_VX   vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      8     1.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VWMACCU_VV    vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      8     2.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VWMACCU_VX    vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACC_VV     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      8     4.00                         8     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VWMACC_VX     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1[1,2],VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1[1,3],VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1[1,5],VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMERGE_VXM vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1[1,9],VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMERGE_VIM vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     16.00                        4     VLEN1024X300SiFive7VA1[1,17],VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMERGE_VVM vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_V       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMV_V_V       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMV_V_V      vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMV_V_V       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMV_V_V      vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,2],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMV_V_V       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMV_V_I      vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      4     1.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,3],VLEN1024X300SiFive7VCQ VMV_V_V       vmv.v.v	v4, v12
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      4     2.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,5],VLEN1024X300SiFive7VCQ VMV_V_X       vmv.v.x	v4, a0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      4     4.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,9],VLEN1024X300SiFive7VCQ VMV_V_I       vmv.v.i	v4, 0
# CHECK-NEXT:  1      3     1.00                  U      1     VLEN1024X300SiFive7PipeA,VLEN1024X300SiFive7PipeAB VSETVLI            vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      4     8.00                         4     VLEN1024X300SiFive7VA1OrVA2[1,17],VLEN1024X300SiFive7VCQ VMV_V_V      vmv.v.v	v4, v12

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN1024X300SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN1024X300SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN1024X300SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN1024X300SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN1024X300SiFive7VA1
# CHECK-NEXT: [5]   - VLEN1024X300SiFive7VA2
# CHECK-NEXT: [6]   - VLEN1024X300SiFive7VCQ
# CHECK-NEXT: [7]   - VLEN1024X300SiFive7VL
# CHECK-NEXT: [8]   - VLEN1024X300SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT:  -      -     342.00  -     20046.50 682.50 385.00  -    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vadd.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vrsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vrsub.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwsubu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwsubu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwadd.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwadd.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwsub.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwsub.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwaddu.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwaddu.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwsubu.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwsubu.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwadd.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwadd.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwsub.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwsub.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwaddu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwaddu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf2	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf4	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vzext.vf8	v4, v8
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vsext.vf8	v4, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmadc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmadc.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmadc.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmsbc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmsbc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsbc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsbc.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmadc.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmadc.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmadc.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmadc.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vxor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vxor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vxor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vxor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vxor.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vxor.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vand.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vand.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vand.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vor.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsrl.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vsrl.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vsra.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsra.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsra.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vsrl.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsrl.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsra.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vsra.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vsra.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vsll.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vsll.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vsll.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vsrl.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsra.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsra.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnsrl.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vnsrl.wx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsrl.wi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnsra.wv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmseq.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmseq.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmseq.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsne.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmsne.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmsne.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmsltu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsltu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmslt.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmslt.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmsleu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmsleu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsle.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsle.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmsle.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmsgtu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsgt.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmseq.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmseq.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsle.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsleu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsne.vv	v4, v8, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsgtu.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmsgt.vi	v4, v8, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmseq.vv	v4, v8, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmsgt.vi	v4, v8, -1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmslt.vx	v4, v8, a0
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmnot.m	v4, v4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmsltu.vx	v4, v8, a1
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmnot.m	v4, v4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmax.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmax.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmax.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmax.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vminu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vminu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmin.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmin.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmaxu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmaxu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmulhsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmulhsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmulh.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmulh.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmulhu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmulhu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     3841.00  -    1.00    -      -     vrem.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     61.00   -     1.00    -      -     vrem.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     121.00  -     1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     241.00  -     1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     481.00  -     1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     961.00  -     1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     1921.00  -    1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     113.00  -     1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     225.00  -     1.00    -      -     vrem.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     449.00  -     1.00    -      -     vrem.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     897.00  -     1.00    -      -     vdivu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     1793.00  -    1.00    -      -     vdivu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     229.00  -     1.00    -      -     vdiv.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     457.00  -     1.00    -      -     vdiv.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     913.00  -     1.00    -      -     vremu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     1825.00  -    1.00    -      -     vremu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmul.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmul.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmulu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmulu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmulsu.vv	v4, v8, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmulsu.vx	v4, v8, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnmsub.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnmsub.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vnmsac.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vnmsac.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmadd.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmadd.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmaccsu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmaccsu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vwmaccus.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vwmaccu.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vwmaccu.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmacc.vv	v4, v12, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vwmacc.vx	v4, a0, v8
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     3.00    -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     5.00    -     1.00    -      -     vmerge.vxm	v4, v8, a0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     9.00    -     1.00    -      -     vmerge.vim	v4, v8, 0, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     17.00   -     1.00    -      -     vmerge.vvm	v4, v8, v12, v0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf8, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e8, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf4, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e16, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, mf2, tu, mu
# CHECK-NEXT:  -      -      -      -     1.00   1.00   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -     1.50   1.50   1.00    -      -     vmv.v.v	v4, v12
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -     2.50   2.50   1.00    -      -     vmv.v.x	v4, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -     4.50   4.50   1.00    -      -     vmv.v.i	v4, 0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     vsetvli	zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -     8.50   8.50   1.00    -      -     vmv.v.v	v4, v12
