; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mattr=-sign-ext,-bulk-memory,-bulk-memory-opt | FileCheck %s

target triple = "wasm32-unknown-unknown"

define i8 @not_use_extend8_s(i8 %v, i8 %x) {
; CHECK-LABEL: not_use_extend8_s:
; CHECK:         .functype not_use_extend8_s (i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32.const 24
; CHECK-NEXT:    i32.shl
; CHECK-NEXT:    i32.const 24
; CHECK-NEXT:    i32.shr_s
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 255
; CHECK-NEXT:    i32.and
; CHECK-NEXT:    i32.shr_s
; CHECK-NEXT:    # fallthrough-return
  %a = ashr i8 %v, %x
  ret i8 %a
}

attributes #0 = { "target-features"="+bulk-memory-opt" }

declare void @llvm.memset.p0.i32(ptr, i8, i32, i1)

define void @lower_bulk_memory(i8 %val) #0 {
; CHECK-LABEL: lower_bulk_memory:
; CHECK:         .functype lower_bulk_memory (i32) -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get __stack_pointer
; CHECK-NEXT:    i32.const 112
; CHECK-NEXT:    i32.sub
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 12
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32.const 100
; CHECK-NEXT:    call memset
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    i32.const 112
; CHECK-NEXT:    i32.add
; CHECK-NEXT:    global.set __stack_pointer
; CHECK-NEXT:    # fallthrough-return
  %a = alloca [100 x i8]
  call void @llvm.memset.p0.i32(ptr %a, i8 %val, i32 100, i1 false)
  ret void
}
