/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_c_chachiyo.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t37, t38;
  double t39, t42, t44, t45, t46, t47, t49, t53;
  double t54, t55, t56, tzk0;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t37 = t36 * t36;
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t37, 1);
  t39 = t38 * t38;
  t42 = -0.2e1 * t39 * t38 + 0.2e1;
  t44 = t24 + (params->af * t32 - t24) * t42;
  t45 = M_CBRTPI;
  t46 = t2 * t45;
  t47 = rho[0] * rho[0];
  t49 = 0.1e1 / t9 / t47;
  t53 = 0.1e1 + t46 * t49 * sigma[0] / 0.48e2;
  t54 = 0.1e1 / t44;
  t55 = params->h * t54;
  t56 = pow(t53, t55);
  tzk0 = t44 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t37, t38;
  double t39, t42, t44, t45, t46, t47, t49, t53;
  double t54, t55, t56, tzk0;

  double t58, t62, t65, t67, t68, t73, t75, t79;
  double t80, t82, t83, t84, t85, t86, t87, t89;
  double t90, t92, t93, t94, t95, t96, t99, t100;
  double tvrho0, t103, t104, t106, tvsigma0;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t37 = t36 * t36;
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t37, 1);
  t39 = t38 * t38;
  t42 = -0.2e1 * t39 * t38 + 0.2e1;
  t44 = t24 + (params->af * t32 - t24) * t42;
  t45 = M_CBRTPI;
  t46 = t2 * t45;
  t47 = rho[0] * rho[0];
  t49 = 0.1e1 / t9 / t47;
  t53 = 0.1e1 + t46 * t49 * sigma[0] / 0.48e2;
  t54 = 0.1e1 / t44;
  t55 = params->h * t54;
  t56 = pow(t53, t55);
  tzk0 = t44 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t8 / t18;
  t62 = t17 / t9;
  t65 = t3 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t62;
  t67 = 0.1e1 / t22;
  t68 = params->ap * t65 * t67;
  t73 = t25 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t62;
  t75 = 0.1e1 / t31;
  t79 = t68 + (params->af * t73 * t75 - t68) * t42;
  t80 = rho[0] * t79;
  t82 = rho[0] * t44;
  t83 = t44 * t44;
  t84 = 0.1e1 / t83;
  t85 = params->h * t84;
  t86 = log(t53);
  t87 = t79 * t86;
  t89 = t55 * t2;
  t90 = t47 * rho[0];
  t92 = 0.1e1 / t9 / t90;
  t93 = t45 * t92;
  t94 = 0.1e1 / t53;
  t95 = sigma[0] * t94;
  t96 = t93 * t95;
  t99 = -t85 * t87 - 0.7e1 / 0.144e3 * t89 * t96;
  t100 = t56 * t99;
  tvrho0 = t82 * t100 + t80 * t56 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t9 / rho[0];
  t104 = t103 * t56;
  t106 = t46 * t94;
  tvsigma0 = t104 * params->h * t106 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t37, t38;
  double t39, t42, t44, t45, t46, t47, t49, t53;
  double t54, t55, t56, tzk0;

  double t58, t62, t65, t67, t68, t73, t75, t79;
  double t80, t82, t83, t84, t85, t86, t87, t89;
  double t90, t92, t93, t94, t95, t96, t99, t100;
  double tvrho0, t103, t104, t106, tvsigma0;

  double t108, t110, t115, t117, t120, t121, t122, t123;
  double t125, t126, t127, t131, t132, t134, t136, t137;
  double t141, t142, t146, t147, t150, t151, t152, t153;
  double t158, t159, t162, t164, t166, t169, t170, t171;
  double t173, t175, t176, t177, t178, t179, t182, t183;
  double tv2rho20, t185, t192, t197, t198, t199, t201, tv2rhosigma0;
  double t205, t206, t207, t210, t211, t214, tv2sigma20;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t37 = t36 * t36;
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t37, 1);
  t39 = t38 * t38;
  t42 = -0.2e1 * t39 * t38 + 0.2e1;
  t44 = t24 + (params->af * t32 - t24) * t42;
  t45 = M_CBRTPI;
  t46 = t2 * t45;
  t47 = rho[0] * rho[0];
  t49 = 0.1e1 / t9 / t47;
  t53 = 0.1e1 + t46 * t49 * sigma[0] / 0.48e2;
  t54 = 0.1e1 / t44;
  t55 = params->h * t54;
  t56 = pow(t53, t55);
  tzk0 = t44 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t8 / t18;
  t62 = t17 / t9;
  t65 = t3 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t62;
  t67 = 0.1e1 / t22;
  t68 = params->ap * t65 * t67;
  t73 = t25 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t62;
  t75 = 0.1e1 / t31;
  t79 = t68 + (params->af * t73 * t75 - t68) * t42;
  t80 = rho[0] * t79;
  t82 = rho[0] * t44;
  t83 = t44 * t44;
  t84 = 0.1e1 / t83;
  t85 = params->h * t84;
  t86 = log(t53);
  t87 = t79 * t86;
  t89 = t55 * t2;
  t90 = t47 * rho[0];
  t92 = 0.1e1 / t9 / t90;
  t93 = t45 * t92;
  t94 = 0.1e1 / t53;
  t95 = sigma[0] * t94;
  t96 = t93 * t95;
  t99 = -t85 * t87 - 0.7e1 / 0.144e3 * t89 * t96;
  t100 = t56 * t99;
  tvrho0 = t82 * t100 + t80 * t56 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t9 / rho[0];
  t104 = t103 * t56;
  t106 = t46 * t94;
  tvsigma0 = t104 * params->h * t106 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t108 = t79 * t56;
  t110 = t44 * t56;
  t115 = t8 / t18 / rho[0];
  t117 = t17 * t103;
  t120 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t13 * t117;
  t121 = params->ap * t120;
  t122 = t121 * t67;
  t123 = t65 * t65;
  t125 = t22 * t22;
  t126 = 0.1e1 / t125;
  t127 = params->ap * t123 * t126;
  t131 = -0.2e1 / 0.27e2 * t25 * t115 - 0.2e1 / 0.27e2 * t28 * t117;
  t132 = params->af * t131;
  t134 = t73 * t73;
  t136 = t31 * t31;
  t137 = 0.1e1 / t136;
  t141 = t122 - t127 + (-params->af * t134 * t137 + t132 * t75 - t122 + t127) * t42;
  t142 = rho[0] * t141;
  t146 = t99 * t99;
  t147 = t56 * t146;
  t150 = 0.1e1 / t83 / t44;
  t151 = params->h * t150;
  t152 = t79 * t79;
  t153 = t152 * t86;
  t158 = t79 * t2;
  t159 = t85 * t158;
  t162 = t47 * t47;
  t164 = 0.1e1 / t9 / t162;
  t166 = t45 * t164 * t95;
  t169 = t55 * t1;
  t170 = t45 * t45;
  t171 = t162 * t47;
  t173 = 0.1e1 / t18 / t171;
  t175 = sigma[0] * sigma[0];
  t176 = t53 * t53;
  t177 = 0.1e1 / t176;
  t178 = t175 * t177;
  t179 = t170 * t173 * t178;
  t182 = 0.2e1 * t151 * t153 - t85 * t141 * t86 + 0.7e1 / 0.72e2 * t159 * t96 + 0.35e2 / 0.216e3 * t89 * t166 - 0.49e2 / 0.6912e4 * t169 * t179;
  t183 = t56 * t182;
  tv2rho20 = 0.2e1 * t80 * t100 + 0.2e1 * t110 * t99 + t142 * t56 + t82 * t147 + t82 * t183 + 0.2e1 * t108;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t185 = t49 * t56;
  t192 = params->h * t2 * t45 * t94;
  t197 = 0.1e1 / t18 / t162 * t56;
  t198 = t197 * params->h;
  t199 = t1 * t170;
  t201 = t199 * t177 * sigma[0];
  tv2rhosigma0 = -t185 * params->h * t106 / 0.36e2 + t104 * t99 * t192 / 0.48e2 + 0.7e1 / 0.2304e4 * t198 * t201;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t205 = 0.1e1 / t18 / t90;
  t206 = t205 * t56;
  t207 = params->h * params->h;
  t210 = t170 * t177;
  t211 = t54 * t1 * t210;
  t214 = t199 * t177;
  tv2sigma20 = t206 * t207 * t211 / 0.768e3 - t206 * params->h * t214 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t37, t38;
  double t39, t42, t44, t45, t46, t47, t49, t53;
  double t54, t55, t56, tzk0;

  double t58, t62, t65, t67, t68, t73, t75, t79;
  double t80, t82, t83, t84, t85, t86, t87, t89;
  double t90, t92, t93, t94, t95, t96, t99, t100;
  double tvrho0, t103, t104, t106, tvsigma0;

  double t108, t110, t115, t117, t120, t121, t122, t123;
  double t125, t126, t127, t131, t132, t134, t136, t137;
  double t141, t142, t146, t147, t150, t151, t152, t153;
  double t158, t159, t162, t164, t166, t169, t170, t171;
  double t173, t175, t176, t177, t178, t179, t182, t183;
  double tv2rho20, t185, t192, t197, t198, t199, t201, tv2rhosigma0;
  double t205, t206, t207, t210, t211, t214, tv2sigma20;

  double t217, t227, t230, t234, t235, t236, t238, t242;
  double t244, t250, t252, t258, t263, t264, t272, t273;
  double t275, t278, t280, t281, t289, t295, t301, t304;
  double t308, t311, t315, t318, t319, t320, t321, t322;
  double t325, t329, t330, tv3rho30, t332, t341, t342, t351;
  double t356, t357, t358, t359, tv3rho2sigma0, t365, t366, t369;
  double t370, t372, t376, t377, t378, t379, t380, t387;
  double t391, tv3rhosigma20, t395, t396, t397, t398, t399, t402;
  double t403, t406, t407, tv3sigma30;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t37 = t36 * t36;
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t37, 1);
  t39 = t38 * t38;
  t42 = -0.2e1 * t39 * t38 + 0.2e1;
  t44 = t24 + (params->af * t32 - t24) * t42;
  t45 = M_CBRTPI;
  t46 = t2 * t45;
  t47 = rho[0] * rho[0];
  t49 = 0.1e1 / t9 / t47;
  t53 = 0.1e1 + t46 * t49 * sigma[0] / 0.48e2;
  t54 = 0.1e1 / t44;
  t55 = params->h * t54;
  t56 = pow(t53, t55);
  tzk0 = t44 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t8 / t18;
  t62 = t17 / t9;
  t65 = t3 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t62;
  t67 = 0.1e1 / t22;
  t68 = params->ap * t65 * t67;
  t73 = t25 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t62;
  t75 = 0.1e1 / t31;
  t79 = t68 + (params->af * t73 * t75 - t68) * t42;
  t80 = rho[0] * t79;
  t82 = rho[0] * t44;
  t83 = t44 * t44;
  t84 = 0.1e1 / t83;
  t85 = params->h * t84;
  t86 = log(t53);
  t87 = t79 * t86;
  t89 = t55 * t2;
  t90 = t47 * rho[0];
  t92 = 0.1e1 / t9 / t90;
  t93 = t45 * t92;
  t94 = 0.1e1 / t53;
  t95 = sigma[0] * t94;
  t96 = t93 * t95;
  t99 = -t85 * t87 - 0.7e1 / 0.144e3 * t89 * t96;
  t100 = t56 * t99;
  tvrho0 = t82 * t100 + t80 * t56 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t9 / rho[0];
  t104 = t103 * t56;
  t106 = t46 * t94;
  tvsigma0 = t104 * params->h * t106 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t108 = t79 * t56;
  t110 = t44 * t56;
  t115 = t8 / t18 / rho[0];
  t117 = t17 * t103;
  t120 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t13 * t117;
  t121 = params->ap * t120;
  t122 = t121 * t67;
  t123 = t65 * t65;
  t125 = t22 * t22;
  t126 = 0.1e1 / t125;
  t127 = params->ap * t123 * t126;
  t131 = -0.2e1 / 0.27e2 * t25 * t115 - 0.2e1 / 0.27e2 * t28 * t117;
  t132 = params->af * t131;
  t134 = t73 * t73;
  t136 = t31 * t31;
  t137 = 0.1e1 / t136;
  t141 = t122 - t127 + (-params->af * t134 * t137 + t132 * t75 - t122 + t127) * t42;
  t142 = rho[0] * t141;
  t146 = t99 * t99;
  t147 = t56 * t146;
  t150 = 0.1e1 / t83 / t44;
  t151 = params->h * t150;
  t152 = t79 * t79;
  t153 = t152 * t86;
  t158 = t79 * t2;
  t159 = t85 * t158;
  t162 = t47 * t47;
  t164 = 0.1e1 / t9 / t162;
  t166 = t45 * t164 * t95;
  t169 = t55 * t1;
  t170 = t45 * t45;
  t171 = t162 * t47;
  t173 = 0.1e1 / t18 / t171;
  t175 = sigma[0] * sigma[0];
  t176 = t53 * t53;
  t177 = 0.1e1 / t176;
  t178 = t175 * t177;
  t179 = t170 * t173 * t178;
  t182 = 0.2e1 * t151 * t153 - t85 * t141 * t86 + 0.7e1 / 0.72e2 * t159 * t96 + 0.35e2 / 0.216e3 * t89 * t166 - 0.49e2 / 0.6912e4 * t169 * t179;
  t183 = t56 * t182;
  tv2rho20 = 0.2e1 * t80 * t100 + 0.2e1 * t110 * t99 + t142 * t56 + t82 * t147 + t82 * t183 + 0.2e1 * t108;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t185 = t49 * t56;
  t192 = params->h * t2 * t45 * t94;
  t197 = 0.1e1 / t18 / t162 * t56;
  t198 = t197 * params->h;
  t199 = t1 * t170;
  t201 = t199 * t177 * sigma[0];
  tv2rhosigma0 = -t185 * params->h * t106 / 0.36e2 + t104 * t99 * t192 / 0.48e2 + 0.7e1 / 0.2304e4 * t198 * t201;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t205 = 0.1e1 / t18 / t90;
  t206 = t205 * t56;
  t207 = params->h * params->h;
  t210 = t170 * t177;
  t211 = t54 * t1 * t210;
  t214 = t199 * t177;
  tv2sigma20 = t206 * t207 * t211 / 0.768e3 - t206 * params->h * t214 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t217 = t141 * t56;
  t227 = t8 / t18 / t47;
  t230 = t17 * t49;
  t234 = params->ap * (0.1e2 / 0.81e2 * t3 * t227 + 0.8e1 / 0.81e2 * t13 * t230);
  t235 = t234 * t67;
  t236 = t126 * t65;
  t238 = 0.3e1 * t121 * t236;
  t242 = 0.1e1 / t125 / t22;
  t244 = 0.2e1 * params->ap * t123 * t65 * t242;
  t250 = params->af * (0.1e2 / 0.81e2 * t25 * t227 + 0.8e1 / 0.81e2 * t28 * t230);
  t252 = t137 * t73;
  t258 = 0.1e1 / t136 / t31;
  t263 = t235 - t238 + t244 + (0.2e1 * params->af * t134 * t73 * t258 - 0.3e1 * t132 * t252 + t250 * t75 - t235 + t238 - t244) * t42;
  t264 = rho[0] * t263;
  t272 = t146 * t99;
  t273 = t56 * t272;
  t275 = t100 * t182;
  t278 = t83 * t83;
  t280 = params->h / t278;
  t281 = t152 * t79;
  t289 = t151 * t152 * t2;
  t295 = t85 * t141 * t2;
  t301 = t85 * t79 * t1;
  t304 = t162 * rho[0];
  t308 = t45 / t9 / t304 * t95;
  t311 = t162 * t90;
  t315 = t170 / t18 / t311 * t178;
  t318 = t55 * M_PI;
  t319 = t162 * t162;
  t320 = t319 * t47;
  t321 = 0.1e1 / t320;
  t322 = t175 * sigma[0];
  t325 = 0.1e1 / t176 / t53;
  t329 = -0.6e1 * t280 * t281 * t86 + 0.6e1 * t151 * t87 * t141 - 0.7e1 / 0.24e2 * t289 * t96 - t85 * t263 * t86 + 0.7e1 / 0.48e2 * t295 * t96 - 0.35e2 / 0.72e2 * t159 * t166 + 0.49e2 / 0.2304e4 * t301 * t179 - 0.455e3 / 0.648e3 * t89 * t308 + 0.245e3 / 0.3456e4 * t169 * t315 - 0.343e3 / 0.165888e6 * t318 * t321 * t322 * t325;
  t330 = t56 * t329;
  tv3rho30 = 0.3e1 * t142 * t100 + 0.6e1 * t108 * t99 + 0.3e1 * t110 * t146 + 0.3e1 * t110 * t182 + 0.3e1 * t80 * t147 + 0.3e1 * t80 * t183 + t264 * t56 + t82 * t273 + 0.3e1 * t82 * t275 + t82 * t330 + 0.3e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t332 = t92 * t56;
  t341 = 0.1e1 / t18 / t304 * t56;
  t342 = t341 * params->h;
  t351 = t99 * params->h;
  t356 = 0.1e1 / t319 * t56;
  t357 = t356 * params->h;
  t358 = M_PI * t325;
  t359 = t358 * t175;
  tv3rho2sigma0 = 0.7e1 / 0.108e3 * t332 * params->h * t106 - t185 * t99 * t192 / 0.18e2 - 0.7e1 / 0.384e3 * t342 * t201 + t104 * t146 * t192 / 0.48e2 + t104 * t182 * t192 / 0.48e2 + 0.7e1 / 0.1152e4 * t197 * t351 * t201 + 0.49e2 / 0.55296e5 * t357 * t359;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t365 = t99 * t207;
  t366 = t206 * t365;
  t369 = t207 * t84;
  t370 = t206 * t369;
  t372 = t199 * t177 * t79;
  t376 = 0.1e1 / t311 * t56;
  t377 = t376 * t207;
  t378 = t54 * M_PI;
  t379 = t325 * sigma[0];
  t380 = t378 * t379;
  t387 = params->h * t1 * t210;
  t391 = t358 * sigma[0];
  tv3rhosigma20 = -0.11e2 / 0.2304e4 * t197 * t207 * t211 + t366 * t211 / 0.768e3 - t370 * t372 / 0.768e3 + 0.7e1 / 0.18432e5 * t377 * t380 + 0.11e2 / 0.2304e4 * t198 * t214 - t206 * t99 * t387 / 0.768e3 - 0.7e1 / 0.18432e5 * t376 * params->h * t391;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t395 = 0.1e1 / t171 * t56;
  t396 = t207 * params->h;
  t397 = t395 * t396;
  t398 = t84 * M_PI;
  t399 = t398 * t325;
  t402 = t395 * t207;
  t403 = t378 * t325;
  t406 = params->h * M_PI;
  t407 = t406 * t325;
  tv3sigma30 = t397 * t399 / 0.12288e5 - t402 * t403 / 0.4096e4 + t395 * t407 / 0.6144e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t13, t14, t16, t17, t18, t19, t22, t23;
  double t24, t25, t28, t31, t32, t36, t37, t38;
  double t39, t42, t44, t45, t46, t47, t49, t53;
  double t54, t55, t56, tzk0;

  double t58, t62, t65, t67, t68, t73, t75, t79;
  double t80, t82, t83, t84, t85, t86, t87, t89;
  double t90, t92, t93, t94, t95, t96, t99, t100;
  double tvrho0, t103, t104, t106, tvsigma0;

  double t108, t110, t115, t117, t120, t121, t122, t123;
  double t125, t126, t127, t131, t132, t134, t136, t137;
  double t141, t142, t146, t147, t150, t151, t152, t153;
  double t158, t159, t162, t164, t166, t169, t170, t171;
  double t173, t175, t176, t177, t178, t179, t182, t183;
  double tv2rho20, t185, t192, t197, t198, t199, t201, tv2rhosigma0;
  double t205, t206, t207, t210, t211, t214, tv2sigma20;

  double t217, t227, t230, t234, t235, t236, t238, t242;
  double t244, t250, t252, t258, t263, t264, t272, t273;
  double t275, t278, t280, t281, t289, t295, t301, t304;
  double t308, t311, t315, t318, t319, t320, t321, t322;
  double t325, t329, t330, tv3rho30, t332, t341, t342, t351;
  double t356, t357, t358, t359, tv3rho2sigma0, t365, t366, t369;
  double t370, t372, t376, t377, t378, t379, t380, t387;
  double t391, tv3rhosigma20, t395, t396, t397, t398, t399, t402;
  double t403, t406, t407, tv3sigma30;

  double t423, t426, t431, t433, t436, t437, t440, t441;
  double t443, t446, t459, t463, t465, t471, t510, t515;
  double t517, t518, t519, t534, t543, t550, t557, t579;
  double t582, tv4rho40, t637, t642, tv4rho3sigma0, t675, t676, t679;
  double tv4rho2sigma20, t723, t724, t729, t735, t738, tv4rhosigma30, t761;
  double t762, tv4sigma40;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = POW_1_3(rho[0]);
  t10 = t8 * t9;
  t13 = params->cp * t1;
  t14 = t5 * t5;
  t16 = t7 * t7;
  t17 = 0.1e1 / t14 * t16;
  t18 = t9 * t9;
  t19 = t17 * t18;
  t22 = 0.1e1 + t3 * t10 / 0.3e1 + t13 * t19 / 0.3e1;
  t23 = log(t22);
  t24 = params->ap * t23;
  t25 = params->bf * t2;
  t28 = params->cf * t1;
  t31 = 0.1e1 + t25 * t10 / 0.3e1 + t28 * t19 / 0.3e1;
  t32 = log(t31);
  t36 = POW_1_3(p->zeta_threshold);
  t37 = t36 * t36;
  t38 = my_piecewise3(0.1e1 <= p->zeta_threshold, t37, 1);
  t39 = t38 * t38;
  t42 = -0.2e1 * t39 * t38 + 0.2e1;
  t44 = t24 + (params->af * t32 - t24) * t42;
  t45 = M_CBRTPI;
  t46 = t2 * t45;
  t47 = rho[0] * rho[0];
  t49 = 0.1e1 / t9 / t47;
  t53 = 0.1e1 + t46 * t49 * sigma[0] / 0.48e2;
  t54 = 0.1e1 / t44;
  t55 = params->h * t54;
  t56 = pow(t53, t55);
  tzk0 = t44 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t8 / t18;
  t62 = t17 / t9;
  t65 = t3 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t13 * t62;
  t67 = 0.1e1 / t22;
  t68 = params->ap * t65 * t67;
  t73 = t25 * t58 / 0.9e1 + 0.2e1 / 0.9e1 * t28 * t62;
  t75 = 0.1e1 / t31;
  t79 = t68 + (params->af * t73 * t75 - t68) * t42;
  t80 = rho[0] * t79;
  t82 = rho[0] * t44;
  t83 = t44 * t44;
  t84 = 0.1e1 / t83;
  t85 = params->h * t84;
  t86 = log(t53);
  t87 = t79 * t86;
  t89 = t55 * t2;
  t90 = t47 * rho[0];
  t92 = 0.1e1 / t9 / t90;
  t93 = t45 * t92;
  t94 = 0.1e1 / t53;
  t95 = sigma[0] * t94;
  t96 = t93 * t95;
  t99 = -t85 * t87 - 0.7e1 / 0.144e3 * t89 * t96;
  t100 = t56 * t99;
  tvrho0 = t82 * t100 + t80 * t56 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t103 = 0.1e1 / t9 / rho[0];
  t104 = t103 * t56;
  t106 = t46 * t94;
  tvsigma0 = t104 * params->h * t106 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t108 = t79 * t56;
  t110 = t44 * t56;
  t115 = t8 / t18 / rho[0];
  t117 = t17 * t103;
  t120 = -0.2e1 / 0.27e2 * t3 * t115 - 0.2e1 / 0.27e2 * t13 * t117;
  t121 = params->ap * t120;
  t122 = t121 * t67;
  t123 = t65 * t65;
  t125 = t22 * t22;
  t126 = 0.1e1 / t125;
  t127 = params->ap * t123 * t126;
  t131 = -0.2e1 / 0.27e2 * t25 * t115 - 0.2e1 / 0.27e2 * t28 * t117;
  t132 = params->af * t131;
  t134 = t73 * t73;
  t136 = t31 * t31;
  t137 = 0.1e1 / t136;
  t141 = t122 - t127 + (-params->af * t134 * t137 + t132 * t75 - t122 + t127) * t42;
  t142 = rho[0] * t141;
  t146 = t99 * t99;
  t147 = t56 * t146;
  t150 = 0.1e1 / t83 / t44;
  t151 = params->h * t150;
  t152 = t79 * t79;
  t153 = t152 * t86;
  t158 = t79 * t2;
  t159 = t85 * t158;
  t162 = t47 * t47;
  t164 = 0.1e1 / t9 / t162;
  t166 = t45 * t164 * t95;
  t169 = t55 * t1;
  t170 = t45 * t45;
  t171 = t162 * t47;
  t173 = 0.1e1 / t18 / t171;
  t175 = sigma[0] * sigma[0];
  t176 = t53 * t53;
  t177 = 0.1e1 / t176;
  t178 = t175 * t177;
  t179 = t170 * t173 * t178;
  t182 = 0.2e1 * t151 * t153 - t85 * t141 * t86 + 0.7e1 / 0.72e2 * t159 * t96 + 0.35e2 / 0.216e3 * t89 * t166 - 0.49e2 / 0.6912e4 * t169 * t179;
  t183 = t56 * t182;
  tv2rho20 = 0.2e1 * t80 * t100 + 0.2e1 * t110 * t99 + t142 * t56 + t82 * t147 + t82 * t183 + 0.2e1 * t108;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t185 = t49 * t56;
  t192 = params->h * t2 * t45 * t94;
  t197 = 0.1e1 / t18 / t162 * t56;
  t198 = t197 * params->h;
  t199 = t1 * t170;
  t201 = t199 * t177 * sigma[0];
  tv2rhosigma0 = -t185 * params->h * t106 / 0.36e2 + t104 * t99 * t192 / 0.48e2 + 0.7e1 / 0.2304e4 * t198 * t201;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t205 = 0.1e1 / t18 / t90;
  t206 = t205 * t56;
  t207 = params->h * params->h;
  t210 = t170 * t177;
  t211 = t54 * t1 * t210;
  t214 = t199 * t177;
  tv2sigma20 = t206 * t207 * t211 / 0.768e3 - t206 * params->h * t214 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t217 = t141 * t56;
  t227 = t8 / t18 / t47;
  t230 = t17 * t49;
  t234 = params->ap * (0.1e2 / 0.81e2 * t3 * t227 + 0.8e1 / 0.81e2 * t13 * t230);
  t235 = t234 * t67;
  t236 = t126 * t65;
  t238 = 0.3e1 * t121 * t236;
  t242 = 0.1e1 / t125 / t22;
  t244 = 0.2e1 * params->ap * t123 * t65 * t242;
  t250 = params->af * (0.1e2 / 0.81e2 * t25 * t227 + 0.8e1 / 0.81e2 * t28 * t230);
  t252 = t137 * t73;
  t258 = 0.1e1 / t136 / t31;
  t263 = t235 - t238 + t244 + (0.2e1 * params->af * t134 * t73 * t258 - 0.3e1 * t132 * t252 + t250 * t75 - t235 + t238 - t244) * t42;
  t264 = rho[0] * t263;
  t272 = t146 * t99;
  t273 = t56 * t272;
  t275 = t100 * t182;
  t278 = t83 * t83;
  t280 = params->h / t278;
  t281 = t152 * t79;
  t289 = t151 * t152 * t2;
  t295 = t85 * t141 * t2;
  t301 = t85 * t79 * t1;
  t304 = t162 * rho[0];
  t308 = t45 / t9 / t304 * t95;
  t311 = t162 * t90;
  t315 = t170 / t18 / t311 * t178;
  t318 = t55 * M_PI;
  t319 = t162 * t162;
  t320 = t319 * t47;
  t321 = 0.1e1 / t320;
  t322 = t175 * sigma[0];
  t325 = 0.1e1 / t176 / t53;
  t329 = -0.6e1 * t280 * t281 * t86 + 0.6e1 * t151 * t87 * t141 - 0.7e1 / 0.24e2 * t289 * t96 - t85 * t263 * t86 + 0.7e1 / 0.48e2 * t295 * t96 - 0.35e2 / 0.72e2 * t159 * t166 + 0.49e2 / 0.2304e4 * t301 * t179 - 0.455e3 / 0.648e3 * t89 * t308 + 0.245e3 / 0.3456e4 * t169 * t315 - 0.343e3 / 0.165888e6 * t318 * t321 * t322 * t325;
  t330 = t56 * t329;
  tv3rho30 = 0.3e1 * t142 * t100 + 0.6e1 * t108 * t99 + 0.3e1 * t110 * t146 + 0.3e1 * t110 * t182 + 0.3e1 * t80 * t147 + 0.3e1 * t80 * t183 + t264 * t56 + t82 * t273 + 0.3e1 * t82 * t275 + t82 * t330 + 0.3e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t332 = t92 * t56;
  t341 = 0.1e1 / t18 / t304 * t56;
  t342 = t341 * params->h;
  t351 = t99 * params->h;
  t356 = 0.1e1 / t319 * t56;
  t357 = t356 * params->h;
  t358 = M_PI * t325;
  t359 = t358 * t175;
  tv3rho2sigma0 = 0.7e1 / 0.108e3 * t332 * params->h * t106 - t185 * t99 * t192 / 0.18e2 - 0.7e1 / 0.384e3 * t342 * t201 + t104 * t146 * t192 / 0.48e2 + t104 * t182 * t192 / 0.48e2 + 0.7e1 / 0.1152e4 * t197 * t351 * t201 + 0.49e2 / 0.55296e5 * t357 * t359;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t365 = t99 * t207;
  t366 = t206 * t365;
  t369 = t207 * t84;
  t370 = t206 * t369;
  t372 = t199 * t177 * t79;
  t376 = 0.1e1 / t311 * t56;
  t377 = t376 * t207;
  t378 = t54 * M_PI;
  t379 = t325 * sigma[0];
  t380 = t378 * t379;
  t387 = params->h * t1 * t210;
  t391 = t358 * sigma[0];
  tv3rhosigma20 = -0.11e2 / 0.2304e4 * t197 * t207 * t211 + t366 * t211 / 0.768e3 - t370 * t372 / 0.768e3 + 0.7e1 / 0.18432e5 * t377 * t380 + 0.11e2 / 0.2304e4 * t198 * t214 - t206 * t99 * t387 / 0.768e3 - 0.7e1 / 0.18432e5 * t376 * params->h * t391;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t395 = 0.1e1 / t171 * t56;
  t396 = t207 * params->h;
  t397 = t395 * t396;
  t398 = t84 * M_PI;
  t399 = t398 * t325;
  t402 = t395 * t207;
  t403 = t378 * t325;
  t406 = params->h * M_PI;
  t407 = t406 * t325;
  tv3sigma30 = t397 * t399 / 0.12288e5 - t402 * t403 / 0.4096e4 + t395 * t407 / 0.6144e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t423 = t8 * t205;
  t426 = t17 * t92;
  t431 = params->ap * (-0.8e2 / 0.243e3 * t3 * t423 - 0.56e2 / 0.243e3 * t13 * t426) * t67;
  t433 = 0.4e1 * t234 * t236;
  t436 = 0.12e2 * t121 * t242 * t123;
  t437 = t120 * t120;
  t440 = 0.3e1 * params->ap * t437 * t126;
  t441 = t123 * t123;
  t443 = t125 * t125;
  t446 = 0.6e1 * params->ap * t441 / t443;
  t459 = t131 * t131;
  t463 = t134 * t134;
  t465 = t136 * t136;
  t471 = t431 - t433 + t436 - t440 - t446 + (params->af * (-0.8e2 / 0.243e3 * t25 * t423 - 0.56e2 / 0.243e3 * t28 * t426) * t75 - 0.4e1 * t250 * t252 + 0.12e2 * t132 * t258 * t134 - 0.3e1 * params->af * t459 * t137 - 0.6e1 * params->af * t463 / t465 - t431 + t433 - t436 + t440 + t446) * t42;
  t510 = t45 * M_PI;
  t515 = t175 * t175;
  t517 = t176 * t176;
  t518 = 0.1e1 / t517;
  t519 = t518 * t2;
  t534 = t319 * t90;
  t543 = t152 * t152;
  t550 = t141 * t141;
  t557 = -t85 * t471 * t86 + 0.7e1 / 0.6e1 * t280 * t281 * t2 * t96 - 0.49e2 / 0.576e3 * t151 * t152 * t1 * t179 + 0.7e1 / 0.36e2 * t85 * t263 * t2 * t96 + 0.49e2 / 0.1152e4 * t85 * t141 * t1 * t179 - 0.245e3 / 0.864e3 * t301 * t315 + 0.91e3 / 0.243e3 * t89 * t45 / t9 / t171 * t95 + 0.343e3 / 0.41472e5 * t85 * t79 * M_PI * t321 * t322 * t325 - 0.10045e5 / 0.15552e5 * t169 * t170 / t18 / t319 * t178 - 0.2401e4 / 0.7962624e7 * t55 * t510 / t9 / t319 / t304 * t515 * t519 - 0.7e1 / 0.6e1 * t151 * t158 * t93 * t95 * t141 + 0.35e2 / 0.18e2 * t289 * t166 - 0.35e2 / 0.36e2 * t295 * t166 + 0.455e3 / 0.162e3 * t159 * t308 + 0.1715e4 / 0.41472e5 * t318 / t534 * t322 * t325 + 0.24e2 * params->h / t278 / t44 * t543 * t86 - 0.36e2 * t280 * t153 * t141 + 0.6e1 * t151 * t550 * t86 + 0.8e1 * t151 * t87 * t263;
  t579 = t146 * t146;
  t582 = t182 * t182;
  tv4rho40 = rho[0] * t471 * t56 + 0.4e1 * t82 * t100 * t329 + 0.6e1 * t82 * t147 * t182 + 0.12e2 * tzk0 * t99 * t182 + t82 * t56 * t557 + t82 * t56 * t579 + 0.3e1 * t82 * t56 * t582 + 0.4e1 * t264 * t100 + 0.12e2 * t108 * t146 + 0.12e2 * t108 * t182 + 0.4e1 * t110 * t272 + 0.4e1 * t110 * t329 + 0.6e1 * t142 * t147 + 0.6e1 * t142 * t183 + 0.12e2 * t217 * t99 + 0.4e1 * t263 * t56 + 0.4e1 * t80 * t273 + 0.12e2 * t80 * t275 + 0.4e1 * t80 * t330;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t637 = t510 * t518;
  t642 = t319 * rho[0];
  tv4rho3sigma0 = -t185 * t146 * t192 / 0.12e2 - 0.7e1 / 0.128e3 * t341 * t351 * t201 + t104 * t351 * t46 * t94 * t182 / 0.16e2 + t104 * t272 * t192 / 0.48e2 + 0.7e1 / 0.768e3 * t197 * t146 * params->h * t201 + 0.7e1 / 0.768e3 * t197 * t182 * params->h * t201 - 0.35e2 / 0.162e3 * t164 * t56 * params->h * t106 + 0.7e1 / 0.36e2 * t332 * t99 * t192 + 0.1169e4 / 0.10368e5 * t173 * t56 * params->h * t201 - t185 * t182 * t192 / 0.12e2 + t104 * t329 * t192 / 0.48e2 + 0.49e2 / 0.18432e5 * t356 * t99 * t406 * t325 * t175 + 0.343e3 / 0.2654208e7 / t9 / t534 * t56 * params->h * t637 * t322 * t2 - 0.343e3 / 0.27648e5 / t642 * t56 * params->h * t359;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t675 = 0.1e1 / t9 / t320 * t56;
  t676 = t207 * t54;
  t679 = t637 * t175 * t2;
  tv4rho2sigma20 = 0.77e2 / 0.3456e4 * t341 * t207 * t211 + 0.11e2 / 0.1152e4 * t197 * t369 * t372 - 0.11e2 / 0.1152e4 * t197 * t365 * t211 + t206 * t182 * t207 * t211 / 0.768e3 + 0.7e1 / 0.9216e4 * t376 * t365 * t380 - t370 * t199 * t177 * t141 / 0.768e3 - 0.7e1 / 0.9216e4 * t376 * t369 * t358 * t79 * sigma[0] + 0.49e2 / 0.884736e6 * t675 * t676 * t679 - t206 * t146 * t387 / 0.768e3 - 0.7e1 / 0.1728e4 * t356 * t207 * t380 - 0.77e2 / 0.3456e4 * t342 * t214 + 0.11e2 / 0.1152e4 * t197 * t99 * t387 - t206 * t182 * t387 / 0.768e3 - 0.7e1 / 0.9216e4 * t376 * t99 * t406 * t379 - 0.49e2 / 0.884736e6 * t675 * params->h * t679 - t366 * t84 * t1 * t210 * t79 / 0.384e3 + t206 * t146 * t207 * t211 / 0.768e3 + t206 * t207 * t150 * t199 * t177 * t152 / 0.384e3 + 0.7e1 / 0.1728e4 * t357 * t391;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t723 = t395 * t99;
  t724 = t396 * t84;
  t729 = t325 * t79;
  t735 = 0.1e1 / t9 / t642 * t56;
  t738 = t637 * t2 * sigma[0];
  tv4rhosigma30 = -t376 * t396 * t399 / 0.2048e4 + t723 * t724 * t358 / 0.12288e5 - t397 * t150 * M_PI * t729 / 0.6144e4 + 0.7e1 / 0.589824e6 * t735 * t724 * t738 + 0.3e1 / 0.2048e4 * t377 * t403 - t723 * t676 * t358 / 0.4096e4 + t402 * t398 * t729 / 0.4096e4 - 0.7e1 / 0.196608e6 * t735 * t676 * t738 - t376 * t407 / 0.1024e4 + t723 * t407 / 0.6144e4 + 0.7e1 / 0.294912e6 * t735 * params->h * t738;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t761 = 0.1e1 / t9 / t319 * t56;
  t762 = t207 * t207;
  tv4sigma40 = t761 * t762 * t150 * t2 * t637 / 0.589824e6 - t761 * t396 * t84 * t510 * t519 / 0.98304e5 + 0.11e2 / 0.589824e6 * t761 * t207 * t54 * t510 * t519 - t761 * params->h * t637 * t2 / 0.98304e5;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t44;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t56, t58, t59, t60, t61, t63, t65, t69;
  double t70, t71, t72, tzk0;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * t41;
  t43 = POW_1_3(t39);
  t44 = t43 * t43;
  t45 = my_piecewise3(t40, t42, t44);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t49 = t48 * t48;
  t50 = my_piecewise3(t47, t42, t49);
  t52 = t45 / 0.2e1 + t50 / 0.2e1;
  t53 = t52 * t52;
  t56 = -0.2e1 * t53 * t52 + 0.2e1;
  t58 = t35 * t56 + t25;
  t59 = M_CBRTPI;
  t60 = t2 * t59;
  t61 = t9 * t9;
  t63 = 0.1e1 / t10 / t61;
  t65 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t69 = 0.1e1 + t60 * t63 * t65 / 0.48e2;
  t70 = 0.1e1 / t58;
  t71 = params->h * t70;
  t72 = pow(t69, t71);
  tzk0 = t58 * t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t44;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t56, t58, t59, t60, t61, t63, t65, t69;
  double t70, t71, t72, tzk0;

  double t74, t78, t81, t83, t84, t89, t91, t93;
  double t94, t95, t96, t97, t98, t99, t102, t103;
  double t104, t107, t109, t112, t113, t115, t116, t117;
  double t118, t119, t120, t122, t123, t125, t126, t127;
  double t128, t129, t131, t132, t133, tvrho0, t135, t138;
  double t139, t142, t144, t147, t148, t150, t152, t153;
  double tvrho1, t156, t157, t159, t160, tvsigma0, tvsigma1, tvsigma2;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * t41;
  t43 = POW_1_3(t39);
  t44 = t43 * t43;
  t45 = my_piecewise3(t40, t42, t44);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t49 = t48 * t48;
  t50 = my_piecewise3(t47, t42, t49);
  t52 = t45 / 0.2e1 + t50 / 0.2e1;
  t53 = t52 * t52;
  t56 = -0.2e1 * t53 * t52 + 0.2e1;
  t58 = t35 * t56 + t25;
  t59 = M_CBRTPI;
  t60 = t2 * t59;
  t61 = t9 * t9;
  t63 = 0.1e1 / t10 / t61;
  t65 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t69 = 0.1e1 + t60 * t63 * t65 / 0.48e2;
  t70 = 0.1e1 / t58;
  t71 = params->h * t70;
  t72 = pow(t69, t71);
  tzk0 = t58 * t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t8 / t19;
  t78 = t18 / t10;
  t81 = t3 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t78;
  t83 = 0.1e1 / t23;
  t84 = params->ap * t81 * t83;
  t89 = t26 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t78;
  t91 = 0.1e1 / t32;
  t93 = params->af * t89 * t91 - t84;
  t94 = t93 * t56;
  t95 = t35 * t53;
  t96 = 0.1e1 / t43;
  t97 = 0.1e1 / t61;
  t98 = t36 * t97;
  t99 = t37 - t98;
  t102 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t99);
  t103 = 0.1e1 / t48;
  t104 = -t99;
  t107 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t104);
  t109 = t102 / 0.2e1 + t107 / 0.2e1;
  t112 = -0.6e1 * t95 * t109 + t84 + t94;
  t113 = t9 * t112;
  t115 = t9 * t58;
  t116 = t58 * t58;
  t117 = 0.1e1 / t116;
  t118 = params->h * t117;
  t119 = log(t69);
  t120 = t112 * t119;
  t122 = t71 * t2;
  t123 = t61 * t9;
  t125 = 0.1e1 / t10 / t123;
  t126 = t59 * t125;
  t127 = 0.1e1 / t69;
  t128 = t65 * t127;
  t129 = t126 * t128;
  t131 = 0.7e1 / 0.144e3 * t122 * t129;
  t132 = -t118 * t120 - t131;
  t133 = t72 * t132;
  tvrho0 = t113 * t72 + t115 * t133 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t135 = -t37 - t98;
  t138 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t135);
  t139 = -t135;
  t142 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t139);
  t144 = t138 / 0.2e1 + t142 / 0.2e1;
  t147 = -0.6e1 * t95 * t144 + t84 + t94;
  t148 = t9 * t147;
  t150 = t147 * t119;
  t152 = -t118 * t150 - t131;
  t153 = t72 * t152;
  tvrho1 = t115 * t153 + t148 * t72 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t156 = 0.1e1 / t10 / t9;
  t157 = t156 * t72;
  t159 = t60 * t127;
  t160 = t157 * params->h * t159;
  tvsigma0 = t160 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = t160 / 0.24e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t44;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t56, t58, t59, t60, t61, t63, t65, t69;
  double t70, t71, t72, tzk0;

  double t74, t78, t81, t83, t84, t89, t91, t93;
  double t94, t95, t96, t97, t98, t99, t102, t103;
  double t104, t107, t109, t112, t113, t115, t116, t117;
  double t118, t119, t120, t122, t123, t125, t126, t127;
  double t128, t129, t131, t132, t133, tvrho0, t135, t138;
  double t139, t142, t144, t147, t148, t150, t152, t153;
  double tvrho1, t156, t157, t159, t160, tvsigma0, tvsigma1, tvsigma2;

  double t161, t163, t164, t168, t170, t173, t174, t175;
  double t176, t178, t179, t180, t184, t185, t187, t189;
  double t190, t192, t193, t194, t195, t197, t198, t202;
  double t203, t206, t207, t209, t213, t215, t216, t219;
  double t223, t225, t228, t229, t233, t234, t237, t238;
  double t239, t240, t245, t246, t247, t249, t251, t252;
  double t253, t255, t256, t257, t258, t260, t261, t262;
  double t263, t264, t265, t266, t268, t269, t270, tv2rho20;
  double t272, t274, t276, t279, t282, t286, t287, t290;
  double t294, t296, t299, t300, t303, t305, t310, t312;
  double t313, t314, t317, t318, tv2rho21, t323, t326, t330;
  double t334, t335, t338, t342, t344, t347, t348, t352;
  double t353, t355, t356, t359, t362, t363, tv2rho22, t365;
  double t367, t368, t372, t373, t377, t378, t379, t381;
  double t382, t383, tv2rhosigma0, t384, t386, tv2rhosigma1, tv2rhosigma2, t388;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t392, t393, t394, t397, t398;
  double t401, t403, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * t41;
  t43 = POW_1_3(t39);
  t44 = t43 * t43;
  t45 = my_piecewise3(t40, t42, t44);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t49 = t48 * t48;
  t50 = my_piecewise3(t47, t42, t49);
  t52 = t45 / 0.2e1 + t50 / 0.2e1;
  t53 = t52 * t52;
  t56 = -0.2e1 * t53 * t52 + 0.2e1;
  t58 = t35 * t56 + t25;
  t59 = M_CBRTPI;
  t60 = t2 * t59;
  t61 = t9 * t9;
  t63 = 0.1e1 / t10 / t61;
  t65 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t69 = 0.1e1 + t60 * t63 * t65 / 0.48e2;
  t70 = 0.1e1 / t58;
  t71 = params->h * t70;
  t72 = pow(t69, t71);
  tzk0 = t58 * t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t8 / t19;
  t78 = t18 / t10;
  t81 = t3 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t78;
  t83 = 0.1e1 / t23;
  t84 = params->ap * t81 * t83;
  t89 = t26 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t78;
  t91 = 0.1e1 / t32;
  t93 = params->af * t89 * t91 - t84;
  t94 = t93 * t56;
  t95 = t35 * t53;
  t96 = 0.1e1 / t43;
  t97 = 0.1e1 / t61;
  t98 = t36 * t97;
  t99 = t37 - t98;
  t102 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t99);
  t103 = 0.1e1 / t48;
  t104 = -t99;
  t107 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t104);
  t109 = t102 / 0.2e1 + t107 / 0.2e1;
  t112 = -0.6e1 * t95 * t109 + t84 + t94;
  t113 = t9 * t112;
  t115 = t9 * t58;
  t116 = t58 * t58;
  t117 = 0.1e1 / t116;
  t118 = params->h * t117;
  t119 = log(t69);
  t120 = t112 * t119;
  t122 = t71 * t2;
  t123 = t61 * t9;
  t125 = 0.1e1 / t10 / t123;
  t126 = t59 * t125;
  t127 = 0.1e1 / t69;
  t128 = t65 * t127;
  t129 = t126 * t128;
  t131 = 0.7e1 / 0.144e3 * t122 * t129;
  t132 = -t118 * t120 - t131;
  t133 = t72 * t132;
  tvrho0 = t113 * t72 + t115 * t133 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t135 = -t37 - t98;
  t138 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t135);
  t139 = -t135;
  t142 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t139);
  t144 = t138 / 0.2e1 + t142 / 0.2e1;
  t147 = -0.6e1 * t95 * t144 + t84 + t94;
  t148 = t9 * t147;
  t150 = t147 * t119;
  t152 = -t118 * t150 - t131;
  t153 = t72 * t152;
  tvrho1 = t115 * t153 + t148 * t72 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t156 = 0.1e1 / t10 / t9;
  t157 = t156 * t72;
  t159 = t60 * t127;
  t160 = t157 * params->h * t159;
  tvsigma0 = t160 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = t160 / 0.24e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t161 = t112 * t72;
  t163 = t58 * t72;
  t164 = t163 * t132;
  t168 = t8 / t19 / t9;
  t170 = t18 * t156;
  t173 = -0.2e1 / 0.27e2 * t14 * t170 - 0.2e1 / 0.27e2 * t3 * t168;
  t174 = params->ap * t173;
  t175 = t174 * t83;
  t176 = t81 * t81;
  t178 = t23 * t23;
  t179 = 0.1e1 / t178;
  t180 = params->ap * t176 * t179;
  t184 = -0.2e1 / 0.27e2 * t26 * t168 - 0.2e1 / 0.27e2 * t29 * t170;
  t185 = params->af * t184;
  t187 = t89 * t89;
  t189 = t32 * t32;
  t190 = 0.1e1 / t189;
  t192 = -params->af * t187 * t190 + t185 * t91 - t175 + t180;
  t193 = t192 * t56;
  t194 = t93 * t53;
  t195 = t194 * t109;
  t197 = t35 * t52;
  t198 = t109 * t109;
  t202 = 0.1e1 / t43 / t39;
  t203 = t99 * t99;
  t206 = 0.1e1 / t123;
  t207 = t36 * t206;
  t209 = -0.2e1 * t97 + 0.2e1 * t207;
  t213 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t203 + 0.2e1 / 0.3e1 * t96 * t209);
  t215 = 0.1e1 / t48 / t46;
  t216 = t104 * t104;
  t219 = -t209;
  t223 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t216 + 0.2e1 / 0.3e1 * t103 * t219);
  t225 = t213 / 0.2e1 + t223 / 0.2e1;
  t228 = -0.12e2 * t197 * t198 - 0.6e1 * t95 * t225 + t175 - t180 + t193 - 0.12e2 * t195;
  t229 = t9 * t228;
  t233 = t132 * t132;
  t234 = t72 * t233;
  t237 = 0.1e1 / t116 / t58;
  t238 = params->h * t237;
  t239 = t112 * t112;
  t240 = t239 * t119;
  t245 = t112 * t2;
  t246 = t118 * t245;
  t247 = t246 * t129;
  t249 = t61 * t61;
  t251 = 0.1e1 / t10 / t249;
  t252 = t59 * t251;
  t253 = t252 * t128;
  t255 = 0.35e2 / 0.216e3 * t122 * t253;
  t256 = t71 * t1;
  t257 = t59 * t59;
  t258 = t249 * t61;
  t260 = 0.1e1 / t19 / t258;
  t261 = t257 * t260;
  t262 = t65 * t65;
  t263 = t69 * t69;
  t264 = 0.1e1 / t263;
  t265 = t262 * t264;
  t266 = t261 * t265;
  t268 = 0.49e2 / 0.6912e4 * t256 * t266;
  t269 = 0.2e1 * t238 * t240 - t118 * t228 * t119 + 0.7e1 / 0.72e2 * t247 + t255 - t268;
  t270 = t72 * t269;
  tv2rho20 = 0.2e1 * t113 * t133 + t115 * t234 + t115 * t270 + t229 * t72 + 0.2e1 * t161 + 0.2e1 * t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t147 * t72;
  t274 = t194 * t144;
  t276 = t144 * t109;
  t279 = t202 * t135;
  t282 = t96 * t36;
  t286 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t279 * t99 + 0.4e1 / 0.3e1 * t282 * t206);
  t287 = t215 * t139;
  t290 = t103 * t36;
  t294 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t287 * t104 - 0.4e1 / 0.3e1 * t290 * t206);
  t296 = t286 / 0.2e1 + t294 / 0.2e1;
  t299 = -0.12e2 * t197 * t276 - 0.6e1 * t95 * t296 + t175 - t180 + t193 - 0.6e1 * t195 - 0.6e1 * t274;
  t300 = t9 * t299;
  t303 = t163 * t152;
  t305 = t133 * t152;
  t310 = t299 * t119;
  t312 = t147 * t2;
  t313 = t118 * t312;
  t314 = t313 * t129;
  t317 = 0.2e1 * t238 * t150 * t112 - t118 * t310 + 0.7e1 / 0.144e3 * t314 + 0.7e1 / 0.144e3 * t247 + t255 - t268;
  t318 = t72 * t317;
  tv2rho21 = t113 * t153 + t115 * t305 + t115 * t318 + t148 * t133 + t300 * t72 + t161 + t164 + t272 + t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t323 = t144 * t144;
  t326 = t135 * t135;
  t330 = 0.2e1 * t97 + 0.2e1 * t207;
  t334 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t326 + 0.2e1 / 0.3e1 * t96 * t330);
  t335 = t139 * t139;
  t338 = -t330;
  t342 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t335 + 0.2e1 / 0.3e1 * t103 * t338);
  t344 = t334 / 0.2e1 + t342 / 0.2e1;
  t347 = -0.12e2 * t197 * t323 - 0.6e1 * t95 * t344 + t175 - t180 + t193 - 0.12e2 * t274;
  t348 = t9 * t347;
  t352 = t152 * t152;
  t353 = t72 * t352;
  t355 = t147 * t147;
  t356 = t355 * t119;
  t359 = t347 * t119;
  t362 = 0.2e1 * t238 * t356 - t118 * t359 + 0.7e1 / 0.72e2 * t314 + t255 - t268;
  t363 = t72 * t362;
  tv2rho22 = t115 * t353 + t115 * t363 + 0.2e1 * t148 * t153 + t348 * t72 + 0.2e1 * t272 + 0.2e1 * t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t365 = t63 * t72;
  t367 = t365 * params->h * t159;
  t368 = t367 / 0.36e2;
  t372 = params->h * t2 * t59 * t127;
  t373 = t157 * t132 * t372;
  t377 = 0.1e1 / t19 / t249 * t72;
  t378 = t377 * params->h;
  t379 = t1 * t257;
  t381 = t379 * t264 * t65;
  t382 = t378 * t381;
  t383 = 0.7e1 / 0.2304e4 * t382;
  tv2rhosigma0 = -t368 + t373 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t384 = t367 / 0.18e2;
  t386 = 0.7e1 / 0.1152e4 * t382;
  tv2rhosigma1 = -t384 + t373 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t388 = t157 * t152 * t372;
  tv2rhosigma3 = -t368 + t388 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t384 + t388 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t392 = 0.1e1 / t19 / t123;
  t393 = t392 * t72;
  t394 = params->h * params->h;
  t397 = t257 * t264;
  t398 = t70 * t1 * t397;
  t401 = t379 * t264;
  t403 = t393 * t394 * t398 - t393 * params->h * t401;
  tv2sigma20 = t403 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = t403 / 0.384e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = t403 / 0.192e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t44;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t56, t58, t59, t60, t61, t63, t65, t69;
  double t70, t71, t72, tzk0;

  double t74, t78, t81, t83, t84, t89, t91, t93;
  double t94, t95, t96, t97, t98, t99, t102, t103;
  double t104, t107, t109, t112, t113, t115, t116, t117;
  double t118, t119, t120, t122, t123, t125, t126, t127;
  double t128, t129, t131, t132, t133, tvrho0, t135, t138;
  double t139, t142, t144, t147, t148, t150, t152, t153;
  double tvrho1, t156, t157, t159, t160, tvsigma0, tvsigma1, tvsigma2;

  double t161, t163, t164, t168, t170, t173, t174, t175;
  double t176, t178, t179, t180, t184, t185, t187, t189;
  double t190, t192, t193, t194, t195, t197, t198, t202;
  double t203, t206, t207, t209, t213, t215, t216, t219;
  double t223, t225, t228, t229, t233, t234, t237, t238;
  double t239, t240, t245, t246, t247, t249, t251, t252;
  double t253, t255, t256, t257, t258, t260, t261, t262;
  double t263, t264, t265, t266, t268, t269, t270, tv2rho20;
  double t272, t274, t276, t279, t282, t286, t287, t290;
  double t294, t296, t299, t300, t303, t305, t310, t312;
  double t313, t314, t317, t318, tv2rho21, t323, t326, t330;
  double t334, t335, t338, t342, t344, t347, t348, t352;
  double t353, t355, t356, t359, t362, t363, tv2rho22, t365;
  double t367, t368, t372, t373, t377, t378, t379, t381;
  double t382, t383, tv2rhosigma0, t384, t386, tv2rhosigma1, tv2rhosigma2, t388;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t392, t393, t394, t397, t398;
  double t401, t403, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t404, t406, t408, t410, t414, t417, t421, t422;
  double t423, t425, t429, t431, t437, t439, t445, t448;
  double t449, t450, t451, t453, t454, t456, t458, t461;
  double t464, t466, t467, t470, t473, t474, t476, t480;
  double t481, t483, t484, t487, t490, t494, t496, t499;
  double t500, t508, t509, t511, t514, t516, t517, t521;
  double t525, t526, t531, t532, t534, t537, t538, t540;
  double t544, t546, t547, t551, t553, t554, t555, t556;
  double t557, t558, t561, t564, t565, t566, tv3rho30, t571;
  double t573, t580, t583, t584, t585, t587, t594, t597;
  double t599, t600, t603, t606, t609, t612, t623, t624;
  double t627, t638, t640, t643, t644, t646, t647, t649;
  double t650, t652, t653, t654, t660, t661, t663, t668;
  double t670, t675, t676, t679, t681, t682, t683, tv3rho31;
  double t684, t687, t689, t692, t695, t697, t700, t705;
  double t710, t714, t715, t720, t723, t727, t729, t732;
  double t733, t736, t744, t746, t748, t751, t753, t761;
  double t762, t763, t765, t768, t770, t771, t772, t778;
  double t779, tv3rho32, t788, t791, t794, t800, t804, t805;
  double t810, t814, t816, t819, t820, t828, t829, t831;
  double t834, t835, t842, t847, t848, tv3rho33, t850, t852;
  double t853, t855, t856, t859, t860, t861, t862, t864;
  double t867, t869, t871, t872, t874, t875, t876, t877;
  double t878, t879, tv3rho2sigma0, t880, t882, t886, tv3rho2sigma1, tv3rho2sigma2;
  double t889, t892, t895, t897, t899, tv3rho2sigma3, t902, t905;
  double tv3rho2sigma4, tv3rho2sigma5, t907, t910, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8, t917;
  double t918, t919, t920, t921, t923, t924, t926, t927;
  double t930, t931, t932, t933, t934, t935, t936, t937;
  double t938, t940, t941, t942, t945, t946, t947, tv3rhosigma20;
  double t948, t951, t952, t954, tv3rhosigma21, tv3rhosigma22, t955, t958;
  double t959, t961, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t962, t963, t964;
  double t966, t967, t968, t971, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, tv3rhosigma211, t979, t980, t981, t982, t983, t984;
  double t985, t987, t988, t989, t991, t992, t993, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double tv3sigma39;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * t41;
  t43 = POW_1_3(t39);
  t44 = t43 * t43;
  t45 = my_piecewise3(t40, t42, t44);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t49 = t48 * t48;
  t50 = my_piecewise3(t47, t42, t49);
  t52 = t45 / 0.2e1 + t50 / 0.2e1;
  t53 = t52 * t52;
  t56 = -0.2e1 * t53 * t52 + 0.2e1;
  t58 = t35 * t56 + t25;
  t59 = M_CBRTPI;
  t60 = t2 * t59;
  t61 = t9 * t9;
  t63 = 0.1e1 / t10 / t61;
  t65 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t69 = 0.1e1 + t60 * t63 * t65 / 0.48e2;
  t70 = 0.1e1 / t58;
  t71 = params->h * t70;
  t72 = pow(t69, t71);
  tzk0 = t58 * t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t8 / t19;
  t78 = t18 / t10;
  t81 = t3 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t78;
  t83 = 0.1e1 / t23;
  t84 = params->ap * t81 * t83;
  t89 = t26 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t78;
  t91 = 0.1e1 / t32;
  t93 = params->af * t89 * t91 - t84;
  t94 = t93 * t56;
  t95 = t35 * t53;
  t96 = 0.1e1 / t43;
  t97 = 0.1e1 / t61;
  t98 = t36 * t97;
  t99 = t37 - t98;
  t102 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t99);
  t103 = 0.1e1 / t48;
  t104 = -t99;
  t107 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t104);
  t109 = t102 / 0.2e1 + t107 / 0.2e1;
  t112 = -0.6e1 * t95 * t109 + t84 + t94;
  t113 = t9 * t112;
  t115 = t9 * t58;
  t116 = t58 * t58;
  t117 = 0.1e1 / t116;
  t118 = params->h * t117;
  t119 = log(t69);
  t120 = t112 * t119;
  t122 = t71 * t2;
  t123 = t61 * t9;
  t125 = 0.1e1 / t10 / t123;
  t126 = t59 * t125;
  t127 = 0.1e1 / t69;
  t128 = t65 * t127;
  t129 = t126 * t128;
  t131 = 0.7e1 / 0.144e3 * t122 * t129;
  t132 = -t118 * t120 - t131;
  t133 = t72 * t132;
  tvrho0 = t113 * t72 + t115 * t133 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t135 = -t37 - t98;
  t138 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t135);
  t139 = -t135;
  t142 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t139);
  t144 = t138 / 0.2e1 + t142 / 0.2e1;
  t147 = -0.6e1 * t95 * t144 + t84 + t94;
  t148 = t9 * t147;
  t150 = t147 * t119;
  t152 = -t118 * t150 - t131;
  t153 = t72 * t152;
  tvrho1 = t115 * t153 + t148 * t72 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t156 = 0.1e1 / t10 / t9;
  t157 = t156 * t72;
  t159 = t60 * t127;
  t160 = t157 * params->h * t159;
  tvsigma0 = t160 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = t160 / 0.24e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t161 = t112 * t72;
  t163 = t58 * t72;
  t164 = t163 * t132;
  t168 = t8 / t19 / t9;
  t170 = t18 * t156;
  t173 = -0.2e1 / 0.27e2 * t14 * t170 - 0.2e1 / 0.27e2 * t3 * t168;
  t174 = params->ap * t173;
  t175 = t174 * t83;
  t176 = t81 * t81;
  t178 = t23 * t23;
  t179 = 0.1e1 / t178;
  t180 = params->ap * t176 * t179;
  t184 = -0.2e1 / 0.27e2 * t26 * t168 - 0.2e1 / 0.27e2 * t29 * t170;
  t185 = params->af * t184;
  t187 = t89 * t89;
  t189 = t32 * t32;
  t190 = 0.1e1 / t189;
  t192 = -params->af * t187 * t190 + t185 * t91 - t175 + t180;
  t193 = t192 * t56;
  t194 = t93 * t53;
  t195 = t194 * t109;
  t197 = t35 * t52;
  t198 = t109 * t109;
  t202 = 0.1e1 / t43 / t39;
  t203 = t99 * t99;
  t206 = 0.1e1 / t123;
  t207 = t36 * t206;
  t209 = -0.2e1 * t97 + 0.2e1 * t207;
  t213 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t203 + 0.2e1 / 0.3e1 * t96 * t209);
  t215 = 0.1e1 / t48 / t46;
  t216 = t104 * t104;
  t219 = -t209;
  t223 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t216 + 0.2e1 / 0.3e1 * t103 * t219);
  t225 = t213 / 0.2e1 + t223 / 0.2e1;
  t228 = -0.12e2 * t197 * t198 - 0.6e1 * t95 * t225 + t175 - t180 + t193 - 0.12e2 * t195;
  t229 = t9 * t228;
  t233 = t132 * t132;
  t234 = t72 * t233;
  t237 = 0.1e1 / t116 / t58;
  t238 = params->h * t237;
  t239 = t112 * t112;
  t240 = t239 * t119;
  t245 = t112 * t2;
  t246 = t118 * t245;
  t247 = t246 * t129;
  t249 = t61 * t61;
  t251 = 0.1e1 / t10 / t249;
  t252 = t59 * t251;
  t253 = t252 * t128;
  t255 = 0.35e2 / 0.216e3 * t122 * t253;
  t256 = t71 * t1;
  t257 = t59 * t59;
  t258 = t249 * t61;
  t260 = 0.1e1 / t19 / t258;
  t261 = t257 * t260;
  t262 = t65 * t65;
  t263 = t69 * t69;
  t264 = 0.1e1 / t263;
  t265 = t262 * t264;
  t266 = t261 * t265;
  t268 = 0.49e2 / 0.6912e4 * t256 * t266;
  t269 = 0.2e1 * t238 * t240 - t118 * t228 * t119 + 0.7e1 / 0.72e2 * t247 + t255 - t268;
  t270 = t72 * t269;
  tv2rho20 = 0.2e1 * t113 * t133 + t115 * t234 + t115 * t270 + t229 * t72 + 0.2e1 * t161 + 0.2e1 * t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t147 * t72;
  t274 = t194 * t144;
  t276 = t144 * t109;
  t279 = t202 * t135;
  t282 = t96 * t36;
  t286 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t279 * t99 + 0.4e1 / 0.3e1 * t282 * t206);
  t287 = t215 * t139;
  t290 = t103 * t36;
  t294 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t287 * t104 - 0.4e1 / 0.3e1 * t290 * t206);
  t296 = t286 / 0.2e1 + t294 / 0.2e1;
  t299 = -0.12e2 * t197 * t276 - 0.6e1 * t95 * t296 + t175 - t180 + t193 - 0.6e1 * t195 - 0.6e1 * t274;
  t300 = t9 * t299;
  t303 = t163 * t152;
  t305 = t133 * t152;
  t310 = t299 * t119;
  t312 = t147 * t2;
  t313 = t118 * t312;
  t314 = t313 * t129;
  t317 = 0.2e1 * t238 * t150 * t112 - t118 * t310 + 0.7e1 / 0.144e3 * t314 + 0.7e1 / 0.144e3 * t247 + t255 - t268;
  t318 = t72 * t317;
  tv2rho21 = t113 * t153 + t115 * t305 + t115 * t318 + t148 * t133 + t300 * t72 + t161 + t164 + t272 + t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t323 = t144 * t144;
  t326 = t135 * t135;
  t330 = 0.2e1 * t97 + 0.2e1 * t207;
  t334 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t326 + 0.2e1 / 0.3e1 * t96 * t330);
  t335 = t139 * t139;
  t338 = -t330;
  t342 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t335 + 0.2e1 / 0.3e1 * t103 * t338);
  t344 = t334 / 0.2e1 + t342 / 0.2e1;
  t347 = -0.12e2 * t197 * t323 - 0.6e1 * t95 * t344 + t175 - t180 + t193 - 0.12e2 * t274;
  t348 = t9 * t347;
  t352 = t152 * t152;
  t353 = t72 * t352;
  t355 = t147 * t147;
  t356 = t355 * t119;
  t359 = t347 * t119;
  t362 = 0.2e1 * t238 * t356 - t118 * t359 + 0.7e1 / 0.72e2 * t314 + t255 - t268;
  t363 = t72 * t362;
  tv2rho22 = t115 * t353 + t115 * t363 + 0.2e1 * t148 * t153 + t348 * t72 + 0.2e1 * t272 + 0.2e1 * t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t365 = t63 * t72;
  t367 = t365 * params->h * t159;
  t368 = t367 / 0.36e2;
  t372 = params->h * t2 * t59 * t127;
  t373 = t157 * t132 * t372;
  t377 = 0.1e1 / t19 / t249 * t72;
  t378 = t377 * params->h;
  t379 = t1 * t257;
  t381 = t379 * t264 * t65;
  t382 = t378 * t381;
  t383 = 0.7e1 / 0.2304e4 * t382;
  tv2rhosigma0 = -t368 + t373 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t384 = t367 / 0.18e2;
  t386 = 0.7e1 / 0.1152e4 * t382;
  tv2rhosigma1 = -t384 + t373 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t388 = t157 * t152 * t372;
  tv2rhosigma3 = -t368 + t388 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t384 + t388 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t392 = 0.1e1 / t19 / t123;
  t393 = t392 * t72;
  t394 = params->h * params->h;
  t397 = t257 * t264;
  t398 = t70 * t1 * t397;
  t401 = t379 * t264;
  t403 = t393 * t394 * t398 - t393 * params->h * t401;
  tv2sigma20 = t403 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = t403 / 0.384e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = t403 / 0.192e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t404 = t228 * t72;
  t406 = t161 * t132;
  t408 = t163 * t233;
  t410 = t163 * t269;
  t414 = t8 / t19 / t61;
  t417 = t18 * t63;
  t421 = params->ap * (0.1e2 / 0.81e2 * t3 * t414 + 0.8e1 / 0.81e2 * t14 * t417);
  t422 = t421 * t83;
  t423 = t179 * t81;
  t425 = 0.3e1 * t174 * t423;
  t429 = 0.1e1 / t178 / t23;
  t431 = 0.2e1 * params->ap * t176 * t81 * t429;
  t437 = params->af * (0.1e2 / 0.81e2 * t26 * t414 + 0.8e1 / 0.81e2 * t29 * t417);
  t439 = t190 * t89;
  t445 = 0.1e1 / t189 / t32;
  t448 = 0.2e1 * params->af * t187 * t89 * t445 - 0.3e1 * t185 * t439 + t437 * t91 - t422 + t425 - t431;
  t449 = t448 * t56;
  t450 = t192 * t53;
  t451 = t450 * t109;
  t453 = t93 * t52;
  t454 = t453 * t198;
  t456 = t194 * t225;
  t458 = t198 * t109;
  t461 = t109 * t225;
  t464 = t39 * t39;
  t466 = 0.1e1 / t43 / t464;
  t467 = t203 * t99;
  t470 = t202 * t99;
  t473 = 0.1e1 / t249;
  t474 = t36 * t473;
  t476 = 0.6e1 * t206 - 0.6e1 * t474;
  t480 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t466 * t467 - 0.2e1 / 0.3e1 * t470 * t209 + 0.2e1 / 0.3e1 * t96 * t476);
  t481 = t46 * t46;
  t483 = 0.1e1 / t48 / t481;
  t484 = t216 * t104;
  t487 = t215 * t104;
  t490 = -t476;
  t494 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t483 * t484 - 0.2e1 / 0.3e1 * t487 * t219 + 0.2e1 / 0.3e1 * t103 * t490);
  t496 = t480 / 0.2e1 + t494 / 0.2e1;
  t499 = -0.36e2 * t197 * t461 - 0.12e2 * t35 * t458 - 0.6e1 * t95 * t496 + t422 - t425 + t431 + t449 - 0.18e2 * t451 - 0.36e2 * t454 - 0.18e2 * t456;
  t500 = t9 * t499;
  t508 = t233 * t132;
  t509 = t72 * t508;
  t511 = t133 * t269;
  t514 = t116 * t116;
  t516 = params->h / t514;
  t517 = t239 * t112;
  t521 = t120 * t228;
  t525 = t238 * t239 * t2;
  t526 = t525 * t129;
  t531 = t118 * t228 * t2;
  t532 = t531 * t129;
  t534 = t246 * t253;
  t537 = t118 * t112 * t1;
  t538 = t537 * t266;
  t540 = t249 * t9;
  t544 = t59 / t10 / t540 * t128;
  t546 = 0.455e3 / 0.648e3 * t122 * t544;
  t547 = t249 * t123;
  t551 = t257 / t19 / t547 * t265;
  t553 = 0.245e3 / 0.3456e4 * t256 * t551;
  t554 = t71 * M_PI;
  t555 = t249 * t249;
  t556 = t555 * t61;
  t557 = 0.1e1 / t556;
  t558 = t262 * t65;
  t561 = 0.1e1 / t263 / t69;
  t564 = 0.343e3 / 0.165888e6 * t554 * t557 * t558 * t561;
  t565 = -0.6e1 * t516 * t517 * t119 + 0.6e1 * t238 * t521 - 0.7e1 / 0.24e2 * t526 - t118 * t499 * t119 + 0.7e1 / 0.48e2 * t532 - 0.35e2 / 0.72e2 * t534 + 0.49e2 / 0.2304e4 * t538 - t546 + t553 - t564;
  t566 = t72 * t565;
  tv3rho30 = 0.3e1 * t113 * t234 + 0.3e1 * t113 * t270 + t115 * t509 + 0.3e1 * t115 * t511 + t115 * t566 + 0.3e1 * t229 * t133 + t500 * t72 + 0.3e1 * t404 + 0.6e1 * t406 + 0.3e1 * t408 + 0.3e1 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t571 = t132 * t152;
  t573 = 0.2e1 * tzk0 * t571;
  t580 = t310 * t112;
  t583 = t238 * t312;
  t584 = t128 * t112;
  t585 = t126 * t584;
  t587 = 0.7e1 / 0.36e2 * t583 * t585;
  t594 = t450 * t144;
  t597 = 0.24e2 * t453 * t276;
  t599 = 0.12e2 * t194 * t296;
  t600 = t35 * t198;
  t603 = t296 * t109;
  t606 = t144 * t225;
  t609 = t466 * t135;
  t612 = t202 * t36;
  t623 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t609 * t203 - 0.8e1 / 0.9e1 * t612 * t206 * t99 - 0.2e1 / 0.9e1 * t279 * t209 + 0.4e1 / 0.3e1 * t96 * t206 - 0.4e1 * t282 * t473);
  t624 = t483 * t139;
  t627 = t215 * t36;
  t638 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t624 * t216 + 0.8e1 / 0.9e1 * t627 * t206 * t104 - 0.2e1 / 0.9e1 * t287 * t219 - 0.4e1 / 0.3e1 * t103 * t206 + 0.4e1 * t290 * t473);
  t640 = t623 / 0.2e1 + t638 / 0.2e1;
  t643 = -0.12e2 * t600 * t144 - 0.24e2 * t197 * t603 - 0.12e2 * t197 * t606 - 0.6e1 * t95 * t640 + t422 - t425 + t431 + t449 - 0.12e2 * t451 - 0.12e2 * t454 - 0.6e1 * t456 - 0.6e1 * t594 - t597 - t599;
  t644 = t643 * t119;
  t646 = t299 * t2;
  t647 = t118 * t646;
  t649 = 0.7e1 / 0.72e2 * t647 * t129;
  t650 = t313 * t253;
  t652 = t147 * t1;
  t653 = t118 * t652;
  t654 = t653 * t266;
  t660 = -0.6e1 * t516 * t150 * t239 + 0.4e1 * t238 * t580 - t587 + 0.2e1 * t238 * t150 * t228 - t118 * t644 + t649 - 0.35e2 / 0.216e3 * t650 + 0.49e2 / 0.6912e4 * t654 - 0.7e1 / 0.72e2 * t526 + 0.7e1 / 0.144e3 * t532 - 0.35e2 / 0.108e3 * t534 + 0.49e2 / 0.3456e4 * t538 - t546 + t553 - t564;
  t661 = t72 * t660;
  t663 = t234 * t152;
  t668 = t270 * t152;
  t670 = t133 * t317;
  t675 = 0.2e1 * t272 * t132;
  t676 = t9 * t643;
  t679 = 0.2e1 * t161 * t152;
  t681 = 0.2e1 * t163 * t317;
  t682 = t299 * t72;
  t683 = 0.2e1 * t682;
  tv3rho31 = 0.2e1 * t113 * t305 + 0.2e1 * t113 * t318 + t115 * t661 + t115 * t663 + t115 * t668 + 0.2e1 * t115 * t670 + 0.2e1 * t300 * t133 + t148 * t234 + t148 * t270 + t229 * t153 + t676 * t72 + t404 + 0.2e1 * t406 + t408 + t410 + t573 + t675 + t679 + t681 + t683;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t684 = t347 * t72;
  t687 = t453 * t323;
  t689 = t35 * t109;
  t692 = t144 * t296;
  t695 = t194 * t344;
  t697 = t344 * t109;
  t700 = t466 * t326;
  t705 = t202 * t330;
  t710 = -0.2e1 * t206 - 0.6e1 * t474;
  t714 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t700 * t99 - 0.8e1 / 0.9e1 * t279 * t207 - 0.2e1 / 0.9e1 * t705 * t99 + 0.2e1 / 0.3e1 * t96 * t710);
  t715 = t483 * t335;
  t720 = t215 * t338;
  t723 = -t710;
  t727 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t715 * t104 + 0.8e1 / 0.9e1 * t287 * t207 - 0.2e1 / 0.9e1 * t720 * t104 + 0.2e1 / 0.3e1 * t103 * t723);
  t729 = t714 / 0.2e1 + t727 / 0.2e1;
  t732 = -0.24e2 * t197 * t692 - 0.12e2 * t197 * t697 - 0.12e2 * t689 * t323 - 0.6e1 * t95 * t729 + t422 - t425 + t431 + t449 - 0.6e1 * t451 - 0.12e2 * t594 - t597 - t599 - 0.12e2 * t687 - 0.6e1 * t695;
  t733 = t9 * t732;
  t736 = t272 * t152;
  t744 = t163 * t352;
  t746 = t133 * t352;
  t748 = t153 * t317;
  t751 = t163 * t362;
  t753 = t133 * t362;
  t761 = t355 * t2;
  t762 = t238 * t761;
  t763 = t762 * t129;
  t765 = t359 * t112;
  t768 = t732 * t119;
  t770 = t347 * t2;
  t771 = t118 * t770;
  t772 = t771 * t129;
  t778 = -0.6e1 * t516 * t356 * t112 + 0.4e1 * t238 * t150 * t299 - 0.7e1 / 0.72e2 * t763 + 0.2e1 * t238 * t765 - t118 * t768 + 0.7e1 / 0.144e3 * t772 - t587 + t649 - 0.35e2 / 0.108e3 * t650 + 0.49e2 / 0.3456e4 * t654 - 0.35e2 / 0.216e3 * t534 - t546 + t553 + 0.49e2 / 0.6912e4 * t538 - t564;
  t779 = t72 * t778;
  tv3rho32 = t113 * t353 + t113 * t363 + t115 * t746 + 0.2e1 * t115 * t748 + t115 * t753 + t115 * t779 + t348 * t133 + 0.2e1 * t148 * t305 + 0.2e1 * t148 * t318 + 0.2e1 * t300 * t153 + t733 * t72 + t573 + t675 + t679 + t681 + t683 + t684 + 0.2e1 * t736 + t744 + t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t788 = t323 * t144;
  t791 = t144 * t344;
  t794 = t326 * t135;
  t800 = -0.6e1 * t206 - 0.6e1 * t474;
  t804 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t466 * t794 - 0.2e1 / 0.3e1 * t279 * t330 + 0.2e1 / 0.3e1 * t96 * t800);
  t805 = t335 * t139;
  t810 = -t800;
  t814 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t483 * t805 - 0.2e1 / 0.3e1 * t287 * t338 + 0.2e1 / 0.3e1 * t103 * t810);
  t816 = t804 / 0.2e1 + t814 / 0.2e1;
  t819 = -0.36e2 * t197 * t791 - 0.12e2 * t35 * t788 - 0.6e1 * t95 * t816 + t422 - t425 + t431 + t449 - 0.18e2 * t594 - 0.36e2 * t687 - 0.18e2 * t695;
  t820 = t9 * t819;
  t828 = t352 * t152;
  t829 = t72 * t828;
  t831 = t153 * t362;
  t834 = t355 * t147;
  t835 = t834 * t119;
  t842 = t819 * t119;
  t847 = -0.6e1 * t516 * t835 + 0.6e1 * t238 * t150 * t347 - 0.7e1 / 0.24e2 * t763 - t118 * t842 + 0.7e1 / 0.48e2 * t772 - 0.35e2 / 0.72e2 * t650 + 0.49e2 / 0.2304e4 * t654 - t546 + t553 - t564;
  t848 = t72 * t847;
  tv3rho33 = t115 * t829 + 0.3e1 * t115 * t831 + t115 * t848 + 0.3e1 * t148 * t353 + 0.3e1 * t148 * t363 + 0.3e1 * t348 * t153 + t820 * t72 + 0.3e1 * t684 + 0.6e1 * t736 + 0.3e1 * t744 + 0.3e1 * t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t850 = t125 * t72;
  t852 = t850 * params->h * t159;
  t853 = 0.7e1 / 0.108e3 * t852;
  t855 = t365 * t132 * t372;
  t856 = t855 / 0.18e2;
  t859 = 0.1e1 / t19 / t540 * t72;
  t860 = t859 * params->h;
  t861 = t860 * t381;
  t862 = 0.7e1 / 0.384e3 * t861;
  t864 = t157 * t233 * t372;
  t867 = t157 * t269 * t372;
  t869 = t132 * params->h;
  t871 = t377 * t869 * t381;
  t872 = 0.7e1 / 0.1152e4 * t871;
  t874 = 0.1e1 / t555 * t72;
  t875 = t874 * params->h;
  t876 = M_PI * t561;
  t877 = t876 * t262;
  t878 = t875 * t877;
  t879 = 0.49e2 / 0.55296e5 * t878;
  tv3rho2sigma0 = t853 - t856 - t862 + t864 / 0.48e2 + t867 / 0.48e2 + t872 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t880 = 0.7e1 / 0.54e2 * t852;
  t882 = 0.7e1 / 0.192e3 * t861;
  t886 = 0.49e2 / 0.27648e5 * t878;
  tv3rho2sigma1 = t880 - t855 / 0.9e1 - t882 + t864 / 0.24e2 + t867 / 0.24e2 + 0.7e1 / 0.576e3 * t871 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t889 = t365 * t152 * t372;
  t892 = t157 * t571 * t372;
  t895 = t157 * t317 * t372;
  t897 = t152 * params->h;
  t899 = t377 * t897 * t381;
  tv3rho2sigma3 = t853 - t855 / 0.36e2 - t862 - t889 / 0.36e2 + t892 / 0.48e2 + t895 / 0.48e2 + 0.7e1 / 0.2304e4 * t899 + 0.7e1 / 0.2304e4 * t871 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t902 = t889 / 0.18e2;
  t905 = 0.7e1 / 0.1152e4 * t899;
  tv3rho2sigma4 = t880 - t856 - t882 - t902 + t892 / 0.24e2 + t895 / 0.24e2 + t905 + t872 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t907 = t157 * t352 * t372;
  t910 = t157 * t362 * t372;
  tv3rho2sigma6 = t853 - t902 - t862 + t907 / 0.48e2 + t910 / 0.48e2 + t905 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t880 - t889 / 0.9e1 - t882 + t907 / 0.24e2 + t910 / 0.24e2 + 0.7e1 / 0.576e3 * t899 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t917 = t377 * t394 * t398;
  t918 = 0.11e2 / 0.2304e4 * t917;
  t919 = t132 * t394;
  t920 = t393 * t919;
  t921 = t920 * t398;
  t923 = t394 * t117;
  t924 = t393 * t923;
  t926 = t379 * t264 * t112;
  t927 = t924 * t926;
  t930 = 0.1e1 / t547 * t72;
  t931 = t930 * t394;
  t932 = t70 * M_PI;
  t933 = t561 * t65;
  t934 = t932 * t933;
  t935 = t931 * t934;
  t936 = 0.7e1 / 0.18432e5 * t935;
  t937 = t378 * t401;
  t938 = 0.11e2 / 0.2304e4 * t937;
  t940 = params->h * t1;
  t941 = t940 * t397;
  t942 = t393 * t132 * t941;
  t945 = t876 * t65;
  t946 = t930 * params->h * t945;
  t947 = 0.7e1 / 0.18432e5 * t946;
  tv3rhosigma20 = -t918 + t921 / 0.768e3 - t927 / 0.768e3 + t936 + t938 - t942 / 0.768e3 - t947;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t948 = 0.11e2 / 0.1152e4 * t917;
  t951 = 0.7e1 / 0.9216e4 * t935;
  t952 = 0.11e2 / 0.1152e4 * t937;
  t954 = 0.7e1 / 0.9216e4 * t946;
  tv3rhosigma21 = -t948 + t921 / 0.384e3 - t927 / 0.384e3 + t951 + t952 - t942 / 0.384e3 - t954;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t955 = 0.11e2 / 0.576e3 * t917;
  t958 = 0.7e1 / 0.4608e4 * t935;
  t959 = 0.11e2 / 0.576e3 * t937;
  t961 = 0.7e1 / 0.4608e4 * t946;
  tv3rhosigma23 = -t955 + t921 / 0.192e3 - t927 / 0.192e3 + t958 + t959 - t942 / 0.192e3 - t961;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t962 = t152 * t394;
  t963 = t393 * t962;
  t964 = t963 * t398;
  t966 = t264 * t147;
  t967 = t379 * t966;
  t968 = t924 * t967;
  t971 = t393 * t152 * t941;
  tv3rhosigma26 = -t918 + t964 / 0.768e3 - t968 / 0.768e3 + t936 + t938 - t971 / 0.768e3 - t947;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = -t948 + t964 / 0.384e3 - t968 / 0.384e3 + t951 + t952 - t971 / 0.384e3 - t954;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = -t955 + t964 / 0.192e3 - t968 / 0.192e3 + t958 + t959 - t971 / 0.192e3 - t961;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t979 = 0.1e1 / t258;
  t980 = t979 * t72;
  t981 = t394 * params->h;
  t982 = t980 * t981;
  t983 = t117 * M_PI;
  t984 = t983 * t561;
  t985 = t982 * t984;
  t987 = t980 * t394;
  t988 = t932 * t561;
  t989 = t987 * t988;
  t991 = params->h * M_PI;
  t992 = t991 * t561;
  t993 = t980 * t992;
  tv3sigma30 = t985 / 0.12288e5 - t989 / 0.4096e4 + t993 / 0.6144e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = t985 / 0.6144e4 - t989 / 0.2048e4 + t993 / 0.3072e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = t985 / 0.3072e4 - t989 / 0.1024e4 + t993 / 0.1536e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = t985 / 0.1536e4 - t989 / 0.512e3 + t993 / 0.768e3;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t7, t8, t9, t10;
  double t11, t14, t15, t17, t18, t19, t20, t23;
  double t24, t25, t26, t29, t32, t33, t35, t36;
  double t37, t38, t39, t40, t41, t42, t43, t44;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t56, t58, t59, t60, t61, t63, t65, t69;
  double t70, t71, t72, tzk0;

  double t74, t78, t81, t83, t84, t89, t91, t93;
  double t94, t95, t96, t97, t98, t99, t102, t103;
  double t104, t107, t109, t112, t113, t115, t116, t117;
  double t118, t119, t120, t122, t123, t125, t126, t127;
  double t128, t129, t131, t132, t133, tvrho0, t135, t138;
  double t139, t142, t144, t147, t148, t150, t152, t153;
  double tvrho1, t156, t157, t159, t160, tvsigma0, tvsigma1, tvsigma2;

  double t161, t163, t164, t168, t170, t173, t174, t175;
  double t176, t178, t179, t180, t184, t185, t187, t189;
  double t190, t192, t193, t194, t195, t197, t198, t202;
  double t203, t206, t207, t209, t213, t215, t216, t219;
  double t223, t225, t228, t229, t233, t234, t237, t238;
  double t239, t240, t245, t246, t247, t249, t251, t252;
  double t253, t255, t256, t257, t258, t260, t261, t262;
  double t263, t264, t265, t266, t268, t269, t270, tv2rho20;
  double t272, t274, t276, t279, t282, t286, t287, t290;
  double t294, t296, t299, t300, t303, t305, t310, t312;
  double t313, t314, t317, t318, tv2rho21, t323, t326, t330;
  double t334, t335, t338, t342, t344, t347, t348, t352;
  double t353, t355, t356, t359, t362, t363, tv2rho22, t365;
  double t367, t368, t372, t373, t377, t378, t379, t381;
  double t382, t383, tv2rhosigma0, t384, t386, tv2rhosigma1, tv2rhosigma2, t388;
  double tv2rhosigma3, tv2rhosigma4, tv2rhosigma5, t392, t393, t394, t397, t398;
  double t401, t403, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, tv2sigma25;

  double t404, t406, t408, t410, t414, t417, t421, t422;
  double t423, t425, t429, t431, t437, t439, t445, t448;
  double t449, t450, t451, t453, t454, t456, t458, t461;
  double t464, t466, t467, t470, t473, t474, t476, t480;
  double t481, t483, t484, t487, t490, t494, t496, t499;
  double t500, t508, t509, t511, t514, t516, t517, t521;
  double t525, t526, t531, t532, t534, t537, t538, t540;
  double t544, t546, t547, t551, t553, t554, t555, t556;
  double t557, t558, t561, t564, t565, t566, tv3rho30, t571;
  double t573, t580, t583, t584, t585, t587, t594, t597;
  double t599, t600, t603, t606, t609, t612, t623, t624;
  double t627, t638, t640, t643, t644, t646, t647, t649;
  double t650, t652, t653, t654, t660, t661, t663, t668;
  double t670, t675, t676, t679, t681, t682, t683, tv3rho31;
  double t684, t687, t689, t692, t695, t697, t700, t705;
  double t710, t714, t715, t720, t723, t727, t729, t732;
  double t733, t736, t744, t746, t748, t751, t753, t761;
  double t762, t763, t765, t768, t770, t771, t772, t778;
  double t779, tv3rho32, t788, t791, t794, t800, t804, t805;
  double t810, t814, t816, t819, t820, t828, t829, t831;
  double t834, t835, t842, t847, t848, tv3rho33, t850, t852;
  double t853, t855, t856, t859, t860, t861, t862, t864;
  double t867, t869, t871, t872, t874, t875, t876, t877;
  double t878, t879, tv3rho2sigma0, t880, t882, t886, tv3rho2sigma1, tv3rho2sigma2;
  double t889, t892, t895, t897, t899, tv3rho2sigma3, t902, t905;
  double tv3rho2sigma4, tv3rho2sigma5, t907, t910, tv3rho2sigma6, tv3rho2sigma7, tv3rho2sigma8, t917;
  double t918, t919, t920, t921, t923, t924, t926, t927;
  double t930, t931, t932, t933, t934, t935, t936, t937;
  double t938, t940, t941, t942, t945, t946, t947, tv3rhosigma20;
  double t948, t951, t952, t954, tv3rhosigma21, tv3rhosigma22, t955, t958;
  double t959, t961, tv3rhosigma23, tv3rhosigma24, tv3rhosigma25, t962, t963, t964;
  double t966, t967, t968, t971, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, tv3rhosigma211, t979, t980, t981, t982, t983, t984;
  double t985, t987, t988, t989, t991, t992, t993, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double tv3sigma39;

  double t1004, t1007, t1009, t1018, t1019, t1022, t1023, t1025;
  double t1028, t1029, t1030, t1032, t1034, t1040, t1043, t1048;
  double t1049, t1050, t1052, t1054, t1056, t1062, t1063, t1069;
  double t1074, t1075, t1077, t1081, t1084, t1085, t1091, t1100;
  double t1107, t1120, t1124, t1126, t1131, t1132, t1137, t1141;
  double t1145, t1149, t1151, t1158, t1162, t1163, t1170, t1171;
  double t1176, t1178, t1179, t1180, t1183, t1186, t1187, t1189;
  double t1191, t1193, t1195, t1200, t1203, t1204, t1211, t1218;
  double t1221, t1223, t1225, t1238, t1241, t1248, tv4rho40, t1250;
  double t1252, t1255, t1258, t1259, t1260, t1262, t1276, t1278;
  double t1280, t1282, t1283, t1284, t1312, t1314, t1339, t1341;
  double t1350, t1351, t1354, t1373, t1384, t1387, t1391, t1392;
  double t1393, t1395, t1396, t1397, t1401, t1407, t1410, t1412;
  double t1417, t1418, t1420, t1421, t1422, t1430, t1431, t1435;
  double t1437, t1438, t1440, t1441, t1446, t1448, t1472, t1479;
  double t1481, t1487, tv4rho41, t1493, t1505, t1518, t1535, t1561;
  double t1566, t1569, t1574, t1576, t1583, t1590, t1591, t1606;
  double t1609, t1610, t1633, t1635, t1644, t1651, t1655, t1659;
  double t1664, t1668, t1671, t1678, t1682, t1686, t1687, t1690;
  double t1691, t1698, t1704, t1712, t1723, t1732, t1733, t1739;
  double t1741, t1743, t1745, t1747, t1756, tv4rho42, t1758, t1781;
  double t1785, t1806, t1811, t1814, t1818, t1819, t1822, t1836;
  double t1837, t1840, t1849, t1871, t1875, t1904, t1908, t1918;
  double t1929, t1937, t1946, t1948, t1950, t1952, tv4rho43, t1965;
  double t1978, t1983, t1989, t1993, t1994, t1999, t2008, t2013;
  double t2026, t2033, t2040, t2053, t2056, tv4rho44, t2067, t2070;
  double t2075, t2078, t2082, t2086, t2090, t2091, t2093, t2097;
  double t2098, t2100, t2103, t2107, t2108, t2114, t2117, t2118;
  double t2119, t2123, t2124, tv4rho3sigma0, t2131, t2133, t2137, t2138;
  double tv4rho3sigma1, tv4rho3sigma2, t2140, t2144, t2147, t2148, t2150, t2153;
  double t2156, t2160, t2161, t2162, t2163, t2165, t2167, t2168;
  double t2170, t2173, t2176, t2181, t2182, t2183, tv4rho3sigma3, t2188;
  double t2189, t2190, t2193, t2194, t2198, t2200, t2202, t2203;
  double tv4rho3sigma4, tv4rho3sigma5, t2206, t2208, t2211, t2214, t2218, t2221;
  double t2224, t2226, t2229, t2234, t2236, tv4rho3sigma6, t2245, t2249;
  double tv4rho3sigma7, tv4rho3sigma8, t2258, t2261, t2265, tv4rho3sigma9, tv4rho3sigma10, tv4rho3sigma11;
  double t2278, t2279, t2280, t2281, t2282, t2284, t2285, t2288;
  double t2291, t2292, t2295, t2297, t2300, t2301, t2304, t2305;
  double t2308, t2309, t2310, t2312, t2315, t2316, t2317, t2318;
  double t2320, t2321, t2323, t2326, t2327, t2328, t2330, t2331;
  double t2332, t2334, t2335, t2339, t2342, t2345, t2347, t2348;
  double tv4rho2sigma20, t2349, t2350, t2351, t2353, t2355, t2356, t2358;
  double t2359, t2360, t2362, t2363, t2367, tv4rho2sigma21, tv4rho2sigma22, t2368;
  double t2375, t2377, t2378, t2382, t2386, tv4rho2sigma23, tv4rho2sigma24, tv4rho2sigma25;
  double t2389, t2392, t2396, t2400, t2402, t2403, t2406, t2408;
  double t2414, t2418, t2421, t2424, t2426, t2429, t2433, t2436;
  double t2437, t2439, tv4rho2sigma26, t2441, t2443, t2445, t2446, t2447;
  double t2448, t2450, t2455, tv4rho2sigma27, tv4rho2sigma28, t2457, t2459, t2461;
  double t2462, t2463, t2464, t2466, t2471, tv4rho2sigma29, tv4rho2sigma210, tv4rho2sigma211;
  double t2474, t2478, t2481, t2484, t2486, t2490, t2494, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, tv4rho2sigma217, t2517, t2518, t2519;
  double t2520, t2521, t2522, t2524, t2525, t2527, t2531, t2534;
  double t2535, t2536, t2537, t2538, t2539, t2540, t2543, t2546;
  double t2547, t2548, t2549, t2550, t2553, t2554, tv4rhosigma30, t2555;
  double t2558, t2559, t2562, t2563, t2565, tv4rhosigma31, tv4rhosigma32, t2566;
  double t2569, t2570, t2573, t2574, t2576, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35;
  double t2577, t2580, t2581, t2584, t2585, t2587, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, tv4rhosigma39, t2588, t2589, t2591, t2593, t2595, t2598;
  double t2600, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316;
  double tv4rhosigma317, tv4rhosigma318, tv4rhosigma319, t2619, t2620, t2624, t2629, t2634;
  double t2638, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46;
  double tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, tv4sigma414;

  gga_c_chachiyo_params *params;

  assert(p->params != NULL);
  params = (gga_c_chachiyo_params * )(p->params);

  t1 = M_CBRT3;
  t2 = t1 * t1;
  t3 = params->bp * t2;
  t5 = POW_1_3(0.1e1 / M_PI);
  t7 = M_CBRT4;
  t8 = 0.1e1 / t5 * t7;
  t9 = rho[0] + rho[1];
  t10 = POW_1_3(t9);
  t11 = t8 * t10;
  t14 = params->cp * t1;
  t15 = t5 * t5;
  t17 = t7 * t7;
  t18 = 0.1e1 / t15 * t17;
  t19 = t10 * t10;
  t20 = t18 * t19;
  t23 = 0.1e1 + t3 * t11 / 0.3e1 + t14 * t20 / 0.3e1;
  t24 = log(t23);
  t25 = params->ap * t24;
  t26 = params->bf * t2;
  t29 = params->cf * t1;
  t32 = 0.1e1 + t26 * t11 / 0.3e1 + t29 * t20 / 0.3e1;
  t33 = log(t32);
  t35 = params->af * t33 - t25;
  t36 = rho[0] - rho[1];
  t37 = 0.1e1 / t9;
  t38 = t36 * t37;
  t39 = 0.1e1 + t38;
  t40 = t39 <= p->zeta_threshold;
  t41 = POW_1_3(p->zeta_threshold);
  t42 = t41 * t41;
  t43 = POW_1_3(t39);
  t44 = t43 * t43;
  t45 = my_piecewise3(t40, t42, t44);
  t46 = 0.1e1 - t38;
  t47 = t46 <= p->zeta_threshold;
  t48 = POW_1_3(t46);
  t49 = t48 * t48;
  t50 = my_piecewise3(t47, t42, t49);
  t52 = t45 / 0.2e1 + t50 / 0.2e1;
  t53 = t52 * t52;
  t56 = -0.2e1 * t53 * t52 + 0.2e1;
  t58 = t35 * t56 + t25;
  t59 = M_CBRTPI;
  t60 = t2 * t59;
  t61 = t9 * t9;
  t63 = 0.1e1 / t10 / t61;
  t65 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t69 = 0.1e1 + t60 * t63 * t65 / 0.48e2;
  t70 = 0.1e1 / t58;
  t71 = params->h * t70;
  t72 = pow(t69, t71);
  tzk0 = t58 * t72;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t74 = t8 / t19;
  t78 = t18 / t10;
  t81 = t3 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t14 * t78;
  t83 = 0.1e1 / t23;
  t84 = params->ap * t81 * t83;
  t89 = t26 * t74 / 0.9e1 + 0.2e1 / 0.9e1 * t29 * t78;
  t91 = 0.1e1 / t32;
  t93 = params->af * t89 * t91 - t84;
  t94 = t93 * t56;
  t95 = t35 * t53;
  t96 = 0.1e1 / t43;
  t97 = 0.1e1 / t61;
  t98 = t36 * t97;
  t99 = t37 - t98;
  t102 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t99);
  t103 = 0.1e1 / t48;
  t104 = -t99;
  t107 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t104);
  t109 = t102 / 0.2e1 + t107 / 0.2e1;
  t112 = -0.6e1 * t95 * t109 + t84 + t94;
  t113 = t9 * t112;
  t115 = t9 * t58;
  t116 = t58 * t58;
  t117 = 0.1e1 / t116;
  t118 = params->h * t117;
  t119 = log(t69);
  t120 = t112 * t119;
  t122 = t71 * t2;
  t123 = t61 * t9;
  t125 = 0.1e1 / t10 / t123;
  t126 = t59 * t125;
  t127 = 0.1e1 / t69;
  t128 = t65 * t127;
  t129 = t126 * t128;
  t131 = 0.7e1 / 0.144e3 * t122 * t129;
  t132 = -t118 * t120 - t131;
  t133 = t72 * t132;
  tvrho0 = t113 * t72 + t115 * t133 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t135 = -t37 - t98;
  t138 = my_piecewise3(t40, 0, 0.2e1 / 0.3e1 * t96 * t135);
  t139 = -t135;
  t142 = my_piecewise3(t47, 0, 0.2e1 / 0.3e1 * t103 * t139);
  t144 = t138 / 0.2e1 + t142 / 0.2e1;
  t147 = -0.6e1 * t95 * t144 + t84 + t94;
  t148 = t9 * t147;
  t150 = t147 * t119;
  t152 = -t118 * t150 - t131;
  t153 = t72 * t152;
  tvrho1 = t115 * t153 + t148 * t72 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t156 = 0.1e1 / t10 / t9;
  t157 = t156 * t72;
  t159 = t60 * t127;
  t160 = t157 * params->h * t159;
  tvsigma0 = t160 / 0.48e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = t160 / 0.24e2;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  tvsigma2 = tvsigma0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t161 = t112 * t72;
  t163 = t58 * t72;
  t164 = t163 * t132;
  t168 = t8 / t19 / t9;
  t170 = t18 * t156;
  t173 = -0.2e1 / 0.27e2 * t14 * t170 - 0.2e1 / 0.27e2 * t3 * t168;
  t174 = params->ap * t173;
  t175 = t174 * t83;
  t176 = t81 * t81;
  t178 = t23 * t23;
  t179 = 0.1e1 / t178;
  t180 = params->ap * t176 * t179;
  t184 = -0.2e1 / 0.27e2 * t26 * t168 - 0.2e1 / 0.27e2 * t29 * t170;
  t185 = params->af * t184;
  t187 = t89 * t89;
  t189 = t32 * t32;
  t190 = 0.1e1 / t189;
  t192 = -params->af * t187 * t190 + t185 * t91 - t175 + t180;
  t193 = t192 * t56;
  t194 = t93 * t53;
  t195 = t194 * t109;
  t197 = t35 * t52;
  t198 = t109 * t109;
  t202 = 0.1e1 / t43 / t39;
  t203 = t99 * t99;
  t206 = 0.1e1 / t123;
  t207 = t36 * t206;
  t209 = -0.2e1 * t97 + 0.2e1 * t207;
  t213 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t203 + 0.2e1 / 0.3e1 * t96 * t209);
  t215 = 0.1e1 / t48 / t46;
  t216 = t104 * t104;
  t219 = -t209;
  t223 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t216 + 0.2e1 / 0.3e1 * t103 * t219);
  t225 = t213 / 0.2e1 + t223 / 0.2e1;
  t228 = -0.12e2 * t197 * t198 - 0.6e1 * t95 * t225 + t175 - t180 + t193 - 0.12e2 * t195;
  t229 = t9 * t228;
  t233 = t132 * t132;
  t234 = t72 * t233;
  t237 = 0.1e1 / t116 / t58;
  t238 = params->h * t237;
  t239 = t112 * t112;
  t240 = t239 * t119;
  t245 = t112 * t2;
  t246 = t118 * t245;
  t247 = t246 * t129;
  t249 = t61 * t61;
  t251 = 0.1e1 / t10 / t249;
  t252 = t59 * t251;
  t253 = t252 * t128;
  t255 = 0.35e2 / 0.216e3 * t122 * t253;
  t256 = t71 * t1;
  t257 = t59 * t59;
  t258 = t249 * t61;
  t260 = 0.1e1 / t19 / t258;
  t261 = t257 * t260;
  t262 = t65 * t65;
  t263 = t69 * t69;
  t264 = 0.1e1 / t263;
  t265 = t262 * t264;
  t266 = t261 * t265;
  t268 = 0.49e2 / 0.6912e4 * t256 * t266;
  t269 = 0.2e1 * t238 * t240 - t118 * t228 * t119 + 0.7e1 / 0.72e2 * t247 + t255 - t268;
  t270 = t72 * t269;
  tv2rho20 = 0.2e1 * t113 * t133 + t115 * t234 + t115 * t270 + t229 * t72 + 0.2e1 * t161 + 0.2e1 * t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t272 = t147 * t72;
  t274 = t194 * t144;
  t276 = t144 * t109;
  t279 = t202 * t135;
  t282 = t96 * t36;
  t286 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t279 * t99 + 0.4e1 / 0.3e1 * t282 * t206);
  t287 = t215 * t139;
  t290 = t103 * t36;
  t294 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t287 * t104 - 0.4e1 / 0.3e1 * t290 * t206);
  t296 = t286 / 0.2e1 + t294 / 0.2e1;
  t299 = -0.12e2 * t197 * t276 - 0.6e1 * t95 * t296 + t175 - t180 + t193 - 0.6e1 * t195 - 0.6e1 * t274;
  t300 = t9 * t299;
  t303 = t163 * t152;
  t305 = t133 * t152;
  t310 = t299 * t119;
  t312 = t147 * t2;
  t313 = t118 * t312;
  t314 = t313 * t129;
  t317 = 0.2e1 * t238 * t150 * t112 - t118 * t310 + 0.7e1 / 0.144e3 * t314 + 0.7e1 / 0.144e3 * t247 + t255 - t268;
  t318 = t72 * t317;
  tv2rho21 = t113 * t153 + t115 * t305 + t115 * t318 + t148 * t133 + t300 * t72 + t161 + t164 + t272 + t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t323 = t144 * t144;
  t326 = t135 * t135;
  t330 = 0.2e1 * t97 + 0.2e1 * t207;
  t334 = my_piecewise3(t40, 0, -0.2e1 / 0.9e1 * t202 * t326 + 0.2e1 / 0.3e1 * t96 * t330);
  t335 = t139 * t139;
  t338 = -t330;
  t342 = my_piecewise3(t47, 0, -0.2e1 / 0.9e1 * t215 * t335 + 0.2e1 / 0.3e1 * t103 * t338);
  t344 = t334 / 0.2e1 + t342 / 0.2e1;
  t347 = -0.12e2 * t197 * t323 - 0.6e1 * t95 * t344 + t175 - t180 + t193 - 0.12e2 * t274;
  t348 = t9 * t347;
  t352 = t152 * t152;
  t353 = t72 * t352;
  t355 = t147 * t147;
  t356 = t355 * t119;
  t359 = t347 * t119;
  t362 = 0.2e1 * t238 * t356 - t118 * t359 + 0.7e1 / 0.72e2 * t314 + t255 - t268;
  t363 = t72 * t362;
  tv2rho22 = t115 * t353 + t115 * t363 + 0.2e1 * t148 * t153 + t348 * t72 + 0.2e1 * t272 + 0.2e1 * t303;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t365 = t63 * t72;
  t367 = t365 * params->h * t159;
  t368 = t367 / 0.36e2;
  t372 = params->h * t2 * t59 * t127;
  t373 = t157 * t132 * t372;
  t377 = 0.1e1 / t19 / t249 * t72;
  t378 = t377 * params->h;
  t379 = t1 * t257;
  t381 = t379 * t264 * t65;
  t382 = t378 * t381;
  t383 = 0.7e1 / 0.2304e4 * t382;
  tv2rhosigma0 = -t368 + t373 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t384 = t367 / 0.18e2;
  t386 = 0.7e1 / 0.1152e4 * t382;
  tv2rhosigma1 = -t384 + t373 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  tv2rhosigma2 = tv2rhosigma0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t388 = t157 * t152 * t372;
  tv2rhosigma3 = -t368 + t388 / 0.48e2 + t383;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t384 + t388 / 0.24e2 + t386;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  tv2rhosigma5 = tv2rhosigma3;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t392 = 0.1e1 / t19 / t123;
  t393 = t392 * t72;
  t394 = params->h * params->h;
  t397 = t257 * t264;
  t398 = t70 * t1 * t397;
  t401 = t379 * t264;
  t403 = t393 * t394 * t398 - t393 * params->h * t401;
  tv2sigma20 = t403 / 0.768e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = t403 / 0.384e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = tv2sigma20;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = t403 / 0.192e3;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = tv2sigma21;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  tv2sigma25 = tv2sigma22;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t404 = t228 * t72;
  t406 = t161 * t132;
  t408 = t163 * t233;
  t410 = t163 * t269;
  t414 = t8 / t19 / t61;
  t417 = t18 * t63;
  t421 = params->ap * (0.1e2 / 0.81e2 * t3 * t414 + 0.8e1 / 0.81e2 * t14 * t417);
  t422 = t421 * t83;
  t423 = t179 * t81;
  t425 = 0.3e1 * t174 * t423;
  t429 = 0.1e1 / t178 / t23;
  t431 = 0.2e1 * params->ap * t176 * t81 * t429;
  t437 = params->af * (0.1e2 / 0.81e2 * t26 * t414 + 0.8e1 / 0.81e2 * t29 * t417);
  t439 = t190 * t89;
  t445 = 0.1e1 / t189 / t32;
  t448 = 0.2e1 * params->af * t187 * t89 * t445 - 0.3e1 * t185 * t439 + t437 * t91 - t422 + t425 - t431;
  t449 = t448 * t56;
  t450 = t192 * t53;
  t451 = t450 * t109;
  t453 = t93 * t52;
  t454 = t453 * t198;
  t456 = t194 * t225;
  t458 = t198 * t109;
  t461 = t109 * t225;
  t464 = t39 * t39;
  t466 = 0.1e1 / t43 / t464;
  t467 = t203 * t99;
  t470 = t202 * t99;
  t473 = 0.1e1 / t249;
  t474 = t36 * t473;
  t476 = 0.6e1 * t206 - 0.6e1 * t474;
  t480 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t466 * t467 - 0.2e1 / 0.3e1 * t470 * t209 + 0.2e1 / 0.3e1 * t96 * t476);
  t481 = t46 * t46;
  t483 = 0.1e1 / t48 / t481;
  t484 = t216 * t104;
  t487 = t215 * t104;
  t490 = -t476;
  t494 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t483 * t484 - 0.2e1 / 0.3e1 * t487 * t219 + 0.2e1 / 0.3e1 * t103 * t490);
  t496 = t480 / 0.2e1 + t494 / 0.2e1;
  t499 = -0.36e2 * t197 * t461 - 0.12e2 * t35 * t458 - 0.6e1 * t95 * t496 + t422 - t425 + t431 + t449 - 0.18e2 * t451 - 0.36e2 * t454 - 0.18e2 * t456;
  t500 = t9 * t499;
  t508 = t233 * t132;
  t509 = t72 * t508;
  t511 = t133 * t269;
  t514 = t116 * t116;
  t516 = params->h / t514;
  t517 = t239 * t112;
  t521 = t120 * t228;
  t525 = t238 * t239 * t2;
  t526 = t525 * t129;
  t531 = t118 * t228 * t2;
  t532 = t531 * t129;
  t534 = t246 * t253;
  t537 = t118 * t112 * t1;
  t538 = t537 * t266;
  t540 = t249 * t9;
  t544 = t59 / t10 / t540 * t128;
  t546 = 0.455e3 / 0.648e3 * t122 * t544;
  t547 = t249 * t123;
  t551 = t257 / t19 / t547 * t265;
  t553 = 0.245e3 / 0.3456e4 * t256 * t551;
  t554 = t71 * M_PI;
  t555 = t249 * t249;
  t556 = t555 * t61;
  t557 = 0.1e1 / t556;
  t558 = t262 * t65;
  t561 = 0.1e1 / t263 / t69;
  t564 = 0.343e3 / 0.165888e6 * t554 * t557 * t558 * t561;
  t565 = -0.6e1 * t516 * t517 * t119 + 0.6e1 * t238 * t521 - 0.7e1 / 0.24e2 * t526 - t118 * t499 * t119 + 0.7e1 / 0.48e2 * t532 - 0.35e2 / 0.72e2 * t534 + 0.49e2 / 0.2304e4 * t538 - t546 + t553 - t564;
  t566 = t72 * t565;
  tv3rho30 = 0.3e1 * t113 * t234 + 0.3e1 * t113 * t270 + t115 * t509 + 0.3e1 * t115 * t511 + t115 * t566 + 0.3e1 * t229 * t133 + t500 * t72 + 0.3e1 * t404 + 0.6e1 * t406 + 0.3e1 * t408 + 0.3e1 * t410;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t571 = t132 * t152;
  t573 = 0.2e1 * tzk0 * t571;
  t580 = t310 * t112;
  t583 = t238 * t312;
  t584 = t128 * t112;
  t585 = t126 * t584;
  t587 = 0.7e1 / 0.36e2 * t583 * t585;
  t594 = t450 * t144;
  t597 = 0.24e2 * t453 * t276;
  t599 = 0.12e2 * t194 * t296;
  t600 = t35 * t198;
  t603 = t296 * t109;
  t606 = t144 * t225;
  t609 = t466 * t135;
  t612 = t202 * t36;
  t623 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t609 * t203 - 0.8e1 / 0.9e1 * t612 * t206 * t99 - 0.2e1 / 0.9e1 * t279 * t209 + 0.4e1 / 0.3e1 * t96 * t206 - 0.4e1 * t282 * t473);
  t624 = t483 * t139;
  t627 = t215 * t36;
  t638 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t624 * t216 + 0.8e1 / 0.9e1 * t627 * t206 * t104 - 0.2e1 / 0.9e1 * t287 * t219 - 0.4e1 / 0.3e1 * t103 * t206 + 0.4e1 * t290 * t473);
  t640 = t623 / 0.2e1 + t638 / 0.2e1;
  t643 = -0.12e2 * t600 * t144 - 0.24e2 * t197 * t603 - 0.12e2 * t197 * t606 - 0.6e1 * t95 * t640 + t422 - t425 + t431 + t449 - 0.12e2 * t451 - 0.12e2 * t454 - 0.6e1 * t456 - 0.6e1 * t594 - t597 - t599;
  t644 = t643 * t119;
  t646 = t299 * t2;
  t647 = t118 * t646;
  t649 = 0.7e1 / 0.72e2 * t647 * t129;
  t650 = t313 * t253;
  t652 = t147 * t1;
  t653 = t118 * t652;
  t654 = t653 * t266;
  t660 = -0.6e1 * t516 * t150 * t239 + 0.4e1 * t238 * t580 - t587 + 0.2e1 * t238 * t150 * t228 - t118 * t644 + t649 - 0.35e2 / 0.216e3 * t650 + 0.49e2 / 0.6912e4 * t654 - 0.7e1 / 0.72e2 * t526 + 0.7e1 / 0.144e3 * t532 - 0.35e2 / 0.108e3 * t534 + 0.49e2 / 0.3456e4 * t538 - t546 + t553 - t564;
  t661 = t72 * t660;
  t663 = t234 * t152;
  t668 = t270 * t152;
  t670 = t133 * t317;
  t675 = 0.2e1 * t272 * t132;
  t676 = t9 * t643;
  t679 = 0.2e1 * t161 * t152;
  t681 = 0.2e1 * t163 * t317;
  t682 = t299 * t72;
  t683 = 0.2e1 * t682;
  tv3rho31 = 0.2e1 * t113 * t305 + 0.2e1 * t113 * t318 + t115 * t661 + t115 * t663 + t115 * t668 + 0.2e1 * t115 * t670 + 0.2e1 * t300 * t133 + t148 * t234 + t148 * t270 + t229 * t153 + t676 * t72 + t404 + 0.2e1 * t406 + t408 + t410 + t573 + t675 + t679 + t681 + t683;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t684 = t347 * t72;
  t687 = t453 * t323;
  t689 = t35 * t109;
  t692 = t144 * t296;
  t695 = t194 * t344;
  t697 = t344 * t109;
  t700 = t466 * t326;
  t705 = t202 * t330;
  t710 = -0.2e1 * t206 - 0.6e1 * t474;
  t714 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t700 * t99 - 0.8e1 / 0.9e1 * t279 * t207 - 0.2e1 / 0.9e1 * t705 * t99 + 0.2e1 / 0.3e1 * t96 * t710);
  t715 = t483 * t335;
  t720 = t215 * t338;
  t723 = -t710;
  t727 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t715 * t104 + 0.8e1 / 0.9e1 * t287 * t207 - 0.2e1 / 0.9e1 * t720 * t104 + 0.2e1 / 0.3e1 * t103 * t723);
  t729 = t714 / 0.2e1 + t727 / 0.2e1;
  t732 = -0.24e2 * t197 * t692 - 0.12e2 * t197 * t697 - 0.12e2 * t689 * t323 - 0.6e1 * t95 * t729 + t422 - t425 + t431 + t449 - 0.6e1 * t451 - 0.12e2 * t594 - t597 - t599 - 0.12e2 * t687 - 0.6e1 * t695;
  t733 = t9 * t732;
  t736 = t272 * t152;
  t744 = t163 * t352;
  t746 = t133 * t352;
  t748 = t153 * t317;
  t751 = t163 * t362;
  t753 = t133 * t362;
  t761 = t355 * t2;
  t762 = t238 * t761;
  t763 = t762 * t129;
  t765 = t359 * t112;
  t768 = t732 * t119;
  t770 = t347 * t2;
  t771 = t118 * t770;
  t772 = t771 * t129;
  t778 = -0.6e1 * t516 * t356 * t112 + 0.4e1 * t238 * t150 * t299 - 0.7e1 / 0.72e2 * t763 + 0.2e1 * t238 * t765 - t118 * t768 + 0.7e1 / 0.144e3 * t772 - t587 + t649 - 0.35e2 / 0.108e3 * t650 + 0.49e2 / 0.3456e4 * t654 - 0.35e2 / 0.216e3 * t534 - t546 + t553 + 0.49e2 / 0.6912e4 * t538 - t564;
  t779 = t72 * t778;
  tv3rho32 = t113 * t353 + t113 * t363 + t115 * t746 + 0.2e1 * t115 * t748 + t115 * t753 + t115 * t779 + t348 * t133 + 0.2e1 * t148 * t305 + 0.2e1 * t148 * t318 + 0.2e1 * t300 * t153 + t733 * t72 + t573 + t675 + t679 + t681 + t683 + t684 + 0.2e1 * t736 + t744 + t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t788 = t323 * t144;
  t791 = t144 * t344;
  t794 = t326 * t135;
  t800 = -0.6e1 * t206 - 0.6e1 * t474;
  t804 = my_piecewise3(t40, 0, 0.8e1 / 0.27e2 * t466 * t794 - 0.2e1 / 0.3e1 * t279 * t330 + 0.2e1 / 0.3e1 * t96 * t800);
  t805 = t335 * t139;
  t810 = -t800;
  t814 = my_piecewise3(t47, 0, 0.8e1 / 0.27e2 * t483 * t805 - 0.2e1 / 0.3e1 * t287 * t338 + 0.2e1 / 0.3e1 * t103 * t810);
  t816 = t804 / 0.2e1 + t814 / 0.2e1;
  t819 = -0.36e2 * t197 * t791 - 0.12e2 * t35 * t788 - 0.6e1 * t95 * t816 + t422 - t425 + t431 + t449 - 0.18e2 * t594 - 0.36e2 * t687 - 0.18e2 * t695;
  t820 = t9 * t819;
  t828 = t352 * t152;
  t829 = t72 * t828;
  t831 = t153 * t362;
  t834 = t355 * t147;
  t835 = t834 * t119;
  t842 = t819 * t119;
  t847 = -0.6e1 * t516 * t835 + 0.6e1 * t238 * t150 * t347 - 0.7e1 / 0.24e2 * t763 - t118 * t842 + 0.7e1 / 0.48e2 * t772 - 0.35e2 / 0.72e2 * t650 + 0.49e2 / 0.2304e4 * t654 - t546 + t553 - t564;
  t848 = t72 * t847;
  tv3rho33 = t115 * t829 + 0.3e1 * t115 * t831 + t115 * t848 + 0.3e1 * t148 * t353 + 0.3e1 * t148 * t363 + 0.3e1 * t348 * t153 + t820 * t72 + 0.3e1 * t684 + 0.6e1 * t736 + 0.3e1 * t744 + 0.3e1 * t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t850 = t125 * t72;
  t852 = t850 * params->h * t159;
  t853 = 0.7e1 / 0.108e3 * t852;
  t855 = t365 * t132 * t372;
  t856 = t855 / 0.18e2;
  t859 = 0.1e1 / t19 / t540 * t72;
  t860 = t859 * params->h;
  t861 = t860 * t381;
  t862 = 0.7e1 / 0.384e3 * t861;
  t864 = t157 * t233 * t372;
  t867 = t157 * t269 * t372;
  t869 = t132 * params->h;
  t871 = t377 * t869 * t381;
  t872 = 0.7e1 / 0.1152e4 * t871;
  t874 = 0.1e1 / t555 * t72;
  t875 = t874 * params->h;
  t876 = M_PI * t561;
  t877 = t876 * t262;
  t878 = t875 * t877;
  t879 = 0.49e2 / 0.55296e5 * t878;
  tv3rho2sigma0 = t853 - t856 - t862 + t864 / 0.48e2 + t867 / 0.48e2 + t872 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t880 = 0.7e1 / 0.54e2 * t852;
  t882 = 0.7e1 / 0.192e3 * t861;
  t886 = 0.49e2 / 0.27648e5 * t878;
  tv3rho2sigma1 = t880 - t855 / 0.9e1 - t882 + t864 / 0.24e2 + t867 / 0.24e2 + 0.7e1 / 0.576e3 * t871 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  tv3rho2sigma2 = tv3rho2sigma0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t889 = t365 * t152 * t372;
  t892 = t157 * t571 * t372;
  t895 = t157 * t317 * t372;
  t897 = t152 * params->h;
  t899 = t377 * t897 * t381;
  tv3rho2sigma3 = t853 - t855 / 0.36e2 - t862 - t889 / 0.36e2 + t892 / 0.48e2 + t895 / 0.48e2 + 0.7e1 / 0.2304e4 * t899 + 0.7e1 / 0.2304e4 * t871 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t902 = t889 / 0.18e2;
  t905 = 0.7e1 / 0.1152e4 * t899;
  tv3rho2sigma4 = t880 - t856 - t882 - t902 + t892 / 0.24e2 + t895 / 0.24e2 + t905 + t872 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  tv3rho2sigma5 = tv3rho2sigma3;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t907 = t157 * t352 * t372;
  t910 = t157 * t362 * t372;
  tv3rho2sigma6 = t853 - t902 - t862 + t907 / 0.48e2 + t910 / 0.48e2 + t905 + t879;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t880 - t889 / 0.9e1 - t882 + t907 / 0.24e2 + t910 / 0.24e2 + 0.7e1 / 0.576e3 * t899 + t886;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  tv3rho2sigma8 = tv3rho2sigma6;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t917 = t377 * t394 * t398;
  t918 = 0.11e2 / 0.2304e4 * t917;
  t919 = t132 * t394;
  t920 = t393 * t919;
  t921 = t920 * t398;
  t923 = t394 * t117;
  t924 = t393 * t923;
  t926 = t379 * t264 * t112;
  t927 = t924 * t926;
  t930 = 0.1e1 / t547 * t72;
  t931 = t930 * t394;
  t932 = t70 * M_PI;
  t933 = t561 * t65;
  t934 = t932 * t933;
  t935 = t931 * t934;
  t936 = 0.7e1 / 0.18432e5 * t935;
  t937 = t378 * t401;
  t938 = 0.11e2 / 0.2304e4 * t937;
  t940 = params->h * t1;
  t941 = t940 * t397;
  t942 = t393 * t132 * t941;
  t945 = t876 * t65;
  t946 = t930 * params->h * t945;
  t947 = 0.7e1 / 0.18432e5 * t946;
  tv3rhosigma20 = -t918 + t921 / 0.768e3 - t927 / 0.768e3 + t936 + t938 - t942 / 0.768e3 - t947;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t948 = 0.11e2 / 0.1152e4 * t917;
  t951 = 0.7e1 / 0.9216e4 * t935;
  t952 = 0.11e2 / 0.1152e4 * t937;
  t954 = 0.7e1 / 0.9216e4 * t946;
  tv3rhosigma21 = -t948 + t921 / 0.384e3 - t927 / 0.384e3 + t951 + t952 - t942 / 0.384e3 - t954;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = tv3rhosigma20;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t955 = 0.11e2 / 0.576e3 * t917;
  t958 = 0.7e1 / 0.4608e4 * t935;
  t959 = 0.11e2 / 0.576e3 * t937;
  t961 = 0.7e1 / 0.4608e4 * t946;
  tv3rhosigma23 = -t955 + t921 / 0.192e3 - t927 / 0.192e3 + t958 + t959 - t942 / 0.192e3 - t961;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = tv3rhosigma21;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  tv3rhosigma25 = tv3rhosigma22;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t962 = t152 * t394;
  t963 = t393 * t962;
  t964 = t963 * t398;
  t966 = t264 * t147;
  t967 = t379 * t966;
  t968 = t924 * t967;
  t971 = t393 * t152 * t941;
  tv3rhosigma26 = -t918 + t964 / 0.768e3 - t968 / 0.768e3 + t936 + t938 - t971 / 0.768e3 - t947;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = -t948 + t964 / 0.384e3 - t968 / 0.384e3 + t951 + t952 - t971 / 0.384e3 - t954;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = tv3rhosigma26;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = -t955 + t964 / 0.192e3 - t968 / 0.192e3 + t958 + t959 - t971 / 0.192e3 - t961;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = tv3rhosigma27;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  tv3rhosigma211 = tv3rhosigma28;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t979 = 0.1e1 / t258;
  t980 = t979 * t72;
  t981 = t394 * params->h;
  t982 = t980 * t981;
  t983 = t117 * M_PI;
  t984 = t983 * t561;
  t985 = t982 * t984;
  t987 = t980 * t394;
  t988 = t932 * t561;
  t989 = t987 * t988;
  t991 = params->h * M_PI;
  t992 = t991 * t561;
  t993 = t980 * t992;
  tv3sigma30 = t985 / 0.12288e5 - t989 / 0.4096e4 + t993 / 0.6144e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = t985 / 0.6144e4 - t989 / 0.2048e4 + t993 / 0.3072e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = tv3sigma30;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = t985 / 0.3072e4 - t989 / 0.1024e4 + t993 / 0.1536e4;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = tv3sigma31;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = tv3sigma32;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = t985 / 0.1536e4 - t989 / 0.512e3 + t993 / 0.768e3;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = tv3sigma33;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = tv3sigma34;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  tv3sigma39 = tv3sigma35;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1004 = t161 * t233;
  t1007 = tzk0 * t132 * t269;
  t1009 = t163 * t508;
  t1018 = 0.4e1 * t421 * t423;
  t1019 = t173 * t173;
  t1022 = 0.3e1 * params->ap * t1019 * t179;
  t1023 = t176 * t176;
  t1025 = t178 * t178;
  t1028 = 0.6e1 * params->ap * t1023 / t1025;
  t1029 = t192 * t52;
  t1030 = t1029 * t198;
  t1032 = t453 * t461;
  t1034 = t225 * t225;
  t1040 = t8 * t392;
  t1043 = t18 * t125;
  t1048 = params->ap * (-0.8e2 / 0.243e3 * t3 * t1040 - 0.56e2 / 0.243e3 * t14 * t1043) * t83;
  t1049 = t448 * t53;
  t1050 = t1049 * t109;
  t1052 = t450 * t225;
  t1054 = t93 * t458;
  t1056 = t194 * t496;
  t1062 = 0.1e1 / t43 / t464 / t39;
  t1063 = t203 * t203;
  t1069 = t209 * t209;
  t1074 = 0.1e1 / t540;
  t1075 = t36 * t1074;
  t1077 = -0.24e2 * t473 + 0.24e2 * t1075;
  t1081 = my_piecewise3(t40, 0, -0.56e2 / 0.81e2 * t1062 * t1063 + 0.16e2 / 0.9e1 * t466 * t203 * t209 - 0.2e1 / 0.3e1 * t202 * t1069 - 0.8e1 / 0.9e1 * t470 * t476 + 0.2e1 / 0.3e1 * t96 * t1077);
  t1084 = 0.1e1 / t48 / t481 / t46;
  t1085 = t216 * t216;
  t1091 = t219 * t219;
  t1100 = my_piecewise3(t47, 0, -0.56e2 / 0.81e2 * t1084 * t1085 + 0.16e2 / 0.9e1 * t483 * t216 * t219 - 0.2e1 / 0.3e1 * t215 * t1091 - 0.8e1 / 0.9e1 * t487 * t490 - 0.2e1 / 0.3e1 * t103 * t1077);
  t1107 = 0.12e2 * t174 * t429 * t176;
  t1120 = t184 * t184;
  t1124 = t187 * t187;
  t1126 = t189 * t189;
  t1131 = (params->af * (-0.8e2 / 0.243e3 * t26 * t1040 - 0.56e2 / 0.243e3 * t29 * t1043) * t91 - 0.4e1 * t437 * t439 + 0.12e2 * t185 * t445 * t187 - 0.3e1 * params->af * t1120 * t190 - 0.6e1 * params->af * t1124 / t1126 - t1048 + t1018 - t1107 + t1022 + t1028) * t56;
  t1132 = -t1018 - t1022 - t1028 - 0.72e2 * t1030 - 0.144e3 * t1032 - 0.36e2 * t197 * t1034 - 0.48e2 * t197 * t109 * t496 + t1048 - 0.24e2 * t1050 - 0.36e2 * t1052 - 0.48e2 * t1054 - 0.24e2 * t1056 - 0.72e2 * t600 * t225 - 0.6e1 * t95 * (t1081 / 0.2e1 + t1100 / 0.2e1) + t1107 + t1131;
  t1137 = t516 * t517 * t2 * t129;
  t1141 = t238 * t239 * t1 * t266;
  t1145 = t118 * t499 * t2 * t129;
  t1149 = t118 * t228 * t1 * t266;
  t1151 = t537 * t551;
  t1158 = 0.91e3 / 0.243e3 * t122 * t59 / t10 / t258 * t128;
  t1162 = M_PI * t557 * t558 * t561;
  t1163 = t118 * t112 * t1162;
  t1170 = 0.10045e5 / 0.15552e5 * t256 * t257 / t19 / t555 * t265;
  t1171 = t59 * M_PI;
  t1176 = t262 * t262;
  t1178 = t263 * t263;
  t1179 = 0.1e1 / t1178;
  t1180 = t1179 * t2;
  t1183 = 0.2401e4 / 0.7962624e7 * t71 * t1171 / t10 / t555 / t540 * t1176 * t1180;
  t1186 = t126 * t128 * t228;
  t1187 = t238 * t245 * t1186;
  t1189 = t525 * t253;
  t1191 = t531 * t253;
  t1193 = t246 * t544;
  t1195 = t555 * t123;
  t1200 = 0.1715e4 / 0.41472e5 * t554 / t1195 * t558 * t561;
  t1203 = params->h / t514 / t58;
  t1204 = t239 * t239;
  t1211 = t228 * t228;
  t1218 = -t118 * t1132 * t119 + 0.7e1 / 0.6e1 * t1137 - 0.49e2 / 0.576e3 * t1141 + 0.7e1 / 0.36e2 * t1145 + 0.49e2 / 0.1152e4 * t1149 - 0.245e3 / 0.864e3 * t1151 + t1158 + 0.343e3 / 0.41472e5 * t1163 - t1170 - t1183 - 0.7e1 / 0.6e1 * t1187 + 0.35e2 / 0.18e2 * t1189 - 0.35e2 / 0.36e2 * t1191 + 0.455e3 / 0.162e3 * t1193 + t1200 + 0.24e2 * t1203 * t1204 * t119 - 0.36e2 * t516 * t240 * t228 + 0.6e1 * t238 * t1211 * t119 + 0.8e1 * t238 * t120 * t499;
  t1221 = t404 * t132;
  t1223 = t161 * t269;
  t1225 = t163 * t565;
  t1238 = t233 * t233;
  t1241 = t269 * t269;
  t1248 = t499 * t72;
  tv4rho40 = t9 * t1132 * t72 + t115 * t72 * t1218 + t115 * t72 * t1238 + 0.3e1 * t115 * t72 * t1241 + 0.4e1 * t115 * t133 * t565 + 0.6e1 * t115 * t234 * t269 + 0.4e1 * t113 * t509 + 0.12e2 * t113 * t511 + 0.4e1 * t113 * t566 + 0.4e1 * t500 * t133 + 0.6e1 * t229 * t234 + 0.6e1 * t229 * t270 + 0.12e2 * t1004 + 0.12e2 * t1007 + 0.4e1 * t1009 + 0.12e2 * t1221 + 0.12e2 * t1223 + 0.4e1 * t1225 + 0.4e1 * t1248;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1250 = t161 * t317;
  t1252 = t404 * t152;
  t1255 = t272 * t269;
  t1258 = t1029 * t276;
  t1259 = 0.36e2 * t1258;
  t1260 = t453 * t603;
  t1262 = t453 * t606;
  t1276 = -0.36e2 * t197 * t640 * t109 - 0.12e2 * t197 * t144 * t496 - 0.36e2 * t197 * t296 * t225 - 0.36e2 * t689 * t606 - t1018 - 0.36e2 * t1032 - 0.12e2 * t1054 + t1107 + t1131 - t1259 - 0.72e2 * t1260 - 0.36e2 * t1262;
  t1278 = t93 * t198 * t144;
  t1280 = t1049 * t144;
  t1282 = t450 * t296;
  t1283 = 0.18e2 * t1282;
  t1284 = t194 * t640;
  t1312 = 0.16e2 * t282 * t1074;
  t1314 = my_piecewise3(t40, 0, -0.56e2 / 0.81e2 * t1062 * t135 * t467 + 0.16e2 / 0.9e1 * t466 * t36 * t206 * t203 + 0.8e1 / 0.9e1 * t609 * t99 * t209 - 0.4e1 / 0.3e1 * t202 * t206 * t99 + 0.4e1 * t612 * t473 * t99 - 0.4e1 / 0.3e1 * t612 * t206 * t209 - 0.2e1 / 0.9e1 * t279 * t476 - 0.8e1 * t96 * t473 + t1312);
  t1339 = 0.16e2 * t290 * t1074;
  t1341 = my_piecewise3(t47, 0, -0.56e2 / 0.81e2 * t1084 * t139 * t484 - 0.16e2 / 0.9e1 * t483 * t36 * t206 * t216 + 0.8e1 / 0.9e1 * t624 * t104 * t219 + 0.4e1 / 0.3e1 * t215 * t206 * t104 - 0.4e1 * t627 * t473 * t104 + 0.4e1 / 0.3e1 * t627 * t206 * t219 - 0.2e1 / 0.9e1 * t287 * t490 + 0.8e1 * t103 * t473 - t1339);
  t1350 = -0.36e2 * t1278 - 0.6e1 * t1280 - t1283 - 0.18e2 * t1284 - 0.36e2 * t600 * t296 - 0.6e1 * t95 * (t1314 / 0.2e1 + t1341 / 0.2e1) - t1022 - t1028 - 0.36e2 * t1030 + t1048 - 0.18e2 * t1050 - 0.18e2 * t1052 - 0.6e1 * t1056;
  t1351 = t1276 + t1350;
  t1354 = t682 * t132;
  t1373 = t516 * t147;
  t1384 = -t118 * t1351 * t119 + 0.24e2 * t1203 * t150 * t517 + t1200 + 0.6e1 * t238 * t644 * t112 - 0.18e2 * t516 * t310 * t239 + 0.2e1 * t238 * t150 * t499 + 0.6e1 * t238 * t310 * t228 - 0.18e2 * t1373 * t521 + 0.7e1 / 0.24e2 * t1137 - 0.49e2 / 0.1152e4 * t1141 + 0.7e1 / 0.144e3 * t1145 + 0.49e2 / 0.2304e4 * t1149 - 0.245e3 / 0.1152e4 * t1151 + 0.35e2 / 0.36e2 * t1189 - 0.35e2 / 0.72e2 * t1191 + 0.455e3 / 0.216e3 * t1193;
  t1387 = t118 * t643 * t2 * t129;
  t1391 = t118 * t299 * t1 * t266;
  t1392 = 0.49e2 / 0.2304e4 * t1391;
  t1393 = t653 * t551;
  t1395 = t647 * t253;
  t1396 = 0.35e2 / 0.72e2 * t1395;
  t1397 = t313 * t544;
  t1401 = t118 * t147 * t1162;
  t1407 = t516 * t312 * t126 * t128 * t239;
  t1410 = t238 * t646 * t585;
  t1412 = t583 * t1186;
  t1417 = t238 * t652 * t261 * t265 * t112;
  t1418 = 0.49e2 / 0.1152e4 * t1417;
  t1420 = t583 * t252 * t584;
  t1421 = 0.35e2 / 0.36e2 * t1420;
  t1422 = 0.7e1 / 0.48e2 * t1387 + t1392 - 0.245e3 / 0.3456e4 * t1393 - t1396 + 0.455e3 / 0.648e3 * t1397 + t1158 + 0.343e3 / 0.55296e5 * t1163 - t1170 - t1183 + 0.343e3 / 0.165888e6 * t1401 - 0.7e1 / 0.24e2 * t1187 + 0.7e1 / 0.8e1 * t1407 - 0.7e1 / 0.12e2 * t1410 - 0.7e1 / 0.24e2 * t1412 - t1418 + t1421;
  t1430 = t132 * t317;
  t1431 = tzk0 * t1430;
  t1435 = t161 * t571;
  t1437 = t269 * t152;
  t1438 = tzk0 * t1437;
  t1440 = t233 * t152;
  t1441 = tzk0 * t1440;
  t1446 = t643 * t72;
  t1448 = 0.6e1 * t1250 + 0.3e1 * t1252 + 0.3e1 * t1007 + t1225 + 0.3e1 * t1255 + t9 * t1351 * t72 + 0.6e1 * t1354 + t115 * t72 * (t1384 + t1422) + 0.3e1 * t113 * t661 + 0.3e1 * t229 * t318 + 0.6e1 * t1431 + t500 * t153 + t148 * t509 + 0.6e1 * t1435 + 0.3e1 * t1438 + 0.3e1 * t1441 + 0.3e1 * t300 * t270 + t148 * t566 + 0.3e1 * t1446;
  t1472 = t163 * t660;
  t1479 = t272 * t233;
  t1481 = t115 * t72;
  t1487 = 0.3e1 * t115 * t133 * t660 + t115 * t509 * t152 + t115 * t566 * t152 + 0.3e1 * t115 * t234 * t317 + 0.3e1 * t115 * t270 * t317 + 0.3e1 * t1481 * t571 * t269 + 0.3e1 * t113 * t663 + 0.3e1 * t113 * t668 + 0.6e1 * t113 * t670 + 0.3e1 * t676 * t133 + 0.3e1 * t148 * t511 + 0.3e1 * t229 * t305 + 0.3e1 * t300 * t234 + 0.3e1 * t1004 + t1009 + 0.3e1 * t1221 + 0.3e1 * t1223 + t1248 + 0.3e1 * t1472 + 0.3e1 * t1479;
  tv4rho41 = t1448 + t1487;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1493 = t732 * t72;
  t1505 = t299 * t299;
  t1518 = t36 * t36;
  t1535 = my_piecewise3(t40, 0, -0.56e2 / 0.81e2 * t1062 * t326 * t203 + 0.64e2 / 0.27e2 * t609 * t99 * t36 * t206 + 0.8e1 / 0.27e2 * t700 * t209 - 0.16e2 / 0.9e1 * t202 * t1518 * t979 - 0.8e1 / 0.9e1 * t279 * t206 + 0.8e1 / 0.3e1 * t279 * t474 + 0.8e1 / 0.27e2 * t466 * t330 * t203 - 0.4e1 / 0.9e1 * t202 * t710 * t99 - 0.2e1 / 0.9e1 * t705 * t209 + t1312);
  t1561 = my_piecewise3(t47, 0, -0.56e2 / 0.81e2 * t1084 * t335 * t216 - 0.64e2 / 0.27e2 * t624 * t104 * t36 * t206 + 0.8e1 / 0.27e2 * t715 * t219 - 0.16e2 / 0.9e1 * t215 * t1518 * t979 + 0.8e1 / 0.9e1 * t287 * t206 - 0.8e1 / 0.3e1 * t287 * t474 + 0.8e1 / 0.27e2 * t483 * t338 * t216 - 0.4e1 / 0.9e1 * t215 * t723 * t104 - 0.2e1 / 0.9e1 * t720 * t219 - t1339);
  t1566 = t1029 * t323;
  t1569 = t93 * t109 * t323;
  t1574 = t450 * t344;
  t1576 = t194 * t729;
  t1583 = t453 * t692;
  t1590 = t1107 - t1018 - 0.6e1 * t95 * (t1535 / 0.2e1 + t1561 / 0.2e1) - 0.12e2 * t1566 - 0.24e2 * t1569 - 0.12e2 * t35 * t225 * t323 - 0.6e1 * t1574 - 0.12e2 * t1576 - 0.12e2 * t600 * t344 - 0.48e2 * t1258 - 0.48e2 * t1260 - 0.24e2 * t1262 - 0.48e2 * t1583 - 0.48e2 * t689 * t692 - 0.24e2 * t197 * t144 * t640;
  t1591 = t453 * t697;
  t1606 = t296 * t296;
  t1609 = -0.24e2 * t197 * t729 * t109 - 0.12e2 * t197 * t344 * t225 - 0.24e2 * t197 * t1606 - t1022 - t1028 - 0.12e2 * t1030 + t1048 - 0.12e2 * t1050 - 0.6e1 * t1052 + t1131 - 0.24e2 * t1278 - 0.12e2 * t1280 - 0.24e2 * t1282 - 0.12e2 * t1284 - 0.24e2 * t1591;
  t1610 = t1590 + t1609;
  t1633 = t762 * t253;
  t1635 = t771 * t253;
  t1644 = 0.4e1 * t238 * t1505 * t119 - t118 * t1610 * t119 + t1200 + 0.2e1 * t238 * t359 * t228 + 0.4e1 * t238 * t768 * t112 - 0.24e2 * t1373 * t580 + 0.4e1 * t238 * t150 * t643 - 0.6e1 * t516 * t356 * t228 - 0.6e1 * t516 * t359 * t239 + 0.24e2 * t1203 * t356 * t239 + 0.35e2 / 0.108e3 * t1633 - 0.35e2 / 0.216e3 * t1635 - 0.49e2 / 0.3456e4 * t1141 + 0.49e2 / 0.6912e4 * t1149 - 0.245e3 / 0.1728e4 * t1151 + 0.35e2 / 0.108e3 * t1189 - 0.35e2 / 0.216e3 * t1191 + 0.455e3 / 0.324e3 * t1193 + 0.7e1 / 0.72e2 * t1387;
  t1651 = t238 * t355 * t1 * t266;
  t1655 = t118 * t732 * t2 * t129;
  t1659 = t118 * t347 * t1 * t266;
  t1664 = t516 * t761 * t585;
  t1668 = t583 * t126 * t128 * t299;
  t1671 = t238 * t770 * t585;
  t1678 = 0.49e2 / 0.1728e4 * t1391 - 0.245e3 / 0.1728e4 * t1393 - 0.35e2 / 0.54e2 * t1395 + 0.455e3 / 0.324e3 * t1397 - 0.49e2 / 0.3456e4 * t1651 + 0.7e1 / 0.72e2 * t1655 + 0.49e2 / 0.6912e4 * t1659 + t1158 + 0.343e3 / 0.82944e5 * t1163 - t1170 - t1183 + 0.343e3 / 0.82944e5 * t1401 + 0.7e1 / 0.12e2 * t1664 - 0.7e1 / 0.18e2 * t1668 - 0.7e1 / 0.36e2 * t1671 + 0.7e1 / 0.12e2 * t1407 - 0.7e1 / 0.18e2 * t1410 - 0.7e1 / 0.36e2 * t1412 - 0.49e2 / 0.864e3 * t1417 + 0.35e2 / 0.27e2 * t1420;
  t1682 = 0.4e1 * t1250 + 0.2e1 * t1252 + t348 * t234 + 0.2e1 * t148 * t668 + 0.2e1 * t1493 + 0.2e1 * t1255 + 0.4e1 * t300 * t305 + t115 * t234 * t362 + t115 * t234 * t352 + 0.4e1 * t1354 + 0.2e1 * t113 * t779 + t115 * t72 * (t1644 + t1678);
  t1686 = t132 * t352;
  t1687 = tzk0 * t1686;
  t1690 = t132 * t362;
  t1691 = tzk0 * t1690;
  t1698 = tzk0 * t152 * t317;
  t1704 = t115 * t270 * t362 + 0.2e1 * t113 * t753 + 0.2e1 * t148 * t661 + t229 * t353 + t229 * t363 + 0.4e1 * t1431 + 0.4e1 * t1435 + 0.2e1 * t1438 + 0.2e1 * t1441 + 0.2e1 * t1687 + 0.2e1 * t1691 + 0.4e1 * t1698;
  t1712 = t317 * t317;
  t1723 = t684 * t132;
  t1732 = 0.2e1 * t115 * t133 * t778 + 0.2e1 * t115 * t153 * t660 + 0.2e1 * t115 * t72 * t1712 + 0.4e1 * t1481 * t571 * t317 + t9 * t1610 * t72 + 0.2e1 * t733 * t133 + 0.2e1 * t148 * t663 + 0.4e1 * t148 * t670 + t348 * t270 + 0.2e1 * t1446 + 0.2e1 * t1472 + 0.2e1 * t1723;
  t1733 = t272 * t571;
  t1739 = t682 * t152;
  t1741 = t272 * t317;
  t1743 = t161 * t352;
  t1745 = t161 * t362;
  t1747 = t163 * t778;
  t1756 = t115 * t270 * t352 + 0.2e1 * t113 * t746 + 0.4e1 * t113 * t748 + 0.2e1 * t676 * t153 + 0.4e1 * t300 * t318 + 0.2e1 * t1479 + 0.4e1 * t1733 + 0.4e1 * t1739 + 0.4e1 * t1741 + 0.2e1 * t1743 + 0.2e1 * t1745 + 0.2e1 * t1747;
  tv4rho42 = t1682 + t1704 + t1732 + t1756;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1758 = t163 * t847;
  t1781 = 0.12e2 * t473 + 0.24e2 * t1075;
  t1785 = my_piecewise3(t40, 0, -0.56e2 / 0.81e2 * t1062 * t794 * t99 + 0.16e2 / 0.9e1 * t700 * t207 + 0.8e1 / 0.9e1 * t609 * t330 * t99 - 0.4e1 / 0.3e1 * t612 * t206 * t330 - 0.2e1 / 0.3e1 * t279 * t710 - 0.2e1 / 0.9e1 * t202 * t800 * t99 + 0.2e1 / 0.3e1 * t96 * t1781);
  t1806 = my_piecewise3(t47, 0, -0.56e2 / 0.81e2 * t1084 * t805 * t104 - 0.16e2 / 0.9e1 * t715 * t207 + 0.8e1 / 0.9e1 * t624 * t338 * t104 + 0.4e1 / 0.3e1 * t627 * t206 * t338 - 0.2e1 / 0.3e1 * t287 * t723 - 0.2e1 / 0.9e1 * t215 * t810 * t104 - 0.2e1 / 0.3e1 * t103 * t1781);
  t1811 = t35 * t323;
  t1814 = t194 * t816;
  t1818 = t1107 - t1018 - 0.36e2 * t1566 - 0.36e2 * t1569 - 0.18e2 * t1574 - 0.18e2 * t1576 - 0.6e1 * t95 * (t1785 / 0.2e1 + t1806 / 0.2e1) - 0.36e2 * t1811 * t296 - 0.6e1 * t1814 - t1259 - 0.72e2 * t1583 - 0.36e2 * t1591;
  t1819 = t93 * t788;
  t1822 = t453 * t791;
  t1836 = -0.12e2 * t197 * t816 * t109 - 0.36e2 * t197 * t144 * t729 - 0.36e2 * t197 * t296 * t344 - 0.36e2 * t689 * t791 - t1022 - t1028 + t1048 - 0.6e1 * t1050 + t1131 - 0.18e2 * t1280 - t1283 - 0.12e2 * t1819 - 0.36e2 * t1822;
  t1837 = t1818 + t1836;
  t1840 = t163 * t828;
  t1849 = tzk0 * t152 * t362;
  t1871 = t115 * t133 * t828 + t115 * t133 * t847 + 0.3e1 * t115 * t153 * t778 + 0.3e1 * t115 * t353 * t317 + t9 * t1837 * t72 + 0.3e1 * t113 * t831 + t820 * t133 + 0.3e1 * t148 * t746 + 0.6e1 * t148 * t748 + 0.3e1 * t148 * t753 + 0.3e1 * t733 * t153 + 0.3e1 * t348 * t305 + 0.3e1 * t1493 + 0.3e1 * t1687 + 0.3e1 * t1691 + 0.6e1 * t1698 + t1758 + t1840 + 0.3e1 * t1849;
  t1875 = t819 * t72;
  t1904 = t516 * t834 * t2 * t129;
  t1908 = t118 * t819 * t2 * t129;
  t1918 = t1200 + 0.2e1 * t238 * t842 * t112 + 0.6e1 * t238 * t150 * t732 + 0.35e2 / 0.36e2 * t1633 - 0.35e2 / 0.72e2 * t1635 + 0.6e1 * t238 * t310 * t347 + 0.7e1 / 0.24e2 * t1904 + 0.7e1 / 0.144e3 * t1908 - 0.245e3 / 0.3456e4 * t1151 - t118 * t1837 * t119 + 0.455e3 / 0.648e3 * t1193 - 0.18e2 * t1373 * t765 + t1392 - 0.245e3 / 0.1152e4 * t1393 - t1396 + 0.455e3 / 0.216e3 * t1397;
  t1929 = t583 * t126 * t128 * t347;
  t1937 = -0.49e2 / 0.1152e4 * t1651 + 0.7e1 / 0.48e2 * t1655 + 0.49e2 / 0.2304e4 * t1659 + t1158 + 0.343e3 / 0.165888e6 * t1163 - t1170 - t1183 + 0.343e3 / 0.55296e5 * t1401 + 0.7e1 / 0.8e1 * t1664 - 0.7e1 / 0.12e2 * t1668 - 0.7e1 / 0.24e2 * t1671 - 0.7e1 / 0.24e2 * t1929 - t1418 + t1421 + 0.24e2 * t1203 * t835 * t112 - 0.18e2 * t516 * t356 * t299;
  t1946 = t684 * t152;
  t1948 = t272 * t352;
  t1950 = t272 * t362;
  t1952 = 0.3e1 * t115 * t318 * t362 + t1875 + 0.3e1 * t1481 * t571 * t362 + 0.3e1 * t1723 + 0.3e1 * t348 * t318 + 0.3e1 * t300 * t353 + 0.3e1 * t300 * t363 + 0.3e1 * t148 * t779 + t113 * t829 + 0.6e1 * t1733 + t113 * t848 + t115 * t72 * (t1918 + t1937) + 0.6e1 * t1739 + 0.6e1 * t1741 + 0.3e1 * t1743 + 0.3e1 * t1745 + 0.3e1 * t1747 + 0.3e1 * t1946 + 0.3e1 * t1948 + 0.3e1 * t1950;
  tv4rho43 = t1871 + t1952;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1965 = t344 * t344;
  t1978 = t326 * t326;
  t1983 = t330 * t330;
  t1989 = 0.24e2 * t473 + 0.24e2 * t1075;
  t1993 = my_piecewise3(t40, 0, -0.56e2 / 0.81e2 * t1062 * t1978 + 0.16e2 / 0.9e1 * t700 * t330 - 0.2e1 / 0.3e1 * t202 * t1983 - 0.8e1 / 0.9e1 * t279 * t800 + 0.2e1 / 0.3e1 * t96 * t1989);
  t1994 = t335 * t335;
  t1999 = t338 * t338;
  t2008 = my_piecewise3(t47, 0, -0.56e2 / 0.81e2 * t1084 * t1994 + 0.16e2 / 0.9e1 * t715 * t338 - 0.2e1 / 0.3e1 * t215 * t1999 - 0.8e1 / 0.9e1 * t287 * t810 - 0.2e1 / 0.3e1 * t103 * t1989);
  t2013 = -t1018 - t1022 - t1028 - 0.144e3 * t1822 - 0.36e2 * t197 * t1965 - 0.48e2 * t197 * t144 * t816 + t1048 + t1107 + t1131 - 0.48e2 * t1819 - 0.24e2 * t1280 - 0.72e2 * t1566 - 0.36e2 * t1574 - 0.24e2 * t1814 - 0.72e2 * t1811 * t344 - 0.6e1 * t95 * (t1993 / 0.2e1 + t2008 / 0.2e1);
  t2026 = t355 * t355;
  t2033 = t347 * t347;
  t2040 = -t118 * t2013 * t119 + t1158 - 0.245e3 / 0.864e3 * t1393 - 0.49e2 / 0.576e3 * t1651 + 0.49e2 / 0.1152e4 * t1659 + 0.7e1 / 0.6e1 * t1904 + 0.7e1 / 0.36e2 * t1908 - t1170 - t1183 + 0.343e3 / 0.41472e5 * t1401 + 0.455e3 / 0.162e3 * t1397 + 0.35e2 / 0.18e2 * t1633 - 0.35e2 / 0.36e2 * t1635 - 0.7e1 / 0.6e1 * t1929 + t1200 + 0.24e2 * t1203 * t2026 * t119 - 0.36e2 * t516 * t356 * t347 + 0.6e1 * t238 * t2033 * t119 + 0.8e1 * t238 * t150 * t819;
  t2053 = t352 * t352;
  t2056 = t362 * t362;
  tv4rho44 = 0.4e1 * t115 * t153 * t847 + t115 * t72 * t2040 + t115 * t72 * t2053 + 0.3e1 * t115 * t72 * t2056 + 0.6e1 * t115 * t353 * t362 + t9 * t2013 * t72 + 0.4e1 * t148 * t829 + 0.12e2 * t148 * t831 + 0.4e1 * t148 * t848 + 0.4e1 * t820 * t153 + 0.6e1 * t348 * t353 + 0.6e1 * t348 * t363 + 0.4e1 * t1758 + 0.4e1 * t1840 + 0.12e2 * t1849 + 0.4e1 * t1875 + 0.12e2 * t1946 + 0.12e2 * t1948 + 0.12e2 * t1950;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2067 = t365 * t233 * t372;
  t2070 = t859 * t869 * t381;
  t2075 = t157 * t869 * t60 * t127 * t269;
  t2078 = t157 * t508 * t372;
  t2082 = t377 * t233 * params->h * t381;
  t2086 = t377 * t269 * params->h * t381;
  t2090 = t251 * t72 * params->h * t159;
  t2091 = 0.35e2 / 0.162e3 * t2090;
  t2093 = t850 * t132 * t372;
  t2097 = t260 * t72 * params->h * t381;
  t2098 = 0.1169e4 / 0.10368e5 * t2097;
  t2100 = t365 * t269 * t372;
  t2103 = t157 * t565 * t372;
  t2107 = t991 * t561 * t262;
  t2108 = t874 * t132 * t2107;
  t2114 = t1171 * t1179;
  t2117 = 0.1e1 / t10 / t1195 * t72 * params->h * t2114 * t558 * t2;
  t2118 = 0.343e3 / 0.2654208e7 * t2117;
  t2119 = t555 * t9;
  t2123 = 0.1e1 / t2119 * t72 * params->h * t877;
  t2124 = 0.343e3 / 0.27648e5 * t2123;
  tv4rho3sigma0 = -t2067 / 0.12e2 - 0.7e1 / 0.128e3 * t2070 + t2075 / 0.16e2 + t2078 / 0.48e2 + 0.7e1 / 0.768e3 * t2082 + 0.7e1 / 0.768e3 * t2086 - t2091 + 0.7e1 / 0.36e2 * t2093 + t2098 - t2100 / 0.12e2 + t2103 / 0.48e2 + 0.49e2 / 0.18432e5 * t2108 + t2118 - t2124;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2131 = 0.35e2 / 0.81e2 * t2090;
  t2133 = 0.1169e4 / 0.5184e4 * t2097;
  t2137 = 0.343e3 / 0.1327104e7 * t2117;
  t2138 = 0.343e3 / 0.13824e5 * t2123;
  tv4rho3sigma1 = -t2067 / 0.6e1 - 0.7e1 / 0.64e2 * t2070 + t2075 / 0.8e1 + t2078 / 0.24e2 + 0.7e1 / 0.384e3 * t2082 + 0.7e1 / 0.384e3 * t2086 - t2131 + 0.7e1 / 0.18e2 * t2093 + t2133 - t2100 / 0.6e1 + t2103 / 0.24e2 + 0.49e2 / 0.9216e4 * t2108 + t2137 - t2138;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  tv4rho3sigma2 = tv4rho3sigma0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2140 = 0.7e1 / 0.192e3 * t2070;
  t2144 = t850 * t152 * t372;
  t2147 = t365 * t571 * t372;
  t2148 = t2147 / 0.18e2;
  t2150 = t859 * t897 * t381;
  t2153 = t157 * t1437 * t372;
  t2156 = t157 * t1430 * t372;
  t2160 = t377 * t317 * params->h * t381;
  t2161 = 0.7e1 / 0.1152e4 * t2160;
  t2162 = -t2067 / 0.36e2 - t2140 + 0.7e1 / 0.2304e4 * t2082 + 0.7e1 / 0.2304e4 * t2086 + 0.7e1 / 0.108e3 * t2144 - t2148 - 0.7e1 / 0.384e3 * t2150 + t2153 / 0.48e2 + t2156 / 0.24e2 + t2161 - t2091;
  t2163 = 0.7e1 / 0.54e2 * t2093;
  t2165 = 0.49e2 / 0.27648e5 * t2108;
  t2167 = t365 * t317 * t372;
  t2168 = t2167 / 0.18e2;
  t2170 = t157 * t660 * t372;
  t2173 = t874 * t152 * t2107;
  t2176 = t157 * t1440 * t372;
  t2181 = t377 * t571 * t940 * t397 * t65;
  t2182 = 0.7e1 / 0.1152e4 * t2181;
  t2183 = t2163 + t2098 - t2100 / 0.36e2 + t2165 + t2118 - t2168 + t2170 / 0.48e2 + 0.49e2 / 0.55296e5 * t2173 + t2176 / 0.48e2 + t2182 - t2124;
  tv4rho3sigma3 = t2162 + t2183;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t2188 = 0.7e1 / 0.54e2 * t2144;
  t2189 = t2147 / 0.9e1;
  t2190 = 0.7e1 / 0.192e3 * t2150;
  t2193 = 0.7e1 / 0.576e3 * t2160;
  t2194 = -t2067 / 0.18e2 - 0.7e1 / 0.96e2 * t2070 + 0.7e1 / 0.1152e4 * t2082 + 0.7e1 / 0.1152e4 * t2086 + t2188 - t2189 - t2190 + t2153 / 0.24e2 + t2156 / 0.12e2 + t2193 - t2131;
  t2198 = t2167 / 0.9e1;
  t2200 = 0.49e2 / 0.27648e5 * t2173;
  t2202 = 0.7e1 / 0.576e3 * t2181;
  t2203 = 0.7e1 / 0.27e2 * t2093 + t2133 - t2100 / 0.18e2 + 0.49e2 / 0.13824e5 * t2108 + t2137 - t2198 + t2170 / 0.24e2 + t2200 + t2176 / 0.24e2 + t2202 - t2138;
  tv4rho3sigma4 = t2194 + t2203;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  tv4rho3sigma5 = tv4rho3sigma3;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2206 = t365 * t352 * t372;
  t2208 = t157 * t897;
  t2211 = t2208 * t60 * t127 * t317;
  t2214 = t157 * t1686 * t372;
  t2218 = t377 * t352 * params->h * t381;
  t2221 = t365 * t362 * t372;
  t2224 = t157 * t1690 * t372;
  t2226 = -0.7e1 / 0.384e3 * t2070 + t2188 - t2148 - t2190 + t2161 - t2206 / 0.36e2 + t2211 / 0.24e2 + t2214 / 0.48e2 + 0.7e1 / 0.2304e4 * t2218 - t2221 / 0.36e2 + t2224 / 0.48e2;
  t2229 = t377 * t362 * params->h * t381;
  t2234 = t157 * t778 * t372;
  t2236 = 0.7e1 / 0.2304e4 * t2229 - t2091 + 0.7e1 / 0.108e3 * t2093 + t2098 + 0.49e2 / 0.55296e5 * t2108 + t2118 - t2168 + t2200 + t2234 / 0.48e2 + t2182 - t2124;
  tv4rho3sigma6 = t2226 + t2236;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  t2245 = -t2140 + 0.7e1 / 0.27e2 * t2144 - t2189 - 0.7e1 / 0.96e2 * t2150 + t2193 - t2206 / 0.18e2 + t2211 / 0.12e2 + t2214 / 0.24e2 + 0.7e1 / 0.1152e4 * t2218 - t2221 / 0.18e2 + t2224 / 0.24e2;
  t2249 = 0.7e1 / 0.1152e4 * t2229 - t2131 + t2163 + t2133 + t2165 + t2137 - t2198 + 0.49e2 / 0.13824e5 * t2173 + t2234 / 0.24e2 + t2202 - t2138;
  tv4rho3sigma7 = t2245 + t2249;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  tv4rho3sigma8 = tv4rho3sigma6;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2258 = t2208 * t60 * t127 * t362;
  t2261 = t157 * t828 * t372;
  t2265 = t157 * t847 * t372;
  tv4rho3sigma9 = 0.7e1 / 0.36e2 * t2144 - 0.7e1 / 0.128e3 * t2150 - t2206 / 0.12e2 + 0.7e1 / 0.768e3 * t2218 - t2221 / 0.12e2 + 0.7e1 / 0.768e3 * t2229 + t2258 / 0.16e2 + t2261 / 0.48e2 - t2091 + t2098 + t2118 + 0.49e2 / 0.18432e5 * t2173 + t2265 / 0.48e2 - t2124;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.7e1 / 0.18e2 * t2144 - 0.7e1 / 0.64e2 * t2150 - t2206 / 0.6e1 + 0.7e1 / 0.384e3 * t2218 - t2221 / 0.6e1 + 0.7e1 / 0.384e3 * t2229 + t2258 / 0.8e1 + t2261 / 0.24e2 - t2131 + t2133 + t2137 + 0.49e2 / 0.9216e4 * t2173 + t2265 / 0.24e2 - t2138;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  tv4rho3sigma11 = tv4rho3sigma9;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2278 = t859 * t394 * t398;
  t2279 = 0.77e2 / 0.3456e4 * t2278;
  t2280 = t377 * t923;
  t2281 = t2280 * t926;
  t2282 = 0.11e2 / 0.1152e4 * t2281;
  t2284 = t377 * t919 * t398;
  t2285 = 0.11e2 / 0.1152e4 * t2284;
  t2288 = t393 * t269 * t394 * t398;
  t2291 = t930 * t919 * t934;
  t2292 = 0.7e1 / 0.9216e4 * t2291;
  t2295 = t924 * t379 * t264 * t228;
  t2297 = t930 * t923;
  t2300 = t2297 * t876 * t112 * t65;
  t2301 = 0.7e1 / 0.9216e4 * t2300;
  t2304 = 0.1e1 / t10 / t556 * t72;
  t2305 = t394 * t70;
  t2308 = t2114 * t262 * t2;
  t2309 = t2304 * t2305 * t2308;
  t2310 = 0.49e2 / 0.884736e6 * t2309;
  t2312 = t393 * t233 * t941;
  t2315 = t874 * t394 * t934;
  t2316 = 0.7e1 / 0.1728e4 * t2315;
  t2317 = t860 * t401;
  t2318 = 0.77e2 / 0.3456e4 * t2317;
  t2320 = t377 * t132 * t941;
  t2321 = 0.11e2 / 0.1152e4 * t2320;
  t2323 = t393 * t269 * t941;
  t2326 = t991 * t933;
  t2327 = t930 * t132 * t2326;
  t2328 = 0.7e1 / 0.9216e4 * t2327;
  t2330 = t2304 * params->h * t2308;
  t2331 = 0.49e2 / 0.884736e6 * t2330;
  t2332 = t117 * t1;
  t2334 = t2332 * t397 * t112;
  t2335 = t920 * t2334;
  t2339 = t393 * t233 * t394 * t398;
  t2342 = t393 * t394 * t237;
  t2345 = t2342 * t379 * t264 * t239;
  t2347 = t875 * t945;
  t2348 = 0.7e1 / 0.1728e4 * t2347;
  tv4rho2sigma20 = t2279 + t2282 - t2285 + t2288 / 0.768e3 + t2292 - t2295 / 0.768e3 - t2301 + t2310 - t2312 / 0.768e3 - t2316 - t2318 + t2321 - t2323 / 0.768e3 - t2328 - t2331 - t2335 / 0.384e3 + t2339 / 0.768e3 + t2345 / 0.384e3 + t2348;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2349 = 0.77e2 / 0.1728e4 * t2278;
  t2350 = 0.11e2 / 0.576e3 * t2281;
  t2351 = 0.11e2 / 0.576e3 * t2284;
  t2353 = 0.7e1 / 0.4608e4 * t2291;
  t2355 = 0.7e1 / 0.4608e4 * t2300;
  t2356 = 0.49e2 / 0.442368e6 * t2309;
  t2358 = 0.7e1 / 0.864e3 * t2315;
  t2359 = 0.77e2 / 0.1728e4 * t2317;
  t2360 = 0.11e2 / 0.576e3 * t2320;
  t2362 = 0.7e1 / 0.4608e4 * t2327;
  t2363 = 0.49e2 / 0.442368e6 * t2330;
  t2367 = 0.7e1 / 0.864e3 * t2347;
  tv4rho2sigma21 = t2349 + t2350 - t2351 + t2288 / 0.384e3 + t2353 - t2295 / 0.384e3 - t2355 + t2356 - t2312 / 0.384e3 - t2358 - t2359 + t2360 - t2323 / 0.384e3 - t2362 - t2363 - t2335 / 0.192e3 + t2339 / 0.384e3 + t2345 / 0.192e3 + t2367;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = tv4rho2sigma20;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  t2368 = 0.77e2 / 0.864e3 * t2278;
  t2375 = 0.49e2 / 0.221184e6 * t2309;
  t2377 = 0.7e1 / 0.432e3 * t2315;
  t2378 = 0.77e2 / 0.864e3 * t2317;
  t2382 = 0.49e2 / 0.221184e6 * t2330;
  t2386 = 0.7e1 / 0.432e3 * t2347;
  tv4rho2sigma23 = t2368 + 0.11e2 / 0.288e3 * t2281 - 0.11e2 / 0.288e3 * t2284 + t2288 / 0.192e3 + 0.7e1 / 0.2304e4 * t2291 - t2295 / 0.192e3 - 0.7e1 / 0.2304e4 * t2300 + t2375 - t2312 / 0.192e3 - t2377 - t2378 + 0.11e2 / 0.288e3 * t2320 - t2323 / 0.192e3 - 0.7e1 / 0.2304e4 * t2327 - t2382 - t2335 / 0.96e2 + t2339 / 0.192e3 + t2345 / 0.96e2 + t2386;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = tv4rho2sigma21;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  tv4rho2sigma25 = tv4rho2sigma22;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2389 = t393 * t317 * t394 * t398;
  t2392 = t930 * t962 * t934;
  t2396 = t924 * t379 * t264 * t299;
  t2400 = t2297 * t876 * t147 * t65;
  t2402 = t393 * t571;
  t2403 = t2402 * t941;
  t2406 = t377 * t962 * t398;
  t2408 = t2280 * t967;
  t2414 = t2348 - t2318 + t2389 / 0.768e3 + 0.7e1 / 0.18432e5 * t2392 - t2396 / 0.768e3 - 0.7e1 / 0.18432e5 * t2400 - t2403 / 0.768e3 - 0.11e2 / 0.2304e4 * t2406 + 0.11e2 / 0.2304e4 * t2408 + 0.11e2 / 0.2304e4 * t2281 - 0.11e2 / 0.2304e4 * t2284 + 0.7e1 / 0.18432e5 * t2291 - 0.7e1 / 0.18432e5 * t2300;
  t2418 = t377 * t152 * t941;
  t2421 = t393 * t317 * t941;
  t2424 = t930 * t152 * t2326;
  t2426 = t963 * t2334;
  t2429 = t2402 * t2305 * t401;
  t2433 = t2342 * t379 * t966 * t112;
  t2436 = t2332 * t397 * t147;
  t2437 = t920 * t2436;
  t2439 = t2310 + t2279 - t2316 + 0.11e2 / 0.2304e4 * t2320 - 0.7e1 / 0.18432e5 * t2327 - t2331 + 0.11e2 / 0.2304e4 * t2418 - t2421 / 0.768e3 - 0.7e1 / 0.18432e5 * t2424 - t2426 / 0.768e3 + t2429 / 0.768e3 + t2433 / 0.384e3 - t2437 / 0.768e3;
  tv4rho2sigma26 = t2414 + t2439;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  t2441 = 0.7e1 / 0.9216e4 * t2392;
  t2443 = 0.7e1 / 0.9216e4 * t2400;
  t2445 = 0.11e2 / 0.1152e4 * t2406;
  t2446 = 0.11e2 / 0.1152e4 * t2408;
  t2447 = t2367 - t2359 + t2389 / 0.384e3 + t2441 - t2396 / 0.384e3 - t2443 - t2403 / 0.384e3 - t2445 + t2446 + t2282 - t2285 + t2292 - t2301;
  t2448 = 0.11e2 / 0.1152e4 * t2418;
  t2450 = 0.7e1 / 0.9216e4 * t2424;
  t2455 = t2356 + t2349 - t2358 + t2321 - t2328 - t2363 + t2448 - t2421 / 0.384e3 - t2450 - t2426 / 0.384e3 + t2429 / 0.384e3 + t2433 / 0.192e3 - t2437 / 0.384e3;
  tv4rho2sigma27 = t2447 + t2455;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = tv4rho2sigma26;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  t2457 = 0.7e1 / 0.4608e4 * t2392;
  t2459 = 0.7e1 / 0.4608e4 * t2400;
  t2461 = 0.11e2 / 0.576e3 * t2406;
  t2462 = 0.11e2 / 0.576e3 * t2408;
  t2463 = t2386 - t2378 + t2389 / 0.192e3 + t2457 - t2396 / 0.192e3 - t2459 - t2403 / 0.192e3 - t2461 + t2462 + t2350 - t2351 + t2353 - t2355;
  t2464 = 0.11e2 / 0.576e3 * t2418;
  t2466 = 0.7e1 / 0.4608e4 * t2424;
  t2471 = t2375 + t2368 - t2377 + t2360 - t2362 - t2382 + t2464 - t2421 / 0.192e3 - t2466 - t2426 / 0.192e3 + t2429 / 0.192e3 + t2433 / 0.96e2 - t2437 / 0.192e3;
  tv4rho2sigma29 = t2463 + t2471;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = tv4rho2sigma27;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  tv4rho2sigma211 = tv4rho2sigma28;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2474 = t393 * t362 * t394 * t398;
  t2478 = t924 * t379 * t264 * t347;
  t2481 = t393 * t352 * t941;
  t2484 = t393 * t362 * t941;
  t2486 = t963 * t2436;
  t2490 = t393 * t352 * t394 * t398;
  t2494 = t2342 * t379 * t264 * t355;
  tv4rho2sigma212 = t2279 + t2310 + t2441 - t2443 + t2448 + t2474 / 0.768e3 - t2478 / 0.768e3 - t2481 / 0.768e3 - t2316 - t2318 - t2331 - t2450 - t2484 / 0.768e3 - t2445 + t2446 - t2486 / 0.384e3 + t2490 / 0.768e3 + t2494 / 0.384e3 + t2348;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = t2349 + t2356 + t2457 - t2459 + t2464 + t2474 / 0.384e3 - t2478 / 0.384e3 - t2481 / 0.384e3 - t2358 - t2359 - t2363 - t2466 - t2484 / 0.384e3 - t2461 + t2462 - t2486 / 0.192e3 + t2490 / 0.384e3 + t2494 / 0.192e3 + t2367;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = tv4rho2sigma212;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = t2368 + t2375 + 0.7e1 / 0.2304e4 * t2392 - 0.7e1 / 0.2304e4 * t2400 + 0.11e2 / 0.288e3 * t2418 + t2474 / 0.192e3 - t2478 / 0.192e3 - t2481 / 0.192e3 - t2377 - t2378 - t2382 - 0.7e1 / 0.2304e4 * t2424 - t2484 / 0.192e3 - 0.11e2 / 0.288e3 * t2406 + 0.11e2 / 0.288e3 * t2408 - t2486 / 0.96e2 + t2490 / 0.192e3 + t2494 / 0.96e2 + t2386;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = tv4rho2sigma213;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  tv4rho2sigma217 = tv4rho2sigma214;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2517 = t930 * t981 * t984;
  t2518 = t2517 / 0.2048e4;
  t2519 = t980 * t132;
  t2520 = t981 * t117;
  t2521 = t2520 * t876;
  t2522 = t2519 * t2521;
  t2524 = t237 * M_PI;
  t2525 = t561 * t112;
  t2527 = t982 * t2524 * t2525;
  t2531 = 0.1e1 / t10 / t2119 * t72;
  t2534 = t2114 * t2 * t65;
  t2535 = t2531 * t2520 * t2534;
  t2536 = 0.7e1 / 0.589824e6 * t2535;
  t2537 = t931 * t988;
  t2538 = 0.3e1 / 0.2048e4 * t2537;
  t2539 = t2305 * t876;
  t2540 = t2519 * t2539;
  t2543 = t987 * t983 * t2525;
  t2546 = t2531 * t2305 * t2534;
  t2547 = 0.7e1 / 0.196608e6 * t2546;
  t2548 = t930 * t992;
  t2549 = t2548 / 0.1024e4;
  t2550 = t2519 * t992;
  t2553 = t2531 * params->h * t2534;
  t2554 = 0.7e1 / 0.294912e6 * t2553;
  tv4rhosigma30 = -t2518 + t2522 / 0.12288e5 - t2527 / 0.6144e4 + t2536 + t2538 - t2540 / 0.4096e4 + t2543 / 0.4096e4 - t2547 - t2549 + t2550 / 0.6144e4 + t2554;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t2555 = t2517 / 0.1024e4;
  t2558 = 0.7e1 / 0.294912e6 * t2535;
  t2559 = 0.3e1 / 0.1024e4 * t2537;
  t2562 = 0.7e1 / 0.98304e5 * t2546;
  t2563 = t2548 / 0.512e3;
  t2565 = 0.7e1 / 0.147456e6 * t2553;
  tv4rhosigma31 = -t2555 + t2522 / 0.6144e4 - t2527 / 0.3072e4 + t2558 + t2559 - t2540 / 0.2048e4 + t2543 / 0.2048e4 - t2562 - t2563 + t2550 / 0.3072e4 + t2565;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = tv4rhosigma30;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  t2566 = t2517 / 0.512e3;
  t2569 = 0.7e1 / 0.147456e6 * t2535;
  t2570 = 0.3e1 / 0.512e3 * t2537;
  t2573 = 0.7e1 / 0.49152e5 * t2546;
  t2574 = t2548 / 0.256e3;
  t2576 = 0.7e1 / 0.73728e5 * t2553;
  tv4rhosigma33 = -t2566 + t2522 / 0.3072e4 - t2527 / 0.1536e4 + t2569 + t2570 - t2540 / 0.1024e4 + t2543 / 0.1024e4 - t2573 - t2574 + t2550 / 0.1536e4 + t2576;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = tv4rhosigma31;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = tv4rhosigma32;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  t2577 = t2517 / 0.256e3;
  t2580 = 0.7e1 / 0.73728e5 * t2535;
  t2581 = 0.3e1 / 0.256e3 * t2537;
  t2584 = 0.7e1 / 0.24576e5 * t2546;
  t2585 = t2548 / 0.128e3;
  t2587 = 0.7e1 / 0.36864e5 * t2553;
  tv4rhosigma36 = -t2577 + t2522 / 0.1536e4 - t2527 / 0.768e3 + t2580 + t2581 - t2540 / 0.512e3 + t2543 / 0.512e3 - t2584 - t2585 + t2550 / 0.768e3 + t2587;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = tv4rhosigma33;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = tv4rhosigma34;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  tv4rhosigma39 = tv4rhosigma35;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2588 = t980 * t152;
  t2589 = t2588 * t2521;
  t2591 = t561 * t147;
  t2593 = t982 * t2524 * t2591;
  t2595 = t2588 * t2539;
  t2598 = t987 * t983 * t2591;
  t2600 = t2588 * t992;
  tv4rhosigma310 = -t2518 + t2589 / 0.12288e5 - t2593 / 0.6144e4 + t2536 + t2538 - t2595 / 0.4096e4 + t2598 / 0.4096e4 - t2547 - t2549 + t2600 / 0.6144e4 + t2554;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = -t2555 + t2589 / 0.6144e4 - t2593 / 0.3072e4 + t2558 + t2559 - t2595 / 0.2048e4 + t2598 / 0.2048e4 - t2562 - t2563 + t2600 / 0.3072e4 + t2565;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = tv4rhosigma310;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = -t2566 + t2589 / 0.3072e4 - t2593 / 0.1536e4 + t2569 + t2570 - t2595 / 0.1024e4 + t2598 / 0.1024e4 - t2573 - t2574 + t2600 / 0.1536e4 + t2576;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = tv4rhosigma311;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = tv4rhosigma312;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = -t2577 + t2589 / 0.1536e4 - t2593 / 0.768e3 + t2580 + t2581 - t2595 / 0.512e3 + t2598 / 0.512e3 - t2584 - t2585 + t2600 / 0.768e3 + t2587;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = tv4rhosigma313;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = tv4rhosigma314;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  tv4rhosigma319 = tv4rhosigma315;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2619 = 0.1e1 / t10 / t555 * t72;
  t2620 = t394 * t394;
  t2624 = t2619 * t2620 * t237 * t2 * t2114;
  t2629 = t2619 * t981 * t117 * t1171 * t1180;
  t2634 = t2619 * t394 * t70 * t1171 * t1180;
  t2638 = t2619 * params->h * t2114 * t2;
  tv4sigma40 = t2624 / 0.589824e6 - t2629 / 0.98304e5 + 0.11e2 / 0.589824e6 * t2634 - t2638 / 0.98304e5;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = t2624 / 0.294912e6 - t2629 / 0.49152e5 + 0.11e2 / 0.294912e6 * t2634 - t2638 / 0.49152e5;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = tv4sigma40;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = t2624 / 0.147456e6 - t2629 / 0.24576e5 + 0.11e2 / 0.147456e6 * t2634 - t2638 / 0.24576e5;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = tv4sigma41;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = tv4sigma42;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = t2624 / 0.73728e5 - t2629 / 0.12288e5 + 0.11e2 / 0.73728e5 * t2634 - t2638 / 0.12288e5;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = tv4sigma43;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = tv4sigma44;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = tv4sigma45;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = t2624 / 0.36864e5 - t2629 / 0.6144e4 + 0.11e2 / 0.36864e5 * t2634 - t2638 / 0.6144e4;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = tv4sigma46;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = tv4sigma47;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = tv4sigma48;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  tv4sigma414 = tv4sigma49;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

