#include "atomic_ops.h"
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic(void)
{
# if defined(AO_HAVE_load) || defined(AO_HAVE_store) \
     || defined(AO_HAVE_fetch_and_add) \
     || defined(AO_HAVE_fetch_and_add1) \
     || defined(AO_HAVE_and) \
     || defined(AO_HAVE_compare_and_swap) \
     || defined(AO_HAVE_fetch_compare_and_swap)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap) \
     || defined(AO_HAVE_fetch_compare_and_swap)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store) \
     || defined(AO_HAVE_compare_and_swap) \
     || defined(AO_HAVE_fetch_compare_and_swap)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add) || defined(AO_HAVE_and) \
     || defined(AO_HAVE_or) || defined(AO_HAVE_xor)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop)
    (void)"AO_nop(): ";
    AO_nop();
# else
    (void)"No AO_nop";
# endif

# ifdef AO_HAVE_load
    (void)"AO_load(&val):";
    (void)AO_load(&val);
# else
    (void)"No AO_load";
# endif
# ifdef AO_HAVE_store
    (void)"AO_store(&val, newval):";
    AO_store(&val, newval);
# else
    (void)"No AO_store";
# endif
# ifdef AO_HAVE_fetch_and_add
    (void)"AO_fetch_and_add(&val, incr):";
    (void)AO_fetch_and_add(&val, incr);
# else
    (void)"No AO_fetch_and_add";
# endif
# ifdef AO_HAVE_fetch_and_add1
    (void)"AO_fetch_and_add1(&val):";
    (void)AO_fetch_and_add1(&val);
# else
    (void)"No AO_fetch_and_add1";
# endif
# ifdef AO_HAVE_fetch_and_sub1
    (void)"AO_fetch_and_sub1(&val):";
    (void)AO_fetch_and_sub1(&val);
# else
    (void)"No AO_fetch_and_sub1";
# endif
# ifdef AO_HAVE_and
    (void)"AO_and(&val, incr):";
    AO_and(&val, incr);
# else
    (void)"No AO_and";
# endif
# ifdef AO_HAVE_or
    (void)"AO_or(&val, incr):";
    AO_or(&val, incr);
# else
    (void)"No AO_or";
# endif
# ifdef AO_HAVE_xor
    (void)"AO_xor(&val, incr):";
    AO_xor(&val, incr);
# else
    (void)"No AO_xor";
# endif
# ifdef AO_HAVE_compare_and_swap
    (void)"AO_compare_and_swap(&val, oldval, newval):";
    if (!AO_compare_and_swap(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap";
# endif
  /* TODO: Add AO_compare_double_and_swap_double */
  /* TODO: Add AO_compare_and_swap_double */
# ifdef AO_HAVE_fetch_compare_and_swap
    (void)"AO_fetch_compare_and_swap(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap";
# endif

# if defined(AO_HAVE_test_and_set)
    (void)"AO_test_and_set(&ts):";
    (void)AO_test_and_set(&ts);
# else
    (void)"No AO_test_and_set";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_release(void)
{
# if defined(AO_HAVE_load_release) || defined(AO_HAVE_store_release) \
     || defined(AO_HAVE_fetch_and_add_release) \
     || defined(AO_HAVE_fetch_and_add1_release) \
     || defined(AO_HAVE_and_release) \
     || defined(AO_HAVE_compare_and_swap_release) \
     || defined(AO_HAVE_fetch_compare_and_swap_release)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_release) \
     || defined(AO_HAVE_fetch_compare_and_swap_release)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_release) \
     || defined(AO_HAVE_compare_and_swap_release) \
     || defined(AO_HAVE_fetch_compare_and_swap_release)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_release) || defined(AO_HAVE_and_release) \
     || defined(AO_HAVE_or_release) || defined(AO_HAVE_xor_release)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release)
    (void)"AO_nop_release(): ";
    AO_nop_release();
# else
    (void)"No AO_nop_release";
# endif

# ifdef AO_HAVE_load_release
    (void)"AO_load_release(&val):";
    (void)AO_load_release(&val);
# else
    (void)"No AO_load_release";
# endif
# ifdef AO_HAVE_store_release
    (void)"AO_store_release(&val, newval):";
    AO_store_release(&val, newval);
# else
    (void)"No AO_store_release";
# endif
# ifdef AO_HAVE_fetch_and_add_release
    (void)"AO_fetch_and_add_release(&val, incr):";
    (void)AO_fetch_and_add_release(&val, incr);
# else
    (void)"No AO_fetch_and_add_release";
# endif
# ifdef AO_HAVE_fetch_and_add1_release
    (void)"AO_fetch_and_add1_release(&val):";
    (void)AO_fetch_and_add1_release(&val);
# else
    (void)"No AO_fetch_and_add1_release";
# endif
# ifdef AO_HAVE_fetch_and_sub1_release
    (void)"AO_fetch_and_sub1_release(&val):";
    (void)AO_fetch_and_sub1_release(&val);
# else
    (void)"No AO_fetch_and_sub1_release";
# endif
# ifdef AO_HAVE_and_release
    (void)"AO_and_release(&val, incr):";
    AO_and_release(&val, incr);
# else
    (void)"No AO_and_release";
# endif
# ifdef AO_HAVE_or_release
    (void)"AO_or_release(&val, incr):";
    AO_or_release(&val, incr);
# else
    (void)"No AO_or_release";
# endif
# ifdef AO_HAVE_xor_release
    (void)"AO_xor_release(&val, incr):";
    AO_xor_release(&val, incr);
# else
    (void)"No AO_xor_release";
# endif
# ifdef AO_HAVE_compare_and_swap_release
    (void)"AO_compare_and_swap_release(&val, oldval, newval):";
    if (!AO_compare_and_swap_release(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_release";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release */
  /* TODO: Add AO_compare_and_swap_double_release */
# ifdef AO_HAVE_fetch_compare_and_swap_release
    (void)"AO_fetch_compare_and_swap_release(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_release(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_release";
# endif

# if defined(AO_HAVE_test_and_set_release)
    (void)"AO_test_and_set_release(&ts):";
    (void)AO_test_and_set_release(&ts);
# else
    (void)"No AO_test_and_set_release";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_acquire(void)
{
# if defined(AO_HAVE_load_acquire) || defined(AO_HAVE_store_acquire) \
     || defined(AO_HAVE_fetch_and_add_acquire) \
     || defined(AO_HAVE_fetch_and_add1_acquire) \
     || defined(AO_HAVE_and_acquire) \
     || defined(AO_HAVE_compare_and_swap_acquire) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_acquire) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_acquire) \
     || defined(AO_HAVE_compare_and_swap_acquire) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_acquire) || defined(AO_HAVE_and_acquire) \
     || defined(AO_HAVE_or_acquire) || defined(AO_HAVE_xor_acquire)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire)
    (void)"AO_nop_acquire(): ";
    AO_nop_acquire();
# else
    (void)"No AO_nop_acquire";
# endif

# ifdef AO_HAVE_load_acquire
    (void)"AO_load_acquire(&val):";
    (void)AO_load_acquire(&val);
# else
    (void)"No AO_load_acquire";
# endif
# ifdef AO_HAVE_store_acquire
    (void)"AO_store_acquire(&val, newval):";
    AO_store_acquire(&val, newval);
# else
    (void)"No AO_store_acquire";
# endif
# ifdef AO_HAVE_fetch_and_add_acquire
    (void)"AO_fetch_and_add_acquire(&val, incr):";
    (void)AO_fetch_and_add_acquire(&val, incr);
# else
    (void)"No AO_fetch_and_add_acquire";
# endif
# ifdef AO_HAVE_fetch_and_add1_acquire
    (void)"AO_fetch_and_add1_acquire(&val):";
    (void)AO_fetch_and_add1_acquire(&val);
# else
    (void)"No AO_fetch_and_add1_acquire";
# endif
# ifdef AO_HAVE_fetch_and_sub1_acquire
    (void)"AO_fetch_and_sub1_acquire(&val):";
    (void)AO_fetch_and_sub1_acquire(&val);
# else
    (void)"No AO_fetch_and_sub1_acquire";
# endif
# ifdef AO_HAVE_and_acquire
    (void)"AO_and_acquire(&val, incr):";
    AO_and_acquire(&val, incr);
# else
    (void)"No AO_and_acquire";
# endif
# ifdef AO_HAVE_or_acquire
    (void)"AO_or_acquire(&val, incr):";
    AO_or_acquire(&val, incr);
# else
    (void)"No AO_or_acquire";
# endif
# ifdef AO_HAVE_xor_acquire
    (void)"AO_xor_acquire(&val, incr):";
    AO_xor_acquire(&val, incr);
# else
    (void)"No AO_xor_acquire";
# endif
# ifdef AO_HAVE_compare_and_swap_acquire
    (void)"AO_compare_and_swap_acquire(&val, oldval, newval):";
    if (!AO_compare_and_swap_acquire(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_acquire";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire */
  /* TODO: Add AO_compare_and_swap_double_acquire */
# ifdef AO_HAVE_fetch_compare_and_swap_acquire
    (void)"AO_fetch_compare_and_swap_acquire(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_acquire(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_acquire";
# endif

# if defined(AO_HAVE_test_and_set_acquire)
    (void)"AO_test_and_set_acquire(&ts):";
    (void)AO_test_and_set_acquire(&ts);
# else
    (void)"No AO_test_and_set_acquire";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_read(void)
{
# if defined(AO_HAVE_load_read) || defined(AO_HAVE_store_read) \
     || defined(AO_HAVE_fetch_and_add_read) \
     || defined(AO_HAVE_fetch_and_add1_read) \
     || defined(AO_HAVE_and_read) \
     || defined(AO_HAVE_compare_and_swap_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_read)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_read)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_read) \
     || defined(AO_HAVE_compare_and_swap_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_read)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_read) || defined(AO_HAVE_and_read) \
     || defined(AO_HAVE_or_read) || defined(AO_HAVE_xor_read)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_read)
    (void)"AO_nop_read(): ";
    AO_nop_read();
# else
    (void)"No AO_nop_read";
# endif

# ifdef AO_HAVE_load_read
    (void)"AO_load_read(&val):";
    (void)AO_load_read(&val);
# else
    (void)"No AO_load_read";
# endif
# ifdef AO_HAVE_store_read
    (void)"AO_store_read(&val, newval):";
    AO_store_read(&val, newval);
# else
    (void)"No AO_store_read";
# endif
# ifdef AO_HAVE_fetch_and_add_read
    (void)"AO_fetch_and_add_read(&val, incr):";
    (void)AO_fetch_and_add_read(&val, incr);
# else
    (void)"No AO_fetch_and_add_read";
# endif
# ifdef AO_HAVE_fetch_and_add1_read
    (void)"AO_fetch_and_add1_read(&val):";
    (void)AO_fetch_and_add1_read(&val);
# else
    (void)"No AO_fetch_and_add1_read";
# endif
# ifdef AO_HAVE_fetch_and_sub1_read
    (void)"AO_fetch_and_sub1_read(&val):";
    (void)AO_fetch_and_sub1_read(&val);
# else
    (void)"No AO_fetch_and_sub1_read";
# endif
# ifdef AO_HAVE_and_read
    (void)"AO_and_read(&val, incr):";
    AO_and_read(&val, incr);
# else
    (void)"No AO_and_read";
# endif
# ifdef AO_HAVE_or_read
    (void)"AO_or_read(&val, incr):";
    AO_or_read(&val, incr);
# else
    (void)"No AO_or_read";
# endif
# ifdef AO_HAVE_xor_read
    (void)"AO_xor_read(&val, incr):";
    AO_xor_read(&val, incr);
# else
    (void)"No AO_xor_read";
# endif
# ifdef AO_HAVE_compare_and_swap_read
    (void)"AO_compare_and_swap_read(&val, oldval, newval):";
    if (!AO_compare_and_swap_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_read */
  /* TODO: Add AO_compare_and_swap_double_read */
# ifdef AO_HAVE_fetch_compare_and_swap_read
    (void)"AO_fetch_compare_and_swap_read(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_read";
# endif

# if defined(AO_HAVE_test_and_set_read)
    (void)"AO_test_and_set_read(&ts):";
    (void)AO_test_and_set_read(&ts);
# else
    (void)"No AO_test_and_set_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_write(void)
{
# if defined(AO_HAVE_load_write) || defined(AO_HAVE_store_write) \
     || defined(AO_HAVE_fetch_and_add_write) \
     || defined(AO_HAVE_fetch_and_add1_write) \
     || defined(AO_HAVE_and_write) \
     || defined(AO_HAVE_compare_and_swap_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_write)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_write)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_write) \
     || defined(AO_HAVE_compare_and_swap_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_write)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_write) || defined(AO_HAVE_and_write) \
     || defined(AO_HAVE_or_write) || defined(AO_HAVE_xor_write)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_write)
    (void)"AO_nop_write(): ";
    AO_nop_write();
# else
    (void)"No AO_nop_write";
# endif

# ifdef AO_HAVE_load_write
    (void)"AO_load_write(&val):";
    (void)AO_load_write(&val);
# else
    (void)"No AO_load_write";
# endif
# ifdef AO_HAVE_store_write
    (void)"AO_store_write(&val, newval):";
    AO_store_write(&val, newval);
# else
    (void)"No AO_store_write";
# endif
# ifdef AO_HAVE_fetch_and_add_write
    (void)"AO_fetch_and_add_write(&val, incr):";
    (void)AO_fetch_and_add_write(&val, incr);
# else
    (void)"No AO_fetch_and_add_write";
# endif
# ifdef AO_HAVE_fetch_and_add1_write
    (void)"AO_fetch_and_add1_write(&val):";
    (void)AO_fetch_and_add1_write(&val);
# else
    (void)"No AO_fetch_and_add1_write";
# endif
# ifdef AO_HAVE_fetch_and_sub1_write
    (void)"AO_fetch_and_sub1_write(&val):";
    (void)AO_fetch_and_sub1_write(&val);
# else
    (void)"No AO_fetch_and_sub1_write";
# endif
# ifdef AO_HAVE_and_write
    (void)"AO_and_write(&val, incr):";
    AO_and_write(&val, incr);
# else
    (void)"No AO_and_write";
# endif
# ifdef AO_HAVE_or_write
    (void)"AO_or_write(&val, incr):";
    AO_or_write(&val, incr);
# else
    (void)"No AO_or_write";
# endif
# ifdef AO_HAVE_xor_write
    (void)"AO_xor_write(&val, incr):";
    AO_xor_write(&val, incr);
# else
    (void)"No AO_xor_write";
# endif
# ifdef AO_HAVE_compare_and_swap_write
    (void)"AO_compare_and_swap_write(&val, oldval, newval):";
    if (!AO_compare_and_swap_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_write */
  /* TODO: Add AO_compare_and_swap_double_write */
# ifdef AO_HAVE_fetch_compare_and_swap_write
    (void)"AO_fetch_compare_and_swap_write(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_write";
# endif

# if defined(AO_HAVE_test_and_set_write)
    (void)"AO_test_and_set_write(&ts):";
    (void)AO_test_and_set_write(&ts);
# else
    (void)"No AO_test_and_set_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_full(void)
{
# if defined(AO_HAVE_load_full) || defined(AO_HAVE_store_full) \
     || defined(AO_HAVE_fetch_and_add_full) \
     || defined(AO_HAVE_fetch_and_add1_full) \
     || defined(AO_HAVE_and_full) \
     || defined(AO_HAVE_compare_and_swap_full) \
     || defined(AO_HAVE_fetch_compare_and_swap_full)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_full) \
     || defined(AO_HAVE_fetch_compare_and_swap_full)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_full) \
     || defined(AO_HAVE_compare_and_swap_full) \
     || defined(AO_HAVE_fetch_compare_and_swap_full)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_full)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_full) || defined(AO_HAVE_and_full) \
     || defined(AO_HAVE_or_full) || defined(AO_HAVE_xor_full)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_full)
    (void)"AO_nop_full(): ";
    AO_nop_full();
# else
    (void)"No AO_nop_full";
# endif

# ifdef AO_HAVE_load_full
    (void)"AO_load_full(&val):";
    (void)AO_load_full(&val);
# else
    (void)"No AO_load_full";
# endif
# ifdef AO_HAVE_store_full
    (void)"AO_store_full(&val, newval):";
    AO_store_full(&val, newval);
# else
    (void)"No AO_store_full";
# endif
# ifdef AO_HAVE_fetch_and_add_full
    (void)"AO_fetch_and_add_full(&val, incr):";
    (void)AO_fetch_and_add_full(&val, incr);
# else
    (void)"No AO_fetch_and_add_full";
# endif
# ifdef AO_HAVE_fetch_and_add1_full
    (void)"AO_fetch_and_add1_full(&val):";
    (void)AO_fetch_and_add1_full(&val);
# else
    (void)"No AO_fetch_and_add1_full";
# endif
# ifdef AO_HAVE_fetch_and_sub1_full
    (void)"AO_fetch_and_sub1_full(&val):";
    (void)AO_fetch_and_sub1_full(&val);
# else
    (void)"No AO_fetch_and_sub1_full";
# endif
# ifdef AO_HAVE_and_full
    (void)"AO_and_full(&val, incr):";
    AO_and_full(&val, incr);
# else
    (void)"No AO_and_full";
# endif
# ifdef AO_HAVE_or_full
    (void)"AO_or_full(&val, incr):";
    AO_or_full(&val, incr);
# else
    (void)"No AO_or_full";
# endif
# ifdef AO_HAVE_xor_full
    (void)"AO_xor_full(&val, incr):";
    AO_xor_full(&val, incr);
# else
    (void)"No AO_xor_full";
# endif
# ifdef AO_HAVE_compare_and_swap_full
    (void)"AO_compare_and_swap_full(&val, oldval, newval):";
    if (!AO_compare_and_swap_full(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_full";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_full */
  /* TODO: Add AO_compare_and_swap_double_full */
# ifdef AO_HAVE_fetch_compare_and_swap_full
    (void)"AO_fetch_compare_and_swap_full(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_full(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_full";
# endif

# if defined(AO_HAVE_test_and_set_full)
    (void)"AO_test_and_set_full(&ts):";
    (void)AO_test_and_set_full(&ts);
# else
    (void)"No AO_test_and_set_full";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_release_write(void)
{
# if defined(AO_HAVE_load_release_write) || defined(AO_HAVE_store_release_write) \
     || defined(AO_HAVE_fetch_and_add_release_write) \
     || defined(AO_HAVE_fetch_and_add1_release_write) \
     || defined(AO_HAVE_and_release_write) \
     || defined(AO_HAVE_compare_and_swap_release_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_release_write)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_release_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_release_write)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_release_write) \
     || defined(AO_HAVE_compare_and_swap_release_write) \
     || defined(AO_HAVE_fetch_compare_and_swap_release_write)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_release_write) || defined(AO_HAVE_and_release_write) \
     || defined(AO_HAVE_or_release_write) || defined(AO_HAVE_xor_release_write)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release_write)
    (void)"AO_nop_release_write(): ";
    AO_nop_release_write();
# else
    (void)"No AO_nop_release_write";
# endif

# ifdef AO_HAVE_load_release_write
    (void)"AO_load_release_write(&val):";
    (void)AO_load_release_write(&val);
# else
    (void)"No AO_load_release_write";
# endif
# ifdef AO_HAVE_store_release_write
    (void)"AO_store_release_write(&val, newval):";
    AO_store_release_write(&val, newval);
# else
    (void)"No AO_store_release_write";
# endif
# ifdef AO_HAVE_fetch_and_add_release_write
    (void)"AO_fetch_and_add_release_write(&val, incr):";
    (void)AO_fetch_and_add_release_write(&val, incr);
# else
    (void)"No AO_fetch_and_add_release_write";
# endif
# ifdef AO_HAVE_fetch_and_add1_release_write
    (void)"AO_fetch_and_add1_release_write(&val):";
    (void)AO_fetch_and_add1_release_write(&val);
# else
    (void)"No AO_fetch_and_add1_release_write";
# endif
# ifdef AO_HAVE_fetch_and_sub1_release_write
    (void)"AO_fetch_and_sub1_release_write(&val):";
    (void)AO_fetch_and_sub1_release_write(&val);
# else
    (void)"No AO_fetch_and_sub1_release_write";
# endif
# ifdef AO_HAVE_and_release_write
    (void)"AO_and_release_write(&val, incr):";
    AO_and_release_write(&val, incr);
# else
    (void)"No AO_and_release_write";
# endif
# ifdef AO_HAVE_or_release_write
    (void)"AO_or_release_write(&val, incr):";
    AO_or_release_write(&val, incr);
# else
    (void)"No AO_or_release_write";
# endif
# ifdef AO_HAVE_xor_release_write
    (void)"AO_xor_release_write(&val, incr):";
    AO_xor_release_write(&val, incr);
# else
    (void)"No AO_xor_release_write";
# endif
# ifdef AO_HAVE_compare_and_swap_release_write
    (void)"AO_compare_and_swap_release_write(&val, oldval, newval):";
    if (!AO_compare_and_swap_release_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_release_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release_write */
  /* TODO: Add AO_compare_and_swap_double_release_write */
# ifdef AO_HAVE_fetch_compare_and_swap_release_write
    (void)"AO_fetch_compare_and_swap_release_write(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_release_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_release_write";
# endif

# if defined(AO_HAVE_test_and_set_release_write)
    (void)"AO_test_and_set_release_write(&ts):";
    (void)AO_test_and_set_release_write(&ts);
# else
    (void)"No AO_test_and_set_release_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_acquire_read(void)
{
# if defined(AO_HAVE_load_acquire_read) || defined(AO_HAVE_store_acquire_read) \
     || defined(AO_HAVE_fetch_and_add_acquire_read) \
     || defined(AO_HAVE_fetch_and_add1_acquire_read) \
     || defined(AO_HAVE_and_acquire_read) \
     || defined(AO_HAVE_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire_read)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire_read)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_acquire_read) \
     || defined(AO_HAVE_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_acquire_read)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_acquire_read) || defined(AO_HAVE_and_acquire_read) \
     || defined(AO_HAVE_or_acquire_read) || defined(AO_HAVE_xor_acquire_read)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire_read)
    (void)"AO_nop_acquire_read(): ";
    AO_nop_acquire_read();
# else
    (void)"No AO_nop_acquire_read";
# endif

# ifdef AO_HAVE_load_acquire_read
    (void)"AO_load_acquire_read(&val):";
    (void)AO_load_acquire_read(&val);
# else
    (void)"No AO_load_acquire_read";
# endif
# ifdef AO_HAVE_store_acquire_read
    (void)"AO_store_acquire_read(&val, newval):";
    AO_store_acquire_read(&val, newval);
# else
    (void)"No AO_store_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_add_acquire_read
    (void)"AO_fetch_and_add_acquire_read(&val, incr):";
    (void)AO_fetch_and_add_acquire_read(&val, incr);
# else
    (void)"No AO_fetch_and_add_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_add1_acquire_read
    (void)"AO_fetch_and_add1_acquire_read(&val):";
    (void)AO_fetch_and_add1_acquire_read(&val);
# else
    (void)"No AO_fetch_and_add1_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_sub1_acquire_read
    (void)"AO_fetch_and_sub1_acquire_read(&val):";
    (void)AO_fetch_and_sub1_acquire_read(&val);
# else
    (void)"No AO_fetch_and_sub1_acquire_read";
# endif
# ifdef AO_HAVE_and_acquire_read
    (void)"AO_and_acquire_read(&val, incr):";
    AO_and_acquire_read(&val, incr);
# else
    (void)"No AO_and_acquire_read";
# endif
# ifdef AO_HAVE_or_acquire_read
    (void)"AO_or_acquire_read(&val, incr):";
    AO_or_acquire_read(&val, incr);
# else
    (void)"No AO_or_acquire_read";
# endif
# ifdef AO_HAVE_xor_acquire_read
    (void)"AO_xor_acquire_read(&val, incr):";
    AO_xor_acquire_read(&val, incr);
# else
    (void)"No AO_xor_acquire_read";
# endif
# ifdef AO_HAVE_compare_and_swap_acquire_read
    (void)"AO_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (!AO_compare_and_swap_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_acquire_read */
# ifdef AO_HAVE_fetch_compare_and_swap_acquire_read
    (void)"AO_fetch_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_acquire_read)
    (void)"AO_test_and_set_acquire_read(&ts):";
    (void)AO_test_and_set_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void list_atomic_dd_acquire_read(void)
{
# if defined(AO_HAVE_load_dd_acquire_read) || defined(AO_HAVE_store_dd_acquire_read) \
     || defined(AO_HAVE_fetch_and_add_dd_acquire_read) \
     || defined(AO_HAVE_fetch_and_add1_dd_acquire_read) \
     || defined(AO_HAVE_and_dd_acquire_read) \
     || defined(AO_HAVE_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_dd_acquire_read)
    static volatile AO_t val /* = 0 */;
# endif
# if defined(AO_HAVE_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_dd_acquire_read)
    static AO_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_store_dd_acquire_read) \
     || defined(AO_HAVE_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_fetch_compare_and_swap_dd_acquire_read)
    static AO_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_fetch_and_add_dd_acquire_read) || defined(AO_HAVE_and_dd_acquire_read) \
     || defined(AO_HAVE_or_dd_acquire_read) || defined(AO_HAVE_xor_dd_acquire_read)
    static AO_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_dd_acquire_read)
    (void)"AO_nop_dd_acquire_read(): ";
    AO_nop_dd_acquire_read();
# else
    (void)"No AO_nop_dd_acquire_read";
# endif

# ifdef AO_HAVE_load_dd_acquire_read
    (void)"AO_load_dd_acquire_read(&val):";
    (void)AO_load_dd_acquire_read(&val);
# else
    (void)"No AO_load_dd_acquire_read";
# endif
# ifdef AO_HAVE_store_dd_acquire_read
    (void)"AO_store_dd_acquire_read(&val, newval):";
    AO_store_dd_acquire_read(&val, newval);
# else
    (void)"No AO_store_dd_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_add_dd_acquire_read
    (void)"AO_fetch_and_add_dd_acquire_read(&val, incr):";
    (void)AO_fetch_and_add_dd_acquire_read(&val, incr);
# else
    (void)"No AO_fetch_and_add_dd_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_add1_dd_acquire_read
    (void)"AO_fetch_and_add1_dd_acquire_read(&val):";
    (void)AO_fetch_and_add1_dd_acquire_read(&val);
# else
    (void)"No AO_fetch_and_add1_dd_acquire_read";
# endif
# ifdef AO_HAVE_fetch_and_sub1_dd_acquire_read
    (void)"AO_fetch_and_sub1_dd_acquire_read(&val):";
    (void)AO_fetch_and_sub1_dd_acquire_read(&val);
# else
    (void)"No AO_fetch_and_sub1_dd_acquire_read";
# endif
# ifdef AO_HAVE_and_dd_acquire_read
    (void)"AO_and_dd_acquire_read(&val, incr):";
    AO_and_dd_acquire_read(&val, incr);
# else
    (void)"No AO_and_dd_acquire_read";
# endif
# ifdef AO_HAVE_or_dd_acquire_read
    (void)"AO_or_dd_acquire_read(&val, incr):";
    AO_or_dd_acquire_read(&val, incr);
# else
    (void)"No AO_or_dd_acquire_read";
# endif
# ifdef AO_HAVE_xor_dd_acquire_read
    (void)"AO_xor_dd_acquire_read(&val, incr):";
    AO_xor_dd_acquire_read(&val, incr);
# else
    (void)"No AO_xor_dd_acquire_read";
# endif
# ifdef AO_HAVE_compare_and_swap_dd_acquire_read
    (void)"AO_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (!AO_compare_and_swap_dd_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_compare_and_swap_dd_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_dd_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_dd_acquire_read */
# ifdef AO_HAVE_fetch_compare_and_swap_dd_acquire_read
    (void)"AO_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (AO_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_fetch_compare_and_swap_dd_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    (void)"AO_test_and_set_dd_acquire_read(&ts):";
    (void)AO_test_and_set_dd_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_dd_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic(void)
{
# if defined(AO_HAVE_char_load) || defined(AO_HAVE_char_store) \
     || defined(AO_HAVE_char_fetch_and_add) \
     || defined(AO_HAVE_char_fetch_and_add1) \
     || defined(AO_HAVE_char_and) \
     || defined(AO_HAVE_char_compare_and_swap) \
     || defined(AO_HAVE_char_fetch_compare_and_swap)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap) \
     || defined(AO_HAVE_char_fetch_compare_and_swap)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store) \
     || defined(AO_HAVE_char_compare_and_swap) \
     || defined(AO_HAVE_char_fetch_compare_and_swap)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add) || defined(AO_HAVE_char_and) \
     || defined(AO_HAVE_char_or) || defined(AO_HAVE_char_xor)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop)
    (void)"AO_nop(): ";
    AO_nop();
# else
    (void)"No AO_nop";
# endif

# ifdef AO_HAVE_char_load
    (void)"AO_char_load(&val):";
    (void)AO_char_load(&val);
# else
    (void)"No AO_char_load";
# endif
# ifdef AO_HAVE_char_store
    (void)"AO_char_store(&val, newval):";
    AO_char_store(&val, newval);
# else
    (void)"No AO_char_store";
# endif
# ifdef AO_HAVE_char_fetch_and_add
    (void)"AO_char_fetch_and_add(&val, incr):";
    (void)AO_char_fetch_and_add(&val, incr);
# else
    (void)"No AO_char_fetch_and_add";
# endif
# ifdef AO_HAVE_char_fetch_and_add1
    (void)"AO_char_fetch_and_add1(&val):";
    (void)AO_char_fetch_and_add1(&val);
# else
    (void)"No AO_char_fetch_and_add1";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1
    (void)"AO_char_fetch_and_sub1(&val):";
    (void)AO_char_fetch_and_sub1(&val);
# else
    (void)"No AO_char_fetch_and_sub1";
# endif
# ifdef AO_HAVE_char_and
    (void)"AO_char_and(&val, incr):";
    AO_char_and(&val, incr);
# else
    (void)"No AO_char_and";
# endif
# ifdef AO_HAVE_char_or
    (void)"AO_char_or(&val, incr):";
    AO_char_or(&val, incr);
# else
    (void)"No AO_char_or";
# endif
# ifdef AO_HAVE_char_xor
    (void)"AO_char_xor(&val, incr):";
    AO_char_xor(&val, incr);
# else
    (void)"No AO_char_xor";
# endif
# ifdef AO_HAVE_char_compare_and_swap
    (void)"AO_char_compare_and_swap(&val, oldval, newval):";
    if (!AO_char_compare_and_swap(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap";
# endif
  /* TODO: Add AO_compare_double_and_swap_double */
  /* TODO: Add AO_compare_and_swap_double */
# ifdef AO_HAVE_char_fetch_compare_and_swap
    (void)"AO_char_fetch_compare_and_swap(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap";
# endif

# if defined(AO_HAVE_test_and_set)
    (void)"AO_test_and_set(&ts):";
    (void)AO_test_and_set(&ts);
# else
    (void)"No AO_test_and_set";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_release(void)
{
# if defined(AO_HAVE_char_load_release) || defined(AO_HAVE_char_store_release) \
     || defined(AO_HAVE_char_fetch_and_add_release) \
     || defined(AO_HAVE_char_fetch_and_add1_release) \
     || defined(AO_HAVE_char_and_release) \
     || defined(AO_HAVE_char_compare_and_swap_release) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_release) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_release) \
     || defined(AO_HAVE_char_compare_and_swap_release) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_release) || defined(AO_HAVE_char_and_release) \
     || defined(AO_HAVE_char_or_release) || defined(AO_HAVE_char_xor_release)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release)
    (void)"AO_nop_release(): ";
    AO_nop_release();
# else
    (void)"No AO_nop_release";
# endif

# ifdef AO_HAVE_char_load_release
    (void)"AO_char_load_release(&val):";
    (void)AO_char_load_release(&val);
# else
    (void)"No AO_char_load_release";
# endif
# ifdef AO_HAVE_char_store_release
    (void)"AO_char_store_release(&val, newval):";
    AO_char_store_release(&val, newval);
# else
    (void)"No AO_char_store_release";
# endif
# ifdef AO_HAVE_char_fetch_and_add_release
    (void)"AO_char_fetch_and_add_release(&val, incr):";
    (void)AO_char_fetch_and_add_release(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_release";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_release
    (void)"AO_char_fetch_and_add1_release(&val):";
    (void)AO_char_fetch_and_add1_release(&val);
# else
    (void)"No AO_char_fetch_and_add1_release";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_release
    (void)"AO_char_fetch_and_sub1_release(&val):";
    (void)AO_char_fetch_and_sub1_release(&val);
# else
    (void)"No AO_char_fetch_and_sub1_release";
# endif
# ifdef AO_HAVE_char_and_release
    (void)"AO_char_and_release(&val, incr):";
    AO_char_and_release(&val, incr);
# else
    (void)"No AO_char_and_release";
# endif
# ifdef AO_HAVE_char_or_release
    (void)"AO_char_or_release(&val, incr):";
    AO_char_or_release(&val, incr);
# else
    (void)"No AO_char_or_release";
# endif
# ifdef AO_HAVE_char_xor_release
    (void)"AO_char_xor_release(&val, incr):";
    AO_char_xor_release(&val, incr);
# else
    (void)"No AO_char_xor_release";
# endif
# ifdef AO_HAVE_char_compare_and_swap_release
    (void)"AO_char_compare_and_swap_release(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_release(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_release";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release */
  /* TODO: Add AO_compare_and_swap_double_release */
# ifdef AO_HAVE_char_fetch_compare_and_swap_release
    (void)"AO_char_fetch_compare_and_swap_release(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_release(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_release";
# endif

# if defined(AO_HAVE_test_and_set_release)
    (void)"AO_test_and_set_release(&ts):";
    (void)AO_test_and_set_release(&ts);
# else
    (void)"No AO_test_and_set_release";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_acquire(void)
{
# if defined(AO_HAVE_char_load_acquire) || defined(AO_HAVE_char_store_acquire) \
     || defined(AO_HAVE_char_fetch_and_add_acquire) \
     || defined(AO_HAVE_char_fetch_and_add1_acquire) \
     || defined(AO_HAVE_char_and_acquire) \
     || defined(AO_HAVE_char_compare_and_swap_acquire) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_acquire) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_acquire) \
     || defined(AO_HAVE_char_compare_and_swap_acquire) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_acquire) || defined(AO_HAVE_char_and_acquire) \
     || defined(AO_HAVE_char_or_acquire) || defined(AO_HAVE_char_xor_acquire)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire)
    (void)"AO_nop_acquire(): ";
    AO_nop_acquire();
# else
    (void)"No AO_nop_acquire";
# endif

# ifdef AO_HAVE_char_load_acquire
    (void)"AO_char_load_acquire(&val):";
    (void)AO_char_load_acquire(&val);
# else
    (void)"No AO_char_load_acquire";
# endif
# ifdef AO_HAVE_char_store_acquire
    (void)"AO_char_store_acquire(&val, newval):";
    AO_char_store_acquire(&val, newval);
# else
    (void)"No AO_char_store_acquire";
# endif
# ifdef AO_HAVE_char_fetch_and_add_acquire
    (void)"AO_char_fetch_and_add_acquire(&val, incr):";
    (void)AO_char_fetch_and_add_acquire(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_acquire";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_acquire
    (void)"AO_char_fetch_and_add1_acquire(&val):";
    (void)AO_char_fetch_and_add1_acquire(&val);
# else
    (void)"No AO_char_fetch_and_add1_acquire";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_acquire
    (void)"AO_char_fetch_and_sub1_acquire(&val):";
    (void)AO_char_fetch_and_sub1_acquire(&val);
# else
    (void)"No AO_char_fetch_and_sub1_acquire";
# endif
# ifdef AO_HAVE_char_and_acquire
    (void)"AO_char_and_acquire(&val, incr):";
    AO_char_and_acquire(&val, incr);
# else
    (void)"No AO_char_and_acquire";
# endif
# ifdef AO_HAVE_char_or_acquire
    (void)"AO_char_or_acquire(&val, incr):";
    AO_char_or_acquire(&val, incr);
# else
    (void)"No AO_char_or_acquire";
# endif
# ifdef AO_HAVE_char_xor_acquire
    (void)"AO_char_xor_acquire(&val, incr):";
    AO_char_xor_acquire(&val, incr);
# else
    (void)"No AO_char_xor_acquire";
# endif
# ifdef AO_HAVE_char_compare_and_swap_acquire
    (void)"AO_char_compare_and_swap_acquire(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_acquire(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_acquire";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire */
  /* TODO: Add AO_compare_and_swap_double_acquire */
# ifdef AO_HAVE_char_fetch_compare_and_swap_acquire
    (void)"AO_char_fetch_compare_and_swap_acquire(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_acquire(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_acquire";
# endif

# if defined(AO_HAVE_test_and_set_acquire)
    (void)"AO_test_and_set_acquire(&ts):";
    (void)AO_test_and_set_acquire(&ts);
# else
    (void)"No AO_test_and_set_acquire";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_read(void)
{
# if defined(AO_HAVE_char_load_read) || defined(AO_HAVE_char_store_read) \
     || defined(AO_HAVE_char_fetch_and_add_read) \
     || defined(AO_HAVE_char_fetch_and_add1_read) \
     || defined(AO_HAVE_char_and_read) \
     || defined(AO_HAVE_char_compare_and_swap_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_read)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_read)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_read) \
     || defined(AO_HAVE_char_compare_and_swap_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_read)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_read) || defined(AO_HAVE_char_and_read) \
     || defined(AO_HAVE_char_or_read) || defined(AO_HAVE_char_xor_read)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_read)
    (void)"AO_nop_read(): ";
    AO_nop_read();
# else
    (void)"No AO_nop_read";
# endif

# ifdef AO_HAVE_char_load_read
    (void)"AO_char_load_read(&val):";
    (void)AO_char_load_read(&val);
# else
    (void)"No AO_char_load_read";
# endif
# ifdef AO_HAVE_char_store_read
    (void)"AO_char_store_read(&val, newval):";
    AO_char_store_read(&val, newval);
# else
    (void)"No AO_char_store_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add_read
    (void)"AO_char_fetch_and_add_read(&val, incr):";
    (void)AO_char_fetch_and_add_read(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_read
    (void)"AO_char_fetch_and_add1_read(&val):";
    (void)AO_char_fetch_and_add1_read(&val);
# else
    (void)"No AO_char_fetch_and_add1_read";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_read
    (void)"AO_char_fetch_and_sub1_read(&val):";
    (void)AO_char_fetch_and_sub1_read(&val);
# else
    (void)"No AO_char_fetch_and_sub1_read";
# endif
# ifdef AO_HAVE_char_and_read
    (void)"AO_char_and_read(&val, incr):";
    AO_char_and_read(&val, incr);
# else
    (void)"No AO_char_and_read";
# endif
# ifdef AO_HAVE_char_or_read
    (void)"AO_char_or_read(&val, incr):";
    AO_char_or_read(&val, incr);
# else
    (void)"No AO_char_or_read";
# endif
# ifdef AO_HAVE_char_xor_read
    (void)"AO_char_xor_read(&val, incr):";
    AO_char_xor_read(&val, incr);
# else
    (void)"No AO_char_xor_read";
# endif
# ifdef AO_HAVE_char_compare_and_swap_read
    (void)"AO_char_compare_and_swap_read(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_read */
  /* TODO: Add AO_compare_and_swap_double_read */
# ifdef AO_HAVE_char_fetch_compare_and_swap_read
    (void)"AO_char_fetch_compare_and_swap_read(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_read";
# endif

# if defined(AO_HAVE_test_and_set_read)
    (void)"AO_test_and_set_read(&ts):";
    (void)AO_test_and_set_read(&ts);
# else
    (void)"No AO_test_and_set_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_write(void)
{
# if defined(AO_HAVE_char_load_write) || defined(AO_HAVE_char_store_write) \
     || defined(AO_HAVE_char_fetch_and_add_write) \
     || defined(AO_HAVE_char_fetch_and_add1_write) \
     || defined(AO_HAVE_char_and_write) \
     || defined(AO_HAVE_char_compare_and_swap_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_write)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_write)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_write) \
     || defined(AO_HAVE_char_compare_and_swap_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_write)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_write) || defined(AO_HAVE_char_and_write) \
     || defined(AO_HAVE_char_or_write) || defined(AO_HAVE_char_xor_write)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_write)
    (void)"AO_nop_write(): ";
    AO_nop_write();
# else
    (void)"No AO_nop_write";
# endif

# ifdef AO_HAVE_char_load_write
    (void)"AO_char_load_write(&val):";
    (void)AO_char_load_write(&val);
# else
    (void)"No AO_char_load_write";
# endif
# ifdef AO_HAVE_char_store_write
    (void)"AO_char_store_write(&val, newval):";
    AO_char_store_write(&val, newval);
# else
    (void)"No AO_char_store_write";
# endif
# ifdef AO_HAVE_char_fetch_and_add_write
    (void)"AO_char_fetch_and_add_write(&val, incr):";
    (void)AO_char_fetch_and_add_write(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_write";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_write
    (void)"AO_char_fetch_and_add1_write(&val):";
    (void)AO_char_fetch_and_add1_write(&val);
# else
    (void)"No AO_char_fetch_and_add1_write";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_write
    (void)"AO_char_fetch_and_sub1_write(&val):";
    (void)AO_char_fetch_and_sub1_write(&val);
# else
    (void)"No AO_char_fetch_and_sub1_write";
# endif
# ifdef AO_HAVE_char_and_write
    (void)"AO_char_and_write(&val, incr):";
    AO_char_and_write(&val, incr);
# else
    (void)"No AO_char_and_write";
# endif
# ifdef AO_HAVE_char_or_write
    (void)"AO_char_or_write(&val, incr):";
    AO_char_or_write(&val, incr);
# else
    (void)"No AO_char_or_write";
# endif
# ifdef AO_HAVE_char_xor_write
    (void)"AO_char_xor_write(&val, incr):";
    AO_char_xor_write(&val, incr);
# else
    (void)"No AO_char_xor_write";
# endif
# ifdef AO_HAVE_char_compare_and_swap_write
    (void)"AO_char_compare_and_swap_write(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_write */
  /* TODO: Add AO_compare_and_swap_double_write */
# ifdef AO_HAVE_char_fetch_compare_and_swap_write
    (void)"AO_char_fetch_compare_and_swap_write(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_write";
# endif

# if defined(AO_HAVE_test_and_set_write)
    (void)"AO_test_and_set_write(&ts):";
    (void)AO_test_and_set_write(&ts);
# else
    (void)"No AO_test_and_set_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_full(void)
{
# if defined(AO_HAVE_char_load_full) || defined(AO_HAVE_char_store_full) \
     || defined(AO_HAVE_char_fetch_and_add_full) \
     || defined(AO_HAVE_char_fetch_and_add1_full) \
     || defined(AO_HAVE_char_and_full) \
     || defined(AO_HAVE_char_compare_and_swap_full) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_full)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_full) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_full)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_full) \
     || defined(AO_HAVE_char_compare_and_swap_full) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_full)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_full)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_full) || defined(AO_HAVE_char_and_full) \
     || defined(AO_HAVE_char_or_full) || defined(AO_HAVE_char_xor_full)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_full)
    (void)"AO_nop_full(): ";
    AO_nop_full();
# else
    (void)"No AO_nop_full";
# endif

# ifdef AO_HAVE_char_load_full
    (void)"AO_char_load_full(&val):";
    (void)AO_char_load_full(&val);
# else
    (void)"No AO_char_load_full";
# endif
# ifdef AO_HAVE_char_store_full
    (void)"AO_char_store_full(&val, newval):";
    AO_char_store_full(&val, newval);
# else
    (void)"No AO_char_store_full";
# endif
# ifdef AO_HAVE_char_fetch_and_add_full
    (void)"AO_char_fetch_and_add_full(&val, incr):";
    (void)AO_char_fetch_and_add_full(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_full";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_full
    (void)"AO_char_fetch_and_add1_full(&val):";
    (void)AO_char_fetch_and_add1_full(&val);
# else
    (void)"No AO_char_fetch_and_add1_full";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_full
    (void)"AO_char_fetch_and_sub1_full(&val):";
    (void)AO_char_fetch_and_sub1_full(&val);
# else
    (void)"No AO_char_fetch_and_sub1_full";
# endif
# ifdef AO_HAVE_char_and_full
    (void)"AO_char_and_full(&val, incr):";
    AO_char_and_full(&val, incr);
# else
    (void)"No AO_char_and_full";
# endif
# ifdef AO_HAVE_char_or_full
    (void)"AO_char_or_full(&val, incr):";
    AO_char_or_full(&val, incr);
# else
    (void)"No AO_char_or_full";
# endif
# ifdef AO_HAVE_char_xor_full
    (void)"AO_char_xor_full(&val, incr):";
    AO_char_xor_full(&val, incr);
# else
    (void)"No AO_char_xor_full";
# endif
# ifdef AO_HAVE_char_compare_and_swap_full
    (void)"AO_char_compare_and_swap_full(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_full(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_full";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_full */
  /* TODO: Add AO_compare_and_swap_double_full */
# ifdef AO_HAVE_char_fetch_compare_and_swap_full
    (void)"AO_char_fetch_compare_and_swap_full(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_full(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_full";
# endif

# if defined(AO_HAVE_test_and_set_full)
    (void)"AO_test_and_set_full(&ts):";
    (void)AO_test_and_set_full(&ts);
# else
    (void)"No AO_test_and_set_full";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_release_write(void)
{
# if defined(AO_HAVE_char_load_release_write) || defined(AO_HAVE_char_store_release_write) \
     || defined(AO_HAVE_char_fetch_and_add_release_write) \
     || defined(AO_HAVE_char_fetch_and_add1_release_write) \
     || defined(AO_HAVE_char_and_release_write) \
     || defined(AO_HAVE_char_compare_and_swap_release_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release_write)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_release_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release_write)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_release_write) \
     || defined(AO_HAVE_char_compare_and_swap_release_write) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_release_write)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_release_write) || defined(AO_HAVE_char_and_release_write) \
     || defined(AO_HAVE_char_or_release_write) || defined(AO_HAVE_char_xor_release_write)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release_write)
    (void)"AO_nop_release_write(): ";
    AO_nop_release_write();
# else
    (void)"No AO_nop_release_write";
# endif

# ifdef AO_HAVE_char_load_release_write
    (void)"AO_char_load_release_write(&val):";
    (void)AO_char_load_release_write(&val);
# else
    (void)"No AO_char_load_release_write";
# endif
# ifdef AO_HAVE_char_store_release_write
    (void)"AO_char_store_release_write(&val, newval):";
    AO_char_store_release_write(&val, newval);
# else
    (void)"No AO_char_store_release_write";
# endif
# ifdef AO_HAVE_char_fetch_and_add_release_write
    (void)"AO_char_fetch_and_add_release_write(&val, incr):";
    (void)AO_char_fetch_and_add_release_write(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_release_write";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_release_write
    (void)"AO_char_fetch_and_add1_release_write(&val):";
    (void)AO_char_fetch_and_add1_release_write(&val);
# else
    (void)"No AO_char_fetch_and_add1_release_write";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_release_write
    (void)"AO_char_fetch_and_sub1_release_write(&val):";
    (void)AO_char_fetch_and_sub1_release_write(&val);
# else
    (void)"No AO_char_fetch_and_sub1_release_write";
# endif
# ifdef AO_HAVE_char_and_release_write
    (void)"AO_char_and_release_write(&val, incr):";
    AO_char_and_release_write(&val, incr);
# else
    (void)"No AO_char_and_release_write";
# endif
# ifdef AO_HAVE_char_or_release_write
    (void)"AO_char_or_release_write(&val, incr):";
    AO_char_or_release_write(&val, incr);
# else
    (void)"No AO_char_or_release_write";
# endif
# ifdef AO_HAVE_char_xor_release_write
    (void)"AO_char_xor_release_write(&val, incr):";
    AO_char_xor_release_write(&val, incr);
# else
    (void)"No AO_char_xor_release_write";
# endif
# ifdef AO_HAVE_char_compare_and_swap_release_write
    (void)"AO_char_compare_and_swap_release_write(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_release_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_release_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release_write */
  /* TODO: Add AO_compare_and_swap_double_release_write */
# ifdef AO_HAVE_char_fetch_compare_and_swap_release_write
    (void)"AO_char_fetch_compare_and_swap_release_write(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_release_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_release_write";
# endif

# if defined(AO_HAVE_test_and_set_release_write)
    (void)"AO_test_and_set_release_write(&ts):";
    (void)AO_test_and_set_release_write(&ts);
# else
    (void)"No AO_test_and_set_release_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_acquire_read(void)
{
# if defined(AO_HAVE_char_load_acquire_read) || defined(AO_HAVE_char_store_acquire_read) \
     || defined(AO_HAVE_char_fetch_and_add_acquire_read) \
     || defined(AO_HAVE_char_fetch_and_add1_acquire_read) \
     || defined(AO_HAVE_char_and_acquire_read) \
     || defined(AO_HAVE_char_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire_read)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire_read)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_acquire_read) \
     || defined(AO_HAVE_char_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_acquire_read)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_acquire_read) || defined(AO_HAVE_char_and_acquire_read) \
     || defined(AO_HAVE_char_or_acquire_read) || defined(AO_HAVE_char_xor_acquire_read)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire_read)
    (void)"AO_nop_acquire_read(): ";
    AO_nop_acquire_read();
# else
    (void)"No AO_nop_acquire_read";
# endif

# ifdef AO_HAVE_char_load_acquire_read
    (void)"AO_char_load_acquire_read(&val):";
    (void)AO_char_load_acquire_read(&val);
# else
    (void)"No AO_char_load_acquire_read";
# endif
# ifdef AO_HAVE_char_store_acquire_read
    (void)"AO_char_store_acquire_read(&val, newval):";
    AO_char_store_acquire_read(&val, newval);
# else
    (void)"No AO_char_store_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add_acquire_read
    (void)"AO_char_fetch_and_add_acquire_read(&val, incr):";
    (void)AO_char_fetch_and_add_acquire_read(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_acquire_read
    (void)"AO_char_fetch_and_add1_acquire_read(&val):";
    (void)AO_char_fetch_and_add1_acquire_read(&val);
# else
    (void)"No AO_char_fetch_and_add1_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_acquire_read
    (void)"AO_char_fetch_and_sub1_acquire_read(&val):";
    (void)AO_char_fetch_and_sub1_acquire_read(&val);
# else
    (void)"No AO_char_fetch_and_sub1_acquire_read";
# endif
# ifdef AO_HAVE_char_and_acquire_read
    (void)"AO_char_and_acquire_read(&val, incr):";
    AO_char_and_acquire_read(&val, incr);
# else
    (void)"No AO_char_and_acquire_read";
# endif
# ifdef AO_HAVE_char_or_acquire_read
    (void)"AO_char_or_acquire_read(&val, incr):";
    AO_char_or_acquire_read(&val, incr);
# else
    (void)"No AO_char_or_acquire_read";
# endif
# ifdef AO_HAVE_char_xor_acquire_read
    (void)"AO_char_xor_acquire_read(&val, incr):";
    AO_char_xor_acquire_read(&val, incr);
# else
    (void)"No AO_char_xor_acquire_read";
# endif
# ifdef AO_HAVE_char_compare_and_swap_acquire_read
    (void)"AO_char_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_acquire_read */
# ifdef AO_HAVE_char_fetch_compare_and_swap_acquire_read
    (void)"AO_char_fetch_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_acquire_read)
    (void)"AO_test_and_set_acquire_read(&ts):";
    (void)AO_test_and_set_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void char_list_atomic_dd_acquire_read(void)
{
# if defined(AO_HAVE_char_load_dd_acquire_read) || defined(AO_HAVE_char_store_dd_acquire_read) \
     || defined(AO_HAVE_char_fetch_and_add_dd_acquire_read) \
     || defined(AO_HAVE_char_fetch_and_add1_dd_acquire_read) \
     || defined(AO_HAVE_char_and_dd_acquire_read) \
     || defined(AO_HAVE_char_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_dd_acquire_read)
    static volatile unsigned/**/char val /* = 0 */;
# endif
# if defined(AO_HAVE_char_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_dd_acquire_read)
    static unsigned/**/char oldval /* = 0 */;
# endif
# if defined(AO_HAVE_char_store_dd_acquire_read) \
     || defined(AO_HAVE_char_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_char_fetch_compare_and_swap_dd_acquire_read)
    static unsigned/**/char newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_char_fetch_and_add_dd_acquire_read) || defined(AO_HAVE_char_and_dd_acquire_read) \
     || defined(AO_HAVE_char_or_dd_acquire_read) || defined(AO_HAVE_char_xor_dd_acquire_read)
    static unsigned/**/char incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_dd_acquire_read)
    (void)"AO_nop_dd_acquire_read(): ";
    AO_nop_dd_acquire_read();
# else
    (void)"No AO_nop_dd_acquire_read";
# endif

# ifdef AO_HAVE_char_load_dd_acquire_read
    (void)"AO_char_load_dd_acquire_read(&val):";
    (void)AO_char_load_dd_acquire_read(&val);
# else
    (void)"No AO_char_load_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_store_dd_acquire_read
    (void)"AO_char_store_dd_acquire_read(&val, newval):";
    AO_char_store_dd_acquire_read(&val, newval);
# else
    (void)"No AO_char_store_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add_dd_acquire_read
    (void)"AO_char_fetch_and_add_dd_acquire_read(&val, incr):";
    (void)AO_char_fetch_and_add_dd_acquire_read(&val, incr);
# else
    (void)"No AO_char_fetch_and_add_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_add1_dd_acquire_read
    (void)"AO_char_fetch_and_add1_dd_acquire_read(&val):";
    (void)AO_char_fetch_and_add1_dd_acquire_read(&val);
# else
    (void)"No AO_char_fetch_and_add1_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_fetch_and_sub1_dd_acquire_read
    (void)"AO_char_fetch_and_sub1_dd_acquire_read(&val):";
    (void)AO_char_fetch_and_sub1_dd_acquire_read(&val);
# else
    (void)"No AO_char_fetch_and_sub1_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_and_dd_acquire_read
    (void)"AO_char_and_dd_acquire_read(&val, incr):";
    AO_char_and_dd_acquire_read(&val, incr);
# else
    (void)"No AO_char_and_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_or_dd_acquire_read
    (void)"AO_char_or_dd_acquire_read(&val, incr):";
    AO_char_or_dd_acquire_read(&val, incr);
# else
    (void)"No AO_char_or_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_xor_dd_acquire_read
    (void)"AO_char_xor_dd_acquire_read(&val, incr):";
    AO_char_xor_dd_acquire_read(&val, incr);
# else
    (void)"No AO_char_xor_dd_acquire_read";
# endif
# ifdef AO_HAVE_char_compare_and_swap_dd_acquire_read
    (void)"AO_char_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (!AO_char_compare_and_swap_dd_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_char_compare_and_swap_dd_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_dd_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_dd_acquire_read */
# ifdef AO_HAVE_char_fetch_compare_and_swap_dd_acquire_read
    (void)"AO_char_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (AO_char_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_char_fetch_compare_and_swap_dd_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    (void)"AO_test_and_set_dd_acquire_read(&ts):";
    (void)AO_test_and_set_dd_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_dd_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic(void)
{
# if defined(AO_HAVE_short_load) || defined(AO_HAVE_short_store) \
     || defined(AO_HAVE_short_fetch_and_add) \
     || defined(AO_HAVE_short_fetch_and_add1) \
     || defined(AO_HAVE_short_and) \
     || defined(AO_HAVE_short_compare_and_swap) \
     || defined(AO_HAVE_short_fetch_compare_and_swap)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap) \
     || defined(AO_HAVE_short_fetch_compare_and_swap)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store) \
     || defined(AO_HAVE_short_compare_and_swap) \
     || defined(AO_HAVE_short_fetch_compare_and_swap)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add) || defined(AO_HAVE_short_and) \
     || defined(AO_HAVE_short_or) || defined(AO_HAVE_short_xor)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop)
    (void)"AO_nop(): ";
    AO_nop();
# else
    (void)"No AO_nop";
# endif

# ifdef AO_HAVE_short_load
    (void)"AO_short_load(&val):";
    (void)AO_short_load(&val);
# else
    (void)"No AO_short_load";
# endif
# ifdef AO_HAVE_short_store
    (void)"AO_short_store(&val, newval):";
    AO_short_store(&val, newval);
# else
    (void)"No AO_short_store";
# endif
# ifdef AO_HAVE_short_fetch_and_add
    (void)"AO_short_fetch_and_add(&val, incr):";
    (void)AO_short_fetch_and_add(&val, incr);
# else
    (void)"No AO_short_fetch_and_add";
# endif
# ifdef AO_HAVE_short_fetch_and_add1
    (void)"AO_short_fetch_and_add1(&val):";
    (void)AO_short_fetch_and_add1(&val);
# else
    (void)"No AO_short_fetch_and_add1";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1
    (void)"AO_short_fetch_and_sub1(&val):";
    (void)AO_short_fetch_and_sub1(&val);
# else
    (void)"No AO_short_fetch_and_sub1";
# endif
# ifdef AO_HAVE_short_and
    (void)"AO_short_and(&val, incr):";
    AO_short_and(&val, incr);
# else
    (void)"No AO_short_and";
# endif
# ifdef AO_HAVE_short_or
    (void)"AO_short_or(&val, incr):";
    AO_short_or(&val, incr);
# else
    (void)"No AO_short_or";
# endif
# ifdef AO_HAVE_short_xor
    (void)"AO_short_xor(&val, incr):";
    AO_short_xor(&val, incr);
# else
    (void)"No AO_short_xor";
# endif
# ifdef AO_HAVE_short_compare_and_swap
    (void)"AO_short_compare_and_swap(&val, oldval, newval):";
    if (!AO_short_compare_and_swap(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap";
# endif
  /* TODO: Add AO_compare_double_and_swap_double */
  /* TODO: Add AO_compare_and_swap_double */
# ifdef AO_HAVE_short_fetch_compare_and_swap
    (void)"AO_short_fetch_compare_and_swap(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap";
# endif

# if defined(AO_HAVE_test_and_set)
    (void)"AO_test_and_set(&ts):";
    (void)AO_test_and_set(&ts);
# else
    (void)"No AO_test_and_set";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_release(void)
{
# if defined(AO_HAVE_short_load_release) || defined(AO_HAVE_short_store_release) \
     || defined(AO_HAVE_short_fetch_and_add_release) \
     || defined(AO_HAVE_short_fetch_and_add1_release) \
     || defined(AO_HAVE_short_and_release) \
     || defined(AO_HAVE_short_compare_and_swap_release) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_release) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_release) \
     || defined(AO_HAVE_short_compare_and_swap_release) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_release) || defined(AO_HAVE_short_and_release) \
     || defined(AO_HAVE_short_or_release) || defined(AO_HAVE_short_xor_release)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release)
    (void)"AO_nop_release(): ";
    AO_nop_release();
# else
    (void)"No AO_nop_release";
# endif

# ifdef AO_HAVE_short_load_release
    (void)"AO_short_load_release(&val):";
    (void)AO_short_load_release(&val);
# else
    (void)"No AO_short_load_release";
# endif
# ifdef AO_HAVE_short_store_release
    (void)"AO_short_store_release(&val, newval):";
    AO_short_store_release(&val, newval);
# else
    (void)"No AO_short_store_release";
# endif
# ifdef AO_HAVE_short_fetch_and_add_release
    (void)"AO_short_fetch_and_add_release(&val, incr):";
    (void)AO_short_fetch_and_add_release(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_release";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_release
    (void)"AO_short_fetch_and_add1_release(&val):";
    (void)AO_short_fetch_and_add1_release(&val);
# else
    (void)"No AO_short_fetch_and_add1_release";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_release
    (void)"AO_short_fetch_and_sub1_release(&val):";
    (void)AO_short_fetch_and_sub1_release(&val);
# else
    (void)"No AO_short_fetch_and_sub1_release";
# endif
# ifdef AO_HAVE_short_and_release
    (void)"AO_short_and_release(&val, incr):";
    AO_short_and_release(&val, incr);
# else
    (void)"No AO_short_and_release";
# endif
# ifdef AO_HAVE_short_or_release
    (void)"AO_short_or_release(&val, incr):";
    AO_short_or_release(&val, incr);
# else
    (void)"No AO_short_or_release";
# endif
# ifdef AO_HAVE_short_xor_release
    (void)"AO_short_xor_release(&val, incr):";
    AO_short_xor_release(&val, incr);
# else
    (void)"No AO_short_xor_release";
# endif
# ifdef AO_HAVE_short_compare_and_swap_release
    (void)"AO_short_compare_and_swap_release(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_release(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_release";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release */
  /* TODO: Add AO_compare_and_swap_double_release */
# ifdef AO_HAVE_short_fetch_compare_and_swap_release
    (void)"AO_short_fetch_compare_and_swap_release(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_release(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_release";
# endif

# if defined(AO_HAVE_test_and_set_release)
    (void)"AO_test_and_set_release(&ts):";
    (void)AO_test_and_set_release(&ts);
# else
    (void)"No AO_test_and_set_release";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_acquire(void)
{
# if defined(AO_HAVE_short_load_acquire) || defined(AO_HAVE_short_store_acquire) \
     || defined(AO_HAVE_short_fetch_and_add_acquire) \
     || defined(AO_HAVE_short_fetch_and_add1_acquire) \
     || defined(AO_HAVE_short_and_acquire) \
     || defined(AO_HAVE_short_compare_and_swap_acquire) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_acquire) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_acquire) \
     || defined(AO_HAVE_short_compare_and_swap_acquire) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_acquire) || defined(AO_HAVE_short_and_acquire) \
     || defined(AO_HAVE_short_or_acquire) || defined(AO_HAVE_short_xor_acquire)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire)
    (void)"AO_nop_acquire(): ";
    AO_nop_acquire();
# else
    (void)"No AO_nop_acquire";
# endif

# ifdef AO_HAVE_short_load_acquire
    (void)"AO_short_load_acquire(&val):";
    (void)AO_short_load_acquire(&val);
# else
    (void)"No AO_short_load_acquire";
# endif
# ifdef AO_HAVE_short_store_acquire
    (void)"AO_short_store_acquire(&val, newval):";
    AO_short_store_acquire(&val, newval);
# else
    (void)"No AO_short_store_acquire";
# endif
# ifdef AO_HAVE_short_fetch_and_add_acquire
    (void)"AO_short_fetch_and_add_acquire(&val, incr):";
    (void)AO_short_fetch_and_add_acquire(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_acquire";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_acquire
    (void)"AO_short_fetch_and_add1_acquire(&val):";
    (void)AO_short_fetch_and_add1_acquire(&val);
# else
    (void)"No AO_short_fetch_and_add1_acquire";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_acquire
    (void)"AO_short_fetch_and_sub1_acquire(&val):";
    (void)AO_short_fetch_and_sub1_acquire(&val);
# else
    (void)"No AO_short_fetch_and_sub1_acquire";
# endif
# ifdef AO_HAVE_short_and_acquire
    (void)"AO_short_and_acquire(&val, incr):";
    AO_short_and_acquire(&val, incr);
# else
    (void)"No AO_short_and_acquire";
# endif
# ifdef AO_HAVE_short_or_acquire
    (void)"AO_short_or_acquire(&val, incr):";
    AO_short_or_acquire(&val, incr);
# else
    (void)"No AO_short_or_acquire";
# endif
# ifdef AO_HAVE_short_xor_acquire
    (void)"AO_short_xor_acquire(&val, incr):";
    AO_short_xor_acquire(&val, incr);
# else
    (void)"No AO_short_xor_acquire";
# endif
# ifdef AO_HAVE_short_compare_and_swap_acquire
    (void)"AO_short_compare_and_swap_acquire(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_acquire(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_acquire";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire */
  /* TODO: Add AO_compare_and_swap_double_acquire */
# ifdef AO_HAVE_short_fetch_compare_and_swap_acquire
    (void)"AO_short_fetch_compare_and_swap_acquire(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_acquire(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_acquire";
# endif

# if defined(AO_HAVE_test_and_set_acquire)
    (void)"AO_test_and_set_acquire(&ts):";
    (void)AO_test_and_set_acquire(&ts);
# else
    (void)"No AO_test_and_set_acquire";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_read(void)
{
# if defined(AO_HAVE_short_load_read) || defined(AO_HAVE_short_store_read) \
     || defined(AO_HAVE_short_fetch_and_add_read) \
     || defined(AO_HAVE_short_fetch_and_add1_read) \
     || defined(AO_HAVE_short_and_read) \
     || defined(AO_HAVE_short_compare_and_swap_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_read)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_read)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_read) \
     || defined(AO_HAVE_short_compare_and_swap_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_read)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_read) || defined(AO_HAVE_short_and_read) \
     || defined(AO_HAVE_short_or_read) || defined(AO_HAVE_short_xor_read)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_read)
    (void)"AO_nop_read(): ";
    AO_nop_read();
# else
    (void)"No AO_nop_read";
# endif

# ifdef AO_HAVE_short_load_read
    (void)"AO_short_load_read(&val):";
    (void)AO_short_load_read(&val);
# else
    (void)"No AO_short_load_read";
# endif
# ifdef AO_HAVE_short_store_read
    (void)"AO_short_store_read(&val, newval):";
    AO_short_store_read(&val, newval);
# else
    (void)"No AO_short_store_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add_read
    (void)"AO_short_fetch_and_add_read(&val, incr):";
    (void)AO_short_fetch_and_add_read(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_read
    (void)"AO_short_fetch_and_add1_read(&val):";
    (void)AO_short_fetch_and_add1_read(&val);
# else
    (void)"No AO_short_fetch_and_add1_read";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_read
    (void)"AO_short_fetch_and_sub1_read(&val):";
    (void)AO_short_fetch_and_sub1_read(&val);
# else
    (void)"No AO_short_fetch_and_sub1_read";
# endif
# ifdef AO_HAVE_short_and_read
    (void)"AO_short_and_read(&val, incr):";
    AO_short_and_read(&val, incr);
# else
    (void)"No AO_short_and_read";
# endif
# ifdef AO_HAVE_short_or_read
    (void)"AO_short_or_read(&val, incr):";
    AO_short_or_read(&val, incr);
# else
    (void)"No AO_short_or_read";
# endif
# ifdef AO_HAVE_short_xor_read
    (void)"AO_short_xor_read(&val, incr):";
    AO_short_xor_read(&val, incr);
# else
    (void)"No AO_short_xor_read";
# endif
# ifdef AO_HAVE_short_compare_and_swap_read
    (void)"AO_short_compare_and_swap_read(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_read */
  /* TODO: Add AO_compare_and_swap_double_read */
# ifdef AO_HAVE_short_fetch_compare_and_swap_read
    (void)"AO_short_fetch_compare_and_swap_read(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_read";
# endif

# if defined(AO_HAVE_test_and_set_read)
    (void)"AO_test_and_set_read(&ts):";
    (void)AO_test_and_set_read(&ts);
# else
    (void)"No AO_test_and_set_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_write(void)
{
# if defined(AO_HAVE_short_load_write) || defined(AO_HAVE_short_store_write) \
     || defined(AO_HAVE_short_fetch_and_add_write) \
     || defined(AO_HAVE_short_fetch_and_add1_write) \
     || defined(AO_HAVE_short_and_write) \
     || defined(AO_HAVE_short_compare_and_swap_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_write)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_write)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_write) \
     || defined(AO_HAVE_short_compare_and_swap_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_write)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_write) || defined(AO_HAVE_short_and_write) \
     || defined(AO_HAVE_short_or_write) || defined(AO_HAVE_short_xor_write)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_write)
    (void)"AO_nop_write(): ";
    AO_nop_write();
# else
    (void)"No AO_nop_write";
# endif

# ifdef AO_HAVE_short_load_write
    (void)"AO_short_load_write(&val):";
    (void)AO_short_load_write(&val);
# else
    (void)"No AO_short_load_write";
# endif
# ifdef AO_HAVE_short_store_write
    (void)"AO_short_store_write(&val, newval):";
    AO_short_store_write(&val, newval);
# else
    (void)"No AO_short_store_write";
# endif
# ifdef AO_HAVE_short_fetch_and_add_write
    (void)"AO_short_fetch_and_add_write(&val, incr):";
    (void)AO_short_fetch_and_add_write(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_write";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_write
    (void)"AO_short_fetch_and_add1_write(&val):";
    (void)AO_short_fetch_and_add1_write(&val);
# else
    (void)"No AO_short_fetch_and_add1_write";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_write
    (void)"AO_short_fetch_and_sub1_write(&val):";
    (void)AO_short_fetch_and_sub1_write(&val);
# else
    (void)"No AO_short_fetch_and_sub1_write";
# endif
# ifdef AO_HAVE_short_and_write
    (void)"AO_short_and_write(&val, incr):";
    AO_short_and_write(&val, incr);
# else
    (void)"No AO_short_and_write";
# endif
# ifdef AO_HAVE_short_or_write
    (void)"AO_short_or_write(&val, incr):";
    AO_short_or_write(&val, incr);
# else
    (void)"No AO_short_or_write";
# endif
# ifdef AO_HAVE_short_xor_write
    (void)"AO_short_xor_write(&val, incr):";
    AO_short_xor_write(&val, incr);
# else
    (void)"No AO_short_xor_write";
# endif
# ifdef AO_HAVE_short_compare_and_swap_write
    (void)"AO_short_compare_and_swap_write(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_write */
  /* TODO: Add AO_compare_and_swap_double_write */
# ifdef AO_HAVE_short_fetch_compare_and_swap_write
    (void)"AO_short_fetch_compare_and_swap_write(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_write";
# endif

# if defined(AO_HAVE_test_and_set_write)
    (void)"AO_test_and_set_write(&ts):";
    (void)AO_test_and_set_write(&ts);
# else
    (void)"No AO_test_and_set_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_full(void)
{
# if defined(AO_HAVE_short_load_full) || defined(AO_HAVE_short_store_full) \
     || defined(AO_HAVE_short_fetch_and_add_full) \
     || defined(AO_HAVE_short_fetch_and_add1_full) \
     || defined(AO_HAVE_short_and_full) \
     || defined(AO_HAVE_short_compare_and_swap_full) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_full)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_full) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_full)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_full) \
     || defined(AO_HAVE_short_compare_and_swap_full) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_full)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_full)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_full) || defined(AO_HAVE_short_and_full) \
     || defined(AO_HAVE_short_or_full) || defined(AO_HAVE_short_xor_full)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_full)
    (void)"AO_nop_full(): ";
    AO_nop_full();
# else
    (void)"No AO_nop_full";
# endif

# ifdef AO_HAVE_short_load_full
    (void)"AO_short_load_full(&val):";
    (void)AO_short_load_full(&val);
# else
    (void)"No AO_short_load_full";
# endif
# ifdef AO_HAVE_short_store_full
    (void)"AO_short_store_full(&val, newval):";
    AO_short_store_full(&val, newval);
# else
    (void)"No AO_short_store_full";
# endif
# ifdef AO_HAVE_short_fetch_and_add_full
    (void)"AO_short_fetch_and_add_full(&val, incr):";
    (void)AO_short_fetch_and_add_full(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_full";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_full
    (void)"AO_short_fetch_and_add1_full(&val):";
    (void)AO_short_fetch_and_add1_full(&val);
# else
    (void)"No AO_short_fetch_and_add1_full";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_full
    (void)"AO_short_fetch_and_sub1_full(&val):";
    (void)AO_short_fetch_and_sub1_full(&val);
# else
    (void)"No AO_short_fetch_and_sub1_full";
# endif
# ifdef AO_HAVE_short_and_full
    (void)"AO_short_and_full(&val, incr):";
    AO_short_and_full(&val, incr);
# else
    (void)"No AO_short_and_full";
# endif
# ifdef AO_HAVE_short_or_full
    (void)"AO_short_or_full(&val, incr):";
    AO_short_or_full(&val, incr);
# else
    (void)"No AO_short_or_full";
# endif
# ifdef AO_HAVE_short_xor_full
    (void)"AO_short_xor_full(&val, incr):";
    AO_short_xor_full(&val, incr);
# else
    (void)"No AO_short_xor_full";
# endif
# ifdef AO_HAVE_short_compare_and_swap_full
    (void)"AO_short_compare_and_swap_full(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_full(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_full";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_full */
  /* TODO: Add AO_compare_and_swap_double_full */
# ifdef AO_HAVE_short_fetch_compare_and_swap_full
    (void)"AO_short_fetch_compare_and_swap_full(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_full(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_full";
# endif

# if defined(AO_HAVE_test_and_set_full)
    (void)"AO_test_and_set_full(&ts):";
    (void)AO_test_and_set_full(&ts);
# else
    (void)"No AO_test_and_set_full";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_release_write(void)
{
# if defined(AO_HAVE_short_load_release_write) || defined(AO_HAVE_short_store_release_write) \
     || defined(AO_HAVE_short_fetch_and_add_release_write) \
     || defined(AO_HAVE_short_fetch_and_add1_release_write) \
     || defined(AO_HAVE_short_and_release_write) \
     || defined(AO_HAVE_short_compare_and_swap_release_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release_write)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_release_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release_write)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_release_write) \
     || defined(AO_HAVE_short_compare_and_swap_release_write) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_release_write)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_release_write) || defined(AO_HAVE_short_and_release_write) \
     || defined(AO_HAVE_short_or_release_write) || defined(AO_HAVE_short_xor_release_write)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release_write)
    (void)"AO_nop_release_write(): ";
    AO_nop_release_write();
# else
    (void)"No AO_nop_release_write";
# endif

# ifdef AO_HAVE_short_load_release_write
    (void)"AO_short_load_release_write(&val):";
    (void)AO_short_load_release_write(&val);
# else
    (void)"No AO_short_load_release_write";
# endif
# ifdef AO_HAVE_short_store_release_write
    (void)"AO_short_store_release_write(&val, newval):";
    AO_short_store_release_write(&val, newval);
# else
    (void)"No AO_short_store_release_write";
# endif
# ifdef AO_HAVE_short_fetch_and_add_release_write
    (void)"AO_short_fetch_and_add_release_write(&val, incr):";
    (void)AO_short_fetch_and_add_release_write(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_release_write";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_release_write
    (void)"AO_short_fetch_and_add1_release_write(&val):";
    (void)AO_short_fetch_and_add1_release_write(&val);
# else
    (void)"No AO_short_fetch_and_add1_release_write";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_release_write
    (void)"AO_short_fetch_and_sub1_release_write(&val):";
    (void)AO_short_fetch_and_sub1_release_write(&val);
# else
    (void)"No AO_short_fetch_and_sub1_release_write";
# endif
# ifdef AO_HAVE_short_and_release_write
    (void)"AO_short_and_release_write(&val, incr):";
    AO_short_and_release_write(&val, incr);
# else
    (void)"No AO_short_and_release_write";
# endif
# ifdef AO_HAVE_short_or_release_write
    (void)"AO_short_or_release_write(&val, incr):";
    AO_short_or_release_write(&val, incr);
# else
    (void)"No AO_short_or_release_write";
# endif
# ifdef AO_HAVE_short_xor_release_write
    (void)"AO_short_xor_release_write(&val, incr):";
    AO_short_xor_release_write(&val, incr);
# else
    (void)"No AO_short_xor_release_write";
# endif
# ifdef AO_HAVE_short_compare_and_swap_release_write
    (void)"AO_short_compare_and_swap_release_write(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_release_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_release_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release_write */
  /* TODO: Add AO_compare_and_swap_double_release_write */
# ifdef AO_HAVE_short_fetch_compare_and_swap_release_write
    (void)"AO_short_fetch_compare_and_swap_release_write(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_release_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_release_write";
# endif

# if defined(AO_HAVE_test_and_set_release_write)
    (void)"AO_test_and_set_release_write(&ts):";
    (void)AO_test_and_set_release_write(&ts);
# else
    (void)"No AO_test_and_set_release_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_acquire_read(void)
{
# if defined(AO_HAVE_short_load_acquire_read) || defined(AO_HAVE_short_store_acquire_read) \
     || defined(AO_HAVE_short_fetch_and_add_acquire_read) \
     || defined(AO_HAVE_short_fetch_and_add1_acquire_read) \
     || defined(AO_HAVE_short_and_acquire_read) \
     || defined(AO_HAVE_short_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire_read)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire_read)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_acquire_read) \
     || defined(AO_HAVE_short_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_acquire_read)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_acquire_read) || defined(AO_HAVE_short_and_acquire_read) \
     || defined(AO_HAVE_short_or_acquire_read) || defined(AO_HAVE_short_xor_acquire_read)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire_read)
    (void)"AO_nop_acquire_read(): ";
    AO_nop_acquire_read();
# else
    (void)"No AO_nop_acquire_read";
# endif

# ifdef AO_HAVE_short_load_acquire_read
    (void)"AO_short_load_acquire_read(&val):";
    (void)AO_short_load_acquire_read(&val);
# else
    (void)"No AO_short_load_acquire_read";
# endif
# ifdef AO_HAVE_short_store_acquire_read
    (void)"AO_short_store_acquire_read(&val, newval):";
    AO_short_store_acquire_read(&val, newval);
# else
    (void)"No AO_short_store_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add_acquire_read
    (void)"AO_short_fetch_and_add_acquire_read(&val, incr):";
    (void)AO_short_fetch_and_add_acquire_read(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_acquire_read
    (void)"AO_short_fetch_and_add1_acquire_read(&val):";
    (void)AO_short_fetch_and_add1_acquire_read(&val);
# else
    (void)"No AO_short_fetch_and_add1_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_acquire_read
    (void)"AO_short_fetch_and_sub1_acquire_read(&val):";
    (void)AO_short_fetch_and_sub1_acquire_read(&val);
# else
    (void)"No AO_short_fetch_and_sub1_acquire_read";
# endif
# ifdef AO_HAVE_short_and_acquire_read
    (void)"AO_short_and_acquire_read(&val, incr):";
    AO_short_and_acquire_read(&val, incr);
# else
    (void)"No AO_short_and_acquire_read";
# endif
# ifdef AO_HAVE_short_or_acquire_read
    (void)"AO_short_or_acquire_read(&val, incr):";
    AO_short_or_acquire_read(&val, incr);
# else
    (void)"No AO_short_or_acquire_read";
# endif
# ifdef AO_HAVE_short_xor_acquire_read
    (void)"AO_short_xor_acquire_read(&val, incr):";
    AO_short_xor_acquire_read(&val, incr);
# else
    (void)"No AO_short_xor_acquire_read";
# endif
# ifdef AO_HAVE_short_compare_and_swap_acquire_read
    (void)"AO_short_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_acquire_read */
# ifdef AO_HAVE_short_fetch_compare_and_swap_acquire_read
    (void)"AO_short_fetch_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_acquire_read)
    (void)"AO_test_and_set_acquire_read(&ts):";
    (void)AO_test_and_set_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void short_list_atomic_dd_acquire_read(void)
{
# if defined(AO_HAVE_short_load_dd_acquire_read) || defined(AO_HAVE_short_store_dd_acquire_read) \
     || defined(AO_HAVE_short_fetch_and_add_dd_acquire_read) \
     || defined(AO_HAVE_short_fetch_and_add1_dd_acquire_read) \
     || defined(AO_HAVE_short_and_dd_acquire_read) \
     || defined(AO_HAVE_short_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_dd_acquire_read)
    static volatile unsigned/**/short val /* = 0 */;
# endif
# if defined(AO_HAVE_short_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_dd_acquire_read)
    static unsigned/**/short oldval /* = 0 */;
# endif
# if defined(AO_HAVE_short_store_dd_acquire_read) \
     || defined(AO_HAVE_short_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_short_fetch_compare_and_swap_dd_acquire_read)
    static unsigned/**/short newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_short_fetch_and_add_dd_acquire_read) || defined(AO_HAVE_short_and_dd_acquire_read) \
     || defined(AO_HAVE_short_or_dd_acquire_read) || defined(AO_HAVE_short_xor_dd_acquire_read)
    static unsigned/**/short incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_dd_acquire_read)
    (void)"AO_nop_dd_acquire_read(): ";
    AO_nop_dd_acquire_read();
# else
    (void)"No AO_nop_dd_acquire_read";
# endif

# ifdef AO_HAVE_short_load_dd_acquire_read
    (void)"AO_short_load_dd_acquire_read(&val):";
    (void)AO_short_load_dd_acquire_read(&val);
# else
    (void)"No AO_short_load_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_store_dd_acquire_read
    (void)"AO_short_store_dd_acquire_read(&val, newval):";
    AO_short_store_dd_acquire_read(&val, newval);
# else
    (void)"No AO_short_store_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add_dd_acquire_read
    (void)"AO_short_fetch_and_add_dd_acquire_read(&val, incr):";
    (void)AO_short_fetch_and_add_dd_acquire_read(&val, incr);
# else
    (void)"No AO_short_fetch_and_add_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_add1_dd_acquire_read
    (void)"AO_short_fetch_and_add1_dd_acquire_read(&val):";
    (void)AO_short_fetch_and_add1_dd_acquire_read(&val);
# else
    (void)"No AO_short_fetch_and_add1_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_fetch_and_sub1_dd_acquire_read
    (void)"AO_short_fetch_and_sub1_dd_acquire_read(&val):";
    (void)AO_short_fetch_and_sub1_dd_acquire_read(&val);
# else
    (void)"No AO_short_fetch_and_sub1_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_and_dd_acquire_read
    (void)"AO_short_and_dd_acquire_read(&val, incr):";
    AO_short_and_dd_acquire_read(&val, incr);
# else
    (void)"No AO_short_and_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_or_dd_acquire_read
    (void)"AO_short_or_dd_acquire_read(&val, incr):";
    AO_short_or_dd_acquire_read(&val, incr);
# else
    (void)"No AO_short_or_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_xor_dd_acquire_read
    (void)"AO_short_xor_dd_acquire_read(&val, incr):";
    AO_short_xor_dd_acquire_read(&val, incr);
# else
    (void)"No AO_short_xor_dd_acquire_read";
# endif
# ifdef AO_HAVE_short_compare_and_swap_dd_acquire_read
    (void)"AO_short_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (!AO_short_compare_and_swap_dd_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_short_compare_and_swap_dd_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_dd_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_dd_acquire_read */
# ifdef AO_HAVE_short_fetch_compare_and_swap_dd_acquire_read
    (void)"AO_short_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (AO_short_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_short_fetch_compare_and_swap_dd_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    (void)"AO_test_and_set_dd_acquire_read(&ts):";
    (void)AO_test_and_set_dd_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_dd_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic(void)
{
# if defined(AO_HAVE_int_load) || defined(AO_HAVE_int_store) \
     || defined(AO_HAVE_int_fetch_and_add) \
     || defined(AO_HAVE_int_fetch_and_add1) \
     || defined(AO_HAVE_int_and) \
     || defined(AO_HAVE_int_compare_and_swap) \
     || defined(AO_HAVE_int_fetch_compare_and_swap)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap) \
     || defined(AO_HAVE_int_fetch_compare_and_swap)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store) \
     || defined(AO_HAVE_int_compare_and_swap) \
     || defined(AO_HAVE_int_fetch_compare_and_swap)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add) || defined(AO_HAVE_int_and) \
     || defined(AO_HAVE_int_or) || defined(AO_HAVE_int_xor)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop)
    (void)"AO_nop(): ";
    AO_nop();
# else
    (void)"No AO_nop";
# endif

# ifdef AO_HAVE_int_load
    (void)"AO_int_load(&val):";
    (void)AO_int_load(&val);
# else
    (void)"No AO_int_load";
# endif
# ifdef AO_HAVE_int_store
    (void)"AO_int_store(&val, newval):";
    AO_int_store(&val, newval);
# else
    (void)"No AO_int_store";
# endif
# ifdef AO_HAVE_int_fetch_and_add
    (void)"AO_int_fetch_and_add(&val, incr):";
    (void)AO_int_fetch_and_add(&val, incr);
# else
    (void)"No AO_int_fetch_and_add";
# endif
# ifdef AO_HAVE_int_fetch_and_add1
    (void)"AO_int_fetch_and_add1(&val):";
    (void)AO_int_fetch_and_add1(&val);
# else
    (void)"No AO_int_fetch_and_add1";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1
    (void)"AO_int_fetch_and_sub1(&val):";
    (void)AO_int_fetch_and_sub1(&val);
# else
    (void)"No AO_int_fetch_and_sub1";
# endif
# ifdef AO_HAVE_int_and
    (void)"AO_int_and(&val, incr):";
    AO_int_and(&val, incr);
# else
    (void)"No AO_int_and";
# endif
# ifdef AO_HAVE_int_or
    (void)"AO_int_or(&val, incr):";
    AO_int_or(&val, incr);
# else
    (void)"No AO_int_or";
# endif
# ifdef AO_HAVE_int_xor
    (void)"AO_int_xor(&val, incr):";
    AO_int_xor(&val, incr);
# else
    (void)"No AO_int_xor";
# endif
# ifdef AO_HAVE_int_compare_and_swap
    (void)"AO_int_compare_and_swap(&val, oldval, newval):";
    if (!AO_int_compare_and_swap(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap";
# endif
  /* TODO: Add AO_compare_double_and_swap_double */
  /* TODO: Add AO_compare_and_swap_double */
# ifdef AO_HAVE_int_fetch_compare_and_swap
    (void)"AO_int_fetch_compare_and_swap(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap";
# endif

# if defined(AO_HAVE_test_and_set)
    (void)"AO_test_and_set(&ts):";
    (void)AO_test_and_set(&ts);
# else
    (void)"No AO_test_and_set";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_release(void)
{
# if defined(AO_HAVE_int_load_release) || defined(AO_HAVE_int_store_release) \
     || defined(AO_HAVE_int_fetch_and_add_release) \
     || defined(AO_HAVE_int_fetch_and_add1_release) \
     || defined(AO_HAVE_int_and_release) \
     || defined(AO_HAVE_int_compare_and_swap_release) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_release) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_release) \
     || defined(AO_HAVE_int_compare_and_swap_release) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_release) || defined(AO_HAVE_int_and_release) \
     || defined(AO_HAVE_int_or_release) || defined(AO_HAVE_int_xor_release)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release)
    (void)"AO_nop_release(): ";
    AO_nop_release();
# else
    (void)"No AO_nop_release";
# endif

# ifdef AO_HAVE_int_load_release
    (void)"AO_int_load_release(&val):";
    (void)AO_int_load_release(&val);
# else
    (void)"No AO_int_load_release";
# endif
# ifdef AO_HAVE_int_store_release
    (void)"AO_int_store_release(&val, newval):";
    AO_int_store_release(&val, newval);
# else
    (void)"No AO_int_store_release";
# endif
# ifdef AO_HAVE_int_fetch_and_add_release
    (void)"AO_int_fetch_and_add_release(&val, incr):";
    (void)AO_int_fetch_and_add_release(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_release";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_release
    (void)"AO_int_fetch_and_add1_release(&val):";
    (void)AO_int_fetch_and_add1_release(&val);
# else
    (void)"No AO_int_fetch_and_add1_release";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_release
    (void)"AO_int_fetch_and_sub1_release(&val):";
    (void)AO_int_fetch_and_sub1_release(&val);
# else
    (void)"No AO_int_fetch_and_sub1_release";
# endif
# ifdef AO_HAVE_int_and_release
    (void)"AO_int_and_release(&val, incr):";
    AO_int_and_release(&val, incr);
# else
    (void)"No AO_int_and_release";
# endif
# ifdef AO_HAVE_int_or_release
    (void)"AO_int_or_release(&val, incr):";
    AO_int_or_release(&val, incr);
# else
    (void)"No AO_int_or_release";
# endif
# ifdef AO_HAVE_int_xor_release
    (void)"AO_int_xor_release(&val, incr):";
    AO_int_xor_release(&val, incr);
# else
    (void)"No AO_int_xor_release";
# endif
# ifdef AO_HAVE_int_compare_and_swap_release
    (void)"AO_int_compare_and_swap_release(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_release(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_release";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release */
  /* TODO: Add AO_compare_and_swap_double_release */
# ifdef AO_HAVE_int_fetch_compare_and_swap_release
    (void)"AO_int_fetch_compare_and_swap_release(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_release(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_release";
# endif

# if defined(AO_HAVE_test_and_set_release)
    (void)"AO_test_and_set_release(&ts):";
    (void)AO_test_and_set_release(&ts);
# else
    (void)"No AO_test_and_set_release";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_acquire(void)
{
# if defined(AO_HAVE_int_load_acquire) || defined(AO_HAVE_int_store_acquire) \
     || defined(AO_HAVE_int_fetch_and_add_acquire) \
     || defined(AO_HAVE_int_fetch_and_add1_acquire) \
     || defined(AO_HAVE_int_and_acquire) \
     || defined(AO_HAVE_int_compare_and_swap_acquire) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_acquire) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_acquire) \
     || defined(AO_HAVE_int_compare_and_swap_acquire) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_acquire) || defined(AO_HAVE_int_and_acquire) \
     || defined(AO_HAVE_int_or_acquire) || defined(AO_HAVE_int_xor_acquire)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire)
    (void)"AO_nop_acquire(): ";
    AO_nop_acquire();
# else
    (void)"No AO_nop_acquire";
# endif

# ifdef AO_HAVE_int_load_acquire
    (void)"AO_int_load_acquire(&val):";
    (void)AO_int_load_acquire(&val);
# else
    (void)"No AO_int_load_acquire";
# endif
# ifdef AO_HAVE_int_store_acquire
    (void)"AO_int_store_acquire(&val, newval):";
    AO_int_store_acquire(&val, newval);
# else
    (void)"No AO_int_store_acquire";
# endif
# ifdef AO_HAVE_int_fetch_and_add_acquire
    (void)"AO_int_fetch_and_add_acquire(&val, incr):";
    (void)AO_int_fetch_and_add_acquire(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_acquire";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_acquire
    (void)"AO_int_fetch_and_add1_acquire(&val):";
    (void)AO_int_fetch_and_add1_acquire(&val);
# else
    (void)"No AO_int_fetch_and_add1_acquire";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_acquire
    (void)"AO_int_fetch_and_sub1_acquire(&val):";
    (void)AO_int_fetch_and_sub1_acquire(&val);
# else
    (void)"No AO_int_fetch_and_sub1_acquire";
# endif
# ifdef AO_HAVE_int_and_acquire
    (void)"AO_int_and_acquire(&val, incr):";
    AO_int_and_acquire(&val, incr);
# else
    (void)"No AO_int_and_acquire";
# endif
# ifdef AO_HAVE_int_or_acquire
    (void)"AO_int_or_acquire(&val, incr):";
    AO_int_or_acquire(&val, incr);
# else
    (void)"No AO_int_or_acquire";
# endif
# ifdef AO_HAVE_int_xor_acquire
    (void)"AO_int_xor_acquire(&val, incr):";
    AO_int_xor_acquire(&val, incr);
# else
    (void)"No AO_int_xor_acquire";
# endif
# ifdef AO_HAVE_int_compare_and_swap_acquire
    (void)"AO_int_compare_and_swap_acquire(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_acquire(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_acquire";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire */
  /* TODO: Add AO_compare_and_swap_double_acquire */
# ifdef AO_HAVE_int_fetch_compare_and_swap_acquire
    (void)"AO_int_fetch_compare_and_swap_acquire(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_acquire(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_acquire";
# endif

# if defined(AO_HAVE_test_and_set_acquire)
    (void)"AO_test_and_set_acquire(&ts):";
    (void)AO_test_and_set_acquire(&ts);
# else
    (void)"No AO_test_and_set_acquire";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_read(void)
{
# if defined(AO_HAVE_int_load_read) || defined(AO_HAVE_int_store_read) \
     || defined(AO_HAVE_int_fetch_and_add_read) \
     || defined(AO_HAVE_int_fetch_and_add1_read) \
     || defined(AO_HAVE_int_and_read) \
     || defined(AO_HAVE_int_compare_and_swap_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_read)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_read)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_read) \
     || defined(AO_HAVE_int_compare_and_swap_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_read)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_read) || defined(AO_HAVE_int_and_read) \
     || defined(AO_HAVE_int_or_read) || defined(AO_HAVE_int_xor_read)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_read)
    (void)"AO_nop_read(): ";
    AO_nop_read();
# else
    (void)"No AO_nop_read";
# endif

# ifdef AO_HAVE_int_load_read
    (void)"AO_int_load_read(&val):";
    (void)AO_int_load_read(&val);
# else
    (void)"No AO_int_load_read";
# endif
# ifdef AO_HAVE_int_store_read
    (void)"AO_int_store_read(&val, newval):";
    AO_int_store_read(&val, newval);
# else
    (void)"No AO_int_store_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add_read
    (void)"AO_int_fetch_and_add_read(&val, incr):";
    (void)AO_int_fetch_and_add_read(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_read
    (void)"AO_int_fetch_and_add1_read(&val):";
    (void)AO_int_fetch_and_add1_read(&val);
# else
    (void)"No AO_int_fetch_and_add1_read";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_read
    (void)"AO_int_fetch_and_sub1_read(&val):";
    (void)AO_int_fetch_and_sub1_read(&val);
# else
    (void)"No AO_int_fetch_and_sub1_read";
# endif
# ifdef AO_HAVE_int_and_read
    (void)"AO_int_and_read(&val, incr):";
    AO_int_and_read(&val, incr);
# else
    (void)"No AO_int_and_read";
# endif
# ifdef AO_HAVE_int_or_read
    (void)"AO_int_or_read(&val, incr):";
    AO_int_or_read(&val, incr);
# else
    (void)"No AO_int_or_read";
# endif
# ifdef AO_HAVE_int_xor_read
    (void)"AO_int_xor_read(&val, incr):";
    AO_int_xor_read(&val, incr);
# else
    (void)"No AO_int_xor_read";
# endif
# ifdef AO_HAVE_int_compare_and_swap_read
    (void)"AO_int_compare_and_swap_read(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_read */
  /* TODO: Add AO_compare_and_swap_double_read */
# ifdef AO_HAVE_int_fetch_compare_and_swap_read
    (void)"AO_int_fetch_compare_and_swap_read(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_read";
# endif

# if defined(AO_HAVE_test_and_set_read)
    (void)"AO_test_and_set_read(&ts):";
    (void)AO_test_and_set_read(&ts);
# else
    (void)"No AO_test_and_set_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_write(void)
{
# if defined(AO_HAVE_int_load_write) || defined(AO_HAVE_int_store_write) \
     || defined(AO_HAVE_int_fetch_and_add_write) \
     || defined(AO_HAVE_int_fetch_and_add1_write) \
     || defined(AO_HAVE_int_and_write) \
     || defined(AO_HAVE_int_compare_and_swap_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_write)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_write)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_write) \
     || defined(AO_HAVE_int_compare_and_swap_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_write)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_write) || defined(AO_HAVE_int_and_write) \
     || defined(AO_HAVE_int_or_write) || defined(AO_HAVE_int_xor_write)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_write)
    (void)"AO_nop_write(): ";
    AO_nop_write();
# else
    (void)"No AO_nop_write";
# endif

# ifdef AO_HAVE_int_load_write
    (void)"AO_int_load_write(&val):";
    (void)AO_int_load_write(&val);
# else
    (void)"No AO_int_load_write";
# endif
# ifdef AO_HAVE_int_store_write
    (void)"AO_int_store_write(&val, newval):";
    AO_int_store_write(&val, newval);
# else
    (void)"No AO_int_store_write";
# endif
# ifdef AO_HAVE_int_fetch_and_add_write
    (void)"AO_int_fetch_and_add_write(&val, incr):";
    (void)AO_int_fetch_and_add_write(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_write";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_write
    (void)"AO_int_fetch_and_add1_write(&val):";
    (void)AO_int_fetch_and_add1_write(&val);
# else
    (void)"No AO_int_fetch_and_add1_write";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_write
    (void)"AO_int_fetch_and_sub1_write(&val):";
    (void)AO_int_fetch_and_sub1_write(&val);
# else
    (void)"No AO_int_fetch_and_sub1_write";
# endif
# ifdef AO_HAVE_int_and_write
    (void)"AO_int_and_write(&val, incr):";
    AO_int_and_write(&val, incr);
# else
    (void)"No AO_int_and_write";
# endif
# ifdef AO_HAVE_int_or_write
    (void)"AO_int_or_write(&val, incr):";
    AO_int_or_write(&val, incr);
# else
    (void)"No AO_int_or_write";
# endif
# ifdef AO_HAVE_int_xor_write
    (void)"AO_int_xor_write(&val, incr):";
    AO_int_xor_write(&val, incr);
# else
    (void)"No AO_int_xor_write";
# endif
# ifdef AO_HAVE_int_compare_and_swap_write
    (void)"AO_int_compare_and_swap_write(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_write */
  /* TODO: Add AO_compare_and_swap_double_write */
# ifdef AO_HAVE_int_fetch_compare_and_swap_write
    (void)"AO_int_fetch_compare_and_swap_write(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_write";
# endif

# if defined(AO_HAVE_test_and_set_write)
    (void)"AO_test_and_set_write(&ts):";
    (void)AO_test_and_set_write(&ts);
# else
    (void)"No AO_test_and_set_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_full(void)
{
# if defined(AO_HAVE_int_load_full) || defined(AO_HAVE_int_store_full) \
     || defined(AO_HAVE_int_fetch_and_add_full) \
     || defined(AO_HAVE_int_fetch_and_add1_full) \
     || defined(AO_HAVE_int_and_full) \
     || defined(AO_HAVE_int_compare_and_swap_full) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_full)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_full) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_full)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_full) \
     || defined(AO_HAVE_int_compare_and_swap_full) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_full)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_full)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_full) || defined(AO_HAVE_int_and_full) \
     || defined(AO_HAVE_int_or_full) || defined(AO_HAVE_int_xor_full)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_full)
    (void)"AO_nop_full(): ";
    AO_nop_full();
# else
    (void)"No AO_nop_full";
# endif

# ifdef AO_HAVE_int_load_full
    (void)"AO_int_load_full(&val):";
    (void)AO_int_load_full(&val);
# else
    (void)"No AO_int_load_full";
# endif
# ifdef AO_HAVE_int_store_full
    (void)"AO_int_store_full(&val, newval):";
    AO_int_store_full(&val, newval);
# else
    (void)"No AO_int_store_full";
# endif
# ifdef AO_HAVE_int_fetch_and_add_full
    (void)"AO_int_fetch_and_add_full(&val, incr):";
    (void)AO_int_fetch_and_add_full(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_full";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_full
    (void)"AO_int_fetch_and_add1_full(&val):";
    (void)AO_int_fetch_and_add1_full(&val);
# else
    (void)"No AO_int_fetch_and_add1_full";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_full
    (void)"AO_int_fetch_and_sub1_full(&val):";
    (void)AO_int_fetch_and_sub1_full(&val);
# else
    (void)"No AO_int_fetch_and_sub1_full";
# endif
# ifdef AO_HAVE_int_and_full
    (void)"AO_int_and_full(&val, incr):";
    AO_int_and_full(&val, incr);
# else
    (void)"No AO_int_and_full";
# endif
# ifdef AO_HAVE_int_or_full
    (void)"AO_int_or_full(&val, incr):";
    AO_int_or_full(&val, incr);
# else
    (void)"No AO_int_or_full";
# endif
# ifdef AO_HAVE_int_xor_full
    (void)"AO_int_xor_full(&val, incr):";
    AO_int_xor_full(&val, incr);
# else
    (void)"No AO_int_xor_full";
# endif
# ifdef AO_HAVE_int_compare_and_swap_full
    (void)"AO_int_compare_and_swap_full(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_full(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_full";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_full */
  /* TODO: Add AO_compare_and_swap_double_full */
# ifdef AO_HAVE_int_fetch_compare_and_swap_full
    (void)"AO_int_fetch_compare_and_swap_full(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_full(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_full";
# endif

# if defined(AO_HAVE_test_and_set_full)
    (void)"AO_test_and_set_full(&ts):";
    (void)AO_test_and_set_full(&ts);
# else
    (void)"No AO_test_and_set_full";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_release_write(void)
{
# if defined(AO_HAVE_int_load_release_write) || defined(AO_HAVE_int_store_release_write) \
     || defined(AO_HAVE_int_fetch_and_add_release_write) \
     || defined(AO_HAVE_int_fetch_and_add1_release_write) \
     || defined(AO_HAVE_int_and_release_write) \
     || defined(AO_HAVE_int_compare_and_swap_release_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release_write)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_release_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release_write)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_release_write) \
     || defined(AO_HAVE_int_compare_and_swap_release_write) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_release_write)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_release_write) || defined(AO_HAVE_int_and_release_write) \
     || defined(AO_HAVE_int_or_release_write) || defined(AO_HAVE_int_xor_release_write)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release_write)
    (void)"AO_nop_release_write(): ";
    AO_nop_release_write();
# else
    (void)"No AO_nop_release_write";
# endif

# ifdef AO_HAVE_int_load_release_write
    (void)"AO_int_load_release_write(&val):";
    (void)AO_int_load_release_write(&val);
# else
    (void)"No AO_int_load_release_write";
# endif
# ifdef AO_HAVE_int_store_release_write
    (void)"AO_int_store_release_write(&val, newval):";
    AO_int_store_release_write(&val, newval);
# else
    (void)"No AO_int_store_release_write";
# endif
# ifdef AO_HAVE_int_fetch_and_add_release_write
    (void)"AO_int_fetch_and_add_release_write(&val, incr):";
    (void)AO_int_fetch_and_add_release_write(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_release_write";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_release_write
    (void)"AO_int_fetch_and_add1_release_write(&val):";
    (void)AO_int_fetch_and_add1_release_write(&val);
# else
    (void)"No AO_int_fetch_and_add1_release_write";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_release_write
    (void)"AO_int_fetch_and_sub1_release_write(&val):";
    (void)AO_int_fetch_and_sub1_release_write(&val);
# else
    (void)"No AO_int_fetch_and_sub1_release_write";
# endif
# ifdef AO_HAVE_int_and_release_write
    (void)"AO_int_and_release_write(&val, incr):";
    AO_int_and_release_write(&val, incr);
# else
    (void)"No AO_int_and_release_write";
# endif
# ifdef AO_HAVE_int_or_release_write
    (void)"AO_int_or_release_write(&val, incr):";
    AO_int_or_release_write(&val, incr);
# else
    (void)"No AO_int_or_release_write";
# endif
# ifdef AO_HAVE_int_xor_release_write
    (void)"AO_int_xor_release_write(&val, incr):";
    AO_int_xor_release_write(&val, incr);
# else
    (void)"No AO_int_xor_release_write";
# endif
# ifdef AO_HAVE_int_compare_and_swap_release_write
    (void)"AO_int_compare_and_swap_release_write(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_release_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_release_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release_write */
  /* TODO: Add AO_compare_and_swap_double_release_write */
# ifdef AO_HAVE_int_fetch_compare_and_swap_release_write
    (void)"AO_int_fetch_compare_and_swap_release_write(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_release_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_release_write";
# endif

# if defined(AO_HAVE_test_and_set_release_write)
    (void)"AO_test_and_set_release_write(&ts):";
    (void)AO_test_and_set_release_write(&ts);
# else
    (void)"No AO_test_and_set_release_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_acquire_read(void)
{
# if defined(AO_HAVE_int_load_acquire_read) || defined(AO_HAVE_int_store_acquire_read) \
     || defined(AO_HAVE_int_fetch_and_add_acquire_read) \
     || defined(AO_HAVE_int_fetch_and_add1_acquire_read) \
     || defined(AO_HAVE_int_and_acquire_read) \
     || defined(AO_HAVE_int_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire_read)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire_read)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_acquire_read) \
     || defined(AO_HAVE_int_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_acquire_read)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_acquire_read) || defined(AO_HAVE_int_and_acquire_read) \
     || defined(AO_HAVE_int_or_acquire_read) || defined(AO_HAVE_int_xor_acquire_read)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire_read)
    (void)"AO_nop_acquire_read(): ";
    AO_nop_acquire_read();
# else
    (void)"No AO_nop_acquire_read";
# endif

# ifdef AO_HAVE_int_load_acquire_read
    (void)"AO_int_load_acquire_read(&val):";
    (void)AO_int_load_acquire_read(&val);
# else
    (void)"No AO_int_load_acquire_read";
# endif
# ifdef AO_HAVE_int_store_acquire_read
    (void)"AO_int_store_acquire_read(&val, newval):";
    AO_int_store_acquire_read(&val, newval);
# else
    (void)"No AO_int_store_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add_acquire_read
    (void)"AO_int_fetch_and_add_acquire_read(&val, incr):";
    (void)AO_int_fetch_and_add_acquire_read(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_acquire_read
    (void)"AO_int_fetch_and_add1_acquire_read(&val):";
    (void)AO_int_fetch_and_add1_acquire_read(&val);
# else
    (void)"No AO_int_fetch_and_add1_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_acquire_read
    (void)"AO_int_fetch_and_sub1_acquire_read(&val):";
    (void)AO_int_fetch_and_sub1_acquire_read(&val);
# else
    (void)"No AO_int_fetch_and_sub1_acquire_read";
# endif
# ifdef AO_HAVE_int_and_acquire_read
    (void)"AO_int_and_acquire_read(&val, incr):";
    AO_int_and_acquire_read(&val, incr);
# else
    (void)"No AO_int_and_acquire_read";
# endif
# ifdef AO_HAVE_int_or_acquire_read
    (void)"AO_int_or_acquire_read(&val, incr):";
    AO_int_or_acquire_read(&val, incr);
# else
    (void)"No AO_int_or_acquire_read";
# endif
# ifdef AO_HAVE_int_xor_acquire_read
    (void)"AO_int_xor_acquire_read(&val, incr):";
    AO_int_xor_acquire_read(&val, incr);
# else
    (void)"No AO_int_xor_acquire_read";
# endif
# ifdef AO_HAVE_int_compare_and_swap_acquire_read
    (void)"AO_int_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_acquire_read */
# ifdef AO_HAVE_int_fetch_compare_and_swap_acquire_read
    (void)"AO_int_fetch_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_acquire_read)
    (void)"AO_test_and_set_acquire_read(&ts):";
    (void)AO_test_and_set_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void int_list_atomic_dd_acquire_read(void)
{
# if defined(AO_HAVE_int_load_dd_acquire_read) || defined(AO_HAVE_int_store_dd_acquire_read) \
     || defined(AO_HAVE_int_fetch_and_add_dd_acquire_read) \
     || defined(AO_HAVE_int_fetch_and_add1_dd_acquire_read) \
     || defined(AO_HAVE_int_and_dd_acquire_read) \
     || defined(AO_HAVE_int_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_dd_acquire_read)
    static volatile unsigned val /* = 0 */;
# endif
# if defined(AO_HAVE_int_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_dd_acquire_read)
    static unsigned oldval /* = 0 */;
# endif
# if defined(AO_HAVE_int_store_dd_acquire_read) \
     || defined(AO_HAVE_int_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_int_fetch_compare_and_swap_dd_acquire_read)
    static unsigned newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_int_fetch_and_add_dd_acquire_read) || defined(AO_HAVE_int_and_dd_acquire_read) \
     || defined(AO_HAVE_int_or_dd_acquire_read) || defined(AO_HAVE_int_xor_dd_acquire_read)
    static unsigned incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_dd_acquire_read)
    (void)"AO_nop_dd_acquire_read(): ";
    AO_nop_dd_acquire_read();
# else
    (void)"No AO_nop_dd_acquire_read";
# endif

# ifdef AO_HAVE_int_load_dd_acquire_read
    (void)"AO_int_load_dd_acquire_read(&val):";
    (void)AO_int_load_dd_acquire_read(&val);
# else
    (void)"No AO_int_load_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_store_dd_acquire_read
    (void)"AO_int_store_dd_acquire_read(&val, newval):";
    AO_int_store_dd_acquire_read(&val, newval);
# else
    (void)"No AO_int_store_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add_dd_acquire_read
    (void)"AO_int_fetch_and_add_dd_acquire_read(&val, incr):";
    (void)AO_int_fetch_and_add_dd_acquire_read(&val, incr);
# else
    (void)"No AO_int_fetch_and_add_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_add1_dd_acquire_read
    (void)"AO_int_fetch_and_add1_dd_acquire_read(&val):";
    (void)AO_int_fetch_and_add1_dd_acquire_read(&val);
# else
    (void)"No AO_int_fetch_and_add1_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_fetch_and_sub1_dd_acquire_read
    (void)"AO_int_fetch_and_sub1_dd_acquire_read(&val):";
    (void)AO_int_fetch_and_sub1_dd_acquire_read(&val);
# else
    (void)"No AO_int_fetch_and_sub1_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_and_dd_acquire_read
    (void)"AO_int_and_dd_acquire_read(&val, incr):";
    AO_int_and_dd_acquire_read(&val, incr);
# else
    (void)"No AO_int_and_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_or_dd_acquire_read
    (void)"AO_int_or_dd_acquire_read(&val, incr):";
    AO_int_or_dd_acquire_read(&val, incr);
# else
    (void)"No AO_int_or_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_xor_dd_acquire_read
    (void)"AO_int_xor_dd_acquire_read(&val, incr):";
    AO_int_xor_dd_acquire_read(&val, incr);
# else
    (void)"No AO_int_xor_dd_acquire_read";
# endif
# ifdef AO_HAVE_int_compare_and_swap_dd_acquire_read
    (void)"AO_int_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (!AO_int_compare_and_swap_dd_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_int_compare_and_swap_dd_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_dd_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_dd_acquire_read */
# ifdef AO_HAVE_int_fetch_compare_and_swap_dd_acquire_read
    (void)"AO_int_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (AO_int_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_int_fetch_compare_and_swap_dd_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    (void)"AO_test_and_set_dd_acquire_read(&ts):";
    (void)AO_test_and_set_dd_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_dd_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic(void)
{
# if defined(AO_HAVE_double_load) || defined(AO_HAVE_double_store) \
     || defined(AO_HAVE_double_fetch_and_add) \
     || defined(AO_HAVE_double_fetch_and_add1) \
     || defined(AO_HAVE_double_and) \
     || defined(AO_HAVE_double_compare_and_swap) \
     || defined(AO_HAVE_double_fetch_compare_and_swap)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap) \
     || defined(AO_HAVE_double_fetch_compare_and_swap)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store) \
     || defined(AO_HAVE_double_compare_and_swap) \
     || defined(AO_HAVE_double_fetch_compare_and_swap)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add) || defined(AO_HAVE_double_and) \
     || defined(AO_HAVE_double_or) || defined(AO_HAVE_double_xor)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop)
    (void)"AO_nop(): ";
    AO_nop();
# else
    (void)"No AO_nop";
# endif

# ifdef AO_HAVE_double_load
    (void)"AO_double_load(&val):";
    (void)AO_double_load(&val);
# else
    (void)"No AO_double_load";
# endif
# ifdef AO_HAVE_double_store
    (void)"AO_double_store(&val, newval):";
    AO_double_store(&val, newval);
# else
    (void)"No AO_double_store";
# endif
# ifdef AO_HAVE_double_fetch_and_add
    (void)"AO_double_fetch_and_add(&val, incr):";
    (void)AO_double_fetch_and_add(&val, incr);
# else
    (void)"No AO_double_fetch_and_add";
# endif
# ifdef AO_HAVE_double_fetch_and_add1
    (void)"AO_double_fetch_and_add1(&val):";
    (void)AO_double_fetch_and_add1(&val);
# else
    (void)"No AO_double_fetch_and_add1";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1
    (void)"AO_double_fetch_and_sub1(&val):";
    (void)AO_double_fetch_and_sub1(&val);
# else
    (void)"No AO_double_fetch_and_sub1";
# endif
# ifdef AO_HAVE_double_and
    (void)"AO_double_and(&val, incr):";
    AO_double_and(&val, incr);
# else
    (void)"No AO_double_and";
# endif
# ifdef AO_HAVE_double_or
    (void)"AO_double_or(&val, incr):";
    AO_double_or(&val, incr);
# else
    (void)"No AO_double_or";
# endif
# ifdef AO_HAVE_double_xor
    (void)"AO_double_xor(&val, incr):";
    AO_double_xor(&val, incr);
# else
    (void)"No AO_double_xor";
# endif
# ifdef AO_HAVE_double_compare_and_swap
    (void)"AO_double_compare_and_swap(&val, oldval, newval):";
    if (!AO_double_compare_and_swap(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap";
# endif
  /* TODO: Add AO_compare_double_and_swap_double */
  /* TODO: Add AO_compare_and_swap_double */
# ifdef AO_HAVE_double_fetch_compare_and_swap
    (void)"AO_double_fetch_compare_and_swap(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap";
# endif

# if defined(AO_HAVE_test_and_set)
    (void)"AO_test_and_set(&ts):";
    (void)AO_test_and_set(&ts);
# else
    (void)"No AO_test_and_set";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_release(void)
{
# if defined(AO_HAVE_double_load_release) || defined(AO_HAVE_double_store_release) \
     || defined(AO_HAVE_double_fetch_and_add_release) \
     || defined(AO_HAVE_double_fetch_and_add1_release) \
     || defined(AO_HAVE_double_and_release) \
     || defined(AO_HAVE_double_compare_and_swap_release) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_release) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_release) \
     || defined(AO_HAVE_double_compare_and_swap_release) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_release) || defined(AO_HAVE_double_and_release) \
     || defined(AO_HAVE_double_or_release) || defined(AO_HAVE_double_xor_release)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release)
    (void)"AO_nop_release(): ";
    AO_nop_release();
# else
    (void)"No AO_nop_release";
# endif

# ifdef AO_HAVE_double_load_release
    (void)"AO_double_load_release(&val):";
    (void)AO_double_load_release(&val);
# else
    (void)"No AO_double_load_release";
# endif
# ifdef AO_HAVE_double_store_release
    (void)"AO_double_store_release(&val, newval):";
    AO_double_store_release(&val, newval);
# else
    (void)"No AO_double_store_release";
# endif
# ifdef AO_HAVE_double_fetch_and_add_release
    (void)"AO_double_fetch_and_add_release(&val, incr):";
    (void)AO_double_fetch_and_add_release(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_release";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_release
    (void)"AO_double_fetch_and_add1_release(&val):";
    (void)AO_double_fetch_and_add1_release(&val);
# else
    (void)"No AO_double_fetch_and_add1_release";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_release
    (void)"AO_double_fetch_and_sub1_release(&val):";
    (void)AO_double_fetch_and_sub1_release(&val);
# else
    (void)"No AO_double_fetch_and_sub1_release";
# endif
# ifdef AO_HAVE_double_and_release
    (void)"AO_double_and_release(&val, incr):";
    AO_double_and_release(&val, incr);
# else
    (void)"No AO_double_and_release";
# endif
# ifdef AO_HAVE_double_or_release
    (void)"AO_double_or_release(&val, incr):";
    AO_double_or_release(&val, incr);
# else
    (void)"No AO_double_or_release";
# endif
# ifdef AO_HAVE_double_xor_release
    (void)"AO_double_xor_release(&val, incr):";
    AO_double_xor_release(&val, incr);
# else
    (void)"No AO_double_xor_release";
# endif
# ifdef AO_HAVE_double_compare_and_swap_release
    (void)"AO_double_compare_and_swap_release(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_release(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_release";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release */
  /* TODO: Add AO_compare_and_swap_double_release */
# ifdef AO_HAVE_double_fetch_compare_and_swap_release
    (void)"AO_double_fetch_compare_and_swap_release(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_release(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_release";
# endif

# if defined(AO_HAVE_test_and_set_release)
    (void)"AO_test_and_set_release(&ts):";
    (void)AO_test_and_set_release(&ts);
# else
    (void)"No AO_test_and_set_release";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_acquire(void)
{
# if defined(AO_HAVE_double_load_acquire) || defined(AO_HAVE_double_store_acquire) \
     || defined(AO_HAVE_double_fetch_and_add_acquire) \
     || defined(AO_HAVE_double_fetch_and_add1_acquire) \
     || defined(AO_HAVE_double_and_acquire) \
     || defined(AO_HAVE_double_compare_and_swap_acquire) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_acquire) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_acquire) \
     || defined(AO_HAVE_double_compare_and_swap_acquire) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_acquire) || defined(AO_HAVE_double_and_acquire) \
     || defined(AO_HAVE_double_or_acquire) || defined(AO_HAVE_double_xor_acquire)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire)
    (void)"AO_nop_acquire(): ";
    AO_nop_acquire();
# else
    (void)"No AO_nop_acquire";
# endif

# ifdef AO_HAVE_double_load_acquire
    (void)"AO_double_load_acquire(&val):";
    (void)AO_double_load_acquire(&val);
# else
    (void)"No AO_double_load_acquire";
# endif
# ifdef AO_HAVE_double_store_acquire
    (void)"AO_double_store_acquire(&val, newval):";
    AO_double_store_acquire(&val, newval);
# else
    (void)"No AO_double_store_acquire";
# endif
# ifdef AO_HAVE_double_fetch_and_add_acquire
    (void)"AO_double_fetch_and_add_acquire(&val, incr):";
    (void)AO_double_fetch_and_add_acquire(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_acquire";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_acquire
    (void)"AO_double_fetch_and_add1_acquire(&val):";
    (void)AO_double_fetch_and_add1_acquire(&val);
# else
    (void)"No AO_double_fetch_and_add1_acquire";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_acquire
    (void)"AO_double_fetch_and_sub1_acquire(&val):";
    (void)AO_double_fetch_and_sub1_acquire(&val);
# else
    (void)"No AO_double_fetch_and_sub1_acquire";
# endif
# ifdef AO_HAVE_double_and_acquire
    (void)"AO_double_and_acquire(&val, incr):";
    AO_double_and_acquire(&val, incr);
# else
    (void)"No AO_double_and_acquire";
# endif
# ifdef AO_HAVE_double_or_acquire
    (void)"AO_double_or_acquire(&val, incr):";
    AO_double_or_acquire(&val, incr);
# else
    (void)"No AO_double_or_acquire";
# endif
# ifdef AO_HAVE_double_xor_acquire
    (void)"AO_double_xor_acquire(&val, incr):";
    AO_double_xor_acquire(&val, incr);
# else
    (void)"No AO_double_xor_acquire";
# endif
# ifdef AO_HAVE_double_compare_and_swap_acquire
    (void)"AO_double_compare_and_swap_acquire(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_acquire(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_acquire";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire */
  /* TODO: Add AO_compare_and_swap_double_acquire */
# ifdef AO_HAVE_double_fetch_compare_and_swap_acquire
    (void)"AO_double_fetch_compare_and_swap_acquire(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_acquire(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_acquire";
# endif

# if defined(AO_HAVE_test_and_set_acquire)
    (void)"AO_test_and_set_acquire(&ts):";
    (void)AO_test_and_set_acquire(&ts);
# else
    (void)"No AO_test_and_set_acquire";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_read(void)
{
# if defined(AO_HAVE_double_load_read) || defined(AO_HAVE_double_store_read) \
     || defined(AO_HAVE_double_fetch_and_add_read) \
     || defined(AO_HAVE_double_fetch_and_add1_read) \
     || defined(AO_HAVE_double_and_read) \
     || defined(AO_HAVE_double_compare_and_swap_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_read)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_read)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_read) \
     || defined(AO_HAVE_double_compare_and_swap_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_read)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_read) || defined(AO_HAVE_double_and_read) \
     || defined(AO_HAVE_double_or_read) || defined(AO_HAVE_double_xor_read)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_read)
    (void)"AO_nop_read(): ";
    AO_nop_read();
# else
    (void)"No AO_nop_read";
# endif

# ifdef AO_HAVE_double_load_read
    (void)"AO_double_load_read(&val):";
    (void)AO_double_load_read(&val);
# else
    (void)"No AO_double_load_read";
# endif
# ifdef AO_HAVE_double_store_read
    (void)"AO_double_store_read(&val, newval):";
    AO_double_store_read(&val, newval);
# else
    (void)"No AO_double_store_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add_read
    (void)"AO_double_fetch_and_add_read(&val, incr):";
    (void)AO_double_fetch_and_add_read(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_read
    (void)"AO_double_fetch_and_add1_read(&val):";
    (void)AO_double_fetch_and_add1_read(&val);
# else
    (void)"No AO_double_fetch_and_add1_read";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_read
    (void)"AO_double_fetch_and_sub1_read(&val):";
    (void)AO_double_fetch_and_sub1_read(&val);
# else
    (void)"No AO_double_fetch_and_sub1_read";
# endif
# ifdef AO_HAVE_double_and_read
    (void)"AO_double_and_read(&val, incr):";
    AO_double_and_read(&val, incr);
# else
    (void)"No AO_double_and_read";
# endif
# ifdef AO_HAVE_double_or_read
    (void)"AO_double_or_read(&val, incr):";
    AO_double_or_read(&val, incr);
# else
    (void)"No AO_double_or_read";
# endif
# ifdef AO_HAVE_double_xor_read
    (void)"AO_double_xor_read(&val, incr):";
    AO_double_xor_read(&val, incr);
# else
    (void)"No AO_double_xor_read";
# endif
# ifdef AO_HAVE_double_compare_and_swap_read
    (void)"AO_double_compare_and_swap_read(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_read */
  /* TODO: Add AO_compare_and_swap_double_read */
# ifdef AO_HAVE_double_fetch_compare_and_swap_read
    (void)"AO_double_fetch_compare_and_swap_read(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_read";
# endif

# if defined(AO_HAVE_test_and_set_read)
    (void)"AO_test_and_set_read(&ts):";
    (void)AO_test_and_set_read(&ts);
# else
    (void)"No AO_test_and_set_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_write(void)
{
# if defined(AO_HAVE_double_load_write) || defined(AO_HAVE_double_store_write) \
     || defined(AO_HAVE_double_fetch_and_add_write) \
     || defined(AO_HAVE_double_fetch_and_add1_write) \
     || defined(AO_HAVE_double_and_write) \
     || defined(AO_HAVE_double_compare_and_swap_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_write)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_write)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_write) \
     || defined(AO_HAVE_double_compare_and_swap_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_write)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_write) || defined(AO_HAVE_double_and_write) \
     || defined(AO_HAVE_double_or_write) || defined(AO_HAVE_double_xor_write)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_write)
    (void)"AO_nop_write(): ";
    AO_nop_write();
# else
    (void)"No AO_nop_write";
# endif

# ifdef AO_HAVE_double_load_write
    (void)"AO_double_load_write(&val):";
    (void)AO_double_load_write(&val);
# else
    (void)"No AO_double_load_write";
# endif
# ifdef AO_HAVE_double_store_write
    (void)"AO_double_store_write(&val, newval):";
    AO_double_store_write(&val, newval);
# else
    (void)"No AO_double_store_write";
# endif
# ifdef AO_HAVE_double_fetch_and_add_write
    (void)"AO_double_fetch_and_add_write(&val, incr):";
    (void)AO_double_fetch_and_add_write(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_write";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_write
    (void)"AO_double_fetch_and_add1_write(&val):";
    (void)AO_double_fetch_and_add1_write(&val);
# else
    (void)"No AO_double_fetch_and_add1_write";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_write
    (void)"AO_double_fetch_and_sub1_write(&val):";
    (void)AO_double_fetch_and_sub1_write(&val);
# else
    (void)"No AO_double_fetch_and_sub1_write";
# endif
# ifdef AO_HAVE_double_and_write
    (void)"AO_double_and_write(&val, incr):";
    AO_double_and_write(&val, incr);
# else
    (void)"No AO_double_and_write";
# endif
# ifdef AO_HAVE_double_or_write
    (void)"AO_double_or_write(&val, incr):";
    AO_double_or_write(&val, incr);
# else
    (void)"No AO_double_or_write";
# endif
# ifdef AO_HAVE_double_xor_write
    (void)"AO_double_xor_write(&val, incr):";
    AO_double_xor_write(&val, incr);
# else
    (void)"No AO_double_xor_write";
# endif
# ifdef AO_HAVE_double_compare_and_swap_write
    (void)"AO_double_compare_and_swap_write(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_write */
  /* TODO: Add AO_compare_and_swap_double_write */
# ifdef AO_HAVE_double_fetch_compare_and_swap_write
    (void)"AO_double_fetch_compare_and_swap_write(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_write";
# endif

# if defined(AO_HAVE_test_and_set_write)
    (void)"AO_test_and_set_write(&ts):";
    (void)AO_test_and_set_write(&ts);
# else
    (void)"No AO_test_and_set_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_full(void)
{
# if defined(AO_HAVE_double_load_full) || defined(AO_HAVE_double_store_full) \
     || defined(AO_HAVE_double_fetch_and_add_full) \
     || defined(AO_HAVE_double_fetch_and_add1_full) \
     || defined(AO_HAVE_double_and_full) \
     || defined(AO_HAVE_double_compare_and_swap_full) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_full)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_full) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_full)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_full) \
     || defined(AO_HAVE_double_compare_and_swap_full) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_full)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_full)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_full) || defined(AO_HAVE_double_and_full) \
     || defined(AO_HAVE_double_or_full) || defined(AO_HAVE_double_xor_full)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_full)
    (void)"AO_nop_full(): ";
    AO_nop_full();
# else
    (void)"No AO_nop_full";
# endif

# ifdef AO_HAVE_double_load_full
    (void)"AO_double_load_full(&val):";
    (void)AO_double_load_full(&val);
# else
    (void)"No AO_double_load_full";
# endif
# ifdef AO_HAVE_double_store_full
    (void)"AO_double_store_full(&val, newval):";
    AO_double_store_full(&val, newval);
# else
    (void)"No AO_double_store_full";
# endif
# ifdef AO_HAVE_double_fetch_and_add_full
    (void)"AO_double_fetch_and_add_full(&val, incr):";
    (void)AO_double_fetch_and_add_full(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_full";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_full
    (void)"AO_double_fetch_and_add1_full(&val):";
    (void)AO_double_fetch_and_add1_full(&val);
# else
    (void)"No AO_double_fetch_and_add1_full";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_full
    (void)"AO_double_fetch_and_sub1_full(&val):";
    (void)AO_double_fetch_and_sub1_full(&val);
# else
    (void)"No AO_double_fetch_and_sub1_full";
# endif
# ifdef AO_HAVE_double_and_full
    (void)"AO_double_and_full(&val, incr):";
    AO_double_and_full(&val, incr);
# else
    (void)"No AO_double_and_full";
# endif
# ifdef AO_HAVE_double_or_full
    (void)"AO_double_or_full(&val, incr):";
    AO_double_or_full(&val, incr);
# else
    (void)"No AO_double_or_full";
# endif
# ifdef AO_HAVE_double_xor_full
    (void)"AO_double_xor_full(&val, incr):";
    AO_double_xor_full(&val, incr);
# else
    (void)"No AO_double_xor_full";
# endif
# ifdef AO_HAVE_double_compare_and_swap_full
    (void)"AO_double_compare_and_swap_full(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_full(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_full";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_full */
  /* TODO: Add AO_compare_and_swap_double_full */
# ifdef AO_HAVE_double_fetch_compare_and_swap_full
    (void)"AO_double_fetch_compare_and_swap_full(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_full(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_full";
# endif

# if defined(AO_HAVE_test_and_set_full)
    (void)"AO_test_and_set_full(&ts):";
    (void)AO_test_and_set_full(&ts);
# else
    (void)"No AO_test_and_set_full";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_release_write(void)
{
# if defined(AO_HAVE_double_load_release_write) || defined(AO_HAVE_double_store_release_write) \
     || defined(AO_HAVE_double_fetch_and_add_release_write) \
     || defined(AO_HAVE_double_fetch_and_add1_release_write) \
     || defined(AO_HAVE_double_and_release_write) \
     || defined(AO_HAVE_double_compare_and_swap_release_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release_write)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_release_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release_write)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_release_write) \
     || defined(AO_HAVE_double_compare_and_swap_release_write) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_release_write)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_release_write)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_release_write) || defined(AO_HAVE_double_and_release_write) \
     || defined(AO_HAVE_double_or_release_write) || defined(AO_HAVE_double_xor_release_write)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_release_write)
    (void)"AO_nop_release_write(): ";
    AO_nop_release_write();
# else
    (void)"No AO_nop_release_write";
# endif

# ifdef AO_HAVE_double_load_release_write
    (void)"AO_double_load_release_write(&val):";
    (void)AO_double_load_release_write(&val);
# else
    (void)"No AO_double_load_release_write";
# endif
# ifdef AO_HAVE_double_store_release_write
    (void)"AO_double_store_release_write(&val, newval):";
    AO_double_store_release_write(&val, newval);
# else
    (void)"No AO_double_store_release_write";
# endif
# ifdef AO_HAVE_double_fetch_and_add_release_write
    (void)"AO_double_fetch_and_add_release_write(&val, incr):";
    (void)AO_double_fetch_and_add_release_write(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_release_write";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_release_write
    (void)"AO_double_fetch_and_add1_release_write(&val):";
    (void)AO_double_fetch_and_add1_release_write(&val);
# else
    (void)"No AO_double_fetch_and_add1_release_write";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_release_write
    (void)"AO_double_fetch_and_sub1_release_write(&val):";
    (void)AO_double_fetch_and_sub1_release_write(&val);
# else
    (void)"No AO_double_fetch_and_sub1_release_write";
# endif
# ifdef AO_HAVE_double_and_release_write
    (void)"AO_double_and_release_write(&val, incr):";
    AO_double_and_release_write(&val, incr);
# else
    (void)"No AO_double_and_release_write";
# endif
# ifdef AO_HAVE_double_or_release_write
    (void)"AO_double_or_release_write(&val, incr):";
    AO_double_or_release_write(&val, incr);
# else
    (void)"No AO_double_or_release_write";
# endif
# ifdef AO_HAVE_double_xor_release_write
    (void)"AO_double_xor_release_write(&val, incr):";
    AO_double_xor_release_write(&val, incr);
# else
    (void)"No AO_double_xor_release_write";
# endif
# ifdef AO_HAVE_double_compare_and_swap_release_write
    (void)"AO_double_compare_and_swap_release_write(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_release_write(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_release_write";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_release_write */
  /* TODO: Add AO_compare_and_swap_double_release_write */
# ifdef AO_HAVE_double_fetch_compare_and_swap_release_write
    (void)"AO_double_fetch_compare_and_swap_release_write(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_release_write(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_release_write";
# endif

# if defined(AO_HAVE_test_and_set_release_write)
    (void)"AO_test_and_set_release_write(&ts):";
    (void)AO_test_and_set_release_write(&ts);
# else
    (void)"No AO_test_and_set_release_write";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_acquire_read(void)
{
# if defined(AO_HAVE_double_load_acquire_read) || defined(AO_HAVE_double_store_acquire_read) \
     || defined(AO_HAVE_double_fetch_and_add_acquire_read) \
     || defined(AO_HAVE_double_fetch_and_add1_acquire_read) \
     || defined(AO_HAVE_double_and_acquire_read) \
     || defined(AO_HAVE_double_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire_read)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire_read)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_acquire_read) \
     || defined(AO_HAVE_double_compare_and_swap_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_acquire_read)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_acquire_read) || defined(AO_HAVE_double_and_acquire_read) \
     || defined(AO_HAVE_double_or_acquire_read) || defined(AO_HAVE_double_xor_acquire_read)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_acquire_read)
    (void)"AO_nop_acquire_read(): ";
    AO_nop_acquire_read();
# else
    (void)"No AO_nop_acquire_read";
# endif

# ifdef AO_HAVE_double_load_acquire_read
    (void)"AO_double_load_acquire_read(&val):";
    (void)AO_double_load_acquire_read(&val);
# else
    (void)"No AO_double_load_acquire_read";
# endif
# ifdef AO_HAVE_double_store_acquire_read
    (void)"AO_double_store_acquire_read(&val, newval):";
    AO_double_store_acquire_read(&val, newval);
# else
    (void)"No AO_double_store_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add_acquire_read
    (void)"AO_double_fetch_and_add_acquire_read(&val, incr):";
    (void)AO_double_fetch_and_add_acquire_read(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_acquire_read
    (void)"AO_double_fetch_and_add1_acquire_read(&val):";
    (void)AO_double_fetch_and_add1_acquire_read(&val);
# else
    (void)"No AO_double_fetch_and_add1_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_acquire_read
    (void)"AO_double_fetch_and_sub1_acquire_read(&val):";
    (void)AO_double_fetch_and_sub1_acquire_read(&val);
# else
    (void)"No AO_double_fetch_and_sub1_acquire_read";
# endif
# ifdef AO_HAVE_double_and_acquire_read
    (void)"AO_double_and_acquire_read(&val, incr):";
    AO_double_and_acquire_read(&val, incr);
# else
    (void)"No AO_double_and_acquire_read";
# endif
# ifdef AO_HAVE_double_or_acquire_read
    (void)"AO_double_or_acquire_read(&val, incr):";
    AO_double_or_acquire_read(&val, incr);
# else
    (void)"No AO_double_or_acquire_read";
# endif
# ifdef AO_HAVE_double_xor_acquire_read
    (void)"AO_double_xor_acquire_read(&val, incr):";
    AO_double_xor_acquire_read(&val, incr);
# else
    (void)"No AO_double_xor_acquire_read";
# endif
# ifdef AO_HAVE_double_compare_and_swap_acquire_read
    (void)"AO_double_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_acquire_read */
# ifdef AO_HAVE_double_fetch_compare_and_swap_acquire_read
    (void)"AO_double_fetch_compare_and_swap_acquire_read(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_acquire_read)
    (void)"AO_test_and_set_acquire_read(&ts):";
    (void)AO_test_and_set_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_acquire_read";
# endif
}
/*
 * Copyright (c) 2003 by Hewlett-Packard Company.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/* This generates a compilable program.  But it is really meant to be   */
/* be used only with cc -E, to inspect the expensions generated by      */
/* primitives.                                                          */

/* The result will not link or run.                                     */

#include <stdlib.h> /* for exit() */

void double_list_atomic_dd_acquire_read(void)
{
# if defined(AO_HAVE_double_load_dd_acquire_read) || defined(AO_HAVE_double_store_dd_acquire_read) \
     || defined(AO_HAVE_double_fetch_and_add_dd_acquire_read) \
     || defined(AO_HAVE_double_fetch_and_add1_dd_acquire_read) \
     || defined(AO_HAVE_double_and_dd_acquire_read) \
     || defined(AO_HAVE_double_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_dd_acquire_read)
    static volatile AO_double_t val /* = 0 */;
# endif
# if defined(AO_HAVE_double_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_dd_acquire_read)
    static AO_double_t oldval /* = 0 */;
# endif
# if defined(AO_HAVE_double_store_dd_acquire_read) \
     || defined(AO_HAVE_double_compare_and_swap_dd_acquire_read) \
     || defined(AO_HAVE_double_fetch_compare_and_swap_dd_acquire_read)
    static AO_double_t newval /* = 0 */;
# endif
# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    AO_TS_t ts = AO_TS_INITIALIZER;
# endif
# if defined(AO_HAVE_double_fetch_and_add_dd_acquire_read) || defined(AO_HAVE_double_and_dd_acquire_read) \
     || defined(AO_HAVE_double_or_dd_acquire_read) || defined(AO_HAVE_double_xor_dd_acquire_read)
    static AO_double_t incr /* = 0 */;
# endif

# if defined(AO_HAVE_nop_dd_acquire_read)
    (void)"AO_nop_dd_acquire_read(): ";
    AO_nop_dd_acquire_read();
# else
    (void)"No AO_nop_dd_acquire_read";
# endif

# ifdef AO_HAVE_double_load_dd_acquire_read
    (void)"AO_double_load_dd_acquire_read(&val):";
    (void)AO_double_load_dd_acquire_read(&val);
# else
    (void)"No AO_double_load_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_store_dd_acquire_read
    (void)"AO_double_store_dd_acquire_read(&val, newval):";
    AO_double_store_dd_acquire_read(&val, newval);
# else
    (void)"No AO_double_store_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add_dd_acquire_read
    (void)"AO_double_fetch_and_add_dd_acquire_read(&val, incr):";
    (void)AO_double_fetch_and_add_dd_acquire_read(&val, incr);
# else
    (void)"No AO_double_fetch_and_add_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_add1_dd_acquire_read
    (void)"AO_double_fetch_and_add1_dd_acquire_read(&val):";
    (void)AO_double_fetch_and_add1_dd_acquire_read(&val);
# else
    (void)"No AO_double_fetch_and_add1_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_fetch_and_sub1_dd_acquire_read
    (void)"AO_double_fetch_and_sub1_dd_acquire_read(&val):";
    (void)AO_double_fetch_and_sub1_dd_acquire_read(&val);
# else
    (void)"No AO_double_fetch_and_sub1_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_and_dd_acquire_read
    (void)"AO_double_and_dd_acquire_read(&val, incr):";
    AO_double_and_dd_acquire_read(&val, incr);
# else
    (void)"No AO_double_and_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_or_dd_acquire_read
    (void)"AO_double_or_dd_acquire_read(&val, incr):";
    AO_double_or_dd_acquire_read(&val, incr);
# else
    (void)"No AO_double_or_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_xor_dd_acquire_read
    (void)"AO_double_xor_dd_acquire_read(&val, incr):";
    AO_double_xor_dd_acquire_read(&val, incr);
# else
    (void)"No AO_double_xor_dd_acquire_read";
# endif
# ifdef AO_HAVE_double_compare_and_swap_dd_acquire_read
    (void)"AO_double_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (!AO_double_compare_and_swap_dd_acquire_read(&val, oldval, newval))
      exit(1);
# else
    (void)"No AO_double_compare_and_swap_dd_acquire_read";
# endif
  /* TODO: Add AO_compare_double_and_swap_double_dd_acquire_read */
  /* TODO: Add AO_compare_and_swap_double_dd_acquire_read */
# ifdef AO_HAVE_double_fetch_compare_and_swap_dd_acquire_read
    (void)"AO_double_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval):";
    if (AO_double_fetch_compare_and_swap_dd_acquire_read(&val, oldval, newval) != oldval)
      exit(1);
# else
    (void)"No AO_double_fetch_compare_and_swap_dd_acquire_read";
# endif

# if defined(AO_HAVE_test_and_set_dd_acquire_read)
    (void)"AO_test_and_set_dd_acquire_read(&ts):";
    (void)AO_test_and_set_dd_acquire_read(&ts);
# else
    (void)"No AO_test_and_set_dd_acquire_read";
# endif
}
