// slang-image-format-defs.h
#ifndef SLANG_FORMAT
    #error Must define SLANG_FORMAT macro before including image-format-defs.h
#endif

SLANG_FORMAT(unknown, (NONE, 0, 0))
SLANG_FORMAT(rgba32f, (FLOAT32, 4, sizeof(float) * 4))
SLANG_FORMAT(rgba16f, (FLOAT16, 4, sizeof(uint16_t) * 4))
SLANG_FORMAT(rg32f, (FLOAT32, 2, sizeof(float) * 2))
SLANG_FORMAT(rg16f, (FLOAT16, 2, sizeof(uint16_t) * 2))
SLANG_FORMAT(r11f_g11f_b10f, (NONE, 3, sizeof(uint32_t)))
SLANG_FORMAT(r32f, (FLOAT32, 1, sizeof(float)))
SLANG_FORMAT(r16f, (FLOAT16, 1, sizeof(uint16_t)))
SLANG_FORMAT(rgba16, (UINT16, 4, sizeof(uint16_t) * 4))
SLANG_FORMAT(rgb10_a2, (NONE, 4, sizeof(uint32_t)))
SLANG_FORMAT(rgba8, (UINT8, 4, sizeof(uint32_t)))
SLANG_FORMAT(rg16, (UINT16, 2, sizeof(uint16_t) * 2))
SLANG_FORMAT(rg8, (UINT8, 2, sizeof(char) * 2))
SLANG_FORMAT(r16, (UINT16, 1, sizeof(uint16_t)))
SLANG_FORMAT(r8, (UINT8, 1, sizeof(uint8_t)))
SLANG_FORMAT(rgba16_snorm, (UINT16, 4, sizeof(uint16_t) * 4))
SLANG_FORMAT(rgba8_snorm, (UINT8, 4, sizeof(uint8_t) * 4))
SLANG_FORMAT(rg16_snorm, (UINT16, 2, sizeof(uint16_t) * 2))
SLANG_FORMAT(rg8_snorm, (UINT8, 2, sizeof(uint8_t) * 2))
SLANG_FORMAT(r16_snorm, (UINT16, 1, sizeof(uint16_t)))
SLANG_FORMAT(r8_snorm, (UINT8, 1, sizeof(uint8_t)))
SLANG_FORMAT(rgba32i, (INT32, 4, sizeof(int32_t) * 4))
SLANG_FORMAT(rgba16i, (INT16, 4, sizeof(int16_t) * 4))
SLANG_FORMAT(rgba8i, (INT8, 4, sizeof(int8_t) * 4))
SLANG_FORMAT(rg32i, (INT32, 2, sizeof(int32_t) * 2))
SLANG_FORMAT(rg16i, (INT16, 2, sizeof(int16_t) * 2))
SLANG_FORMAT(rg8i, (INT8, 2, sizeof(int8_t) * 2))
SLANG_FORMAT(r32i, (INT32, 1, sizeof(int32_t)))
SLANG_FORMAT(r16i, (INT16, 1, sizeof(int16_t)))
SLANG_FORMAT(r8i, (INT8, 1, sizeof(int8_t)))
SLANG_FORMAT(rgba32ui, (UINT32, 4, sizeof(uint32_t) * 4))
SLANG_FORMAT(rgba16ui, (UINT16, 4, sizeof(uint16_t) * 4))
SLANG_FORMAT(rgb10_a2ui, (NONE, 4, sizeof(uint32_t)))
SLANG_FORMAT(rgba8ui, (UINT8, 4, sizeof(uint8_t) * 4))
SLANG_FORMAT(rg32ui, (UINT32, 2, sizeof(uint32_t) * 2))
SLANG_FORMAT(rg16ui, (UINT16, 2, sizeof(uint16_t) * 2))
SLANG_FORMAT(rg8ui, (UINT8, 2, sizeof(uint8_t) * 2))
SLANG_FORMAT(r32ui, (UINT32, 1, sizeof(uint32_t)))
SLANG_FORMAT(r16ui, (UINT16, 1, sizeof(uint16_t)))
SLANG_FORMAT(r8ui, (UINT8, 1, sizeof(uint8_t)))
SLANG_FORMAT(r64ui, (UINT64, 1, sizeof(uint64_t)))
SLANG_FORMAT(r64i, (INT64, 1, sizeof(int64_t)))
SLANG_FORMAT(bgra8, (UINT8, 4, sizeof(uint32_t)))

#undef SLANG_FORMAT
