/*
This source is published under the following 3-clause BSD license.

Copyright (c) 2012 - 2013, Lukas Hosek and Alexander Wilkie
All rights reserved.

Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * None of the names of the contributors may be used to endorse or promote 
      products derived from this software without specific prior written 
      permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/* ============================================================================

This file is part of a sample implementation of the analytical skylight and
solar radiance models presented in the SIGGRAPH 2012 paper


           "An Analytic Model for Full Spectral Sky-Dome Radiance"

and the 2013 IEEE CG&A paper

       "Adding a Solar Radiance Function to the Hosek Skylight Model"

                                   both by 

                       Lukas Hosek and Alexander Wilkie
                Charles University in Prague, Czech Republic


                        Version: 1.4a, February 22nd, 2013
                        
Version history:

1.4a  February 22nd, 2013
      Removed unnecessary and counter-intuitive solar radius parameters 
      from the interface of the colourspace sky dome initialisation functions.

1.4   February 11th, 2013
      Fixed a bug which caused the relative brightness of the solar disc
      and the sky dome to be off by a factor of about 6. The sun was too 
      bright: this affected both normal and alien sun scenarios. The 
      coefficients of the solar radiance function were changed to fix this.

1.3   January 21st, 2013 (not released to the public)
      Added support for solar discs that are not exactly the same size as
      the terrestrial sun. Also added support for suns with a different
      emission spectrum ("Alien World" functionality).

1.2a  December 18th, 2012
      Fixed a mistake and some inaccuracies in the solar radiance function
      explanations found in ArHosekSkyModel.h. The actual source code is
      unchanged compared to version 1.2.

1.2   December 17th, 2012
      Native RGB data and a solar radiance function that matches the turbidity
      conditions were added.

1.1   September 2012
      The coefficients of the spectral model are now scaled so that the output
      is given in physical units: W / (m^-2 * sr * nm). Also, the output of the
      XYZ model is now no longer scaled to the range [0...1]. Instead, it is
      the result of a simple conversion from spectral data via the CIE 2 degree
      standard observer matching functions. Therefore, after multiplication
      with 683 lm / W, the Y channel now corresponds to luminance in lm.
     
1.0   May 11th, 2012
      Initial release.


Please visit http://cgg.mff.cuni.cz/projects/SkylightModelling/ to check if
an updated version of this code has been published!

============================================================================ */


/*

This file contains the coefficient data for the RGB colour space version of 
the model.

*/

// uses Aug 23 dataset

double datasetRGB1[] = 
{
	// albedo 0, turbidity 1
	-1.099459e+000,
	-1.335146e-001,
	-4.083223e+000,
	5.919603e+000,
	-1.104166e-001,
	1.600158e+000,
	-1.326538e-006,
	4.917807e+000,
	5.127716e-001,
	-1.169858e+000,
	-1.832793e-001,
	9.694744e-001,
	9.495762e-002,
	-4.738918e-002,
	2.194171e-001,
	1.095749e-001,
	3.603604e+000,
	3.815119e-001,
	-9.665225e-001,
	-1.403888e-001,
	5.194457e+000,
	-1.107607e+000,
	-8.135181e-001,
	4.969661e+000,
	-2.300508e-001,
	-2.489350e+000,
	1.279158e+000,
	-1.292508e+000,
	-1.299552e-001,
	-2.071404e+000,
	-4.752482e-002,
	1.215598e+000,
	-1.904179e+000,
	3.027985e-001,
	8.707768e+000,
	6.332446e-002,
	-9.264666e-001,
	-1.696780e-001,
	4.574070e+000,
	-4.232936e-001,
	-7.575833e+000,
	5.079755e+000,
	-2.576343e-001,
	-4.506805e+000,
	6.908129e-001,
	-1.139072e+000,
	-1.796056e-001,
	1.923311e+000,
	6.788529e+000,
	-2.364389e+000,
	-1.064041e+000,
	1.717010e-001,
	1.534681e+000,
	5.015810e-001,
	// albedo 0, turbidity 2
	-1.107257e+000,
	-1.384411e-001,
	-4.285744e+000,
	5.713157e+000,
	-1.015992e-001,
	1.372638e+000,
	6.555893e-002,
	5.127514e+000,
	6.550471e-001,
	-1.187337e+000,
	-1.969013e-001,
	8.551048e-001,
	5.289708e-002,
	-7.626406e-002,
	1.733153e-002,
	1.779454e-001,
	3.801038e+000,
	4.742709e-001,
	-9.685321e-001,
	-1.553308e-001,
	4.732492e+000,
	-1.178935e+000,
	-7.852791e-001,
	4.604492e+000,
	-2.666518e-001,
	-2.367663e+000,
	1.177527e+000,
	-1.252817e+000,
	-5.129949e-002,
	-2.800433e+000,
	-1.295992e-002,
	1.308964e+000,
	-2.204331e+000,
	7.276011e-001,
	8.699265e+000,
	1.188388e-001,
	-9.459509e-001,
	-2.322133e-001,
	4.375041e+000,
	-1.712018e-001,
	-7.451681e+000,
	5.078019e+000,
	-4.223538e-001,
	-4.595561e+000,
	1.074719e+000,
	-1.125092e+000,
	-1.796750e-001,
	1.626399e+000,
	6.989743e+000,
	-2.406382e+000,
	-9.060383e-001,
	2.961611e-001,
	1.337715e+000,
	5.438140e-001,
	// albedo 0, turbidity 3
	-1.135338e+000,
	-1.716160e-001,
	-1.499253e+000,
	2.373491e+000,
	-1.654023e-001,
	9.566404e-001,
	1.113453e-001,
	4.528473e+000,
	6.579439e-001,
	-1.132780e+000,
	-1.456214e-001,
	-1.736672e+000,
	1.756589e+000,
	-1.087003e-001,
	3.757927e-001,
	2.525070e-001,
	7.178513e+000,
	5.003814e-001,
	-1.167176e+000,
	-2.927225e-001,
	5.727667e+000,
	-3.139244e+000,
	-6.425204e-001,
	2.822634e+000,
	-1.457812e-001,
	-6.787080e+000,
	1.017072e+000,
	-1.042529e+000,
	4.110823e-002,
	-4.000629e+000,
	4.362364e+000,
	1.090540e+000,
	-1.338674e+000,
	8.246964e-001,
	1.095249e+001,
	2.912211e-001,
	-1.061598e+000,
	-2.096143e-001,
	3.803155e+000,
	-7.977069e+000,
	-3.637880e+000,
	3.707671e+000,
	-1.903128e-001,
	-3.397953e+000,
	9.971500e-001,
	-1.073560e+000,
	-2.077964e-001,
	1.492052e+000,
	1.626322e+001,
	-5.015304e+000,
	-4.059889e-001,
	2.659782e-001,
	6.395380e-001,
	5.634436e-001,
	// albedo 0, turbidity 4
	-1.172794e+000,
	-2.111186e-001,
	-1.360013e+000,
	1.604080e+000,
	-8.473723e-002,
	7.217312e-001,
	1.548030e-001,
	4.257010e+000,
	6.328974e-001,
	-1.238374e+000,
	-2.670827e-001,
	3.247678e-001,
	5.466311e-001,
	-7.425952e-001,
	5.276440e-001,
	2.678026e-002,
	5.484169e+000,
	6.814734e-001,
	-1.176923e+000,
	-2.574586e-001,
	2.304045e+000,
	-2.797678e+000,
	1.464405e+000,
	1.998552e+000,
	2.550559e-001,
	-4.199772e+000,
	7.544892e-001,
	-1.003284e+000,
	1.943984e-002,
	-2.145066e+000,
	1.030924e+001,
	-1.525413e+001,
	-2.023010e+000,
	5.448699e-001,
	8.159497e+000,
	5.539148e-001,
	-1.060017e+000,
	-2.037206e-001,
	2.483018e+000,
	-4.595459e+000,
	6.526991e+000,
	4.031804e+000,
	1.206513e-001,
	-2.586527e+000,
	7.875752e-001,
	-1.081141e+000,
	-2.123302e-001,
	1.092275e+000,
	2.683841e+000,
	-4.166938e+000,
	-1.396582e+000,
	4.371205e-001,
	1.030233e+000,
	6.664862e-001,
	// albedo 0, turbidity 5
	-1.222392e+000,
	-2.651924e-001,
	-4.625037e-001,
	3.521964e-001,
	2.148855e-002,
	5.078494e-001,
	1.791590e-001,
	3.852516e+000,
	5.998216e-001,
	-1.424610e+000,
	-4.710155e-001,
	-1.826815e-001,
	1.786277e+000,
	-1.952442e+000,
	5.277612e-001,
	-1.773629e-002,
	2.415874e+000,
	6.701272e-001,
	-1.130655e+000,
	-1.358609e-001,
	9.171203e-001,
	-4.660394e+000,
	6.251162e+000,
	1.904529e+000,
	2.639668e-001,
	1.856130e+000,
	8.228440e-001,
	-9.739015e-001,
	-6.674749e-002,
	-4.768897e-001,
	1.248589e+001,
	-1.994688e+001,
	-2.353043e+000,
	5.885575e-001,
	1.287251e+000,
	4.830135e-001,
	-1.082178e+000,
	-1.974495e-001,
	1.050245e+000,
	-4.792855e+000,
	8.663406e+000,
	3.246969e+000,
	1.556731e-001,
	8.117442e-001,
	8.050376e-001,
	-1.063354e+000,
	-1.727108e-001,
	9.681592e-001,
	2.736077e+000,
	-4.969269e+000,
	-8.360570e-001,
	5.994612e-001,
	1.024039e+000,
	6.786935e-001,
	// albedo 0, turbidity 6
	-1.261936e+000,
	-3.053676e-001,
	-4.262222e-001,
	4.000196e-001,
	-2.059388e-002,
	4.721802e-001,
	1.480028e-001,
	3.505343e+000,
	6.121337e-001,
	-1.681088e+000,
	-6.971919e-001,
	-1.105652e-001,
	7.437426e-001,
	-6.594399e-001,
	2.254221e-001,
	8.710195e-002,
	1.263913e+000,
	5.681865e-001,
	-9.453001e-001,
	3.460388e-002,
	6.067038e-001,
	-1.985128e+000,
	3.457236e+000,
	2.655483e+000,
	-1.162354e-002,
	3.304716e+000,
	1.001950e+000,
	-1.086609e+000,
	-2.029011e-001,
	-6.399170e-001,
	6.926885e+000,
	-1.512189e+001,
	-3.793051e+000,
	9.456120e-001,
	2.222222e-001,
	2.893725e-001,
	-1.041259e+000,
	-1.388790e-001,
	1.147331e+000,
	6.282086e+000,
	3.679836e+000,
	4.398314e+000,
	-1.355232e-001,
	1.031134e+000,
	9.273509e-001,
	-1.063473e+000,
	-1.916051e-001,
	6.556979e-001,
	-3.371891e-003,
	-3.699664e+000,
	-1.926783e+000,
	7.371154e-001,
	1.179975e+000,
	6.367068e-001,
	// albedo 0, turbidity 7
	-1.336390e+000,
	-3.778927e-001,
	-7.259477e-001,
	2.270247e-001,
	4.627513e-001,
	1.366459e-001,
	2.637347e-001,
	3.292059e+000,
	4.998211e-001,
	-2.119878e+000,
	-1.055472e+000,
	5.422052e-001,
	7.826648e-001,
	-1.286065e+000,
	9.517905e-001,
	-1.432358e-001,
	-2.379816e-001,
	5.910513e-001,
	-7.761432e-001,
	2.124336e-001,
	-6.845184e-001,
	-9.812342e-001,
	4.347257e+000,
	9.671980e-001,
	3.773150e-001,
	5.789529e+000,
	9.646598e-001,
	-1.118734e+000,
	-3.513815e-001,
	5.500918e-001,
	9.449627e-001,
	-1.262070e+001,
	-1.825280e+000,
	4.731260e-001,
	-3.326892e+000,
	3.568768e-001,
	-1.026437e+000,
	-8.257946e-002,
	3.221701e-001,
	1.198372e+001,
	1.555130e+000,
	2.560304e+000,
	1.406465e-001,
	2.912858e+000,
	8.643181e-001,
	-1.069949e+000,
	-2.029607e-001,
	5.825042e-001,
	-2.398595e-003,
	-3.278335e+000,
	-1.349882e+000,
	7.208433e-001,
	8.505164e-001,
	6.625391e-001,
	// albedo 0, turbidity 8
	-1.392309e+000,
	-4.454945e-001,
	-5.664000e-001,
	6.283393e-001,
	-3.761727e-001,
	6.949802e-001,
	7.748178e-002,
	3.192797e+000,
	5.968661e-001,
	-2.713405e+000,
	-1.395112e+000,
	2.029230e-001,
	1.877272e-001,
	-3.715859e-001,
	-1.652929e-001,
	2.385861e-001,
	-4.150768e-001,
	1.375467e-001,
	-9.588644e-001,
	2.433900e-002,
	-1.527493e+000,
	-9.632874e-001,
	5.496269e+000,
	1.094931e+000,
	2.004044e-001,
	6.084554e+000,
	1.369604e+000,
	-8.028546e-001,
	-2.473563e-001,
	1.617898e+000,
	2.073591e+000,
	-1.149446e+001,
	-8.394131e-001,
	2.726847e-001,
	-4.634538e+000,
	1.367293e-001,
	-1.198326e+000,
	-1.804865e-001,
	-3.565414e-001,
	4.073200e+000,
	1.662086e+000,
	1.239770e+000,
	3.367978e-001,
	2.997402e+000,
	9.360383e-001,
	-1.013531e+000,
	-1.859060e-001,
	5.799857e-001,
	1.331883e+001,
	-4.346873e+000,
	-1.113820e+000,
	5.275714e-001,
	8.045177e-001,
	6.496373e-001,
	// albedo 0, turbidity 9
	-1.530103e+000,
	-6.107468e-001,
	-3.841771e-001,
	1.881508e+000,
	-1.464807e+000,
	6.654690e-001,
	-5.950797e-006,
	2.738912e+000,
	8.101012e-001,
	-2.415469e+000,
	-1.057499e+000,
	-4.161968e-001,
	-2.357548e+000,
	6.300296e-001,
	6.224915e-001,
	1.545048e-002,
	2.038561e+000,
	-1.339415e-001,
	-3.096796e+000,
	-1.465688e+000,
	-1.199232e+000,
	4.567061e+000,
	3.260980e+000,
	-9.794907e-001,
	8.950491e-001,
	2.049235e+000,
	1.331015e+000,
	2.713904e-001,
	2.852852e-001,
	1.202090e+000,
	-8.206784e+000,
	-5.805762e+000,
	1.804431e+000,
	-6.090648e-001,
	-1.990902e+000,
	3.288858e-001,
	-1.456580e+000,
	-3.455960e-001,
	-6.409257e-002,
	1.667697e+001,
	-2.311094e+000,
	-9.771104e-001,
	6.759863e-001,
	1.245136e+000,
	7.911932e-001,
	-9.860389e-001,
	-2.099564e-001,
	2.946650e-001,
	-3.547800e-003,
	-2.268313e+000,
	-6.205647e-002,
	4.705185e-001,
	8.657995e-001,
	6.856284e-001,
	// albedo 0, turbidity 10
	-1.971736e+000,
	-9.414047e-001,
	-3.400557e-001,
	1.468763e+000,
	-1.474284e+000,
	5.501062e-001,
	-1.109750e-005,
	2.356370e+000,
	9.001702e-001,
	-1.589845e+000,
	-7.797079e-001,
	-5.582240e-001,
	-8.137376e-001,
	5.846617e-001,
	1.129459e-001,
	-2.658005e-002,
	2.707248e+000,
	-2.112486e-001,
	-6.940173e+000,
	-2.823963e+000,
	-1.620848e+000,
	1.090696e+000,
	2.391730e+000,
	1.370047e+000,
	5.890462e-001,
	1.728400e+000,
	1.331253e+000,
	1.293144e+000,
	-1.919778e-003,
	1.644206e+000,
	-8.666967e-001,
	-7.161953e+000,
	-1.385018e+000,
	-1.505374e-001,
	-1.388643e+000,
	2.530122e-001,
	-1.488880e+000,
	-2.495496e-001,
	-2.377137e-001,
	1.167714e+001,
	-8.617124e-001,
	1.053828e+000,
	1.992744e-001,
	3.633564e-001,
	8.553304e-001,
	-1.060891e+000,
	-4.035829e-001,
	2.823207e-001,
	-2.369798e-003,
	-1.876577e+000,
	-5.950265e-001,
	4.241017e-001,
	3.140802e-001,
	6.631669e-001,
	// albedo 1, turbidity 1
	-1.101204e+000,
	-1.351353e-001,
	-4.030882e+000,
	6.096353e+000,
	-1.148599e-001,
	1.606507e+000,
	-1.555474e-006,
	4.436084e+000,
	5.973715e-001,
	-1.154597e+000,
	-1.923378e-001,
	8.512132e-001,
	2.934895e-001,
	-6.522777e-002,
	1.389077e-001,
	9.091469e-002,
	3.133307e+000,
	2.108541e-001,
	-1.031588e+000,
	-1.546804e-001,
	5.266214e+000,
	-9.491390e-001,
	-7.184867e-001,
	4.875626e+000,
	-1.911907e-001,
	-2.865642e+000,
	1.087895e+000,
	-1.159454e+000,
	-9.546699e-002,
	-1.508146e+000,
	-2.031411e-002,
	1.040653e+000,
	-2.333508e+000,
	2.540592e-001,
	8.594981e+000,
	9.316770e-002,
	-1.035940e+000,
	-2.021151e-001,
	4.719343e+000,
	-9.019318e-001,
	-7.858046e+000,
	3.901234e+000,
	-2.233137e-001,
	-4.344739e+000,
	6.550733e-001,
	-1.096669e+000,
	-1.558196e-001,
	2.057553e+000,
	6.274495e+000,
	-2.678352e+000,
	-1.814927e+000,
	1.550676e-001,
	1.903276e+000,
	4.998989e-001,
	// albedo 1, turbidity 2
	-1.114209e+000,
	-1.473531e-001,
	-7.602914e+000,
	8.973685e+000,
	-4.980074e-002,
	1.289198e+000,
	8.366906e-002,
	4.557987e+000,
	6.118757e-001,
	-1.149397e+000,
	-1.981628e-001,
	4.914096e+000,
	-3.498986e+000,
	-6.257090e-002,
	1.667401e-001,
	1.048980e-001,
	2.284689e+000,
	5.935965e-001,
	-1.056121e+000,
	-1.456172e-001,
	4.272656e-001,
	2.912649e+000,
	-5.501745e-001,
	4.406542e+000,
	-1.387680e-001,
	1.245555e+000,
	9.733011e-001,
	-1.125047e+000,
	-4.003662e-002,
	1.058457e+000,
	-3.462236e+000,
	4.395278e-001,
	-2.395805e+000,
	5.177589e-001,
	4.866247e+000,
	4.253189e-001,
	-1.051444e+000,
	-2.804541e-001,
	3.364668e+000,
	3.293787e+000,
	-1.015741e+001,
	3.807407e+000,
	-3.592377e-001,
	-3.367415e+000,
	7.900825e-001,
	-1.093847e+000,
	-1.436965e-001,
	2.384780e+000,
	5.787070e+000,
	-2.445987e+000,
	-1.311171e+000,
	2.326563e-001,
	1.158439e+000,
	5.555416e-001,
	// albedo 1, turbidity 3
	-1.134824e+000,
	-1.680468e-001,
	-3.325620e+000,
	4.458596e+000,
	-1.135063e-001,
	1.104500e+000,
	7.794544e-002,
	4.609952e+000,
	6.854854e-001,
	-1.143017e+000,
	-1.565926e-001,
	3.014687e-001,
	-1.763027e-001,
	-3.557925e-002,
	-2.342406e-001,
	2.528705e-001,
	5.884085e+000,
	4.750602e-001,
	-1.136801e+000,
	-2.907502e-001,
	3.682423e+000,
	-4.061202e-001,
	-8.728159e-001,
	4.001510e+000,
	-1.522202e-001,
	-5.528713e+000,
	1.044847e+000,
	-1.063652e+000,
	7.808107e-002,
	-1.983678e+000,
	3.648078e-001,
	2.102276e+000,
	-3.065050e+000,
	8.431951e-001,
	1.038830e+001,
	2.662834e-001,
	-1.061015e+000,
	-2.859814e-001,
	4.223615e+000,
	-2.290138e+000,
	-8.314010e+000,
	4.405718e+000,
	-4.613627e-001,
	-4.502910e+000,
	1.008383e+000,
	-1.106302e+000,
	-1.697123e-001,
	2.087196e+000,
	8.238929e+000,
	-2.992416e+000,
	-1.821776e+000,
	3.434859e-001,
	7.755179e-001,
	5.341190e-001,
	// albedo 1, turbidity 4
	-1.171110e+000,
	-2.106304e-001,
	-1.614361e+000,
	2.378103e+000,
	-1.625969e-001,
	8.504483e-001,
	1.059312e-001,
	4.046256e+000,
	6.618227e-001,
	-1.200480e+000,
	-2.235733e-001,
	1.014390e+000,
	-1.174074e+000,
	-4.440180e-001,
	2.262406e-001,
	1.665868e-001,
	5.461829e+000,
	5.676310e-001,
	-1.223587e+000,
	-3.502622e-001,
	1.699106e+000,
	6.724266e-001,
	1.268567e+000,
	2.135102e+000,
	8.039374e-004,
	-5.221111e+000,
	9.445690e-001,
	-9.452673e-001,
	1.468459e-001,
	-1.335034e+000,
	4.346628e+000,
	-1.285652e+001,
	-1.807046e+000,
	8.175243e-001,
	9.301065e+000,
	3.656798e-001,
	-1.134681e+000,
	-3.310951e-001,
	3.571244e+000,
	-2.208948e+000,
	6.041580e+000,
	3.107577e+000,
	-3.112127e-001,
	-4.186351e+000,
	9.188333e-001,
	-1.083237e+000,
	-1.831394e-001,
	2.062654e+000,
	1.385424e+000,
	-5.004950e+000,
	-1.332669e+000,
	3.627352e-001,
	3.323150e-001,
	6.191181e-001,
	// albedo 1, turbidity 5
	-1.211527e+000,
	-2.590617e-001,
	-1.660874e-001,
	3.627905e-001,
	-1.039258e-001,
	4.697924e-001,
	1.671653e-001,
	3.507497e+000,
	6.022506e-001,
	-1.433017e+000,
	-4.733592e-001,
	1.724445e-001,
	9.953236e-001,
	-1.874457e+000,
	4.432099e-001,
	1.715810e-002,
	2.339272e+000,
	6.441470e-001,
	-1.084920e+000,
	-1.587903e-001,
	8.999585e-001,
	-2.537516e+000,
	5.877859e+000,
	2.014554e+000,
	9.689141e-002,
	3.177242e-001,
	9.030399e-001,
	-1.008242e+000,
	2.793030e-003,
	-3.507469e-001,
	1.028300e+001,
	-2.080454e+001,
	-2.781026e+000,
	8.995090e-001,
	3.366951e+000,
	3.473867e-001,
	-1.103151e+000,
	-2.799598e-001,
	2.525791e+000,
	-4.255704e+000,
	9.903388e+000,
	3.722668e+000,
	-3.603941e-001,
	-1.303292e+000,
	9.369454e-001,
	-1.102235e+000,
	-2.025061e-001,
	2.085660e+000,
	1.686787e+000,
	-5.010957e+000,
	-1.656458e+000,
	4.584029e-001,
	-2.751759e-001,
	6.184162e-001,
	// albedo 1, turbidity 6
	-1.256130e+000,
	-3.104904e-001,
	1.639350e-001,
	1.315502e-001,
	-7.297583e-001,
	4.778480e-001,
	1.259265e-001,
	3.012108e+000,
	6.202728e-001,
	-1.620114e+000,
	-6.552670e-001,
	-2.877157e-001,
	1.094371e+000,
	2.818914e-001,
	3.696830e-001,
	9.428521e-002,
	1.450951e+000,
	5.681308e-001,
	-9.686204e-001,
	-3.755647e-002,
	1.469980e+000,
	-3.103414e+000,
	2.856583e+000,
	1.883209e+000,
	-5.746099e-002,
	1.286383e+000,
	1.001751e+000,
	-1.089377e+000,
	-1.023062e-001,
	-1.498891e+000,
	1.066455e+001,
	-1.720184e+001,
	-2.759314e+000,
	1.061258e+000,
	2.910211e+000,
	2.624701e-001,
	-1.044681e+000,
	-2.156857e-001,
	3.230136e+000,
	-5.863862e-001,
	6.096640e+000,
	3.550019e+000,
	-4.255773e-001,
	-1.500033e+000,
	9.687696e-001,
	-1.133658e+000,
	-2.505101e-001,
	1.717840e+000,
	8.480428e-003,
	-5.011789e+000,
	-1.740989e+000,
	4.983430e-001,
	-2.081829e-001,
	6.088641e-001,
	// albedo 1, turbidity 7
	-1.335366e+000,
	-3.863319e-001,
	-5.279971e-001,
	3.638324e-001,
	3.230699e-001,
	8.339707e-002,
	2.483293e-001,
	2.678646e+000,
	4.998346e-001,
	-2.004511e+000,
	-9.957121e-001,
	1.250807e+000,
	1.625025e-002,
	-3.410754e-001,
	7.858244e-001,
	-9.506757e-002,
	2.651876e-002,
	5.788643e-001,
	-8.714157e-001,
	1.192051e-001,
	-8.486879e-001,
	-3.702497e-001,
	1.818277e+000,
	1.103427e+000,
	2.454866e-001,
	3.841575e+000,
	9.847350e-001,
	-1.042618e+000,
	-2.285793e-001,
	3.620175e-001,
	2.983368e+000,
	-9.776844e+000,
	-1.971587e+000,
	6.691674e-001,
	-7.901947e-001,
	3.213200e-001,
	-1.099112e+000,
	-1.869868e-001,
	2.044065e+000,
	2.062964e+000,
	1.265668e+000,
	2.710130e+000,
	-1.099443e-001,
	2.179353e-001,
	9.024108e-001,
	-1.106985e+000,
	-2.396881e-001,
	1.809807e+000,
	8.523319e+000,
	-5.011788e+000,
	-1.590086e+000,
	3.248449e-001,
	-1.003187e-001,
	6.550606e-001,
	// albedo 1, turbidity 8
	-1.421285e+000,
	-4.767024e-001,
	-3.885004e-001,
	8.274590e-001,
	-3.644229e-001,
	6.999513e-001,
	5.196710e-002,
	2.578431e+000,
	6.246310e-001,
	-2.611217e+000,
	-1.398846e+000,
	4.527425e-001,
	-5.932142e-001,
	2.224617e-001,
	-5.593581e-001,
	3.389633e-001,
	-7.767112e-001,
	6.536004e-002,
	-9.881543e-001,
	4.684782e-002,
	-8.616613e-001,
	8.799807e-001,
	4.003130e+000,
	1.739543e+000,
	-8.098378e-002,
	5.524802e+000,
	1.499673e+000,
	-7.544759e-001,
	-2.314808e-001,
	8.125770e-001,
	-7.724135e-001,
	-9.577645e+000,
	-1.629433e+000,
	6.790832e-001,
	-4.193895e+000,
	-2.526624e-002,
	-1.273719e+000,
	-2.187030e-001,
	1.401798e+000,
	5.231832e+000,
	7.405093e-001,
	1.775166e+000,
	-7.269476e-002,
	1.996087e+000,
	1.057450e+000,
	-1.046864e+000,
	-2.247559e-001,
	1.679449e+000,
	1.140057e+001,
	-4.948829e+000,
	-1.182664e+000,
	3.241038e-001,
	-2.470012e-001,
	6.115900e-001,
	// albedo 1, turbidity 9
	-1.514607e+000,
	-5.985430e-001,
	-1.877610e-001,
	1.756930e+000,
	-1.314206e+000,
	6.115810e-001,
	-5.970460e-006,
	2.412975e+000,
	8.124304e-001,
	-2.308414e+000,
	-1.083797e+000,
	-1.179959e-001,
	-1.728246e+000,
	7.784742e-001,
	5.494505e-001,
	6.203168e-003,
	9.326251e-001,
	-1.419518e-001,
	-3.230837e+000,
	-1.438670e+000,
	-9.868286e-001,
	2.974393e+000,
	1.949339e+000,
	-6.337857e-001,
	8.160271e-001,
	3.278606e+000,
	1.354373e+000,
	5.149378e-001,
	2.754789e-001,
	1.040965e+000,
	-4.501186e+000,
	-3.399057e+000,
	9.661861e-001,
	-4.736173e-001,
	-4.037574e+000,
	2.794847e-001,
	-1.621870e+000,
	-3.192763e-001,
	8.786242e-001,
	9.785565e+000,
	-2.727652e+000,
	1.903691e-002,
	5.521261e-001,
	2.138764e+000,
	8.419871e-001,
	-9.951701e-001,
	-2.550607e-001,
	1.498952e+000,
	-2.737197e-003,
	-3.101832e+000,
	-5.921329e-001,
	2.864422e-001,
	-4.405218e-001,
	6.631410e-001,
	// albedo 1, turbidity 10
	-1.902954e+000,
	-9.056918e-001,
	-2.069570e-001,
	1.191499e+000,
	-1.092577e+000,
	5.849556e-001,
	-9.649602e-006,
	2.048407e+000,
	9.001527e-001,
	-1.271627e+000,
	-7.193923e-001,
	-1.136606e-002,
	-1.167951e-001,
	3.286175e-003,
	-5.262827e-002,
	-2.473874e-002,
	1.716125e+000,
	-2.187133e-001,
	-7.647175e+000,
	-3.114129e+000,
	-1.490128e+000,
	-5.266488e-001,
	3.063090e+000,
	1.474262e+000,
	5.481458e-001,
	2.052174e+000,
	1.353089e+000,
	2.191403e+000,
	3.421120e-001,
	1.446510e+000,
	2.170943e+000,
	-7.768187e+000,
	-1.471207e+000,
	-1.456708e-001,
	-1.753574e+000,
	2.310576e-001,
	-1.932296e+000,
	-3.814739e-001,
	6.245422e-001,
	6.748294e+000,
	-3.060171e-001,
	1.067747e+000,
	2.500671e-001,
	-1.252596e-001,
	8.614611e-001,
	-9.471101e-001,
	-4.052640e-001,
	1.300174e+000,
	-3.951536e-003,
	-1.908284e+000,
	-5.385721e-001,
	2.133578e-001,
	-6.250292e-001,
	6.658012e-001,
};

double datasetRGBRad1[] = 
{
	// albedo 0, turbidity 1
	1.962684e+000,
	1.159831e+000,
	4.450588e+000,
	5.079633e+000,
	4.437388e+000,
	4.324573e+000,
	// albedo 0, turbidity 2
	1.946487e+000,
	1.287515e+000,
	3.703696e+000,
	8.782833e+000,
	3.440437e+000,
	5.160333e+000,
	// albedo 0, turbidity 3
	1.882170e+000,
	1.335878e+000,
	2.648641e+000,
	1.358368e+001,
	3.105473e+000,
	5.907387e+000,
	// albedo 0, turbidity 4
	1.738159e+000,
	1.624289e+000,
	-8.786695e-003,
	2.118253e+001,
	2.770255e+000,
	7.055672e+000,
	// albedo 0, turbidity 5
	1.571896e+000,
	2.301786e+000,
	-4.028545e+000,
	2.966806e+001,
	1.630876e+000,
	8.711031e+000,
	// albedo 0, turbidity 6
	1.475048e+000,
	2.679086e+000,
	-6.311315e+000,
	3.377896e+001,
	2.140975e+000,
	9.385283e+000,
	// albedo 0, turbidity 7
	1.326174e+000,
	3.378759e+000,
	-9.831444e+000,
	3.942061e+001,
	2.852702e+000,
	1.082542e+001,
	// albedo 0, turbidity 8
	1.153344e+000,
	3.967771e+000,
	-1.265181e+001,
	4.195016e+001,
	7.468239e+000,
	1.221350e+001,
	// albedo 0, turbidity 9
	9.746081e-001,
	4.051626e+000,
	-1.298454e+001,
	3.754964e+001,
	1.749232e+001,
	1.420619e+001,
	// albedo 0, turbidity 10
	8.448016e-001,
	3.181809e+000,
	-8.757338e+000,
	2.197962e+001,
	3.524033e+001,
	1.639549e+001,
	// albedo 1, turbidity 1
	2.029623e+000,
	1.364434e+000,
	4.201529e+000,
	5.415099e+000,
	9.825839e+000,
	1.063328e+001,
	// albedo 1, turbidity 2
	2.023126e+000,
	1.494728e+000,
	3.420413e+000,
	9.072178e+000,
	9.205157e+000,
	1.186639e+001,
	// albedo 1, turbidity 3
	1.956307e+000,
	1.648665e+000,
	2.039712e+000,
	1.430239e+001,
	9.039526e+000,
	1.330453e+001,
	// albedo 1, turbidity 4
	1.825053e+000,
	1.985022e+000,
	-8.036307e-001,
	2.202493e+001,
	9.415361e+000,
	1.517659e+001,
	// albedo 1, turbidity 5
	1.650367e+000,
	2.593201e+000,
	-4.469328e+000,
	2.969817e+001,
	9.410977e+000,
	1.744850e+001,
	// albedo 1, turbidity 6
	1.555202e+000,
	2.962925e+000,
	-6.608170e+000,
	3.329887e+001,
	1.064559e+001,
	1.850816e+001,
	// albedo 1, turbidity 7
	1.412478e+000,
	3.439403e+000,
	-9.196616e+000,
	3.685077e+001,
	1.345341e+001,
	2.003128e+001,
	// albedo 1, turbidity 8
	1.252990e+000,
	3.820805e+000,
	-1.115338e+001,
	3.721593e+001,
	2.014916e+001,
	2.182320e+001,
	// albedo 1, turbidity 9
	1.091952e+000,
	3.663027e+000,
	-1.031330e+001,
	2.978985e+001,
	3.296835e+001,
	2.375450e+001,
	// albedo 1, turbidity 10
	9.501691e-001,
	2.664579e+000,
	-5.545167e+000,
	1.281159e+001,
	5.154768e+001,
	2.574284e+001,
};

double datasetRGB2[] = 
{
	// albedo 0, turbidity 1
	-1.140530e+000,
	-1.982747e-001,
	-7.512730e+000,
	8.403899e+000,
	-5.699038e-002,
	9.015907e-001,
	3.392161e-002,
	4.772522e+000,
	5.111184e-001,
	-1.165117e+000,
	-1.852955e-001,
	2.963684e+000,
	-2.262274e+000,
	-1.571683e-001,
	6.339974e-001,
	4.977879e-002,
	7.243307e+000,
	4.220053e-001,
	-1.169936e+000,
	-3.357429e-001,
	1.911291e+000,
	-2.391074e-001,
	-4.791643e-001,
	1.446113e+000,
	-9.178108e-002,
	-4.700239e+000,
	8.096219e-001,
	-1.060246e+000,
	-1.051633e-001,
	5.013829e-001,
	2.832309e+000,
	-3.707855e-001,
	1.523131e+000,
	9.163749e-002,
	5.604183e+000,
	7.208566e-001,
	-1.089753e+000,
	-2.382167e-001,
	2.360312e+000,
	-5.902562e+000,
	-8.799894e+000,
	1.377692e+000,
	-6.131633e-002,
	-1.415472e+000,
	6.124057e-001,
	-1.075481e+000,
	-1.242391e-001,
	1.425781e+000,
	8.810319e+000,
	-2.922646e+000,
	1.486520e+000,
	3.270580e-002,
	3.889783e+000,
	4.999482e-001,
	// albedo 0, turbidity 2
	-1.149342e+000,
	-2.076337e-001,
	-7.446587e+000,
	8.014559e+000,
	-4.866227e-002,
	8.203043e-001,
	6.386483e-002,
	4.894198e+000,
	5.452051e-001,
	-1.120531e+000,
	-1.513311e-001,
	2.735504e+000,
	-2.417591e+000,
	-1.361114e-001,
	4.296342e-001,
	9.427488e-002,
	8.171403e+000,
	4.102448e-001,
	-1.226964e+000,
	-3.516378e-001,
	1.308298e+000,
	-5.097487e-002,
	-4.846783e-001,
	1.654619e+000,
	-1.134940e-001,
	-3.347854e+000,
	1.131147e+000,
	-9.664377e-001,
	2.767589e-002,
	1.658235e-001,
	2.407439e+000,
	-1.300304e-001,
	9.170958e-001,
	2.742895e-001,
	6.642633e+000,
	2.550064e-001,
	-1.153358e+000,
	-3.126223e-001,
	2.078934e+000,
	-5.857733e+000,
	-8.659848e+000,
	1.758505e+000,
	-9.616094e-002,
	-1.230863e+000,
	9.663832e-001,
	-1.053850e+000,
	-1.330743e-001,
	1.481738e+000,
	1.049485e+001,
	-3.528854e+000,
	9.142363e-001,
	1.244880e-001,
	2.644615e+000,
	5.001048e-001,
	// albedo 0, turbidity 3
	-1.173687e+000,
	-2.360362e-001,
	-3.741454e+000,
	4.088507e+000,
	-7.528205e-002,
	6.645237e-001,
	7.718265e-002,
	4.651220e+000,
	5.586318e-001,
	-1.213757e+000,
	-2.589561e-001,
	7.132551e-001,
	-4.259327e-001,
	-1.980821e-001,
	3.627815e-001,
	4.666560e-002,
	5.807984e+000,
	5.847377e-001,
	-1.108794e+000,
	-2.259870e-001,
	1.574179e+000,
	-3.753731e-001,
	-5.984743e-001,
	1.659414e+000,
	-1.681021e-002,
	6.785219e-001,
	8.647325e-001,
	-1.060896e+000,
	-1.346690e-002,
	-7.529656e-001,
	1.711319e+000,
	-9.792435e-001,
	2.022433e-001,
	3.826487e-001,
	5.725157e+000,
	5.290714e-001,
	-1.085145e+000,
	-2.840715e-001,
	2.088029e+000,
	-4.935097e+000,
	-9.056542e+000,
	1.976149e+000,
	-3.912485e-002,
	-8.636064e-001,
	7.452125e-001,
	-1.077983e+000,
	-1.416633e-001,
	1.100848e+000,
	1.015875e+001,
	-2.943712e+000,
	5.255135e-001,
	2.164224e-001,
	2.941143e+000,
	6.699937e-001,
	// albedo 0, turbidity 4
	-1.223293e+000,
	-2.867444e-001,
	-1.624136e+000,
	1.668299e+000,
	-9.537589e-002,
	5.015947e-001,
	1.130741e-001,
	4.244812e+000,
	5.082152e-001,
	-1.325342e+000,
	-4.280991e-001,
	4.705490e-001,
	6.926592e-002,
	-4.572587e-001,
	5.344144e-001,
	-2.554192e-002,
	3.093939e+000,
	6.639401e-001,
	-1.113581e+000,
	-1.192133e-001,
	4.011536e-001,
	7.011889e-001,
	2.052842e-001,
	9.880724e-001,
	1.807533e-002,
	4.690160e+000,
	8.576240e-001,
	-1.016063e+000,
	-1.038138e-001,
	-2.280391e-001,
	7.898918e-001,
	-1.127333e+001,
	2.074545e-001,
	5.388182e-001,
	1.364263e+000,
	4.660455e-001,
	-1.099582e+000,
	-2.228607e-001,
	1.332648e+000,
	5.135188e+000,
	1.653152e+000,
	1.417020e+000,
	-1.087532e-001,
	1.809275e+000,
	8.080874e-001,
	-1.064357e+000,
	-1.520775e-001,
	8.207368e-001,
	-1.323565e-003,
	-5.009523e+000,
	3.946298e-001,
	4.337902e-001,
	2.593198e+000,
	6.719172e-001,
	// albedo 0, turbidity 5
	-1.278702e+000,
	-3.512866e-001,
	-4.511055e-001,
	3.895760e-001,
	-2.429672e-001,
	4.270577e-001,
	1.135348e-001,
	3.719130e+000,
	4.998867e-001,
	-1.580069e+000,
	-7.095475e-001,
	-3.198904e-001,
	1.715748e+000,
	-1.185915e+000,
	4.523161e-001,
	-1.026159e-002,
	7.927188e-001,
	5.538350e-001,
	-9.474023e-001,
	1.173703e-001,
	4.881381e-001,
	-2.618684e+000,
	3.251661e+000,
	1.213931e+000,
	-1.736274e-002,
	8.000768e+000,
	1.025998e+000,
	-1.129091e+000,
	-3.287694e-001,
	-3.524077e-001,
	3.352892e+000,
	-1.416073e+001,
	-8.485617e-001,
	6.560766e-001,
	-2.820937e+000,
	3.111303e-001,
	-1.030884e+000,
	-1.137581e-001,
	1.109855e+000,
	8.082276e+000,
	1.519214e+000,
	2.112433e+000,
	-1.592299e-001,
	3.675905e+000,
	8.703367e-001,
	-1.075192e+000,
	-1.627166e-001,
	3.514910e-001,
	1.168164e+000,
	-4.255822e+000,
	-6.015348e-001,
	6.265776e-001,
	2.884818e+000,
	6.548384e-001,
	// albedo 0, turbidity 6
	-1.316017e+000,
	-3.889652e-001,
	-5.030854e-001,
	4.488704e-001,
	-3.186800e-001,
	4.570763e-001,
	8.909201e-002,
	3.659274e+000,
	5.011746e-001,
	-1.731876e+000,
	-8.493806e-001,
	1.194871e-001,
	2.002781e+000,
	-2.006547e+000,
	4.872233e-001,
	-2.854606e-002,
	2.662137e-001,
	4.611629e-001,
	-9.273680e-001,
	1.380954e-001,
	-3.302179e-001,
	-3.553265e+000,
	4.633345e+000,
	9.696729e-001,
	8.799775e-002,
	8.291129e+000,
	1.094451e+000,
	-1.099377e+000,
	-3.325392e-001,
	2.501063e-001,
	2.613712e+000,
	-1.328142e+001,
	-5.579527e-001,
	4.992081e-001,
	-3.504402e+000,
	3.022924e-001,
	-1.048420e+000,
	-1.227773e-001,
	5.845373e-001,
	1.105869e+001,
	3.813151e-002,
	1.330409e+000,
	1.978131e-002,
	3.959430e+000,
	8.396439e-001,
	-1.063233e+000,
	-1.560639e-001,
	2.840033e-001,
	8.751565e-001,
	-3.411820e+000,
	-1.436564e-001,
	5.846580e-001,
	2.899292e+000,
	6.799095e-001,
	// albedo 0, turbidity 7
	-1.376715e+000,
	-4.541567e-001,
	-1.445491e+000,
	1.569898e+000,
	-1.390627e-001,
	5.558270e-001,
	4.109877e-002,
	3.349451e+000,
	5.516123e-001,
	-1.953391e+000,
	-1.035869e+000,
	1.690563e+000,
	-1.964690e-001,
	-7.787096e-001,
	5.799605e-001,
	2.945626e-002,
	4.217906e-002,
	2.451373e-001,
	-1.012422e+000,
	7.136451e-002,
	-1.862534e+000,
	-7.228653e-001,
	1.947997e-001,
	2.091805e-001,
	6.399233e-002,
	7.928994e+000,
	1.290733e+000,
	-9.706708e-001,
	-2.880950e-001,
	1.107797e+000,
	-2.731734e+000,
	-8.445995e+000,
	4.296774e-001,
	5.117648e-001,
	-3.824277e+000,
	1.761207e-001,
	-1.110611e+000,
	-1.789409e-001,
	2.108488e-001,
	2.071430e+001,
	-1.763174e+000,
	9.554695e-002,
	-2.943103e-002,
	3.422079e+000,
	8.815496e-001,
	-1.048334e+000,
	-1.614087e-001,
	2.475184e-001,
	2.146938e-002,
	-2.983901e+000,
	2.538224e-001,
	5.601370e-001,
	2.461925e+000,
	6.777394e-001,
	// albedo 0, turbidity 8
	-1.393719e+000,
	-5.002724e-001,
	-2.408940e+000,
	2.680983e+000,
	-1.362825e-001,
	7.395067e-001,
	-3.300343e-006,
	3.260889e+000,
	8.132057e-001,
	-2.128663e+000,
	-1.151182e+000,
	2.923026e+000,
	-1.931838e+000,
	-4.426170e-001,
	2.309983e-001,
	-5.485890e-003,
	3.279529e-001,
	-2.229467e-001,
	-1.618022e+000,
	-3.766490e-001,
	-3.163544e+000,
	1.611608e+000,
	-3.967476e-001,
	3.933680e-001,
	3.006742e-001,
	6.835177e+000,
	1.613765e+000,
	-5.669064e-001,
	-1.481749e-001,
	2.071817e+000,
	-8.157422e+000,
	-5.988088e+000,
	2.387202e-001,
	1.447191e-001,
	-4.296385e+000,
	5.011258e-002,
	-1.241724e+000,
	-2.519348e-001,
	-1.908609e-001,
	2.952235e+001,
	-3.333660e+000,
	-1.837651e-002,
	1.022249e-001,
	2.929320e+000,
	8.867262e-001,
	-1.021670e+000,
	-1.667327e-001,
	1.789771e-001,
	-2.178108e-003,
	-2.641572e+000,
	-5.641484e-002,
	5.303758e-001,
	2.138196e+000,
	6.780350e-001,
	// albedo 0, turbidity 9
	-1.669332e+000,
	-7.588708e-001,
	-2.993557e+000,
	3.178760e+000,
	-8.066442e-002,
	6.544672e-001,
	-8.089880e-006,
	2.628924e+000,
	9.001272e-001,
	-1.755806e+000,
	-8.735348e-001,
	3.258881e+000,
	-2.504785e+000,
	-3.300791e-001,
	1.180565e-001,
	-9.315982e-003,
	1.785154e+000,
	-3.205824e-001,
	-3.720277e+000,
	-1.733350e+000,
	-3.332272e+000,
	1.515869e+000,
	1.734218e-001,
	8.011956e-001,
	1.995440e-001,
	3.817666e+000,
	1.638502e+000,
	4.724641e-001,
	3.209828e-001,
	2.051443e+000,
	-5.105574e+000,
	-6.509139e+000,
	-4.232041e-001,
	2.598931e-001,
	-2.151756e+000,
	-3.493910e-003,
	-1.525600e+000,
	-4.897606e-001,
	-9.891121e-002,
	2.346818e+001,
	-2.278152e+000,
	1.681219e-001,
	-4.469389e-002,
	1.051000e+000,
	9.294666e-001,
	-9.908649e-001,
	-2.008182e-001,
	1.605143e-001,
	-2.463113e-003,
	-2.477349e+000,
	-1.218647e-001,
	4.750121e-001,
	1.460813e+000,
	6.661364e-001,
	// albedo 0, turbidity 10
	-2.122119e+000,
	-1.125475e+000,
	-3.066599e+000,
	3.145078e+000,
	-5.411593e-002,
	5.133628e-001,
	-7.823408e-006,
	2.268448e+000,
	9.001416e-001,
	-1.528158e+000,
	-9.370249e-001,
	2.567559e+000,
	-1.591439e+000,
	-3.634460e-001,
	1.763256e-001,
	1.119624e-003,
	1.811848e+000,
	-2.637929e-001,
	-6.524387e+000,
	-2.673507e+000,
	-2.940472e+000,
	-6.025609e-001,
	7.852067e-001,
	1.073499e+000,
	-3.540435e-002,
	3.517416e+000,
	1.490466e+000,
	8.886026e-001,
	-9.681828e-002,
	1.430554e+000,
	4.993717e+000,
	-6.071355e+000,
	-6.053986e-001,
	5.092997e-001,
	-1.273010e+000,
	7.491329e-002,
	-1.481997e+000,
	-5.897282e-001,
	2.659264e-001,
	1.267239e+000,
	-5.741291e-001,
	5.983011e-002,
	-2.217312e-001,
	-3.016452e-001,
	9.260830e-001,
	-1.010943e+000,
	-2.075134e-001,
	5.066749e-002,
	1.470708e+001,
	-3.780501e+000,
	7.253223e-002,
	4.045458e-001,
	1.320164e+000,
	6.559925e-001,
	// albedo 1, turbidity 1
	-1.129907e+000,
	-1.884011e-001,
	-8.047670e+000,
	9.035776e+000,
	-5.539419e-002,
	8.823349e-001,
	3.197135e-002,
	4.839388e+000,
	5.042822e-001,
	-1.133821e+000,
	-1.510781e-001,
	3.362822e+000,
	-2.453381e+000,
	-1.463925e-001,
	4.728708e-001,
	5.958140e-002,
	7.636300e+000,
	4.805162e-001,
	-1.176518e+000,
	-3.549902e-001,
	1.729044e+000,
	-2.160966e-001,
	-5.075865e-001,
	1.675584e+000,
	-8.906902e-002,
	-5.386842e+000,
	5.452218e-001,
	-1.043563e+000,
	-7.520975e-002,
	8.750644e-001,
	2.510518e+000,
	7.584882e-003,
	9.361250e-001,
	7.889083e-002,
	6.066644e+000,
	5.813108e-001,
	-1.081304e+000,
	-2.222253e-001,
	2.517638e+000,
	-4.453820e+000,
	-8.663691e+000,
	8.662558e-001,
	-4.802657e-002,
	-8.965449e-001,
	4.886656e-001,
	-1.083774e+000,
	-1.375469e-001,
	1.685818e+000,
	5.631120e+000,
	-3.100752e+000,
	4.045941e-001,
	2.346895e-002,
	3.390321e+000,
	5.008309e-001,
	// albedo 1, turbidity 2
	-1.143158e+000,
	-2.058334e-001,
	-9.660198e+000,
	1.062394e+001,
	-4.434119e-002,
	8.607615e-001,
	3.177325e-002,
	4.416481e+000,
	5.918162e-001,
	-1.146773e+000,
	-1.727385e-001,
	4.626048e+000,
	-4.684602e+000,
	-8.307137e-002,
	1.619616e-001,
	1.484866e-001,
	7.572868e+000,
	2.681126e-001,
	-1.151324e+000,
	-3.099303e-001,
	4.125596e-001,
	2.340752e+000,
	-4.214444e-001,
	1.987375e+000,
	-1.913410e-001,
	-3.845978e+000,
	1.337311e+000,
	-1.034258e+000,
	-7.778759e-003,
	7.050094e-001,
	-8.036369e-001,
	3.138570e-001,
	2.469452e-001,
	3.559970e-001,
	7.485917e+000,
	4.790329e-002,
	-1.096568e+000,
	-2.673169e-001,
	2.575654e+000,
	-8.057121e-001,
	-8.884928e+000,
	1.416170e+000,
	-2.091315e-001,
	-1.543494e+000,
	1.065445e+000,
	-1.083304e+000,
	-1.528265e-001,
	1.697727e+000,
	2.503702e+000,
	-2.885296e+000,
	-1.298500e-001,
	1.548870e-001,
	2.479652e+000,
	5.066496e-001,
	// albedo 1, turbidity 3
	-1.165736e+000,
	-2.329945e-001,
	-5.967964e+000,
	6.705959e+000,
	-5.931355e-002,
	7.485638e-001,
	3.913878e-002,
	4.221591e+000,
	6.183926e-001,
	-1.212422e+000,
	-2.545910e-001,
	2.418626e+000,
	-2.266104e+000,
	-1.102014e-001,
	1.363887e-002,
	1.055411e-001,
	5.648062e+000,
	4.557412e-001,
	-1.070436e+000,
	-2.163341e-001,
	7.098718e-001,
	7.843075e-001,
	-4.323930e-001,
	2.109823e+000,
	-9.589700e-002,
	-1.985193e-001,
	1.060428e+000,
	-1.104879e+000,
	-3.013622e-002,
	2.976276e-002,
	1.069707e+000,
	1.410000e-001,
	-4.880020e-001,
	4.452288e-001,
	6.418590e+000,
	3.195986e-001,
	-1.048969e+000,
	-2.655317e-001,
	2.689426e+000,
	-3.941038e+000,
	-9.506461e+000,
	1.837119e+000,
	-1.892124e-001,
	-1.562146e+000,
	9.043414e-001,
	-1.106145e+000,
	-1.601642e-001,
	1.544544e+000,
	7.388492e+000,
	-2.924600e+000,
	-4.328453e-001,
	1.763161e-001,
	2.523111e+000,
	5.851902e-001,
	// albedo 1, turbidity 4
	-1.203666e+000,
	-2.776587e-001,
	-2.084286e+000,
	2.450840e+000,
	-8.746613e-002,
	5.258507e-001,
	7.983316e-002,
	3.860055e+000,
	5.486167e-001,
	-1.340448e+000,
	-4.230590e-001,
	3.462849e-001,
	4.707607e-001,
	-2.512626e-001,
	1.530746e-001,
	2.724218e-002,
	3.035216e+000,
	5.876133e-001,
	-1.014554e+000,
	-1.168790e-001,
	9.477794e-001,
	-1.061218e+000,
	-4.196730e-001,
	2.058832e+000,
	-5.989624e-002,
	3.058168e+000,
	9.763861e-001,
	-1.137388e+000,
	-9.854030e-002,
	-2.984893e-001,
	3.647820e+000,
	-6.585571e-001,
	-1.479180e+000,
	6.102932e-001,
	3.265914e+000,
	3.480333e-001,
	-1.021816e+000,
	-2.344957e-001,
	2.463671e+000,
	-7.240685e+000,
	-8.862697e+000,
	2.514058e+000,
	-2.122768e-001,
	-3.313968e-002,
	9.028136e-001,
	-1.126581e+000,
	-1.874347e-001,
	1.454154e+000,
	1.034398e+001,
	-3.237393e+000,
	-8.654927e-001,
	2.457248e-001,
	1.845769e+000,
	6.002482e-001,
	// albedo 1, turbidity 5
	-1.263727e+000,
	-3.439354e-001,
	-1.786388e-001,
	3.980166e-001,
	-3.349517e-001,
	3.825166e-001,
	1.029225e-001,
	3.331096e+000,
	4.998955e-001,
	-1.530010e+000,
	-6.879698e-001,
	2.380415e-001,
	1.608216e+000,
	-1.682679e+000,
	3.546360e-001,
	-3.915220e-003,
	4.517655e-001,
	5.128605e-001,
	-9.685659e-001,
	9.480403e-002,
	6.076844e-002,
	-3.217561e+000,
	4.568074e+000,
	1.069299e+000,
	2.083638e-002,
	7.301088e+000,
	1.072165e+000,
	-1.113925e+000,
	-3.112382e-001,
	3.954133e-001,
	5.105907e+000,
	-1.456866e+001,
	-4.917378e-001,
	5.289909e-001,
	-2.678374e+000,
	3.014709e-001,
	-1.046864e+000,
	-1.215754e-001,
	1.778308e+000,
	4.661489e+000,
	2.565583e-001,
	1.353680e+000,
	-1.175767e-001,
	3.415972e+000,
	8.457746e-001,
	-1.104480e+000,
	-1.940913e-001,
	1.343668e+000,
	-1.759206e-003,
	-5.009204e+000,
	-4.186951e-001,
	3.125710e-001,
	1.628183e+000,
	6.720408e-001,
	// albedo 1, turbidity 6
	-1.286902e+000,
	-3.781238e-001,
	-8.977253e-002,
	3.545393e-001,
	-4.866515e-001,
	3.843664e-001,
	8.281675e-002,
	3.122231e+000,
	5.046991e-001,
	-1.712597e+000,
	-8.549112e-001,
	4.809286e-001,
	1.515398e+000,
	-2.212211e+000,
	2.539029e-001,
	2.335997e-002,
	-6.089466e-002,
	4.268444e-001,
	-8.807283e-001,
	1.646097e-001,
	-4.437898e-001,
	-3.188247e+000,
	5.984417e+000,
	1.334779e+000,
	-4.026975e-002,
	7.546431e+000,
	1.175751e+000,
	-1.147253e+000,
	-3.538199e-001,
	6.101836e-001,
	4.437780e+000,
	-1.559813e+001,
	-1.103222e+000,
	6.242039e-001,
	-3.091472e+000,
	2.174290e-001,
	-1.038230e+000,
	-1.213475e-001,
	1.547505e+000,
	5.893176e+000,
	1.368738e+000,
	1.663127e+000,
	-1.377130e-001,
	3.185279e+000,
	8.736453e-001,
	-1.101026e+000,
	-1.874907e-001,
	1.272667e+000,
	3.596524e+000,
	-5.007243e+000,
	-6.352483e-001,
	3.048985e-001,
	1.931613e+000,
	6.788844e-001,
	// albedo 1, turbidity 7
	-1.342753e+000,
	-4.384971e-001,
	-1.213491e+000,
	1.621399e+000,
	-1.551441e-001,
	5.614218e-001,
	2.591739e-002,
	2.958967e+000,
	5.782132e-001,
	-1.937684e+000,
	-1.066019e+000,
	1.913336e+000,
	-7.347719e-001,
	-5.916167e-001,
	1.587590e-001,
	1.092568e-001,
	-6.275002e-001,
	1.599071e-001,
	-9.302391e-001,
	1.486187e-001,
	-1.603835e+000,
	1.783713e-001,
	1.100461e+000,
	1.174181e+000,
	-1.602361e-001,
	7.868331e+000,
	1.468971e+000,
	-1.053631e+000,
	-3.727050e-001,
	1.114117e+000,
	-9.603286e-001,
	-1.062469e+001,
	-1.162140e+000,
	7.952797e-001,
	-4.478765e+000,
	-4.440862e-002,
	-1.083629e+000,
	-1.261405e-001,
	1.229344e+000,
	1.127825e+001,
	1.319010e-001,
	1.624729e+000,
	-2.825898e-001,
	3.661082e+000,
	1.036911e+000,
	-1.093950e+000,
	-2.067455e-001,
	1.258035e+000,
	7.548645e+000,
	-4.598387e+000,
	-8.944932e-001,
	3.292634e-001,
	1.311304e+000,
	6.291871e-001,
	// albedo 1, turbidity 8
	-1.385867e+000,
	-5.068139e-001,
	-1.486490e+000,
	1.969049e+000,
	-1.698025e-001,
	6.629167e-001,
	-5.289365e-006,
	2.760315e+000,
	8.644368e-001,
	-2.107367e+000,
	-1.175639e+000,
	2.313241e+000,
	-1.001653e+000,
	-4.843139e-001,
	1.124485e-001,
	3.901494e-005,
	-3.502469e-001,
	-3.204780e-001,
	-1.475244e+000,
	-2.833055e-001,
	-2.085824e+000,
	1.192563e+000,
	-7.645200e-001,
	8.380081e-001,
	2.203580e-001,
	7.157885e+000,
	1.753702e+000,
	-6.644372e-001,
	-2.549735e-001,
	1.600273e+000,
	-8.589034e+000,
	-6.144718e+000,
	-7.599731e-001,
	2.898370e-001,
	-5.770923e+000,
	-9.656242e-002,
	-1.211687e+000,
	-1.653494e-001,
	8.393400e-001,
	2.792988e+001,
	-3.395461e+000,
	9.933752e-001,
	-3.976877e-002,
	3.776659e+000,
	9.546526e-001,
	-1.063757e+000,
	-2.037563e-001,
	1.117207e+000,
	-1.252806e-003,
	-3.332330e+000,
	-6.971409e-001,
	3.388719e-001,
	1.311398e+000,
	6.635171e-001,
	// albedo 1, turbidity 9
	-1.678889e+000,
	-7.992295e-001,
	-2.421687e+000,
	2.871029e+000,
	-7.662842e-002,
	6.046208e-001,
	-7.598099e-006,
	2.002314e+000,
	9.001307e-001,
	-1.692144e+000,
	-8.804250e-001,
	3.060895e+000,
	-2.000009e+000,
	-3.183563e-001,
	8.385862e-002,
	-6.326713e-003,
	1.206639e+000,
	-3.369967e-001,
	-3.676795e+000,
	-1.719207e+000,
	-2.534697e+000,
	1.005285e+000,
	1.550407e-001,
	1.072910e+000,
	1.318094e-001,
	3.717018e+000,
	1.689191e+000,
	5.424542e-001,
	3.263528e-001,
	1.551055e+000,
	-3.841058e+000,
	-6.598996e+000,
	-1.201779e+000,
	3.530669e-001,
	-2.542945e+000,
	-6.482523e-002,
	-1.553849e+000,
	-4.576860e-001,
	9.324676e-001,
	1.950982e+001,
	-2.344516e+000,
	1.121020e+000,
	-1.221537e-001,
	7.285496e-001,
	9.582816e-001,
	-1.020650e+000,
	-2.215797e-001,
	1.009774e+000,
	-2.056855e-003,
	-2.740338e+000,
	-8.122355e-001,
	3.328967e-001,
	8.982766e-001,
	6.594676e-001,
	// albedo 1, turbidity 10
	-2.247360e+000,
	-1.221267e+000,
	-3.072346e+000,
	3.385139e+000,
	-4.387559e-002,
	5.084887e-001,
	-7.418833e-006,
	1.750107e+000,
	9.001401e-001,
	-1.248499e+000,
	-8.442718e-001,
	3.062611e+000,
	-2.020314e+000,
	-2.815341e-001,
	5.254745e-002,
	3.345008e-003,
	1.433225e+000,
	-2.835911e-001,
	-7.004119e+000,
	-2.927978e+000,
	-2.649852e+000,
	7.971894e-001,
	5.466893e-001,
	1.442667e+000,
	-6.063912e-002,
	2.806194e+000,
	1.547429e+000,
	1.434882e+000,
	9.114639e-002,
	1.170089e+000,
	3.512808e-002,
	-5.861915e+000,
	-1.411843e+000,
	5.400486e-001,
	-7.746522e-001,
	2.386984e-002,
	-1.559053e+000,
	-5.502302e-001,
	1.200396e+000,
	1.347741e+001,
	-2.344397e+000,
	8.868907e-001,
	-3.292661e-001,
	-1.362105e+000,
	9.217826e-001,
	-1.044436e+000,
	-2.360719e-001,
	7.054471e-001,
	-2.904518e-003,
	-2.092829e+000,
	-5.119668e-001,
	4.174861e-001,
	9.687435e-001,
	6.588427e-001,
};

double datasetRGBRad2[] = 
{
	// albedo 0, turbidity 1
	1.590330e+000,
	1.355401e+000,
	1.151412e+000,
	1.359116e+001,
	5.857714e+000,
	8.090833e+000,
	// albedo 0, turbidity 2
	1.552540e+000,
	1.510040e+000,
	1.276413e-001,
	1.604643e+001,
	5.912162e+000,
	8.350009e+000,
	// albedo 0, turbidity 3
	1.470871e+000,
	1.880464e+000,
	-1.865398e+000,
	2.030808e+001,
	5.471461e+000,
	9.109834e+000,
	// albedo 0, turbidity 4
	1.356563e+000,
	2.373866e+000,
	-4.653245e+000,
	2.570922e+001,
	5.686009e+000,
	1.009480e+001,
	// albedo 0, turbidity 5
	1.244232e+000,
	2.851519e+000,
	-7.130942e+000,
	2.993449e+001,
	6.382120e+000,
	1.114578e+001,
	// albedo 0, turbidity 6
	1.173693e+000,
	3.120604e+000,
	-8.491886e+000,
	3.187393e+001,
	7.290615e+000,
	1.180066e+001,
	// albedo 0, turbidity 7
	1.091845e+000,
	3.368888e+000,
	-9.722083e+000,
	3.268508e+001,
	1.032424e+001,
	1.236508e+001,
	// albedo 0, turbidity 8
	9.858985e-001,
	3.500541e+000,
	-1.026328e+001,
	3.092956e+001,
	1.610881e+001,
	1.331222e+001,
	// albedo 0, turbidity 9
	8.864993e-001,
	3.172888e+000,
	-8.687550e+000,
	2.362161e+001,
	2.621851e+001,
	1.474967e+001,
	// albedo 0, turbidity 10
	7.946973e-001,
	2.189355e+000,
	-4.207953e+000,
	9.399091e+000,
	4.062849e+001,
	1.681753e+001,
	// albedo 1, turbidity 1
	1.711696e+000,
	1.657311e+000,
	9.328021e-001,
	1.317880e+001,
	1.506751e+001,
	1.863556e+001,
	// albedo 1, turbidity 2
	1.666968e+000,
	1.849993e+000,
	-2.088601e-001,
	1.586653e+001,
	1.486880e+001,
	1.940719e+001,
	// albedo 1, turbidity 3
	1.584846e+000,
	2.170022e+000,
	-2.019597e+000,
	1.970826e+001,
	1.490684e+001,
	2.045055e+001,
	// albedo 1, turbidity 4
	1.469412e+000,
	2.524017e+000,
	-4.197267e+000,
	2.365249e+001,
	1.664588e+001,
	2.134477e+001,
	// albedo 1, turbidity 5
	1.369714e+000,
	2.843548e+000,
	-6.059031e+000,
	2.634993e+001,
	1.881361e+001,
	2.232186e+001,
	// albedo 1, turbidity 6
	1.310477e+000,
	2.984444e+000,
	-6.831686e+000,
	2.682340e+001,
	2.123267e+001,
	2.259755e+001,
	// albedo 1, turbidity 7
	1.222552e+000,
	3.176523e+000,
	-7.731496e+000,
	2.671760e+001,
	2.484358e+001,
	2.336863e+001,
	// albedo 1, turbidity 8
	1.115781e+000,
	3.130635e+000,
	-7.581744e+000,
	2.336531e+001,
	3.171048e+001,
	2.413859e+001,
	// albedo 1, turbidity 9
	1.013181e+000,
	2.699342e+000,
	-5.602709e+000,
	1.500158e+001,
	4.217613e+001,
	2.515957e+001,
	// albedo 1, turbidity 10
	8.976323e-001,
	1.726948e+000,
	-1.296120e+000,
	1.183675e+000,
	5.503215e+001,
	2.643066e+001,
};

double datasetRGB3[] = 
{
	// albedo 0, turbidity 1
	-1.372629e+000,
	-4.905585e-001,
	-4.100789e+001,
	4.122169e+001,
	-7.389360e-003,
	4.839359e-001,
	6.474757e-003,
	3.471755e+000,
	5.092936e-001,
	-1.523025e+000,
	-6.497084e-001,
	6.249857e+000,
	-5.662543e+000,
	-1.908402e-002,
	5.512810e-001,
	-2.181049e-005,
	2.507663e+000,
	4.339598e-001,
	-1.035567e+000,
	-7.478740e-002,
	9.221030e-001,
	-2.140047e+000,
	-2.374146e-002,
	3.795517e-001,
	-1.769134e-002,
	7.479831e+000,
	7.729303e-001,
	-1.271086e+000,
	-5.588190e-001,
	6.908023e-001,
	2.096832e+000,
	-2.453967e-001,
	1.410648e+000,
	4.475036e-002,
	-4.719115e+000,
	5.741186e-001,
	-9.712598e-001,
	-7.033926e-002,
	9.167274e-001,
	-9.502097e-001,
	3.004684e-001,
	4.547054e-001,
	-5.929017e-002,
	5.266196e+000,
	7.204135e-001,
	-1.087457e+000,
	-1.888896e-001,
	8.156686e-001,
	3.101712e-001,
	-2.155419e+000,
	1.422205e+000,
	9.692261e-002,
	3.122404e+000,
	4.999430e-001,
	// albedo 0, turbidity 2
	-1.425280e+000,
	-5.413508e-001,
	-3.454883e+001,
	3.481142e+001,
	-8.686975e-003,
	4.914268e-001,
	-2.479243e-006,
	3.239879e+000,
	6.094201e-001,
	-1.688557e+000,
	-8.070865e-001,
	7.018459e+000,
	-6.244574e+000,
	-2.149341e-002,
	3.993971e-001,
	1.252502e-002,
	1.630662e+000,
	1.097860e-001,
	-8.664152e-001,
	7.869125e-002,
	-5.236535e-001,
	-1.218960e+000,
	-2.059093e-002,
	6.684898e-001,
	-5.584112e-002,
	8.602299e+000,
	1.410496e+000,
	-1.319763e+000,
	-5.985323e-001,
	1.253918e+000,
	1.914706e+000,
	-3.216739e-001,
	9.011213e-001,
	1.324845e-001,
	-5.252749e+000,
	6.231252e-002,
	-9.706008e-001,
	-5.914059e-002,
	5.693150e-001,
	-1.175362e+000,
	5.221644e-001,
	7.518213e-001,
	-8.247655e-002,
	5.875635e+000,
	9.850863e-001,
	-1.085330e+000,
	-1.956105e-001,
	8.019605e-001,
	5.338101e-001,
	-3.423464e+000,
	1.110444e+000,
	1.507923e-001,
	2.864942e+000,
	4.999481e-001,
	// albedo 0, turbidity 3
	-1.431967e+000,
	-5.478935e-001,
	-3.286288e+001,
	3.305288e+001,
	-8.380797e-003,
	4.772050e-001,
	-3.044274e-006,
	3.289973e+000,
	5.976303e-001,
	-1.801361e+000,
	-9.315889e-001,
	5.391756e+000,
	-4.588592e+000,
	-2.040076e-002,
	4.144684e-001,
	1.814534e-002,
	1.051795e+000,
	1.145651e-001,
	-7.905357e-001,
	1.451332e-001,
	-1.605661e-001,
	-1.592174e+000,
	4.561348e-004,
	3.380323e-001,
	-7.770275e-002,
	8.775384e+000,
	1.489512e+000,
	-1.308575e+000,
	-5.539232e-001,
	9.184133e-001,
	2.011479e+000,
	-3.842472e-001,
	1.432274e+000,
	1.637153e-001,
	-4.408856e+000,
	5.272957e-002,
	-9.829872e-001,
	-8.183048e-002,
	4.464556e-001,
	-1.442716e+000,
	1.029641e+000,
	-6.991617e-002,
	8.702356e-003,
	5.706417e+000,
	9.116452e-001,
	-1.087130e+000,
	-2.038013e-001,
	7.260801e-001,
	9.164376e-001,
	-5.006183e+000,
	1.511271e+000,
	1.257134e-001,
	2.715439e+000,
	6.201652e-001,
	// albedo 0, turbidity 4
	-1.448662e+000,
	-5.799075e-001,
	-2.833268e+001,
	2.858023e+001,
	-9.134061e-003,
	4.404783e-001,
	-2.709026e-006,
	3.029357e+000,
	5.540071e-001,
	-2.061772e+000,
	-1.145190e+000,
	7.918478e+000,
	-7.212525e+000,
	-2.020760e-002,
	2.962715e-001,
	4.689670e-002,
	8.517209e-001,
	2.334587e-001,
	-6.413755e-001,
	1.780425e-001,
	-2.412919e+000,
	1.064484e+000,
	-1.949986e-002,
	6.769741e-001,
	-1.752760e-001,
	7.262714e+000,
	1.325869e+000,
	-1.304871e+000,
	-3.975581e-001,
	1.219002e+000,
	7.285178e-001,
	-2.710105e-001,
	7.779727e-001,
	3.247139e-001,
	-8.818168e-001,
	1.839517e-001,
	-1.001104e+000,
	-1.994801e-001,
	3.676742e-001,
	-1.409737e+000,
	2.901555e-001,
	2.506940e-001,
	2.468899e-003,
	3.398923e+000,
	8.584645e-001,
	-1.111552e+000,
	-2.487204e-001,
	7.410842e-001,
	1.703749e+000,
	-5.007855e+000,
	1.057763e+000,
	1.354511e-001,
	2.088715e+000,
	6.600013e-001,
	// albedo 0, turbidity 5
	-1.547227e+000,
	-6.679466e-001,
	-1.861465e+001,
	1.884045e+001,
	-1.242210e-002,
	4.157339e-001,
	-2.432805e-006,
	2.812423e+000,
	5.446957e-001,
	-2.043890e+000,
	-1.149081e+000,
	2.304118e+000,
	-1.715757e+000,
	-2.433628e-002,
	2.816836e-001,
	7.185458e-002,
	1.064860e+000,
	2.706789e-001,
	-9.040720e-001,
	-8.274472e-002,
	-2.555676e-001,
	-6.326215e-001,
	-2.770880e-002,
	6.676024e-001,
	-2.513532e-001,
	5.903839e+000,
	1.241452e+000,
	-1.000013e+000,
	-1.010774e-001,
	3.699166e-001,
	8.774526e-001,
	-3.042007e-001,
	6.951053e-001,
	4.361813e-001,
	6.793421e-001,
	2.573892e-001,
	-1.171332e+000,
	-3.768188e-001,
	3.701377e-001,
	-1.470757e+000,
	5.525942e-001,
	2.991456e-002,
	1.581823e-002,
	2.365233e+000,
	8.214514e-001,
	-1.068667e+000,
	-2.326330e-001,
	6.725059e-001,
	2.243733e+000,
	-4.614370e+000,
	1.033677e+000,
	1.376291e-001,
	2.013334e+000,
	6.865304e-001,
	// albedo 0, turbidity 6
	-1.592991e+000,
	-7.246948e-001,
	-2.598204e+001,
	2.621960e+001,
	-8.365176e-003,
	4.207571e-001,
	-2.742772e-006,
	2.623735e+000,
	5.873190e-001,
	-2.271349e+000,
	-1.280884e+000,
	6.308739e+000,
	-5.758350e+000,
	-1.977049e-002,
	3.671835e-001,
	6.698038e-002,
	1.150597e+000,
	1.759218e-001,
	-6.368620e-001,
	-7.436052e-003,
	-2.230026e+000,
	1.640997e+000,
	-1.548497e-002,
	3.145331e-001,
	-2.492644e-001,
	5.083843e+000,
	1.260215e+000,
	-1.177925e+000,
	-9.628114e-002,
	3.051152e-001,
	-3.749544e-002,
	-2.713209e-001,
	1.164226e+000,
	4.559969e-001,
	2.175429e+000,
	2.874284e-001,
	-1.078500e+000,
	-3.801779e-001,
	4.788906e-001,
	-4.795969e-001,
	5.977621e-001,
	-4.488535e-001,
	3.386874e-002,
	1.538143e+000,
	8.062054e-001,
	-1.108028e+000,
	-2.596892e-001,
	5.162202e-001,
	1.557081e+000,
	-4.265039e+000,
	1.182535e+000,
	1.563762e-001,
	2.095084e+000,
	6.883383e-001,
	// albedo 0, turbidity 7
	-1.668427e+000,
	-7.908511e-001,
	-2.779690e+001,
	2.799746e+001,
	-7.186935e-003,
	3.757766e-001,
	-3.326858e-006,
	2.563421e+000,
	5.439687e-001,
	-2.156175e+000,
	-1.220004e+000,
	3.585732e+000,
	-3.235988e+000,
	-1.086239e-002,
	1.846143e-001,
	1.046017e-001,
	1.234427e+000,
	2.842191e-001,
	-1.117051e+000,
	-4.101627e-001,
	-8.463730e-001,
	7.671472e-001,
	-2.226609e-002,
	8.574943e-001,
	-3.434124e-001,
	4.475715e+000,
	1.154824e+000,
	-7.444840e-001,
	2.312078e-001,
	-5.393724e-001,
	1.574213e-001,
	-1.763914e-001,
	2.751692e-001,
	5.564200e-001,
	2.217672e+000,
	3.483932e-001,
	-1.273036e+000,
	-5.275562e-001,
	4.902512e-001,
	-4.498436e-002,
	4.339366e-001,
	2.386682e-001,
	2.380879e-002,
	1.413444e+000,
	7.855923e-001,
	-1.084192e+000,
	-2.936753e-001,
	4.719432e-001,
	1.384436e+000,
	-3.257789e+000,
	6.119543e-001,
	1.681884e-001,
	1.650441e+000,
	6.936631e-001,
	// albedo 0, turbidity 8
	-1.848490e+000,
	-9.512670e-001,
	-3.005251e+001,
	3.024315e+001,
	-5.635304e-003,
	3.447780e-001,
	-2.782999e-006,
	2.309422e+000,
	5.643559e-001,
	-2.300008e+000,
	-1.252335e+000,
	-1.218876e+000,
	1.493730e+000,
	-6.107100e-003,
	7.974860e-002,
	1.023449e-001,
	1.505934e+000,
	2.360948e-001,
	-1.483705e+000,
	-8.547575e-001,
	-7.797146e-001,
	6.447971e-001,
	-2.678052e-002,
	1.091263e+000,
	-3.344889e-001,
	3.830416e+000,
	1.189425e+000,
	-5.348005e-001,
	3.982733e-001,
	-4.071573e-001,
	3.265569e-001,
	-8.658789e-002,
	-2.370892e-001,
	5.369097e-001,
	1.478279e+000,
	3.143303e-001,
	-1.320401e+000,
	-6.043247e-001,
	3.019196e-001,
	-7.732911e-002,
	4.768381e-001,
	6.745764e-001,
	3.694098e-002,
	1.158234e+000,
	8.169056e-001,
	-1.101040e+000,
	-3.420019e-001,
	3.775661e-001,
	1.769338e+000,
	-2.990515e+000,
	1.649529e-001,
	1.970125e-001,
	1.453355e+000,
	6.759757e-001,
	// albedo 0, turbidity 9
	-2.251946e+000,
	-1.229349e+000,
	-3.271808e+001,
	3.283114e+001,
	-4.252027e-003,
	3.372289e-001,
	-3.001937e-006,
	2.154046e+000,
	5.842674e-001,
	-1.867834e+000,
	-9.531252e-001,
	-1.229365e+001,
	1.269149e+001,
	-6.844772e-003,
	1.185107e-001,
	7.539587e-002,
	1.846381e+000,
	1.899412e-001,
	-3.398629e+000,
	-2.180862e+000,
	2.335213e+000,
	-3.382823e+000,
	-8.613985e-003,
	8.431602e-001,
	-2.393567e-001,
	3.112460e+000,
	1.218556e+000,
	5.708381e-001,
	9.406030e-001,
	-6.890113e-001,
	2.746233e+000,
	-5.772068e-002,
	1.096005e-001,
	3.491978e-001,
	7.281453e-001,
	3.212049e-001,
	-1.705909e+000,
	-8.517224e-001,
	1.131160e-001,
	-2.141434e+000,
	4.274043e-001,
	3.397600e-001,
	1.786490e-001,
	9.026101e-001,
	7.882800e-001,
	-1.012865e+000,
	-3.495551e-001,
	3.369038e-001,
	3.724205e+000,
	-3.089586e+000,
	1.266964e-001,
	1.461790e-001,
	1.170199e+000,
	6.931052e-001,
	// albedo 0, turbidity 10
	-2.890318e+000,
	-1.665573e+000,
	-3.493756e+001,
	3.500369e+001,
	-2.984251e-003,
	2.622419e-001,
	-4.259360e-006,
	1.947681e+000,
	6.905752e-001,
	-1.956022e+000,
	-1.062900e+000,
	-1.919714e+001,
	1.975164e+001,
	-8.865396e-003,
	2.165540e-001,
	5.475637e-002,
	1.761134e+000,
	3.164249e-003,
	-5.612198e+000,
	-3.101371e+000,
	4.098034e+000,
	-6.144001e+000,
	9.944958e-003,
	2.905472e-001,
	-1.707110e-001,
	3.199107e+000,
	1.337660e+000,
	8.353756e-001,
	4.855943e-001,
	-1.243589e+000,
	5.147385e+000,
	-7.013963e-002,
	9.380410e-001,
	2.335714e-001,
	1.727744e-001,
	2.802696e-001,
	-1.524329e+000,
	-7.388547e-001,
	3.259025e-001,
	-4.050634e+000,
	4.058549e-001,
	-2.591384e-001,
	1.898299e-001,
	3.556071e-001,
	7.884126e-001,
	-1.070371e+000,
	-4.207858e-001,
	1.739862e-001,
	5.293410e+000,
	-3.136757e+000,
	2.323856e-001,
	1.673706e-001,
	1.007227e+000,
	6.844287e-001,
	// albedo 1, turbidity 1
	-1.341720e+000,
	-4.834889e-001,
	-4.633447e+001,
	4.682148e+001,
	-6.137296e-003,
	4.599216e-001,
	7.047323e-003,
	2.895798e+000,
	4.999398e-001,
	-1.529104e+000,
	-6.498631e-001,
	1.534103e+001,
	-1.450675e+001,
	-1.531439e-002,
	3.280082e-001,
	1.682926e-002,
	1.901587e+000,
	5.013227e-001,
	-1.014776e+000,
	-1.454495e-001,
	-4.071085e+000,
	2.954982e+000,
	-2.630348e-002,
	5.681531e-001,
	-3.016505e-002,
	6.773854e+000,
	5.003504e-001,
	-1.172413e+000,
	-4.026320e-001,
	2.960428e+000,
	2.020710e-001,
	-2.004947e-001,
	9.375572e-001,
	5.998168e-002,
	-4.945934e+000,
	4.502898e-001,
	-9.898161e-001,
	-5.772814e-002,
	4.470024e-001,
	-5.786656e-001,
	1.158168e-001,
	3.468040e-001,
	-5.043360e-002,
	6.867947e+000,
	8.012363e-001,
	-1.085111e+000,
	-1.882675e-001,
	1.223748e+000,
	3.565495e-001,
	-3.688357e+000,
	5.653723e-001,
	6.727646e-002,
	2.690130e+000,
	4.999400e-001,
	// albedo 1, turbidity 2
	-1.389119e+000,
	-5.290250e-001,
	-4.055774e+001,
	4.105972e+001,
	-7.062577e-003,
	4.560060e-001,
	-1.736334e-006,
	2.775512e+000,
	6.671455e-001,
	-1.584641e+000,
	-7.200619e-001,
	1.248067e+001,
	-1.156028e+001,
	-1.659568e-002,
	3.050029e-001,
	1.099895e-002,
	1.438927e+000,
	-2.138015e-002,
	-9.826068e-001,
	-8.887254e-002,
	-2.960031e+000,
	1.808816e+000,
	-2.478159e-002,
	6.035733e-001,
	-4.868441e-002,
	7.347705e+000,
	1.584739e+000,
	-1.150423e+000,
	-4.073793e-001,
	2.412991e+000,
	4.870840e-001,
	-2.337902e-001,
	8.295114e-001,
	1.129914e-001,
	-5.150045e+000,
	-9.016643e-002,
	-1.016933e+000,
	-6.311501e-002,
	5.218937e-001,
	-5.716430e-001,
	1.250993e-001,
	3.601524e-001,
	-5.497586e-002,
	7.060139e+000,
	1.018333e+000,
	-1.073151e+000,
	-1.845444e-001,
	1.155394e+000,
	3.004486e-001,
	-3.431711e+000,
	4.657031e-001,
	9.401223e-002,
	2.688620e+000,
	4.999544e-001,
	// albedo 1, turbidity 3
	-1.391257e+000,
	-5.365815e-001,
	-4.255881e+001,
	4.299132e+001,
	-5.838466e-003,
	4.229134e-001,
	-2.760038e-006,
	2.775531e+000,
	6.234597e-001,
	-1.780062e+000,
	-9.228880e-001,
	1.376172e+001,
	-1.260946e+001,
	-1.507526e-002,
	3.117435e-001,
	2.205045e-002,
	6.093731e-001,
	3.463446e-002,
	-7.388169e-001,
	1.275670e-001,
	-3.999528e+000,
	2.223993e+000,
	-1.856853e-002,
	5.439310e-001,
	-8.834054e-002,
	8.037139e+000,
	1.645951e+000,
	-1.322387e+000,
	-5.320143e-001,
	2.659359e+000,
	1.086712e+000,
	-2.129712e-001,
	8.704649e-001,
	1.800315e-001,
	-4.967241e+000,
	-1.383720e-001,
	-9.378288e-001,
	-1.599895e-002,
	3.607555e-001,
	-1.980561e+000,
	3.791456e-001,
	1.212268e-001,
	-2.845992e-002,
	6.825542e+000,
	1.059139e+000,
	-1.100832e+000,
	-2.172313e-001,
	1.211561e+000,
	2.002721e+000,
	-5.010011e+000,
	5.717583e-001,
	6.777702e-002,
	2.160006e+000,
	5.676392e-001,
	// albedo 1, turbidity 4
	-1.409373e+000,
	-5.708751e-001,
	-3.034974e+001,
	3.079809e+001,
	-7.280715e-003,
	3.723304e-001,
	-2.436279e-006,
	2.577348e+000,
	5.913377e-001,
	-1.954312e+000,
	-1.116510e+000,
	5.399148e+000,
	-4.299553e+000,
	-1.724739e-002,
	3.742824e-001,
	4.187077e-002,
	1.044883e-001,
	1.232727e-001,
	-6.772215e-001,
	2.001396e-001,
	-3.670523e-001,
	-1.014628e+000,
	-3.497152e-003,
	4.099858e-001,
	-1.584633e-001,
	7.750400e+000,
	1.514559e+000,
	-1.291600e+000,
	-4.977437e-001,
	9.641914e-001,
	1.562420e+000,
	-3.227782e-001,
	9.055427e-001,
	3.046444e-001,
	-3.385619e+000,
	9.546291e-003,
	-9.750857e-001,
	-8.770560e-002,
	9.054256e-001,
	-1.429236e+000,
	8.974777e-001,
	-1.217961e-001,
	-5.194608e-002,
	4.909409e+000,
	9.589153e-001,
	-1.088007e+000,
	-1.959301e-001,
	9.745799e-001,
	1.260761e+000,
	-5.008864e+000,
	7.271248e-001,
	1.096661e-001,
	2.717295e+000,
	6.340731e-001,
	// albedo 1, turbidity 5
	-1.456050e+000,
	-6.223072e-001,
	-2.228088e+001,
	2.269604e+001,
	-9.340812e-003,
	4.118308e-001,
	-2.418083e-006,
	2.442117e+000,
	5.589638e-001,
	-2.176449e+000,
	-1.302416e+000,
	2.222836e+000,
	-1.222730e+000,
	-1.728051e-002,
	1.323513e-001,
	7.027731e-002,
	4.835745e-002,
	2.093351e-001,
	-5.789641e-001,
	2.215407e-001,
	2.142291e-001,
	-1.201725e+000,
	-1.185728e-002,
	8.122982e-001,
	-2.380420e-001,
	6.706841e+000,
	1.404146e+000,
	-1.307463e+000,
	-4.515174e-001,
	6.447827e-001,
	1.223841e+000,
	-2.902391e-001,
	4.986588e-001,
	4.073652e-001,
	-1.706696e+000,
	1.060885e-001,
	-9.698678e-001,
	-1.307094e-001,
	9.389347e-001,
	-1.522852e+000,
	7.768797e-001,
	-1.368595e-001,
	-3.857426e-002,
	3.676935e+000,
	8.980966e-001,
	-1.104349e+000,
	-2.380323e-001,
	1.047043e+000,
	1.865421e+000,
	-5.011664e+000,
	7.014954e-001,
	9.622701e-002,
	1.891360e+000,
	6.687354e-001,
	// albedo 1, turbidity 6
	-1.502249e+000,
	-6.724523e-001,
	-2.888092e+001,
	2.930360e+001,
	-6.685766e-003,
	3.685464e-001,
	-2.469442e-006,
	2.310797e+000,
	5.566754e-001,
	-2.217125e+000,
	-1.364924e+000,
	4.048243e+000,
	-3.111333e+000,
	-1.317747e-002,
	1.921948e-001,
	8.627702e-002,
	1.981769e-003,
	2.213689e-001,
	-6.215757e-001,
	1.687995e-001,
	-5.949131e-001,
	-1.551293e-001,
	3.356129e-004,
	6.897657e-001,
	-2.855053e-001,
	6.271042e+000,
	1.363084e+000,
	-1.216317e+000,
	-3.489429e-001,
	7.566226e-001,
	5.409809e-001,
	-2.830843e-001,
	6.191825e-001,
	4.755163e-001,
	-9.131387e-001,
	1.383909e-001,
	-1.030437e+000,
	-2.034064e-001,
	8.335995e-001,
	-1.050947e+000,
	8.689093e-001,
	-3.672310e-001,
	-4.056183e-002,
	3.111269e+000,
	8.856842e-001,
	-1.078984e+000,
	-2.070549e-001,
	9.683145e-001,
	1.497022e+000,
	-5.007653e+000,
	7.702541e-001,
	1.285822e-001,
	2.225188e+000,
	6.587911e-001,
	// albedo 1, turbidity 7
	-1.559291e+000,
	-7.374039e-001,
	-3.596311e+001,
	3.634470e+001,
	-4.667132e-003,
	3.277964e-001,
	-2.487945e-006,
	2.215652e+000,
	5.764681e-001,
	-2.356929e+000,
	-1.444755e+000,
	6.244526e+000,
	-5.540162e+000,
	-8.794510e-003,
	1.792100e-001,
	9.578517e-002,
	3.737676e-001,
	1.922194e-001,
	-6.589752e-001,
	-2.926910e-002,
	-1.831779e+000,
	1.869962e+000,
	-2.030095e-003,
	7.552089e-001,
	-3.168157e-001,
	4.632196e+000,
	1.294054e+000,
	-1.161046e+000,
	-1.472506e-001,
	6.494138e-001,
	-8.327174e-001,
	-2.320724e-001,
	3.391212e-001,
	5.269637e-001,
	9.376341e-001,
	2.458573e-001,
	-1.034427e+000,
	-3.062504e-001,
	8.975634e-001,
	3.203531e-001,
	8.565142e-001,
	-1.250162e-001,
	-4.094017e-002,
	1.861304e+000,
	8.223468e-001,
	-1.109954e+000,
	-2.740277e-001,
	1.063811e+000,
	7.077398e-001,
	-4.695734e+000,
	5.621696e-001,
	1.248956e-001,
	1.297723e+000,
	6.789720e-001,
	// albedo 1, turbidity 8
	-1.788293e+000,
	-9.368751e-001,
	-4.382980e+001,
	4.424963e+001,
	-3.652530e-003,
	3.094331e-001,
	-2.810503e-006,
	1.904402e+000,
	5.861599e-001,
	-2.268206e+000,
	-1.312676e+000,
	2.863082e+000,
	-2.373727e+000,
	-5.144980e-003,
	1.711072e-001,
	9.316041e-002,
	9.309598e-001,
	1.791683e-001,
	-1.376966e+000,
	-7.418582e-001,
	-1.349589e+000,
	1.563419e+000,
	-3.124219e-003,
	6.967139e-001,
	-3.061887e-001,
	3.602731e+000,
	1.255669e+000,
	-6.017540e-001,
	2.815928e-001,
	5.424052e-001,
	-6.885450e-001,
	-1.620001e-001,
	2.980046e-001,
	4.995571e-001,
	7.371203e-001,
	2.812466e-001,
	-1.278853e+000,
	-5.245326e-001,
	7.870520e-001,
	3.125067e-001,
	7.748105e-001,
	-7.788581e-002,
	3.490956e-003,
	1.283748e+000,
	8.130190e-001,
	-1.050930e+000,
	-2.786331e-001,
	1.056344e+000,
	1.053002e+000,
	-4.047789e+000,
	4.432174e-001,
	1.169077e-001,
	9.532621e-001,
	6.806764e-001,
	// albedo 1, turbidity 9
	-2.084927e+000,
	-1.203954e+000,
	-4.881638e+001,
	4.920160e+001,
	-2.896045e-003,
	2.882977e-001,
	-3.073517e-006,
	1.702211e+000,
	6.374180e-001,
	-2.328567e+000,
	-1.238023e+000,
	-1.891019e+000,
	2.451520e+000,
	-5.847581e-003,
	2.084702e-001,
	7.848130e-002,
	1.211048e+000,
	8.095008e-002,
	-2.634632e+000,
	-1.789460e+000,
	-1.370558e-001,
	-3.326435e-001,
	2.783737e-003,
	5.239451e-001,
	-2.548881e-001,
	2.896327e+000,
	1.324116e+000,
	6.882616e-002,
	5.997821e-001,
	1.535398e-001,
	1.375209e+000,
	-1.267285e-001,
	4.239743e-001,
	4.013122e-001,
	1.794675e-001,
	2.395382e-001,
	-1.430918e+000,
	-6.439041e-001,
	8.325980e-001,
	-1.705612e+000,
	7.236426e-001,
	-5.567593e-002,
	6.408718e-002,
	6.836524e-001,
	8.388887e-001,
	-1.037956e+000,
	-3.215402e-001,
	9.457349e-001,
	3.178114e+000,
	-4.152156e+000,
	2.230992e-001,
	1.156198e-001,
	7.606223e-001,
	6.656923e-001,
	// albedo 1, turbidity 10
	-2.967314e+000,
	-1.728778e+000,
	-3.730988e+001,
	3.755578e+001,
	-2.588835e-003,
	2.927966e-001,
	-3.935038e-006,
	1.592161e+000,
	6.868694e-001,
	-2.123311e+000,
	-1.175148e+000,
	-1.314988e+001,
	1.386882e+001,
	-7.828537e-003,
	1.852026e-001,
	5.481038e-002,
	1.294309e+000,
	2.428177e-002,
	-5.443597e+000,
	-3.156344e+000,
	2.110838e+000,
	-3.421556e+000,
	1.181890e-002,
	1.196951e-001,
	-1.742902e-001,
	2.404353e+000,
	1.272805e+000,
	1.029898e+000,
	5.912521e-001,
	-3.983531e-001,
	3.286069e+000,
	-9.252065e-002,
	1.331381e+000,
	2.560642e-001,
	8.001754e-001,
	3.624178e-001,
	-1.547574e+000,
	-7.881604e-001,
	1.020902e+000,
	-2.897069e+000,
	5.213470e-001,
	-9.242315e-001,
	1.185594e-001,
	-1.150721e+000,
	7.317211e-001,
	-9.621043e-001,
	-1.991406e-001,
	6.531287e-001,
	3.925839e+000,
	-3.596904e+000,
	6.317332e-001,
	1.531334e-001,
	1.457846e+000,
	6.966285e-001,
};

double datasetRGBRad3[] = 
{
	// albedo 0, turbidity 1
	9.926518e-001,
	1.999494e+000,
	-4.136109e+000,
	1.856270e+001,
	1.351028e+001,
	1.390238e+001,
	// albedo 0, turbidity 2
	9.634366e-001,
	2.119694e+000,
	-4.614523e+000,
	1.919701e+001,
	1.376644e+001,
	1.418731e+001,
	// albedo 0, turbidity 3
	9.446537e-001,
	2.171610e+000,
	-4.915556e+000,
	1.918240e+001,
	1.537135e+001,
	1.400530e+001,
	// albedo 0, turbidity 4
	9.073074e-001,
	2.330536e+000,
	-5.577596e+000,
	1.961615e+001,
	1.688365e+001,
	1.446955e+001,
	// albedo 0, turbidity 5
	8.739124e-001,
	2.388682e+000,
	-5.842995e+000,
	1.923265e+001,
	1.887735e+001,
	1.485698e+001,
	// albedo 0, turbidity 6
	8.563688e-001,
	2.391534e+000,
	-5.769133e+000,
	1.828709e+001,
	2.097209e+001,
	1.469587e+001,
	// albedo 0, turbidity 7
	8.270533e-001,
	2.342790e+000,
	-5.558071e+000,
	1.684993e+001,
	2.356498e+001,
	1.505975e+001,
	// albedo 0, turbidity 8
	7.908339e-001,
	2.190341e+000,
	-4.852571e+000,
	1.374862e+001,
	2.806846e+001,
	1.548444e+001,
	// albedo 0, turbidity 9
	7.403619e-001,
	1.783998e+000,
	-2.983854e+000,
	7.622563e+000,
	3.507610e+001,
	1.615805e+001,
	// albedo 0, turbidity 10
	6.840111e-001,
	1.154457e+000,
	-2.393830e-001,
	-7.896893e-001,
	4.282765e+001,
	1.779469e+001,
	// albedo 1, turbidity 1
	1.168300e+000,
	1.860993e+000,
	-2.129074e+000,
	1.251952e+001,
	3.032499e+001,
	2.938716e+001,
	// albedo 1, turbidity 2
	1.150338e+000,
	1.918813e+000,
	-2.413527e+000,
	1.274862e+001,
	3.087134e+001,
	2.951432e+001,
	// albedo 1, turbidity 3
	1.114719e+000,
	1.964689e+000,
	-2.625423e+000,
	1.247837e+001,
	3.237949e+001,
	2.943596e+001,
	// albedo 1, turbidity 4
	1.077948e+000,
	2.006292e+000,
	-2.846934e+000,
	1.190195e+001,
	3.459293e+001,
	2.937492e+001,
	// albedo 1, turbidity 5
	1.035143e+000,
	1.986681e+000,
	-2.752584e+000,
	1.060972e+001,
	3.722185e+001,
	2.918594e+001,
	// albedo 1, turbidity 6
	1.015992e+000,
	1.992054e+000,
	-2.812626e+000,
	1.001416e+001,
	3.847300e+001,
	2.924624e+001,
	// albedo 1, turbidity 7
	9.756887e-001,
	1.939897e+000,
	-2.533281e+000,
	8.319176e+000,
	4.083907e+001,
	2.925586e+001,
	// albedo 1, turbidity 8
	9.264164e-001,
	1.716454e+000,
	-1.597044e+000,
	4.739725e+000,
	4.507683e+001,
	2.878915e+001,
	// albedo 1, turbidity 9
	8.595191e-001,
	1.346034e+000,
	-2.801895e-002,
	-6.582906e-001,
	5.017523e+001,
	2.852953e+001,
	// albedo 1, turbidity 10
	7.754116e-001,
	7.709245e-001,
	2.200201e+000,
	-7.487661e+000,
	5.436622e+001,
	2.893432e+001,
};

double* datasetsRGB[] =
{
	datasetRGB1,
	datasetRGB2,
	datasetRGB3
};

double* datasetsRGBRad[] =
{
	datasetRGBRad1,
	datasetRGBRad2,
	datasetRGBRad3
};
