;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-merge %s primary %s.second secondary --skip-export-conflicts -all -S -o - | filecheck %s

;; Export a function with a subtype. It is imported using the supertype, and
;; after we merge, the refined return type must be updated - the call
;; instruction now returns something new.
(module
 ;; CHECK:      (type $0 (func (result anyref)))

 ;; CHECK:      (type $super (sub (func (param i32) (result anyref))))
 (type $super (sub (func (param i32) (result anyref))))

 ;; CHECK:      (type $sub (sub final $super (func (param i32) (result (ref any)))))
 (type $sub (sub final $super (func (param i32) (result (ref any)))))

 ;; CHECK:      (export "sub" (func $sub))

 ;; CHECK:      (export "caller" (func $caller))

 ;; CHECK:      (export "caller-unreachable" (func $caller-unreachable))

 ;; CHECK:      (func $sub (type $sub) (param $0 i32) (result (ref any))
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $sub (export "sub") (type $sub)
  (unreachable)
 )
)

;; CHECK:      (func $caller (type $0) (result anyref)
;; CHECK-NEXT:  (block $block (result (ref any))
;; CHECK-NEXT:   (call $sub
;; CHECK-NEXT:    (i32.const 42)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )

;; CHECK:      (func $caller-unreachable (type $0) (result anyref)
;; CHECK-NEXT:  (block $block
;; CHECK-NEXT:   (call $sub
;; CHECK-NEXT:    (unreachable)
;; CHECK-NEXT:   )
;; CHECK-NEXT:  )
;; CHECK-NEXT: )
