%feature("docstring") OT::OptimizationResult
"Optimization result.

Returned by optimization solvers, see :class:`~openturns.OptimizationAlgorithm`.

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`
    Problem being solved."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getAbsoluteError
"Accessor to the absolute error.

Returns
-------
absoluteError : float
    Absolute error of the input point :math:`\\vect{x}`, defined by :math:`\\epsilon^a_n=\\|\\vect{x}_{n+1}-\\vect{x}_n\\|_{\\infty}` where :math:`\\vect{x}_{n+1}` and :math:`\\vect{x}_n` are two consecutive approximations of the optimum."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getAbsoluteErrorHistory
"Accessor to the evolution of the absolute error.

Returns
-------
absoluteErrorHistory : :class:`~openturns.Sample`
    Value of the absolute error at each function evaluation."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getConstraintError
"Accessor to the constraint error.

Returns
-------
constraintError : float
    Constraint error, defined by :math:`\\gamma_n=\\|g(\\vect{x}_n)\\|_{\\infty}` where :math:`\\vect{x}_n` is the current approximation of the optimum and :math:`g` is the function that gathers all the equality and inequality constraints (violated values only)."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getConstraintErrorHistory
"Accessor to the evolution of the constraint error.

Returns
-------
constraintErrorHistory : :class:`~openturns.Sample`
    Value of the constraint error at each function evaluation."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setCallsNumber
"Accessor to the number calls.

Parameters
----------
callsNumber : int
    Number of objective calls."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getCallsNumber
"Accessor to the number of calls.

Returns
-------
callsNumber : int
    Number of objective calls."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setIterationNumber
"Accessor to the number of iterations.

Parameters
----------
iterationNumber : int
    Number of iterations."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getIterationNumber
"Accessor to the number of iterations.

Returns
-------
iterationNumber : int
    Number of iterations."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getRelativeError
"Accessor to the relative error.

Returns
-------
relativeError : float
    Relative error of the input point :math:`\\vect{x}`. If :math:`\\|\\vect{x}_{n+1}\\|_{\\infty}\\neq 0`, then the relative error is :math:`\\epsilon^r_n=\\epsilon^a_n/\\|\\vect{x}_{n+1}\\|_{\\infty}` where :math:`\\epsilon^a_n=\\|\\vect{x}_{n+1}-\\vect{x}_n\\|_{\\infty}` is the absolute error. Otherwise, the relative error is :math:`\\epsilon^r_n=-1`."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getRelativeErrorHistory
"Accessor to the evolution of the relative error.

Returns
-------
relativeErrorHistory : :class:`~openturns.Sample`
    Value of the relative error at each function evaluation."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getResidualError
"Accessor to the residual error.

Returns
-------
residualError : float
    Relative error, defined by :math:`\\epsilon^r_n=\\frac{\\|f(\\vect{x}_{n+1})-f(\\vect{x}_{n})\\|}{\\|f(\\vect{x}_{n+1})\\|}` if :math:`\\|f(\\vect{x}_{n+1})\\|\\neq 0`, else :math:`\\epsilon^r_n=-1`."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getResidualErrorHistory
"Accessor to the evolution of the residual error.

Returns
-------
residualErrorHistory : :class:`~openturns.Sample`
    Value of the residual error at each function evaluation."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setOptimalPoint
"Accessor to the optimal point.

Parameters
----------
optimalPoint : :class:`~openturns.Point`
    Optimal point"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getOptimalPoint
"Accessor to the optimal point.

Returns
-------
optimalPoint : :class:`~openturns.Point`
    Optimal point"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::computeLagrangeMultipliers
"Compute the Lagrange multipliers.

Parameters
----------
x : sequence of float, optional
    Location where the multipliers are computed
    If not provided, the optimal point is used

Returns
-------
lagrangeMultiplier : sequence of float
    Lagrange multipliers of the problem at point x.
    It needs an extra call to the objective function gradient unless it can be
    computed during the optimization (AbdoRackwitz or SQP).

Notes
-----
The Lagrange multipliers :math:`\\vect{\\lambda}` are associated with the following Lagrangian formulation of the optimization problem:

.. math::

    \\cL(\\vect{x}, \\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq}) = J(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{eq} g(\\vect{x}) + \\Tr{\\vect{\\lambda}}_{\\ell} (\\vect{x}-\\vect{\\ell})^{+} + \\Tr{\\vect{\\lambda}}_{u} (\\vect{u}-\\vect{x})^{+} + \\Tr{\\vect{\\lambda}}_{ineq}  h^{+}(\\vect{x})

where :math:`\\vect{\\alpha}^{+}=(\\max(0,\\alpha_1),\\hdots,\\max(0,\\alpha_n))`.

The Lagrange multipliers are stored as :math:`(\\vect{\\lambda}_{eq}, \\vect{\\lambda}_{\\ell}, \\vect{\\lambda}_{u}, \\vect{\\lambda}_{ineq})`, where:
    - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no equality
      constraint, else of dimension the dimension of :math:`g(\\vect{x})` ie the number of scalar equality constraints
    - :math:`\\vect{\\lambda}_{\\ell}` and :math:`\\vect{\\lambda}_{u}` are of dimension 0 if there is no bound constraint, else of dimension of :math:`\\vect{x}`
    - :math:`\\vect{\\lambda}_{eq}` is of dimension 0 if there is no inequality constraint, else of dimension the dimension of :math:`h(\\vect{x})` ie the number of scalar inequality constraints

The vector :math:`\\vect{\\lambda}` is solution of the following linear system:

.. math::

    \\Tr{\\vect{\\lambda}}_{eq}\\left[\\dfrac{\\partial g}{\\partial\\vect{x}}(\\vect{x})\\right]+
    \\Tr{\\vect{\\lambda}}_{\\ell}\\left[\\dfrac{\\partial (\\vect{x}-\\vect{\\ell})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
    \\Tr{\\vect{\\lambda}}_{u}\\left[\\dfrac{\\partial (\\vect{u}-\\vect{x})^{+}}{\\partial\\vect{x}}(\\vect{x})\\right]+
    \\Tr{\\vect{\\lambda}}_{ineq}\\left[\\dfrac{\\partial h}{\\partial\\vect{x}}(\\vect{x})\\right]=-\\dfrac{\\partial J}{\\partial\\vect{x}}(\\vect{x})

If there is no constraint of any kind, :math:`\\vect{\\lambda}` is of dimension 0, as well as if no constraint is active."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setOptimalValue
"Accessor to the optimal value.

Parameters
----------
optimalValue : :class:`~openturns.Point`
    Value at the optimal point"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getOptimalValue
"Accessor to the optimal value.

Returns
-------
optimalValue : :class:`~openturns.Point`
    Value at the optimal point"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getInputSample
"Accessor to the input sample.

Returns
-------
inputSample : :class:`~openturns.Sample`
    Input points used by the solver"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getOutputSample
"Accessor to the output sample.

Returns
-------
outputSample : :class:`~openturns.Sample`
    Output points used by the solver"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setProblem
"Accessor to the underlying optimization problem.

Parameters
----------
problem : :class:`~openturns.OptimizationProblem`
    Problem corresponding to the result"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getProblem
"Accessor to the underlying optimization problem.

Returns
-------
problem : :class:`~openturns.OptimizationProblem`
    Problem corresponding to the result"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::drawErrorHistory
"Draw the convergence criteria history.

Returns
-------
graph : :class:`~openturns.Graph`
    Convergence criteria history graph"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::drawOptimalValueHistory
"Draw the optimal value history.

Returns
-------
graph : :class:`~openturns.Graph`
    Optimal value history graph"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setFinalPoints
"Accessor to the final points.

Parameters
----------
finalPoints : :class:`~openturns.Sample`
    Final population"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getFinalPoints
"Accessor to the final points.

Returns
-------
finalPoints : :class:`~openturns.Sample`
    Final population.
    For non-evolutionary algorithms this will return the optimal point."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setFinalValues
"Accessor to the final values.

Parameters
----------
finalValues : :class:`~openturns.Sample`
    Values at the final points"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getFinalValues
"Accessor to the final values.

Returns
-------
finalValues : :class:`~openturns.Sample`
    Values at the final points.
    For non-evolutionary algorithms this will return the optimal value."

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getParetoFrontsIndices
"Accessor to the Pareto fronts indices in the final population.

In the multi-objective case, it consists of stratas of points in the final population.
The first front contains the best candidates according to the objectives.

Returns
-------
indices : list of :class:`~openturns.Indices`
    Pareto fronts indices"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setParetoFrontsIndices
"Accessor to the Pareto fronts indices in the final population.

Parameters
----------
indices : 2-d sequence of int
    Pareto fronts indices"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setStatusMessage
"Accessor to the specialized status string.

Parameters
----------
statusMessage : str
    Convergence or error message"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getStatusMessage
"Accessor to the specialized status string.

Returns
-------
statusMessage : str
    Convergence or error message"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setStatus
"Accessor to the generic status.

Parameters
----------
status : int
    Status flag, possible values SUCCESS, FAILURE, TIMEOUT, INTERRUPTION, MAXIMUMCALLS"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getStatus
"Accessor to the generic status.

Returns
-------
status : int
    Status flag, possible values SUCCESS, FAILURE, TIMEOUT, INTERRUPTION, MAXIMUMCALLS"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::setTimeDuration
"Accessor to the elapsed time.

Parameters
----------
time : float
    Optimization duration in seconds"

// ---------------------------------------------------------------------

%feature("docstring") OT::OptimizationResult::getTimeDuration
"Accessor to the elapsed time.

Returns
-------
time : float
    Optimization duration in seconds"
