/* 
 * Copyright (C) 2004-2006 the xine project
 * 
 * This file is part of xine, a unix video player.
 * 
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: cursors.c,v 1.4 2006/01/07 20:14:38 valtri Exp $
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include <X11/cursorfont.h>

#include "_xitk.h"

#define MAX_CURSORS  xitk_cursor_num_glyphs

#define X_CURSOR     0
#define XITK_CURSOR  1

static struct cursors_s {
  xitk_cursors_t  xitk_shape;
  unsigned int    x_shape;
  unsigned int    embedded;
  Cursor          cursor;
  Pixmap          p;
  Pixmap          mask;
} cursors[] = {
  { xitk_cursor_invisible,              0,                      XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_X_cursor,               XC_X_cursor,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_arrow,                  XC_arrow,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_based_arrow_down,       XC_based_arrow_down,    X_CURSOR,      None,  None,  None  },
  { xitk_cursor_based_arrow_up,         XC_based_arrow_up,      X_CURSOR,      None,  None,  None  },
  { xitk_cursor_boat,                   XC_boat,                X_CURSOR,      None,  None,  None  },
  { xitk_cursor_bogosity,               XC_bogosity,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_bottom_left_corner,     XC_bottom_left_corner,  XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_bottom_right_corner,    XC_bottom_right_corner, XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_bottom_side,            XC_bottom_side,         XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_bottom_tee,             XC_bottom_tee,          X_CURSOR,      None,  None,  None  },
  { xitk_cursor_box_spiral,             XC_box_spiral,          X_CURSOR,      None,  None,  None  },
  { xitk_cursor_center_ptr,             XC_center_ptr,          XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_circle,                 XC_circle,              XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_clock,                  XC_clock,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_coffee_mug,             XC_coffee_mug,          X_CURSOR,      None,  None,  None  },
  { xitk_cursor_cross,                  XC_cross,               XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_cross_reverse,          XC_cross_reverse,       X_CURSOR,      None,  None,  None  },
  { xitk_cursor_crosshair,              XC_crosshair,           X_CURSOR,      None,  None,  None  },
  { xitk_cursor_diamond_cross,          XC_diamond_cross,       X_CURSOR,      None,  None,  None  },
  { xitk_cursor_dot,                    XC_dot,                 X_CURSOR,      None,  None,  None  },
  { xitk_cursor_dotbox,                 XC_dotbox,              XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_double_arrow,           XC_double_arrow,        XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_draft_large,            XC_draft_large,         X_CURSOR,      None,  None,  None  },
  { xitk_cursor_draft_small,            XC_draft_small,         X_CURSOR,      None,  None,  None  },
  { xitk_cursor_draped_box,             XC_draped_box,          XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_exchange,               XC_exchange,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_fleur,                  XC_fleur,               XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_gobbler,                XC_gobbler,             X_CURSOR,      None,  None,  None  },
  { xitk_cursor_gumby,                  XC_gumby,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_hand1,                  XC_hand1,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_hand2,                  XC_hand2,               XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_heart,                  XC_heart,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_icon,                   XC_icon,                X_CURSOR,      None,  None,  None  },
  { xitk_cursor_iron_cross,             XC_iron_cross,          X_CURSOR,      None,  None,  None  },
  { xitk_cursor_left_ptr,               XC_left_ptr,            XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_left_side,              XC_left_side,           XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_left_tee,               XC_left_tee,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_leftbutton,             XC_leftbutton,          X_CURSOR,      None,  None,  None  },
  { xitk_cursor_ll_angle,               XC_ll_angle,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_lr_angle,               XC_lr_angle,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_man,                    XC_man,                 X_CURSOR,      None,  None,  None  },
  { xitk_cursor_middlebutton,           XC_middlebutton,        X_CURSOR,      None,  None,  None  },
  { xitk_cursor_mouse,                  XC_mouse,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_pencil,                 XC_pencil,              XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_pirate,                 XC_pirate,              X_CURSOR,      None,  None,  None  },
  { xitk_cursor_plus,                   XC_plus,                X_CURSOR,      None,  None,  None  },
  { xitk_cursor_question_arrow,         XC_question_arrow,      XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_right_ptr,              XC_right_ptr,           XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_right_side,             XC_right_side,          XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_right_tee,              XC_right_tee,           X_CURSOR,      None,  None,  None  },
  { xitk_cursor_rightbutton,            XC_rightbutton,         X_CURSOR,      None,  None,  None  },
  { xitk_cursor_rtl_logo,               XC_rtl_logo,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_sailboat,               XC_sailboat,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_sb_down_arrow,          XC_sb_down_arrow,       XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_sb_h_double_arrow,      XC_sb_h_double_arrow,   XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_sb_left_arrow,          XC_sb_left_arrow,       XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_sb_right_arrow,         XC_sb_right_arrow,      XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_sb_up_arrow,            XC_sb_up_arrow,         XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_sb_v_double_arrow,      XC_sb_v_double_arrow,   XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_shuttle,                XC_shuttle,             X_CURSOR,      None,  None,  None  },
  { xitk_cursor_sizing,                 XC_sizing,              X_CURSOR,      None,  None,  None  },
  { xitk_cursor_spider,                 XC_spider,              X_CURSOR,      None,  None,  None  },
  { xitk_cursor_spraycan,               XC_spraycan,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_star,                   XC_star,                X_CURSOR,      None,  None,  None  },
  { xitk_cursor_target,                 XC_target,              X_CURSOR,      None,  None,  None  },
  { xitk_cursor_tcross,                 XC_tcross,              X_CURSOR,      None,  None,  None  },
  { xitk_cursor_top_left_arrow,         XC_top_left_arrow,      X_CURSOR,      None,  None,  None  },
  { xitk_cursor_top_left_corner,        XC_top_left_corner,     XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_top_right_corner,       XC_top_right_corner,    XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_top_side,               XC_top_side,            XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_top_tee,                XC_top_tee,             X_CURSOR,      None,  None,  None  },
  { xitk_cursor_trek,                   XC_trek,                X_CURSOR,      None,  None,  None  },
  { xitk_cursor_ul_angle,               XC_ul_angle,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_umbrella,               XC_umbrella,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_ur_angle,               XC_ur_angle,            X_CURSOR,      None,  None,  None  },
  { xitk_cursor_watch,                  XC_watch,               X_CURSOR,      None,  None,  None  },
  { xitk_cursor_xterm,                  XC_xterm,               XITK_CURSOR,   None,  None,  None  },
  { xitk_cursor_num_glyphs,             XC_num_glyphs,          X_CURSOR,      None,  None,  None  }
};

static unsigned char no_data[] = { 
  0,0,0,0, 0,0,0,0 
};

static unsigned char bottom_left_corner_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x0f, 0x00, 0xf0, 0x0f, 0x00, 0xe0, 0x0f, 0x00, 0xc0, 0x0f,
   0x00, 0xe0, 0x0f, 0x00, 0xf0, 0x0f, 0x00, 0xf8, 0x0e, 0x60, 0x7c, 0x0c,
   0xe0, 0x3e, 0x00, 0xe0, 0x1f, 0x00, 0xe0, 0x0f, 0x00, 0xe0, 0x07, 0x00,
   0xe0, 0x0f, 0x00, 0xe0, 0x1f, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char bottom_left_corner_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xf0, 0x0f, 0x00, 0x10, 0x08, 0x00, 0x20, 0x08, 0x00, 0x40, 0x08,
   0x00, 0x20, 0x08, 0x00, 0x10, 0x09, 0x00, 0x88, 0x0a, 0x60, 0x44, 0x0c,
   0xa0, 0x22, 0x00, 0x20, 0x11, 0x00, 0x20, 0x08, 0x00, 0x20, 0x04, 0x00,
   0x20, 0x08, 0x00, 0x20, 0x10, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char bottom_right_corner_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0xf0, 0x0f, 0x00, 0xf0, 0x07, 0x00,
   0xf0, 0x03, 0x00, 0xf0, 0x07, 0x00, 0xf0, 0x0f, 0x00, 0x70, 0x1f, 0x00,
   0x30, 0x3e, 0x06, 0x00, 0x7c, 0x07, 0x00, 0xf8, 0x07, 0x00, 0xf0, 0x07,
   0x00, 0xe0, 0x07, 0x00, 0xf0, 0x07, 0x00, 0xf8, 0x07, 0x00, 0xf8, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char bottom_right_corner_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x10, 0x08, 0x00, 0x10, 0x04, 0x00,
   0x10, 0x02, 0x00, 0x10, 0x04, 0x00, 0x90, 0x08, 0x00, 0x50, 0x11, 0x00,
   0x30, 0x22, 0x06, 0x00, 0x44, 0x05, 0x00, 0x88, 0x04, 0x00, 0x10, 0x04,
   0x00, 0x20, 0x04, 0x00, 0x10, 0x04, 0x00, 0x08, 0x04, 0x00, 0xf8, 0x07,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char bottom_side_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00,
   0x00, 0x7e, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char bottom_side_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x81, 0x00, 0x00,
   0x80, 0x00, 0x01, 0x00, 0x80, 0xe7, 0x01, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x80, 0xe7, 0x01, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x81, 0x00, 0x00,
   0x00, 0x42, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char center_ptr_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char center_ptr_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x81, 0x00, 0x00,
   0x80, 0x00, 0x01, 0x00, 0x80, 0xe7, 0x01, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char circle_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
   0x1c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00,
   0xfc, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x00, 0x00, 0xfc, 0x03, 0x00, 0x00,
   0xfc, 0x07, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00,
   0xfc, 0x01, 0x00, 0x00, 0xdc, 0x03, 0x00, 0x00, 0xcc, 0x03, 0x1e, 0x00,
   0x84, 0x87, 0x7f, 0x00, 0x80, 0xc7, 0xe1, 0x00, 0x00, 0xcf, 0xc3, 0x00,
   0x00, 0x6f, 0x87, 0x01, 0x00, 0x6e, 0x8e, 0x01, 0x00, 0x60, 0x9c, 0x01,
   0x00, 0x60, 0xb8, 0x01, 0x00, 0xc0, 0xf0, 0x00, 0x00, 0xc0, 0xe1, 0x00,
   0x00, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char circle_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
   0x14, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
   0x84, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00,
   0x04, 0x04, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x04, 0x1f, 0x00, 0x00,
   0x24, 0x01, 0x00, 0x00, 0x54, 0x02, 0x00, 0x00, 0x4c, 0x02, 0x00, 0x00,
   0x84, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
   0x00, 0x09, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char cross_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01,
   0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80,
   0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x01, 0x00, 0xc0, 0xff, 0xff, 0x07,
   0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00,
   0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01,
   0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char cross_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0x07,
   0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char dotbox_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xb6, 0x1d,
   0x04, 0x00, 0x10, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10,
   0x04, 0x3c, 0x10, 0x00, 0x7f, 0x00, 0x04, 0xff, 0x10, 0x84, 0xff, 0x10,
   0x80, 0xff, 0x00, 0x84, 0xff, 0x10, 0x04, 0xff, 0x10, 0x00, 0x7f, 0x00,
   0x04, 0x1c, 0x10, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10,
   0x04, 0x00, 0x10, 0xdc, 0xb6, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char dotbox_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xb6, 0x1d,
   0x04, 0x00, 0x10, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10,
   0x04, 0x00, 0x10, 0x00, 0x60, 0x00, 0x04, 0xe0, 0x10, 0x04, 0xf8, 0x10,
   0x80, 0xfe, 0x00, 0x84, 0xff, 0x10, 0x04, 0xbf, 0x10, 0x00, 0x6f, 0x00,
   0x04, 0x1c, 0x10, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x10,
   0x04, 0x00, 0x10, 0xdc, 0xb6, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char double_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x3c, 0x00,
   0x00, 0x7e, 0x00, 0x00, 0xff, 0x00, 0x80, 0xff, 0x01, 0x80, 0xff, 0x01,
   0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x3c, 0x00, 0x80, 0xff, 0x01,
   0x80, 0xff, 0x01, 0x00, 0xff, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x3c, 0x00,
   0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char double_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x24, 0x00,
   0x00, 0x42, 0x00, 0x00, 0x81, 0x00, 0x80, 0x00, 0x01, 0x80, 0xe7, 0x01,
   0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x00, 0x24, 0x00, 0x80, 0xe7, 0x01,
   0x80, 0x00, 0x01, 0x00, 0x81, 0x00, 0x00, 0x42, 0x00, 0x00, 0x24, 0x00,
   0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char draped_box_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00,
   0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00,
   0xfc, 0x1f, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00, 0x8c, 0x18,
   0x00, 0x00, 0x00, 0x8c, 0x18, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00,
   0x00, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x00, 0xf0,
   0x07, 0x00, 0x00, 0xc0, 0xf0, 0x87, 0x01, 0x00, 0xc0, 0xe0, 0xe7, 0x00,
   0x00, 0xc0, 0xc1, 0xf3, 0x01, 0x00, 0xe0, 0x07, 0xf8, 0x01, 0x00, 0xf0,
   0x3f, 0x7e, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x00, 0x00, 0x60, 0xf8, 0x1f,
   0x03, 0x00, 0xe0, 0x7f, 0xfe, 0x03, 0x00, 0xe0, 0x0f, 0xf0, 0x01, 0x00,
   0xe0, 0x01, 0xc0, 0x01, 0x00, 0xc0, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char draped_box_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00,
   0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0x00, 0xfc, 0x1f, 0x00, 0x00, 0x00,
   0xfc, 0x1f, 0x00, 0x00, 0x00, 0xf8, 0x0f, 0x00, 0x00, 0x00, 0x88, 0x08,
   0x00, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x08, 0x18, 0x00, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x00, 0x84, 0x00, 0x00, 0xc0, 0x20, 0x26, 0x00,
   0x00, 0xc0, 0x41, 0x63, 0x01, 0x00, 0xa0, 0x03, 0x18, 0x01, 0x00, 0xe0,
   0x0e, 0x4c, 0x00, 0x00, 0x00, 0x98, 0x03, 0x00, 0x00, 0x60, 0xe0, 0x1c,
   0x02, 0x00, 0xc0, 0x5f, 0xd8, 0x03, 0x00, 0xc0, 0x06, 0x00, 0x01, 0x00,
   0x40, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char fleur_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x7e, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x80, 0xff, 0x01, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x60, 0x3c, 0x06, 0x00, 0x70, 0x3c, 0x0e, 0x00,
   0x78, 0x3c, 0x1e, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0xfe, 0xff, 0x7f, 0x00,
   0xfe, 0xff, 0x7f, 0x00, 0xfc, 0xff, 0x3f, 0x00, 0x78, 0x3c, 0x1e, 0x00,
   0x70, 0x3c, 0x0e, 0x00, 0x60, 0x3c, 0x06, 0x00, 0x80, 0xff, 0x01, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char fleur_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x42, 0x00, 0x00, 0x00, 0x81, 0x00, 0x00, 0x80, 0x00, 0x01, 0x00,
   0x80, 0xe7, 0x01, 0x00, 0x60, 0x24, 0x06, 0x00, 0x50, 0x24, 0x0a, 0x00,
   0x48, 0x24, 0x12, 0x00, 0xc4, 0xe7, 0x23, 0x00, 0x02, 0x00, 0x40, 0x00,
   0x02, 0x00, 0x40, 0x00, 0xc4, 0xe7, 0x23, 0x00, 0x48, 0x24, 0x12, 0x00,
   0x50, 0x24, 0x0a, 0x00, 0x60, 0x24, 0x06, 0x00, 0x80, 0xe7, 0x01, 0x00,
   0x80, 0x00, 0x01, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char hand2_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00,
   0x00, 0xf8, 0x0f, 0x00, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0xfe, 0x7f, 0x00,
   0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
   0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
   0x00, 0xff, 0xff, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00, 0xfe, 0xff, 0x00,
   0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0x00, 0xfc, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char hand2_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
   0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00,
   0x00, 0x48, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0xc8, 0x01, 0x00,
   0x00, 0x48, 0x0e, 0x00, 0x00, 0x48, 0x32, 0x00, 0x00, 0x4e, 0x52, 0x00,
   0x00, 0x4b, 0x92, 0x00, 0x00, 0x09, 0x90, 0x00, 0x00, 0x09, 0x80, 0x00,
   0x00, 0x09, 0x80, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x01, 0x80, 0x00,
   0x00, 0x01, 0x80, 0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x02, 0xc0, 0x00,
   0x00, 0x04, 0x40, 0x00, 0x00, 0x04, 0x60, 0x00, 0x00, 0xfc, 0x3f, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char left_ptr_mask_bits[] = {
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0e, 0x00, 0x00,
   0x1e, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0xfe, 0x00, 0x00,
   0xfe, 0x01, 0x00, 0xfe, 0x03, 0x00, 0xfe, 0x07, 0x00, 0xfe, 0x0f, 0x00,
   0xfe, 0x00, 0x00, 0xee, 0x01, 0x00, 0xe6, 0x01, 0x00, 0xc2, 0x03, 0x00,
   0xc0, 0x03, 0x00, 0x80, 0x07, 0x00, 0x80, 0x07, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char left_ptr_bits[] = {
   0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0a, 0x00, 0x00,
   0x12, 0x00, 0x00, 0x22, 0x00, 0x00, 0x42, 0x00, 0x00, 0x82, 0x00, 0x00,
   0x02, 0x01, 0x00, 0x02, 0x02, 0x00, 0x02, 0x04, 0x00, 0x82, 0x0f, 0x00,
   0x92, 0x00, 0x00, 0x2a, 0x01, 0x00, 0x26, 0x01, 0x00, 0x42, 0x02, 0x00,
   0x40, 0x02, 0x00, 0x80, 0x04, 0x00, 0x80, 0x04, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char left_side_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0xc0, 0x01, 0x07, 0x00,
   0xe0, 0x01, 0x0f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0x3f, 0x00,
   0xf8, 0xff, 0x3f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xe0, 0x01, 0x0f, 0x00,
   0xc0, 0x01, 0x07, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char left_side_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x40, 0x01, 0x05, 0x00,
   0x20, 0x01, 0x09, 0x00, 0x10, 0xff, 0x11, 0x00, 0x08, 0x00, 0x20, 0x00,
   0x08, 0x00, 0x20, 0x00, 0x10, 0xff, 0x11, 0x00, 0x20, 0x01, 0x09, 0x00,
   0x40, 0x01, 0x05, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char pencil_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00,
   0xf0, 0x01, 0x00, 0x00, 0xe0, 0x03, 0x00, 0x00, 0xc0, 0x07, 0x00, 0x00,
   0x80, 0x0f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00,
   0x00, 0x7c, 0x00, 0x00, 0x00, 0xf8, 0x04, 0x00, 0x00, 0xf0, 0x0d, 0x00,
   0x00, 0xe0, 0x1f, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x7f, 0x00,
   0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xfc, 0x00,
   0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char pencil_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
   0x18, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00,
   0x70, 0x01, 0x00, 0x00, 0x60, 0x02, 0x00, 0x00, 0xc0, 0x04, 0x00, 0x00,
   0x80, 0x09, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00,
   0x00, 0x4c, 0x00, 0x00, 0x00, 0xb8, 0x04, 0x00, 0x00, 0x70, 0x0d, 0x00,
   0x00, 0xe0, 0x1e, 0x00, 0x00, 0xc0, 0x35, 0x00, 0x00, 0x80, 0x6b, 0x00,
   0x00, 0x00, 0xd7, 0x00, 0x00, 0x00, 0xae, 0x00, 0x00, 0x00, 0xdc, 0x00,
   0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char question_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x02, 0xf8, 0x03, 0x06, 0x9c, 0x07, 0x0e, 0x0e, 0x0f,
   0x1e, 0x0e, 0x0f, 0x3e, 0x0e, 0x0f, 0x7e, 0x0e, 0x07, 0xfe, 0x80, 0x03,
   0xfe, 0xc1, 0x01, 0xfe, 0xe3, 0x00, 0xfe, 0xe7, 0x00, 0xfe, 0xef, 0x00,
   0xfe, 0x00, 0x00, 0xee, 0xe1, 0x00, 0xe6, 0xf1, 0x01, 0xc2, 0xe3, 0x00,
   0xc0, 0x03, 0x00, 0x80, 0x07, 0x00, 0x80, 0x07, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char question_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x02, 0xf8, 0x03, 0x06, 0x9c, 0x07, 0x0a, 0x0e, 0x0f,
   0x12, 0x0e, 0x0f, 0x22, 0x0e, 0x0f, 0x42, 0x0e, 0x07, 0x82, 0x80, 0x03,
   0x02, 0xc1, 0x01, 0x02, 0xe2, 0x00, 0x02, 0xe4, 0x00, 0x82, 0xef, 0x00,
   0x92, 0x00, 0x00, 0x2a, 0xe1, 0x00, 0x26, 0xf1, 0x01, 0x42, 0xe2, 0x00,
   0x40, 0x02, 0x00, 0x80, 0x04, 0x00, 0x80, 0x04, 0x00, 0x00, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char right_ptr_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x3f, 0x00, 0x80, 0x3f, 0x00,
   0xc0, 0x3f, 0x00, 0xe0, 0x3f, 0x00, 0xf0, 0x3f, 0x00, 0xf8, 0x3f, 0x00,
   0x80, 0x3f, 0x00, 0xc0, 0x3b, 0x00, 0xc0, 0x33, 0x00, 0xe0, 0x21, 0x00,
   0xe0, 0x01, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x70, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char right_ptr_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x30, 0x00, 0x00, 0x28, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x22, 0x00, 0x00, 0x21, 0x00, 0x80, 0x20, 0x00,
   0x40, 0x20, 0x00, 0x20, 0x20, 0x00, 0x10, 0x20, 0x00, 0xf8, 0x20, 0x00,
   0x80, 0x24, 0x00, 0x40, 0x2a, 0x00, 0x40, 0x32, 0x00, 0x20, 0x21, 0x00,
   0x20, 0x01, 0x00, 0x90, 0x00, 0x00, 0x90, 0x00, 0x00, 0x70, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char right_side_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0xc0, 0x01, 0x07, 0x00,
   0xe0, 0x01, 0x0f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0x3f, 0x00,
   0xf8, 0xff, 0x3f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xe0, 0x01, 0x0f, 0x00,
   0xc0, 0x01, 0x07, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char right_side_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x40, 0x01, 0x05, 0x00,
   0x20, 0x01, 0x09, 0x00, 0x10, 0xff, 0x11, 0x00, 0x08, 0x00, 0x20, 0x00,
   0x08, 0x00, 0x20, 0x00, 0x10, 0xff, 0x11, 0x00, 0x20, 0x01, 0x09, 0x00,
   0x40, 0x01, 0x05, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_down_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0xff, 0x00, 0x00,
   0x00, 0x7e, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_down_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x80, 0xe7, 0x01, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0x81, 0x00, 0x00,
   0x00, 0x42, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_h_double_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0xc0, 0x01, 0x07, 0x00,
   0xe0, 0x01, 0x0f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf8, 0xff, 0x3f, 0x00,
   0xf8, 0xff, 0x3f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xe0, 0x01, 0x0f, 0x00,
   0xc0, 0x01, 0x07, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_h_double_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x40, 0x01, 0x05, 0x00,
   0x20, 0x01, 0x09, 0x00, 0x10, 0xff, 0x11, 0x00, 0x08, 0x00, 0x20, 0x00,
   0x08, 0x00, 0x20, 0x00, 0x10, 0xff, 0x11, 0x00, 0x20, 0x01, 0x09, 0x00,
   0x40, 0x01, 0x05, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_left_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00,
   0xe0, 0x01, 0x00, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0xf8, 0xff, 0x0f, 0x00,
   0xf8, 0xff, 0x0f, 0x00, 0xf0, 0xff, 0x0f, 0x00, 0xe0, 0x01, 0x00, 0x00,
   0xc0, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_left_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00,
   0x20, 0x01, 0x00, 0x00, 0x10, 0xff, 0x0f, 0x00, 0x08, 0x00, 0x08, 0x00,
   0x08, 0x00, 0x08, 0x00, 0x10, 0xff, 0x0f, 0x00, 0x20, 0x01, 0x00, 0x00,
   0x40, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_right_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0xfe, 0xff, 0x01, 0x00, 0xfe, 0xff, 0x03, 0x00, 0xfe, 0xff, 0x03, 0x00,
   0xfe, 0xff, 0x01, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_right_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00,
   0xfe, 0x1f, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00,
   0xfe, 0x1f, 0x01, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_up_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
   0x80, 0xff, 0x01, 0x00, 0x80, 0xff, 0x01, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_up_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x81, 0x00, 0x00,
   0x80, 0x00, 0x01, 0x00, 0x80, 0xe7, 0x01, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char sb_v_double_arrow_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0xc0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char sb_v_double_arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x40, 0x08, 0x00, 0x00, 0x20, 0x10, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00,
   0xf0, 0x3c, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0xf0, 0x3c, 0x00, 0x00,
   0x10, 0x20, 0x00, 0x00, 0x20, 0x10, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char top_left_corner_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00,
   0xfc, 0x03, 0x00, 0xfc, 0x01, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x01, 0x00,
   0xfc, 0x03, 0x00, 0xdc, 0x07, 0x00, 0x8c, 0x8f, 0x01, 0x00, 0xdf, 0x01,
   0x00, 0xfe, 0x01, 0x00, 0xfc, 0x01, 0x00, 0xf8, 0x01, 0x00, 0xfc, 0x01,
   0x00, 0xfe, 0x01, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char top_left_corner_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00,
   0x04, 0x02, 0x00, 0x04, 0x01, 0x00, 0x84, 0x00, 0x00, 0x04, 0x01, 0x00,
   0x24, 0x02, 0x00, 0x54, 0x04, 0x00, 0x8c, 0x88, 0x01, 0x00, 0x51, 0x01,
   0x00, 0x22, 0x01, 0x00, 0x04, 0x01, 0x00, 0x08, 0x01, 0x00, 0x04, 0x01,
   0x00, 0x02, 0x01, 0x00, 0xfe, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char top_right_corner_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0xfe, 0x01,
   0x00, 0xfc, 0x01, 0x00, 0xf8, 0x01, 0x00, 0xfc, 0x01, 0x00, 0xfe, 0x01,
   0x00, 0xdf, 0x01, 0x8c, 0x8f, 0x01, 0xdc, 0x07, 0x00, 0xfc, 0x03, 0x00,
   0xfc, 0x01, 0x00, 0xfc, 0x00, 0x00, 0xfc, 0x01, 0x00, 0xfc, 0x03, 0x00,
   0xfc, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static unsigned char top_right_corner_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0x00, 0x02, 0x01,
   0x00, 0x04, 0x01, 0x00, 0x08, 0x01, 0x00, 0x04, 0x01, 0x00, 0x22, 0x01,
   0x00, 0x51, 0x01, 0x8c, 0x88, 0x01, 0x54, 0x04, 0x00, 0x24, 0x02, 0x00,
   0x04, 0x01, 0x00, 0x84, 0x00, 0x00, 0x04, 0x01, 0x00, 0x04, 0x02, 0x00,
   0xfc, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

static unsigned char top_side_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0xc0, 0x0f, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00,
   0xf0, 0x3f, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0x00,
   0x80, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char top_side_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x40, 0x08, 0x00, 0x00, 0x20, 0x10, 0x00, 0x00, 0x10, 0x20, 0x00, 0x00,
   0xf0, 0x3c, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0xf0, 0x3c, 0x00, 0x00,
   0x10, 0x20, 0x00, 0x00, 0x20, 0x10, 0x00, 0x00, 0x40, 0x08, 0x00, 0x00,
   0x80, 0x04, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };

static unsigned char xterm_mask_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
   0x00, 0x3f, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };
static unsigned char xterm_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x7f, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
   0x00, 0x08, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00 };


static void _cursors_create_cursor(Display *display, struct cursors_s *cursor) {
  XColor  bg, fg;
  
  bg.red   = 255 << 8;
  bg.green = 255 << 8;
  bg.blue  = 255 << 8;
  fg.red   = 0;
  fg.green = 0;
  fg.blue  = 0;
  
  XLOCK(display);
  switch(cursor->xitk_shape) {

  case xitk_cursor_invisible:
    {
      XColor black = xitk_get_black_pixel_color();
      
      cursor->p      = XCreateBitmapFromData(display, DefaultRootWindow(display), no_data, 8, 8);
      cursor->cursor = XCreatePixmapCursor(display, cursor->p, cursor->p, &black, &black, 0, 0);
    }
    break;

  case xitk_cursor_hand2:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)hand2_bits, 32, 32);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)hand2_mask_bits, 32, 32);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_bottom_left_corner:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_left_corner_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_left_corner_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;
    
  case xitk_cursor_bottom_right_corner:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_right_corner_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_right_corner_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_bottom_side:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_side_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)bottom_side_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_center_ptr:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)center_ptr_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)center_ptr_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_circle:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)circle_bits, 32, 32);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)circle_mask_bits, 32, 32);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_cross:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)cross_bits, 34, 32);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)cross_mask_bits, 34, 32);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_dotbox:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)dotbox_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)dotbox_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_double_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)double_arrow_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)double_arrow_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_draped_box:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)draped_box_bits, 38, 36);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)draped_box_mask_bits, 38, 36);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;
  
  case xitk_cursor_fleur:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)fleur_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)fleur_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;
    
  case xitk_cursor_sb_h_double_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_h_double_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_h_double_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_sb_left_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_left_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_left_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_sb_right_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_right_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_right_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_sb_up_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_up_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_up_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_sb_down_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_down_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_down_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_sb_v_double_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_v_double_arrow_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)sb_v_double_arrow_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_top_left_corner:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_left_corner_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_left_corner_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_top_right_corner:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_right_corner_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_right_corner_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_top_side:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_side_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)top_side_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_xterm:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)xterm_bits, 26, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)xterm_mask_bits, 26, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_question_arrow:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)question_arrow_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)question_arrow_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_left_ptr:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)left_ptr_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)left_ptr_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_right_ptr:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)right_ptr_bits, 24, 24);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)right_ptr_mask_bits, 24, 24);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_right_side:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)right_side_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)right_side_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_left_side:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)left_side_bits, 25, 25);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)left_side_mask_bits, 25, 25);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  case xitk_cursor_pencil:
    cursor->p       = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)pencil_bits, 32, 32);
    cursor->mask    = XCreateBitmapFromData(display, DefaultRootWindow(display), (char *)pencil_mask_bits, 32, 32);
    cursor->cursor  = XCreatePixmapCursor(display, cursor->p, cursor->mask, &fg, &bg, 0, 0);
    break;

  default:
    XITK_WARNING("cursor unhandled: %d. Fallback to X one.\n", cursor->xitk_shape);
    cursors->cursor = XCreateFontCursor(display, cursor->x_shape);
    break;
  }
  XUNLOCK(display);
}

void xitk_cursors_init(Display *display) {
  int   i;
  int   xitk_cursors = xitk_get_cursors_feature();

  /* Transparent cursor isn't a valid X cursor */
  _cursors_create_cursor(display, &cursors[0]);
  
  for(i = 1; i < MAX_CURSORS; i++) {
    
    if(xitk_cursors) {
      if(cursors[i].embedded == X_CURSOR) {
	XLOCK(display);
	cursors[i].cursor = XCreateFontCursor(display, cursors[i].x_shape);
	XUNLOCK(display);
      }
      else
	_cursors_create_cursor(display, &cursors[i]);
    }
    else {
      XLOCK(display);
      cursors[i].cursor = XCreateFontCursor(display, cursors[i].x_shape);
      XUNLOCK(display);
    }
  }
}

void xitk_cursors_deinit(Display *display) {
  int i;
  
  XLOCK(display);
  for(i = 0; i < MAX_CURSORS; i++) {
    XFreeCursor(display, cursors[i].cursor);
    
    if(cursors[i].embedded == XITK_CURSOR) {
      if(cursors[i].p != None)
	XFreePixmap(display, cursors[i].p);
      if(cursors[i].mask != None)
	XFreePixmap(display, cursors[i].mask);
    }

  }
  XUNLOCK(display);
}

/* Public */
void xitk_cursors_define_window_cursor(Display *display, Window window, xitk_cursors_t cursor) {
  if(window != None) {
    XLOCK(display);
    XDefineCursor(display, window, cursors[cursor].cursor);
    XSync(display, False);
    XUNLOCK(display);
  }
}

void xitk_cursors_restore_window_cursor(Display *display, Window window) {
  if(window != None) {
    XLOCK(display);
    XUndefineCursor(display, window);
    XSync(display, False);
    XUNLOCK(display);
  }
}
