.TH "sane\-pixma" "5" "8 Jan 2010" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-pixma
.SH NAME
.B sane\-pixma 
\- SANE backend for Canon PIXMA Multi-Functions Printers
.br 
             MP, MX, ImageCLASS and I-SENSYS series
.SH DESCRIPTION
The
.B sane\-pixma
library implements a SANE (Scanner Access Now Easy) backend that provides
access to Canon PIXMA multi-function devices (All-in-one printers).
The backend implements both USB interface and Network LAN interface
using Canon's BJNP protocol.
Currently, the following models work with this backend:
.PP
.RS
PIXMA MP140, MP150, MP160, MP170, MP180, MP190
.br
PIXMA MP210, MP220, MP240, MP250, MP260, MP270
.br
PIXMA MP360, MP370, MP390
.br
PIXMA MP450, MP460, MP470, MP480, MP490
.br
PIXMA MP500, MP510, MP520, MP530, MP540, MP550, MP560
.br
PIXMA MP600, MP600R, MP610, MP620, MP630, MP640, MP710
.br
PIXMA MP800, MP800R, MP810, MP830, MP960, MP970, MP980, MP990
.br
PIXMA MX300, MX310, MX330, MX340, MX350
.br
PIXMA MX700, MX850, MX860, MX870, MX7600
.br
PIXMA MP700, MP730, PIXMA MP750 (no grayscale)
.br
ImageCLASS MF3110, MF3240, MF4010, MF4018, MF4120, MF4122
.br
ImageCLASS MF4140, MF4150, MF4270, MF4350d, MF4370dn, MF4380dn
.br
ImageCLASS MF4660, MF4690, MF5770, MF6550, D480
.br
I-SENSYS MF4320d, MF4330d
.br
CanoScan 8800F
.RE
.PP
The following models are not well tested and/or the scanner sometimes hangs
and must be switched off and on.
.PP
.RS
PIXMA PIXMA MP760, PIXMA MP780
.RE
.PP
The following models may use the same Pixma protocol as those listed 
above, but have not yet been reported to work (or not). They are declared 
in the backend so that they get recognized and activated. 
Feedback in the Sane-dev mailing list welcome.
.PP
.RS
PIXMA MP375R, MP740
.br
PIXMA MX320
.br
ImageCLASS MF5630, MF5650, MF5730, MF5750, MF8170c
.RE
.PP
\#The following models may use partly the same Pixma protocol as MPs listed
\#above, but may still need some work. They are declared in the backend as 
\#experimental. Snoop logs are required to further investigate, please contact 
\#the sane\-devel mailing list.
\#.PP
\#.RS
\#PIXMA MP---
\#.RE
The backend supports:
.PP
.RS
* resolutions of 75, 150, 300, 600, 1200, 2400, and 4800 DPI (some maybe buggy),
.br
* color and grayscale mode, as well as lineart on certain models,
.br
* a custom gamma table,
.br
* Automatic Document Feeder, Simplex and Duplex.
.br
* Transparency Unit, 24 or 48 bits depth.
.RE
.PP
The device name for USB devices is in the form pixma:xxxxyyyy_zzzzz
where x, y and z are vendor ID, product ID and serial number respectively.
Example: pixma:04A91709_123456 is a MP150.
.PP
Device names for BJNP devices is in the form pixma:aaaa_bbbbb
where aaaa is the scanners model and bbbb is the hostname or ip-adress.
.PP
This backend, based on cloning original Canon drivers protocols, is in 
a production stage. Designed has been carried out without any applicable
manufacturer documentation, probably never available. However, we have tested 
it as well as we could, but it may not work in every situations. You will find 
an up-to-date status at the project homepage. (See below). 
Users feedback is essential to help improve features and performances. 
.SH OPTIONS
Besides "well-known" options (e.g. resolution, mode etc.) pixma backend also
provides the following
\#.B experimental
options for button handling, i.e. the options might change in the future.
.br
Button scan is disabled on MAC OS X due to darwin libusb not handling
timeouts in usb interrupt reads. 
.TP
.I button\-controlled
This option can be used in combination with
.BR scanadf (1)
and
.BR scanimage (1)
in batch mode, for example when you want to scan many photos or
multiple-page documents. If it is enabled (i.e. is set to true or yes), the
backend waits before every scan until the user presses the "SCAN" button
(for MP150) or the color-scan button (for other models). Just put the
first page in the scanner, press the button, then the next page, press
the button and so on. When you finished, press the gray-scan button. (For
MP150 you have to stop the frontend by pressing Ctrl-C for example.)
.TP
.I button\-update button\-1 button\-2
These options are interesting for developers. To check button status: (1) set
.I button\-1
and
.I button\-2
to zero, (2) set
.I button-update
(Its type is SANE_TYPE_BUTTON.), (3) get
.I button\-1
and
.IR button\-2 .
If the result is not zero, the corresponding button was pressed.
.SH FILES
.TP
.I @LIBDIR@/libsane\-pixma.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-pixma.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I @CONFIGDIR@/pixma.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below). The files contains an optional list of scanners. Normally only scanners
that can not be auto-detected because they are on a different subnet shall be
listed here. If your OS does not allow enumeration of interfaces (i.e. it does not
support the getifaddrs() function) you may need to add your scanner here as well.
Scanners shall be listed as:
.PP
.RS
.I bjnp://<host>
.RE
.RS
where host is the hostname or IP address of the scanner, e.g. bjnp://10.0.1.4 or
bjnp://myscanner.mydomain.org. Define each scanner on a new line.
.SH USB SUPPORT
USB scanners will be auto-detected and require no configuration.
.SH NETWORKING SUPPORT
The pixma backend supports network scanners using the so called Canon BJNP protocol.
Configuration is normally not required.
The pixma backend will auto-detect your scanner if it is within
the same subnet as your computer if your OS does support this.

If your scanner can not be auto-detected, you can add it to the pixma configuration
file (see above).
.SH FIREWALLING FOR NETWORKED SCANNERS
The sane pixma backend communicates with port 8612 on the scanner. So
you will have to allow outgoing traffic TO port 8612 on the common subnet
for scanning.

Scanner detection is slightly more complicated. The pixma backend sends
a broadcast on all direct connected subnets it can find (provided your OS allows for enumeration
of all interfaces). The broadcast is sent FROM port
8612 TO port 8612 on the broadcast address of each interface.
The outgoing packets will be allowed by the rule described above.
Responses from the scanner are sent back to the computer TO port 8612.
Connection tracking however does not see a match as the response does not come
from the broadcast address but from the scanners own address.
You will therefore have to allow incoming packets TO port 8612 on your computer.

So in short: open the firewall for all traffic from your computer to port 8612 AND
to port 8612 to your computer.

With the firewall rules above there is no need to add the scanner to the
pixma.conf file, unless the scanner is on a network that is not directly
connected to your computer.
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_PIXMA
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend. Higher value increases
the verbosity.
.PP
.RS
0  print nothing (default)
.br
1  print error and warning messages (recommended)
.br
2  print informational messages
.br
3  print debug-level messages
.br
11 dump USB/BJNP traffics
.br
21 full dump USB/BJNP traffic
.br
.RE
.TP
.B PIXMA_EXPERIMENT
Setting to a non-zero value will enable the support for experimental models.
You should also set SANE_DEBUG_PIXMA to 11.
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.SH "SEE ALSO"
.BR sane (7),
.BR sane\-dll (5),
.I http://home.arcor.de/wittawat/pixma/,
.I http://mp610.blogspot.com/
.PP
In case of trouble with a recent Pixma model, try the latest code for 
the pixma backend, available in the Sane git repository at:
.br
.I http://git.debian.org/?p=sane/sane-backends.git
.PP
You can also post into the Sane-devel mailing list for support.

.SH AUTHORS
Wittawat Yamwong, Nicolas Martin, Dennis Lou, Louis Lagendijk
.PP
We would like to thank all testers and helpers. Without them we could not be
able to write subdrivers for models we don't have. See also the project
homepage.
