/*#define DEBUG*/
/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define SPLIT_VIEW
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>
#include <glob.h>
#include <grp.h>
#include <pwd.h>
#include <dirent.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "add_file.h"
#include "aux.h"
#include "misc.h"
#include "menu.h"
#include "callbacks.h"
#include "dnd.h"
#include "dummies.h"
#include "entry.h"
#include "filter.h"
#include "icons.h"
#include "help.h"
#include "monitor.h"
#include "options.h"
#include "refresh.h"
#include "reg.h"
#include "settings.h"
#include "treeview.h"
#include "treestore.h"
#include "widgets.h"
#include "smb/smb_misc.h"
#include "libs/input.h"

#include "preferences.i"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define LOCAL_OVERRIDE_MASK (SHOW_MM|SHOW_TB1|SHOW_TB2|SHOW_F|SHOW_TITLES|RSH_X_SSH|RSYNC_X_SCP)


extern int geometryX, geometryY, hpane;
extern char *auto_C_name[];
extern char *auto_CC_name[];
extern char *auto_D_name[];
extern char *auto_DD_name[];
extern gchar *bookfile;
extern GList *theme_list;
extern gchar *xffm_argv0;

static GtkTreeRowReference *Rref=NULL,*Lref=NULL;

/*XXX for gtk bug workaround with flashing treeview on expand/collapse
 * ater scroll if root not visible: */
GtkTreeViewColumn *name_column;

#ifdef SPLIT_VIEW
gboolean double_treeview=TRUE;
#else
gboolean double_treeview=FALSE;
#endif

root_t root[] = {
	{ROOT_BOOKMARKS, N_("/XFFM_BOOKMARKS"), N_("Book"), __BOOKMARK_TYPE},
	{ROOT_FILES, N_("/XFFM_FILES"), N_("Local"), __LOCAL_TYPE},
	{ROOT_NETWORK, N_("/XFFM_NETWORK"), N_("SMB Network"), __NETWORK_TYPE},
	{ROOT_APP, N_("/XFFM_APP"), N_("Applications"), __APP_TYPE},
	{ROOT_FIND, N_("/XFFM_FIND"), N_("Find"), __FIND_TYPE},
	{ROOT_TRASH, N_("/XFFM_TRASH"), N_("Trash"), __TRASH_TYPE}
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
     	,{ROOT_FSTAB, N_("/XFFM_FSTAB"), N_("Fstab"), __FSTAB_TYPE}
#endif
};

void menu_detach(void)
{
    /*printf ("dbg:menu_detach()\n"); */
}

void set_path_reference(GtkTreeView *treeview,GtkTreePath *ipath){
    	tree_details_t *tree_details = get_tree_details(treeview);
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	if (tree_details->treeview==treeview){
		if (Rref) gtk_tree_row_reference_free(Rref);
		if (!ipath) Rref=NULL;
		else Rref= gtk_tree_row_reference_new(treemodel, ipath);
	} else {
		if (Lref) gtk_tree_row_reference_free(Lref);
		if (!ipath) Lref=NULL;
		else Lref= gtk_tree_row_reference_new(treemodel, ipath);
	}
}
static void show_alt_treeview(GtkWidget * parent)
{
    GtkWidget *vpaned;
    if(!parent)
	return;
    /*printf("DBG:show_text\n");*/
    vpaned = lookup_widget(parent, "hpaned1");
    if (gtk_paned_get_position((GtkPaned *)vpaned) < vpaned->allocation.height * 0.40)
       gtk_paned_set_position(GTK_PANED(vpaned), vpaned->allocation.height * 0.40);
}
static void hide_alt_treeview(GtkWidget * parent)
{
    GtkWidget *vpaned;
    if(!parent)
	return;
    /*printf("DBG:show_text\n");*/
    vpaned = lookup_widget(parent, "hpaned1");
    gtk_paned_set_position(GTK_PANED(vpaned), 0);
}

static void status_the_path(GtkTreeView *treeview, GtkTreePath *ipath,tree_entry_t *en)
	    {
		gchar *readable_path;
    		/*GtkTreeModel *treemodel =
		 * gtk_tree_view_get_model(treeview);*/
    		tree_details_t *tree_details = get_tree_details(treeview);
		
		
		readable_path=g_strdup(FILENAME(en));
		if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype))
			ascii_readable(readable_path);
		print_status_tmp(treeview, resolve_icon_small(en), 
				readable_path,
				NULL);
		g_free(readable_path);readable_path=NULL;
		turn_on(treeview);
	    }

static gboolean null_motion(GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GtkTreeView *w = (GtkTreeView *) lookup_widget(widget, "treeview");
    print_status(w, NULL, NULL);
    return FALSE;
}

static void create_menu_entry(char *name,char *label,GtkWidget *parent,
		GtkWidget *main_window,void *callback,void *data){
  GtkWidget *w,*image;
  w = gtk_image_menu_item_new_with_label (label);
  gtk_container_add (GTK_CONTAINER (parent), w);
  image = gtk_image_new_from_stock ("gtk-execute", GTK_ICON_SIZE_MENU);
  gtk_widget_show (image);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (w), image);
  g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (callback),
                   data);
  GLADE_HOOKUP_OBJECT (main_window, w, name);
}

static void add_autotype_C_widgets(GtkTreeView * treeview){
  int i;
  GtkWidget *open1_menu,*open2_menu;
  tree_details_t *tree_details = get_tree_details(treeview);
  open1_menu = lookup_widget(tree_details->window, "open1_menu");
  open2_menu = lookup_widget(tree_details->window, "open2_menu");
  
  create_menu_entry("autotype_Prun",_("Execute"),open1_menu,
		tree_details->window,(void *)on_autotype_run,NULL);
  create_menu_entry("autotype_Mrun",_("Execute"),open2_menu,
		tree_details->window,(void *)on_autotype_run,NULL);
#if HAVE_GETMNTENT || HAVE_GETMNTINFO
  {
   GtkWidget *w;
   w = lookup_widget(tree_details->window, "mountM");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)0));
   w = lookup_widget(tree_details->window, "mountP");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)0));
   w = lookup_widget(tree_details->window, "unmountM");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)1));
   w = lookup_widget(tree_details->window, "unmountP");
   g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_mount),(gpointer)((long)1));

  }
#else
  hideit(tree_details->window,"mountM");
  hideit(tree_details->window,"unmountM");
  hideit(tree_details->window,"mountP");
  hideit(tree_details->window,"unmountP");
#endif
	  
  
 for (i=0;auto_C_name[i];i++){
    create_menu_entry(auto_C_name[i]," ",open1_menu,tree_details->window,
		    (void *)on_autotype_C,(gpointer)((long)i));
 }
 for (i=0;auto_D_name[i];i++){
    create_menu_entry(auto_D_name[i]," ",open1_menu,tree_details->window,
		    (void *)on_autotype_D,(gpointer)((long)i));
 }
  
/*  create_menu_entry("autotype_DD","DD",open2_menu,tree_details->window,
		    (void *)on_autotype_D,NULL);*/
  create_menu_entry("autotype_RR","RR",open2_menu,tree_details->window,
		    (void *)on_autotype_R,NULL);
  
  for (i=0;auto_CC_name[i];i++){
      create_menu_entry(auto_CC_name[i],"CC",open2_menu,tree_details->window,
		    (void *)on_autotype_C,(gpointer)((long)i));
  }
  for (i=0;auto_DD_name[i];i++){
      create_menu_entry(auto_DD_name[i],"DD",open2_menu,tree_details->window,
		    (void *)on_autotype_D,(gpointer)((long)i));
  }
}

static void add_preferences_items(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkWidget *w, *menu;
    int i;
    GSList *l;
    GList *tmp;
    menu = lookup_widget(tree_details->window, "preferences3_menu");
    l = gtk_accel_groups_from_object((GObject *) tree_details->window);
    if(!l || !l->data)	g_assert_not_reached();

    for (i=0;preferences_titles[i].label;i++)
    {
	w = gtk_check_menu_item_new_with_label(_(preferences_titles[i].label));
	if(tree_details->preferences & preferences_titles[i].flag)
	{
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), TRUE);
	}

	if (preferences_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				preferences_titles[i].key, 
				GDK_SHIFT_MASK|GDK_CONTROL_MASK,
				GTK_ACCEL_VISIBLE);
	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_preference), 
			(gpointer) ((long)preferences_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			preferences_titles[i].xml_option);
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	gtk_widget_show(w);
    }

    menu = lookup_widget(tree_details->window, "columns1_menu");
   
   for (i=0;opt_col_titles[i].label;i++)
    {
	w = gtk_check_menu_item_new_with_label(_(opt_col_titles[i].label));
	if(tree_details->preferences & opt_col_titles[i].flag)
	{
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), TRUE);
	}

	if (opt_col_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				opt_col_titles[i].key, 
				0, GTK_ACCEL_VISIBLE);

	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_preference), 
			(gpointer) ((long)opt_col_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			opt_col_titles[i].xml_option);
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	if (strcmp(opt_col_titles[i].xml_option,"SHOW_MM") &&
	    strcmp(opt_col_titles[i].xml_option,"SHOW_TB1") &&		
	    strcmp(opt_col_titles[i].xml_option,"SHOW_TB2") &&		
	    strcmp(opt_col_titles[i].xml_option,"SHOW_F") &&		
	    strcmp(opt_col_titles[i].xml_option,"SHOW_TITLES") 
	   )    gtk_widget_show(w);
    }

    menu = lookup_widget(tree_details->window, "views1_menu");
   for (i=0;opt_view_titles[i].label;i++)
    {
	w = gtk_menu_item_new_with_label(_(opt_view_titles[i].label));

	if (opt_view_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				opt_view_titles[i].key, 
				GDK_SHIFT_MASK, GTK_ACCEL_VISIBLE);
	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_preference), 
			(gpointer) ((long)opt_view_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			opt_view_titles[i].xml_option);
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	gtk_widget_show(w);
    }
   
    menu = lookup_widget(tree_details->window, "themes1_menu");
   for (tmp=theme_list;tmp;tmp=tmp->next)
    {
	w = gtk_menu_item_new_with_label((char *)tmp->data);

	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_theme), 
			(gpointer) (tmp->data));
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	gtk_widget_show(w);
    }
    
    menu = lookup_widget(tree_details->window, "remote1_menu");
   for (i=0;opt_remote_titles[i].label;i++)
    {
	w = gtk_check_menu_item_new_with_label(_(opt_remote_titles[i].label));
	if(tree_details->preferences & opt_remote_titles[i].flag)
	{
	    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(w), TRUE);
	}

	if (opt_remote_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				opt_remote_titles[i].key, 
				GDK_SHIFT_MASK|GDK_CONTROL_MASK,
				/*GDK_MOD3_MASK,*/
			       	GTK_ACCEL_VISIBLE);
	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(toggle_preference), 
			(gpointer) ((long)opt_remote_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			opt_remote_titles[i].xml_option);
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	gtk_widget_show(w);
    }
   
    menu = lookup_widget(tree_details->window, "activate1_menu");
   for (i=0;opt_branches_titles[i].label;i++)
    {
	w = gtk_menu_item_new_with_label(_(opt_branches_titles[i].label));

	if (opt_branches_titles[i].key){
		gtk_widget_add_accelerator(w, "activate", 
				(GtkAccelGroup *) (l->data), 
				opt_branches_titles[i].key, 
				GDK_SHIFT_MASK|GDK_CONTROL_MASK,
			       	GTK_ACCEL_VISIBLE);
	}
	g_signal_connect((gpointer) w, "activate", 
			G_CALLBACK(on_activate_branch), 
			(gpointer) ((long)opt_branches_titles[i].flag));
  	GLADE_HOOKUP_OBJECT (tree_details->window, w, 
			opt_branches_titles[i].xml_option);
	gtk_menu_shell_insert(GTK_MENU_SHELL(menu), w, i);
	gtk_widget_show(w);
    }

    
}


void create_root_element(GtkTreeView * treeview, GtkTreeIter *iterator,
		int i,const gchar *home){
    tree_entry_t *en;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    
	gchar *name;
    	gchar *tag;
	if(i == ROOT_FILES)
	{
	    if (!home) g_assert_not_reached();	
	    if((en = stat_entry((char *)home, 0)) == NULL) g_assert_not_reached();
	    SET_LOCAL_TYPE(en->type);
	}
	else
	{
	    if((en = mk_entry(0)) == NULL) g_assert_not_reached();
	    en->type |= (root[i].type);	/* hack */
	}
	SET_ROOT_TYPE(en->type);
	if (tree_details->preferences & IMAGE_PREVIEW) 
		SET_SHOWS_IMAGES(en->type);
	if (tree_details->preferences & SHOW_DOT) 
		SET_SHOWS_HIDDEN(en->type);
	if (tree_details->preferences & FILETYPE_SUBS) 
		SET_TYPE_SUBSORT(en->type);
	en->tag = NULL;
	tag = g_strdup(my_utf_string(_(root[i].label)));
	
	gtk_tree_store_append((GtkTreeStore *) treemodel, iterator, NULL);
	if(i == ROOT_FILES)
	{
	    name = FILENAME(en);
	    en->count = -1;
	}
	else if(i == ROOT_BOOKMARKS && bookfile)
	{
	    name = my_utf_string(bookfile);
	    /* this is bugged: en->path=g_strdup(bookfile);
	     * en->path for bookmarks operations should not be used in other modules
	     * to eliminate this bug */
	    en->path = g_strdup(_(root[i].path));	    
	}
	else 
	{
	    name = tag;
	    en->path = g_strdup(_(root[i].path));
	}
	/* icon size set by config-file or xfce-mcs-manager(default) */
	switch (tree_details->icon_size)
	{
	    case 0:
		SET_SIZE_S(en->type);
		break;
	    case 1:
		SET_SIZE_M(en->type);
		break;
	    default:
	    case 2:
		SET_SIZE_L(en->type);
		break;
	    case 3:
		SET_SIZE_XL(en->type);
		break;
	}
	if (tree_details->preferences & FILETYPE_SUBS){
		SET_TYPE_SUBSORT(en->type);
	}

	gtk_tree_store_set((GtkTreeStore *) treemodel, iterator, 
			ENTRY_COLUMN, en, 
			NAME_COLUMN, name, -1);
	set_icon(treeview, iterator);
	add_dummy(treeview, iterator);
	switch (i)
	{
	    case ROOT_FILES:
		update_columns(treemodel, iterator, en);
		break;
	    case ROOT_FIND:
		reset_dummy(treeview, iterator, 2);
		break;
	    /*case ROOT_BOOKMARKS:
		reset_dummy(treeview, iterator, 3);
		break;*/
	    default:
		break;
	}
	g_free(tag);tag=NULL;
}

static void add_roots(GtkTreeView * treeview, char *home)
{
    int i;
    GtkTreeIter iter;
    const char *var;
    
    for(i = 0; i < ROOT_TAGS; i++)
    {
	gboolean will_show;
	will_show=TRUE;
	switch(i){
	  case ROOT_BOOKMARKS:
		if ((var = getenv("XFFM_HIDE_BOOK")) && strlen(var)) will_show=FALSE;
		break;
	  case ROOT_FILES:
		if ((var = getenv("XFFM_HIDE_LOCAL")) && strlen(var)) will_show=FALSE;
		break;
	  case ROOT_NETWORK:
		if ((var = getenv("XFFM_HIDE_NETWORK")) && strlen(var)) will_show=FALSE;
		break;
	  case ROOT_APP:
		if ((var = getenv("XFFM_HIDE_APPS")) && strlen(var)) will_show=FALSE;
		break;
	  case ROOT_FIND:
		if ((var = getenv("XFFM_HIDE_FIND")) && strlen(var)) will_show=FALSE;
		break;
	  case ROOT_TRASH:
		if ((var = getenv("XFFM_HIDE_TRASH")) && strlen(var)) will_show=FALSE;
		break;
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	  case ROOT_FSTAB:
		if ((var = getenv("XFFM_HIDE_FSTAB")) && strlen(var)) will_show=FALSE;
		break;
#endif
	  default:
		will_show=FALSE;
		break;
	}
	if (will_show) create_root_element(treeview,&iter,i,home);
    }
    return;
}



/* additional key bindings for the tree */
static gboolean treeview_key(GtkWidget *w,
		GdkEventKey *event,gpointer data){
	GtkTreeView *treeview=(GtkTreeView *)w;
    	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    	tree_details_t *tree_details = get_tree_details(treeview);
	    GtkTreePath *ipath=NULL;
	GtkTreeIter iter,iter2;
	static gboolean lock=FALSE;
        tree_entry_t *en=NULL;
	if (tree_details->loading){
#ifdef DEBUG	
			printf("DBG: ignoring key...\n");
#endif
		return TRUE;
	}
	if (lock) {
#ifdef DEBUG	
		printf("DBG: keys locked!\n");
#endif			
		return TRUE;
	}
#ifdef DEBUG	
	printf("DBG: keyval=0x%x state=0x%x, mod3=0x%x\n",
			event->keyval,event->state,GDK_MOD4_MASK);
#endif
	switch (event->keyval){
		case GDK_Control_L:
		case GDK_Control_R:
		case GDK_Shift_L:
		case GDK_Shift_R:
		case GDK_Caps_Lock:
		case GDK_Shift_Lock:
		case GDK_Meta_L:
		case GDK_Meta_R:
		case GDK_Alt_L:
		case GDK_Alt_R:
			return TRUE;
		/*case GDK_MOD3_MASK | GDK_minus :*/
		case GDK_minus :
		case GDK_KP_Subtract :
		/*case GDK_Super_L:*/
			/*printf("DBG:mask=0x%x, control=0x%x\n",event->state,GDK_CONTROL_MASK);*/
			if (!(event->state&GDK_CONTROL_MASK)) return FALSE;
#ifdef DEBUG	
		printf("DBG: toggle view down\n");
		
#endif		
		if (tree_details->icon_size>0)	
		     tb_toggleview((GtkButton *)w,(gpointer)((long)TRUE));
			return TRUE;
		case GDK_plus:
		case GDK_KP_Add:
		/*case GDK_Super_R:*/
			if (!(event->state&GDK_CONTROL_MASK)) return FALSE;
#ifdef DEBUG	
			printf("DBG: toggle view up\n");
#endif			
		if (tree_details->icon_size<3)	
  			tb_toggleview((GtkButton *)w,NULL);
			return TRUE;

		default: break;
			
	}
	
	
	switch (event->keyval){
		case GDK_Print:
			tb_print((GtkButton *)w,NULL);
			return TRUE;
		case GDK_Execute:
			on_run_activate((GtkMenuItem *)w, NULL);
			return TRUE;
		case GDK_Delete:
			on_remove_activate((GtkMenuItem *)w, NULL);
			return TRUE;
		/*case GDK_U :
			if (!(event->state&GDK_CONTROL_MASK)) break;
			on_unselect_activate((GtkMenuItem *)w, NULL);		
			return TRUE;*/
		case GDK_Tab:
		{
			GtkTreeRowReference **ref;
    			GtkTreeSelection *selection2; 
			GtkTreeView *treeview2;
			lock=TRUE;
			on_unselect_activate((GtkMenuItem *)treeview,NULL);
			if ((event->state&GDK_CONTROL_MASK)){
				treeview2=tree_details->treeview;
				ref=&Rref;
				hide_alt_treeview((GtkWidget *)treeview);
			} else {	
			  if (tree_details->treeview==treeview){
				ref=&Lref;
				treeview2=(GtkTreeView *)lookup_widget((GtkWidget *)treeview, "treeview2");
				show_alt_treeview((GtkWidget *)treeview);
			  } else {
				treeview2=tree_details->treeview;
				ref=&Rref;
			  }
			}
			selection2 = gtk_tree_view_get_selection(treeview2);



			
			if (*ref && gtk_tree_row_reference_valid(*ref)) {
				ipath=gtk_tree_row_reference_get_path(*ref);
				
			} else {
				if (*ref) gtk_tree_row_reference_free(*ref);
				ipath=gtk_tree_path_new_first();
				*ref=gtk_tree_row_reference_new(treemodel, ipath);
			}
			
					
			gtk_widget_grab_focus((GtkWidget *) treeview2);
    		  	gtk_tree_view_set_cursor (treeview2,ipath,NULL,FALSE);
			gtk_tree_selection_select_path(selection2,ipath);
			
			gtk_tree_model_get_iter(treemodel, &iter, ipath);
			gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);

			if (en) status_the_path(treeview,ipath,en);
			
			gtk_tree_path_free(ipath);
		        lock=FALSE;
			turn_on(treeview);
 
			return TRUE;
		}
		case GDK_Menu:
		case GDK_F12:
		{	 
			GtkTreePath *selectpath=NULL;
			tree_details->selectionOK=0;
    			gtk_tree_selection_selected_foreach(selection, 
		    		count_selection, (gpointer) treeview);
			if (tree_details->selectionOK==0) return TRUE;
			if (tree_details->selectionOK==1){
			  gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
			  if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
  		   	  gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
			  gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
			  if (!en) return FALSE;
			  selectpath=gtk_tree_model_get_path (treemodel,&iter);
			}
			do_select_popup(treeview, selectpath,0);
			if (selectpath) gtk_tree_path_free(selectpath);
			return TRUE;
		}
		case GDK_Escape:
			on_unselect_activate((GtkMenuItem *)w,NULL);
			return TRUE;
		default: break;
	}

	/* this will leave only one selected */
	
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_BROWSE);
	if(gtk_tree_selection_get_selected(selection, &treemodel, &iter))
  		   gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

	if ((event->keyval >= GDK_space && event->keyval <= GDK_asciitilde) || 
	    (event->keyval >= GDK_KP_Multiply && event->keyval <= GDK_KP_9)  
	    )
	{
	    char c;
	    gchar *f;
	    int emergency=0;
	    gboolean second_letter_match=FALSE;
	    gchar *a=NULL,*b=NULL;
	    if (event->keyval >= GDK_space && event->keyval <= GDK_asciitilde)
		c=event->keyval;
	    else switch (event->keyval){
		case GDK_KP_0: c=GDK_0; break;
		case GDK_KP_1: c=GDK_1; break;
		case GDK_KP_2: c=GDK_2; break;
		case GDK_KP_3: c=GDK_3; break;
		case GDK_KP_4: c=GDK_4; break;
		case GDK_KP_5: c=GDK_5; break;
		case GDK_KP_6: c=GDK_6; break;
		case GDK_KP_7: c=GDK_7; break;
		case GDK_KP_8: c=GDK_8; break;
		case GDK_KP_9: c=GDK_9; break;
		case GDK_KP_Multiply: c=GDK_asterisk; break;
		case GDK_KP_Add: c=GDK_plus; break;
		case GDK_KP_Separator: c=GDK_space; break;
		case GDK_KP_Subtract: c=GDK_minus; break;
		case GDK_KP_Decimal: c=GDK_period; break;
		case GDK_KP_Divide: c=GDK_slash; break;
		default : c=0x7f; break;
	    }
	    /*printf ("state=0x%x\n",event->state);*/
	    /* Use windows key modifier to do second letter match */
	    if (event->state & GDK_MOD4_MASK) second_letter_match=TRUE;

#ifdef DEBUG	
	    printf("DBG: alphabeta keyval=0x%x\n",event->keyval);
#endif			
	    if (!en) {
		if (!gtk_tree_model_get_iter_first (treemodel,&iter))
		    return FALSE;
	    } 	    
	    if (ipath) gtk_tree_path_free(ipath);	
	    ipath=gtk_tree_model_get_path(treemodel, &iter);
	    
	    a=gtk_tree_path_to_string(ipath);
    	    gtk_tree_model_get(treemodel, &iter, NAME_COLUMN, &f, ENTRY_COLUMN, &en, -1);
#ifdef DEBUG	
	    printf("DBG: startpath=%s\n",a);
#endif	    
	    do {
		GtkTreeIter parent;
		if (!gtk_tree_model_get_iter (treemodel,&iter,ipath)) {
			printf("xffm:treeview.c this is unreachable (728)\n");
			break;
		}
			
		if (gtk_tree_view_row_expanded (treeview,ipath)){
			gtk_tree_path_down (ipath);
			if (!gtk_tree_model_get_iter (treemodel,&iter,ipath)){
			    printf("xffm:treeview.c this is unreachable (735)\n");
			    break;
			}			
		} else {
		     gtk_tree_path_next (ipath);
		     if (gtk_tree_model_get_iter (treemodel,&iter2,ipath)) iter=iter2;
		     else {
			if (gtk_tree_model_iter_parent (treemodel,&iter2,&iter)){
			  if (gtk_tree_model_iter_next (treemodel,&iter2))iter=iter2;
			  else {
		              gtk_tree_model_get_iter_first (treemodel,&iter);
			  } 
			} else {
				gtk_tree_model_get_iter_first (treemodel,&iter);
			}
		     }
		}
		
		if (ipath) gtk_tree_path_free(ipath);	
		ipath=gtk_tree_model_get_path(treemodel, &iter);
		
    		gtk_tree_model_get(treemodel, &iter, NAME_COLUMN, &f, ENTRY_COLUMN, &en, -1);
		emergency++;
		if (!f || !strlen(f)) {
#ifdef DEBUG	
	    		printf("DBG: treemodel_get returns null for name column cell!\n");
#endif			
			continue;
		}
		/*printf("DBG:(%s,%s) %d==%d ... emergency=%d\n",en->path,f,*f,c,emergency);fflush(NULL);*/
		if (second_letter_match && strlen(f)>1) f++;
		if (*f == c){
			gdk_flush();
    			gtk_tree_view_scroll_to_cell(treeview, ipath, 
					NULL, TRUE, 0.0, 0.0);
			gtk_tree_selection_select_path(selection,ipath);
       			gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
			if (en) status_the_path(treeview,ipath,en);	
			set_path_reference (treeview,ipath);
			break;
		} 
		g_free(b);
		b=gtk_tree_path_to_string(ipath);
#ifdef DEBUG	
	    printf("DBG: skipping to path=%s\n",b);
#endif	
	    } while (strcmp(a,b) && emergency<20000);
	    if (emergency >= 20000){
		    /* this should never happen */
		    print_diagnostics(treeview,"xf_ERROR_ICON", 
			"unreachable code reached! (treeview.c 790) ", 
			strerror(ETIMEDOUT),"\n",NULL);
	    }
	    g_free(a);
	    g_free(b);
	    a=b=NULL;
    	    if (ipath) gtk_tree_path_free(ipath);
	    return FALSE;
	}	    
	
	if (!en) return FALSE;
        if(tree_details->input)	cancel_input(treeview);
	
	switch (event->keyval){
		default: break;
	        case GDK_Find:
			 tb_find((GtkButton *)w,NULL);
			 return TRUE;
		case GDK_Down:
#ifdef DEBUG
		     printf("DBG:gdk down...state=0x%x, mod3 is 0x%x\n",
				     event->state,GDK_MOD3_MASK);
#endif
	        case GDK_Up:
			if (event->state&GDK_SHIFT_MASK) return FALSE;
		         lock=TRUE;
#ifdef DEBUG	
		         printf("DBG: lock #1!\n");
#endif			
	    		if (!en) {
			  if (!gtk_tree_model_get_iter_first (treemodel,&iter))
		          lock=FALSE;
		    	  return FALSE;
	    		} 
	    		ipath=gtk_tree_model_get_path(treemodel, &iter);
			if (event->keyval==GDK_Down) {
				GtkTreeIter iter2;
				if (gtk_tree_view_row_expanded (treeview,ipath)){
					gtk_tree_path_down (ipath);
				} else {
					gtk_tree_path_next (ipath);
				}
				if (!gtk_tree_model_get_iter (treemodel,&iter2,ipath)){
					if (!gtk_tree_model_iter_next(treemodel,&iter)){
				  	   gtk_tree_path_free(ipath);
				  	   lock=FALSE;
		    	  	  	   return FALSE;
					}
	    				ipath=gtk_tree_model_get_path(treemodel, &iter);
				}
			}
			if (event->keyval==GDK_Up) {
				GtkTreePath *rpath=gtk_tree_path_new_first();
				if (gtk_tree_path_compare (rpath,ipath)==0){
				  gtk_tree_path_free(ipath);
				  gtk_tree_path_free(rpath);
				  lock=FALSE;
		    	  	  return FALSE;
				}
				gtk_tree_path_free(rpath);
				if (!gtk_tree_path_prev (ipath)) gtk_tree_path_up(ipath);
			}
			
			set_path_reference(treeview,ipath);
		    	gtk_widget_grab_focus((GtkWidget *) treeview);
    		  	gtk_tree_view_set_cursor (treeview,ipath,NULL,FALSE);
			gtk_tree_selection_select_path(selection,ipath);
			
			gtk_tree_model_get_iter(treemodel, &iter, ipath);
			gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);

			if (en) status_the_path(treeview,ipath,en);
			/* scrolling with alt key */	
			if (event->state&GDK_MOD1_MASK){
				/*get selected path ++*/
			     gdk_flush();
			     gtk_tree_view_scroll_to_cell(treeview, ipath, NULL, TRUE, 0.0, 0.0);
			}
			
			gtk_tree_path_free(ipath);
		        lock=FALSE;
#ifdef DEBUG	
			printf("DBG: unlock #1!\n");
#endif			
		    	return TRUE;
		case GDK_Right:
		{
			lock=TRUE;
#ifdef DEBUG	
			printf("DBG: lock #2...\n");
#endif			
			if (gtk_tree_model_iter_has_child(treemodel,&iter))
			{
    			     GtkTreePath *treepath;
#ifdef DEBUG	
			printf("DBG: lock #2a...path=%s\n",(en->path)?en->path:"null");
#endif			
			     treepath = gtk_tree_model_get_path(treemodel, &iter);
			     gtk_tree_view_expand_row(treeview, treepath, FALSE);
		    	     gtk_tree_path_free(treepath);
			     turn_on(treeview);
			     lock=FALSE;
#ifdef DEBUG	
			     printf("DBG: unlock #2a!\n");
#endif			
			     return TRUE;
			}
#if 0
/* better leave this to the return key only */			
			if (IS_LOCAL_TYPE(en->type) && IS_DIR(en->type)){
#ifdef DEBUG	
			printf("DBG: lock #2aa...path=%s\n",(en->path)?en->path:"null");
#endif			
			     go_to(treeview, en->path);
			     turn_on(treeview);
#ifdef DEBUG	
		 	     printf("DBG: unlock #2aa!\n");
#endif			
			     lock=FALSE;
			     return TRUE;
			}
#endif
			/* otherwise, -> is a return: */
		}
		case GDK_Return:
			 lock=TRUE;
#ifdef DEBUG	
			 printf("DBG: lock #2b!\n");
#endif			
			 on_double_click_activate((GtkMenuItem *)w,
					(gpointer) treeview);
			 lock=FALSE;
#ifdef DEBUG	
			 printf("DBG: unlock #2b!\n");
#endif			
			 return TRUE;
			 break;
		case GDK_Left:
			lock=TRUE;
#ifdef DEBUG	
			printf("DBG: lock #3!\n");
#endif			
			
			if (!gtk_tree_model_iter_has_child(treemodel,&iter)){
			 lock=FALSE;
			 return FALSE;
			}

	
			 
			if (gtk_tree_model_iter_has_child(treemodel,&iter))
			{
    			     GtkTreePath *treepath;
			     treepath = gtk_tree_model_get_path(treemodel, &iter);
			     gtk_tree_view_collapse_row(treeview, treepath);
		    	     gtk_tree_path_free(treepath);
			     turn_on(treeview);
			} 
#if 0
  /* as above, this is left to return on the .. element */
			else {
#ifdef DEBUG	
			printf("DBG: 3 >>> tb_go_up!\n");
#endif			
				tb_go_up((GtkButton *)w,NULL);
			}
#endif
			lock=FALSE;
#ifdef DEBUG	
			printf("DBG: unlock #3!\n");
#endif			
			return TRUE;
			
			break;
	}
		
	return FALSE;
}

/***********  treeview ******************/
typedef struct menu_checks_t
{
    unsigned flag;
    char *name;
}
menu_checks_t;


GtkTreeView *create_treeview(char *path)
{
    int i, j;
    GtkTreeViewColumn *column;
    GtkTreeView *treeview;
#ifdef SPLIT_VIEW
    GtkTreeView *treeview2;
#endif
    GtkTreeStore *treestore;
    GtkCellRenderer *cell;
    struct stat st;
    tree_details_t *tree_details;
    static gboolean do_icons = TRUE;
    gchar *d_path=NULL;


    if(path) d_path=g_strdup(path);
    else d_path=g_strdup(get_xffm_home());
     /* chop off any trailing slashes */
    if(strlen(d_path) > 1 && d_path[strlen(d_path) - 1] == '/')
	d_path[strlen(d_path) - 1] = 0;

    if(stat(d_path, &st) < 0)
    {
	g_free(d_path);    
	d_path = g_strdup("/");
	if(stat(d_path, &st) < 0) g_assert_not_reached();
    }

    if((tree_details = (tree_details_t *) malloc(sizeof(tree_details_t))) == NULL)
	g_assert_not_reached();

    if((tree_details->window = create_xffm()) == NULL)
	g_assert_not_reached();



    if((treestore = create_treestore()) == NULL)
	g_assert_not_reached();
    /*printf("DBG: GTK_TREE_STORE (tree_model)->n_columns=%d\n",GTK_TREE_STORE (treestore)->n_columns);*/

    if((treeview = (GtkTreeView *) gtk_tree_view_new_with_model(GTK_TREE_MODEL(treestore))) == NULL)
	g_assert_not_reached();
    
#ifdef SPLIT_VIEW
    if((treeview2 = (GtkTreeView *) gtk_tree_view_new_with_model(GTK_TREE_MODEL(treestore))) == NULL)
	g_assert_not_reached();
     gtk_tree_view_set_headers_visible(treeview2,FALSE);
#endif

    tree_details->timer = 0;
    tree_details->remove = NULL;
    tree_details->loading = 0;
    tree_details->tubo_object = NULL;
    tree_details->theme = g_strdup("gnome");

    tree_details->treeview = treeview;
    tree_details->gogo = (golist *) malloc(sizeof(golist));
    tree_details->gogo->next = tree_details->gogo->previous = NULL;
    tree_details->gogo->path = g_strdup(d_path);

    g_object_set_data(G_OBJECT(treeview), "tree_details", (gpointer) tree_details);

    g_object_set_data(G_OBJECT(tree_details->window), "treeview", (gpointer) treeview);
    
#ifdef SPLIT_VIEW
    g_object_set_data(G_OBJECT(treeview2), "tree_details", (gpointer) tree_details);
    g_object_set_data(G_OBJECT(tree_details->window), "treeview2", (gpointer) treeview2);
#endif

    {
	unsigned local_pref;
	get_local_xffm_config(&tree_details);
	local_pref=tree_details->preferences;
        gtk_window_set_default_size(GTK_WINDOW(tree_details->window), geometryX, geometryY);
	if (hpane > 0) {
		GtkWidget *hpaned=lookup_widget(tree_details->window, "hpaned1");
		gtk_paned_set_position(GTK_PANED(hpaned), hpane);
	}
	/*get_xffm_config(&tree_details);
	tree_details->preferences &= (LOCAL_OVERRIDE_MASK ^ 0xffffffff);
	tree_details->preferences  |= (local_pref & LOCAL_OVERRIDE_MASK);*/
    }
    if(do_icons)
    {
	create_icons(tree_details);
	do_icons = FALSE;
    }



    {
	GtkTreeSelection *selection = gtk_tree_view_get_selection(tree_details->treeview);
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
/*	  gtk_tree_selection_set_mode (selection,GTK_SELECTION_BROWSE);*/
    }
#ifdef SPLIT_VIEW
    {
	GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview2);
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    }
#endif

    /* empty margin column. Do not remove */
    column = gtk_tree_view_column_new();
    cell = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "text", EMPTY_COLUMN, 
		    NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect(G_OBJECT(column), "clicked", G_CALLBACK(titles_off), (gpointer) treeview);


    /* create the label column */
    name_column = column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_reorderable(column, TRUE);
    gtk_tree_view_column_set_spacing(column,2);

    cell = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);


    cell = gtk_cell_renderer_text_new();
    /*g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); */
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "style", STYLE_COLUMN, 
		    "font-desc", FONT_COLUMN, 
		    "text", NAME_COLUMN, 
		    NULL);

    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
    gtk_tree_view_set_expander_column(treeview, column);


    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
    gtk_tree_view_column_set_title(column, my_utf_string(_("Name")));


#ifdef SPLIT_VIEW
    column = gtk_tree_view_column_new();
    gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
    /* no problem here with GTK bug, since there is only one column: */
    gtk_tree_view_column_set_resizable(column, FALSE);
    gtk_tree_view_column_set_spacing(column,2);

    cell = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "pixbuf", PIXBUF_COLUMN, 
		    "pixbuf_expander_closed", PIXBUF_COLUMN, 
		    "pixbuf_expander_open", PIXBUF_COLUMN, 
		    NULL);


    cell = gtk_cell_renderer_text_new();
    /*g_object_set (G_OBJECT (cell), "editable",TRUE,NULL); */
    gtk_tree_view_column_pack_start(column, cell, FALSE);
    gtk_tree_view_column_set_attributes(column, cell, 
		    "style", STYLE_COLUMN, 
		    "font-desc", FONT_COLUMN, 
		    "text", NAME_COLUMN, 
		    NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(treeview2), column);
    gtk_tree_view_set_expander_column(treeview2, column);
    cell = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
#endif
   
/*    {
	gchar *s;
	gsize r_bytes, w_bytes;
	s = g_strdup(_("Name"));
	gtk_tree_view_column_set_title(column, s);
	g_free(s);
    }*/
    gtk_tree_view_column_set_clickable(column, TRUE);
    g_signal_connect_object(column, "clicked", G_CALLBACK(on_name_click), treeview, 0);


    for(i = SIZE_COLUMN, j = SIZE_COL; i < TREE_COLUMNS; i++, j++)
    {
	char *texto;
	cell = gtk_cell_renderer_text_new();
	g_object_set(G_OBJECT(cell), "editable", FALSE, NULL);
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_GROW_ONLY);
	gtk_tree_view_column_set_resizable(column, TRUE);
	gtk_tree_view_column_set_reorderable(column, TRUE);

	gtk_tree_view_column_pack_start(column, cell, FALSE);
	switch (i)
	{
	    case SIZE_COLUMN:
		texto = _("Size");
		g_signal_connect_object(column, "clicked", G_CALLBACK(on_size_click), treeview, 0);
		tree_details->column[j] = column;
		break;
	    case DATE_COLUMN:
		texto = _("Date");
		g_signal_connect_object(column, "clicked", G_CALLBACK(on_date_click), treeview, 0);
		tree_details->column[j] = column;
		break;
	    case OWNER_COLUMN:
		texto = _("Owner");
		g_signal_connect_object(column, "clicked", G_CALLBACK(on_uid_click), treeview, 0);
		tree_details->column[j] = column;
		break;
	    case GROUP_COLUMN:
		texto = _("Group");
		g_signal_connect_object(column, "clicked", G_CALLBACK(on_gid_click), treeview, 0);
		tree_details->column[j] = column;
		break;
	    case MODE_COLUMN:
		texto = _("Mode");
		tree_details->column[j] = column;
		break;
	    default:
		texto = NULL;
	}
	gtk_tree_view_column_set_attributes(column, cell,  
			"font-desc", FONT_COLUMN, 
			"text", i, NULL);
	
	/* translated texts should already be in UTF-8 format 
	 * (in Leibnitz' world) */
	if(texto){
	    gtk_tree_view_column_set_title(column,my_utf_string(texto));
	}
/*	{
	    gchar *s;
	    gsize r_bytes, w_bytes;
	    s = g_strdup(texto);
	    gtk_tree_view_column_set_title(column, s);
	    g_free(s);
	}*/
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	gtk_tree_view_column_set_clickable(column, TRUE);
    }


    gtk_widget_show(GTK_WIDGET(treeview));
    gtk_container_add(GTK_CONTAINER(lookup_widget(tree_details->window, "treeview_scroll")), 
		    GTK_WIDGET(treeview));
    g_signal_connect_object(treeview, "row-expanded", G_CALLBACK(open_dir), treeview, 0);
    g_signal_connect_object(treeview, "row-collapsed", G_CALLBACK(close_dir), treeview, 0);


    g_signal_connect(treeview, "button-press-event", G_CALLBACK(treeclick), treeview);
/* g_signal_connect works better than g_signal_connect_object, sometimes */
    g_signal_connect_object(treeview, "button-release-event", 
		    G_CALLBACK(button_releaseF), treeview, G_CONNECT_AFTER);

    add_roots(treeview, d_path);
    
#ifdef SPLIT_VIEW
    gtk_widget_show(GTK_WIDGET(treeview2));
    gtk_container_add(GTK_CONTAINER(lookup_widget(tree_details->window, "treeview_scroll2")), 
		    GTK_WIDGET(treeview2));
    g_signal_connect_object(treeview2, "row-expanded", G_CALLBACK(open_dir), treeview2, 0);
    g_signal_connect_object(treeview2, "row-collapsed", G_CALLBACK(close_dir), treeview2, 0);


    g_signal_connect(treeview2, "button-press-event", G_CALLBACK(treeclick), treeview2);
/* g_signal_connect works better than g_signal_connect_object, sometimes */
    g_signal_connect_object(treeview2, "button-release-event", 
		    G_CALLBACK(button_releaseF), treeview2, G_CONNECT_AFTER);

#endif

    gtk_widget_show(tree_details->window);

    g_signal_connect(G_OBJECT(tree_details->window), 
		    "destroy_event", G_CALLBACK(on_xffm_destroy_event), (gpointer) tree_details);
    g_signal_connect(G_OBJECT(tree_details->window), 
		    "delete_event", G_CALLBACK(on_xffm_delete_event), (gpointer) tree_details);
    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "salir1")), 
		    "activate", G_CALLBACK(on_close_activate), (gpointer) tree_details);

    gtk_combo_disable_activate((GtkCombo *) lookup_widget(tree_details->window, "filter_combo"));
    gtk_combo_disable_activate((GtkCombo *) lookup_widget(tree_details->window, "input_combo"));

    tree_details->diagnostics = GTK_TEXT_VIEW(lookup_widget(tree_details->window, "textview1"));
    tree_details->status = GTK_TEXT_VIEW(lookup_widget(tree_details->window, "textview2"));
    /*show_text(tree_details->window); */
    hide_text(tree_details->window);
    hideit(tree_details->window, "stop");
    hideit(tree_details->window, "input_box");

    {
	GtkWidget *menu;
	hideit(tree_details->window, "menubar2");
	menu = lookup_widget(tree_details->window, "item22_menu");
	gtk_menu_detach((GtkMenu *) menu);
	gtk_menu_attach_to_widget(GTK_MENU(menu), (GtkWidget *) treeview, 
			(GtkMenuDetachFunc) menu_detach);
    }

    {
	int i;
	/* NOTICE: keep names[] order in sync with on_sort_activate() 
	 * at libs/refresh.c */
	char *names[] = {  
	    "subsort_by_file_type1",
	    "name1",
	    "date1",
	    "size1",
	    "owner1",
	    "group1",
	    "show_hidden1",
	    "ascending1",
	    "preview_images1",
	    NULL
	};
	for(i = 0; names[i]; i++)
	{
	    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, names[i])), 
			    "activate", 
			    GTK_SIGNAL_FUNC(on_sort_activate), 
			    (gpointer) ((long)i));
	}
    }

    gtk_combo_set_case_sensitive(GTK_COMBO(lookup_widget(tree_details->window, 
				    "input_combo")), TRUE);
    gtk_combo_set_case_sensitive(GTK_COMBO(lookup_widget(tree_details->window, 
				    "filter_combo")), TRUE);
    tree_details->loading = FALSE;
#ifdef SPLIT_VIEW
    setup_drag_signal(treeview2);
#endif
    setup_drag_signal(treeview);

    {				/* status should not accept drops nor input */
	GtkWidget *w;
	/*
	   w=lookup_widget(tree_details->window,"textview1");
	   g_signal_connect (G_OBJECT (w), "drag_motion", 
	   G_CALLBACK(null_motion), NULL);
	   gtk_text_view_set_editable ((GtkTextView *)w,FALSE);
	 */

	w = lookup_widget(tree_details->window, "textview2");
	g_signal_connect(G_OBJECT(w), "drag_motion", G_CALLBACK(null_motion), NULL);
	gtk_text_view_set_editable((GtkTextView *) w, FALSE);
    }

    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "show_mm")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_MM));
    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "hide_mm")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_MM));

    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "show_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));
    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "hide_tb1")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB1));

    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "show_tb2")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB2));
    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "hide_tb2")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TB2));

    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "show_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));
    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "hide_f")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_F));

    g_signal_connect(G_OBJECT(lookup_widget(tree_details->window, "show_titles")), 
		    "clicked", G_CALLBACK(quick_hide), (gpointer) ((long)SHOW_TITLES));
    set_mainmenu_icons(tree_details);


    add_preferences_items(treeview);
    add_autotype_C_widgets(treeview);
    /*add_view_items(treeview);*/
    set_widget_initial_state(treeview);
    set_widget_initial_goto_state(treeview);
    turn_on_goto(treeview);
    turn_on_pasteboard(treeview);
    {
	  GtkWidget *label,*a=lookup_widget((GtkWidget *)treeview,"about2");
	  gchar *label_txt;
    	  label = gtk_bin_get_child(GTK_BIN(a));
	  label_txt=g_strconcat(_("About")," (",VERSION,")",NULL);
	  gtk_label_set_text((GtkLabel *)label,my_utf_string(label_txt));
	  g_free(label_txt);label_txt=NULL;
    }


    apply_view(treeview);
    set_title(treeview, &d_path);
    {
  	GdkPixbuf *xffm_icon_pixbuf;
  	xffm_icon_pixbuf = create_pixbuf ("xffm_icon-36.png");
  	if (xffm_icon_pixbuf)
    	{
      		gtk_window_set_icon (GTK_WINDOW (tree_details->window), 
				xffm_icon_pixbuf);
      		g_object_unref (G_OBJECT(xffm_icon_pixbuf));
   	}
    }


    /*printf("DBG: preferences=0x%x\n",tree_details->preferences); */
    /*printf("DBG:hostname =%s\n",our_host_name(treeview)); */
    connect_help(treeview);

#if 0
    /* invisible widgets for hotkeys */
    {
      GtkWidget *w=gtk_image_menu_item_new();
      GtkAccelGroup *accel_group= gtk_accel_group_new ();
      gtk_widget_add_accelerator (w, "activate", accel_group,
                              GDK_Insert, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
      g_signal_connect ((gpointer) w, "activate",
                    G_CALLBACK (on_double_click_activate),
                    (gpointer)treeview);
      gtk_window_add_accel_group (GTK_WINDOW (tree_details->window),
		      accel_group);
  	
    }
#endif
#ifdef SPLIT_VIEW
   g_signal_connect(treeview2, "key-press-event", 
			G_CALLBACK(treeview_key),
                        NULL);    
#endif
    g_signal_connect(treeview, "key-press-event", 
			G_CALLBACK(treeview_key),
                        NULL);    
    g_free(d_path);d_path=NULL;
    gtk_widget_grab_focus((GtkWidget *) treeview);
    set_filter_combo(treeview);
    
    local_monitor(treeview,FALSE);
    /*XXX: this should be removed when the glade code generation is removed */
    hideit(tree_details->window, "separator21");
    hideit(tree_details->window, "separator22");
    hideit(tree_details->window, "separator23");
    hideit(tree_details->window, "separator24");
    hideit(tree_details->window, "separator26");
    return treeview;
}

/* if it fails to set directory, it goes to root,
 * if no directory is given in argv, it goes to home */
GtkTreeView *init_xffm(int argc, char *argv[])
{
    GtkTreeView *treeview;
    gchar *startup=NULL;
    gboolean expand=FALSE;
#ifdef DEBUG
    printf("DBG:xffm_argv0=%s\n",xffm_argv0);
#endif
    if ((strstr(xffm_argv0,"xfsamba") ||
	 strstr(xffm_argv0,"xfbook") ||    
	 strstr(xffm_argv0,"xftrash") ||    
	 strstr(xffm_argv0,"xfapps") ||    
	 strstr(xffm_argv0,"xftree") ||    
	 strstr(xffm_argv0,"xfglob") ||    
	 strstr(xffm_argv0,"xffstab") ) && 
	argc < 2 ) 
	    expand=TRUE;
    if((strstr(xffm_argv0,"xffm") || strstr(xffm_argv0,"xftree"))&& argc >= 2)
    {				/* if it fails it goes to root. */
	expand=TRUE;
	if(argv[1][0] == '/')
	    startup = g_strdup(argv[1]);
	else
	{
	    char wd[_POSIX_PATH_MAX];
	    getcwd(wd, _POSIX_PATH_MAX - 1);
	    startup = g_strconcat(wd, "/",argv[1],NULL);
	}
    }
    if (!startup) startup=g_strdup(get_xffm_home());
    if (!startup) g_assert_not_reached();

    reg_build_list();
    treeview = create_treeview(startup);
    g_free(startup);startup=NULL;
    if (expand){
	GtkTreeIter iter;
	tree_entry_t *en=NULL;
	if (strstr(xffm_argv0,"xffm")==0 || strstr(xffm_argv0,"xftree")) 
		get_local_root(treeview, &iter, &en);
	if (strstr(xffm_argv0,"xfsamba")) 
		get_network_root(treeview, &iter, &en);
	if (strstr(xffm_argv0,"xfglob")) 
		get_find_root(treeview, &iter, &en);
	if (strstr(xffm_argv0,"xfbook")) 
		get_bookmark_root(treeview, &iter, &en);
	if (strstr(xffm_argv0,"xfapps")) 
		get_apps_root(treeview, &iter, &en);
	if (strstr(xffm_argv0,"xftrash"))
		get_trash_root(treeview, &iter, &en);
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
	if (strstr(xffm_argv0,"xffstab")) 
		get_fstab_root(treeview, &iter, &en);
#endif
	if (en){
  	   GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
           GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
           GtkTreePath *treepath = gtk_tree_model_get_path(treemodel, &iter);
    	   gtk_tree_view_expand_row(treeview, treepath, FALSE);  
     	   gdk_flush();
	   gtk_tree_view_scroll_to_cell(treeview, treepath, NULL, TRUE, 0.0, 0.0);
	   gtk_tree_selection_select_path (selection,treepath);
	   gtk_tree_view_set_cursor (treeview,treepath,NULL,FALSE);
 	   gtk_tree_path_free(treepath); 
	}
    }
    return treeview;

}
