
#ifndef __TYPES_H__
#define __TYPES_H__
#include <time.h>

typedef struct history_combo_info_t{
	GtkTreeView 	*treeview;
	GtkWidget 	*combo;
	GtkWidget 	*entry;
	GList 		*list;
	GList 		*limited_list;
	gchar 		*active_dbh_file;
}history_combo_info_t;

typedef struct preferences_t {
  char *label;
  char *xml_option;
  int  flag;
  gint key;
} preferences_t;

typedef struct golist
{
    struct golist *previous;
    struct golist *next;
    char *path;
}
golist;

enum
{
    SMALL,
    MEDIUM,
    REAL_BIG,
    BIG,			/* must be last one */
    HOW_MANY_SIZES
};

enum
{
    SIZE_COL,
    DATE_COL,
    UID_COL,
    GID_COL,
    MODE_COL,
    NUM_COLS
};


typedef struct tree_details_t
{
    void *tubo_object;
    int selectionOK;
    GtkWidget *window;
    GtkTreeView *treeview;
    GtkTextView *status;
    GtkTextView *diagnostics;
    golist *gogo;
    int input;
    int timer;
    int loading;
    GtkTreeViewColumn *column[NUM_COLS];
    GtkWidget *remove;

    unsigned preferences;
    char *homedir;
    char *smb_user;
    int icon_size;
    int xffm_layer;
    char *theme;
    /*GHashTable *file_hash; */
    /*GtkTextBuffer *text_buffer; */
}
tree_details_t;


typedef struct tree_entry_t
{
    int type;
    int subtype;
    int count;		        /* only for directories */
    struct stat *st;
    char *tag;
    char *path;			/* this is just name for trash */
    char *filter;		/* filter for directories, path for trash */
    long long checksum;		/* only for directories */
    time_t load_time;
}
tree_entry_t;

typedef struct dir_t
{
    char *pathv;		/* matched pathname.  */
    tree_entry_t *en;

}
dir_t;


typedef struct gdir_t
{
    size_t pathc;		/* Count of paths matched */
    dir_t *gl;
}
gdir_t;

typedef struct column_info_t
{
    int id;
    GType type;
}
column_info_t;

#if 0
enum
{
    /* gtk stock icons first */
    FIND_RESULT_ICON,
    ERROR_ICON,
    INFO_ICON,
    QUESTION_ICON,
    WARNING_ICON,
    FIND_ICON,
    BOOKMARKS_ICON,
    TASKS_ICON,
    TRASH_CLOSED_ICON,
    TRASH_OPEN_ICON,
    UP_ICON,

    WASTE_BASKET_EMPTY_ICON,
    WASTE_BASKET_FULL_ICON,
    /* application icons */
    DEFAULT_ICON,
    OPEN_FOLDER_ICON,
    OPEN_FOLDER_LNK_ICON,
    OPEN_FOLDER_RO_ICON,
    OPEN_FOLDER_RO_LNK_ICON,
    HOPEN_FOLDER_ICON,
    HOPEN_FOLDER_LNK_ICON,
    HOPEN_FOLDER_RO_ICON,
    HOPEN_FOLDER_RO_LNK_ICON,
    AOPEN_FOLDER_ICON,
    AOPEN_FOLDER_LNK_ICON,
    AOPEN_FOLDER_RO_ICON,
    AOPEN_FOLDER_RO_LNK_ICON,

    CLOSED_FOLDER_ICON,
    CLOSED_FOLDER_LNK_ICON,
    CLOSED_FOLDER_RO_ICON,
    CLOSED_FOLDER_RO_LNK_ICON,
    NOACCESS_ICON,
    LINK_ICON,
    BROKEN_ICON,
    EXECUTABLE_ICON,
    NETWORK_ICON,
    BLOCK_DEV_ICON,
    CHAR_DEV_ICON,
    FIFO_ICON,
    SOCKET_ICON,
    HOW_MANY_ICONS
};
#endif

enum
{
    EMPTY_COLUMN,
    ENTRY_COLUMN,
    STYLE_COLUMN,
    FONT_COLUMN,

    PIXBUF_COLUMN,
    NAME_COLUMN,
    SIZE_COLUMN,
    DATE_COLUMN,
    OWNER_COLUMN,
    GROUP_COLUMN,
    MODE_COLUMN,

    TREE_COLUMNS
};

typedef struct root_t
{
    int id;
    char *path;
    char *label;
    unsigned int type;
}
root_t;

enum
{
    /*ROOT_TASKS,*/
    ROOT_BOOKMARKS,
    ROOT_FILES,
    ROOT_NETWORK,
    ROOT_APP,
    ROOT_FIND,
    ROOT_TRASH,
#if defined(HAVE_GETMNTENT) || defined(HAVE_GETFSENT) || defined(HAVE_GETVFSENT)
    ROOT_FSTAB,
#endif
    ROOT_TAGS
};

#endif
