/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "new_win.h"
#include "entry.h"
#include "misc.h"
#include "run.h"
#include "treeview.h"

extern gchar *xffm_argv0;
extern char *bookfile;

static void new_win(GtkTreeView * treeview)
{
    const gchar *path = get_selected_chdir(treeview);
    /* this works with ctrees, but no more with treeviews because
     * of the cache they use...  create_treeview(path);
     * so instead let's fork a brand new process */
    char *argv[3];
    argv[0] = xffm_argv0;
    if (strcmp(xffm_argv0,"xfbook")==0 || strcmp(xffm_argv0,"xfbook4")==0)
	    argv[1] = (char *)bookfile;
    else    argv[1] = (char *)path;
    argv[2] = 0;
    runv(treeview, argv);
    return;
}

/* callbacks */
void on_new_tree_view2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    new_win(treeview);
}

void tb_new_win(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);
    new_win(treeview);

}

void on_open_in_xffm_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    new_win(treeview);

}
