<!--

  $Id: linuxdoc-html.ts,v 1.2 1996/12/17 01:48:32 jfieber Exp $

  Copyright (C) 1997
       John R. Fieber.  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY JOHN R. FIEBER AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL JOHN R. FIEBER OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

-->

<!--

  This is an instant(1) translation specification to turn an
  SGML document marked up according to the linuxdoc DTD into
  a document marked up according to the DocBook DTD.  Some manual
  post-conversion cleanup may be needed for the resulting
  document to parse.  The output of this transpec should NOT be
  used as an example of how to use the DocBook DTD.
  
-->

<!DOCTYPE transpec PUBLIC "-//FreeBSD//DTD transpec//EN" [
<!ENTITY lt CDATA "<">
<!ENTITY gt CDATA ">">

<!ENTITY r.pass  CDATA "1">
<!ENTITY r.ignore CDATA "2">
<!ENTITY r.getid CDATA "3">
<!ENTITY r.normp CDATA "4">
<!ENTITY r.tag1 CDATA "5">
<!ENTITY r.tagn CDATA "6">
<!ENTITY r.headid "7">

<!ENTITY m.trid '${_! echo -n "${ID}" | tr ":_" "--"}'>

<!ENTITY cmap SYSTEM "html.cmap">
<!ENTITY sdata SYSTEM "html.sdata">

]>

<transpec>

<!-- Character and SDATA entity mapping -->
<cmap>&cmap;</cmap>
<smap>&sdata;</smap>

<var>article 1

<!-- Transform rules -->

<rule>
<match>
<gi>LINUXDOC
</rule>

<rule>
<match>
  <gi>ARTICLE BOOK
<action>
  <start>&lt;!DOCTYPE BOOK PUBLIC "-//Davenport//DTD DocBook V3.0//EN">
&lt;book>^</start>
  <end>&lt;/book>^</end>
</rule>

<rule>
<match>
  <gi>REPORT
</rule>

<rule>
<match>
  <gi>BOOK
</rule>

<rule>
<match>
  <gi>NOTES
</rule>

<rule>
<match>
  <gi>MANPAGE
</rule>

<rule>
<match>
  <gi>TITLEPAG
<action>
  <start>^
&lt;bookinfo>
&lt;bookbiblio>^</start>
  <end>&lt;/bookbiblio>
&lt;/bookinfo>
^</end>
</rule>

<rule>
<match>
  <gi>TITLE
<action>
  <start>^&lt;title></start>
  <end>&lt;/title></end>
</rule>

<rule>
<match>
  <gi>SUBTITLE
<action>
  <start>^&lt;subtitle></start>
  <end>&lt;/subtitle>^</end>
</rule>

<rule>
<match>
  <gi>DATE
<action>
  <start>^
&lt;pubdate></start>
  <end>&lt;/pubdate></end>
</rule>

<rule>
<match>
  <gi>AUTHOR
<action>
  <start>^
&lt;authorgroup></start>
  <end>^&lt;/authorgroup>^</end>
</rule>

<rule>
<match>
  <gi>NAME
<action>
  <start>^&lt;author>
&lt;surname></start>
  <end>&lt;/surname>
&lt;/author></end>
</rule>

<rule>
<match>
  <gi>AND
<action>
  <start>and </start>
</rule>

<rule>
<match>
  <gi>THANKS
<action>
  <start>^&lt;othercredit>&lt;surname></start>
  <end>&lt;/surname>&lt;/othercredit></end>
</rule>

<rule>
<match>
  <gi>INST
<action>
  <start>^&lt;affiliation>&lt;shortaffil></start>
  <end>&lt;/shortaffil>&lt;/affiliation>^</end>
</rule>

<rule>
<match>
  <gi>NEWLINE
<action>
  <start>&lt;!-- &lt;br> --></start>
</rule>

<rule>
<match>
  <gi>LABEL
  <relation>parent HEADING
</rule>

<rule>
<match>
  <gi>LABEL
<action>
  <start>&lt;anchor id="&m.trid"></start>
</rule>

<rule>
<match>
  <gi>HEADER
</rule>

<rule>
<match>
  <gi>LHEAD
<action>
  <start>^&lt;!-- </start>
  <end>-->^</end>
</rule>

<rule>
<match>
  <gi>RHEAD
<action>
  <start>^&lt;!-- </start>
  <end>-->^</end>
</rule>

<rule>
<match>
  <gi>COMMENT
<action>
  <start>^&lt;comment></start>
  <end>&lt;/comment>^</end>
</rule>

<rule>
<match>
  <gi>ABSTRACT
<action>
  <start>^
&lt;abstract>&lt;para></start>
  <end>&lt;/para>&lt;/abstract>

^</end>
</rule>

<rule>
<match>
  <gi>APPENDIX
<action>
  <start>^&lt;appendix></start>
  <end>&lt;/appendix></end>
</rule>

<rule>
<match>
  <gi>TOC
</rule>

<rule>
<match>
  <gi>LOF
</rule>

<rule>
<match>
  <gi>LOT
</rule>

<rule>
<match>
  <gi>PART
<action>
  <start>^
&lt;part${_followrel child HEADING &r.headid;t}></start>
  <end>&lt;/part></end>
</rule>

<rule>
<match>
  <gi>CHAPT
<action>
  <start>^
&lt;chapter${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/chapter>^</end>
</rule>

<rule>
<match>
  <gi>SECT
  <context>CHAPT
<action>
  <start>^
&lt;sect1${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect1>^</end>
</rule>

<rule>
<match>
  <gi>SECT
<action>
  <start>^
&lt;chapter${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/chapter>^</end>
</rule>

<rule>
<match>
  <gi>SECT1
  <relation>ancestor CHAPT
<action>
  <start>^
&lt;sect2${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect2>^</end>
</rule>

<rule>
<match>
  <gi>SECT1
<action>
  <start>^
&lt;sect1${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect1>^</end>
</rule>

<rule>
<match>
  <gi>SECT2
  <relation>ancestor CHAPT
<action>
  <start>^
&lt;sect3${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect3>^</end>
</rule>

<rule>
<match>
  <gi>SECT2
<action>
  <start>^
&lt;sect2${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect2>^</end>
</rule>

<rule>
<match>
  <gi>SECT3
  <relation>ancestor CHAPT
<action>
  <start>^
&lt;sect4${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect4>^</end>
</rule>

<rule>
<match>
  <gi>SECT3
<action>
  <start>^
&lt;sect3${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect3>^</end>
</rule>

<rule>
<match>
  <gi>SECT4
  <relation>ancestor CHAPT
<action>
  <start>^
&lt;sect5${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect5>^</end>
</rule>

<rule>
<match>
  <gi>SECT4
<action>
  <start>^
&lt;sect4${_followrel child HEADING &r.headid;t}></start>
  <end>^&lt;/sect4>^</end>
</rule>

<rule>
<match>
  <gi>HEADING
<action>
  <start>^&lt;title></start>
  <end>&lt;/title>

^</end>
</rule>

<rule>
<match>
  <gi>P
  <context>DESCRIP
<action>
  <replace>${_relation sibling- TAG &r.normp; &r.ignore;}</replace>
</rule>

<rule>
<match>
  <gi>P
  <context>ITEM|QUOTE
<action>
  <start>&lt;/para>

&lt;para></start>
</rule>

<rule> <!-- Any other paragraph with content -->
<match>
  <gi>P
<action>
  <replace>${_notempty &r.normp;}</replace>
</rule>

<rule> <!-- A paragraph that gets this far is empty, ignore it. -->
<match>
  <gi>P
</rule>

<rule id="&r.normp;">
<match>
  <gi>P
<action>
  <start>^&lt;para></start>
  <end>&lt;/para>
  
^</end>
</rule>

<!-- Unordered and Ordered lists are simple -->
<rule>
<match>
  <gi>ITEMIZE LIST
<action>
  <start>^&lt;itemizedlist>

^</start>
  <end>^&lt;/itemizedlist>^</end>
</rule>

<rule>
<match>
  <gi>ENUM
<action>
  <start>^&lt;orderedlist>

^</start>
  <end>^&lt;/orderedlist>^</end>
</rule>

<rule>
<match>
  <gi>ITEM
<action>
  <start>^&lt;listitem>
&lt;para></start>
  <end>&lt;/para>
&lt;/listitem>

^</end>
</rule>

<rule>
<match>
  <gi>DESCRIP
<action>
  <start>^&lt;variablelist>^</start>
  <end>&lt;/listitem>
&lt;/varlistentry>
&lt;/variablelist>^</end>
</rule>

<rule>
<match>
  <gi>TAG
<action>
  <replace>${_relation sibling- TAG &r.tagn; &r.tag1;}</replace>
</rule>

<rule id="&r.tagn;">
<match>
  <gi>_tagn
<action>
  <start>&lt;/listitem>
&lt;/varlistentry>

&lt;varlistentry>&lt;term></start>
  <end>&lt;/term>

&lt;listitem></end>
</rule>

<rule id="&r.tag1;">
<match>
  <gi>TAG
<action>
  <start>&lt;varlistentry>&lt;term></start>
  <end>&lt;/term>
&lt;listitem></end>
</rule>

<rule>
<match>
  <gi>CITE
<action>
  <start>&lt;citation>&m.trid;&lt;/citation></start>
</rule>

<rule>
<match>
  <gi>NCITE
<action>
  <start>&lt;citation>${NOTE} (&m.trid;)&lt;/citation></start>
</rule>

<rule>
<match>
  <gi>FOOTNOTE
<action>
  <start>&lt;footnote>&lt;para></start>
  <end>&lt;/para>&lt;/footnote></end>
</rule>

<rule>
<match>
  <gi>SQ
<action>
  <start>&lt;quote></start>
  <end>%lt;/quote></end>
</rule>

<rule>
<match>
  <gi>LQ
<action>
  <start>^&lt;blockquote></start>
  <end>&lt;/blockquote>^</end>
</rule>

<!-- Be clever and interpret various procedural markup by its content -->

<rule>
<match>
  <gi>EM IT
  <relation>parent TT
<action>
  <start>&lt;replaceable></start>
  <end>&lt;/replaceable></end>
</rule>

<rule> <!-- email addresses -->
<match>
  <gi>EM BF IT SF SL TT
  <content>^[^ @]*@[^ @]*$</content>
<action>
  <start>&lt;email></start>
  <end>&lt;/email></end>
</rule>

<rule> <!-- code snippets -->
<match>
  <gi>EM BF IT SF SL TT
  <content>(=)|(0x[0-9a-fA-F]*)</content>
<action>
  <start>&lt;literal></start>
  <end>&lt;/literal></end>
</rule>

<rule> <!-- filenames -->
<match>
  <gi>EM BF IT SF SL TT
  <content>(^[^ ]*/[^ ]*$)|(^[^ ]*\.[a-zA-Z]+$)</content>
<action>
  <start>&lt;filename></start>
  <end>&lt;/filename></end>
</rule>

<rule> <!-- commands detected by options or parameters starting with /. -->
<match>
  <gi>EM BF IT SF SL TT
  <content>^[a-z]*( +[-/]| +.* [-/]).*</content>
<action>
  <start>&lt;command></start>
  <end>&lt;/command></end>
</rule>

<rule> <!-- functions (must come before commands, below!) -->
<match>
  <gi>EM BF IT SF SL TT
  <content>\([239]?\)$</content>
<action>
  <start>&lt;function></start>
  <end>&lt;/function></end>
</rule>

<rule> <!-- commands detected by man(1) style citations. -->
<match>
  <gi>EM BF IT SF SL TT
  <content>\([168]?\)$</content>
<action>
  <start>&lt;command></start>
  <end>&lt;/command></end>
</rule>

<rule> <!-- variables. This one may catch too many things. In particular,
            some test docs caught a number of things that should be
            <replaceable>. -->
<match>
  <gi>EM BF IT SF SL TT
  <content>^[-a-zA-Z0-9_]*_[-a-zA-Z0-9_]*$</content>
<action>
  <start>&lt;symbol></start>
  <end>&lt;/symbol></end>
</rule>

<rule>
<match>
  <gi>BF TT
  <content>^-</content>
<action>
  <start>&lt;option></start>
  <end>&lt;/option></end>
</rule>

<rule> <!-- Acronyms (upper case letters only) -->
<match>
  <gi>EM BF IT SF SL TT
  <content>^[A-Z][A-Z]+$</content>
<action>
  <start>&lt;acronym></start>
  <end>&lt;/acronym></end>
</rule>



<rule>
<match>
  <gi>EM
<action>
  <start>&lt;emphasis></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>BF
<action>
  <start>&lt;emphasis remap=bf></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>IT
<action>
  <start>&lt;emphasis remap=it></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>SF
<action>
  <start>&lt;emphasis remap=sf></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>SL
<action>
  <start>&lt;emphasis remap=sl></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>TT
<action>
  <start>&lt;emphasis remap=tt></start>
  <end>&lt;/emphasis></end>
</rule>

<rule>
<match>
  <gi>URL HTMLURL
  <context>NAME
  <attval>NAME .
<action>
  <start>${NAME}</start>
</rule>

<rule>
<match>
  <gi>URL HTMLURL
  <context>NAME
<action>
  <start>${URL}</start>
</rule>

<rule>
<match>
  <gi>URL HTMLURL
  <attval>NAME .
<action>
  <start>&lt;ulink URL="${URL}">${NAME}&lt;/ulink></start>
</rule>

<rule>
<match>
  <gi>URL HTMLURL
<action>
  <start>&lt;ulink URL="${URL}">${URL}&lt;/ulink></start>
</rule>

<rule> <!-- Link text in docbook is specified at that target
            end, not the reference end as in linuxdoc.  Use
            the remap attribute to fake the linuxdoc behavior. -->
<match>
  <gi>REF
  <attval>NAME .
<action>
  <start>&lt;xref linkend="&m.trid;" remap="${NAME}"></start>
</rule>

<rule>
<match>
  <gi>REF
<action>
  <start>&lt;xref linkend="&m.trid;" remap="&m.trid;"></start>
</rule>

<rule> <!-- Docbook does not have a pageref equivalent, so specify
            a role of pageref. -->
<match>
  <gi>PAGEREF
<action>
  <start>&lt;xref linkend="&m.trid;" role=pageref></start>
</rule>

<rule>
<match>
  <gi>X
</rule>

<rule>
<match>
  <gi>MC
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>BIBLIO
<action>
  <start>^&lt;bibliography></start>
  <end>&lt;/bibliography>^</end>
</rule>

<rule>
<match>
  <gi>CODE
  <relation>parent TSCREEN
</rule>

<rule>
<match>
  <gi>CODE
<action>
  <start>^&lt;informalexample>
&lt;programlisting></start>
  <end>&lt;/programlisting>
&lt;/informalexample>^</end>
</rule>

<rule>
<match>
  <gi>VERB
  <context>TSCREEN
</rule>

<rule>
<match>
  <gi>VERB
<action>
  <start>^&lt;literallayout></start>
  <end>&lt;/literallayout>^</end>
</rule>

<rule>
<match>
  <gi>TSCREEN
  <relation>child CODE
<action>
  <start>^&lt;informalexample>
&lt;programlisting></start>
  <end>&lt;/programlisting>
&lt;/informalexample></end>
</rule>

<rule>
<match>
  <gi>TSCREEN
<action>
  <start>^&lt;informalexample>
&lt;screen></start>
  <end>&lt;/screen>
&lt;/informalexample>^</end>
</rule>

<rule>
<match>
  <gi>QUOTE
<action>
  <start>^&lt;blockquote>
&lt;para></start>
  <end>&lt;/para>
&lt;/blockquote>^</end>
</rule>

<rule>
<match>
  <gi>DEF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>PROP
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>LEMMA
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>COROLL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>PROOF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>THEOREM
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>THTAG
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>F
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>DM
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>EQ
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>FR
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>NU
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>DE
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>LIM
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>OP
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>LL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>UL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>OPD
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>PR
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>IN
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SUM
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>ROOT
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>AR
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>ARR
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>ARC
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SUP
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>INF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>UNL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>OVL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>RF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>V
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>FI
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>PHR
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>TU
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>FIGURE
<action>
  <start>^&lt;figure>
&lt;title>${_find gi caption &r.pass;}&lt/title>^</start>
  <end>^&lt;/figure>^</end>
</rule>

<rule>
<match>
  <gi>EPS
<action>
  <start>^&lt;graphic fileref="${FILE}" notation=EPS>^</start>
</rule>

<rule>
<match>
  <gi>PH
<action>
  <start>^&lt;-- Space for a figure of height ${VSPACE} -->^</start>
</rule>

<rule>
<match>
  <gi>CAPTION
  <context>FIGURE
<action>
  <ignore>all
</rule>

<rule>
<match>
  <gi>TABLE
<action>
  <start>^&lt;table>
&lt;title>${_find gi caption &r.pass;}&lt/title>^</start>
  <end>^&lt;/table>^</end>
</rule>

<rule>
<match>
  <gi>CAPTION
  <context>TABLE
<action>
  <ignore>all
</rule>

<rule>
<match>
  <gi>TABULAR
<action>
  <start>^&lt;table>
&lt;title>${_find gi caption &r.pass;}&lt/title>
&lt;tgroup>
&lt;tbody>
&lt;row>&lt;entry></start>
  <end>&lt;/row>
&lt;/tbody>
&lt;/tgroup>
&lt;/table>^</end>
</rule>

<rule>
<match>
  <gi>ROWSEP
<action>
  <start>&lt;/entry>&lt;/row>
&lt;row>&lt;entry></start>
</rule>

<rule>
<match>
  <gi>COLSEP
<action>
  <start>&lt;/entry>&lt;entry></start>
</rule>

<rule>
<match>
  <gi>HLINE
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SLIDES
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SLIDE
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>LETTER
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>TELEFAX
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>OPENING
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>FROM
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>TO
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>ADDRESS
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>EMAIL
<action>
  <start>&lt;email></start>
  <end>&lt;/email></end>
</rule>

<rule>
<match>
  <gi>PHONE
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>FAX
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SUBJECT
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>SREF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>RREF
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>RDATE
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>CLOSING
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>CC
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>ENCL
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule>
<match>
  <gi>PS
<action>
  <message>I have no mapping for ${_gi U}^</message>
</rule>

<rule id="&r.pass;">
<match>
  <gi>_pass
</rule>

<rule id="&r.ignore;">
<match>
  <gi>_ignore
<action>
  <ignore>all
</rule>

<rule id="&r.getid;">
<match>
  <gi>_getid
<action>
  <start>^id="&m.trid;"</start>
</rule>

<rule id="&r.headid">
<match>
  <relation>child LABEL
<action>
  <replace>${_followrel child LABEL &r.getid;}</replace>
</rule>

</transpec>
