#ifndef KBBPREFS_H
#define KBBPREFS_H
// $Id: kbbprefs.h,v 1.10 2002/09/26 09:16:54 cschumac Exp $
// (C) 2001 by Cornelius Schumacher

#include <qmap.h>

#include "kprefs.h"
#include "mailsender.h"

class QStringList;

class KBBPrefs : public KPrefs
{
  public:
    virtual ~KBBPrefs();
  
    static KBBPrefs *instance();

  protected:
    void usrSetDefaults();
    void usrReadConfig();
    void usrWriteConfig();

    void setMessageButtonsDefault();

  private:
    KBBPrefs();

    static KBBPrefs *mInstance;

  public:
    QStringList     mRecentPackages;
    int             mRecentPackagesCount;

    QString         mCurrentPackage;
    QString         mCurrentBug;

    QValueList<int> mSplitter1;
    QValueList<int> mSplitter2;

    int             mMailClient;
    bool            mShowClosedBugs;
    bool            mShowWishes;
    bool            mSendBCC;
    QString         mBugzillaURL;
    QString         mOverrideRecipient;

    QMap<QString,QString> mMessageButtons;

    int mMsgDlgWidth;
    int mMsgDlgHeight;
    QValueList<int> mMsgDlgSplitter;

    QStringList mServers;
};

#endif
