/***************************************************************************
                            KPreviewWidgetBase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPREVIEWWIDGETBASE_H
#define KPREVIEWWIDGETBASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Abstract baseclass for all preview widgets which shall be used via
 -[KFileDialog setPreviewWidget](const KPreviewWidgetBase *).
 Ownership will be transferred to KFileDialog, so you have to create
 the preview with "new" and let KFileDialog delete it.

 Just derive your custom preview widget from KPreviewWidgetBase and implement
 all the pure virtual methods. The slot showPreview(const KURL &) is called
 every time the file selection changes.

 @author Frerich Raabe <raabe@kde.org>
 
 @short Abstract baseclass for all preview widgets.

*/
@class KURL; 

@interface KPreviewWidgetBase : QWidget 

/** 
 This slot is called everytime the user selects another file in the
 file dialog. Implement the stuff necessary to reflect the change here.

*/
- showPreview: (KURL*)url;

/** 
 Reimplement this to clear the preview. This is called when e.g. the
 selection is cleared or when multiple selections exist, or the directory
 is changed.
     
*/
- clearPreview;
@end

/** Override these methods in subclasses of KPreviewWidgetBase to customise event handling behaviour */
@protocol KPreviewWidgetBaseEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
