/***************************************************************************
                            KDCOPPropertyProxy.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDCOPPROPERTYPROXY_H
#define KDCOPPROPERTYPROXY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.

 The class provides DCOP equivalents for the Qt property methods -setProperty ,
 -property and -propertyNames and also provides automatic set/get methods for
 the properties of a QObject. That means for example if your object provides a
 QString property called foo , then KDCOPPropertyProxy translates DCOP calls
 "setFoo( QString )" and "QString -foo" automatically into the corresponding
 setProperty/property calls.
 
 @short 
 The KDCOPPropertyProxy class provides an easy way to publish Qt properties of a
 QObject through DCOP.
*/
@class QByteArray; 
@class QObject; 

@interface  KDCOPPropertyProxy : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Convenience constructor. Use it if you want to use this class as object, in contrary
 to using the static methods of this class and providing a QObject argument for each
 call.
   
*/
- initWithObject: (QObject *)object;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Convenience method, when using this class as object. See documentation of the constructor and
 static isPropertyRequest method.
   
*/
- (BOOL) isPropertyRequest: (NSString *)fun;

/** 
 Convenience method, when using this class as object. See documentation of the constructor and
 static processPropertyRequest method.
   
*/
- (BOOL) processPropertyRequest: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;

/** 
 Returns true if the method request in the fun argument matches the signature of the three standard
 property methods or set/get methods for the properties of the object argument.

 Use this method in your own DCOPObject dispatcher to check if the DCOP request is a property
 request which can be handled by this class.
   
*/
+ (BOOL) isPropertyRequest: (NSString *)fun object: (QObject *)object;

/** 
 Processes the given DCOP method request by translating the request into a setProperty/property call
 on the given QObject argument.
   
*/
+ (BOOL) processPropertyRequest: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData object: (QObject *)object;
@end

#endif
