package org.kde.koala;
import org.kde.qt.*;


/** {@link KIconDialog} emits these signals */
public interface KIconDialogSignals {

/** 
 The OK button was pressed. This signal is only emitted if
 {@link KIconDialog#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The Try button was pressed. This signal is only emitted if
 {@link KIconDialog#slotTry} is not replaced.
     
*/
	void tryClicked();

/** 
 The Yes button was pressed. This signal is only emitted if
 {@link KIconDialog#slotYes} is not replaced.
     
*/
	void yesClicked();
	void destroyed( QObject obj );

/** 
 The No button was pressed. This signal is only emitted if
 {@link KIconDialog#slotNo} is not replaced.
     
*/
	void noClicked();

/** 
 The Apply button was pressed. This signal is only emitted if
 {@link KIconDialog#slotApply} is not replaced.
     
*/
	void applyClicked();

/** 
 The Close button was pressed. This signal is only emitted if
 {@link KIconDialog#slotClose} is not replaced.
     
*/
	void closeClicked();

/** 
 The User3 button was pressed. This signal is only emitted if
 {@link KIconDialog#slotUser3} is not replaced.
     
*/
	void user3Clicked();

/** 
 Emitted when the margin size and/or spacing size
 have changed.

 Use {@link KIconDialog#marginHint} and  {@link KIconDialog#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/** 
 A page is about to be shown.
     
*/
	void aboutToShowPage( QWidget page );

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KIconDialog#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KIconDialog#delayedDestruct} instead.
     
*/
	void finished();

/** 
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/** 
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KIconDialog#applyClicked} instead.
     
*/
	void apply();

/** 
 The User2 button was pressed. This signal is only emitted if
 {@link KIconDialog#slotUser2} is not replaced.
     
*/
	void user2Clicked();

/** 
 The Cancel button was pressed. This signal is only emitted if
 {@link KIconDialog#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/** 
 The Default button was pressed. This signal is only emitted if
 {@link KIconDialog#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/** 
 The User1 button was pressed. This signal is only emitted if
 {@link KIconDialog#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/** 
 The background tile has changed.
     
*/
	void backgroundChanged();

/** 
 The Help button was pressed. This signal is only emitted if
 {@link KIconDialog#slotHelp} is not replaced.
     
*/
	void helpClicked();
}

