/***************************************************************************
                            kde_KScriptManager.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSCRIPTMANAGER
#define KDE_KSCRIPTMANAGER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
	This class is the base for all script engines.

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short *
	This class is the base for all script engines.
*/

/** *
	Create a new instance of the script engine.
		
*/
kde_KScriptManager * kde_new_KScriptManager(qt_QObject * parent, char* name);

/** *
	Destroy the current script engine.
		
*/
void kde_del_KScriptManager( kde_KScriptManager* p );

/** *
	Add a new script instance to the script engine.
	This should be the full name and path to the desktop
	file.
		
*/
int kde_KScriptManager_addScript(kde_KScriptManager* instPointer,qt_QString * scriptDesktopFile);

/** *
	Remove a script instance from the script engine.

*/
int kde_KScriptManager_removeScript(kde_KScriptManager* instPointer,qt_QString * scriptName);

/** *
	Access the names of script instances from the script engine.

*/
qt_QStringList* kde_KScriptManager_scripts(kde_KScriptManager* instPointer);

/** *
	Clear all script intstances in memory
		
*/
void kde_KScriptManager_clear(kde_KScriptManager* instPointer);

/** *
	This function will allow the main application of any errors
	that have occured during processing of the script.
		
*/
void kde_KScriptManager_error(kde_KScriptManager* instPointer,qt_QString * msg);

/** *
	This function will allow the main application of any warnings
	that have occured during the processing of the script.
		
*/
void kde_KScriptManager_warning(kde_KScriptManager* instPointer,qt_QString * msg);

/** *
	This function will allow the main application of any normal
	output that has occured during the processing of the script.
		
*/
void kde_KScriptManager_output(kde_KScriptManager* instPointer,qt_QString * msg);

/** *
	This function will allow feedback to any progress bars in the main
	application as to how far along the script is.  This is very useful when
	a script is processing files or doing some long operation that is of a
	known duration.
		
*/
void kde_KScriptManager_progress(kde_KScriptManager* instPointer,int percent);

/** *
	This function will allow feedback on completion of the script.
	It turns the result as a @ref KScriptInteface::Result, and a return
	value as a @ref QVariant
		
*/
void kde_KScriptManager_done(kde_KScriptManager* instPointer,int result, qt_QVariant * returned);

/** *
	Run the selected script
		
*/
void kde_KScriptManager_runScript(kde_KScriptManager* instPointer,qt_QString * scriptName, qt_QObject * context, qt_QVariant * arg);

/** Casts a 'kde_KScriptManager *' to a 'kde_KScriptClientInterface*' */
kde_KScriptClientInterface* kde_KScriptManager_KScriptClientInterface(kde_KScriptManager* instPointer);

/** Casts a 'kde_KScriptManager *' to a 'qt_QObject *' */
qt_QObject * kde_KScriptManager_QObject(kde_KScriptManager* instPointer);

#endif
