/* $Id: plugin_domtreeviewer.cpp,v 1.9.2.1 2003/07/18 00:59:44 mueller Exp $ */

#include "plugin_domtreeviewer.h"

#include <kaction.h>
#include <kinstance.h>

#include <klocale.h>
#include <kgenericfactory.h>

#include <khtml_part.h>

#include <domtreeview.h>

typedef KGenericFactory<PluginDomtreeviewer> DomtreeviewerFactory;
K_EXPORT_COMPONENT_FACTORY( libdomtreeviewerplugin, DomtreeviewerFactory( "domtreeviewer" ) )

PluginDomtreeviewer::PluginDomtreeviewer( QObject* parent, const char* name,
	                                  const QStringList & )
  : Plugin( parent, name )
{
  (void) new KAction( i18n("Show &DOM Tree"),
                      "domtreeviewer", 0,
                      this, SLOT(slotShowDOMTree()),
                      actionCollection(), "viewdomtree" );
}

PluginDomtreeviewer::~PluginDomtreeviewer()
{
}

void PluginDomtreeviewer::slotShowDOMTree()
{
  if( parent() && parent()->inherits("KHTMLPart"))
    {
       KHTMLPart *part = static_cast<KHTMLPart *>(parent());
      DOMTreeView * dtv = new DOMTreeView(0, part, "DomTreeView", false);
      dtv->show();
    }
}

#include <plugin_domtreeviewer.moc>
