/***************************************************************************
                               domtreeview.h
                             -------------------

    copyright            : (C) 2001 - The Kafka Team/Andreas Schlapbach
    email                : kde-kafka@master.kde.org
                           schlpbch@iam.unibe.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* $Id: domtreeview.h,v 1.12 2002/08/25 09:51:01 mlaurent Exp $ */

#ifndef DOMTREEVIEW_H
#define DOMTREEVIEW_H

#include <qptrdict.h>
#include <dom/dom_core.h>
#include <qtextstream.h>

#include <kdebug.h>
#include <kdialog.h>
#include <klistview.h>
#include <keditcl.h>

#include "domlistviewitem.h"

class QVBoxLayout;
class QHBoxLayout;
class QPushButton;
class QCheckBox;

class DOMTreeView : public KDialog
{
    Q_OBJECT

    public:
	DOMTreeView(QWidget *parent, KHTMLPart *part, const char* name,
		    bool allowSaving = true);
	~DOMTreeView();
    /*
    protected:
	void saveTreeAsHTML(const DOM::Node &pNode);
    */
    protected slots:
        void slotShowNode(const DOM::Node &pNode);
        void slotShowTree(const DOM::Node &pNode);
	void slotItemClicked(QListViewItem *);
	void slotSearch();

	void slotFindClicked();
	// void slotSaveClicked();
        void slotRefreshClicked();
	void slotIncrExpansionDepth();
	void slotDecrExpansionDepth();

	void slotPureToggled(bool);
        void slotShowAttributesToggled(bool);
	void slotHighlightHTMLToggled(bool);

    private:
	QPtrDict<QListViewItem> m_itemdict;
	QPtrDict<DOM::Node> m_nodedict;
 	DOM::Node m_document;
	uint m_expansionDepth, m_maxDepth;
	bool m_bPure, m_bShowAttributes, m_bHighlightHTML;

	void showRecursive(const DOM::Node &pNode, const DOM::Node &node,
			   uint depth);

	// void saveRecursive(const DOM::Node &node, int ident);

	void searchRecursive(DOMListViewItem *cur_item,
			     const QString &searchText,
			     bool caseSensitive);

	void adjustDepth(QListViewItem *cur_item,  uint currDepth);
	void highlightHTML(DOMListViewItem *cur_item,
			   const QString &nodeName);

	void addElement(const DOM::Node &node, DOMListViewItem *cur_item,
			bool isLast);
    void updateIncrDecreaseButton();
	KEdFind* m_findDialog;

	KHTMLPart *part;
	QTextStream* m_textStream;

	KListView* m_listView;
	const KListView* m_rootListView;
	QCheckBox* m_pureCheckBox;
	QCheckBox* m_showAttributesCheckBox;
	QCheckBox* m_highlightHTMLCheckBox;

	QPushButton* m_decreaseButton;
	QPushButton* m_increaseButton;
	QPushButton* m_findButton;
	QPushButton* m_saveButton;
	QPushButton* m_refreshButton;
	QPushButton* m_closeButton;

	QVBoxLayout* m_vLayout1;
	QVBoxLayout* m_vLayout2;
	QHBoxLayout* m_hLayout1;
	QHBoxLayout* m_hLayout2;
};

#endif
