/*
 *  Hamlib CI-V backend - description of IC-707
 *  Copyright (c) 2000-2004 by Stephane Fillod
 *
 *	$Id: ic707.c,v 1.3 2005/04/03 19:53:51 fillods Exp $
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include "hamlib/rig.h"
#include "bandplan.h"
#include "icom.h"


#define IC707_ALL_RX_MODES (RIG_MODE_AM|RIG_MODE_CW|RIG_MODE_SSB|RIG_MODE_FM)

/* 
 * IC-707
 * specs: http://www.qsl.net/sm7vhs/radio/icom/ic707/specs.htm
 *
 */ 
#define IC707_OTHER_TX_MODES (RIG_MODE_CW|RIG_MODE_SSB|RIG_MODE_FM)
#define IC707_AM_TX_MODES (RIG_MODE_AM)

#define IC707_VFO_ALL (RIG_VFO_A|RIG_VFO_B)

#define IC707_VFO_OPS (RIG_OP_FROM_VFO|RIG_OP_TO_VFO|RIG_OP_CPY|RIG_OP_MCL)

#define IC707_SCAN_OPS (RIG_SCAN_VFO|RIG_SCAN_MEM)	/* TBC */

#define IC707_ANTS RIG_ANT_1

/*
 */
static const struct icom_priv_caps ic707_priv_caps = { 
	0x3e,	/* default address */
	0,		/* 731 mode */
	ic737_ts_sc_list
};

const struct rig_caps ic707_caps = {
.rig_model =  RIG_MODEL_IC707,
.model_name = "IC-707", 
.mfg_name =  "Icom", 
.version =  BACKEND_VER, 
.copyright =  "LGPL",
.status =  RIG_STATUS_NEW,
.rig_type =  RIG_TYPE_TRANSCEIVER,
.ptt_type =  RIG_PTT_NONE,
.dcd_type =  RIG_DCD_NONE,
.port_type =  RIG_PORT_SERIAL,
.serial_rate_min =  300,
.serial_rate_max =  9600,
.serial_data_bits =  8,
.serial_stop_bits =  2,
.serial_parity =  RIG_PARITY_NONE,
.serial_handshake =  RIG_HANDSHAKE_NONE, 
.write_delay =  0,
.post_write_delay =  0,
.timeout =  200,
.retry =  3, 
.has_get_func =  RIG_FUNC_NONE,
.has_set_func =  RIG_FUNC_NONE, 
.has_get_level =  RIG_LEVEL_NONE,
.has_set_level =  RIG_LEVEL_NONE,
.has_get_parm =  RIG_PARM_NONE,
.has_set_parm =  RIG_PARM_NONE,
.level_gran =  {},
.parm_gran =  {},
.ctcss_list =  NULL,
.dcs_list =  NULL,
.preamp =   { RIG_DBLST_END, },
.attenuator =   { RIG_DBLST_END, },
.max_rit =  Hz(0),
.max_xit =  Hz(0),
.max_ifshift =  Hz(0),
.targetable_vfo =  0,
.vfo_ops =  IC707_VFO_OPS,
.scan_ops =  IC707_SCAN_OPS,
.transceive =  RIG_TRN_RIG,
.bank_qty =   0,
.chan_desc_sz =  0,

.chan_list =  {
	{   1,  26, RIG_MTYPE_MEM, IC_MIN_MEM_CAP },
	{  27,  30, RIG_MTYPE_EDGE, IC_MIN_MEM_CAP },
	{  31,  35, RIG_MTYPE_SAT, IC_MIN_MEM_CAP },	/* split ? */
	RIG_CHAN_END,
	},

.rx_range_list1 =   {
	{kHz(500),MHz(30),IC707_ALL_RX_MODES,-1,-1,IC707_VFO_ALL},
	RIG_FRNG_END, },
.tx_range_list1 =  {
	FRQ_RNG_HF(1,IC707_OTHER_TX_MODES, W(5),W(100),IC707_VFO_ALL,IC707_ANTS),
	FRQ_RNG_HF(1,IC707_AM_TX_MODES, W(5),W(25),IC707_VFO_ALL,IC707_ANTS),  /* AM class */
	RIG_FRNG_END, },

.rx_range_list2 =   {
	{kHz(500),MHz(30),IC707_ALL_RX_MODES,-1,-1,IC707_VFO_ALL},
	RIG_FRNG_END, },
.tx_range_list2 =  {
	FRQ_RNG_HF(2,IC707_OTHER_TX_MODES, W(5),W(100),IC707_VFO_ALL,IC707_ANTS),
	FRQ_RNG_HF(2,IC707_AM_TX_MODES, W(5),W(25),IC707_VFO_ALL,IC707_ANTS),  /* AM class */
	RIG_FRNG_END, },

.tuning_steps = 	{
	{IC707_ALL_RX_MODES,10},  /* basic resolution, there's no set_ts */
	RIG_TS_END,
	},
	/* mode/filter list, remember: order matters! */
.filters = 	{
	{RIG_MODE_SSB|RIG_MODE_CW, kHz(2.1)},
	{RIG_MODE_AM, kHz(6)},
	{RIG_MODE_FM, kHz(12)},
	RIG_FLT_END,
	},

.cfgparams =  icom_cfg_params,
.set_conf =  icom_set_conf,
.get_conf =  icom_get_conf,

.priv =  (void*)&ic707_priv_caps,
.rig_init =	icom_init,
.rig_cleanup =	icom_cleanup,
.rig_open =  NULL,
.rig_close =  NULL,

.set_freq =  icom_set_freq,
.get_freq =  icom_get_freq,
.set_mode =  icom_set_mode,
.get_mode =  icom_get_mode,
.set_vfo =  icom_set_vfo,
.set_split_vfo =  icom_set_split_vfo,
.set_split_freq =  icom_set_split_freq,
.get_split_freq =  icom_get_split_freq,
.set_split_mode =  icom_set_split_mode,
.get_split_mode =  icom_get_split_mode,

.scan =  icom_scan,

.decode_event =  icom_decode_event,
.set_mem =  icom_set_mem,
.vfo_op =  icom_vfo_op,

};

