/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSpeechRecognition.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_start);
static JSC_DECLARE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_stop);
static JSC_DECLARE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_abort);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognitionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_lang);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_lang);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_continuous);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_continuous);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_interimResults);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_interimResults);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_maxAlternatives);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_maxAlternatives);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onaudiostart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onaudiostart);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onsoundstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onsoundstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onspeechstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onspeechstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onspeechend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onspeechend);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onsoundend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onsoundend);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onaudioend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onaudioend);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onresult);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onresult);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onnomatch);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onnomatch);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onstart);
static JSC_DECLARE_CUSTOM_GETTER(jsSpeechRecognition_onend);
static JSC_DECLARE_CUSTOM_SETTER(setJSSpeechRecognition_onend);

class JSSpeechRecognitionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSpeechRecognitionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSpeechRecognitionPrototype* ptr = new (NotNull, JSC::allocateCell<JSSpeechRecognitionPrototype>(vm)) JSSpeechRecognitionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSpeechRecognitionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSpeechRecognitionPrototype, JSSpeechRecognitionPrototype::Base);

using JSSpeechRecognitionDOMConstructor = JSDOMConstructor<JSSpeechRecognition>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSSpeechRecognitionDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSSpeechRecognitionDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "webkitSpeechRecognition"_s);
    auto& document = downcast<Document>(*context);
    auto object = SpeechRecognition::create(document);
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<SpeechRecognition>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<SpeechRecognition>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSSpeechRecognitionDOMConstructorConstruct, JSSpeechRecognitionDOMConstructor::construct);

template<> const ClassInfo JSSpeechRecognitionDOMConstructor::s_info = { "webkitSpeechRecognition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionDOMConstructor) };

template<> JSValue JSSpeechRecognitionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSSpeechRecognitionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "webkitSpeechRecognition"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSpeechRecognition::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSpeechRecognitionPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognitionConstructor, 0 } },
    { "lang"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_lang, setJSSpeechRecognition_lang } },
    { "continuous"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_continuous, setJSSpeechRecognition_continuous } },
    { "interimResults"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_interimResults, setJSSpeechRecognition_interimResults } },
    { "maxAlternatives"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_maxAlternatives, setJSSpeechRecognition_maxAlternatives } },
    { "onaudiostart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onaudiostart, setJSSpeechRecognition_onaudiostart } },
    { "onsoundstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onsoundstart, setJSSpeechRecognition_onsoundstart } },
    { "onspeechstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onspeechstart, setJSSpeechRecognition_onspeechstart } },
    { "onspeechend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onspeechend, setJSSpeechRecognition_onspeechend } },
    { "onsoundend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onsoundend, setJSSpeechRecognition_onsoundend } },
    { "onaudioend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onaudioend, setJSSpeechRecognition_onaudioend } },
    { "onresult"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onresult, setJSSpeechRecognition_onresult } },
    { "onnomatch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onnomatch, setJSSpeechRecognition_onnomatch } },
    { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onerror, setJSSpeechRecognition_onerror } },
    { "onstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onstart, setJSSpeechRecognition_onstart } },
    { "onend"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSpeechRecognition_onend, setJSSpeechRecognition_onend } },
    { "start"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSpeechRecognitionPrototypeFunction_start, 0 } },
    { "stop"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSpeechRecognitionPrototypeFunction_stop, 0 } },
    { "abort"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSpeechRecognitionPrototypeFunction_abort, 0 } },
};

const ClassInfo JSSpeechRecognitionPrototype::s_info = { "webkitSpeechRecognition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognitionPrototype) };

void JSSpeechRecognitionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSpeechRecognition::info(), JSSpeechRecognitionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSpeechRecognition::s_info = { "webkitSpeechRecognition"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSpeechRecognition) };

JSSpeechRecognition::JSSpeechRecognition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SpeechRecognition>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<SpeechRecognition> JSSpeechRecognition::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, SpeechRecognition>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSSpeechRecognition::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSpeechRecognitionPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSpeechRecognitionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSpeechRecognition::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSpeechRecognition>(vm, globalObject);
}

JSValue JSSpeechRecognition::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSpeechRecognitionDOMConstructor, DOMConstructorID::SpeechRecognition>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognitionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSpeechRecognitionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSpeechRecognition::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSpeechRecognition_langGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lang())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_lang, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_langGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_langSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLang(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_lang, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_langSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_continuousGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.continuous())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_continuous, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_continuousGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_continuousSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setContinuous(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_continuous, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_continuousSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_interimResultsGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.interimResults())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_interimResults, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_interimResultsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_interimResultsSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setInterimResults(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_interimResults, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_interimResultsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_maxAlternativesGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxAlternatives())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_maxAlternatives, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_maxAlternativesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_maxAlternativesSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxAlternatives(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_maxAlternatives, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_maxAlternativesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onaudiostartGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().audiostartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onaudiostart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onaudiostartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onaudiostartSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().audiostartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onaudiostart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onaudiostartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onsoundstartGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().soundstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onsoundstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onsoundstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onsoundstartSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().soundstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onsoundstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onsoundstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onspeechstartGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().speechstartEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onspeechstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onspeechstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onspeechstartSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().speechstartEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onspeechstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onspeechstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onspeechendGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().speechendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onspeechend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onspeechendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onspeechendSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().speechendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onspeechend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onspeechendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onsoundendGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().soundendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onsoundend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onsoundendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onsoundendSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().soundendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onsoundend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onsoundendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onaudioendGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().audioendEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onaudioend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onaudioendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onaudioendSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().audioendEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onaudioend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onaudioendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onresultGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resultEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onresult, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onresultGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onresultSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resultEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onresult, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onresultSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onnomatchGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().nomatchEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onnomatch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onnomatchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onnomatchSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().nomatchEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onnomatch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onnomatchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onstartGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().startEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onstartSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().startEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSpeechRecognition_onendGetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().endEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSpeechRecognition_onend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::get<jsSpeechRecognition_onendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSpeechRecognition_onendSetter(JSGlobalObject& lexicalGlobalObject, JSSpeechRecognition& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().endEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSpeechRecognition_onend, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSpeechRecognition>::set<setJSSpeechRecognition_onendSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsSpeechRecognitionPrototypeFunction_startBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechRecognition>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startRecognition(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_start, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSpeechRecognition>::call<jsSpeechRecognitionPrototypeFunction_startBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsSpeechRecognitionPrototypeFunction_stopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechRecognition>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stopRecognition(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_stop, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSpeechRecognition>::call<jsSpeechRecognitionPrototypeFunction_stopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsSpeechRecognitionPrototypeFunction_abortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSpeechRecognition>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.abortRecognition(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSpeechRecognitionPrototypeFunction_abort, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSpeechRecognition>::call<jsSpeechRecognitionPrototypeFunction_abortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

JSC::GCClient::IsoSubspace* JSSpeechRecognition::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSpeechRecognition, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSpeechRecognition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSpeechRecognition = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSpeechRecognition.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSpeechRecognition = std::forward<decltype(space)>(space); }
    );
}

void JSSpeechRecognition::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSpeechRecognition*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSpeechRecognitionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsSpeechRecognition = jsCast<JSSpeechRecognition*>(handle.slot()->asCell());
    auto& wrapped = jsSpeechRecognition->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSpeechRecognitionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSpeechRecognition = static_cast<JSSpeechRecognition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSpeechRecognition->protectedWrapped().ptr(), jsSpeechRecognition);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SpeechRecognition@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17SpeechRecognitionE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, SpeechRecognition>, void>> static inline void verifyVTable(SpeechRecognition* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SpeechRecognition@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17SpeechRecognitionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SpeechRecognition has subclasses. If SpeechRecognition has subclasses that get passed
        // to toJS() we currently require SpeechRecognition you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SpeechRecognition>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SpeechRecognition>(impl.ptr());
#endif
    return createWrapper<SpeechRecognition>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SpeechRecognition& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SpeechRecognition* JSSpeechRecognition::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSpeechRecognition*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
