/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSReportingObserver.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSReport.h"
#include "JSReportingObserverCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ReportingObserver::Options>> convertDictionary<ReportingObserver::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ReportingObserver::Options result;
    JSValue bufferedValue;
    if (isNullOrUndefined)
        bufferedValue = jsUndefined();
    else {
        bufferedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffered"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bufferedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bufferedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bufferedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.buffered = bufferedConversionResult.releaseReturnValue();
    JSValue typesValue;
    if (isNullOrUndefined)
        typesValue = jsUndefined();
    else {
        typesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "types"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!typesValue.isUndefined()) {
        auto typesConversionResult = convert<IDLNullable<IDLSequence<IDLAtomStringAdaptor<IDLDOMString>>>>(lexicalGlobalObject, typesValue);
        if (UNLIKELY(typesConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.types = typesConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_observe);
static JSC_DECLARE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_disconnect);
static JSC_DECLARE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_takeRecords);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsReportingObserverConstructor);

class JSReportingObserverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSReportingObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSReportingObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSReportingObserverPrototype>(vm)) JSReportingObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSReportingObserverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSReportingObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSReportingObserverPrototype, JSReportingObserverPrototype::Base);

using JSReportingObserverDOMConstructor = JSDOMConstructor<JSReportingObserver>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSReportingObserverDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSReportingObserverDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "ReportingObserver"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSReportingObserverCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "ReportingObserver"_s, nullptr); });
    if (UNLIKELY(callbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<ReportingObserver::Options>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = ReportingObserver::create(*context, callbackConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<ReportingObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<ReportingObserver>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSReportingObserverDOMConstructorConstruct, JSReportingObserverDOMConstructor::construct);

template<> const ClassInfo JSReportingObserverDOMConstructor::s_info = { "ReportingObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSReportingObserverDOMConstructor) };

template<> JSValue JSReportingObserverDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSReportingObserverDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ReportingObserver"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSReportingObserver::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSReportingObserverPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsReportingObserverConstructor, 0 } },
    { "observe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsReportingObserverPrototypeFunction_observe, 0 } },
    { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsReportingObserverPrototypeFunction_disconnect, 0 } },
    { "takeRecords"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsReportingObserverPrototypeFunction_takeRecords, 0 } },
};

const ClassInfo JSReportingObserverPrototype::s_info = { "ReportingObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSReportingObserverPrototype) };

void JSReportingObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSReportingObserver::info(), JSReportingObserverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSReportingObserver::s_info = { "ReportingObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSReportingObserver) };

JSReportingObserver::JSReportingObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ReportingObserver>&& impl)
    : JSDOMWrapper<ReportingObserver>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, ReportingObserver>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSReportingObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSReportingObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSReportingObserverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSReportingObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSReportingObserver>(vm, globalObject);
}

JSValue JSReportingObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSReportingObserverDOMConstructor, DOMConstructorID::ReportingObserver>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSReportingObserver::destroy(JSC::JSCell* cell)
{
    JSReportingObserver* thisObject = static_cast<JSReportingObserver*>(cell);
    thisObject->JSReportingObserver::~JSReportingObserver();
}

JSC_DEFINE_CUSTOM_GETTER(jsReportingObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSReportingObserverPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSReportingObserver::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsReportingObserverPrototypeFunction_observeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSReportingObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.observe(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_observe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSReportingObserver>::call<jsReportingObserverPrototypeFunction_observeBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsReportingObserverPrototypeFunction_disconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSReportingObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSReportingObserver>::call<jsReportingObserverPrototypeFunction_disconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsReportingObserverPrototypeFunction_takeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSReportingObserver>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<Report>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.takeRecords())));
}

JSC_DEFINE_HOST_FUNCTION(jsReportingObserverPrototypeFunction_takeRecords, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSReportingObserver>::call<jsReportingObserverPrototypeFunction_takeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

JSC::GCClient::IsoSubspace* JSReportingObserver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSReportingObserver, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForReportingObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForReportingObserver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForReportingObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForReportingObserver = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSReportingObserver::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSReportingObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSReportingObserver);

template<typename Visitor>
void JSReportingObserver::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSReportingObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSReportingObserver::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSReportingObserver::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSReportingObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSReportingObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSReportingObserverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsReportingObserver = jsCast<JSReportingObserver*>(handle.slot()->asCell());
    auto& wrapped = jsReportingObserver->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSReportingObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsReportingObserver = static_cast<JSReportingObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsReportingObserver->protectedWrapped().ptr(), jsReportingObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ReportingObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17ReportingObserverE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ReportingObserver>, void>> static inline void verifyVTable(ReportingObserver* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ReportingObserver@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore17ReportingObserverE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ReportingObserver has subclasses. If ReportingObserver has subclasses that get passed
        // to toJS() we currently require ReportingObserver you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ReportingObserver>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ReportingObserver>(impl.ptr());
#endif
    return createWrapper<ReportingObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ReportingObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ReportingObserver* JSReportingObserver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSReportingObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
