/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaSessionAction.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaSessionAction enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("play"),
        MAKE_STATIC_STRING_IMPL("pause"),
        MAKE_STATIC_STRING_IMPL("seekbackward"),
        MAKE_STATIC_STRING_IMPL("seekforward"),
        MAKE_STATIC_STRING_IMPL("previoustrack"),
        MAKE_STATIC_STRING_IMPL("nexttrack"),
        MAKE_STATIC_STRING_IMPL("skipad"),
        MAKE_STATIC_STRING_IMPL("stop"),
        MAKE_STATIC_STRING_IMPL("seekto"),
        MAKE_STATIC_STRING_IMPL("togglemicrophone"),
        MAKE_STATIC_STRING_IMPL("togglecamera"),
        MAKE_STATIC_STRING_IMPL("togglescreenshare"),
    };
    static_assert(static_cast<size_t>(MediaSessionAction::Play) == 0, "MediaSessionAction::Play is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Pause) == 1, "MediaSessionAction::Pause is not 1 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Seekbackward) == 2, "MediaSessionAction::Seekbackward is not 2 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Seekforward) == 3, "MediaSessionAction::Seekforward is not 3 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Previoustrack) == 4, "MediaSessionAction::Previoustrack is not 4 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Nexttrack) == 5, "MediaSessionAction::Nexttrack is not 5 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Skipad) == 6, "MediaSessionAction::Skipad is not 6 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Stop) == 7, "MediaSessionAction::Stop is not 7 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Seekto) == 8, "MediaSessionAction::Seekto is not 8 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Togglemicrophone) == 9, "MediaSessionAction::Togglemicrophone is not 9 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Togglecamera) == 10, "MediaSessionAction::Togglecamera is not 10 as expected");
    static_assert(static_cast<size_t>(MediaSessionAction::Togglescreenshare) == 11, "MediaSessionAction::Togglescreenshare is not 11 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaSessionAction enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaSessionAction> parseEnumerationFromString<MediaSessionAction>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, MediaSessionAction> mappings[] = {
        { "nexttrack", MediaSessionAction::Nexttrack },
        { "pause", MediaSessionAction::Pause },
        { "play", MediaSessionAction::Play },
        { "previoustrack", MediaSessionAction::Previoustrack },
        { "seekbackward", MediaSessionAction::Seekbackward },
        { "seekforward", MediaSessionAction::Seekforward },
        { "seekto", MediaSessionAction::Seekto },
        { "skipad", MediaSessionAction::Skipad },
        { "stop", MediaSessionAction::Stop },
        { "togglecamera", MediaSessionAction::Togglecamera },
        { "togglemicrophone", MediaSessionAction::Togglemicrophone },
        { "togglescreenshare", MediaSessionAction::Togglescreenshare },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaSessionAction> parseEnumeration<MediaSessionAction>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaSessionAction>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaSessionAction>()
{
    return "\"play\", \"pause\", \"seekbackward\", \"seekforward\", \"previoustrack\", \"nexttrack\", \"skipad\", \"stop\", \"seekto\", \"togglemicrophone\", \"togglecamera\", \"togglescreenshare\""_s;
}

} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
