/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaImage.h"

#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SESSION)

template<> ConversionResult<IDLDictionary<MediaImage>> convertDictionary<MediaImage>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaImage result;
    JSValue sizesValue;
    if (isNullOrUndefined)
        sizesValue = jsUndefined();
    else {
        sizesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sizes"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sizesConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, sizesValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(sizesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.sizes = sizesConversionResult.releaseReturnValue();
    JSValue srcValue;
    if (isNullOrUndefined)
        srcValue = jsUndefined();
    else {
        srcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "src"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (srcValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "src"_s, "MediaImage"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto srcConversionResult = convert<IDLUSVString>(lexicalGlobalObject, srcValue);
    if (UNLIKELY(srcConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.src = srcConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaImage& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto sizesValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.sizes);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "sizes"_s), sizesValue);
    auto srcValue = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, dictionary.src);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "src"_s), srcValue);
    auto typeValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.type);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "type"_s), typeValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
