/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrixInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DOMMatrixInit>> convertDictionary<DOMMatrixInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DOMMatrixInit result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!aValue.isUndefined()) {
        auto aConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, aValue);
        if (UNLIKELY(aConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.a = aConversionResult.releaseReturnValue();
    }
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bValue.isUndefined()) {
        auto bConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, bValue);
        if (UNLIKELY(bConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.b = bConversionResult.releaseReturnValue();
    }
    JSValue cValue;
    if (isNullOrUndefined)
        cValue = jsUndefined();
    else {
        cValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "c"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!cValue.isUndefined()) {
        auto cConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, cValue);
        if (UNLIKELY(cConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.c = cConversionResult.releaseReturnValue();
    }
    JSValue dValue;
    if (isNullOrUndefined)
        dValue = jsUndefined();
    else {
        dValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "d"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!dValue.isUndefined()) {
        auto dConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, dValue);
        if (UNLIKELY(dConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.d = dConversionResult.releaseReturnValue();
    }
    JSValue eValue;
    if (isNullOrUndefined)
        eValue = jsUndefined();
    else {
        eValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "e"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!eValue.isUndefined()) {
        auto eConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, eValue);
        if (UNLIKELY(eConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.e = eConversionResult.releaseReturnValue();
    }
    JSValue fValue;
    if (isNullOrUndefined)
        fValue = jsUndefined();
    else {
        fValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "f"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fValue.isUndefined()) {
        auto fConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, fValue);
        if (UNLIKELY(fConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.f = fConversionResult.releaseReturnValue();
    }
    JSValue m11Value;
    if (isNullOrUndefined)
        m11Value = jsUndefined();
    else {
        m11Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m11"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m11Value.isUndefined()) {
        auto m11ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m11Value);
        if (UNLIKELY(m11ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m11 = m11ConversionResult.releaseReturnValue();
    }
    JSValue m12Value;
    if (isNullOrUndefined)
        m12Value = jsUndefined();
    else {
        m12Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m12"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m12Value.isUndefined()) {
        auto m12ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m12Value);
        if (UNLIKELY(m12ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m12 = m12ConversionResult.releaseReturnValue();
    }
    JSValue m21Value;
    if (isNullOrUndefined)
        m21Value = jsUndefined();
    else {
        m21Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m21"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m21Value.isUndefined()) {
        auto m21ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m21Value);
        if (UNLIKELY(m21ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m21 = m21ConversionResult.releaseReturnValue();
    }
    JSValue m22Value;
    if (isNullOrUndefined)
        m22Value = jsUndefined();
    else {
        m22Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m22"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m22Value.isUndefined()) {
        auto m22ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m22Value);
        if (UNLIKELY(m22ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m22 = m22ConversionResult.releaseReturnValue();
    }
    JSValue m41Value;
    if (isNullOrUndefined)
        m41Value = jsUndefined();
    else {
        m41Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m41"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m41Value.isUndefined()) {
        auto m41ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m41Value);
        if (UNLIKELY(m41ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m41 = m41ConversionResult.releaseReturnValue();
    }
    JSValue m42Value;
    if (isNullOrUndefined)
        m42Value = jsUndefined();
    else {
        m42Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m42"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m42Value.isUndefined()) {
        auto m42ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m42Value);
        if (UNLIKELY(m42ConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.m42 = m42ConversionResult.releaseReturnValue();
    }
    JSValue is2DValue;
    if (isNullOrUndefined)
        is2DValue = jsUndefined();
    else {
        is2DValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "is2D"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!is2DValue.isUndefined()) {
        auto is2DConversionResult = convert<IDLBoolean>(lexicalGlobalObject, is2DValue);
        if (UNLIKELY(is2DConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.is2D = is2DConversionResult.releaseReturnValue();
    }
    JSValue m13Value;
    if (isNullOrUndefined)
        m13Value = jsUndefined();
    else {
        m13Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m13"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m13ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m13Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m13ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m13 = m13ConversionResult.releaseReturnValue();
    JSValue m14Value;
    if (isNullOrUndefined)
        m14Value = jsUndefined();
    else {
        m14Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m14"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m14ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m14Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m14ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m14 = m14ConversionResult.releaseReturnValue();
    JSValue m23Value;
    if (isNullOrUndefined)
        m23Value = jsUndefined();
    else {
        m23Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m23"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m23ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m23Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m23ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m23 = m23ConversionResult.releaseReturnValue();
    JSValue m24Value;
    if (isNullOrUndefined)
        m24Value = jsUndefined();
    else {
        m24Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m24"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m24ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m24Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m24ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m24 = m24ConversionResult.releaseReturnValue();
    JSValue m31Value;
    if (isNullOrUndefined)
        m31Value = jsUndefined();
    else {
        m31Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m31"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m31ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m31Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m31ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m31 = m31ConversionResult.releaseReturnValue();
    JSValue m32Value;
    if (isNullOrUndefined)
        m32Value = jsUndefined();
    else {
        m32Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m32"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m32ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m32Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m32ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m32 = m32ConversionResult.releaseReturnValue();
    JSValue m33Value;
    if (isNullOrUndefined)
        m33Value = jsUndefined();
    else {
        m33Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m33"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m33ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m33Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (UNLIKELY(m33ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m33 = m33ConversionResult.releaseReturnValue();
    JSValue m34Value;
    if (isNullOrUndefined)
        m34Value = jsUndefined();
    else {
        m34Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m34"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m34ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m34Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m34ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m34 = m34ConversionResult.releaseReturnValue();
    JSValue m43Value;
    if (isNullOrUndefined)
        m43Value = jsUndefined();
    else {
        m43Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m43"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m43ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m43Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (UNLIKELY(m43ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m43 = m43ConversionResult.releaseReturnValue();
    JSValue m44Value;
    if (isNullOrUndefined)
        m44Value = jsUndefined();
    else {
        m44Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m44"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto m44ConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, m44Value, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1 }; });
    if (UNLIKELY(m44ConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.m44 = m44ConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
