/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import gnu.trove.list.array.TIntArrayList;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.osmand.data.LatLon;
import net.osmand.data.PointDescription;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.GpxSelectionHelper;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.base.FavoriteImageDrawable;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.views.MapTextLayer;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;
import net.sourceforge.offroad.ui.PorterDuffMultiplyFilter;

public class GPXLayer
extends OsmandMapLayer
implements IContextMenuProvider,
MapTextLayer.MapTextProvider<GPXUtilities.WptPt> {
    private OsmBitmapPanel view;
    private Paint paint;
    private Paint paint2;
    private boolean isPaint2;
    private Paint shadowPaint;
    private boolean isShadowPaint;
    private Paint paint_1;
    private boolean isPaint_1;
    private int cachedHash;
    private int cachedColor;
    private Paint paintIcon;
    private BufferedImage pointSmall;
    private static final int startZoom = 7;
    private GpxSelectionHelper selectedGpxHelper;
    private Paint paintBmp;
    private List<GPXUtilities.WptPt> cache = new ArrayList<GPXUtilities.WptPt>();
    private MapTextLayer textLayer;
    private Paint paintOuter;
    private Paint paintInnerCircle;
    private Paint paintTextIcon;
    private OsmandRenderer osmandRenderer;
    private List<GPXUtilities.TrkSegment> points;
    private GPXUtilities.GPXFile gpx;

    private void initUI() {
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setAntiAlias(true);
        this.paint2 = new Paint();
        this.paint2.setStyle(Paint.Style.STROKE);
        this.paint2.setAntiAlias(true);
        this.shadowPaint = new Paint();
        this.shadowPaint.setStyle(Paint.Style.STROKE);
        this.shadowPaint.setAntiAlias(true);
        this.paint_1 = new Paint();
        this.paint_1.setStyle(Paint.Style.STROKE);
        this.paint_1.setAntiAlias(true);
        this.paintBmp = new Paint();
        this.paintBmp.setAntiAlias(true);
        this.paintBmp.setFilterBitmap(true);
        this.paintBmp.setDither(true);
        this.paintTextIcon = new Paint();
        this.paintTextIcon.setTextSize(10.0f * this.view.getDensity());
        this.paintTextIcon.setTextAlign(Paint.Align.CENTER);
        this.paintTextIcon.setFakeBoldText(true);
        this.paintTextIcon.setColor(Color.BLACK);
        this.paintTextIcon.setAntiAlias(true);
        this.textLayer = this.view.getLayerByClass(MapTextLayer.class);
        this.paintOuter = new Paint();
        this.paintOuter.setColor(-2007673515);
        this.paintOuter.setAntiAlias(true);
        this.paintOuter.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintInnerCircle = new Paint();
        this.paintInnerCircle.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintInnerCircle.setColor(-570425345);
        this.paintInnerCircle.setAntiAlias(true);
        this.paintIcon = new Paint();
        this.pointSmall = this.readImage("map_white_shield_small", this.view);
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.selectedGpxHelper = view.getApplication().getSelectedGpxHelper();
        this.osmandRenderer = view.getApplication().getResourceManager().getRenderer().getRenderer();
        this.initUI();
    }

    public void updateLayerStyle() {
        this.cachedHash = -1;
    }

    private int updatePaints(int color2, boolean routePoints, boolean currentTrack, OsmandMapLayer.DrawSettings nightMode, RotatedTileBox tileBox) {
        RenderingRulesStorage rrs = this.view.getApplication().getRendererRegistry().getCurrentSelectedRenderer();
        boolean isNight = nightMode != null && nightMode.isNightMode();
        int hsh = this.calculateHash(rrs, routePoints, isNight, tileBox.getMapDensity());
        if (hsh != this.cachedHash) {
            this.cachedHash = hsh;
            this.cachedColor = this.view.getResources().getColor(R.color.gpx_track);
            if (rrs != null) {
                RenderingRuleProperty ctWidth;
                OsmandSettings.CommonPreference<String> p2;
                RenderingRuleProperty ctColor;
                RenderingRuleSearchRequest req = new RenderingRuleSearchRequest(rrs);
                req.setBooleanFilter(rrs.PROPS.R_NIGHT_MODE, isNight);
                OsmandSettings.CommonPreference<String> p = this.view.getSettings().getCustomRenderProperty("currentTrackColor");
                if (p != null && p.isSet() && (ctColor = rrs.PROPS.get("currentTrackColor")) != null) {
                    req.setStringFilter(ctColor, p.get());
                }
                if ((p2 = this.view.getSettings().getCustomRenderProperty("currentTrackWidth")) != null && p2.isSet() && (ctWidth = rrs.PROPS.get("currentTrackWidth")) != null) {
                    req.setStringFilter(ctWidth, p2.get());
                }
                String additional = "";
                if (routePoints) {
                    additional = "routePoints=true";
                }
                if (currentTrack) {
                    additional = (additional.length() == 0 ? "" : ";") + "currentTrack=true";
                }
                if (additional.length() > 0) {
                    req.setStringFilter(rrs.PROPS.R_ADDITIONAL, additional);
                }
                if (req.searchRenderingAttribute("gpx")) {
                    OsmandRenderer.RenderingContext rc = new OsmandRenderer.RenderingContext();
                    rc.setDensityValue((float)tileBox.getMapDensity());
                    this.cachedColor = req.getIntPropertyValue(rrs.PROPS.R_COLOR);
                    this.osmandRenderer.updatePaint(req, this.paint, 0, false, rc);
                    this.isPaint2 = this.osmandRenderer.updatePaint(req, this.paint2, 1, false, rc);
                    this.isPaint_1 = this.osmandRenderer.updatePaint(req, this.paint_1, -1, false, rc);
                    this.isShadowPaint = req.isSpecified(rrs.PROPS.R_SHADOW_RADIUS);
                    if (this.isShadowPaint) {
                        this.shadowPaint.setColor(req.getIntPropertyValue(rrs.PROPS.R_SHADOW_COLOR));
                        this.shadowPaint.setColorFilter(AlphaComposite.getInstance(5));
                        this.shadowPaint.setStrokeWidth(this.paint.getStrokeWidth() + 2.0f * rc.getComplexValue(req, rrs.PROPS.R_SHADOW_RADIUS));
                    }
                } else {
                    System.err.println("Rendering attribute gpx is not found !");
                    this.paint.setStrokeWidth(7.0f * this.view.getDensity());
                }
            }
        }
        this.paint.setColor(color2 == 0 ? this.cachedColor : color2);
        return this.cachedColor;
    }

    private int calculateHash(Object ... o) {
        return Arrays.hashCode(o);
    }

    @Override
    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
        if (this.points != null) {
            this.updatePaints(0, false, false, settings, tileBox);
            this.drawSegments(canvas, tileBox, this.points);
        } else {
            List<GpxSelectionHelper.SelectedGpxFile> selectedGPXFiles = this.selectedGpxHelper.getSelectedGPXFiles();
            this.cache.clear();
            if (!selectedGPXFiles.isEmpty()) {
                this.drawSelectedFilesSegments(canvas, tileBox, selectedGPXFiles, settings);
                this.drawSelectedFilesSplits(canvas, tileBox, selectedGPXFiles, settings);
                this.drawSelectedFilesPoints(canvas, tileBox, selectedGPXFiles);
            }
            if (this.textLayer != null && this.textLayer.isVisible()) {
                this.textLayer.putData(this, this.cache);
            }
        }
    }

    private void drawSelectedFilesSplits(Graphics2D canvas, RotatedTileBox tileBox, List<GpxSelectionHelper.SelectedGpxFile> selectedGPXFiles, OsmandMapLayer.DrawSettings settings) {
        if (tileBox.getZoom() >= 7) {
            for (GpxSelectionHelper.SelectedGpxFile g : selectedGPXFiles) {
                List<GpxSelectionHelper.GpxDisplayGroup> groups = g.getDisplayGroups();
                if (groups == null) continue;
                for (GpxSelectionHelper.GpxDisplayGroup group : groups) {
                    List<GpxSelectionHelper.GpxDisplayItem> items = group.getModifiableList();
                    this.drawSplitItems(canvas, tileBox, items, settings);
                }
            }
        }
    }

    private void drawSplitItems(Graphics2D canvas, RotatedTileBox tileBox, List<GpxSelectionHelper.GpxDisplayItem> items, OsmandMapLayer.DrawSettings settings) {
        QuadRect latLonBounds = tileBox.getLatLonBounds();
        int r = (int)(12.0f * tileBox.getDensity());
        int dr = r * 3 / 2;
        int px = -1;
        int py = -1;
        for (int k = 0; k < items.size(); ++k) {
            GpxSelectionHelper.GpxDisplayItem i = items.get(k);
            GPXUtilities.WptPt o = i.locationEnd;
            if (o == null || !(o.lat >= latLonBounds.bottom) || !(o.lat <= latLonBounds.top) || !(o.lon >= latLonBounds.left) || !(o.lon <= latLonBounds.right)) continue;
            int x = (int)tileBox.getPixXFromLatLon(o.lat, o.lon);
            int y = (int)tileBox.getPixYFromLatLon(o.lat, o.lon);
            if ((px != -1 || py != -1) && Math.abs(x - px) <= dr && Math.abs(y - py) <= dr) continue;
            px = x;
            py = y;
            String nm = i.splitName;
            if (nm == null) continue;
            int ind = nm.indexOf(32);
            if (ind > 0) {
                nm = nm.substring(0, ind);
            }
            int radius = (int)((float)r + (float)Math.ceil(tileBox.getDensity()));
            this.paintOuter.updateGraphics(canvas).drawOval(x, y, radius, radius);
            radius = (int)((float)r - (float)Math.ceil(tileBox.getDensity()));
            this.paintInnerCircle.updateGraphics(canvas).drawOval(x, y, radius, radius);
            this.paintTextIcon.setTextSize(r);
            this.paintTextIcon.updateGraphics(canvas).drawString(nm, x, y + r / 2);
        }
    }

    private void drawSelectedFilesPoints(Graphics2D canvas, RotatedTileBox tileBox, List<GpxSelectionHelper.SelectedGpxFile> selectedGPXFiles) {
        int defPointColor = this.view.getResources().getColor(R.color.gpx_color_point);
        int visitedColor = this.view.getContext().getResources().getColor(R.color.color_ok);
        if (tileBox.getZoom() >= 7) {
            float iconSize = (float)(FavoriteImageDrawable.getOrCreate(this.view.getContext(), 0, true).getIntrinsicWidth() * 3) / 2.5f;
            QuadTree<QuadRect> boundIntersections = this.initBoundIntersections(tileBox);
            QuadRect latLonBounds = tileBox.getLatLonBounds();
            for (GpxSelectionHelper.SelectedGpxFile g : selectedGPXFiles) {
                boolean visit;
                float y;
                float x;
                List<GPXUtilities.WptPt> pts = this.getListStarPoints(g);
                ArrayList<GPXUtilities.WptPt> fullObjects = new ArrayList<GPXUtilities.WptPt>();
                ArrayList<LatLon> fullObjectsLatLon = new ArrayList<LatLon>();
                ArrayList<LatLon> smallObjectsLatLon = new ArrayList<LatLon>();
                int fcolor = g.getColor() == 0 ? defPointColor : g.getColor();
                for (GPXUtilities.WptPt o : pts) {
                    if (!(o.lat >= latLonBounds.bottom) || !(o.lat <= latLonBounds.top) || !(o.lon >= latLonBounds.left) || !(o.lon <= latLonBounds.right)) continue;
                    this.cache.add(o);
                    x = tileBox.getPixXFromLatLon(o.lat, o.lon);
                    y = tileBox.getPixYFromLatLon(o.lat, o.lon);
                    if (this.intersects(boundIntersections, x, y, iconSize, iconSize)) {
                        visit = this.isPointVisited(o);
                        int col = visit ? visitedColor : o.getColor(fcolor);
                        this.paintIcon.setColorFilter(new PorterDuffMultiplyFilter(col));
                        this.paintIcon.updateGraphics(canvas).drawImage((Image)this.pointSmall, (int)(x - (float)(this.pointSmall.getWidth() / 2)), (int)(y - (float)(this.pointSmall.getHeight() / 2)), null);
                        smallObjectsLatLon.add(new LatLon(o.lat, o.lon));
                        continue;
                    }
                    fullObjects.add(o);
                    fullObjectsLatLon.add(new LatLon(o.lat, o.lon));
                }
                for (GPXUtilities.WptPt o : fullObjects) {
                    x = tileBox.getPixXFromLatLon(o.lat, o.lon);
                    y = tileBox.getPixYFromLatLon(o.lat, o.lon);
                    visit = this.isPointVisited(o);
                    int pointColor = visit ? visitedColor : o.getColor(fcolor);
                    FavoriteImageDrawable fid = FavoriteImageDrawable.getOrCreate(this.view.getContext(), pointColor, true);
                    fid.drawBitmapInCenter(canvas, x, y);
                }
                this.fullObjectsLatLon = fullObjectsLatLon;
                this.smallObjectsLatLon = smallObjectsLatLon;
            }
        }
    }

    private void drawSelectedFilesSegments(Graphics2D canvas, RotatedTileBox tileBox, List<GpxSelectionHelper.SelectedGpxFile> selectedGPXFiles, OsmandMapLayer.DrawSettings settings) {
        for (GpxSelectionHelper.SelectedGpxFile g : selectedGPXFiles) {
            List<GPXUtilities.TrkSegment> points = g.getPointsToDisplay();
            boolean routePoints = g.isRoutePoints();
            this.updatePaints(g.getColor(), routePoints, g.isShowCurrentTrack(), settings, tileBox);
            this.drawSegments(canvas, tileBox, points);
        }
    }

    private boolean isPointVisited(GPXUtilities.WptPt o) {
        boolean visit = false;
        String visited = o.getExtensionsToRead().get("VISITED_KEY");
        if (visited != null && !visited.equals("0")) {
            visit = true;
        }
        return visit;
    }

    private List<GPXUtilities.WptPt> getListStarPoints(GpxSelectionHelper.SelectedGpxFile g) {
        List<GPXUtilities.WptPt> pts = g.getGpxFile().points;
        return pts;
    }

    private void drawSegments(Graphics2D pCanvas, RotatedTileBox tileBox, List<GPXUtilities.TrkSegment> points) {
        QuadRect latLonBounds = tileBox.getLatLonBounds();
        for (GPXUtilities.TrkSegment l : points) {
            int startIndex = -1;
            int endIndex = -1;
            int prevCross = 0;
            double shift = 0.0;
            for (int i = 0; i < l.points.size(); ++i) {
                GPXUtilities.WptPt ls = l.points.get(i);
                int cross = 0;
                cross |= ls.lon < latLonBounds.left - shift ? 1 : 0;
                cross |= ls.lon > latLonBounds.right + shift ? 2 : 0;
                cross |= ls.lat > latLonBounds.top + shift ? 4 : 0;
                if (i > 0 && (prevCross & (cross |= ls.lat < latLonBounds.bottom - shift ? 8 : 0)) == 0) {
                    if (endIndex != i - 1 || startIndex == -1) {
                        if (startIndex >= 0) {
                            this.drawSegment(pCanvas, tileBox, l, startIndex, endIndex);
                        }
                        startIndex = i - 1;
                    }
                    endIndex = i;
                }
                prevCross = cross;
            }
            if (startIndex == -1) continue;
            this.drawSegment(pCanvas, tileBox, l, startIndex, endIndex);
        }
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
    }

    private void drawSegment(Graphics2D pCanvas, RotatedTileBox tb, GPXUtilities.TrkSegment l, int startIndex, int endIndex) {
        int clr;
        TIntArrayList tx = new TIntArrayList();
        TIntArrayList ty = new TIntArrayList();
        Path2D.Double path = new Path2D.Double();
        for (int i = startIndex; i <= endIndex; ++i) {
            GPXUtilities.WptPt p = l.points.get(i);
            int x = (int)tb.getPixXFromLatLon(p.lat, p.lon);
            int y = (int)tb.getPixYFromLatLon(p.lat, p.lon);
            tx.add(x);
            ty.add(y);
        }
        this.calculatePath(tb, tx, ty, path);
        if (this.isPaint_1) {
            this.paint_1.updateGraphics(pCanvas).draw(path);
        }
        if (this.isShadowPaint) {
            this.shadowPaint.updateGraphics(pCanvas).draw(path);
        }
        if ((clr = this.paint.getColor()) != l.getColor(clr) && l.getColor(clr) != 0) {
            this.paint.setColor(l.getColor(clr));
        }
        this.paint.updateGraphics(pCanvas).draw(path);
        this.paint.setColor(clr);
        if (this.isPaint2) {
            this.paint2.updateGraphics(pCanvas).draw(path);
        }
    }

    private boolean calculateBelongs(int ex, int ey, int objx, int objy, int radius) {
        return Math.abs(objx - ex) <= radius * 2 && Math.abs(objy - ey) <= radius * 2;
    }

    public void getWptFromPoint(RotatedTileBox tb, Point2D point, List<? super GPXUtilities.WptPt> res) {
        int r = (int)(15.0f * tb.getDensity());
        int ex = (int)point.getX();
        int ey = (int)point.getY();
        for (GpxSelectionHelper.SelectedGpxFile g : this.selectedGpxHelper.getSelectedGPXFiles()) {
            List<GPXUtilities.WptPt> pts = this.getListStarPoints(g);
            for (GPXUtilities.WptPt n : pts) {
                int y;
                int x = (int)tb.getPixXFromLatLon(n.lat, n.lon);
                if (!this.calculateBelongs(ex, ey, x, y = (int)tb.getPixYFromLatLon(n.lat, n.lon), r)) continue;
                res.add(n);
            }
        }
    }

    public void getSelectedGpxFileFromPoint(RotatedTileBox tb, Point2D point, List<? super GpxSelectionHelper.SelectedGpxFile> res) {
        double r = 15.0 * tb.getPixelDistanceInMeters();
        LatLon latLon = tb.getLatLonFromPixel(point.getX(), point.getY());
        block0: for (GpxSelectionHelper.SelectedGpxFile g : this.selectedGpxHelper.getSelectedGPXFiles()) {
            List<GPXUtilities.TrkSegment> pts = g.getPointsToDisplay();
            for (GPXUtilities.TrkSegment n : pts) {
                LatLon last = null;
                for (GPXUtilities.WptPt pt : n.points) {
                    double distance;
                    if (last != null && Math.abs(distance = MapUtils.getOrthogonalDistance(latLon, last, pt.getLatLon())) < r) {
                        res.add(g);
                        continue block0;
                    }
                    last = pt.getLatLon();
                }
            }
        }
    }

    @Override
    public String getObjectDescription(Object o) {
        if (o instanceof GPXUtilities.WptPt) {
            return this.view.getContext().getString(1513) + " : " + ((GPXUtilities.WptPt)o).name;
        }
        if (o instanceof GpxSelectionHelper.SelectedGpxFile) {
            return this.view.getContext().getString(1523) + " : " + ((GpxSelectionHelper.SelectedGpxFile)o).getGpxFile().author;
        }
        return null;
    }

    @Override
    public PointDescription getObjectName(Object o) {
        if (o instanceof GPXUtilities.WptPt) {
            return new PointDescription("wpt", ((GPXUtilities.WptPt)o).name);
        }
        if (o instanceof GpxSelectionHelper.SelectedGpxFile) {
            GpxSelectionHelper.SelectedGpxFile sgf = (GpxSelectionHelper.SelectedGpxFile)o;
            return new PointDescription("wpt", sgf.getGpxFile().path);
        }
        return null;
    }

    @Override
    public boolean disableSingleTap() {
        return false;
    }

    @Override
    public boolean disableLongPressOnMap() {
        return false;
    }

    @Override
    public boolean isObjectClickable(Object o) {
        return o instanceof GPXUtilities.WptPt || o instanceof GpxSelectionHelper.SelectedGpxFile;
    }

    @Override
    public void collectObjectsFromPoint(Point2D point, RotatedTileBox tileBox, List<Object> res) {
        this.getWptFromPoint(tileBox, point, res);
        this.getSelectedGpxFileFromPoint(tileBox, point, res);
    }

    @Override
    public LatLon getObjectLocation(Object o) {
        if (o instanceof GPXUtilities.WptPt) {
            return new LatLon(((GPXUtilities.WptPt)o).lat, ((GPXUtilities.WptPt)o).lon);
        }
        return null;
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    @Override
    public boolean onLongPressEvent(Point2D point, RotatedTileBox tileBox) {
        return false;
    }

    @Override
    public LatLon getTextLocation(GPXUtilities.WptPt o) {
        return new LatLon(o.lat, o.lon);
    }

    @Override
    public int getTextShift(GPXUtilities.WptPt o, RotatedTileBox rb) {
        return (int)(16.0f * rb.getDensity());
    }

    @Override
    public String getText(GPXUtilities.WptPt o) {
        return o.name;
    }

    public void setGivenGpx(GPXUtilities.GPXFile gpx) {
        this.gpx = gpx;
        this.points = gpx == null ? null : gpx.proccessPoints();
    }
}

