/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.osm.PoiCategory;
import net.osmand.plus.resources.AmenityIndexRepository;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class AmenityIndexRepositoryBinary
implements AmenityIndexRepository {
    private static final Log log = PlatformUtil.getLog(AmenityIndexRepositoryBinary.class);
    private final BinaryMapIndexReader index;

    public AmenityIndexRepositoryBinary(BinaryMapIndexReader index) {
        this.index = index;
    }

    @Override
    public void close() {
        try {
            this.index.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean checkContains(double latitude, double longitude) {
        return this.index.containsPoiData(latitude, longitude);
    }

    @Override
    public boolean checkContains(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude) {
        return this.index.containsPoiData(topLatitude, leftLongitude, bottomLatitude, rightLongitude);
    }

    public synchronized Map<PoiCategory, List<String>> searchAmenityCategoriesByName(String query, Map<PoiCategory, List<String>> map) {
        try {
            return this.index.searchPoiCategoriesByName(query, map);
        }
        catch (IOException e) {
            log.error((Object)"Error searching amenities", (Throwable)e);
            return map;
        }
    }

    public synchronized List<Amenity> searchAmenitiesByName(int x, int y, int l, int t, int r, int b, String query, ResultMatcher<Amenity> resulMatcher) {
        long now = System.currentTimeMillis();
        List<Amenity> amenities = Collections.emptyList();
        BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(x, y, query, l, r, t, b, resulMatcher);
        try {
            amenities = this.index.searchPoiByName(req);
            if (log.isDebugEnabled()) {
                String nm = "";
                List<BinaryMapIndexReader.MapIndex> mi = this.index.getMapIndexes();
                if (mi.size() > 0) {
                    nm = mi.get(0).getName();
                }
                log.debug((Object)String.format("Search for %s done in %s ms found %s (%s).", query, System.currentTimeMillis() - now, amenities.size(), nm));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error searching amenities", (Throwable)e);
        }
        return amenities;
    }

    @Override
    public synchronized List<Amenity> searchAmenities(int stop, int sleft, int sbottom, int sright, int zoom, BinaryMapIndexReader.SearchPoiTypeFilter filter, ResultMatcher<Amenity> matcher) {
        long now = System.currentTimeMillis();
        BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(sleft, sright, stop, sbottom, zoom, filter, matcher);
        List<Amenity> result = null;
        try {
            result = this.index.searchPoi(req);
        }
        catch (IOException e) {
            log.error((Object)"Error searching amenities", (Throwable)e);
        }
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("Search for %s done in %s ms found %s.", MapUtils.get31LatitudeY(stop) + " " + MapUtils.get31LongitudeX(sleft), System.currentTimeMillis() - now, result.size()));
        }
        return result;
    }

    @Override
    public synchronized List<Amenity> searchAmenitiesOnThePath(List<Location> locations, double radius, BinaryMapIndexReader.SearchPoiTypeFilter filter, ResultMatcher<Amenity> matcher) {
        long now = System.currentTimeMillis();
        List<Amenity> result = null;
        BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(locations, radius, filter, matcher);
        try {
            result = this.index.searchPoi(req);
        }
        catch (IOException e) {
            log.error((Object)"Error searching amenities", (Throwable)e);
            return result;
        }
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("Search done in %s ms found %s.", System.currentTimeMillis() - now, result.size()));
        }
        return result;
    }
}

