// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f413.svd, see https://github.com/tinygo-org/stm32-svd

// +build stm32,stm32f413

// STM32F413
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F413"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// QuadSPI interface
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Reset and clock control
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Secure digital input/output interface
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA1_Stream0 = 11

	// DMA controller
	IRQ_DMA1_Stream1 = 12

	// DMA controller
	IRQ_DMA1_Stream2 = 13

	// DMA controller
	IRQ_DMA1_Stream3 = 14

	// DMA controller
	IRQ_DMA1_Stream4 = 15

	// DMA controller
	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Analog-to-digital converter
	IRQ_ADC = 18

	// Controller area network
	IRQ_CAN1_TX = 19

	// Controller area network
	IRQ_CAN1_RX0 = 20

	// Controller area network
	IRQ_CAN1_RX1 = 21

	// Controller area network
	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// General purpose timers
	IRQ_TIM1_BRK_TIM9 = 24

	// General-purpose-timers
	IRQ_TIM1_UP_TIM10 = 25

	// General-purpose-timers
	IRQ_TIM1_TRG_COM_TIM11 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General-purpose I/Os
	IRQ_TIM2 = 28

	IRQ_TIM3 = 29

	// General purpose timers
	IRQ_TIM4 = 30

	IRQ_I2C1_EVT = 31

	IRQ_I2C1_ERR = 32

	// Inter-integrated circuit
	IRQ_I2C2_EVT = 33

	// Inter-integrated circuit
	IRQ_I2C2_ERR = 34

	IRQ_SPI1 = 35

	// System configuration controller
	IRQ_SPI2 = 36

	// USB on the go full speed
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Reset and clock control
	IRQ_EXTI17_RTC_Alarm = 41

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	// DMA controller
	IRQ_DMA1_Stream7 = 47

	// General purpose timers
	IRQ_FSMC = 48

	// Serial audio interface
	IRQ_SDIO = 49

	// Independent watchdog
	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_USART4 = 52

	IRQ_UART5 = 53

	IRQ_TIM6_GLB_IT_DAC1_DAC2 = 54

	// Basic timers
	IRQ_TIM7 = 55

	IRQ_DMA2_Stream0 = 56

	IRQ_DMA2_Stream1 = 57

	IRQ_DMA2_Stream2 = 58

	IRQ_DMA2_Stream3 = 59

	IRQ_DMA2_Stream4 = 60

	IRQ_DFSDM1_FLT0 = 61

	IRQ_DFSDM1_FLT1 = 62

	IRQ_CAN2_TX = 63

	IRQ_CAN2_RX0 = 64

	IRQ_CAN2_RX1 = 65

	IRQ_CAN2_SCE = 66

	// USB on the go full speed
	IRQ_OTG_FS = 67

	IRQ_DMA2_Stream5 = 68

	IRQ_DMA2_Stream6 = 69

	IRQ_DMA2_Stream7 = 70

	IRQ_USART6 = 71

	// Low power timer
	IRQ_I2C3_EV = 72

	// Low power timer
	IRQ_I2C3_ER = 73

	IRQ_CAN3_TX = 74

	IRQ_CAN3_RX0 = 75

	// fast-mode Inter-integrated circuit
	IRQ_CAN3_RX1 = 76

	IRQ_CAN3_SCE = 77

	// Advanced encryption standard hardware accelerator
	IRQ_CRYPTO = 79

	// Controller area network
	IRQ_RNG = 80

	// Secure digital input/output interface // ADC common registers // Floting point unit
	IRQ_FPU = 81

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART7 = 82

	IRQ_USART8 = 83

	// Serial peripheral interface
	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	// Advanced encryption standard hardware accelerator
	IRQ_SAI1 = 87

	// USB on the go full speed
	IRQ_UART9 = 88

	// USB on the go full speed
	IRQ_UART10 = 89

	// Nested Vectored Interrupt Controller
	IRQ_QuadSPI = 92

	// General purpose timers
	IRQ_I2CFMP1event = 95

	// General purpose timers
	IRQ_I2CFMP1error = 96

	// External interrupt/event controller
	IRQ_lptim1_OR_it_eit_23 = 97

	IRQ_DFSDM2_FILTER1 = 98

	// Digital filter for sigma delta modulators
	IRQ_DFSDM2_FILTER2 = 99

	IRQ_DFSDM2_FILTER3 = 100

	// Digital filter for sigma delta modulators
	IRQ_DFSDM2_FILTER4 = 101

	// Highest interrupt number on this device.
	IRQ_max = 101
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Stream0_IRQHandler
func interruptDMA1_Stream0() {
	callHandlers(IRQ_DMA1_Stream0)
}

//export DMA1_Stream1_IRQHandler
func interruptDMA1_Stream1() {
	callHandlers(IRQ_DMA1_Stream1)
}

//export DMA1_Stream2_IRQHandler
func interruptDMA1_Stream2() {
	callHandlers(IRQ_DMA1_Stream2)
}

//export DMA1_Stream3_IRQHandler
func interruptDMA1_Stream3() {
	callHandlers(IRQ_DMA1_Stream3)
}

//export DMA1_Stream4_IRQHandler
func interruptDMA1_Stream4() {
	callHandlers(IRQ_DMA1_Stream4)
}

//export DMA1_Stream5_IRQHandler
func interruptDMA1_Stream5() {
	callHandlers(IRQ_DMA1_Stream5)
}

//export DMA1_Stream6_IRQHandler
func interruptDMA1_Stream6() {
	callHandlers(IRQ_DMA1_Stream6)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export CAN1_TX_IRQHandler
func interruptCAN1_TX() {
	callHandlers(IRQ_CAN1_TX)
}

//export CAN1_RX0_IRQHandler
func interruptCAN1_RX0() {
	callHandlers(IRQ_CAN1_RX0)
}

//export CAN1_RX1_IRQHandler
func interruptCAN1_RX1() {
	callHandlers(IRQ_CAN1_RX1)
}

//export CAN1_SCE_IRQHandler
func interruptCAN1_SCE() {
	callHandlers(IRQ_CAN1_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM9_IRQHandler
func interruptTIM1_BRK_TIM9() {
	callHandlers(IRQ_TIM1_BRK_TIM9)
}

//export TIM1_UP_TIM10_IRQHandler
func interruptTIM1_UP_TIM10() {
	callHandlers(IRQ_TIM1_UP_TIM10)
}

//export TIM1_TRG_COM_TIM11_IRQHandler
func interruptTIM1_TRG_COM_TIM11() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM11)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EVT_IRQHandler
func interruptI2C1_EVT() {
	callHandlers(IRQ_I2C1_EVT)
}

//export I2C1_ERR_IRQHandler
func interruptI2C1_ERR() {
	callHandlers(IRQ_I2C1_ERR)
}

//export I2C2_EVT_IRQHandler
func interruptI2C2_EVT() {
	callHandlers(IRQ_I2C2_EVT)
}

//export I2C2_ERR_IRQHandler
func interruptI2C2_ERR() {
	callHandlers(IRQ_I2C2_ERR)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export EXTI17_RTC_Alarm_IRQHandler
func interruptEXTI17_RTC_Alarm() {
	callHandlers(IRQ_EXTI17_RTC_Alarm)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_Stream7_IRQHandler
func interruptDMA1_Stream7() {
	callHandlers(IRQ_DMA1_Stream7)
}

//export FSMC_IRQHandler
func interruptFSMC() {
	callHandlers(IRQ_FSMC)
}

//export SDIO_IRQHandler
func interruptSDIO() {
	callHandlers(IRQ_SDIO)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export USART4_IRQHandler
func interruptUSART4() {
	callHandlers(IRQ_USART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_GLB_IT_DAC1_DAC2_IRQHandler
func interruptTIM6_GLB_IT_DAC1_DAC2() {
	callHandlers(IRQ_TIM6_GLB_IT_DAC1_DAC2)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_Stream0_IRQHandler
func interruptDMA2_Stream0() {
	callHandlers(IRQ_DMA2_Stream0)
}

//export DMA2_Stream1_IRQHandler
func interruptDMA2_Stream1() {
	callHandlers(IRQ_DMA2_Stream1)
}

//export DMA2_Stream2_IRQHandler
func interruptDMA2_Stream2() {
	callHandlers(IRQ_DMA2_Stream2)
}

//export DMA2_Stream3_IRQHandler
func interruptDMA2_Stream3() {
	callHandlers(IRQ_DMA2_Stream3)
}

//export DMA2_Stream4_IRQHandler
func interruptDMA2_Stream4() {
	callHandlers(IRQ_DMA2_Stream4)
}

//export DFSDM1_FLT0_IRQHandler
func interruptDFSDM1_FLT0() {
	callHandlers(IRQ_DFSDM1_FLT0)
}

//export DFSDM1_FLT1_IRQHandler
func interruptDFSDM1_FLT1() {
	callHandlers(IRQ_DFSDM1_FLT1)
}

//export CAN2_TX_IRQHandler
func interruptCAN2_TX() {
	callHandlers(IRQ_CAN2_TX)
}

//export CAN2_RX0_IRQHandler
func interruptCAN2_RX0() {
	callHandlers(IRQ_CAN2_RX0)
}

//export CAN2_RX1_IRQHandler
func interruptCAN2_RX1() {
	callHandlers(IRQ_CAN2_RX1)
}

//export CAN2_SCE_IRQHandler
func interruptCAN2_SCE() {
	callHandlers(IRQ_CAN2_SCE)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_Stream5_IRQHandler
func interruptDMA2_Stream5() {
	callHandlers(IRQ_DMA2_Stream5)
}

//export DMA2_Stream6_IRQHandler
func interruptDMA2_Stream6() {
	callHandlers(IRQ_DMA2_Stream6)
}

//export DMA2_Stream7_IRQHandler
func interruptDMA2_Stream7() {
	callHandlers(IRQ_DMA2_Stream7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export CAN3_TX_IRQHandler
func interruptCAN3_TX() {
	callHandlers(IRQ_CAN3_TX)
}

//export CAN3_RX0_IRQHandler
func interruptCAN3_RX0() {
	callHandlers(IRQ_CAN3_RX0)
}

//export CAN3_RX1_IRQHandler
func interruptCAN3_RX1() {
	callHandlers(IRQ_CAN3_RX1)
}

//export CAN3_SCE_IRQHandler
func interruptCAN3_SCE() {
	callHandlers(IRQ_CAN3_SCE)
}

//export CRYPTO_IRQHandler
func interruptCRYPTO() {
	callHandlers(IRQ_CRYPTO)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export USART7_IRQHandler
func interruptUSART7() {
	callHandlers(IRQ_USART7)
}

//export USART8_IRQHandler
func interruptUSART8() {
	callHandlers(IRQ_USART8)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export UART9_IRQHandler
func interruptUART9() {
	callHandlers(IRQ_UART9)
}

//export UART10_IRQHandler
func interruptUART10() {
	callHandlers(IRQ_UART10)
}

//export QuadSPI_IRQHandler
func interruptQuadSPI() {
	callHandlers(IRQ_QuadSPI)
}

//export I2CFMP1event_IRQHandler
func interruptI2CFMP1event() {
	callHandlers(IRQ_I2CFMP1event)
}

//export I2CFMP1error_IRQHandler
func interruptI2CFMP1error() {
	callHandlers(IRQ_I2CFMP1error)
}

//export lptim1_OR_it_eit_23_IRQHandler
func interruptlptim1_OR_it_eit_23() {
	callHandlers(IRQ_lptim1_OR_it_eit_23)
}

//export DFSDM2_FILTER1_IRQHandler
func interruptDFSDM2_FILTER1() {
	callHandlers(IRQ_DFSDM2_FILTER1)
}

//export DFSDM2_FILTER2_IRQHandler
func interruptDFSDM2_FILTER2() {
	callHandlers(IRQ_DFSDM2_FILTER2)
}

//export DFSDM2_FILTER3_IRQHandler
func interruptDFSDM2_FILTER3() {
	callHandlers(IRQ_DFSDM2_FILTER3)
}

//export DFSDM2_FILTER4_IRQHandler
func interruptDFSDM2_FILTER4() {
	callHandlers(IRQ_DFSDM2_FILTER4)
}

// Peripherals.
var (
	// Advanced encryption standard hardware accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Digital filter for sigma delta modulators
	DFSDM2 = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016400)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// fast-mode Inter-integrated circuit
	FMPI2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Low power timer
	LPTIM = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// Secure digital input/output interface
	SDIO = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Serial audio interface
	SAI = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Flexible static memory controller
	FSMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// ADC common registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Controller area network
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006800)))

	// Controller area network
	CAN3 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006c00)))

	// Digital filter for sigma delta modulators
	DFSDM1 = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI6 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015400)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART10 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART9 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011800)))
)

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// AES.CR: control register
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_CHMOD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES.SR: status register
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES.DINR: data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: initialization vector register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: initialization vector register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: initialization vector register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: initialization vector register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// ADC.SR: status register
func (o *ADC_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_STRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_STRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_JSTRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_JSTRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_JEOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_AWD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_AWD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// ADC.CR1: control register 1
func (o *ADC_Type) SetCR1_OVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR1_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR1_RES(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCR1_AWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR1_AWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR1_JAWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR1_JAWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR1_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe000)|value<<13)
}
func (o *ADC_Type) GetCR1_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe000) >> 13
}
func (o *ADC_Type) SetCR1_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCR1_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR1_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR1_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR1_AWDSGL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR1_AWDSGL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR1_SCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR1_SCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCR1_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCR1_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCR1_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR1_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR1_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetCR1_AWDCH() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1f
}

// ADC.CR2: control register 2
func (o *ADC_Type) SetCR2_SWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR2_SWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR2_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR2_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR2_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetCR2_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetCR2_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR2_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR2_EOCS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR2_EOCS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR2_DDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR2_DDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR2_DMA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR2_DMA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR2_CONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR2_CONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR2_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR2_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.JOFR1: injected channel data offset register x
func (o *ADC_Type) SetJOFR1_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR1.Reg, volatile.LoadUint32(&o.JOFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR1_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR1.Reg) & 0xfff
}

// ADC.JOFR2: injected channel data offset register x
func (o *ADC_Type) SetJOFR2_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR2.Reg, volatile.LoadUint32(&o.JOFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR2_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR2.Reg) & 0xfff
}

// ADC.JOFR3: injected channel data offset register x
func (o *ADC_Type) SetJOFR3_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR3.Reg, volatile.LoadUint32(&o.JOFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR3_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR3.Reg) & 0xfff
}

// ADC.JOFR4: injected channel data offset register x
func (o *ADC_Type) SetJOFR4_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR4.Reg, volatile.LoadUint32(&o.JOFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR4_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR4.Reg) & 0xfff
}

// ADC.HTR: watchdog higher threshold register
func (o *ADC_Type) SetHTR_HT(value uint32) {
	volatile.StoreUint32(&o.HTR.Reg, volatile.LoadUint32(&o.HTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetHTR_HT() uint32 {
	return volatile.LoadUint32(&o.HTR.Reg) & 0xfff
}

// ADC.LTR: watchdog lower threshold register
func (o *ADC_Type) SetLTR_LT(value uint32) {
	volatile.StoreUint32(&o.LTR.Reg, volatile.LoadUint32(&o.LTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLTR_LT() uint32 {
	return volatile.LoadUint32(&o.LTR.Reg) & 0xfff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSQR1_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR1_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR1_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR1_SQ15() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR1_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR1_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR1_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR1_SQ13() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0x1f
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR2_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR2_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR2_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR2_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR2_SQ10() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR3_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR3_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR3_SQ5() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR3_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR3_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR3_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR3_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR3_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR3_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR3_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ1() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x1f
}

// ADC.JDR1: injected data register x
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register x
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register x
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register x
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.DR: regular data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: interrupt enable register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_CAN2SB(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x3f00)|value<<8)
}
func (o *CAN_Type) GetFMR_CAN2SB() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x3f00) >> 8
}
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFM1R_FBM14(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFM1R_FBM14() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFM1R_FBM15(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFM1R_FBM15() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFM1R_FBM16(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFM1R_FBM16() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFM1R_FBM17(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFM1R_FBM17() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFM1R_FBM18(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFM1R_FBM18() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFM1R_FBM19(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFM1R_FBM19() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFM1R_FBM20(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFM1R_FBM20() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFM1R_FBM21(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFM1R_FBM21() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFM1R_FBM22(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFM1R_FBM22() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFM1R_FBM23(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFM1R_FBM23() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFM1R_FBM24(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFM1R_FBM24() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFM1R_FBM25(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFM1R_FBM25() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFM1R_FBM26(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFM1R_FBM26() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFM1R_FBM27(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFM1R_FBM27() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000000) >> 27
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFS1R_FSC14(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFS1R_FSC14() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFS1R_FSC15(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFS1R_FSC15() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFS1R_FSC16(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFS1R_FSC16() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFS1R_FSC17(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFS1R_FSC17() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFS1R_FSC18(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFS1R_FSC18() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFS1R_FSC19(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFS1R_FSC19() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFS1R_FSC20(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFS1R_FSC20() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFS1R_FSC21(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFS1R_FSC21() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFS1R_FSC22(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFS1R_FSC22() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFS1R_FSC23(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFS1R_FSC23() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFS1R_FSC24(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFS1R_FSC24() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFS1R_FSC25(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFS1R_FSC25() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFS1R_FSC26(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFS1R_FSC26() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFS1R_FSC27(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFS1R_FSC27() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000000) >> 27
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFFA1R_FFA14(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFFA1R_FFA14() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFFA1R_FFA15(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFFA1R_FFA15() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFFA1R_FFA16(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFFA1R_FFA16() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFFA1R_FFA17(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFFA1R_FFA17() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFFA1R_FFA18(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFFA1R_FFA18() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFFA1R_FFA19(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFFA1R_FFA19() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFFA1R_FFA20(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFFA1R_FFA20() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFFA1R_FFA21(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFFA1R_FFA21() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFFA1R_FFA22(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFFA1R_FFA22() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFFA1R_FFA23(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFFA1R_FFA23() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFFA1R_FFA24(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFFA1R_FFA24() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFFA1R_FFA25(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFFA1R_FFA25() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFFA1R_FFA26(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFFA1R_FFA26() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFFA1R_FFA27(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFFA1R_FFA27() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000000) >> 27
}

// CAN.FA1R: filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFA1R_FACT14(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFA1R_FACT14() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFA1R_FACT15(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFA1R_FACT15() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFA1R_FACT16(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFA1R_FACT16() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFA1R_FACT17(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFA1R_FACT17() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFA1R_FACT18(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFA1R_FACT18() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFA1R_FACT19(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFA1R_FACT19() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFA1R_FACT20(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFA1R_FACT20() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFA1R_FACT21(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFA1R_FACT21() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFA1R_FACT22(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFA1R_FACT22() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFA1R_FACT23(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFA1R_FACT23() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFA1R_FACT24(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFA1R_FACT24() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFA1R_FACT25(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFA1R_FACT25() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFA1R_FACT26(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFA1R_FACT26() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFA1R_FACT27(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFA1R_FACT27() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000000) >> 27
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: mailbox data high register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: mailbox data high register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, value)
}
func (o *CAN_FB_Type) GetFR1() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg)
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, value)
}
func (o *CAN_FB_Type) GetFR2() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg)
}

// Cryptographic processor
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBG.IDCODE: IDCODE
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: Control Register
func (o *DBG_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBG_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBG.APB1_FZ: Debug MCU APB1 Freeze registe
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBG_Type) SetAPB1_FZ_DBG_RTC_Stop(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_RTC_Stop() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400) >> 10
}
func (o *DBG_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C3SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800000)|value<<23)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C3SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800000) >> 23
}

// DBG.APB2_FZ: Debug MCU APB2 Freeze registe
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CH  [8]DFSDM_CH_Type  // 0x0
	FLT [4]DFSDM_FLT_Type // 0x100
}

type DFSDM_CH_Type struct {
	CFGR1  volatile.Register32 // 0x0
	CFGR2  volatile.Register32 // 0x4
	AWSCDR volatile.Register32 // 0x8
	WDATR  volatile.Register32 // 0xC
	DATINR volatile.Register32 // 0x10
	_      [12]byte
}

// DFSDM_CH.CFGR1: channel configuration y register
func (o *DFSDM_CH_Type) SetCFGR1_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *DFSDM_CH_Type) GetCFGR1_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}
func (o *DFSDM_CH_Type) SetCFGR1_CKOUTSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKOUTSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_CH_Type) SetCFGR1_CKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_CH_Type) SetCFGR1_DATPACK(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc000)|value<<14)
}
func (o *DFSDM_CH_Type) GetCFGR1_DATPACK() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc000) >> 14
}
func (o *DFSDM_CH_Type) SetCFGR1_DATMPX(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3000)|value<<12)
}
func (o *DFSDM_CH_Type) GetCFGR1_DATMPX() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x3000) >> 12
}
func (o *DFSDM_CH_Type) SetCFGR1_CHINSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100)|value<<8)
}
func (o *DFSDM_CH_Type) GetCFGR1_CHINSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100) >> 8
}
func (o *DFSDM_CH_Type) SetCFGR1_CHEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80)|value<<7)
}
func (o *DFSDM_CH_Type) GetCFGR1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80) >> 7
}
func (o *DFSDM_CH_Type) SetCFGR1_CKABEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_CH_Type) GetCFGR1_CKABEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40) >> 6
}
func (o *DFSDM_CH_Type) SetCFGR1_SCDEN(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_CH_Type) GetCFGR1_SCDEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_CH_Type) SetCFGR1_SPICKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc)|value<<2)
}
func (o *DFSDM_CH_Type) GetCFGR1_SPICKSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc) >> 2
}
func (o *DFSDM_CH_Type) SetCFGR1_SITP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3)|value)
}
func (o *DFSDM_CH_Type) GetCFGR1_SITP() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x3
}

// DFSDM_CH.CFGR2: channel configuration y register
func (o *DFSDM_CH_Type) SetCFGR2_OFFSET(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_CH_Type) GetCFGR2_OFFSET() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_CH_Type) SetCFGR2_DTRBS(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf8)|value<<3)
}
func (o *DFSDM_CH_Type) GetCFGR2_DTRBS() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0xf8) >> 3
}

// DFSDM_CH.AWSCDR: analog watchdog and short-circuit detector register
func (o *DFSDM_CH_Type) SetAWSCDR_AWFORD(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xc00000)|value<<22)
}
func (o *DFSDM_CH_Type) GetAWSCDR_AWFORD() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0xc00000) >> 22
}
func (o *DFSDM_CH_Type) SetAWSCDR_AWFOSR(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0x1f0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetAWSCDR_AWFOSR() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0x1f0000) >> 16
}
func (o *DFSDM_CH_Type) SetAWSCDR_BKSCD(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xf000)|value<<12)
}
func (o *DFSDM_CH_Type) GetAWSCDR_BKSCD() uint32 {
	return (volatile.LoadUint32(&o.AWSCDR.Reg) & 0xf000) >> 12
}
func (o *DFSDM_CH_Type) SetAWSCDR_SCDT(value uint32) {
	volatile.StoreUint32(&o.AWSCDR.Reg, volatile.LoadUint32(&o.AWSCDR.Reg)&^(0xff)|value)
}
func (o *DFSDM_CH_Type) GetAWSCDR_SCDT() uint32 {
	return volatile.LoadUint32(&o.AWSCDR.Reg) & 0xff
}

// DFSDM_CH.WDATR: channel watchdog filter data register
func (o *DFSDM_CH_Type) SetWDATR_WDATA(value uint32) {
	volatile.StoreUint32(&o.WDATR.Reg, volatile.LoadUint32(&o.WDATR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_CH_Type) GetWDATR_WDATA() uint32 {
	return volatile.LoadUint32(&o.WDATR.Reg) & 0xffff
}

// DFSDM_CH.DATINR: channel data input register
func (o *DFSDM_CH_Type) SetDATINR_INDAT1(value uint32) {
	volatile.StoreUint32(&o.DATINR.Reg, volatile.LoadUint32(&o.DATINR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DFSDM_CH_Type) GetDATINR_INDAT1() uint32 {
	return (volatile.LoadUint32(&o.DATINR.Reg) & 0xffff0000) >> 16
}
func (o *DFSDM_CH_Type) SetDATINR_INDAT0(value uint32) {
	volatile.StoreUint32(&o.DATINR.Reg, volatile.LoadUint32(&o.DATINR.Reg)&^(0xffff)|value)
}
func (o *DFSDM_CH_Type) GetDATINR_INDAT0() uint32 {
	return volatile.LoadUint32(&o.DATINR.Reg) & 0xffff
}

type DFSDM_FLT_Type struct {
	CR1     volatile.Register32 // 0x100
	CR2     volatile.Register32 // 0x104
	ISR     volatile.Register32 // 0x108
	ICR     volatile.Register32 // 0x10C
	JCHGR   volatile.Register32 // 0x110
	FCR     volatile.Register32 // 0x114
	JDATAR  volatile.Register32 // 0x118
	RDATAR  volatile.Register32 // 0x11C
	AWHTR   volatile.Register32 // 0x120
	AWLTR   volatile.Register32 // 0x124
	AWSR    volatile.Register32 // 0x128
	AWCFR   volatile.Register32 // 0x12C
	EXMAX   volatile.Register32 // 0x130
	EXMIN   volatile.Register32 // 0x134
	CNVTIMR volatile.Register32 // 0x138
	_       [68]byte
}

// DFSDM_FLT.CR1: control register 1
func (o *DFSDM_FLT_Type) SetCR1_AWFSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000000)|value<<30)
}
func (o *DFSDM_FLT_Type) GetCR1_AWFSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000000) >> 30
}
func (o *DFSDM_FLT_Type) SetCR1_FAST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000000)|value<<29)
}
func (o *DFSDM_FLT_Type) GetCR1_FAST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000000) >> 29
}
func (o *DFSDM_FLT_Type) SetCR1_RCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x7000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetCR1_RCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x7000000) >> 24
}
func (o *DFSDM_FLT_Type) SetCR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *DFSDM_FLT_Type) GetCR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *DFSDM_FLT_Type) SetCR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *DFSDM_FLT_Type) GetCR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *DFSDM_FLT_Type) SetCR1_RCONT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *DFSDM_FLT_Type) GetCR1_RCONT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *DFSDM_FLT_Type) SetCR1_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *DFSDM_FLT_Type) GetCR1_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *DFSDM_FLT_Type) SetCR1_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x6000)|value<<13)
}
func (o *DFSDM_FLT_Type) GetCR1_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x6000) >> 13
}
func (o *DFSDM_FLT_Type) SetCR1_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x700)|value<<8)
}
func (o *DFSDM_FLT_Type) GetCR1_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x700) >> 8
}
func (o *DFSDM_FLT_Type) SetCR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_FLT_Type) GetCR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *DFSDM_FLT_Type) SetCR1_JSCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetCR1_JSCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetCR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetCR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetCR1_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetCR1_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetCR1_DFEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetCR1_DFEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// DFSDM_FLT.CR2: control register 2
func (o *DFSDM_FLT_Type) SetCR2_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetCR2_AWDCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetCR2_EXCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetCR2_EXCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetCR2_CKABIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *DFSDM_FLT_Type) GetCR2_CKABIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *DFSDM_FLT_Type) SetCR2_SCDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *DFSDM_FLT_Type) GetCR2_SCDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *DFSDM_FLT_Type) SetCR2_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetCR2_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetCR2_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetCR2_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetCR2_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetCR2_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *DFSDM_FLT_Type) SetCR2_REOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetCR2_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetCR2_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetCR2_JEOCIE() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// DFSDM_FLT.ISR: interrupt and status register
func (o *DFSDM_FLT_Type) SetISR_SCDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetISR_SCDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_FLT_Type) SetISR_CKABF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetISR_CKABF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DFSDM_FLT_Type) GetISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DFSDM_FLT_Type) SetISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DFSDM_FLT_Type) GetISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DFSDM_FLT_Type) SetISR_AWDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetISR_AWDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DFSDM_FLT_Type) SetISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DFSDM_FLT_Type) GetISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DFSDM_FLT_Type) SetISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DFSDM_FLT_Type) GetISR_JEOCF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DFSDM_FLT.ICR: interrupt flag clear register
func (o *DFSDM_FLT_Type) SetICR_CLRSCDF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *DFSDM_FLT_Type) GetICR_CLRSCDF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff000000) >> 24
}
func (o *DFSDM_FLT_Type) SetICR_CLRCKABF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetICR_CLRCKABF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetICR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *DFSDM_FLT_Type) GetICR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *DFSDM_FLT_Type) SetICR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *DFSDM_FLT_Type) GetICR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}

// DFSDM_FLT.JCHGR: injected channel group selection register
func (o *DFSDM_FLT_Type) SetJCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.JCHGR.Reg, volatile.LoadUint32(&o.JCHGR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetJCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.JCHGR.Reg) & 0xff
}

// DFSDM_FLT.FCR: filter control register
func (o *DFSDM_FLT_Type) SetFCR_FORD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe0000000)|value<<29)
}
func (o *DFSDM_FLT_Type) GetFCR_FORD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe0000000) >> 29
}
func (o *DFSDM_FLT_Type) SetFCR_FOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3ff0000)|value<<16)
}
func (o *DFSDM_FLT_Type) GetFCR_FOSR() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3ff0000) >> 16
}
func (o *DFSDM_FLT_Type) SetFCR_IOSR(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetFCR_IOSR() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}

// DFSDM_FLT.JDATAR: data register for injected group
func (o *DFSDM_FLT_Type) SetJDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetJDATAR_JDATA() uint32 {
	return (volatile.LoadUint32(&o.JDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetJDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetJDATAR_JDATACH() uint32 {
	return volatile.LoadUint32(&o.JDATAR.Reg) & 0x7
}

// DFSDM_FLT.RDATAR: data register for the regular channel
func (o *DFSDM_FLT_Type) SetRDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RDATA() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetRDATAR_RPEND(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x10)|value<<4)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RPEND() uint32 {
	return (volatile.LoadUint32(&o.RDATAR.Reg) & 0x10) >> 4
}
func (o *DFSDM_FLT_Type) SetRDATAR_RDATACH(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetRDATAR_RDATACH() uint32 {
	return volatile.LoadUint32(&o.RDATAR.Reg) & 0x7
}

// DFSDM_FLT.AWHTR: analog watchdog high threshold register
func (o *DFSDM_FLT_Type) SetAWHTR_AWHT(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWHTR_AWHT() uint32 {
	return (volatile.LoadUint32(&o.AWHTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWHTR_BKAWH(value uint32) {
	volatile.StoreUint32(&o.AWHTR.Reg, volatile.LoadUint32(&o.AWHTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_FLT_Type) GetAWHTR_BKAWH() uint32 {
	return volatile.LoadUint32(&o.AWHTR.Reg) & 0xf
}

// DFSDM_FLT.AWLTR: analog watchdog low threshold register
func (o *DFSDM_FLT_Type) SetAWLTR_AWLT(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWLTR_AWLT() uint32 {
	return (volatile.LoadUint32(&o.AWLTR.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWLTR_BKAWL(value uint32) {
	volatile.StoreUint32(&o.AWLTR.Reg, volatile.LoadUint32(&o.AWLTR.Reg)&^(0xf)|value)
}
func (o *DFSDM_FLT_Type) GetAWLTR_BKAWL() uint32 {
	return volatile.LoadUint32(&o.AWLTR.Reg) & 0xf
}

// DFSDM_FLT.AWSR: analog watchdog status register
func (o *DFSDM_FLT_Type) SetAWSR_AWHTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWSR_AWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWSR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWSR_AWLTF(value uint32) {
	volatile.StoreUint32(&o.AWSR.Reg, volatile.LoadUint32(&o.AWSR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetAWSR_AWLTF() uint32 {
	return volatile.LoadUint32(&o.AWSR.Reg) & 0xff
}

// DFSDM_FLT.AWCFR: analog watchdog clear flag register
func (o *DFSDM_FLT_Type) SetAWCFR_CLRAWHTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetAWCFR_CLRAWHTF() uint32 {
	return (volatile.LoadUint32(&o.AWCFR.Reg) & 0xff00) >> 8
}
func (o *DFSDM_FLT_Type) SetAWCFR_CLRAWLTF(value uint32) {
	volatile.StoreUint32(&o.AWCFR.Reg, volatile.LoadUint32(&o.AWCFR.Reg)&^(0xff)|value)
}
func (o *DFSDM_FLT_Type) GetAWCFR_CLRAWLTF() uint32 {
	return volatile.LoadUint32(&o.AWCFR.Reg) & 0xff
}

// DFSDM_FLT.EXMAX: Extremes detector maximum register
func (o *DFSDM_FLT_Type) SetEXMAX(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetEXMAX() uint32 {
	return (volatile.LoadUint32(&o.EXMAX.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetEXMAX_EXMAXCH(value uint32) {
	volatile.StoreUint32(&o.EXMAX.Reg, volatile.LoadUint32(&o.EXMAX.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetEXMAX_EXMAXCH() uint32 {
	return volatile.LoadUint32(&o.EXMAX.Reg) & 0x7
}

// DFSDM_FLT.EXMIN: Extremes detector minimum register
func (o *DFSDM_FLT_Type) SetEXMIN(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0xffffff00)|value<<8)
}
func (o *DFSDM_FLT_Type) GetEXMIN() uint32 {
	return (volatile.LoadUint32(&o.EXMIN.Reg) & 0xffffff00) >> 8
}
func (o *DFSDM_FLT_Type) SetEXMIN_EXMINCH(value uint32) {
	volatile.StoreUint32(&o.EXMIN.Reg, volatile.LoadUint32(&o.EXMIN.Reg)&^(0x7)|value)
}
func (o *DFSDM_FLT_Type) GetEXMIN_EXMINCH() uint32 {
	return volatile.LoadUint32(&o.EXMIN.Reg) & 0x7
}

// DFSDM_FLT.CNVTIMR: conversion timer register
func (o *DFSDM_FLT_Type) SetCNVTIMR_CNVCNT(value uint32) {
	volatile.StoreUint32(&o.CNVTIMR.Reg, volatile.LoadUint32(&o.CNVTIMR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DFSDM_FLT_Type) GetCNVTIMR_CNVCNT() uint32 {
	return (volatile.LoadUint32(&o.CNVTIMR.Reg) & 0xfffffff0) >> 4
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]DMA_ST_Type      // 0x10
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}

type DMA_ST_Type struct {
	CR   volatile.Register32 // 0x10
	NDTR volatile.Register32 // 0x14
	PAR  volatile.Register32 // 0x18
	M0AR volatile.Register32 // 0x1C
	M1AR volatile.Register32 // 0x20
	FCR  volatile.Register32 // 0x24
}

// DMA_ST.CR: stream x configuration register
func (o *DMA_ST_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1e000000)|value<<25)
}
func (o *DMA_ST_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1e000000) >> 25
}
func (o *DMA_ST_Type) SetCR_MBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_ST_Type) GetCR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_ST_Type) SetCR_PBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_ST_Type) GetCR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DMA_ST_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_ST_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DMA_ST_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_ST_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DMA_ST_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_ST_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA_ST_Type) SetCR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_ST_Type) GetCR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *DMA_ST_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_ST_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *DMA_ST_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_ST_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *DMA_ST_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_ST_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA_ST_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_ST_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA_ST_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_ST_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA_ST_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_ST_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DMA_ST_Type) SetCR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_ST_Type) GetCR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_ST_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_ST_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_ST_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_ST_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_ST_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetCR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_ST_Type) GetCR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_ST_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_ST_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA_ST.NDTR: stream x number of data register
func (o *DMA_ST_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_ST_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_ST.PAR: stream x peripheral address register
func (o *DMA_ST_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_ST_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_ST.M0AR: stream x memory 0 address register
func (o *DMA_ST_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *DMA_ST_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// DMA_ST.M1AR: stream x memory 1 address register
func (o *DMA_ST_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *DMA_ST_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA_ST.FCR: stream x FIFO control register
func (o *DMA_ST_Type) SetFCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_ST_Type) GetFCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x80) >> 7
}
func (o *DMA_ST_Type) SetFCR_FS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_ST_Type) GetFCR_FS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x38) >> 3
}
func (o *DMA_ST_Type) SetFCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetFCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetFCR_FTH(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3)|value)
}
func (o *DMA_ST_Type) GetFCR_FTH() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x3
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: Interrupt mask register (EXTI_IMR)
func (o *EXTI_Type) SetIMR_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}

// EXTI.EMR: Event mask register (EXTI_EMR)
func (o *EXTI_Type) SetEMR_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}

// EXTI.RTSR: Rising Trigger selection register (EXTI_RTSR)
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}

// EXTI.FTSR: Falling Trigger selection register (EXTI_FTSR)
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}

// EXTI.SWIER: Software interrupt event register (EXTI_SWIER)
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}

// EXTI.PR: Pending register (EXTI_PR)
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}

// fast-mode Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x1
}
func (o *I2C_Type) SetOAR1_OA11_7(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR1_OA11_7() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR1_OA18_9(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x300)|value<<8)
}
func (o *I2C_Type) GetOAR1_OA18_9() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x300) >> 8
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Timeout register
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// FLASH.ACR: Flash access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *FLASH_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *FLASH_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *FLASH_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *FLASH_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *FLASH_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *FLASH_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *FLASH_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *FLASH_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}

// FLASH.KEYR: Flash key register
func (o *FLASH_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH.OPTKEYR: Flash option key register
func (o *FLASH_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *FLASH_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// FLASH.SR: Status register
func (o *FLASH_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetSR_PGPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetSR_PGPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// FLASH.CR: Control register
func (o *FLASH_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x78)|value<<3)
}
func (o *FLASH_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x78) >> 3
}
func (o *FLASH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *FLASH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *FLASH_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// FLASH.OPTCR: Flash option control register
func (o *FLASH_Type) SetOPTCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetOPTCR_OPTLOCK() uint32 {
	return volatile.LoadUint32(&o.OPTCR.Reg) & 0x1
}
func (o *FLASH_Type) SetOPTCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetOPTCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetOPTCR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xc)|value<<2)
}
func (o *FLASH_Type) GetOPTCR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xc) >> 2
}
func (o *FLASH_Type) SetOPTCR_WDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetOPTCR_WDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetOPTCR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetOPTCR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetOPTCR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetOPTCR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetOPTCR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff00)|value<<8)
}
func (o *FLASH_Type) GetOPTCR_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff00) >> 8
}
func (o *FLASH_Type) SetOPTCR_NWRP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR_NWRP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xfff0000) >> 16
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// PWR.CR: power control register
func (o *PWR_Type) SetCR_VOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCR_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCR_ADCDC1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR_ADCDC1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR_DBP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR_PLS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR_CWUF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR_CWUF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PWR.CSR: power control/status register
func (o *PWR_Type) SetCSR_WUF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR_WUF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *PWR_Type) SetCSR_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR_BRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR_BRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR_EWUP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR_EWUP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR_BRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR_BRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR_VOSRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCSR_VOSRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: control register
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QUADSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QUADSPI_Type) SetCR_DFM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *QUADSPI_Type) GetCR_DFM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// QUADSPI.DCR: device configuration register
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}

// QUADSPI.SR: status register
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7f00) >> 8
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// QUADSPI.FCR: flag clear register
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// QUADSPI.DLR: data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: communication configuration register
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}
func (o *QUADSPI_Type) SetCCR_DHHC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000000)|value<<30)
}
func (o *QUADSPI_Type) GetCCR_DHHC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000000) >> 30
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}

// QUADSPI.AR: address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: ABR
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_DCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCR_DCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CALIBR: calibration register
func (o *RTC_Type) SetCALIBR_DCS(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCALIBR_DCS() uint32 {
	return (volatile.LoadUint32(&o.CALIBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCALIBR_DC(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCALIBR_DC() uint32 {
	return volatile.LoadUint32(&o.CALIBR.Reg) & 0x1f
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAFCR: tamper and alternate function configuration register
func (o *RTC_Type) SetTAFCR_ALARMOUTTYPE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAFCR_ALARMOUTTYPE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAFCR_TSINSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAFCR_TSINSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAFCR_TAMP1INSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAFCR_TAMP1INSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAFCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAFCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAFCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAFCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAFCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAFCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAFCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAFCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAFCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAFCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAFCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAFCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAFCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAFCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAFCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAFCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAFCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAFCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAFCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAFCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAFCR.Reg) & 0x1
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	_          [4]byte
	DCKCFGR    volatile.Register32 // 0x8C
	CKGATENR   volatile.Register32 // 0x90
	DCKCFGR2   volatile.Register32 // 0x94
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLI2SON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLI2SON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLI2SRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLI2SRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_PLLR(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLCFGR_PLLR() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf000000) >> 24
}

// RCC.CFGR: clock configuration register
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38000000)|value<<27)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38000000) >> 27
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1f0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}

// RCC.CIR: clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_PLLI2SRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_PLLI2SRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_PLLI2SRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400000) >> 22
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_CRYPRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_CRYPRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}

// RCC.AHB3RSTR: peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FSMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FSMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x2) >> 1
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR_TIM12RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1RSTR_TIM12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1RSTR_TIM13RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1RSTR_TIM13RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1RSTR_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_FMPI2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1RSTR_FMPI2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1RSTR_CAN1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR_CAN1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR_CAN2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1RSTR_CAN2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_LPTIMER1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR_LPTIMER1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1RSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR_CAN3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1RSTR_CAN3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1RSTR_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_UART7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR_UART7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1RSTR_UART8RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR_UART8RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000000) >> 31
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2RSTR_SDIORST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDIORST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_DFSDMRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2RSTR_DFSDMRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2RSTR_UART9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB2RSTR_UART9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB2RSTR_UART10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2RSTR_UART10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_SPI5RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_SPI5RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2RSTR_DFSDM2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB2RSTR_DFSDM2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000000) >> 25
}

// RCC.AHB1ENR: AHB1 peripheral clock register
func (o *RCC_Type) SetAHB1ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400000) >> 22
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_CRYPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_CRYPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FSMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FSMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x2) >> 1
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1ENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1ENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1ENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1ENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_FMPI2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1ENR_FMPI2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1ENR_CAN1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR_CAN1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR_CAN2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1ENR_CAN2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_LPTIMER1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR_LPTIMER1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1ENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR_CAN3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1ENR_CAN3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1ENR_DACEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_UART7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR_UART7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1ENR_UART8EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR_UART8EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000000) >> 31
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2ENR_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_DFSDMEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2ENR_DFSDMEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2ENR_DFSDM2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB2ENR_DFSDM2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB2ENR_UART9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB2ENR_UART9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB2ENR_UART10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2ENR_UART10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x80) >> 7
}

// RCC.AHB1LPENR: AHB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB1LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1LPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000) >> 17
}

// RCC.AHB2LPENR: AHB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB2LPENR_OTGFSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2LPENR_OTGFSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2LPENR_FSMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB2LPENR_FSMCLPEN() uint32 {
	return volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB2LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB2LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x2) >> 1
}

// RCC.AHB3LPENR: AHB3 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB3LPENR_FSMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3LPENR_FSMCLPEN() uint32 {
	return volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x2) >> 1
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_FMPI2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB1LPENR_FMPI2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB1LPENR_CAN1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1LPENR_CAN1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1LPENR_CAN2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetAPB1LPENR_CAN2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_LPTIMER1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LPENR_LPTIMER1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LPENR_RTCAPBLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1LPENR_RTCAPBLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB1LPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LPENR_CAN3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetAPB1LPENR_CAN3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetAPB1LPENR_DACLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LPENR_DACLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LPENR_UART7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LPENR_UART7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LPENR_UART8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LPENR_UART8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000000) >> 31
}

// RCC.APB2LPENR: APB2 peripheral clock enabled in low power mode register
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2LPENR_SDIOLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDIOLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_DFSDMLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAPB2LPENR_DFSDMLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAPB2LPENR_UART9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB2LPENR_UART9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB2LPENR_UART10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2LPENR_UART10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB2LPENR_EXTITLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB2LPENR_EXTITLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2LPENR_SAI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2LPENR_SAI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2LPENR_DFSDM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB2LPENR_DFSDM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000000) >> 25
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSEMOD(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEMOD() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}

// RCC.CSR: clock control & status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_WDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_WDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PADRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PADRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.SSCGR: spread spectrum clock generation register
func (o *RCC_Type) SetSSCGR_SSCGEN(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetSSCGR_SSCGEN() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetSSCGR_SPREADSEL(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetSSCGR_SPREADSEL() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetSSCGR_INCSTEP(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0xfffe000)|value<<13)
}
func (o *RCC_Type) GetSSCGR_INCSTEP() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0xfffe000) >> 13
}
func (o *RCC_Type) SetSSCGR_MODPER(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x1fff)|value)
}
func (o *RCC_Type) GetSSCGR_MODPER() uint32 {
	return volatile.LoadUint32(&o.SSCGR.Reg) & 0x1fff
}

// RCC.PLLI2SCFGR: PLLI2S configuration register
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SR(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SR() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SN(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SN() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SM(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SM() uint32 {
	return volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SSRC(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SQ(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SQ() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0xf000000) >> 24
}

// RCC.DCKCFGR: Dedicated Clocks Configuration Register
func (o *RCC_Type) SetDCKCFGR_CKDFSDM1ASEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetDCKCFGR_CKDFSDM1ASEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetDCKCFGR_TIMPRE(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR_TIMPRE() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetDCKCFGR_I2S1SRC(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x6000000)|value<<25)
}
func (o *RCC_Type) GetDCKCFGR_I2S1SRC() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x6000000) >> 25
}
func (o *RCC_Type) SetDCKCFGR_I2S2SRC(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x18000000)|value<<27)
}
func (o *RCC_Type) GetDCKCFGR_I2S2SRC() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x18000000) >> 27
}
func (o *RCC_Type) SetDCKCFGR_PLLI2SDIVR(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x1f)|value)
}
func (o *RCC_Type) GetDCKCFGR_PLLI2SDIVR() uint32 {
	return volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x1f
}
func (o *RCC_Type) SetDCKCFGR_PLLDIVR(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x1f00)|value<<8)
}
func (o *RCC_Type) GetDCKCFGR_PLLDIVR() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x1f00) >> 8
}
func (o *RCC_Type) SetDCKCFGR_CKDFSDM2ASEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetDCKCFGR_CKDFSDM2ASEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetDCKCFGR_SAI1ASRC(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetDCKCFGR_SAI1ASRC() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetDCKCFGR_SAI1BSRC(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetDCKCFGR_SAI1BSRC() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetDCKCFGR_CKDFSDM1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetDCKCFGR_CKDFSDM1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x80000000) >> 31
}

// RCC.CKGATENR: RCC clocks gated enable register
func (o *RCC_Type) SetCKGATENR_AHB2APB1_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCKGATENR_AHB2APB1_CKEN() uint32 {
	return volatile.LoadUint32(&o.CKGATENR.Reg) & 0x1
}
func (o *RCC_Type) SetCKGATENR_AHB2APB2_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCKGATENR_AHB2APB2_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCKGATENR_CM4DBG_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCKGATENR_CM4DBG_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCKGATENR_SPARE_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCKGATENR_SPARE_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCKGATENR_SRAM_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCKGATENR_SRAM_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCKGATENR_FLITF_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCKGATENR_FLITF_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCKGATENR_RCC_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCKGATENR_RCC_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCKGATENR_EVTCL_CKEN(value uint32) {
	volatile.StoreUint32(&o.CKGATENR.Reg, volatile.LoadUint32(&o.CKGATENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCKGATENR_EVTCL_CKEN() uint32 {
	return (volatile.LoadUint32(&o.CKGATENR.Reg) & 0x80) >> 7
}

// RCC.DCKCFGR2: Dedicated Clocks Configuration Register
func (o *RCC_Type) SetDCKCFGR2_SDIOSEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetDCKCFGR2_SDIOSEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetDCKCFGR2_CK48MSEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetDCKCFGR2_CK48MSEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetDCKCFGR2_FMPI2C1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetDCKCFGR2_FMPI2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetDCKCFGR2_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetDCKCFGR2_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc0000000) >> 30
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDIO.POWER: power control register
func (o *SDIO_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDIO_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDIO.CLKCR: SDI clock control register
func (o *SDIO_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDIO_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDIO_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDIO_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDIO.ARG: argument register
func (o *SDIO_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDIO_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDIO.CMD: command register
func (o *SDIO_Type) SetCMD_CE_ATACMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCMD_CE_ATACMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCMD_NIEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCMD_NIEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCMD_ENCMDcompl(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetCMD_ENCMDcompl() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDIO_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDIO_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDIO.RESPCMD: command response register
func (o *SDIO_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDIO.RESP1: response 1..4 register
func (o *SDIO_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDIO_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDIO.RESP2: response 1..4 register
func (o *SDIO_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDIO_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDIO.RESP3: response 1..4 register
func (o *SDIO_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDIO_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDIO.RESP4: response 1..4 register
func (o *SDIO_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDIO_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDIO.DTIMER: data timer register
func (o *SDIO_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDIO_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDIO.DLEN: data length register
func (o *SDIO_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDIO.DCTRL: data control register
func (o *SDIO_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDIO_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDIO_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDIO.DCOUNT: data counter register
func (o *SDIO_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDIO.STA: status register
func (o *SDIO_Type) SetSTA_CEATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetSTA_CEATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetSTA_STBITERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetSTA_STBITERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDIO.ICR: interrupt clear register
func (o *SDIO_Type) SetICR_CEATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetICR_CEATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetICR_STBITERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetICR_STBITERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDIO.MASK: mask register
func (o *SDIO_Type) SetMASK_CEATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetMASK_CEATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetMASK_STBITERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetMASK_STBITERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDIO.FIFOCNT: FIFO counter register
func (o *SDIO_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDIO_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDIO.FIFO: data FIFO register
func (o *SDIO_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDIO_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// Serial audio interface
type SAI_Type struct {
	_  [4]byte
	CH [2]SAI_CH_Type // 0x4
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: AConfiguration register 1
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}

// SAI_CH.CR2: AConfiguration register 2
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}

// SAI_CH.FRCR: AFRCR
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}

// SAI_CH.SLOTR: ASlot register
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}

// SAI_CH.IM: AInterrupt mask register2
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}

// SAI_CH.SR: AStatus register
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SAI_CH.CLRFR: AClear flag register
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}

// SAI_CH.DR: AData register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
	_       [8]byte
	CFGR    volatile.Register32 // 0x2C
}

// SYSCFG.MEMRM: memory remap register
func (o *SYSCFG_Type) SetMEMRM_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRM.Reg, volatile.LoadUint32(&o.MEMRM.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetMEMRM_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRM.Reg) & 0x3
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_ADC1DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetPMC_ADC1DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x10000) >> 16
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CMPCR: Compensation cell control register
func (o *SYSCFG_Type) SetCMPCR_READY(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCMPCR_READY() uint32 {
	return (volatile.LoadUint32(&o.CMPCR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCMPCR_CMP_PD(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCMPCR_CMP_PD() uint32 {
	return volatile.LoadUint32(&o.CMPCR.Reg) & 0x1
}

// SYSCFG.CFGR: Configuration register
func (o *SYSCFG_Type) SetCFGR_FMPI2C1_SCL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCFGR_FMPI2C1_SCL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}
func (o *SYSCFG_Type) SetCFGR_FMPI2C1_SDA(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetCFGR_FMPI2C1_SDA() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// USART.SR: Status register
func (o *USART_Type) SetSR_CTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetSR_LBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetSR_LBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetSR_TC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSR_TC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSR_ORE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSR_ORE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSR_NF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSR_NF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSR_FE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSR_FE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSR_PE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSR_PE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// USART.DR: Data register
func (o *USART_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0x1ff
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR_DIV_Mantissa(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfff0)|value<<4)
}
func (o *USART_Type) GetBRR_DIV_Mantissa() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0xfff0) >> 4
}
func (o *USART_Type) SetBRR_DIV_Fraction(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetBRR_DIV_Fraction() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xf
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_RWU(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_RWU() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_SBK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_SBK() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xf
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	DCFG       volatile.Register32 // 0x0
	DCTL       volatile.Register32 // 0x4
	DSTS       volatile.Register32 // 0x8
	_          [4]byte
	DIEPMSK    volatile.Register32 // 0x10
	DOEPMSK    volatile.Register32 // 0x14
	DAINT      volatile.Register32 // 0x18
	DAINTMSK   volatile.Register32 // 0x1C
	_          [8]byte
	DVBUSDIS   volatile.Register32 // 0x28
	DVBUSPULSE volatile.Register32 // 0x2C
	_          [4]byte
	DIEPEMPMSK volatile.Register32 // 0x34
	_          [200]byte
	DIEPCTL0   volatile.Register32 // 0x100
	_          [4]byte
	DIEPINT0   volatile.Register32 // 0x108
	_          [4]byte
	DIEPTSIZ0  volatile.Register32 // 0x110
	_          [4]byte
	DTXFSTS0   volatile.Register32 // 0x118
	_          [4]byte
	DIEPCTL1   volatile.Register32 // 0x120
	_          [4]byte
	DIEPINT1   volatile.Register32 // 0x128
	_          [4]byte
	DIEPTSIZ1  volatile.Register32 // 0x130
	_          [4]byte
	DTXFSTS1   volatile.Register32 // 0x138
	_          [4]byte
	DIEPCTL2   volatile.Register32 // 0x140
	_          [4]byte
	DIEPINT2   volatile.Register32 // 0x148
	_          [4]byte
	DIEPTSIZ2  volatile.Register32 // 0x150
	_          [4]byte
	DTXFSTS2   volatile.Register32 // 0x158
	_          [4]byte
	DIEPCTL3   volatile.Register32 // 0x160
	_          [4]byte
	DIEPINT3   volatile.Register32 // 0x168
	_          [4]byte
	DIEPTSIZ3  volatile.Register32 // 0x170
	_          [4]byte
	DTXFSTS3   volatile.Register32 // 0x178
	_          [388]byte
	DOEPCTL0   volatile.Register32 // 0x300
	_          [4]byte
	DOEPINT0   volatile.Register32 // 0x308
	_          [4]byte
	DOEPTSIZ0  volatile.Register32 // 0x310
	_          [12]byte
	DOEPCTL1   volatile.Register32 // 0x320
	_          [4]byte
	DOEPINT1   volatile.Register32 // 0x328
	_          [4]byte
	DOEPTSIZ1  volatile.Register32 // 0x330
	_          [12]byte
	DOEPCTL2   volatile.Register32 // 0x340
	_          [4]byte
	DOEPINT2   volatile.Register32 // 0x348
	_          [4]byte
	DOEPTSIZ2  volatile.Register32 // 0x350
	_          [12]byte
	DOEPCTL3   volatile.Register32 // 0x360
	_          [4]byte
	DOEPINT3   volatile.Register32 // 0x368
	_          [4]byte
	DOEPTSIZ3  volatile.Register32 // 0x370
}

// USB_OTG_FS.DCFG: OTG_FS device configuration register (OTG_FS_DCFG)
func (o *USB_OTG_FS_Type) SetDCFG_DSPD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDCFG_DSPD() uint32 {
	return volatile.LoadUint32(&o.DCFG.Reg) & 0x3
}
func (o *USB_OTG_FS_Type) SetDCFG_NZLSOHSK(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetDCFG_NZLSOHSK() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetDCFG_DAD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x7f0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDCFG_DAD() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x7f0) >> 4
}
func (o *USB_OTG_FS_Type) SetDCFG_PFIVL(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x1800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetDCFG_PFIVL() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x1800) >> 11
}

// USB_OTG_FS.DCTL: OTG_FS device control register (OTG_FS_DCTL)
func (o *USB_OTG_FS_Type) SetDCTL_RWUSIG(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDCTL_RWUSIG() uint32 {
	return volatile.LoadUint32(&o.DCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDCTL_SDIS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDCTL_SDIS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDCTL_GINSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetDCTL_GINSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetDCTL_GONSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDCTL_GONSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDCTL_TCTL(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x70)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDCTL_TCTL() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x70) >> 4
}
func (o *USB_OTG_FS_Type) SetDCTL_SGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDCTL_SGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDCTL_CGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetDCTL_CGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetDCTL_SGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetDCTL_SGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetDCTL_CGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetDCTL_CGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetDCTL_POPRGDNE(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetDCTL_POPRGDNE() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x800) >> 11
}

// USB_OTG_FS.DSTS: OTG_FS device status register (OTG_FS_DSTS)
func (o *USB_OTG_FS_Type) SetDSTS_SUSPSTS(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDSTS_SUSPSTS() uint32 {
	return volatile.LoadUint32(&o.DSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDSTS_ENUMSPD(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x6)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDSTS_ENUMSPD() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x6) >> 1
}
func (o *USB_OTG_FS_Type) SetDSTS_EERR(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDSTS_EERR() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDSTS_FNSOF(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x3fff00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetDSTS_FNSOF() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x3fff00) >> 8
}
func (o *USB_OTG_FS_Type) SetDSTS_DEVLNSTS(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0xc00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDSTS_DEVLNSTS() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0xc00000) >> 22
}

// USB_OTG_FS.DIEPMSK: OTG_FS device IN endpoint common interrupt mask register (OTG_FS_DIEPMSK)
func (o *USB_OTG_FS_Type) SetDIEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_TOM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_TOM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_ITTXFEMSK(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_ITTXFEMSK() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_INEPNMM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_INEPNMM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_INEPNEM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_INEPNEM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x40) >> 6
}

// USB_OTG_FS.DOEPMSK: OTG_FS device OUT endpoint common interrupt mask register (OTG_FS_DOEPMSK)
func (o *USB_OTG_FS_Type) SetDOEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_STUPM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_STUPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_OTEPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_OTEPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x10) >> 4
}

// USB_OTG_FS.DAINT: OTG_FS device all endpoints interrupt register (OTG_FS_DAINT)
func (o *USB_OTG_FS_Type) SetDAINT_IEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDAINT_IEPINT() uint32 {
	return volatile.LoadUint32(&o.DAINT.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetDAINT_OEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDAINT_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.DAINT.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.DAINTMSK: OTG_FS all endpoints interrupt mask register (OTG_FS_DAINTMSK)
func (o *USB_OTG_FS_Type) SetDAINTMSK_IEPM(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDAINTMSK_IEPM() uint32 {
	return volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetDAINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDAINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.DVBUSDIS: OTG_FS device VBUS discharge time register
func (o *USB_OTG_FS_Type) SetDVBUSDIS_VBUSDT(value uint32) {
	volatile.StoreUint32(&o.DVBUSDIS.Reg, volatile.LoadUint32(&o.DVBUSDIS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDVBUSDIS_VBUSDT() uint32 {
	return volatile.LoadUint32(&o.DVBUSDIS.Reg) & 0xffff
}

// USB_OTG_FS.DVBUSPULSE: OTG_FS device VBUS pulsing time register
func (o *USB_OTG_FS_Type) SetDVBUSPULSE_DVBUSP(value uint32) {
	volatile.StoreUint32(&o.DVBUSPULSE.Reg, volatile.LoadUint32(&o.DVBUSPULSE.Reg)&^(0xfff)|value)
}
func (o *USB_OTG_FS_Type) GetDVBUSPULSE_DVBUSP() uint32 {
	return volatile.LoadUint32(&o.DVBUSPULSE.Reg) & 0xfff
}

// USB_OTG_FS.DIEPEMPMSK: OTG_FS device IN endpoint FIFO empty interrupt mask register
func (o *USB_OTG_FS_Type) SetDIEPEMPMSK_INEPTXFEM(value uint32) {
	volatile.StoreUint32(&o.DIEPEMPMSK.Reg, volatile.LoadUint32(&o.DIEPEMPMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPEMPMSK_INEPTXFEM() uint32 {
	return volatile.LoadUint32(&o.DIEPEMPMSK.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL0: OTG_FS device control IN endpoint 0 control register (OTG_FS_DIEPCTL0)
func (o *USB_OTG_FS_Type) SetDIEPCTL0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x3
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_STALL(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_STALL() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.DIEPINT0: device endpoint-x interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT0_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ0: device endpoint-0 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x180000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x180000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x7f
}

// USB_OTG_FS.DTXFSTS0: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS0_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS0.Reg, volatile.LoadUint32(&o.DTXFSTS0.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS0_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS0.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL1: OTG device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SODDFRM_SD1PID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SODDFRM_SD1PID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT1: device endpoint-1 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT1_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ1: device endpoint-1 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS1: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS1_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS1.Reg, volatile.LoadUint32(&o.DTXFSTS1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS1_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS1.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL2: OTG device endpoint-2 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT2: device endpoint-2 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT2_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ2: device endpoint-2 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS2: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS2_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS2.Reg, volatile.LoadUint32(&o.DTXFSTS2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS2_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS2.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL3: OTG device endpoint-3 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_Stall(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_Stall() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT3: device endpoint-3 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT3_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ3: device endpoint-3 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS3: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS3_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS3.Reg, volatile.LoadUint32(&o.DTXFSTS3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS3_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS3.Reg) & 0xffff
}

// USB_OTG_FS.DOEPCTL0: device endpoint-0 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_Stall(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_Stall() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x3
}

// USB_OTG_FS.DOEPINT0: device endpoint-0 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT0_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ0: device OUT endpoint-0 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x7f
}

// USB_OTG_FS.DOEPCTL1: device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_Stall(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_Stall() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT1: device endpoint-1 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT1_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ1: device OUT endpoint-1 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x7ffff
}

// USB_OTG_FS.DOEPCTL2: device endpoint-2 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_Stall(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_Stall() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT2: device endpoint-2 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT2_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ2: device OUT endpoint-2 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x7ffff
}

// USB_OTG_FS.DOEPCTL3: device endpoint-3 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_Stall(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_Stall() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT3: device endpoint-3 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT3_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ3: device OUT endpoint-3 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x7ffff
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Flexible static memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [228]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// FSMC.BCR1: BCR1
func (o *FSMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}
func (o *FSMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}

// FSMC.BTR1: BTR1
func (o *FSMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}

// FSMC.BCR2: BCR2
func (o *FSMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}
func (o *FSMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR2_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR2_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR2_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR2_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200000) >> 21
}

// FSMC.BTR2: BTR1
func (o *FSMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}

// FSMC.BCR3: BCR2
func (o *FSMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}
func (o *FSMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR3_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR3_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR3_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR3_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200000) >> 21
}

// FSMC.BTR3: BTR1
func (o *FSMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}

// FSMC.BCR4: BCR2
func (o *FSMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}
func (o *FSMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR4_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR4_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR4_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR4_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200000) >> 21
}

// FSMC.BTR4: BTR1
func (o *FSMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}

// FSMC.BWTR1: BWTR1
func (o *FSMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR2: BWTR1
func (o *FSMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR3: BWTR1
func (o *FSMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR4: BWTR1
func (o *FSMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCRS: System handler control and state register
func (o *SCB_Type) SetSHCRS_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCRS.Reg) & 0x1
}
func (o *SCB_Type) SetSHCRS_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCRS_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCRS_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCRS_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCRS_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCRS_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCRS_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCRS_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCRS_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCRS_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCRS_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCRS_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCRS_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCRS_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCRS_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCRS_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCRS_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCRS_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCRS_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCRS_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCRS_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// Constants for AES: Advanced encryption standard hardware accelerator
const (
	// CR: control register
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Position of CHMOD field.
	AES_CR_CHMOD_Pos = 0x5
	// Bit mask of CHMOD field.
	AES_CR_CHMOD_Msk = 0x60
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1

	// SR: status register
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1

	// DINR: data input register
	// Position of AES_DINR field.
	AES_DINR_AES_DINR_Pos = 0x0
	// Bit mask of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff

	// DOUTR: data output register
	// Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Pos = 0x0
	// Bit mask of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff

	// KEYR0: key register 0
	// Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Pos = 0x0
	// Bit mask of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff

	// KEYR1: key register 1
	// Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Pos = 0x0
	// Bit mask of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff

	// KEYR2: key register 2
	// Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Pos = 0x0
	// Bit mask of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff

	// KEYR3: key register 3
	// Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Pos = 0x0
	// Bit mask of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff

	// IVR0: initialization vector register 0
	// Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Pos = 0x0
	// Bit mask of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff

	// IVR1: initialization vector register 1
	// Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Pos = 0x0
	// Bit mask of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff

	// IVR2: initialization vector register 2
	// Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Pos = 0x0
	// Bit mask of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff

	// IVR3: initialization vector register 3
	// Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Pos = 0x0
	// Bit mask of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff
)

// Constants for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// OC/OCN are disabled or forced idle depending on OSSI
	TIM_BDTR_MOE_DisabledIdle = 0x0
	// OC/OCN are enabled if CCxE/CCxNE are set
	TIM_BDTR_MOE_Enabled = 0x1
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSR_Disabled = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level
	TIM_BDTR_OSSR_IdleLevel = 0x1
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSI_Disabled = 0x0
	// When inactive, OC/OCN outputs are forced to idle level
	TIM_BDTR_OSSI_IdleLevel = 0x1
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff
)

// Constants for ADC1: Analog-to-digital converter
const (
	// SR: status register
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// No overrun occurred
	ADC_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_SR_OVR_Overrun = 0x1
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected channel conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected channel conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Overrun interrupt disabled
	ADC_CR1_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_CR1_OVRIE_Enabled = 0x1
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// 12-bit (15 ADCCLK cycles)
	ADC_CR1_RES_TwelveBit = 0x0
	// 10-bit (13 ADCCLK cycles)
	ADC_CR1_RES_TenBit = 0x1
	// 8-bit (11 ADCCLK cycles)
	ADC_CR1_RES_EightBit = 0x2
	// 6-bit (9 ADCCLK cycles)
	ADC_CR1_RES_SixBit = 0x3
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_SingleChannel = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analogue watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analogue watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Starts conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Trigger detection disabled
	ADC_CR2_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_TIM1CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_TIM1CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_TIM1CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_TIM2CC2 = 0x3
	// Timer 2 CC3 event
	ADC_CR2_EXTSEL_TIM2CC3 = 0x4
	// Timer 2 CC4 event
	ADC_CR2_EXTSEL_TIM2CC4 = 0x5
	// Timer 2 TRGO event
	ADC_CR2_EXTSEL_TIM2TRGO = 0x6
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Starts conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Trigger detection disabled
	ADC_CR2_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_TIM1TRGO = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_TIM1CC4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_TIM2TRGO = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_TIM2CC1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_TIM3CC4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_TIM4TRGO = 0x5
	// Timer 8 CC4 event
	ADC_CR2_JEXTSEL_TIM8CC4 = 0x7
	// Timer 1 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM1TRGO2 = 0x8
	// Timer 8 TRGO event
	ADC_CR2_JEXTSEL_TIM8TRGO = 0x9
	// Timer 8 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM8TRGO2 = 0xa
	// Timer 3 CC3 event
	ADC_CR2_JEXTSEL_TIM3CC3 = 0xb
	// Timer 5 TRGO event
	ADC_CR2_JEXTSEL_TIM5TRGO = 0xc
	// Timer 3 CC1 event
	ADC_CR2_JEXTSEL_TIM3CC1 = 0xd
	// Timer 6 TRGO event
	ADC_CR2_JEXTSEL_TIM6TRGO = 0xe
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// The EOC bit is set at the end of each sequence of regular conversions
	ADC_CR2_EOCS_EachSequence = 0x0
	// The EOC bit is set at the end of each regular conversion
	ADC_CR2_EOCS_EachConversion = 0x1
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// No new DMA request is issued after the last transfer
	ADC_CR2_DDS_Single = 0x0
	// DMA requests are issued as long as data are converted and DMA=1
	ADC_CR2_DDS_Continuous = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP18 field.
	ADC_SMPR1_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR1_SMP18_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR1_SMP18_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP18_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP18_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP18_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP18_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP18_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP18_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP18_Cycles480 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR1_SMP17_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP17_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP17_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP17_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP17_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP17_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP17_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP17_Cycles480 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR1_SMP16_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP16_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP16_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP16_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP16_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP16_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP16_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP16_Cycles480 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 3 cycles
	ADC_SMPR1_SMP15_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP15_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP15_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP15_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP15_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP15_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP15_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP15_Cycles480 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 3 cycles
	ADC_SMPR1_SMP14_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP14_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP14_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP14_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP14_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP14_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP14_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP14_Cycles480 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 3 cycles
	ADC_SMPR1_SMP13_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP13_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP13_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP13_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP13_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP13_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP13_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP13_Cycles480 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR1_SMP12_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP12_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP12_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP12_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP12_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP12_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP12_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP12_Cycles480 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 3 cycles
	ADC_SMPR1_SMP11_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP11_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP11_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP11_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP11_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP11_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP11_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP11_Cycles480 = 0x7
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 3 cycles
	ADC_SMPR1_SMP10_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP10_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP10_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP10_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP10_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP10_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP10_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP10_Cycles480 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 3 cycles
	ADC_SMPR2_SMP9_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP9_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP9_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP9_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP9_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP9_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP9_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP9_Cycles480 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR2_SMP8_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP8_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP8_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP8_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP8_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP8_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP8_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP8_Cycles480 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR2_SMP7_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP7_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP7_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP7_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP7_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP7_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP7_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP7_Cycles480 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR2_SMP6_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP6_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP6_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP6_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP6_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP6_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP6_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP6_Cycles480 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 3 cycles
	ADC_SMPR2_SMP5_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP5_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP5_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP5_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP5_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP5_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP5_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP5_Cycles480 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 3 cycles
	ADC_SMPR2_SMP4_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP4_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP4_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP4_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP4_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP4_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP4_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP4_Cycles480 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 3 cycles
	ADC_SMPR2_SMP3_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP3_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP3_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP3_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP3_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP3_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP3_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP3_Cycles480 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR2_SMP2_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP2_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP2_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP2_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP2_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP2_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP2_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP2_Cycles480 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 3 cycles
	ADC_SMPR2_SMP1_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP1_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP1_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP1_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP1_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP1_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP1_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP1_Cycles480 = 0x7
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 3 cycles
	ADC_SMPR2_SMP0_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP0_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP0_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP0_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP0_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP0_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP0_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP0_Cycles480 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET field.
	ADC_JOFR_JOFFSET_Pos = 0x0
	// Bit mask of JOFFSET field.
	ADC_JOFR_JOFFSET_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Constants for CAN1: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO %s register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: mailbox data high register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB field.
	CAN_FB_FR1_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR1_FB_Msk = 0xffffffff

	// FB.FR2: Filter bank 0 register 2
	// Position of FB field.
	CAN_FB_FR2_FB_Pos = 0x0
	// Bit mask of FB field.
	CAN_FB_FR2_FB_Msk = 0xffffffff
)

// Constants for CRC: Cryptographic processor
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent Data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Constants for DBGMCU: Debug support
const (
	// IDCODE: IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Control Register
	// Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBG_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBG_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: Debug MCU APB1 Freeze registe
	// Position of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBG_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBG_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_RTC_Stop field.
	DBG_APB1_FZ_DBG_RTC_Stop_Pos = 0xa
	// Bit mask of DBG_RTC_Stop field.
	DBG_APB1_FZ_DBG_RTC_Stop_Msk = 0x400
	// Bit DBG_RTC_Stop.
	DBG_APB1_FZ_DBG_RTC_Stop = 0x400
	// Position of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT = 0x200000
	// Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT = 0x400000
	// Position of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Pos = 0x17
	// Bit mask of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Msk = 0x800000
	// Bit DBG_I2C3SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT = 0x800000

	// APB2_FZ: Debug MCU APB2 Freeze registe
	// Position of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Pos = 0x0
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Msk = 0x1
	// Bit DBG_TIM1_STOP.
	DBG_APB2_FZ_DBG_TIM1_STOP = 0x1
	// Position of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Pos = 0x10
	// Bit mask of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Msk = 0x10000
	// Bit DBG_TIM9_STOP.
	DBG_APB2_FZ_DBG_TIM9_STOP = 0x10000
	// Position of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11
	// Bit mask of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000
	// Bit DBG_TIM10_STOP.
	DBG_APB2_FZ_DBG_TIM10_STOP = 0x20000
	// Position of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12
	// Bit mask of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000
	// Bit DBG_TIM11_STOP.
	DBG_APB2_FZ_DBG_TIM11_STOP = 0x40000
)

// Constants for DFSDM2: Digital filter for sigma delta modulators
const (
	// CH.CFGR1: channel configuration y register
	// Position of DFSDMEN field.
	DFSDM_CH_CFGR1_DFSDMEN_Pos = 0x1f
	// Bit mask of DFSDMEN field.
	DFSDM_CH_CFGR1_DFSDMEN_Msk = 0x80000000
	// Bit DFSDMEN.
	DFSDM_CH_CFGR1_DFSDMEN = 0x80000000
	// Position of CKOUTSRC field.
	DFSDM_CH_CFGR1_CKOUTSRC_Pos = 0x1e
	// Bit mask of CKOUTSRC field.
	DFSDM_CH_CFGR1_CKOUTSRC_Msk = 0x40000000
	// Bit CKOUTSRC.
	DFSDM_CH_CFGR1_CKOUTSRC = 0x40000000
	// Position of CKOUTDIV field.
	DFSDM_CH_CFGR1_CKOUTDIV_Pos = 0x10
	// Bit mask of CKOUTDIV field.
	DFSDM_CH_CFGR1_CKOUTDIV_Msk = 0xff0000
	// Position of DATPACK field.
	DFSDM_CH_CFGR1_DATPACK_Pos = 0xe
	// Bit mask of DATPACK field.
	DFSDM_CH_CFGR1_DATPACK_Msk = 0xc000
	// Position of DATMPX field.
	DFSDM_CH_CFGR1_DATMPX_Pos = 0xc
	// Bit mask of DATMPX field.
	DFSDM_CH_CFGR1_DATMPX_Msk = 0x3000
	// Position of CHINSEL field.
	DFSDM_CH_CFGR1_CHINSEL_Pos = 0x8
	// Bit mask of CHINSEL field.
	DFSDM_CH_CFGR1_CHINSEL_Msk = 0x100
	// Bit CHINSEL.
	DFSDM_CH_CFGR1_CHINSEL = 0x100
	// Position of CHEN field.
	DFSDM_CH_CFGR1_CHEN_Pos = 0x7
	// Bit mask of CHEN field.
	DFSDM_CH_CFGR1_CHEN_Msk = 0x80
	// Bit CHEN.
	DFSDM_CH_CFGR1_CHEN = 0x80
	// Position of CKABEN field.
	DFSDM_CH_CFGR1_CKABEN_Pos = 0x6
	// Bit mask of CKABEN field.
	DFSDM_CH_CFGR1_CKABEN_Msk = 0x40
	// Bit CKABEN.
	DFSDM_CH_CFGR1_CKABEN = 0x40
	// Position of SCDEN field.
	DFSDM_CH_CFGR1_SCDEN_Pos = 0x5
	// Bit mask of SCDEN field.
	DFSDM_CH_CFGR1_SCDEN_Msk = 0x20
	// Bit SCDEN.
	DFSDM_CH_CFGR1_SCDEN = 0x20
	// Position of SPICKSEL field.
	DFSDM_CH_CFGR1_SPICKSEL_Pos = 0x2
	// Bit mask of SPICKSEL field.
	DFSDM_CH_CFGR1_SPICKSEL_Msk = 0xc
	// Position of SITP field.
	DFSDM_CH_CFGR1_SITP_Pos = 0x0
	// Bit mask of SITP field.
	DFSDM_CH_CFGR1_SITP_Msk = 0x3

	// CH.CFGR2: channel configuration y register
	// Position of OFFSET field.
	DFSDM_CH_CFGR2_OFFSET_Pos = 0x8
	// Bit mask of OFFSET field.
	DFSDM_CH_CFGR2_OFFSET_Msk = 0xffffff00
	// Position of DTRBS field.
	DFSDM_CH_CFGR2_DTRBS_Pos = 0x3
	// Bit mask of DTRBS field.
	DFSDM_CH_CFGR2_DTRBS_Msk = 0xf8

	// CH.AWSCDR: analog watchdog and short-circuit detector register
	// Position of AWFORD field.
	DFSDM_CH_AWSCDR_AWFORD_Pos = 0x16
	// Bit mask of AWFORD field.
	DFSDM_CH_AWSCDR_AWFORD_Msk = 0xc00000
	// Position of AWFOSR field.
	DFSDM_CH_AWSCDR_AWFOSR_Pos = 0x10
	// Bit mask of AWFOSR field.
	DFSDM_CH_AWSCDR_AWFOSR_Msk = 0x1f0000
	// Position of BKSCD field.
	DFSDM_CH_AWSCDR_BKSCD_Pos = 0xc
	// Bit mask of BKSCD field.
	DFSDM_CH_AWSCDR_BKSCD_Msk = 0xf000
	// Position of SCDT field.
	DFSDM_CH_AWSCDR_SCDT_Pos = 0x0
	// Bit mask of SCDT field.
	DFSDM_CH_AWSCDR_SCDT_Msk = 0xff

	// CH.WDATR: channel watchdog filter data register
	// Position of WDATA field.
	DFSDM_CH_WDATR_WDATA_Pos = 0x0
	// Bit mask of WDATA field.
	DFSDM_CH_WDATR_WDATA_Msk = 0xffff

	// CH.DATINR: channel data input register
	// Position of INDAT1 field.
	DFSDM_CH_DATINR_INDAT1_Pos = 0x10
	// Bit mask of INDAT1 field.
	DFSDM_CH_DATINR_INDAT1_Msk = 0xffff0000
	// Position of INDAT0 field.
	DFSDM_CH_DATINR_INDAT0_Pos = 0x0
	// Bit mask of INDAT0 field.
	DFSDM_CH_DATINR_INDAT0_Msk = 0xffff

	// FLT.CR1: control register 1
	// Position of AWFSEL field.
	DFSDM_FLT_CR1_AWFSEL_Pos = 0x1e
	// Bit mask of AWFSEL field.
	DFSDM_FLT_CR1_AWFSEL_Msk = 0x40000000
	// Bit AWFSEL.
	DFSDM_FLT_CR1_AWFSEL = 0x40000000
	// Position of FAST field.
	DFSDM_FLT_CR1_FAST_Pos = 0x1d
	// Bit mask of FAST field.
	DFSDM_FLT_CR1_FAST_Msk = 0x20000000
	// Bit FAST.
	DFSDM_FLT_CR1_FAST = 0x20000000
	// Position of RCH field.
	DFSDM_FLT_CR1_RCH_Pos = 0x18
	// Bit mask of RCH field.
	DFSDM_FLT_CR1_RCH_Msk = 0x7000000
	// Position of RDMAEN field.
	DFSDM_FLT_CR1_RDMAEN_Pos = 0x15
	// Bit mask of RDMAEN field.
	DFSDM_FLT_CR1_RDMAEN_Msk = 0x200000
	// Bit RDMAEN.
	DFSDM_FLT_CR1_RDMAEN = 0x200000
	// Position of RSYNC field.
	DFSDM_FLT_CR1_RSYNC_Pos = 0x13
	// Bit mask of RSYNC field.
	DFSDM_FLT_CR1_RSYNC_Msk = 0x80000
	// Bit RSYNC.
	DFSDM_FLT_CR1_RSYNC = 0x80000
	// Position of RCONT field.
	DFSDM_FLT_CR1_RCONT_Pos = 0x12
	// Bit mask of RCONT field.
	DFSDM_FLT_CR1_RCONT_Msk = 0x40000
	// Bit RCONT.
	DFSDM_FLT_CR1_RCONT = 0x40000
	// Position of RSWSTART field.
	DFSDM_FLT_CR1_RSWSTART_Pos = 0x11
	// Bit mask of RSWSTART field.
	DFSDM_FLT_CR1_RSWSTART_Msk = 0x20000
	// Bit RSWSTART.
	DFSDM_FLT_CR1_RSWSTART = 0x20000
	// Position of JEXTEN field.
	DFSDM_FLT_CR1_JEXTEN_Pos = 0xd
	// Bit mask of JEXTEN field.
	DFSDM_FLT_CR1_JEXTEN_Msk = 0x6000
	// Position of JEXTSEL field.
	DFSDM_FLT_CR1_JEXTSEL_Pos = 0x8
	// Bit mask of JEXTSEL field.
	DFSDM_FLT_CR1_JEXTSEL_Msk = 0x700
	// Position of JDMAEN field.
	DFSDM_FLT_CR1_JDMAEN_Pos = 0x5
	// Bit mask of JDMAEN field.
	DFSDM_FLT_CR1_JDMAEN_Msk = 0x20
	// Bit JDMAEN.
	DFSDM_FLT_CR1_JDMAEN = 0x20
	// Position of JSCAN field.
	DFSDM_FLT_CR1_JSCAN_Pos = 0x4
	// Bit mask of JSCAN field.
	DFSDM_FLT_CR1_JSCAN_Msk = 0x10
	// Bit JSCAN.
	DFSDM_FLT_CR1_JSCAN = 0x10
	// Position of JSYNC field.
	DFSDM_FLT_CR1_JSYNC_Pos = 0x3
	// Bit mask of JSYNC field.
	DFSDM_FLT_CR1_JSYNC_Msk = 0x8
	// Bit JSYNC.
	DFSDM_FLT_CR1_JSYNC = 0x8
	// Position of JSWSTART field.
	DFSDM_FLT_CR1_JSWSTART_Pos = 0x1
	// Bit mask of JSWSTART field.
	DFSDM_FLT_CR1_JSWSTART_Msk = 0x2
	// Bit JSWSTART.
	DFSDM_FLT_CR1_JSWSTART = 0x2
	// Position of DFEN field.
	DFSDM_FLT_CR1_DFEN_Pos = 0x0
	// Bit mask of DFEN field.
	DFSDM_FLT_CR1_DFEN_Msk = 0x1
	// Bit DFEN.
	DFSDM_FLT_CR1_DFEN = 0x1

	// FLT.CR2: control register 2
	// Position of AWDCH field.
	DFSDM_FLT_CR2_AWDCH_Pos = 0x10
	// Bit mask of AWDCH field.
	DFSDM_FLT_CR2_AWDCH_Msk = 0xff0000
	// Position of EXCH field.
	DFSDM_FLT_CR2_EXCH_Pos = 0x8
	// Bit mask of EXCH field.
	DFSDM_FLT_CR2_EXCH_Msk = 0xff00
	// Position of CKABIE field.
	DFSDM_FLT_CR2_CKABIE_Pos = 0x6
	// Bit mask of CKABIE field.
	DFSDM_FLT_CR2_CKABIE_Msk = 0x40
	// Bit CKABIE.
	DFSDM_FLT_CR2_CKABIE = 0x40
	// Position of SCDIE field.
	DFSDM_FLT_CR2_SCDIE_Pos = 0x5
	// Bit mask of SCDIE field.
	DFSDM_FLT_CR2_SCDIE_Msk = 0x20
	// Bit SCDIE.
	DFSDM_FLT_CR2_SCDIE = 0x20
	// Position of AWDIE field.
	DFSDM_FLT_CR2_AWDIE_Pos = 0x4
	// Bit mask of AWDIE field.
	DFSDM_FLT_CR2_AWDIE_Msk = 0x10
	// Bit AWDIE.
	DFSDM_FLT_CR2_AWDIE = 0x10
	// Position of ROVRIE field.
	DFSDM_FLT_CR2_ROVRIE_Pos = 0x3
	// Bit mask of ROVRIE field.
	DFSDM_FLT_CR2_ROVRIE_Msk = 0x8
	// Bit ROVRIE.
	DFSDM_FLT_CR2_ROVRIE = 0x8
	// Position of JOVRIE field.
	DFSDM_FLT_CR2_JOVRIE_Pos = 0x2
	// Bit mask of JOVRIE field.
	DFSDM_FLT_CR2_JOVRIE_Msk = 0x4
	// Bit JOVRIE.
	DFSDM_FLT_CR2_JOVRIE = 0x4
	// Position of REOCIE field.
	DFSDM_FLT_CR2_REOCIE_Pos = 0x1
	// Bit mask of REOCIE field.
	DFSDM_FLT_CR2_REOCIE_Msk = 0x2
	// Bit REOCIE.
	DFSDM_FLT_CR2_REOCIE = 0x2
	// Position of JEOCIE field.
	DFSDM_FLT_CR2_JEOCIE_Pos = 0x0
	// Bit mask of JEOCIE field.
	DFSDM_FLT_CR2_JEOCIE_Msk = 0x1
	// Bit JEOCIE.
	DFSDM_FLT_CR2_JEOCIE = 0x1

	// FLT.ISR: interrupt and status register
	// Position of SCDF field.
	DFSDM_FLT_ISR_SCDF_Pos = 0x18
	// Bit mask of SCDF field.
	DFSDM_FLT_ISR_SCDF_Msk = 0xff000000
	// Position of CKABF field.
	DFSDM_FLT_ISR_CKABF_Pos = 0x10
	// Bit mask of CKABF field.
	DFSDM_FLT_ISR_CKABF_Msk = 0xff0000
	// Position of RCIP field.
	DFSDM_FLT_ISR_RCIP_Pos = 0xe
	// Bit mask of RCIP field.
	DFSDM_FLT_ISR_RCIP_Msk = 0x4000
	// Bit RCIP.
	DFSDM_FLT_ISR_RCIP = 0x4000
	// Position of JCIP field.
	DFSDM_FLT_ISR_JCIP_Pos = 0xd
	// Bit mask of JCIP field.
	DFSDM_FLT_ISR_JCIP_Msk = 0x2000
	// Bit JCIP.
	DFSDM_FLT_ISR_JCIP = 0x2000
	// Position of AWDF field.
	DFSDM_FLT_ISR_AWDF_Pos = 0x4
	// Bit mask of AWDF field.
	DFSDM_FLT_ISR_AWDF_Msk = 0x10
	// Bit AWDF.
	DFSDM_FLT_ISR_AWDF = 0x10
	// Position of ROVRF field.
	DFSDM_FLT_ISR_ROVRF_Pos = 0x3
	// Bit mask of ROVRF field.
	DFSDM_FLT_ISR_ROVRF_Msk = 0x8
	// Bit ROVRF.
	DFSDM_FLT_ISR_ROVRF = 0x8
	// Position of JOVRF field.
	DFSDM_FLT_ISR_JOVRF_Pos = 0x2
	// Bit mask of JOVRF field.
	DFSDM_FLT_ISR_JOVRF_Msk = 0x4
	// Bit JOVRF.
	DFSDM_FLT_ISR_JOVRF = 0x4
	// Position of REOCF field.
	DFSDM_FLT_ISR_REOCF_Pos = 0x1
	// Bit mask of REOCF field.
	DFSDM_FLT_ISR_REOCF_Msk = 0x2
	// Bit REOCF.
	DFSDM_FLT_ISR_REOCF = 0x2
	// Position of JEOCF field.
	DFSDM_FLT_ISR_JEOCF_Pos = 0x0
	// Bit mask of JEOCF field.
	DFSDM_FLT_ISR_JEOCF_Msk = 0x1
	// Bit JEOCF.
	DFSDM_FLT_ISR_JEOCF = 0x1

	// FLT.ICR: interrupt flag clear register
	// Position of CLRSCDF field.
	DFSDM_FLT_ICR_CLRSCDF_Pos = 0x18
	// Bit mask of CLRSCDF field.
	DFSDM_FLT_ICR_CLRSCDF_Msk = 0xff000000
	// Position of CLRCKABF field.
	DFSDM_FLT_ICR_CLRCKABF_Pos = 0x10
	// Bit mask of CLRCKABF field.
	DFSDM_FLT_ICR_CLRCKABF_Msk = 0xff0000
	// Position of CLRROVRF field.
	DFSDM_FLT_ICR_CLRROVRF_Pos = 0x3
	// Bit mask of CLRROVRF field.
	DFSDM_FLT_ICR_CLRROVRF_Msk = 0x8
	// Bit CLRROVRF.
	DFSDM_FLT_ICR_CLRROVRF = 0x8
	// Position of CLRJOVRF field.
	DFSDM_FLT_ICR_CLRJOVRF_Pos = 0x2
	// Bit mask of CLRJOVRF field.
	DFSDM_FLT_ICR_CLRJOVRF_Msk = 0x4
	// Bit CLRJOVRF.
	DFSDM_FLT_ICR_CLRJOVRF = 0x4

	// FLT.JCHGR: injected channel group selection register
	// Position of JCHG field.
	DFSDM_FLT_JCHGR_JCHG_Pos = 0x0
	// Bit mask of JCHG field.
	DFSDM_FLT_JCHGR_JCHG_Msk = 0xff

	// FLT.FCR: filter control register
	// Position of FORD field.
	DFSDM_FLT_FCR_FORD_Pos = 0x1d
	// Bit mask of FORD field.
	DFSDM_FLT_FCR_FORD_Msk = 0xe0000000
	// Position of FOSR field.
	DFSDM_FLT_FCR_FOSR_Pos = 0x10
	// Bit mask of FOSR field.
	DFSDM_FLT_FCR_FOSR_Msk = 0x3ff0000
	// Position of IOSR field.
	DFSDM_FLT_FCR_IOSR_Pos = 0x0
	// Bit mask of IOSR field.
	DFSDM_FLT_FCR_IOSR_Msk = 0xff

	// FLT.JDATAR: data register for injected group
	// Position of JDATA field.
	DFSDM_FLT_JDATAR_JDATA_Pos = 0x8
	// Bit mask of JDATA field.
	DFSDM_FLT_JDATAR_JDATA_Msk = 0xffffff00
	// Position of JDATACH field.
	DFSDM_FLT_JDATAR_JDATACH_Pos = 0x0
	// Bit mask of JDATACH field.
	DFSDM_FLT_JDATAR_JDATACH_Msk = 0x7

	// FLT.RDATAR: data register for the regular channel
	// Position of RDATA field.
	DFSDM_FLT_RDATAR_RDATA_Pos = 0x8
	// Bit mask of RDATA field.
	DFSDM_FLT_RDATAR_RDATA_Msk = 0xffffff00
	// Position of RPEND field.
	DFSDM_FLT_RDATAR_RPEND_Pos = 0x4
	// Bit mask of RPEND field.
	DFSDM_FLT_RDATAR_RPEND_Msk = 0x10
	// Bit RPEND.
	DFSDM_FLT_RDATAR_RPEND = 0x10
	// Position of RDATACH field.
	DFSDM_FLT_RDATAR_RDATACH_Pos = 0x0
	// Bit mask of RDATACH field.
	DFSDM_FLT_RDATAR_RDATACH_Msk = 0x7

	// FLT.AWHTR: analog watchdog high threshold register
	// Position of AWHT field.
	DFSDM_FLT_AWHTR_AWHT_Pos = 0x8
	// Bit mask of AWHT field.
	DFSDM_FLT_AWHTR_AWHT_Msk = 0xffffff00
	// Position of BKAWH field.
	DFSDM_FLT_AWHTR_BKAWH_Pos = 0x0
	// Bit mask of BKAWH field.
	DFSDM_FLT_AWHTR_BKAWH_Msk = 0xf

	// FLT.AWLTR: analog watchdog low threshold register
	// Position of AWLT field.
	DFSDM_FLT_AWLTR_AWLT_Pos = 0x8
	// Bit mask of AWLT field.
	DFSDM_FLT_AWLTR_AWLT_Msk = 0xffffff00
	// Position of BKAWL field.
	DFSDM_FLT_AWLTR_BKAWL_Pos = 0x0
	// Bit mask of BKAWL field.
	DFSDM_FLT_AWLTR_BKAWL_Msk = 0xf

	// FLT.AWSR: analog watchdog status register
	// Position of AWHTF field.
	DFSDM_FLT_AWSR_AWHTF_Pos = 0x8
	// Bit mask of AWHTF field.
	DFSDM_FLT_AWSR_AWHTF_Msk = 0xff00
	// Position of AWLTF field.
	DFSDM_FLT_AWSR_AWLTF_Pos = 0x0
	// Bit mask of AWLTF field.
	DFSDM_FLT_AWSR_AWLTF_Msk = 0xff

	// FLT.AWCFR: analog watchdog clear flag register
	// Position of CLRAWHTF field.
	DFSDM_FLT_AWCFR_CLRAWHTF_Pos = 0x8
	// Bit mask of CLRAWHTF field.
	DFSDM_FLT_AWCFR_CLRAWHTF_Msk = 0xff00
	// Position of CLRAWLTF field.
	DFSDM_FLT_AWCFR_CLRAWLTF_Pos = 0x0
	// Bit mask of CLRAWLTF field.
	DFSDM_FLT_AWCFR_CLRAWLTF_Msk = 0xff

	// FLT.EXMAX: Extremes detector maximum register
	// Position of EXMAX field.
	DFSDM_FLT_EXMAX_EXMAX_Pos = 0x8
	// Bit mask of EXMAX field.
	DFSDM_FLT_EXMAX_EXMAX_Msk = 0xffffff00
	// Position of EXMAXCH field.
	DFSDM_FLT_EXMAX_EXMAXCH_Pos = 0x0
	// Bit mask of EXMAXCH field.
	DFSDM_FLT_EXMAX_EXMAXCH_Msk = 0x7

	// FLT.EXMIN: Extremes detector minimum register
	// Position of EXMIN field.
	DFSDM_FLT_EXMIN_EXMIN_Pos = 0x8
	// Bit mask of EXMIN field.
	DFSDM_FLT_EXMIN_EXMIN_Msk = 0xffffff00
	// Position of EXMINCH field.
	DFSDM_FLT_EXMIN_EXMINCH_Pos = 0x0
	// Bit mask of EXMINCH field.
	DFSDM_FLT_EXMIN_EXMINCH_Msk = 0x7

	// FLT.CNVTIMR: conversion timer register
	// Position of CNVCNT field.
	DFSDM_FLT_CNVTIMR_CNVCNT_Pos = 0x4
	// Bit mask of CNVCNT field.
	DFSDM_FLT_CNVTIMR_CNVCNT_Msk = 0xfffffff0
)

// Constants for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Constants for DMA1: DMA controller
const (
	// LISR: low interrupt status register
	// Position of TCIF3 field.
	DMA_LISR_TCIF3_Pos = 0x1b
	// Bit mask of TCIF3 field.
	DMA_LISR_TCIF3_Msk = 0x8000000
	// Bit TCIF3.
	DMA_LISR_TCIF3 = 0x8000000
	// No transfer complete event on stream x
	DMA_LISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_LISR_HTIF3_Pos = 0x1a
	// Bit mask of HTIF3 field.
	DMA_LISR_HTIF3_Msk = 0x4000000
	// Bit HTIF3.
	DMA_LISR_HTIF3 = 0x4000000
	// No half transfer event on stream x
	DMA_LISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_LISR_TEIF3_Pos = 0x19
	// Bit mask of TEIF3 field.
	DMA_LISR_TEIF3_Msk = 0x2000000
	// Bit TEIF3.
	DMA_LISR_TEIF3 = 0x2000000
	// No transfer error on stream x
	DMA_LISR_TEIF3_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF3_Error = 0x1
	// Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Pos = 0x18
	// Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000
	// Bit DMEIF3.
	DMA_LISR_DMEIF3 = 0x1000000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF3_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF3_Error = 0x1
	// Position of FEIF3 field.
	DMA_LISR_FEIF3_Pos = 0x16
	// Bit mask of FEIF3 field.
	DMA_LISR_FEIF3_Msk = 0x400000
	// Bit FEIF3.
	DMA_LISR_FEIF3 = 0x400000
	// No FIFO error event on stream x
	DMA_LISR_FEIF3_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF3_Error = 0x1
	// Position of TCIF2 field.
	DMA_LISR_TCIF2_Pos = 0x15
	// Bit mask of TCIF2 field.
	DMA_LISR_TCIF2_Msk = 0x200000
	// Bit TCIF2.
	DMA_LISR_TCIF2 = 0x200000
	// No transfer complete event on stream x
	DMA_LISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_LISR_HTIF2_Pos = 0x14
	// Bit mask of HTIF2 field.
	DMA_LISR_HTIF2_Msk = 0x100000
	// Bit HTIF2.
	DMA_LISR_HTIF2 = 0x100000
	// No half transfer event on stream x
	DMA_LISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_LISR_TEIF2_Pos = 0x13
	// Bit mask of TEIF2 field.
	DMA_LISR_TEIF2_Msk = 0x80000
	// Bit TEIF2.
	DMA_LISR_TEIF2 = 0x80000
	// No transfer error on stream x
	DMA_LISR_TEIF2_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF2_Error = 0x1
	// Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Pos = 0x12
	// Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000
	// Bit DMEIF2.
	DMA_LISR_DMEIF2 = 0x40000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF2_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF2_Error = 0x1
	// Position of FEIF2 field.
	DMA_LISR_FEIF2_Pos = 0x10
	// Bit mask of FEIF2 field.
	DMA_LISR_FEIF2_Msk = 0x10000
	// Bit FEIF2.
	DMA_LISR_FEIF2 = 0x10000
	// No FIFO error event on stream x
	DMA_LISR_FEIF2_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF2_Error = 0x1
	// Position of TCIF1 field.
	DMA_LISR_TCIF1_Pos = 0xb
	// Bit mask of TCIF1 field.
	DMA_LISR_TCIF1_Msk = 0x800
	// Bit TCIF1.
	DMA_LISR_TCIF1 = 0x800
	// No transfer complete event on stream x
	DMA_LISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_LISR_HTIF1_Pos = 0xa
	// Bit mask of HTIF1 field.
	DMA_LISR_HTIF1_Msk = 0x400
	// Bit HTIF1.
	DMA_LISR_HTIF1 = 0x400
	// No half transfer event on stream x
	DMA_LISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_LISR_TEIF1_Pos = 0x9
	// Bit mask of TEIF1 field.
	DMA_LISR_TEIF1_Msk = 0x200
	// Bit TEIF1.
	DMA_LISR_TEIF1 = 0x200
	// No transfer error on stream x
	DMA_LISR_TEIF1_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF1_Error = 0x1
	// Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Pos = 0x8
	// Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100
	// Bit DMEIF1.
	DMA_LISR_DMEIF1 = 0x100
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF1_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF1_Error = 0x1
	// Position of FEIF1 field.
	DMA_LISR_FEIF1_Pos = 0x6
	// Bit mask of FEIF1 field.
	DMA_LISR_FEIF1_Msk = 0x40
	// Bit FEIF1.
	DMA_LISR_FEIF1 = 0x40
	// No FIFO error event on stream x
	DMA_LISR_FEIF1_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF1_Error = 0x1
	// Position of TCIF0 field.
	DMA_LISR_TCIF0_Pos = 0x5
	// Bit mask of TCIF0 field.
	DMA_LISR_TCIF0_Msk = 0x20
	// Bit TCIF0.
	DMA_LISR_TCIF0 = 0x20
	// No transfer complete event on stream x
	DMA_LISR_TCIF0_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF0_Complete = 0x1
	// Position of HTIF0 field.
	DMA_LISR_HTIF0_Pos = 0x4
	// Bit mask of HTIF0 field.
	DMA_LISR_HTIF0_Msk = 0x10
	// Bit HTIF0.
	DMA_LISR_HTIF0 = 0x10
	// No half transfer event on stream x
	DMA_LISR_HTIF0_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF0_Half = 0x1
	// Position of TEIF0 field.
	DMA_LISR_TEIF0_Pos = 0x3
	// Bit mask of TEIF0 field.
	DMA_LISR_TEIF0_Msk = 0x8
	// Bit TEIF0.
	DMA_LISR_TEIF0 = 0x8
	// No transfer error on stream x
	DMA_LISR_TEIF0_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF0_Error = 0x1
	// Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Pos = 0x2
	// Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4
	// Bit DMEIF0.
	DMA_LISR_DMEIF0 = 0x4
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF0_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF0_Error = 0x1
	// Position of FEIF0 field.
	DMA_LISR_FEIF0_Pos = 0x0
	// Bit mask of FEIF0 field.
	DMA_LISR_FEIF0_Msk = 0x1
	// Bit FEIF0.
	DMA_LISR_FEIF0 = 0x1
	// No FIFO error event on stream x
	DMA_LISR_FEIF0_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF0_Error = 0x1

	// HISR: high interrupt status register
	// Position of TCIF7 field.
	DMA_HISR_TCIF7_Pos = 0x1b
	// Bit mask of TCIF7 field.
	DMA_HISR_TCIF7_Msk = 0x8000000
	// Bit TCIF7.
	DMA_HISR_TCIF7 = 0x8000000
	// No transfer complete event on stream x
	DMA_HISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_HISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_HISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_HISR_HTIF7 = 0x4000000
	// No half transfer event on stream x
	DMA_HISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_HISR_TEIF7_Pos = 0x19
	// Bit mask of TEIF7 field.
	DMA_HISR_TEIF7_Msk = 0x2000000
	// Bit TEIF7.
	DMA_HISR_TEIF7 = 0x2000000
	// No transfer error on stream x
	DMA_HISR_TEIF7_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF7_Error = 0x1
	// Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Pos = 0x18
	// Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000
	// Bit DMEIF7.
	DMA_HISR_DMEIF7 = 0x1000000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF7_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF7_Error = 0x1
	// Position of FEIF7 field.
	DMA_HISR_FEIF7_Pos = 0x16
	// Bit mask of FEIF7 field.
	DMA_HISR_FEIF7_Msk = 0x400000
	// Bit FEIF7.
	DMA_HISR_FEIF7 = 0x400000
	// No FIFO error event on stream x
	DMA_HISR_FEIF7_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF7_Error = 0x1
	// Position of TCIF6 field.
	DMA_HISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_HISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_HISR_TCIF6 = 0x200000
	// No transfer complete event on stream x
	DMA_HISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_HISR_HTIF6_Pos = 0x14
	// Bit mask of HTIF6 field.
	DMA_HISR_HTIF6_Msk = 0x100000
	// Bit HTIF6.
	DMA_HISR_HTIF6 = 0x100000
	// No half transfer event on stream x
	DMA_HISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_HISR_TEIF6_Pos = 0x13
	// Bit mask of TEIF6 field.
	DMA_HISR_TEIF6_Msk = 0x80000
	// Bit TEIF6.
	DMA_HISR_TEIF6 = 0x80000
	// No transfer error on stream x
	DMA_HISR_TEIF6_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF6_Error = 0x1
	// Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Pos = 0x12
	// Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000
	// Bit DMEIF6.
	DMA_HISR_DMEIF6 = 0x40000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF6_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF6_Error = 0x1
	// Position of FEIF6 field.
	DMA_HISR_FEIF6_Pos = 0x10
	// Bit mask of FEIF6 field.
	DMA_HISR_FEIF6_Msk = 0x10000
	// Bit FEIF6.
	DMA_HISR_FEIF6 = 0x10000
	// No FIFO error event on stream x
	DMA_HISR_FEIF6_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF6_Error = 0x1
	// Position of TCIF5 field.
	DMA_HISR_TCIF5_Pos = 0xb
	// Bit mask of TCIF5 field.
	DMA_HISR_TCIF5_Msk = 0x800
	// Bit TCIF5.
	DMA_HISR_TCIF5 = 0x800
	// No transfer complete event on stream x
	DMA_HISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_HISR_HTIF5_Pos = 0xa
	// Bit mask of HTIF5 field.
	DMA_HISR_HTIF5_Msk = 0x400
	// Bit HTIF5.
	DMA_HISR_HTIF5 = 0x400
	// No half transfer event on stream x
	DMA_HISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_HISR_TEIF5_Pos = 0x9
	// Bit mask of TEIF5 field.
	DMA_HISR_TEIF5_Msk = 0x200
	// Bit TEIF5.
	DMA_HISR_TEIF5 = 0x200
	// No transfer error on stream x
	DMA_HISR_TEIF5_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF5_Error = 0x1
	// Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Pos = 0x8
	// Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100
	// Bit DMEIF5.
	DMA_HISR_DMEIF5 = 0x100
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF5_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF5_Error = 0x1
	// Position of FEIF5 field.
	DMA_HISR_FEIF5_Pos = 0x6
	// Bit mask of FEIF5 field.
	DMA_HISR_FEIF5_Msk = 0x40
	// Bit FEIF5.
	DMA_HISR_FEIF5 = 0x40
	// No FIFO error event on stream x
	DMA_HISR_FEIF5_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF5_Error = 0x1
	// Position of TCIF4 field.
	DMA_HISR_TCIF4_Pos = 0x5
	// Bit mask of TCIF4 field.
	DMA_HISR_TCIF4_Msk = 0x20
	// Bit TCIF4.
	DMA_HISR_TCIF4 = 0x20
	// No transfer complete event on stream x
	DMA_HISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_HISR_HTIF4_Pos = 0x4
	// Bit mask of HTIF4 field.
	DMA_HISR_HTIF4_Msk = 0x10
	// Bit HTIF4.
	DMA_HISR_HTIF4 = 0x10
	// No half transfer event on stream x
	DMA_HISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_HISR_TEIF4_Pos = 0x3
	// Bit mask of TEIF4 field.
	DMA_HISR_TEIF4_Msk = 0x8
	// Bit TEIF4.
	DMA_HISR_TEIF4 = 0x8
	// No transfer error on stream x
	DMA_HISR_TEIF4_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF4_Error = 0x1
	// Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Pos = 0x2
	// Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4
	// Bit DMEIF4.
	DMA_HISR_DMEIF4 = 0x4
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF4_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF4_Error = 0x1
	// Position of FEIF4 field.
	DMA_HISR_FEIF4_Pos = 0x0
	// Bit mask of FEIF4 field.
	DMA_HISR_FEIF4_Msk = 0x1
	// Bit FEIF4.
	DMA_HISR_FEIF4 = 0x1
	// No FIFO error event on stream x
	DMA_HISR_FEIF4_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF4_Error = 0x1

	// LIFCR: low interrupt flag clear register
	// Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Pos = 0x1b
	// Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk = 0x8000000
	// Bit CTCIF3.
	DMA_LIFCR_CTCIF3 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Pos = 0x1a
	// Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk = 0x4000000
	// Bit CHTIF3.
	DMA_LIFCR_CHTIF3 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Pos = 0x19
	// Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk = 0x2000000
	// Bit CTEIF3.
	DMA_LIFCR_CTEIF3 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF3_Clear = 0x1
	// Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Pos = 0x18
	// Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000
	// Bit CDMEIF3.
	DMA_LIFCR_CDMEIF3 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF3_Clear = 0x1
	// Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Pos = 0x16
	// Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk = 0x400000
	// Bit CFEIF3.
	DMA_LIFCR_CFEIF3 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF3_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Pos = 0x15
	// Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk = 0x200000
	// Bit CTCIF2.
	DMA_LIFCR_CTCIF2 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Pos = 0x14
	// Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk = 0x100000
	// Bit CHTIF2.
	DMA_LIFCR_CHTIF2 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Pos = 0x13
	// Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk = 0x80000
	// Bit CTEIF2.
	DMA_LIFCR_CTEIF2 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF2_Clear = 0x1
	// Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Pos = 0x12
	// Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000
	// Bit CDMEIF2.
	DMA_LIFCR_CDMEIF2 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF2_Clear = 0x1
	// Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Pos = 0x10
	// Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk = 0x10000
	// Bit CFEIF2.
	DMA_LIFCR_CFEIF2 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF2_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Pos = 0xb
	// Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk = 0x800
	// Bit CTCIF1.
	DMA_LIFCR_CTCIF1 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Pos = 0xa
	// Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk = 0x400
	// Bit CHTIF1.
	DMA_LIFCR_CHTIF1 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Pos = 0x9
	// Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk = 0x200
	// Bit CTEIF1.
	DMA_LIFCR_CTEIF1 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF1_Clear = 0x1
	// Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Pos = 0x8
	// Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100
	// Bit CDMEIF1.
	DMA_LIFCR_CDMEIF1 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF1_Clear = 0x1
	// Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Pos = 0x6
	// Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk = 0x40
	// Bit CFEIF1.
	DMA_LIFCR_CFEIF1 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF1_Clear = 0x1
	// Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Pos = 0x5
	// Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk = 0x20
	// Bit CTCIF0.
	DMA_LIFCR_CTCIF0 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF0_Clear = 0x1
	// Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Pos = 0x4
	// Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk = 0x10
	// Bit CHTIF0.
	DMA_LIFCR_CHTIF0 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF0_Clear = 0x1
	// Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Pos = 0x3
	// Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk = 0x8
	// Bit CTEIF0.
	DMA_LIFCR_CTEIF0 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF0_Clear = 0x1
	// Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Pos = 0x2
	// Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4
	// Bit CDMEIF0.
	DMA_LIFCR_CDMEIF0 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF0_Clear = 0x1
	// Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Pos = 0x0
	// Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk = 0x1
	// Bit CFEIF0.
	DMA_LIFCR_CFEIF0 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF0_Clear = 0x1

	// HIFCR: high interrupt flag clear register
	// Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Pos = 0x1b
	// Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk = 0x8000000
	// Bit CTCIF7.
	DMA_HIFCR_CTCIF7 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_HIFCR_CHTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Pos = 0x19
	// Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk = 0x2000000
	// Bit CTEIF7.
	DMA_HIFCR_CTEIF7 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF7_Clear = 0x1
	// Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Pos = 0x18
	// Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000
	// Bit CDMEIF7.
	DMA_HIFCR_CDMEIF7 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF7_Clear = 0x1
	// Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Pos = 0x16
	// Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk = 0x400000
	// Bit CFEIF7.
	DMA_HIFCR_CFEIF7 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF7_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_HIFCR_CTCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Pos = 0x14
	// Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk = 0x100000
	// Bit CHTIF6.
	DMA_HIFCR_CHTIF6 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Pos = 0x13
	// Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk = 0x80000
	// Bit CTEIF6.
	DMA_HIFCR_CTEIF6 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF6_Clear = 0x1
	// Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Pos = 0x12
	// Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000
	// Bit CDMEIF6.
	DMA_HIFCR_CDMEIF6 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF6_Clear = 0x1
	// Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Pos = 0x10
	// Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk = 0x10000
	// Bit CFEIF6.
	DMA_HIFCR_CFEIF6 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF6_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Pos = 0xb
	// Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk = 0x800
	// Bit CTCIF5.
	DMA_HIFCR_CTCIF5 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Pos = 0xa
	// Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk = 0x400
	// Bit CHTIF5.
	DMA_HIFCR_CHTIF5 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Pos = 0x9
	// Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk = 0x200
	// Bit CTEIF5.
	DMA_HIFCR_CTEIF5 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF5_Clear = 0x1
	// Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Pos = 0x8
	// Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100
	// Bit CDMEIF5.
	DMA_HIFCR_CDMEIF5 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF5_Clear = 0x1
	// Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Pos = 0x6
	// Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk = 0x40
	// Bit CFEIF5.
	DMA_HIFCR_CFEIF5 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF5_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Pos = 0x5
	// Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk = 0x20
	// Bit CTCIF4.
	DMA_HIFCR_CTCIF4 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Pos = 0x4
	// Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk = 0x10
	// Bit CHTIF4.
	DMA_HIFCR_CHTIF4 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Pos = 0x3
	// Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk = 0x8
	// Bit CTEIF4.
	DMA_HIFCR_CTEIF4 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF4_Clear = 0x1
	// Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Pos = 0x2
	// Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4
	// Bit CDMEIF4.
	DMA_HIFCR_CDMEIF4 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF4_Clear = 0x1
	// Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Pos = 0x0
	// Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk = 0x1
	// Bit CFEIF4.
	DMA_HIFCR_CFEIF4 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF4_Clear = 0x1

	// ST.CR: stream x configuration register
	// Position of CHSEL field.
	DMA_ST_CR_CHSEL_Pos = 0x19
	// Bit mask of CHSEL field.
	DMA_ST_CR_CHSEL_Msk = 0x1e000000
	// Position of MBURST field.
	DMA_ST_CR_MBURST_Pos = 0x17
	// Bit mask of MBURST field.
	DMA_ST_CR_MBURST_Msk = 0x1800000
	// Single transfer
	DMA_ST_CR_MBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_MBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_MBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_MBURST_INCR16 = 0x3
	// Position of PBURST field.
	DMA_ST_CR_PBURST_Pos = 0x15
	// Bit mask of PBURST field.
	DMA_ST_CR_PBURST_Msk = 0x600000
	// Single transfer
	DMA_ST_CR_PBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_PBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_PBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_PBURST_INCR16 = 0x3
	// Position of CT field.
	DMA_ST_CR_CT_Pos = 0x13
	// Bit mask of CT field.
	DMA_ST_CR_CT_Msk = 0x80000
	// Bit CT.
	DMA_ST_CR_CT = 0x80000
	// The current target memory is Memory 0
	DMA_ST_CR_CT_Memory0 = 0x0
	// The current target memory is Memory 1
	DMA_ST_CR_CT_Memory1 = 0x1
	// Position of DBM field.
	DMA_ST_CR_DBM_Pos = 0x12
	// Bit mask of DBM field.
	DMA_ST_CR_DBM_Msk = 0x40000
	// Bit DBM.
	DMA_ST_CR_DBM = 0x40000
	// No buffer switching at the end of transfer
	DMA_ST_CR_DBM_Disabled = 0x0
	// Memory target switched at the end of the DMA transfer
	DMA_ST_CR_DBM_Enabled = 0x1
	// Position of PL field.
	DMA_ST_CR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA_ST_CR_PL_Msk = 0x30000
	// Low
	DMA_ST_CR_PL_Low = 0x0
	// Medium
	DMA_ST_CR_PL_Medium = 0x1
	// High
	DMA_ST_CR_PL_High = 0x2
	// Very high
	DMA_ST_CR_PL_VeryHigh = 0x3
	// Position of PINCOS field.
	DMA_ST_CR_PINCOS_Pos = 0xf
	// Bit mask of PINCOS field.
	DMA_ST_CR_PINCOS_Msk = 0x8000
	// Bit PINCOS.
	DMA_ST_CR_PINCOS = 0x8000
	// The offset size for the peripheral address calculation is linked to the PSIZE
	DMA_ST_CR_PINCOS_PSIZE = 0x0
	// The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)
	DMA_ST_CR_PINCOS_Fixed4 = 0x1
	// Position of MSIZE field.
	DMA_ST_CR_MSIZE_Pos = 0xd
	// Bit mask of MSIZE field.
	DMA_ST_CR_MSIZE_Msk = 0x6000
	// Byte (8-bit)
	DMA_ST_CR_MSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_MSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_ST_CR_PSIZE_Pos = 0xb
	// Bit mask of PSIZE field.
	DMA_ST_CR_PSIZE_Msk = 0x1800
	// Byte (8-bit)
	DMA_ST_CR_PSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_PSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_ST_CR_MINC_Pos = 0xa
	// Bit mask of MINC field.
	DMA_ST_CR_MINC_Msk = 0x400
	// Bit MINC.
	DMA_ST_CR_MINC = 0x400
	// Address pointer is fixed
	DMA_ST_CR_MINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_MINC_Incremented = 0x1
	// Position of PINC field.
	DMA_ST_CR_PINC_Pos = 0x9
	// Bit mask of PINC field.
	DMA_ST_CR_PINC_Msk = 0x200
	// Bit PINC.
	DMA_ST_CR_PINC = 0x200
	// Address pointer is fixed
	DMA_ST_CR_PINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_PINC_Incremented = 0x1
	// Position of CIRC field.
	DMA_ST_CR_CIRC_Pos = 0x8
	// Bit mask of CIRC field.
	DMA_ST_CR_CIRC_Msk = 0x100
	// Bit CIRC.
	DMA_ST_CR_CIRC = 0x100
	// Circular mode disabled
	DMA_ST_CR_CIRC_Disabled = 0x0
	// Circular mode enabled
	DMA_ST_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_ST_CR_DIR_Pos = 0x6
	// Bit mask of DIR field.
	DMA_ST_CR_DIR_Msk = 0xc0
	// Peripheral-to-memory
	DMA_ST_CR_DIR_PeripheralToMemory = 0x0
	// Memory-to-peripheral
	DMA_ST_CR_DIR_MemoryToPeripheral = 0x1
	// Memory-to-memory
	DMA_ST_CR_DIR_MemoryToMemory = 0x2
	// Position of PFCTRL field.
	DMA_ST_CR_PFCTRL_Pos = 0x5
	// Bit mask of PFCTRL field.
	DMA_ST_CR_PFCTRL_Msk = 0x20
	// Bit PFCTRL.
	DMA_ST_CR_PFCTRL = 0x20
	// The DMA is the flow controller
	DMA_ST_CR_PFCTRL_DMA = 0x0
	// The peripheral is the flow controller
	DMA_ST_CR_PFCTRL_Peripheral = 0x1
	// Position of TCIE field.
	DMA_ST_CR_TCIE_Pos = 0x4
	// Bit mask of TCIE field.
	DMA_ST_CR_TCIE_Msk = 0x10
	// Bit TCIE.
	DMA_ST_CR_TCIE = 0x10
	// TC interrupt disabled
	DMA_ST_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA_ST_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_ST_CR_HTIE_Pos = 0x3
	// Bit mask of HTIE field.
	DMA_ST_CR_HTIE_Msk = 0x8
	// Bit HTIE.
	DMA_ST_CR_HTIE = 0x8
	// HT interrupt disabled
	DMA_ST_CR_HTIE_Disabled = 0x0
	// HT interrupt enabled
	DMA_ST_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_ST_CR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	DMA_ST_CR_TEIE_Msk = 0x4
	// Bit TEIE.
	DMA_ST_CR_TEIE = 0x4
	// TE interrupt disabled
	DMA_ST_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA_ST_CR_TEIE_Enabled = 0x1
	// Position of DMEIE field.
	DMA_ST_CR_DMEIE_Pos = 0x1
	// Bit mask of DMEIE field.
	DMA_ST_CR_DMEIE_Msk = 0x2
	// Bit DMEIE.
	DMA_ST_CR_DMEIE = 0x2
	// DME interrupt disabled
	DMA_ST_CR_DMEIE_Disabled = 0x0
	// DME interrupt enabled
	DMA_ST_CR_DMEIE_Enabled = 0x1
	// Position of EN field.
	DMA_ST_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_ST_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_ST_CR_EN = 0x1
	// Stream disabled
	DMA_ST_CR_EN_Disabled = 0x0
	// Stream enabled
	DMA_ST_CR_EN_Enabled = 0x1

	// ST.NDTR: stream x number of data register
	// Position of NDT field.
	DMA_ST_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_ST_NDTR_NDT_Msk = 0xffff

	// ST.PAR: stream x peripheral address register
	// Position of PA field.
	DMA_ST_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_ST_PAR_PA_Msk = 0xffffffff

	// ST.M0AR: stream x memory 0 address register
	// Position of M0A field.
	DMA_ST_M0AR_M0A_Pos = 0x0
	// Bit mask of M0A field.
	DMA_ST_M0AR_M0A_Msk = 0xffffffff

	// ST.M1AR: stream x memory 1 address register
	// Position of M1A field.
	DMA_ST_M1AR_M1A_Pos = 0x0
	// Bit mask of M1A field.
	DMA_ST_M1AR_M1A_Msk = 0xffffffff

	// ST.FCR: stream x FIFO control register
	// Position of FEIE field.
	DMA_ST_FCR_FEIE_Pos = 0x7
	// Bit mask of FEIE field.
	DMA_ST_FCR_FEIE_Msk = 0x80
	// Bit FEIE.
	DMA_ST_FCR_FEIE = 0x80
	// FE interrupt disabled
	DMA_ST_FCR_FEIE_Disabled = 0x0
	// FE interrupt enabled
	DMA_ST_FCR_FEIE_Enabled = 0x1
	// Position of FS field.
	DMA_ST_FCR_FS_Pos = 0x3
	// Bit mask of FS field.
	DMA_ST_FCR_FS_Msk = 0x38
	// 0 < fifo_level < 1/4
	DMA_ST_FCR_FS_Quarter1 = 0x0
	// 1/4 <= fifo_level < 1/2
	DMA_ST_FCR_FS_Quarter2 = 0x1
	// 1/2 <= fifo_level < 3/4
	DMA_ST_FCR_FS_Quarter3 = 0x2
	// 3/4 <= fifo_level < full
	DMA_ST_FCR_FS_Quarter4 = 0x3
	// FIFO is empty
	DMA_ST_FCR_FS_Empty = 0x4
	// FIFO is full
	DMA_ST_FCR_FS_Full = 0x5
	// Position of DMDIS field.
	DMA_ST_FCR_DMDIS_Pos = 0x2
	// Bit mask of DMDIS field.
	DMA_ST_FCR_DMDIS_Msk = 0x4
	// Bit DMDIS.
	DMA_ST_FCR_DMDIS = 0x4
	// Direct mode is enabled
	DMA_ST_FCR_DMDIS_Enabled = 0x0
	// Direct mode is disabled
	DMA_ST_FCR_DMDIS_Disabled = 0x1
	// Position of FTH field.
	DMA_ST_FCR_FTH_Pos = 0x0
	// Bit mask of FTH field.
	DMA_ST_FCR_FTH_Msk = 0x3
	// 1/4 full FIFO
	DMA_ST_FCR_FTH_Quarter = 0x0
	// 1/2 full FIFO
	DMA_ST_FCR_FTH_Half = 0x1
	// 3/4 full FIFO
	DMA_ST_FCR_FTH_ThreeQuarters = 0x2
	// Full FIFO
	DMA_ST_FCR_FTH_Full = 0x3
)

// Constants for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR22_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR22_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR22_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR22_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWIER22_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR22_Clear = 0x1
)

// Constants for FMPI2C1: fast-mode Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1
	// Position of TXIE field.
	I2C_CR1_TXIE_Pos = 0x1
	// Bit mask of TXIE field.
	I2C_CR1_TXIE_Msk = 0x2
	// Bit TXIE.
	I2C_CR1_TXIE = 0x2
	// Transmit (TXIS) interrupt disabled
	I2C_CR1_TXIE_Disabled = 0x0
	// Transmit (TXIS) interrupt enabled
	I2C_CR1_TXIE_Enabled = 0x1
	// Position of RXIE field.
	I2C_CR1_RXIE_Pos = 0x2
	// Bit mask of RXIE field.
	I2C_CR1_RXIE_Msk = 0x4
	// Bit RXIE.
	I2C_CR1_RXIE = 0x4
	// Receive (RXNE) interrupt disabled
	I2C_CR1_RXIE_Disabled = 0x0
	// Receive (RXNE) interrupt enabled
	I2C_CR1_RXIE_Enabled = 0x1
	// Position of ADDRIE field.
	I2C_CR1_ADDRIE_Pos = 0x3
	// Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE_Msk = 0x8
	// Bit ADDRIE.
	I2C_CR1_ADDRIE = 0x8
	// Address match (ADDR) interrupts disabled
	I2C_CR1_ADDRIE_Disabled = 0x0
	// Address match (ADDR) interrupts enabled
	I2C_CR1_ADDRIE_Enabled = 0x1
	// Position of NACKIE field.
	I2C_CR1_NACKIE_Pos = 0x4
	// Bit mask of NACKIE field.
	I2C_CR1_NACKIE_Msk = 0x10
	// Bit NACKIE.
	I2C_CR1_NACKIE = 0x10
	// Not acknowledge (NACKF) received interrupts disabled
	I2C_CR1_NACKIE_Disabled = 0x0
	// Not acknowledge (NACKF) received interrupts enabled
	I2C_CR1_NACKIE_Enabled = 0x1
	// Position of STOPIE field.
	I2C_CR1_STOPIE_Pos = 0x5
	// Bit mask of STOPIE field.
	I2C_CR1_STOPIE_Msk = 0x20
	// Bit STOPIE.
	I2C_CR1_STOPIE = 0x20
	// Stop detection (STOPF) interrupt disabled
	I2C_CR1_STOPIE_Disabled = 0x0
	// Stop detection (STOPF) interrupt enabled
	I2C_CR1_STOPIE_Enabled = 0x1
	// Position of TCIE field.
	I2C_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	I2C_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	I2C_CR1_TCIE = 0x40
	// Transfer Complete interrupt disabled
	I2C_CR1_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	I2C_CR1_TCIE_Enabled = 0x1
	// Position of ERRIE field.
	I2C_CR1_ERRIE_Pos = 0x7
	// Bit mask of ERRIE field.
	I2C_CR1_ERRIE_Msk = 0x80
	// Bit ERRIE.
	I2C_CR1_ERRIE = 0x80
	// Error detection interrupts disabled
	I2C_CR1_ERRIE_Disabled = 0x0
	// Error detection interrupts enabled
	I2C_CR1_ERRIE_Enabled = 0x1
	// Position of DNF field.
	I2C_CR1_DNF_Pos = 0x8
	// Bit mask of DNF field.
	I2C_CR1_DNF_Msk = 0xf00
	// Digital filter disabled
	I2C_CR1_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_CR1_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_CR1_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_CR1_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_CR1_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_CR1_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_CR1_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_CR1_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_CR1_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_CR1_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_CR1_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_CR1_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_CR1_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_CR1_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_CR1_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_CR1_DNF_Filter15 = 0xf
	// Position of ANFOFF field.
	I2C_CR1_ANFOFF_Pos = 0xc
	// Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF_Msk = 0x1000
	// Bit ANFOFF.
	I2C_CR1_ANFOFF = 0x1000
	// Analog noise filter enabled
	I2C_CR1_ANFOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_CR1_ANFOFF_Disabled = 0x1
	// Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Pos = 0xe
	// Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk = 0x4000
	// Bit TXDMAEN.
	I2C_CR1_TXDMAEN = 0x4000
	// DMA mode disabled for transmission
	I2C_CR1_TXDMAEN_Disabled = 0x0
	// DMA mode enabled for transmission
	I2C_CR1_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Pos = 0xf
	// Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk = 0x8000
	// Bit RXDMAEN.
	I2C_CR1_RXDMAEN = 0x8000
	// DMA mode disabled for reception
	I2C_CR1_RXDMAEN_Disabled = 0x0
	// DMA mode enabled for reception
	I2C_CR1_RXDMAEN_Enabled = 0x1
	// Position of SBC field.
	I2C_CR1_SBC_Pos = 0x10
	// Bit mask of SBC field.
	I2C_CR1_SBC_Msk = 0x10000
	// Bit SBC.
	I2C_CR1_SBC = 0x10000
	// Slave byte control disabled
	I2C_CR1_SBC_Disabled = 0x0
	// Slave byte control enabled
	I2C_CR1_SBC_Enabled = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x11
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x20000
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of GCEN field.
	I2C_CR1_GCEN_Pos = 0x13
	// Bit mask of GCEN field.
	I2C_CR1_GCEN_Msk = 0x80000
	// Bit GCEN.
	I2C_CR1_GCEN = 0x80000
	// General call disabled. Address 0b00000000 is NACKed
	I2C_CR1_GCEN_Disabled = 0x0
	// General call enabled. Address 0b00000000 is ACKed
	I2C_CR1_GCEN_Enabled = 0x1
	// Position of SMBHEN field.
	I2C_CR1_SMBHEN_Pos = 0x14
	// Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN_Msk = 0x100000
	// Bit SMBHEN.
	I2C_CR1_SMBHEN = 0x100000
	// Host address disabled. Address 0b0001000x is NACKed
	I2C_CR1_SMBHEN_Disabled = 0x0
	// Host address enabled. Address 0b0001000x is ACKed
	I2C_CR1_SMBHEN_Enabled = 0x1
	// Position of SMBDEN field.
	I2C_CR1_SMBDEN_Pos = 0x15
	// Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN_Msk = 0x200000
	// Bit SMBDEN.
	I2C_CR1_SMBDEN = 0x200000
	// Device default address disabled. Address 0b1100001x is NACKed
	I2C_CR1_SMBDEN_Disabled = 0x0
	// Device default address enabled. Address 0b1100001x is ACKed
	I2C_CR1_SMBDEN_Enabled = 0x1
	// Position of ALERTEN field.
	I2C_CR1_ALERTEN_Pos = 0x16
	// Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN_Msk = 0x400000
	// Bit ALERTEN.
	I2C_CR1_ALERTEN = 0x400000
	// In device mode (SMBHEN=Disabled) Releases SMBA pin high and Alert Response Address Header disabled (0001100x) followed by NACK. In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) not supported
	I2C_CR1_ALERTEN_Disabled = 0x0
	// In device mode (SMBHEN=Disabled) Drives SMBA pin low and Alert Response Address Header enabled (0001100x) followed by ACK.In host mode (SMBHEN=Enabled) SMBus Alert pin (SMBA) supported
	I2C_CR1_ALERTEN_Enabled = 0x1
	// Position of PECEN field.
	I2C_CR1_PECEN_Pos = 0x17
	// Bit mask of PECEN field.
	I2C_CR1_PECEN_Msk = 0x800000
	// Bit PECEN.
	I2C_CR1_PECEN = 0x800000
	// PEC calculation disabled
	I2C_CR1_PECEN_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_PECEN_Enabled = 0x1

	// CR2: Control register 2
	// Position of RD_WRN field.
	I2C_CR2_RD_WRN_Pos = 0xa
	// Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN_Msk = 0x400
	// Bit RD_WRN.
	I2C_CR2_RD_WRN = 0x400
	// Master requests a write transfer
	I2C_CR2_RD_WRN_Write = 0x0
	// Master requests a read transfer
	I2C_CR2_RD_WRN_Read = 0x1
	// Position of ADD10 field.
	I2C_CR2_ADD10_Pos = 0xb
	// Bit mask of ADD10 field.
	I2C_CR2_ADD10_Msk = 0x800
	// Bit ADD10.
	I2C_CR2_ADD10 = 0x800
	// The master operates in 7-bit addressing mode
	I2C_CR2_ADD10_Bit7 = 0x0
	// The master operates in 10-bit addressing mode
	I2C_CR2_ADD10_Bit10 = 0x1
	// Position of HEAD10R field.
	I2C_CR2_HEAD10R_Pos = 0xc
	// Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000
	// Bit HEAD10R.
	I2C_CR2_HEAD10R = 0x1000
	// The master sends the complete 10 bit slave address read sequence
	I2C_CR2_HEAD10R_Complete = 0x0
	// The master only sends the 1st 7 bits of the 10 bit address, followed by Read direction
	I2C_CR2_HEAD10R_Partial = 0x1
	// Position of START field.
	I2C_CR2_START_Pos = 0xd
	// Bit mask of START field.
	I2C_CR2_START_Msk = 0x2000
	// Bit START.
	I2C_CR2_START = 0x2000
	// No Start generation
	I2C_CR2_START_NoStart = 0x0
	// Restart/Start generation
	I2C_CR2_START_Start = 0x1
	// Position of STOP field.
	I2C_CR2_STOP_Pos = 0xe
	// Bit mask of STOP field.
	I2C_CR2_STOP_Msk = 0x4000
	// Bit STOP.
	I2C_CR2_STOP = 0x4000
	// No Stop generation
	I2C_CR2_STOP_NoStop = 0x0
	// Stop generation after current byte transfer
	I2C_CR2_STOP_Stop = 0x1
	// Position of NACK field.
	I2C_CR2_NACK_Pos = 0xf
	// Bit mask of NACK field.
	I2C_CR2_NACK_Msk = 0x8000
	// Bit NACK.
	I2C_CR2_NACK = 0x8000
	// an ACK is sent after current received byte
	I2C_CR2_NACK_Ack = 0x0
	// a NACK is sent after current received byte
	I2C_CR2_NACK_Nack = 0x1
	// Position of NBYTES field.
	I2C_CR2_NBYTES_Pos = 0x10
	// Bit mask of NBYTES field.
	I2C_CR2_NBYTES_Msk = 0xff0000
	// Position of RELOAD field.
	I2C_CR2_RELOAD_Pos = 0x18
	// Bit mask of RELOAD field.
	I2C_CR2_RELOAD_Msk = 0x1000000
	// Bit RELOAD.
	I2C_CR2_RELOAD = 0x1000000
	// The transfer is completed after the NBYTES data transfer (STOP or RESTART will follow)
	I2C_CR2_RELOAD_Completed = 0x0
	// The transfer is not completed after the NBYTES data transfer (NBYTES will be reloaded)
	I2C_CR2_RELOAD_NotCompleted = 0x1
	// Position of AUTOEND field.
	I2C_CR2_AUTOEND_Pos = 0x19
	// Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000
	// Bit AUTOEND.
	I2C_CR2_AUTOEND = 0x2000000
	// Software end mode: TC flag is set when NBYTES data are transferred, stretching SCL low
	I2C_CR2_AUTOEND_Software = 0x0
	// Automatic end mode: a STOP condition is automatically sent when NBYTES data are transferred
	I2C_CR2_AUTOEND_Automatic = 0x1
	// Position of PECBYTE field.
	I2C_CR2_PECBYTE_Pos = 0x1a
	// Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000
	// Bit PECBYTE.
	I2C_CR2_PECBYTE = 0x4000000
	// No PEC transfer
	I2C_CR2_PECBYTE_NoPec = 0x0
	// PEC transmission/reception is requested
	I2C_CR2_PECBYTE_Pec = 0x1
	// Position of SADD field.
	I2C_CR2_SADD_Pos = 0x0
	// Bit mask of SADD field.
	I2C_CR2_SADD_Msk = 0x3ff

	// OAR1: Own address register 1
	// Position of OA1 field.
	I2C_OAR1_OA1_Pos = 0x0
	// Bit mask of OA1 field.
	I2C_OAR1_OA1_Msk = 0x1
	// Bit OA1.
	I2C_OAR1_OA1 = 0x1
	// Position of OA11_7 field.
	I2C_OAR1_OA11_7_Pos = 0x1
	// Bit mask of OA11_7 field.
	I2C_OAR1_OA11_7_Msk = 0xfe
	// Position of OA18_9 field.
	I2C_OAR1_OA18_9_Pos = 0x8
	// Bit mask of OA18_9 field.
	I2C_OAR1_OA18_9_Msk = 0x300
	// Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Pos = 0xa
	// Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400
	// Bit OA1MODE.
	I2C_OAR1_OA1MODE = 0x400
	// Own address 1 is a 7-bit address
	I2C_OAR1_OA1MODE_Bit7 = 0x0
	// Own address 1 is a 10-bit address
	I2C_OAR1_OA1MODE_Bit10 = 0x1
	// Position of OA1EN field.
	I2C_OAR1_OA1EN_Pos = 0xf
	// Bit mask of OA1EN field.
	I2C_OAR1_OA1EN_Msk = 0x8000
	// Bit OA1EN.
	I2C_OAR1_OA1EN = 0x8000
	// Own address 1 disabled. The received slave address OA1 is NACKed
	I2C_OAR1_OA1EN_Disabled = 0x0
	// Own address 1 enabled. The received slave address OA1 is ACKed
	I2C_OAR1_OA1EN_Enabled = 0x1

	// OAR2: Own address register 2
	// Position of OA2 field.
	I2C_OAR2_OA2_Pos = 0x1
	// Bit mask of OA2 field.
	I2C_OAR2_OA2_Msk = 0xfe
	// Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Pos = 0x8
	// Bit mask of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700
	// No mask
	I2C_OAR2_OA2MSK_NoMask = 0x0
	// OA2[1] is masked and don’t care. Only OA2[7:2] are compared
	I2C_OAR2_OA2MSK_Mask1 = 0x1
	// OA2[2:1] are masked and don’t care. Only OA2[7:3] are compared
	I2C_OAR2_OA2MSK_Mask2 = 0x2
	// OA2[3:1] are masked and don’t care. Only OA2[7:4] are compared
	I2C_OAR2_OA2MSK_Mask3 = 0x3
	// OA2[4:1] are masked and don’t care. Only OA2[7:5] are compared
	I2C_OAR2_OA2MSK_Mask4 = 0x4
	// OA2[5:1] are masked and don’t care. Only OA2[7:6] are compared
	I2C_OAR2_OA2MSK_Mask5 = 0x5
	// OA2[6:1] are masked and don’t care. Only OA2[7] is compared.
	I2C_OAR2_OA2MSK_Mask6 = 0x6
	// OA2[7:1] are masked and don’t care. No comparison is done, and all (except reserved) 7-bit received addresses are acknowledged
	I2C_OAR2_OA2MSK_Mask7 = 0x7
	// Position of OA2EN field.
	I2C_OAR2_OA2EN_Pos = 0xf
	// Bit mask of OA2EN field.
	I2C_OAR2_OA2EN_Msk = 0x8000
	// Bit OA2EN.
	I2C_OAR2_OA2EN = 0x8000
	// Own address 2 disabled. The received slave address OA2 is NACKed
	I2C_OAR2_OA2EN_Disabled = 0x0
	// Own address 2 enabled. The received slave address OA2 is ACKed
	I2C_OAR2_OA2EN_Enabled = 0x1

	// TIMINGR: Timing register
	// Position of SCLL field.
	I2C_TIMINGR_SCLL_Pos = 0x0
	// Bit mask of SCLL field.
	I2C_TIMINGR_SCLL_Msk = 0xff
	// Position of SCLH field.
	I2C_TIMINGR_SCLH_Pos = 0x8
	// Bit mask of SCLH field.
	I2C_TIMINGR_SCLH_Msk = 0xff00
	// Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Pos = 0x10
	// Bit mask of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000
	// Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14
	// Bit mask of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000
	// Position of PRESC field.
	I2C_TIMINGR_PRESC_Pos = 0x1c
	// Bit mask of PRESC field.
	I2C_TIMINGR_PRESC_Msk = 0xf0000000

	// TIMEOUTR: Timeout register
	// Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0
	// Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff
	// Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Pos = 0xc
	// Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk = 0x1000
	// Bit TIDLE.
	I2C_TIMEOUTR_TIDLE = 0x1000
	// TIMEOUTA is used to detect SCL low timeout
	I2C_TIMEOUTR_TIDLE_Disabled = 0x0
	// TIMEOUTA is used to detect both SCL and SDA high timeout (bus idle condition)
	I2C_TIMEOUTR_TIDLE_Enabled = 0x1
	// Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf
	// Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000
	// Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMOUTEN = 0x8000
	// SCL timeout detection is disabled
	I2C_TIMEOUTR_TIMOUTEN_Disabled = 0x0
	// SCL timeout detection is enabled
	I2C_TIMEOUTR_TIMOUTEN_Enabled = 0x1
	// Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10
	// Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000
	// Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Pos = 0x1f
	// Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk = 0x80000000
	// Bit TEXTEN.
	I2C_TIMEOUTR_TEXTEN = 0x80000000
	// Extended clock timeout detection is disabled
	I2C_TIMEOUTR_TEXTEN_Disabled = 0x0
	// Extended clock timeout detection is enabled
	I2C_TIMEOUTR_TEXTEN_Enabled = 0x1

	// ISR: Interrupt and Status register
	// Position of TXE field.
	I2C_ISR_TXE_Pos = 0x0
	// Bit mask of TXE field.
	I2C_ISR_TXE_Msk = 0x1
	// Bit TXE.
	I2C_ISR_TXE = 0x1
	// TXDR register not empty
	I2C_ISR_TXE_NotEmpty = 0x0
	// TXDR register empty
	I2C_ISR_TXE_Empty = 0x1
	// Position of TXIS field.
	I2C_ISR_TXIS_Pos = 0x1
	// Bit mask of TXIS field.
	I2C_ISR_TXIS_Msk = 0x2
	// Bit TXIS.
	I2C_ISR_TXIS = 0x2
	// The TXDR register is not empty
	I2C_ISR_TXIS_NotEmpty = 0x0
	// The TXDR register is empty and the data to be transmitted must be written in the TXDR register
	I2C_ISR_TXIS_Empty = 0x1
	// Position of RXNE field.
	I2C_ISR_RXNE_Pos = 0x2
	// Bit mask of RXNE field.
	I2C_ISR_RXNE_Msk = 0x4
	// Bit RXNE.
	I2C_ISR_RXNE = 0x4
	// The RXDR register is empty
	I2C_ISR_RXNE_Empty = 0x0
	// Received data is copied into the RXDR register, and is ready to be read
	I2C_ISR_RXNE_NotEmpty = 0x1
	// Position of ADDR field.
	I2C_ISR_ADDR_Pos = 0x3
	// Bit mask of ADDR field.
	I2C_ISR_ADDR_Msk = 0x8
	// Bit ADDR.
	I2C_ISR_ADDR = 0x8
	// Adress mismatched or not received
	I2C_ISR_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_ISR_ADDR_Match = 0x1
	// Position of NACKF field.
	I2C_ISR_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	I2C_ISR_NACKF_Msk = 0x10
	// Bit NACKF.
	I2C_ISR_NACKF = 0x10
	// No NACK has been received
	I2C_ISR_NACKF_NoNack = 0x0
	// NACK has been received
	I2C_ISR_NACKF_Nack = 0x1
	// Position of STOPF field.
	I2C_ISR_STOPF_Pos = 0x5
	// Bit mask of STOPF field.
	I2C_ISR_STOPF_Msk = 0x20
	// Bit STOPF.
	I2C_ISR_STOPF = 0x20
	// No Stop condition detected
	I2C_ISR_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_ISR_STOPF_Stop = 0x1
	// Position of TC field.
	I2C_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	I2C_ISR_TC_Msk = 0x40
	// Bit TC.
	I2C_ISR_TC = 0x40
	// Transfer is not complete
	I2C_ISR_TC_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TC_Complete = 0x1
	// Position of TCR field.
	I2C_ISR_TCR_Pos = 0x7
	// Bit mask of TCR field.
	I2C_ISR_TCR_Msk = 0x80
	// Bit TCR.
	I2C_ISR_TCR = 0x80
	// Transfer is not complete
	I2C_ISR_TCR_NotComplete = 0x0
	// NBYTES has been transfered
	I2C_ISR_TCR_Complete = 0x1
	// Position of BERR field.
	I2C_ISR_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_ISR_BERR_Msk = 0x100
	// Bit BERR.
	I2C_ISR_BERR = 0x100
	// No bus error
	I2C_ISR_BERR_NoError = 0x0
	// Misplaced Start and Stop condition is detected
	I2C_ISR_BERR_Error = 0x1
	// Position of ARLO field.
	I2C_ISR_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_ISR_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_ISR_ARLO = 0x200
	// No arbitration lost
	I2C_ISR_ARLO_NotLost = 0x0
	// Arbitration lost
	I2C_ISR_ARLO_Lost = 0x1
	// Position of OVR field.
	I2C_ISR_OVR_Pos = 0xa
	// Bit mask of OVR field.
	I2C_ISR_OVR_Msk = 0x400
	// Bit OVR.
	I2C_ISR_OVR = 0x400
	// No overrun/underrun error occurs
	I2C_ISR_OVR_NoOverrun = 0x0
	// slave mode with NOSTRETCH=1, when an overrun/underrun error occurs
	I2C_ISR_OVR_Overrun = 0x1
	// Position of PECERR field.
	I2C_ISR_PECERR_Pos = 0xb
	// Bit mask of PECERR field.
	I2C_ISR_PECERR_Msk = 0x800
	// Bit PECERR.
	I2C_ISR_PECERR = 0x800
	// Received PEC does match with PEC register
	I2C_ISR_PECERR_Match = 0x0
	// Received PEC does not match with PEC register
	I2C_ISR_PECERR_NoMatch = 0x1
	// Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Pos = 0xc
	// Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000
	// Bit TIMEOUT.
	I2C_ISR_TIMEOUT = 0x1000
	// No timeout occured
	I2C_ISR_TIMEOUT_NoTimeout = 0x0
	// Timeout occured
	I2C_ISR_TIMEOUT_Timeout = 0x1
	// Position of ALERT field.
	I2C_ISR_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_ISR_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_ISR_ALERT = 0x2000
	// SMBA alert is not detected
	I2C_ISR_ALERT_NoAlert = 0x0
	// SMBA alert event is detected on SMBA pin
	I2C_ISR_ALERT_Alert = 0x1
	// Position of BUSY field.
	I2C_ISR_BUSY_Pos = 0xf
	// Bit mask of BUSY field.
	I2C_ISR_BUSY_Msk = 0x8000
	// Bit BUSY.
	I2C_ISR_BUSY = 0x8000
	// No communication is in progress on the bus
	I2C_ISR_BUSY_NotBusy = 0x0
	// A communication is in progress on the bus
	I2C_ISR_BUSY_Busy = 0x1
	// Position of DIR field.
	I2C_ISR_DIR_Pos = 0x10
	// Bit mask of DIR field.
	I2C_ISR_DIR_Msk = 0x10000
	// Bit DIR.
	I2C_ISR_DIR = 0x10000
	// Write transfer, slave enters receiver mode
	I2C_ISR_DIR_Write = 0x0
	// Read transfer, slave enters transmitter mode
	I2C_ISR_DIR_Read = 0x1
	// Position of ADDCODE field.
	I2C_ISR_ADDCODE_Pos = 0x11
	// Bit mask of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000

	// ICR: Interrupt clear register
	// Position of ADDRCF field.
	I2C_ICR_ADDRCF_Pos = 0x3
	// Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF_Msk = 0x8
	// Bit ADDRCF.
	I2C_ICR_ADDRCF = 0x8
	// Clears the ADDR flag in ISR register
	I2C_ICR_ADDRCF_Clear = 0x1
	// Position of NACKCF field.
	I2C_ICR_NACKCF_Pos = 0x4
	// Bit mask of NACKCF field.
	I2C_ICR_NACKCF_Msk = 0x10
	// Bit NACKCF.
	I2C_ICR_NACKCF = 0x10
	// Clears the NACK flag in ISR register
	I2C_ICR_NACKCF_Clear = 0x1
	// Position of STOPCF field.
	I2C_ICR_STOPCF_Pos = 0x5
	// Bit mask of STOPCF field.
	I2C_ICR_STOPCF_Msk = 0x20
	// Bit STOPCF.
	I2C_ICR_STOPCF = 0x20
	// Clears the STOP flag in ISR register
	I2C_ICR_STOPCF_Clear = 0x1
	// Position of BERRCF field.
	I2C_ICR_BERRCF_Pos = 0x8
	// Bit mask of BERRCF field.
	I2C_ICR_BERRCF_Msk = 0x100
	// Bit BERRCF.
	I2C_ICR_BERRCF = 0x100
	// Clears the BERR flag in ISR register
	I2C_ICR_BERRCF_Clear = 0x1
	// Position of ARLOCF field.
	I2C_ICR_ARLOCF_Pos = 0x9
	// Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF_Msk = 0x200
	// Bit ARLOCF.
	I2C_ICR_ARLOCF = 0x200
	// Clears the ARLO flag in ISR register
	I2C_ICR_ARLOCF_Clear = 0x1
	// Position of OVRCF field.
	I2C_ICR_OVRCF_Pos = 0xa
	// Bit mask of OVRCF field.
	I2C_ICR_OVRCF_Msk = 0x400
	// Bit OVRCF.
	I2C_ICR_OVRCF = 0x400
	// Clears the OVR flag in ISR register
	I2C_ICR_OVRCF_Clear = 0x1
	// Position of PECCF field.
	I2C_ICR_PECCF_Pos = 0xb
	// Bit mask of PECCF field.
	I2C_ICR_PECCF_Msk = 0x800
	// Bit PECCF.
	I2C_ICR_PECCF = 0x800
	// Clears the PEC flag in ISR register
	I2C_ICR_PECCF_Clear = 0x1
	// Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Pos = 0xc
	// Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000
	// Bit TIMOUTCF.
	I2C_ICR_TIMOUTCF = 0x1000
	// Clears the TIMOUT flag in ISR register
	I2C_ICR_TIMOUTCF_Clear = 0x1
	// Position of ALERTCF field.
	I2C_ICR_ALERTCF_Pos = 0xd
	// Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF_Msk = 0x2000
	// Bit ALERTCF.
	I2C_ICR_ALERTCF = 0x2000
	// Clears the ALERT flag in ISR register
	I2C_ICR_ALERTCF_Clear = 0x1

	// PECR: PEC register
	// Position of PEC field.
	I2C_PECR_PEC_Pos = 0x0
	// Bit mask of PEC field.
	I2C_PECR_PEC_Msk = 0xff

	// RXDR: Receive data register
	// Position of RXDATA field.
	I2C_RXDR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff

	// TXDR: Transmit data register
	// Position of TXDATA field.
	I2C_TXDR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff
)

// Constants for FLASH: FLASH
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	FLASH_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0xf
	// 0 wait states
	FLASH_ACR_LATENCY_WS0 = 0x0
	// 1 wait states
	FLASH_ACR_LATENCY_WS1 = 0x1
	// 2 wait states
	FLASH_ACR_LATENCY_WS2 = 0x2
	// 3 wait states
	FLASH_ACR_LATENCY_WS3 = 0x3
	// 4 wait states
	FLASH_ACR_LATENCY_WS4 = 0x4
	// 5 wait states
	FLASH_ACR_LATENCY_WS5 = 0x5
	// 6 wait states
	FLASH_ACR_LATENCY_WS6 = 0x6
	// 7 wait states
	FLASH_ACR_LATENCY_WS7 = 0x7
	// 8 wait states
	FLASH_ACR_LATENCY_WS8 = 0x8
	// 9 wait states
	FLASH_ACR_LATENCY_WS9 = 0x9
	// 10 wait states
	FLASH_ACR_LATENCY_WS10 = 0xa
	// 11 wait states
	FLASH_ACR_LATENCY_WS11 = 0xb
	// 12 wait states
	FLASH_ACR_LATENCY_WS12 = 0xc
	// 13 wait states
	FLASH_ACR_LATENCY_WS13 = 0xd
	// 14 wait states
	FLASH_ACR_LATENCY_WS14 = 0xe
	// 15 wait states
	FLASH_ACR_LATENCY_WS15 = 0xf
	// Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	FLASH_ACR_PRFTEN = 0x100
	// Prefetch is disabled
	FLASH_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	FLASH_ACR_PRFTEN_Enabled = 0x1
	// Position of ICEN field.
	FLASH_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	FLASH_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	FLASH_ACR_ICEN = 0x200
	// Instruction cache is disabled
	FLASH_ACR_ICEN_Disabled = 0x0
	// Instruction cache is enabled
	FLASH_ACR_ICEN_Enabled = 0x1
	// Position of DCEN field.
	FLASH_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	FLASH_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	FLASH_ACR_DCEN = 0x400
	// Data cache is disabled
	FLASH_ACR_DCEN_Disabled = 0x0
	// Data cache is enabled
	FLASH_ACR_DCEN_Enabled = 0x1
	// Position of ICRST field.
	FLASH_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	FLASH_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	FLASH_ACR_ICRST = 0x800
	// Instruction cache is not reset
	FLASH_ACR_ICRST_NotReset = 0x0
	// Instruction cache is reset
	FLASH_ACR_ICRST_Reset = 0x1
	// Position of DCRST field.
	FLASH_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	FLASH_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	FLASH_ACR_DCRST = 0x1000
	// Data cache is not reset
	FLASH_ACR_DCRST_NotReset = 0x0
	// Data cache is reset
	FLASH_ACR_DCRST_Reset = 0x1

	// KEYR: Flash key register
	// Position of KEY field.
	FLASH_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	FLASH_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	FLASH_SR_EOP_Msk = 0x1
	// Bit EOP.
	FLASH_SR_EOP = 0x1
	// Position of OPERR field.
	FLASH_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	FLASH_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	FLASH_SR_OPERR = 0x2
	// Position of WRPERR field.
	FLASH_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	FLASH_SR_WRPERR = 0x10
	// Position of PGAERR field.
	FLASH_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	FLASH_SR_PGAERR = 0x20
	// Position of PGPERR field.
	FLASH_SR_PGPERR_Pos = 0x6
	// Bit mask of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40
	// Bit PGPERR.
	FLASH_SR_PGPERR = 0x40
	// Position of PGSERR field.
	FLASH_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	FLASH_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	FLASH_SR_PGSERR = 0x80
	// Position of BSY field.
	FLASH_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	FLASH_SR_BSY_Msk = 0x10000
	// Bit BSY.
	FLASH_SR_BSY = 0x10000

	// CR: Control register
	// Position of PG field.
	FLASH_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	FLASH_CR_PG_Msk = 0x1
	// Bit PG.
	FLASH_CR_PG = 0x1
	// Flash programming activated
	FLASH_CR_PG_Program = 0x1
	// Position of SER field.
	FLASH_CR_SER_Pos = 0x1
	// Bit mask of SER field.
	FLASH_CR_SER_Msk = 0x2
	// Bit SER.
	FLASH_CR_SER = 0x2
	// Erase activated for selected sector
	FLASH_CR_SER_SectorErase = 0x1
	// Position of MER field.
	FLASH_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	FLASH_CR_MER_Msk = 0x4
	// Bit MER.
	FLASH_CR_MER = 0x4
	// Erase activated for all user sectors
	FLASH_CR_MER_MassErase = 0x1
	// Position of SNB field.
	FLASH_CR_SNB_Pos = 0x3
	// Bit mask of SNB field.
	FLASH_CR_SNB_Msk = 0x78
	// Position of PSIZE field.
	FLASH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300
	// Program x8
	FLASH_CR_PSIZE_PSIZE8 = 0x0
	// Program x16
	FLASH_CR_PSIZE_PSIZE16 = 0x1
	// Program x32
	FLASH_CR_PSIZE_PSIZE32 = 0x2
	// Program x64
	FLASH_CR_PSIZE_PSIZE64 = 0x3
	// Position of STRT field.
	FLASH_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	FLASH_CR_STRT_Msk = 0x10000
	// Bit STRT.
	FLASH_CR_STRT = 0x10000
	// Trigger an erase operation
	FLASH_CR_STRT_Start = 0x1
	// Position of EOPIE field.
	FLASH_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	FLASH_CR_EOPIE = 0x1000000
	// End of operation interrupt disabled
	FLASH_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	FLASH_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	FLASH_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	FLASH_CR_ERRIE = 0x2000000
	// Error interrupt generation disabled
	FLASH_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	FLASH_CR_ERRIE_Enabled = 0x1
	// Position of LOCK field.
	FLASH_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	FLASH_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	FLASH_CR_LOCK = 0x80000000
	// FLASH_CR register is unlocked
	FLASH_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	FLASH_CR_LOCK_Locked = 0x1

	// OPTCR: Flash option control register
	// Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Pos = 0x0
	// Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk = 0x1
	// Bit OPTLOCK.
	FLASH_OPTCR_OPTLOCK = 0x1
	// Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Pos = 0x1
	// Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk = 0x2
	// Bit OPTSTRT.
	FLASH_OPTCR_OPTSTRT = 0x2
	// Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Pos = 0x2
	// Bit mask of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk = 0xc
	// Position of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Pos = 0x5
	// Bit mask of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Msk = 0x20
	// Bit WDG_SW.
	FLASH_OPTCR_WDG_SW = 0x20
	// Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Pos = 0x6
	// Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk = 0x40
	// Bit NRST_STOP.
	FLASH_OPTCR_NRST_STOP = 0x40
	// Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7
	// Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80
	// Bit NRST_STDBY.
	FLASH_OPTCR_NRST_STDBY = 0x80
	// Position of RDP field.
	FLASH_OPTCR_RDP_Pos = 0x8
	// Bit mask of RDP field.
	FLASH_OPTCR_RDP_Msk = 0xff00
	// Position of NWRP field.
	FLASH_OPTCR_NWRP_Pos = 0x10
	// Bit mask of NWRP field.
	FLASH_OPTCR_NWRP_Msk = 0xfff0000
)

// Constants for GPIOF: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
)

// Constants for LPTIM: Low power timer
const (
	// ISR: Interrupt and Status Register
	// Position of DOWN field.
	LPTIM_ISR_DOWN_Pos = 0x6
	// Bit mask of DOWN field.
	LPTIM_ISR_DOWN_Msk = 0x40
	// Bit DOWN.
	LPTIM_ISR_DOWN = 0x40
	// Position of UP field.
	LPTIM_ISR_UP_Pos = 0x5
	// Bit mask of UP field.
	LPTIM_ISR_UP_Msk = 0x20
	// Bit UP.
	LPTIM_ISR_UP = 0x20
	// Position of ARROK field.
	LPTIM_ISR_ARROK_Pos = 0x4
	// Bit mask of ARROK field.
	LPTIM_ISR_ARROK_Msk = 0x10
	// Bit ARROK.
	LPTIM_ISR_ARROK = 0x10
	// Position of CMPOK field.
	LPTIM_ISR_CMPOK_Pos = 0x3
	// Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK_Msk = 0x8
	// Bit CMPOK.
	LPTIM_ISR_CMPOK = 0x8
	// Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Pos = 0x2
	// Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4
	// Bit EXTTRIG.
	LPTIM_ISR_EXTTRIG = 0x4
	// Position of ARRM field.
	LPTIM_ISR_ARRM_Pos = 0x1
	// Bit mask of ARRM field.
	LPTIM_ISR_ARRM_Msk = 0x2
	// Bit ARRM.
	LPTIM_ISR_ARRM = 0x2
	// Position of CMPM field.
	LPTIM_ISR_CMPM_Pos = 0x0
	// Bit mask of CMPM field.
	LPTIM_ISR_CMPM_Msk = 0x1
	// Bit CMPM.
	LPTIM_ISR_CMPM = 0x1

	// ICR: Interrupt Clear Register
	// Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Pos = 0x6
	// Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk = 0x40
	// Bit DOWNCF.
	LPTIM_ICR_DOWNCF = 0x40
	// Position of UPCF field.
	LPTIM_ICR_UPCF_Pos = 0x5
	// Bit mask of UPCF field.
	LPTIM_ICR_UPCF_Msk = 0x20
	// Bit UPCF.
	LPTIM_ICR_UPCF = 0x20
	// Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Pos = 0x4
	// Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk = 0x10
	// Bit ARROKCF.
	LPTIM_ICR_ARROKCF = 0x10
	// Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Pos = 0x3
	// Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk = 0x8
	// Bit CMPOKCF.
	LPTIM_ICR_CMPOKCF = 0x8
	// Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2
	// Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4
	// Bit EXTTRIGCF.
	LPTIM_ICR_EXTTRIGCF = 0x4
	// Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Pos = 0x1
	// Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk = 0x2
	// Bit ARRMCF.
	LPTIM_ICR_ARRMCF = 0x2
	// Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Pos = 0x0
	// Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk = 0x1
	// Bit CMPMCF.
	LPTIM_ICR_CMPMCF = 0x1

	// IER: Interrupt Enable Register
	// Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Pos = 0x6
	// Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk = 0x40
	// Bit DOWNIE.
	LPTIM_IER_DOWNIE = 0x40
	// Position of UPIE field.
	LPTIM_IER_UPIE_Pos = 0x5
	// Bit mask of UPIE field.
	LPTIM_IER_UPIE_Msk = 0x20
	// Bit UPIE.
	LPTIM_IER_UPIE = 0x20
	// Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Pos = 0x4
	// Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk = 0x10
	// Bit ARROKIE.
	LPTIM_IER_ARROKIE = 0x10
	// Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Pos = 0x3
	// Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk = 0x8
	// Bit CMPOKIE.
	LPTIM_IER_CMPOKIE = 0x8
	// Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2
	// Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4
	// Bit EXTTRIGIE.
	LPTIM_IER_EXTTRIGIE = 0x4
	// Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Pos = 0x1
	// Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk = 0x2
	// Bit ARRMIE.
	LPTIM_IER_ARRMIE = 0x2
	// Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Pos = 0x0
	// Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk = 0x1
	// Bit CMPMIE.
	LPTIM_IER_CMPMIE = 0x1

	// CFGR: Configuration Register
	// Position of ENC field.
	LPTIM_CFGR_ENC_Pos = 0x18
	// Bit mask of ENC field.
	LPTIM_CFGR_ENC_Msk = 0x1000000
	// Bit ENC.
	LPTIM_CFGR_ENC = 0x1000000
	// Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17
	// Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000
	// Bit COUNTMODE.
	LPTIM_CFGR_COUNTMODE = 0x800000
	// Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Pos = 0x16
	// Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk = 0x400000
	// Bit PRELOAD.
	LPTIM_CFGR_PRELOAD = 0x400000
	// Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Pos = 0x15
	// Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk = 0x200000
	// Bit WAVPOL.
	LPTIM_CFGR_WAVPOL = 0x200000
	// Position of WAVE field.
	LPTIM_CFGR_WAVE_Pos = 0x14
	// Bit mask of WAVE field.
	LPTIM_CFGR_WAVE_Msk = 0x100000
	// Bit WAVE.
	LPTIM_CFGR_WAVE = 0x100000
	// Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Pos = 0x13
	// Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk = 0x80000
	// Bit TIMOUT.
	LPTIM_CFGR_TIMOUT = 0x80000
	// Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Pos = 0x11
	// Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk = 0x60000
	// Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Pos = 0xd
	// Bit mask of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk = 0xe000
	// Position of PRESC field.
	LPTIM_CFGR_PRESC_Pos = 0x9
	// Bit mask of PRESC field.
	LPTIM_CFGR_PRESC_Msk = 0xe00
	// Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Pos = 0x6
	// Bit mask of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk = 0xc0
	// Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Pos = 0x3
	// Bit mask of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk = 0x18
	// Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Pos = 0x1
	// Bit mask of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk = 0x6
	// Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk = 0x1
	// Bit CKSEL.
	LPTIM_CFGR_CKSEL = 0x1

	// CR: Control Register
	// Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Pos = 0x2
	// Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4
	// Bit CNTSTRT.
	LPTIM_CR_CNTSTRT = 0x4
	// Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Pos = 0x1
	// Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2
	// Bit SNGSTRT.
	LPTIM_CR_SNGSTRT = 0x2
	// Position of ENABLE field.
	LPTIM_CR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	LPTIM_CR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	LPTIM_CR_ENABLE = 0x1

	// CMP: Compare Register
	// Position of CMP field.
	LPTIM_CMP_CMP_Pos = 0x0
	// Bit mask of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff

	// ARR: Autoreload Register
	// Position of ARR field.
	LPTIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff

	// CNT: Counter Register
	// Position of CNT field.
	LPTIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff
)

// Constants for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000

	// IPR18: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000

	// IPR19: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000
)

// Constants for PWR: Power control
const (
	// CR: power control register
	// Position of VOS field.
	PWR_CR_VOS_Pos = 0xe
	// Bit mask of VOS field.
	PWR_CR_VOS_Msk = 0xc000
	// Position of ADCDC1 field.
	PWR_CR_ADCDC1_Pos = 0xd
	// Bit mask of ADCDC1 field.
	PWR_CR_ADCDC1_Msk = 0x2000
	// Bit ADCDC1.
	PWR_CR_ADCDC1 = 0x2000
	// Position of FPDS field.
	PWR_CR_FPDS_Pos = 0x9
	// Bit mask of FPDS field.
	PWR_CR_FPDS_Msk = 0x200
	// Bit FPDS.
	PWR_CR_FPDS = 0x200
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1

	// CSR: power control/status register
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of BRR field.
	PWR_CSR_BRR_Pos = 0x3
	// Bit mask of BRR field.
	PWR_CSR_BRR_Msk = 0x8
	// Bit BRR.
	PWR_CSR_BRR = 0x8
	// Position of EWUP field.
	PWR_CSR_EWUP_Pos = 0x8
	// Bit mask of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100
	// Bit EWUP.
	PWR_CSR_EWUP = 0x100
	// Position of BRE field.
	PWR_CSR_BRE_Pos = 0x9
	// Bit mask of BRE field.
	PWR_CSR_BRE_Msk = 0x200
	// Bit BRE.
	PWR_CSR_BRE = 0x200
	// Position of VOSRDY field.
	PWR_CSR_VOSRDY_Pos = 0xe
	// Bit mask of VOSRDY field.
	PWR_CSR_VOSRDY_Msk = 0x4000
	// Bit VOSRDY.
	PWR_CSR_VOSRDY = 0x4000
)

// Constants for QUADSPI: QuadSPI interface
const (
	// CR: control register
	// Position of PRESCALER field.
	QUADSPI_CR_PRESCALER_Pos = 0x18
	// Bit mask of PRESCALER field.
	QUADSPI_CR_PRESCALER_Msk = 0xff000000
	// Position of PMM field.
	QUADSPI_CR_PMM_Pos = 0x17
	// Bit mask of PMM field.
	QUADSPI_CR_PMM_Msk = 0x800000
	// Bit PMM.
	QUADSPI_CR_PMM = 0x800000
	// Position of APMS field.
	QUADSPI_CR_APMS_Pos = 0x16
	// Bit mask of APMS field.
	QUADSPI_CR_APMS_Msk = 0x400000
	// Bit APMS.
	QUADSPI_CR_APMS = 0x400000
	// Position of TOIE field.
	QUADSPI_CR_TOIE_Pos = 0x14
	// Bit mask of TOIE field.
	QUADSPI_CR_TOIE_Msk = 0x100000
	// Bit TOIE.
	QUADSPI_CR_TOIE = 0x100000
	// Position of SMIE field.
	QUADSPI_CR_SMIE_Pos = 0x13
	// Bit mask of SMIE field.
	QUADSPI_CR_SMIE_Msk = 0x80000
	// Bit SMIE.
	QUADSPI_CR_SMIE = 0x80000
	// Position of FTIE field.
	QUADSPI_CR_FTIE_Pos = 0x12
	// Bit mask of FTIE field.
	QUADSPI_CR_FTIE_Msk = 0x40000
	// Bit FTIE.
	QUADSPI_CR_FTIE = 0x40000
	// Position of TCIE field.
	QUADSPI_CR_TCIE_Pos = 0x11
	// Bit mask of TCIE field.
	QUADSPI_CR_TCIE_Msk = 0x20000
	// Bit TCIE.
	QUADSPI_CR_TCIE = 0x20000
	// Position of TEIE field.
	QUADSPI_CR_TEIE_Pos = 0x10
	// Bit mask of TEIE field.
	QUADSPI_CR_TEIE_Msk = 0x10000
	// Bit TEIE.
	QUADSPI_CR_TEIE = 0x10000
	// Position of FTHRES field.
	QUADSPI_CR_FTHRES_Pos = 0x8
	// Bit mask of FTHRES field.
	QUADSPI_CR_FTHRES_Msk = 0x1f00
	// Position of FSEL field.
	QUADSPI_CR_FSEL_Pos = 0x7
	// Bit mask of FSEL field.
	QUADSPI_CR_FSEL_Msk = 0x80
	// Bit FSEL.
	QUADSPI_CR_FSEL = 0x80
	// Position of DFM field.
	QUADSPI_CR_DFM_Pos = 0x6
	// Bit mask of DFM field.
	QUADSPI_CR_DFM_Msk = 0x40
	// Bit DFM.
	QUADSPI_CR_DFM = 0x40
	// Position of SSHIFT field.
	QUADSPI_CR_SSHIFT_Pos = 0x4
	// Bit mask of SSHIFT field.
	QUADSPI_CR_SSHIFT_Msk = 0x10
	// Bit SSHIFT.
	QUADSPI_CR_SSHIFT = 0x10
	// Position of TCEN field.
	QUADSPI_CR_TCEN_Pos = 0x3
	// Bit mask of TCEN field.
	QUADSPI_CR_TCEN_Msk = 0x8
	// Bit TCEN.
	QUADSPI_CR_TCEN = 0x8
	// Position of DMAEN field.
	QUADSPI_CR_DMAEN_Pos = 0x2
	// Bit mask of DMAEN field.
	QUADSPI_CR_DMAEN_Msk = 0x4
	// Bit DMAEN.
	QUADSPI_CR_DMAEN = 0x4
	// Position of ABORT field.
	QUADSPI_CR_ABORT_Pos = 0x1
	// Bit mask of ABORT field.
	QUADSPI_CR_ABORT_Msk = 0x2
	// Bit ABORT.
	QUADSPI_CR_ABORT = 0x2
	// Position of EN field.
	QUADSPI_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	QUADSPI_CR_EN_Msk = 0x1
	// Bit EN.
	QUADSPI_CR_EN = 0x1

	// DCR: device configuration register
	// Position of FSIZE field.
	QUADSPI_DCR_FSIZE_Pos = 0x10
	// Bit mask of FSIZE field.
	QUADSPI_DCR_FSIZE_Msk = 0x1f0000
	// Position of CSHT field.
	QUADSPI_DCR_CSHT_Pos = 0x8
	// Bit mask of CSHT field.
	QUADSPI_DCR_CSHT_Msk = 0x700
	// Position of CKMODE field.
	QUADSPI_DCR_CKMODE_Pos = 0x0
	// Bit mask of CKMODE field.
	QUADSPI_DCR_CKMODE_Msk = 0x1
	// Bit CKMODE.
	QUADSPI_DCR_CKMODE = 0x1

	// SR: status register
	// Position of FLEVEL field.
	QUADSPI_SR_FLEVEL_Pos = 0x8
	// Bit mask of FLEVEL field.
	QUADSPI_SR_FLEVEL_Msk = 0x7f00
	// Position of BUSY field.
	QUADSPI_SR_BUSY_Pos = 0x5
	// Bit mask of BUSY field.
	QUADSPI_SR_BUSY_Msk = 0x20
	// Bit BUSY.
	QUADSPI_SR_BUSY = 0x20
	// Position of TOF field.
	QUADSPI_SR_TOF_Pos = 0x4
	// Bit mask of TOF field.
	QUADSPI_SR_TOF_Msk = 0x10
	// Bit TOF.
	QUADSPI_SR_TOF = 0x10
	// Position of SMF field.
	QUADSPI_SR_SMF_Pos = 0x3
	// Bit mask of SMF field.
	QUADSPI_SR_SMF_Msk = 0x8
	// Bit SMF.
	QUADSPI_SR_SMF = 0x8
	// Position of FTF field.
	QUADSPI_SR_FTF_Pos = 0x2
	// Bit mask of FTF field.
	QUADSPI_SR_FTF_Msk = 0x4
	// Bit FTF.
	QUADSPI_SR_FTF = 0x4
	// Position of TCF field.
	QUADSPI_SR_TCF_Pos = 0x1
	// Bit mask of TCF field.
	QUADSPI_SR_TCF_Msk = 0x2
	// Bit TCF.
	QUADSPI_SR_TCF = 0x2
	// Position of TEF field.
	QUADSPI_SR_TEF_Pos = 0x0
	// Bit mask of TEF field.
	QUADSPI_SR_TEF_Msk = 0x1
	// Bit TEF.
	QUADSPI_SR_TEF = 0x1

	// FCR: flag clear register
	// Position of CTOF field.
	QUADSPI_FCR_CTOF_Pos = 0x4
	// Bit mask of CTOF field.
	QUADSPI_FCR_CTOF_Msk = 0x10
	// Bit CTOF.
	QUADSPI_FCR_CTOF = 0x10
	// Position of CSMF field.
	QUADSPI_FCR_CSMF_Pos = 0x3
	// Bit mask of CSMF field.
	QUADSPI_FCR_CSMF_Msk = 0x8
	// Bit CSMF.
	QUADSPI_FCR_CSMF = 0x8
	// Position of CTCF field.
	QUADSPI_FCR_CTCF_Pos = 0x1
	// Bit mask of CTCF field.
	QUADSPI_FCR_CTCF_Msk = 0x2
	// Bit CTCF.
	QUADSPI_FCR_CTCF = 0x2
	// Position of CTEF field.
	QUADSPI_FCR_CTEF_Pos = 0x0
	// Bit mask of CTEF field.
	QUADSPI_FCR_CTEF_Msk = 0x1
	// Bit CTEF.
	QUADSPI_FCR_CTEF = 0x1

	// DLR: data length register
	// Position of DL field.
	QUADSPI_DLR_DL_Pos = 0x0
	// Bit mask of DL field.
	QUADSPI_DLR_DL_Msk = 0xffffffff

	// CCR: communication configuration register
	// Position of DDRM field.
	QUADSPI_CCR_DDRM_Pos = 0x1f
	// Bit mask of DDRM field.
	QUADSPI_CCR_DDRM_Msk = 0x80000000
	// Bit DDRM.
	QUADSPI_CCR_DDRM = 0x80000000
	// Position of DHHC field.
	QUADSPI_CCR_DHHC_Pos = 0x1e
	// Bit mask of DHHC field.
	QUADSPI_CCR_DHHC_Msk = 0x40000000
	// Bit DHHC.
	QUADSPI_CCR_DHHC = 0x40000000
	// Position of SIOO field.
	QUADSPI_CCR_SIOO_Pos = 0x1c
	// Bit mask of SIOO field.
	QUADSPI_CCR_SIOO_Msk = 0x10000000
	// Bit SIOO.
	QUADSPI_CCR_SIOO = 0x10000000
	// Position of FMODE field.
	QUADSPI_CCR_FMODE_Pos = 0x1a
	// Bit mask of FMODE field.
	QUADSPI_CCR_FMODE_Msk = 0xc000000
	// Position of DMODE field.
	QUADSPI_CCR_DMODE_Pos = 0x18
	// Bit mask of DMODE field.
	QUADSPI_CCR_DMODE_Msk = 0x3000000
	// Position of DCYC field.
	QUADSPI_CCR_DCYC_Pos = 0x12
	// Bit mask of DCYC field.
	QUADSPI_CCR_DCYC_Msk = 0x7c0000
	// Position of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Pos = 0x10
	// Bit mask of ABSIZE field.
	QUADSPI_CCR_ABSIZE_Msk = 0x30000
	// Position of ABMODE field.
	QUADSPI_CCR_ABMODE_Pos = 0xe
	// Bit mask of ABMODE field.
	QUADSPI_CCR_ABMODE_Msk = 0xc000
	// Position of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Pos = 0xc
	// Bit mask of ADSIZE field.
	QUADSPI_CCR_ADSIZE_Msk = 0x3000
	// Position of ADMODE field.
	QUADSPI_CCR_ADMODE_Pos = 0xa
	// Bit mask of ADMODE field.
	QUADSPI_CCR_ADMODE_Msk = 0xc00
	// Position of IMODE field.
	QUADSPI_CCR_IMODE_Pos = 0x8
	// Bit mask of IMODE field.
	QUADSPI_CCR_IMODE_Msk = 0x300
	// Position of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Pos = 0x0
	// Bit mask of INSTRUCTION field.
	QUADSPI_CCR_INSTRUCTION_Msk = 0xff

	// AR: address register
	// Position of ADDRESS field.
	QUADSPI_AR_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	QUADSPI_AR_ADDRESS_Msk = 0xffffffff

	// ABR: ABR
	// Position of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Pos = 0x0
	// Bit mask of ALTERNATE field.
	QUADSPI_ABR_ALTERNATE_Msk = 0xffffffff

	// DR: data register
	// Position of DATA field.
	QUADSPI_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	QUADSPI_DR_DATA_Msk = 0xffffffff

	// PSMKR: polling status mask register
	// Position of MASK field.
	QUADSPI_PSMKR_MASK_Pos = 0x0
	// Bit mask of MASK field.
	QUADSPI_PSMKR_MASK_Msk = 0xffffffff

	// PSMAR: polling status match register
	// Position of MATCH field.
	QUADSPI_PSMAR_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	QUADSPI_PSMAR_MATCH_Msk = 0xffffffff

	// PIR: polling interval register
	// Position of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Pos = 0x0
	// Bit mask of INTERVAL field.
	QUADSPI_PIR_INTERVAL_Msk = 0xffff

	// LPTR: low-power timeout register
	// Position of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	QUADSPI_LPTR_TIMEOUT_Msk = 0xffff
)

// Constants for RNG: Random number generator
const (
	// CR: control register
	// Position of IE field.
	RNG_CR_IE_Pos = 0x3
	// Bit mask of IE field.
	RNG_CR_IE_Msk = 0x8
	// Bit IE.
	RNG_CR_IE = 0x8
	// Position of RNGEN field.
	RNG_CR_RNGEN_Pos = 0x2
	// Bit mask of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4
	// Bit RNGEN.
	RNG_CR_RNGEN = 0x4

	// SR: status register
	// Position of SEIS field.
	RNG_SR_SEIS_Pos = 0x6
	// Bit mask of SEIS field.
	RNG_SR_SEIS_Msk = 0x40
	// Bit SEIS.
	RNG_SR_SEIS = 0x40
	// Position of CEIS field.
	RNG_SR_CEIS_Pos = 0x5
	// Bit mask of CEIS field.
	RNG_SR_CEIS_Msk = 0x20
	// Bit CEIS.
	RNG_SR_CEIS = 0x20
	// Position of SECS field.
	RNG_SR_SECS_Pos = 0x2
	// Bit mask of SECS field.
	RNG_SR_SECS_Msk = 0x4
	// Bit SECS.
	RNG_SR_SECS = 0x4
	// Position of CECS field.
	RNG_SR_CECS_Pos = 0x1
	// Bit mask of CECS field.
	RNG_SR_CECS_Msk = 0x2
	// Bit CECS.
	RNG_SR_CECS = 0x2
	// Position of DRDY field.
	RNG_SR_DRDY_Pos = 0x0
	// Bit mask of DRDY field.
	RNG_SR_DRDY_Msk = 0x1
	// Bit DRDY.
	RNG_SR_DRDY = 0x1

	// DR: data register
	// Position of RNDATA field.
	RNG_DR_RNDATA_Pos = 0x0
	// Bit mask of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff
)

// Constants for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of DCE field.
	RTC_CR_DCE_Pos = 0x7
	// Bit mask of DCE field.
	RTC_CR_DCE_Msk = 0x80
	// Bit DCE.
	RTC_CR_DCE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CALIBR: calibration register
	// Position of DCS field.
	RTC_CALIBR_DCS_Pos = 0x7
	// Bit mask of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80
	// Bit DCS.
	RTC_CALIBR_DCS = 0x80
	// Position of DC field.
	RTC_CALIBR_DC_Pos = 0x0
	// Bit mask of DC field.
	RTC_CALIBR_DC_Msk = 0x1f

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAFCR: tamper and alternate function configuration register
	// Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TAFCR_ALARMOUTTYPE = 0x40000
	// Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Pos = 0x11
	// Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk = 0x20000
	// Bit TSINSEL.
	RTC_TAFCR_TSINSEL = 0x20000
	// Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Pos = 0x10
	// Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk = 0x10000
	// Bit TAMP1INSEL.
	RTC_TAFCR_TAMP1INSEL = 0x10000
	// Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPUDIS = 0x8000
	// Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAFCR_TAMPTS = 0x80
	// Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAFCR_TAMP2TRG = 0x10
	// Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAFCR_TAMP2E = 0x8
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAFCR_TAMP1TRG = 0x2
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Constants for RCC: Reset and clock control
const (
	// CR: clock control register
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Pos = 0x1a
	// Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk = 0x4000000
	// Bit PLLI2SON.
	RCC_CR_PLLI2SON = 0x4000000
	// Clock Off
	RCC_CR_PLLI2SON_Off = 0x0
	// Clock On
	RCC_CR_PLLI2SON_On = 0x1
	// Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Pos = 0x1b
	// Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000
	// Bit PLLI2SRDY.
	RCC_CR_PLLI2SRDY = 0x8000000
	// Clock not ready
	RCC_CR_PLLI2SRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLI2SRDY_Ready = 0x1

	// PLLCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000
	// Bit PLLSRC.
	RCC_PLLCFGR_PLLSRC = 0x400000
	// HSI clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSI = 0x0
	// HSE oscillator clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSE = 0x1
	// Position of PLLR field.
	RCC_PLLCFGR_PLLR_Pos = 0x1c
	// Bit mask of PLLR field.
	RCC_PLLCFGR_PLLR_Msk = 0x70000000
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x0
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x3f
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x6
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7fc0
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x10
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x30000
	// PLLP=2
	RCC_PLLCFGR_PLLP_Div2 = 0x0
	// PLLP=4
	RCC_PLLCFGR_PLLP_Div4 = 0x1
	// PLLP=6
	RCC_PLLCFGR_PLLP_Div6 = 0x2
	// PLLP=8
	RCC_PLLCFGR_PLLP_Div8 = 0x3
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x18
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xf000000

	// CFGR: clock configuration register
	// Position of MCO2 field.
	RCC_CFGR_MCO2_Pos = 0x1e
	// Bit mask of MCO2 field.
	RCC_CFGR_MCO2_Msk = 0xc0000000
	// System clock (SYSCLK) selected
	RCC_CFGR_MCO2_SYSCLK = 0x0
	// PLLI2S clock selected
	RCC_CFGR_MCO2_PLLI2S = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO2_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO2_PLL = 0x3
	// Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b
	// Bit mask of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000
	// No division
	RCC_CFGR_MCO2PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO2PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO2PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO2PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO2PRE_Div5 = 0x7
	// Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18
	// Bit mask of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000
	// No division
	RCC_CFGR_MCO1PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO1PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO1PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO1PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO1PRE_Div5 = 0x7
	// Position of MCO1 field.
	RCC_CFGR_MCO1_Pos = 0x15
	// Bit mask of MCO1 field.
	RCC_CFGR_MCO1_Msk = 0x600000
	// HSI clock selected
	RCC_CFGR_MCO1_HSI = 0x0
	// LSE oscillator selected
	RCC_CFGR_MCO1_LSE = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO1_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO1_PLL = 0x3
	// Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Pos = 0x10
	// Bit mask of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk = 0x1f0000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xd
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0xe000
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0xa
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x1c00
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2

	// CIR: clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1
	// Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Pos = 0x15
	// Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk = 0x200000
	// Bit PLLI2SRDYC.
	RCC_CIR_PLLI2SRDYC = 0x200000
	// Clear interrupt flag
	RCC_CIR_PLLI2SRDYC_Clear = 0x1
	// Po