/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MVFilmSize
implements Comparable<MVFilmSize> {
    private long aktSizeL = -1L;
    private Long sizeL = 0L;
    private static final Logger logger = LogManager.getLogger(MVFilmSize.class);

    public static String getGroesse(long l) {
        String ret = "";
        if (l > 1000000L) {
            ret = String.valueOf(l / 1000000L);
        } else if (l > 0L) {
            ret = "1";
        }
        return ret;
    }

    @Override
    public int compareTo(@NotNull MVFilmSize ll) {
        return this.sizeL.compareTo(ll.sizeL);
    }

    public String toString() {
        return this.prepareString();
    }

    public void reset() {
        this.aktSizeL = -1L;
    }

    public long getSize() {
        return this.sizeL;
    }

    public void setSize(String size) {
        if (size.isEmpty()) {
            this.aktSizeL = -1L;
            this.sizeL = 0L;
        } else {
            try {
                this.sizeL = Long.parseLong(size) * 1000000L;
            }
            catch (Exception ex) {
                logger.error("string: {}, ex: {}", (Object)size, (Object)ex);
                this.sizeL = 0L;
            }
        }
    }

    public void setSize(long l) {
        this.sizeL = l;
    }

    public void addAktSize(long l) {
        this.aktSizeL += l;
    }

    public long getAktSize() {
        return this.aktSizeL;
    }

    public void setAktSize(long l) {
        this.aktSizeL = l;
    }

    private String prepareString() {
        Object sizeStr = this.aktSizeL <= 0L ? (this.sizeL > 0L ? MVFilmSize.getGroesse(this.sizeL) : "") : (this.sizeL > 0L ? MVFilmSize.getGroesse(this.aktSizeL) + " von " + MVFilmSize.getGroesse(this.sizeL) : MVFilmSize.getGroesse(this.aktSizeL));
        return sizeStr;
    }
}

