/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Icons;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilenameUtils;
import mediathek.tool.Log;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;

public class DialogAddMoreDownload
extends JDialog {
    public boolean addAll = false;
    public boolean cancel = false;
    public boolean info;
    public boolean subtitle;
    private final JFrame parent;
    private final DatenPset pSet;
    private final String orgPfad;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private JButton btnCancel;
    private JButton btnChange;
    private JButton btnOk;
    private JCheckBox chkInfo;
    private JCheckBox chkStart;
    private JCheckBox chkSubtitle;
    private JButton jButtonDelPath;
    private JButton jButtonPath;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JComboBox<String> jComboBoxPath;

    public DialogAddMoreDownload(JFrame parent, DatenPset pSet) {
        super((Frame)parent, true);
        this.parent = parent;
        this.pSet = pSet;
        this.initComponents();
        this.setTitle("Alle Downloads starten");
        this.chkSubtitle.setSelected(Boolean.parseBoolean(pSet.arr[21]));
        this.subtitle = this.chkSubtitle.isSelected();
        this.chkSubtitle.addActionListener(l -> {
            this.subtitle = this.chkSubtitle.isSelected();
        });
        this.chkInfo.setSelected(Boolean.parseBoolean(pSet.arr[19]));
        this.info = this.chkInfo.isSelected();
        this.chkInfo.addActionListener(l -> {
            this.info = this.chkInfo.isSelected();
        });
        this.chkStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN)));
        this.chkStart.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN, String.valueOf(this.chkStart.isSelected())));
        this.jCheckBoxPfadSpeichern.setSelected(this.config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(e -> this.config.setProperty("download.path.last_used.show", this.jCheckBoxPfadSpeichern.isSelected()));
        this.btnChange.addActionListener(l -> this.beenden());
        this.btnOk.addActionListener(e -> {
            this.addAll = true;
            this.beenden();
        });
        this.btnCancel.addActionListener(l -> {
            this.cancel = true;
            this.beenden();
        });
        this.jButtonPath.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonDelPath.setIcon(Icons.ICON_BUTTON_DEL);
        this.jButtonPath.addActionListener(new ZielBeobachter());
        this.jButtonDelPath.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{pSet.getZielPfad()}));
        });
        DialogAddDownload.setModelPfad(pSet.getZielPfad(), this.jComboBoxPath);
        this.orgPfad = pSet.getZielPfad();
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                String s2 = ((JTextComponent)DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent()).getText();
                if (!s2.equals(FilenameUtils.checkDateiname(s2, true))) {
                    DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(Color.WHITE);
                }
            }
        });
        EscapeKeyHandler.installHandler(this, this::beenden);
        this.pack();
    }

    public String getPath() {
        String path = this.jComboBoxPath.getModel().getSelectedItem().toString();
        if (path.isEmpty()) {
            path = this.pSet.getZielPfad();
        }
        return path;
    }

    private void beenden() {
        DialogAddDownload.saveComboPfad(this.jComboBoxPath, this.orgPfad);
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanelExtra = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.chkInfo = new JCheckBox();
        this.chkSubtitle = new JCheckBox();
        this.jComboBoxPath = new JComboBox();
        this.jButtonDelPath = new JButton();
        this.jButtonPath = new JButton();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.btnOk = new JButton();
        this.btnChange = new JButton();
        this.chkStart = new JCheckBox();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        jLabel1.setText("Speicherpfad:");
        this.chkInfo.setText("Infodatei anlegen: \"Filmname.txt\"");
        this.chkSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        this.jComboBoxPath.setEditable(true);
        this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonDelPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        GroupLayout jPanelExtraLayout = new GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.chkSubtitle).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelExtraLayout.createSequentialGroup().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.chkInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxPfadSpeichern)).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jComboBoxPath, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelPath))).addContainerGap()))));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jComboBoxPath, -2, -1, -2).addComponent(this.jButtonDelPath).addComponent(this.jButtonPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkInfo).addComponent(this.jCheckBoxPfadSpeichern)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkSubtitle).addContainerGap(49, Short.MAX_VALUE)));
        this.btnOk.setText("OK");
        this.btnChange.setText("\u00c4ndern");
        this.chkStart.setText("Download sofort starten");
        this.btnCancel.setText("Abbrechen");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanelExtra, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.chkStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 104, Short.MAX_VALUE).addComponent(this.btnChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel))).addContainerGap()));
        layout.linkSize(0, this.btnCancel, this.btnChange, this.btnOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanelExtra, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnChange).addComponent(this.chkStart).addComponent(this.btnCancel)).addContainerGap()));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)DialogAddMoreDownload.this.parent, "Film speichern");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        String path = chooser.getDirectory() + chooser.getFile();
                        DialogAddMoreDownload.this.jComboBoxPath.addItem(path);
                        DialogAddMoreDownload.this.jComboBoxPath.setSelectedItem(path);
                    }
                    catch (Exception ex) {
                        Log.errorLog(356871087, ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogAddMoreDownload.this.jComboBoxPath.getSelectedItem().toString().isEmpty()) {
                    chooser.setCurrentDirectory(new File(DialogAddMoreDownload.this.jComboBoxPath.getSelectedItem().toString()));
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        String absolutePath = chooser.getSelectedFile().getAbsolutePath();
                        DialogAddMoreDownload.this.jComboBoxPath.addItem(absolutePath);
                        DialogAddMoreDownload.this.jComboBoxPath.setSelectedItem(absolutePath);
                    }
                    catch (Exception ex) {
                        Log.errorLog(356871087, ex);
                    }
                }
            }
        }
    }
}

