# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class WindowToImageFilter(Algorithm):
    """
    WindowToImageFilter - Use a Window as input to image pipeline
    
    Superclass: Algorithm
    
    WindowToImageFilter provides methods needed to read the data in a
    Window and use it as input to the imaging pipeline. This is useful
    for saving an image to a file for example. The window can be read as
    either RGB or RGBA pixels;  in addition, the depth buffer can also be
    read.   RGB and RGBA pixels are of type unsigned char, while Z-Buffer
    data is returned as floats.  Use this filter to convert render_windows
    or image_windows to an image format.
    
    @warning
    A Window doesn't behave like other parts of the VTK pipeline: its
    modification time doesn't get updated when an image is rendered.  As
    a result, naive use of WindowToImageFilter will produce an image
    of the first image that the window rendered, but which is never
    updated on subsequent window updates.  This behavior is unexpected
    and in general undesirable.
    
    @warning
    To force an update of the output image, call WindowToImageFilter's
    Modified method after rendering to the window.
    
    @warning
    In VTK versions 4 and later, this filter is part of the canonical way
    to output an image of a window to a file (replacing the obsolete
    save_image_as_ppm method for RenderWindows that existed in 3.2 and
    earlier).  Connect this filter to the output of the window, and
    filter's output to a writer such as PNGWriter.
    
    @warning
    Reading back alpha planes is dependent on the correct operation of
    the render window's get_rgba_char_pixel_data method, which in turn is
    dependent on the configuration of the window's alpha planes.  As of
    VTK 4.4+, machine-independent behavior is not automatically assured
    because of these dependencies.
    
    @sa
    RendererSource RendererPointCloudSource Window
    RenderLargeImage
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWindowToImageFilter, obj, update, **traits)
    
    fix_boundary = tvtk_base.false_bool_trait(desc=\
        """
        When scale factor > 1, this class render the full image in tiles.
        Sometimes that results in artificial artifacts at internal tile
        seams. To overcome this issue, set this flag to true.
        """
    )

    def _fix_boundary_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFixBoundary,
                        self.fix_boundary_)

    read_front_buffer = tvtk_base.true_bool_trait(desc=\
        """
        Set/Get the flag that determines which buffer to read from. The
        default is to read from the front buffer.
        """
    )

    def _read_front_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadFrontBuffer,
                        self.read_front_buffer_)

    should_rerender = tvtk_base.true_bool_trait(desc=\
        """
        Set/get whether to re-render the input window. Initial value is
        true. (This option makes no difference if scale factor > 1.)
        """
    )

    def _should_rerender_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShouldRerender,
                        self.should_rerender_)

    input_buffer_type = tvtk_base.RevPrefixMap({'rgb': 3, 'rgba': 4, 'z_buffer': 5}, default_value='rgb', desc=\
        """
        Set/get the window buffer from which data will be read.  Choices
        include VTK_RGB (read the color image from the window), VTK_RGBA
        (same, but include the alpha channel), and VTK_ZBUFFER (depth
        buffer, returned as a float array). Initial value is VTK_RGB.
        """
    )

    def _input_buffer_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputBufferType,
                        self.input_buffer_type_)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        """
        Returns which renderer is being used as the source for the pixel
        data. Initial value is 0.
        """
    )

    scale = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(1, 1), cols=2, desc=\
        """
        
        """
    )

    def _scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScale,
                        self.scale)

    viewport = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 0.0, 1.0, 1.0), cols=3, desc=\
        """
        Set/get the extents to be used to generate the image. Initial
        value is {0,0,1,1} (This option does not work if scale factor >
        1.)
        """
    )

    def _viewport_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetViewport,
                        self.viewport)

    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    output = traits.Property(_get_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self):
        """
        V.get_output() -> ImageData
        C++: ImageData *GetOutput()
        Get the output data object for a port on this algorithm.
        """
        return wrap_vtk(self._vtk_obj.GetOutput())

    _updateable_traits_ = \
    (('fix_boundary', 'GetFixBoundary'), ('read_front_buffer',
    'GetReadFrontBuffer'), ('should_rerender', 'GetShouldRerender'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('input_buffer_type', 'GetInputBufferType'), ('scale', 'GetScale'),
    ('viewport', 'GetViewport'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'fix_boundary', 'global_warning_display',
    'read_front_buffer', 'release_data_flag', 'should_rerender',
    'input_buffer_type', 'progress_text', 'scale', 'viewport'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WindowToImageFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['fix_boundary', 'read_front_buffer', 'should_rerender'],
            ['input_buffer_type'], ['scale', 'viewport']),
            title='Edit WindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WindowToImageFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

