/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.HashingNameMapper$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.StringDigestUtil;

public class HashingNameMapper
implements NameMapper {
    private final NameMapper delegate;

    public HashingNameMapper(NameMapper delegate) {
        NameMapper nameMapper = delegate;
        nameMapper.getClass();
        this.delegate = nameMapper;
    }

    @Override
    public boolean isFileSystemFriendly() {
        return true;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        int depth = ConfigUtils.getInteger(session, 2, "aether.syncContext.named.hashing.depth");
        if (depth < 0 || depth > 4) {
            throw new IllegalArgumentException("allowed depth value is between 0 and 4 (inclusive)");
        }
        int n = depth;
        HashingNameMapper hashingNameMapper = this;
        return this.delegate.nameLocks(session, artifacts, metadatas).stream().map(new HashingNameMapper$$Lambda$0(hashingNameMapper, n)).collect(Collectors.toList());
    }

    private String hashName(String name, int depth) {
        String hashedName = StringDigestUtil.sha1(name);
        if (depth == 0) {
            return hashedName;
        }
        StringBuilder prefix = new StringBuilder("");
        for (int i = 0; i < hashedName.length() && i / 2 < depth; i += 2) {
            prefix.append(hashedName, i, i + 2).append("/");
        }
        return prefix.append(hashedName).toString();
    }

    private /* synthetic */ String lambda$nameLocks$0(int depth, String n) {
        return this.hashName(n, depth);
    }

    static /* synthetic */ String accessor$HashingNameMapper$lambda0(HashingNameMapper hashingNameMapper, int n, String string) {
        return hashingNameMapper.lambda$nameLocks$0(n, string);
    }
}

