/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.spi;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.OpenListener;
import org.xnio.IoUtils;

public final class SpiUtils {
    private static final Logger heLog = Logger.getLogger("org.jboss.remoting.handler-errors");

    private SpiUtils() {
    }

    public static <T> void safeHandleClose(CloseHandler<? super T> handler, T closed, IOException exception) {
        try {
            if (handler != null && closed != null) {
                handler.handleClose(closed, exception);
            }
        }
        catch (Throwable t) {
            heLog.error((Object)"Close handler threw an exception", t);
        }
    }

    public static CloseHandler<Object> closingCloseHandler(final Closeable c) {
        return new CloseHandler<Object>(){

            @Override
            public void handleClose(Object closed, IOException exception) {
                IoUtils.safeClose(c);
            }
        };
    }

    public static CloseHandler<Object> asyncClosingCloseHandler(final HandleableCloseable<?> c) {
        return new CloseHandler<Object>(){

            @Override
            public void handleClose(Object closed, IOException exception) {
                c.closeAsync();
            }
        };
    }

    public static void glueStackTraces(Throwable exception, StackTraceElement[] userStackTrace, int trimCount, String msg) {
        StackTraceElement[] est = exception.getStackTrace();
        StackTraceElement[] fst = Arrays.copyOf(est, est.length + userStackTrace.length - trimCount + 1);
        fst[est.length] = new StackTraceElement("..." + msg + "..", "", null, -1);
        System.arraycopy(userStackTrace, trimCount, fst, est.length + 1, userStackTrace.length - trimCount);
        exception.setStackTrace(fst);
    }

    public static Runnable getServiceOpenTask(Channel newChannel, OpenListener listener) {
        return new ServiceOpenTask(listener, newChannel);
    }

    static class ServiceOpenTask
    implements Runnable {
        private final OpenListener listener;
        private final Channel newChannel;

        public ServiceOpenTask(OpenListener listener, Channel newChannel) {
            this.listener = listener;
            this.newChannel = newChannel;
        }

        @Override
        public void run() {
            this.listener.channelOpened(this.newChannel);
        }
    }
}

