/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.naming.txn;

import java.util.Arrays;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;
import org.wildfly.transaction.client.LocalUserTransaction;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.RemoteUserTransaction;
import org.wildfly.transaction.client.naming.txn.ReadOnlyBinding;
import org.wildfly.transaction.client.naming.txn.ReadOnlyNameClassPair;

class TxnNamingContext
extends AbstractContext {
    private static final String TRANSACTION_MANAGER = "TransactionManager";
    private static final String USER_TRANSACTION = "UserTransaction";
    private static final String REMOTE_USER_TRANSACTION = "RemoteUserTransaction";
    private static final String LOCAL_USER_TRANSACTION = "LocalUserTransaction";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY = "TransactionSynchronizationRegistry";
    private final NamingProvider namingProvider;
    private final ProviderEnvironment providerEnvironment;
    private final RemoteUserTransaction remoteUserTransaction;

    TxnNamingContext(NamingProvider namingProvider, ProviderEnvironment providerEnvironment) {
        this.namingProvider = namingProvider;
        this.providerEnvironment = providerEnvironment;
        this.remoteUserTransaction = this.getRemoteUserTransaction();
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        String str;
        switch (str = name.get(0)) {
            case "UserTransaction": {
                if (this.namingProvider != null) {
                    return this.remoteUserTransaction;
                }
                return LocalUserTransaction.getInstance();
            }
            case "RemoteUserTransaction": {
                return this.remoteUserTransaction;
            }
            case "LocalUserTransaction": {
                return LocalUserTransaction.getInstance();
            }
            case "TransactionManager": {
                if (this.namingProvider != null) break;
                return ContextTransactionManager.getInstance();
            }
            case "TransactionSynchronizationRegistry": {
                if (this.namingProvider != null) break;
                return ContextTransactionSynchronizationRegistry.getInstance();
            }
        }
        throw TxnNamingContext.nameNotFound(name);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.lookupNative(name);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound(name);
        }
        return CloseableNamingEnumeration.fromIterable(Arrays.asList(this.nameClassPair(UserTransaction.class), this.nameClassPair(RemoteUserTransaction.class), this.nameClassPair(LocalUserTransaction.class), this.nameClassPair(TransactionManager.class), this.nameClassPair(TransactionSynchronizationRegistry.class)));
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw TxnNamingContext.nameNotFound(name);
        }
        return CloseableNamingEnumeration.fromIterable(Arrays.asList(this.binding(UserTransaction.class, this.namingProvider != null ? this.remoteUserTransaction : LocalUserTransaction.getInstance()), this.binding(RemoteUserTransaction.class, this.remoteUserTransaction), this.binding(LocalUserTransaction.class, LocalUserTransaction.getInstance()), this.binding(TransactionManager.class, ContextTransactionManager.getInstance()), this.binding(TransactionSynchronizationRegistry.class, ContextTransactionSynchronizationRegistry.getInstance())));
    }

    private NameClassPair nameClassPair(Class<?> clazz) {
        return new ReadOnlyNameClassPair(clazz.getSimpleName(), clazz.getName(), "txn:" + clazz.getSimpleName());
    }

    private <T> Binding binding(Class<T> clazz, T content) {
        return new ReadOnlyBinding(clazz.getSimpleName(), clazz.getName(), content, "txn:" + clazz.getSimpleName());
    }

    private RemoteUserTransaction getRemoteUserTransaction() {
        AuthenticationContext context = this.providerEnvironment.getAuthenticationContextSupplier().get();
        return context.runFunction(RemoteTransactionContext::getUserTransaction, RemoteTransactionContext.getInstance());
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }
}

